/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.symbolsolver.model.methods;

import com.github.javaparser.symbolsolver.model.declarations.MethodDeclaration;
import com.github.javaparser.symbolsolver.model.declarations.ReferenceTypeDeclaration;
import com.github.javaparser.symbolsolver.model.declarations.TypeParameterDeclaration;
import com.github.javaparser.symbolsolver.model.typesystem.Type;
import com.github.javaparser.symbolsolver.model.typesystem.parametrization.TypeParametersMap;
import com.github.javaparser.symbolsolver.model.typesystem.parametrization.TypeParametrized;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;

public class MethodUsage
implements TypeParametrized {
    private MethodDeclaration declaration;
    private List<Type> paramTypes = new ArrayList<Type>();
    private Type returnType;
    private TypeParametersMap typeParametersMap = TypeParametersMap.empty();

    public MethodUsage(MethodDeclaration declaration) {
        this.declaration = declaration;
        for (int i = 0; i < declaration.getNumberOfParams(); ++i) {
            this.paramTypes.add(declaration.getParam(i).getType());
        }
        this.returnType = declaration.getReturnType();
    }

    public MethodUsage(MethodDeclaration declaration, List<Type> paramTypes, Type returnType) {
        this.declaration = declaration;
        this.paramTypes = paramTypes;
        this.returnType = returnType;
    }

    public String toString() {
        return "MethodUsage{declaration=" + this.declaration + ", paramTypes=" + this.paramTypes + '}';
    }

    public MethodDeclaration getDeclaration() {
        return this.declaration;
    }

    public String getName() {
        return this.declaration.getName();
    }

    public ReferenceTypeDeclaration declaringType() {
        return this.declaration.declaringType();
    }

    public Type returnType() {
        return this.returnType;
    }

    public List<Type> getParamTypes() {
        return this.paramTypes;
    }

    public MethodUsage replaceParamType(int i, Type replaced) {
        if (this.paramTypes.get(i) == replaced) {
            return this;
        }
        LinkedList<Type> newParams = new LinkedList<Type>(this.paramTypes);
        newParams.set(i, replaced);
        return new MethodUsage(this.declaration, newParams, this.returnType);
    }

    public MethodUsage replaceReturnType(Type returnType) {
        if (returnType == this.returnType) {
            return this;
        }
        return new MethodUsage(this.declaration, this.paramTypes, returnType);
    }

    public int getNoParams() {
        return this.paramTypes.size();
    }

    public Type getParamType(int i) {
        return this.paramTypes.get(i);
    }

    public MethodUsage replaceTypeParameter(TypeParameterDeclaration typeParameter, Type type) {
        if (type == null) {
            throw new IllegalArgumentException();
        }
        MethodUsage res = this;
        HashMap<TypeParameterDeclaration, Type> inferredTypes = new HashMap<TypeParameterDeclaration, Type>();
        for (int i = 0; i < this.paramTypes.size(); ++i) {
            Type originalParamType = this.paramTypes.get(i);
            Type newParamType = originalParamType.replaceTypeVariables(typeParameter, type, inferredTypes);
            res = res.replaceParamType(i, newParamType);
        }
        Type oldReturnType = res.returnType;
        Type newReturnType = oldReturnType.replaceTypeVariables(typeParameter, type, inferredTypes);
        res = res.replaceReturnType(newReturnType);
        return res;
    }

    @Override
    public TypeParametersMap typeParametersMap() {
        return this.typeParametersMap;
    }

    public String getQualifiedSignature() {
        return this.getDeclaration().getQualifiedSignature();
    }
}

