/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.symbolsolver.model.typesystem;

import com.github.javaparser.symbolsolver.model.declarations.ReferenceTypeDeclaration;
import com.github.javaparser.symbolsolver.model.declarations.TypeParameterDeclaration;
import com.github.javaparser.symbolsolver.model.methods.MethodUsage;
import com.github.javaparser.symbolsolver.model.resolution.TypeSolver;
import com.github.javaparser.symbolsolver.model.typesystem.Type;
import com.github.javaparser.symbolsolver.model.typesystem.TypeTransformer;
import com.github.javaparser.symbolsolver.model.typesystem.TypeVariable;
import com.github.javaparser.symbolsolver.model.typesystem.Wildcard;
import com.github.javaparser.symbolsolver.model.typesystem.parametrization.TypeParameterValueProvider;
import com.github.javaparser.symbolsolver.model.typesystem.parametrization.TypeParametersMap;
import com.github.javaparser.symbolsolver.model.typesystem.parametrization.TypeParametrized;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javaslang.Tuple2;

public abstract class ReferenceType
implements Type,
TypeParametrized,
TypeParameterValueProvider {
    protected ReferenceTypeDeclaration typeDeclaration;
    protected TypeSolver typeSolver;
    protected TypeParametersMap typeParametersMap;

    public ReferenceType(ReferenceTypeDeclaration typeDeclaration, TypeSolver typeSolver) {
        this(typeDeclaration, ReferenceType.deriveParams(typeDeclaration), typeSolver);
    }

    public ReferenceType(ReferenceTypeDeclaration typeDeclaration, List<Type> typeParameters, TypeSolver typeSolver) {
        if (typeSolver == null) {
            throw new IllegalArgumentException("typeSolver should not be null");
        }
        if (typeDeclaration.isTypeParameter()) {
            throw new IllegalArgumentException("You should use only Classes, Interfaces and enums");
        }
        if (typeParameters.size() > 0 && typeParameters.size() != typeDeclaration.getTypeParameters().size()) {
            throw new IllegalArgumentException(String.format("expected either zero type parameters or has many as defined in the declaration (%d). Found %d", typeDeclaration.getTypeParameters().size(), typeParameters.size()));
        }
        TypeParametersMap.Builder typeParametersMapBuilder = new TypeParametersMap.Builder();
        for (int i = 0; i < typeParameters.size(); ++i) {
            typeParametersMapBuilder.setValue(typeDeclaration.getTypeParameters().get(i), typeParameters.get(i));
        }
        this.typeParametersMap = typeParametersMapBuilder.build();
        this.typeDeclaration = typeDeclaration;
        this.typeSolver = typeSolver;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReferenceType that = (ReferenceType)o;
        if (!this.typeDeclaration.equals(that.typeDeclaration)) {
            return false;
        }
        return this.typeParametersMap.equals(that.typeParametersMap);
    }

    public int hashCode() {
        int result = this.typeDeclaration.hashCode();
        result = 31 * result + this.typeParametersMap.hashCode();
        return result;
    }

    public String toString() {
        return "ReferenceType{" + this.getQualifiedName() + ", typeParametersMap=" + this.typeParametersMap + '}';
    }

    @Override
    public final boolean isReferenceType() {
        return true;
    }

    @Override
    public ReferenceType asReferenceType() {
        return this;
    }

    @Override
    public String describe() {
        StringBuilder sb = new StringBuilder();
        if (this.hasName()) {
            sb.append(this.typeDeclaration.getQualifiedName());
        } else {
            sb.append("<anonymous class>");
        }
        if (!this.typeParametersMap().isEmpty()) {
            sb.append("<");
            sb.append(String.join((CharSequence)", ", this.typeDeclaration.getTypeParameters().stream().map(tp -> this.typeParametersMap().getValue((TypeParameterDeclaration)tp).describe()).collect(Collectors.toList())));
            sb.append(">");
        }
        return sb.toString();
    }

    public Type transformTypeParameters(TypeTransformer transformer) {
        ReferenceType result = this;
        int i = 0;
        for (Type tp : this.typeParametersValues()) {
            Type transformedTp = transformer.transform(tp);
            if (transformedTp != tp) {
                List<Type> typeParametersCorrected = result.asReferenceType().typeParametersValues();
                typeParametersCorrected.set(i, transformedTp);
                result = this.create(this.typeDeclaration, typeParametersCorrected, this.typeSolver);
            }
            ++i;
        }
        return result;
    }

    @Override
    public Type replaceTypeVariables(TypeParameterDeclaration tpToReplace, Type replaced, Map<TypeParameterDeclaration, Type> inferredTypes) {
        if (replaced == null) {
            throw new IllegalArgumentException();
        }
        ReferenceType result = this;
        int i = 0;
        for (Type tp : this.typeParametersValues()) {
            Type transformedTp = tp.replaceTypeVariables(tpToReplace, replaced, inferredTypes);
            if (tp.isTypeVariable() && tp.asTypeVariable().describe().equals(tpToReplace.getName())) {
                inferredTypes.put(tp.asTypeParameter(), replaced);
            }
            List<Type> typeParametersCorrected = result.asReferenceType().typeParametersValues();
            typeParametersCorrected.set(i, transformedTp);
            result = this.create(this.typeDeclaration, typeParametersCorrected, this.typeSolver);
            ++i;
        }
        List<Type> values = result.typeParametersValues();
        if (values.contains(tpToReplace)) {
            int index = values.indexOf(tpToReplace);
            values.set(index, replaced);
            return this.create(result.getTypeDeclaration(), values, this.typeSolver);
        }
        return result;
    }

    @Override
    public abstract boolean isAssignableBy(Type var1);

    public List<ReferenceType> getAllAncestors() {
        List<ReferenceType> ancestors = this.typeDeclaration.getAllAncestors();
        ancestors = ancestors.stream().map(a -> this.typeParametersMap().replaceAll((Type)a).asReferenceType()).collect(Collectors.toList());
        ancestors.removeIf(a -> a.getQualifiedName().equals(Object.class.getCanonicalName()));
        ReferenceTypeDeclaration objectType = this.typeSolver.solveType(Object.class.getCanonicalName());
        ReferenceType objectRef = this.create(objectType, this.typeSolver);
        ancestors.add(objectRef);
        return ancestors;
    }

    public final List<ReferenceType> getAllInterfacesAncestors() {
        return this.getAllAncestors().stream().filter(it -> it.getTypeDeclaration().isInterface()).collect(Collectors.toList());
    }

    public final List<ReferenceType> getAllClassesAncestors() {
        return this.getAllAncestors().stream().filter(it -> it.getTypeDeclaration().isClass()).collect(Collectors.toList());
    }

    @Override
    public Optional<Type> getGenericParameterByName(String name) {
        for (TypeParameterDeclaration tp : this.typeDeclaration.getTypeParameters()) {
            if (!tp.getName().equals(name)) continue;
            return Optional.of(this.typeParametersMap().getValue(tp));
        }
        return Optional.empty();
    }

    public List<Type> typeParametersValues() {
        return this.typeParametersMap.isEmpty() ? Collections.emptyList() : this.typeDeclaration.getTypeParameters().stream().map(tp -> this.typeParametersMap.getValue((TypeParameterDeclaration)tp)).collect(Collectors.toList());
    }

    public List<Tuple2<TypeParameterDeclaration, Type>> getTypeParametersMap() {
        ArrayList<Tuple2<TypeParameterDeclaration, Type>> typeParametersMap = new ArrayList<Tuple2<TypeParameterDeclaration, Type>>();
        if (!this.isRawType()) {
            for (int i = 0; i < this.typeDeclaration.getTypeParameters().size(); ++i) {
                typeParametersMap.add((Tuple2<TypeParameterDeclaration, Type>)new Tuple2((Object)this.typeDeclaration.getTypeParameters().get(0), (Object)this.typeParametersValues().get(i)));
            }
        }
        return typeParametersMap;
    }

    @Override
    public TypeParametersMap typeParametersMap() {
        return this.typeParametersMap;
    }

    public final ReferenceTypeDeclaration getTypeDeclaration() {
        return this.typeDeclaration;
    }

    public Optional<Type> getFieldType(String name) {
        if (!this.typeDeclaration.hasField(name)) {
            return Optional.empty();
        }
        Type type = this.typeDeclaration.getField(name).getType();
        type = this.useThisTypeParametersOnTheGivenType(type);
        return Optional.of(type);
    }

    public boolean hasName() {
        return this.typeDeclaration.hasName();
    }

    public String getQualifiedName() {
        return this.typeDeclaration.getQualifiedName();
    }

    public String getId() {
        return this.typeDeclaration.getId();
    }

    public abstract Set<MethodUsage> getDeclaredMethods();

    public boolean isRawType() {
        return !this.typeDeclaration.getTypeParameters().isEmpty() && this.typeParametersMap().isEmpty();
    }

    @Override
    public Optional<Type> typeParamValue(TypeParameterDeclaration typeParameterDeclaration) {
        if (typeParameterDeclaration.declaredOnMethod()) {
            throw new IllegalArgumentException();
        }
        String typeId = this.getTypeDeclaration().getId();
        if (typeId.equals(typeParameterDeclaration.getContainerId())) {
            return Optional.of(this.typeParametersMap().getValue(typeParameterDeclaration));
        }
        for (ReferenceType ancestor : this.getAllAncestors()) {
            if (!ancestor.getId().equals(typeParameterDeclaration.getContainerId())) continue;
            return Optional.of(ancestor.typeParametersMap().getValue(typeParameterDeclaration));
        }
        return Optional.empty();
    }

    protected abstract ReferenceType create(ReferenceTypeDeclaration var1, List<Type> var2, TypeSolver var3);

    protected ReferenceType create(ReferenceTypeDeclaration typeDeclaration, TypeParametersMap typeParametersMap, TypeSolver typeSolver) {
        return this.create(typeDeclaration, typeDeclaration.getTypeParameters().stream().map(tp -> typeParametersMap.getValue((TypeParameterDeclaration)tp)).collect(Collectors.toList()), typeSolver);
    }

    protected abstract ReferenceType create(ReferenceTypeDeclaration var1, TypeSolver var2);

    protected boolean isCorrespondingBoxingType(String typeName) {
        switch (typeName) {
            case "boolean": {
                return this.getQualifiedName().equals(Boolean.class.getCanonicalName());
            }
            case "char": {
                return this.getQualifiedName().equals(Character.class.getCanonicalName());
            }
            case "byte": {
                return this.getQualifiedName().equals(Byte.class.getCanonicalName());
            }
            case "short": {
                return this.getQualifiedName().equals(Short.class.getCanonicalName());
            }
            case "int": {
                return this.getQualifiedName().equals(Integer.class.getCanonicalName());
            }
            case "long": {
                return this.getQualifiedName().equals(Long.class.getCanonicalName());
            }
            case "float": {
                return this.getQualifiedName().equals(Float.class.getCanonicalName());
            }
            case "double": {
                return this.getQualifiedName().equals(Double.class.getCanonicalName());
            }
        }
        throw new UnsupportedOperationException(typeName);
    }

    protected boolean compareConsideringTypeParameters(ReferenceType other) {
        if (other.equals(this)) {
            return true;
        }
        if (this.getQualifiedName().equals(other.getQualifiedName())) {
            if (this.isRawType() || other.isRawType()) {
                return true;
            }
            if (this.typeParametersValues().size() != other.typeParametersValues().size()) {
                throw new IllegalStateException();
            }
            for (int i = 0; i < this.typeParametersValues().size(); ++i) {
                Type otherParam;
                Type thisParam = this.typeParametersValues().get(i);
                if (thisParam.equals(otherParam = other.typeParametersValues().get(i))) continue;
                if (thisParam instanceof Wildcard) {
                    Wildcard thisParamAsWildcard = (Wildcard)thisParam;
                    if (thisParamAsWildcard.isSuper() && otherParam.isAssignableBy(thisParamAsWildcard.getBoundedType()) || thisParamAsWildcard.isExtends() && thisParamAsWildcard.getBoundedType().isAssignableBy(otherParam) || !thisParamAsWildcard.isBounded()) continue;
                    return false;
                }
                return false;
            }
            return true;
        }
        return false;
    }

    private static List<Type> deriveParams(ReferenceTypeDeclaration typeDeclaration) {
        return typeDeclaration.getTypeParameters().stream().map(tp -> new TypeVariable((TypeParameterDeclaration)tp)).collect(Collectors.toList());
    }

    public ReferenceType deriveTypeParameters(TypeParametersMap typeParametersMap) {
        return this.create(this.typeDeclaration, typeParametersMap, this.typeSolver);
    }
}

