/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.symbolsolver.model.typesystem;

import com.github.javaparser.symbolsolver.model.declarations.TypeParameterDeclaration;
import com.github.javaparser.symbolsolver.model.typesystem.ArrayType;
import com.github.javaparser.symbolsolver.model.typesystem.LambdaConstraintType;
import com.github.javaparser.symbolsolver.model.typesystem.PrimitiveType;
import com.github.javaparser.symbolsolver.model.typesystem.ReferenceType;
import com.github.javaparser.symbolsolver.model.typesystem.TypeVariable;
import com.github.javaparser.symbolsolver.model.typesystem.Wildcard;
import java.util.HashMap;
import java.util.Map;

public interface Type {
    default public boolean isArray() {
        return false;
    }

    default public int arrayLevel() {
        if (this.isArray()) {
            return 1 + this.asArrayType().getComponentType().arrayLevel();
        }
        return 0;
    }

    default public boolean isPrimitive() {
        return false;
    }

    default public boolean isNull() {
        return false;
    }

    default public boolean isReference() {
        return this.isReferenceType() || this.isArray() || this.isTypeVariable() || this.isNull() || this.isWildcard();
    }

    default public boolean isConstraint() {
        return false;
    }

    default public boolean isReferenceType() {
        return false;
    }

    default public boolean isVoid() {
        return false;
    }

    default public boolean isTypeVariable() {
        return false;
    }

    default public boolean isWildcard() {
        return false;
    }

    default public ArrayType asArrayType() {
        throw new UnsupportedOperationException(String.format("%s is not an Array", this));
    }

    default public ReferenceType asReferenceType() {
        throw new UnsupportedOperationException(String.format("%s is not a Reference Type", this));
    }

    default public TypeParameterDeclaration asTypeParameter() {
        throw new UnsupportedOperationException(String.format("%s is not a Type parameter", this));
    }

    default public TypeVariable asTypeVariable() {
        throw new UnsupportedOperationException(String.format("%s is not a Type variable", this));
    }

    default public PrimitiveType asPrimitive() {
        throw new UnsupportedOperationException(String.format("%s is not a Primitive type", this));
    }

    default public Wildcard asWildcard() {
        throw new UnsupportedOperationException(String.format("%s is not a Wildcard", this));
    }

    default public LambdaConstraintType asConstraintType() {
        throw new UnsupportedOperationException(String.format("%s is not a constraint type", this));
    }

    public String describe();

    default public Type replaceTypeVariables(TypeParameterDeclaration tp, Type replaced, Map<TypeParameterDeclaration, Type> inferredTypes) {
        return this;
    }

    default public Type replaceTypeVariables(TypeParameterDeclaration tp, Type replaced) {
        return this.replaceTypeVariables(tp, replaced, new HashMap<TypeParameterDeclaration, Type>());
    }

    public boolean isAssignableBy(Type var1);
}

