/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.symbolsolver.model.typesystem;

import com.github.javaparser.symbolsolver.model.declarations.TypeParameterDeclaration;
import com.github.javaparser.symbolsolver.model.typesystem.Type;
import java.util.Map;

public class Wildcard
implements Type {
    public static Wildcard UNBOUNDED = new Wildcard(null, null);
    private BoundType type;
    private Type boundedType;

    private Wildcard(BoundType type, Type boundedType) {
        if (type == null && boundedType != null) {
            throw new IllegalArgumentException();
        }
        if (type != null && boundedType == null) {
            throw new IllegalArgumentException();
        }
        this.type = type;
        this.boundedType = boundedType;
    }

    public static Wildcard superBound(Type type) {
        return new Wildcard(BoundType.SUPER, type);
    }

    public static Wildcard extendsBound(Type type) {
        return new Wildcard(BoundType.EXTENDS, type);
    }

    public String toString() {
        return "WildcardUsage{type=" + (Object)((Object)this.type) + ", boundedType=" + this.boundedType + '}';
    }

    @Override
    public boolean isWildcard() {
        return true;
    }

    @Override
    public Wildcard asWildcard() {
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Wildcard)) {
            return false;
        }
        Wildcard that = (Wildcard)o;
        if (this.boundedType != null ? !this.boundedType.equals(that.boundedType) : that.boundedType != null) {
            return false;
        }
        return this.type == that.type;
    }

    public int hashCode() {
        int result = this.type != null ? this.type.hashCode() : 0;
        result = 31 * result + (this.boundedType != null ? this.boundedType.hashCode() : 0);
        return result;
    }

    @Override
    public String describe() {
        if (this.type == null) {
            return "?";
        }
        if (this.type == BoundType.SUPER) {
            return "? super " + this.boundedType.describe();
        }
        if (this.type == BoundType.EXTENDS) {
            return "? extends " + this.boundedType.describe();
        }
        throw new UnsupportedOperationException();
    }

    public boolean isSuper() {
        return this.type == BoundType.SUPER;
    }

    public boolean isExtends() {
        return this.type == BoundType.EXTENDS;
    }

    public boolean isBounded() {
        return this.isSuper() || this.isExtends();
    }

    public Type getBoundedType() {
        if (this.boundedType == null) {
            throw new IllegalStateException();
        }
        return this.boundedType;
    }

    @Override
    public boolean isAssignableBy(Type other) {
        if (this.boundedType == null) {
            return false;
        }
        if (this.type == BoundType.SUPER) {
            return this.boundedType.isAssignableBy(other);
        }
        if (this.type == BoundType.EXTENDS) {
            return false;
        }
        throw new RuntimeException();
    }

    @Override
    public Type replaceTypeVariables(TypeParameterDeclaration tpToReplace, Type replaced, Map<TypeParameterDeclaration, Type> inferredTypes) {
        if (replaced == null) {
            throw new IllegalArgumentException();
        }
        if (this.boundedType == null) {
            return this;
        }
        Type boundedTypeReplaced = this.boundedType.replaceTypeVariables(tpToReplace, replaced, inferredTypes);
        if (boundedTypeReplaced == null) {
            throw new RuntimeException();
        }
        if (boundedTypeReplaced != this.boundedType) {
            return new Wildcard(this.type, boundedTypeReplaced);
        }
        return this;
    }

    public static enum BoundType {
        SUPER,
        EXTENDS;

    }
}

