/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlgrock.javascriptframework.jsar;

import com.github.jlgrock.javascriptframework.mavenutils.mavenobjects.JsarRelativeLocations;
import java.io.File;
import org.apache.log4j.Logger;
import org.apache.maven.archiver.MavenArchiveConfiguration;
import org.apache.maven.archiver.MavenArchiver;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.myfaces.buildtools.maven2.plugin.javascript.jmt.archive.JavascriptArchiver;
import org.codehaus.plexus.archiver.jar.JarArchiver;

public class JsarMojo
extends AbstractMojo {
    private static final Logger LOGGER = Logger.getLogger(JsarMojo.class);
    private File frameworkTargetDirectory;
    private String classifier;
    private static final String[] DEFAULT_EXCLUDES = new String[]{"**/package.html"};
    private static final String[] DEFAULT_INCLUDES = new String[]{"**/**"};
    private String[] includes;
    private String[] excludes;
    private File outputDirectory;
    private String finalName;
    private JavascriptArchiver jsarArchiver;
    private MavenProject project;
    private MavenArchiveConfiguration archive = new MavenArchiveConfiguration();
    private File defaultManifestFile;
    private boolean useDefaultManifestFile;
    private MavenProjectHelper projectHelper;
    private boolean forceCreation;
    private String debugFilename;

    protected final String getClassifier() {
        return this.classifier;
    }

    protected final String getType() {
        return "jsar";
    }

    protected final MavenProject getProject() {
        return this.project;
    }

    protected static File getJsarFile(File basedir, String finalName, String classifier) {
        String classifierOut = classifier;
        if (classifier == null) {
            classifierOut = "";
        } else if (classifier.trim().length() > 0 && !classifier.startsWith("-")) {
            classifierOut = "-" + classifier;
        }
        return new File(basedir, finalName + classifierOut + ".jsar");
    }

    protected final File getDefaultManifestFile() {
        return this.defaultManifestFile;
    }

    public final File createArchive() throws MojoExecutionException {
        File jsarFile = JsarMojo.getJsarFile(this.outputDirectory, this.finalName, this.getClassifier());
        MavenArchiver archiver = new MavenArchiver();
        archiver.setArchiver((JarArchiver)this.jsarArchiver);
        archiver.setOutputFile(jsarFile);
        this.archive.setForced(this.forceCreation);
        try {
            File compiledDirectory = JsarRelativeLocations.getOutputLocation((File)this.getFrameworkTargetDirectory());
            archiver.getArchiver().addDirectory(compiledDirectory);
            File existingManifest = this.getDefaultManifestFile();
            if (this.useDefaultManifestFile && existingManifest.exists() && this.archive.getManifestFile() == null) {
                LOGGER.info((Object)("Adding existing MANIFEST to archive. Found under: " + existingManifest.getPath()));
                this.archive.setManifestFile(existingManifest);
            }
            archiver.createArchive(this.project, this.archive);
            return jsarFile;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error assembling JSAR", e);
        }
    }

    public final void execute() throws MojoExecutionException, MojoFailureException {
        File jsarFile = this.createArchive();
        if (this.classifier != null) {
            this.projectHelper.attachArtifact(this.getProject(), this.getType(), this.classifier, jsarFile);
        } else {
            this.getProject().getArtifact().setFile(jsarFile);
        }
    }

    private String[] getIncludes() {
        if (this.includes != null && this.includes.length > 0) {
            return this.includes;
        }
        return DEFAULT_INCLUDES;
    }

    private String[] getExcludes() {
        if (this.excludes != null && this.excludes.length > 0) {
            return this.excludes;
        }
        return DEFAULT_EXCLUDES;
    }

    public final String getDebugFilename() {
        return this.debugFilename;
    }

    public final void setDebugFilename(String debugFilenameIn) {
        this.debugFilename = debugFilenameIn;
    }

    public final File getFrameworkTargetDirectory() {
        return this.frameworkTargetDirectory;
    }

    public final void setFrameworkTargetDirectory(File frameworkTargetDirectoryIn) {
        this.frameworkTargetDirectory = frameworkTargetDirectoryIn;
    }
}

