/*
 * Decompiled with CFR 0.152.
 */
package com.github.loki4j.client.batch;

import com.github.loki4j.client.batch.BinaryBatch;
import com.github.loki4j.client.util.ByteBufferFactory;
import java.nio.ByteBuffer;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;

public class ByteBufferQueue {
    private final ConcurrentLinkedQueue<BinaryBatch> pool = new ConcurrentLinkedQueue();
    private final AtomicLong sizeBytes = new AtomicLong(0L);
    private final ConcurrentLinkedQueue<BinaryBatch> items = new ConcurrentLinkedQueue();
    private final long maxSizeBytes;
    private final ByteBufferFactory bufferFactory;

    public ByteBufferQueue(long maxSizeBytes, ByteBufferFactory bufferFactory) {
        this.maxSizeBytes = maxSizeBytes;
        this.bufferFactory = bufferFactory;
    }

    public boolean offer(long batchId, int itemsCount, int claimBytes, Consumer<ByteBuffer> write) {
        if (this.sizeBytes.get() + (long)claimBytes > this.maxSizeBytes) {
            return false;
        }
        this.sizeBytes.addAndGet(claimBytes);
        BinaryBatch batch = this.pool.poll();
        if (batch == null) {
            batch = new BinaryBatch();
        }
        if (batch.data == null || batch.data.capacity() <= claimBytes) {
            batch.data = this.bufferFactory.allocate(claimBytes + claimBytes / 2);
        }
        batch.batchId = batchId;
        batch.sizeItems = itemsCount;
        batch.sizeBytes = claimBytes;
        batch.data.clear();
        write.accept(batch.data);
        this.items.offer(batch);
        return true;
    }

    public BinaryBatch borrowBuffer() {
        BinaryBatch batch = this.items.poll();
        if (batch != null) {
            this.sizeBytes.addAndGet(-batch.sizeBytes);
        }
        return batch;
    }

    public void returnBuffer(BinaryBatch batch) {
        if (!this.pool.isEmpty()) {
            return;
        }
        this.pool.offer(batch);
    }

    public long getSizeBytes() {
        return this.sizeBytes.get();
    }

    int poolSize() {
        return this.pool.size();
    }
}

