/*
 * Decompiled with CFR 0.152.
 */
package com.github.loki4j.logback;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Layout;
import ch.qos.logback.core.spi.ContextAwareBase;
import com.github.loki4j.logback.json.JsonEventWriter;
import com.github.loki4j.logback.json.JsonProvider;
import com.github.loki4j.logback.json.KeyValuePairsJsonProvider;
import com.github.loki4j.logback.json.LogLevelJsonProvider;
import com.github.loki4j.logback.json.LoggerNameJsonProvider;
import com.github.loki4j.logback.json.MdcJsonProvider;
import com.github.loki4j.logback.json.MessageJsonProvider;
import com.github.loki4j.logback.json.StackTraceJsonProvider;
import com.github.loki4j.logback.json.ThreadNameJsonProvider;
import com.github.loki4j.logback.json.TimestampJsonProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.function.Supplier;

public class JsonLayout
extends ContextAwareBase
implements Layout<ILoggingEvent> {
    private static final String EMPTY_STRING = "";
    private static final int INIT_WRITER_CAPACITY_BYTES = 1000;
    private TimestampJsonProvider timestamp;
    private LoggerNameJsonProvider loggerName;
    private LogLevelJsonProvider logLevel;
    private ThreadNameJsonProvider threadName;
    private MessageJsonProvider message;
    private StackTraceJsonProvider stackTrace;
    private MdcJsonProvider mdc;
    private KeyValuePairsJsonProvider kvp;
    private volatile boolean started;
    private List<JsonProvider<ILoggingEvent>> providers;
    private List<JsonProvider<ILoggingEvent>> customProviders = new ArrayList<JsonProvider<ILoggingEvent>>();

    public String doLayout(ILoggingEvent event) {
        JsonEventWriter jsonWriter = new JsonEventWriter(1000);
        Iterator<JsonProvider<ILoggingEvent>> standard = this.providers.iterator();
        Iterator<JsonProvider<ILoggingEvent>> custom = this.customProviders.iterator();
        boolean firstFieldWritten = false;
        jsonWriter.writeBeginObject();
        while (standard.hasNext() || custom.hasNext()) {
            JsonProvider<ILoggingEvent> provider = standard.hasNext() ? standard.next() : custom.next();
            if (!provider.isEnabled() || !provider.canWrite(event)) continue;
            firstFieldWritten = provider.writeTo(jsonWriter, event, firstFieldWritten) || firstFieldWritten;
        }
        jsonWriter.writeEndObject();
        return jsonWriter.toString();
    }

    public void start() {
        this.timestamp = this.ensureProvider(this.timestamp, TimestampJsonProvider::new);
        this.loggerName = this.ensureProvider(this.loggerName, LoggerNameJsonProvider::new);
        this.logLevel = this.ensureProvider(this.logLevel, LogLevelJsonProvider::new);
        this.threadName = this.ensureProvider(this.threadName, ThreadNameJsonProvider::new);
        this.message = this.ensureProvider(this.message, MessageJsonProvider::new);
        this.stackTrace = this.ensureProvider(this.stackTrace, StackTraceJsonProvider::new);
        this.mdc = this.ensureProvider(this.mdc, MdcJsonProvider::new);
        this.kvp = this.ensureProvider(this.kvp, KeyValuePairsJsonProvider::new);
        this.providers = Arrays.asList(this.timestamp, this.loggerName, this.logLevel, this.threadName, this.message, this.stackTrace, this.mdc, this.kvp);
        for (JsonProvider<ILoggingEvent> provider : this.providers) {
            provider.setContext(this.context);
            provider.start();
        }
        for (JsonProvider<ILoggingEvent> provider : this.customProviders) {
            provider.setContext(this.context);
            provider.start();
        }
        this.started = true;
    }

    public void stop() {
        this.started = false;
        for (JsonProvider<ILoggingEvent> provider : this.providers) {
            provider.stop();
        }
        for (JsonProvider<ILoggingEvent> provider : this.customProviders) {
            provider.stop();
        }
    }

    private <T extends JsonProvider<ILoggingEvent>> T ensureProvider(T current, Supplier<T> factory) {
        if (current != null) {
            return current;
        }
        JsonProvider newInstance = (JsonProvider)factory.get();
        return (T)newInstance;
    }

    public void addCustomProvider(JsonProvider<ILoggingEvent> provider) {
        this.customProviders.add(provider);
    }

    public void setTimestamp(TimestampJsonProvider timestamp) {
        this.timestamp = timestamp;
    }

    public void setLoggerName(LoggerNameJsonProvider loggerName) {
        this.loggerName = loggerName;
    }

    public void setLogLevel(LogLevelJsonProvider logLevel) {
        this.logLevel = logLevel;
    }

    public void setThreadName(ThreadNameJsonProvider threadName) {
        this.threadName = threadName;
    }

    public void setMessage(MessageJsonProvider message) {
        this.message = message;
    }

    public void setStackTrace(StackTraceJsonProvider stackTrace) {
        this.stackTrace = stackTrace;
    }

    public void setMdc(MdcJsonProvider mdc) {
        this.mdc = mdc;
    }

    public void setKvp(KeyValuePairsJsonProvider keyValuePairs) {
        this.kvp = keyValuePairs;
    }

    public boolean isStarted() {
        return this.started;
    }

    public String getFileHeader() {
        return EMPTY_STRING;
    }

    public String getPresentationHeader() {
        return EMPTY_STRING;
    }

    public String getPresentationFooter() {
        return EMPTY_STRING;
    }

    public String getFileFooter() {
        return EMPTY_STRING;
    }

    public String getContentType() {
        return "application/json";
    }
}

