/*
 * Decompiled with CFR 0.152.
 */
package com.github.opendevl;

import com.github.opendevl.OrderJson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.spi.json.JacksonJsonProvider;
import com.jayway.jsonpath.spi.json.JsonProvider;
import com.jayway.jsonpath.spi.mapper.JacksonMappingProvider;
import com.jayway.jsonpath.spi.mapper.MappingProvider;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JFlat {
    private String jsonString = null;
    private List<Object[]> sheetMatrix = null;
    private List<String> pathList = null;
    private String[] tmp = null;
    private HashSet<String> primitivePath = null;
    private HashSet<String> primitiveUniquePath = null;
    private List<String> unique = null;
    private String regex = "(\\[[0-9]*\\]$)";
    private Pattern pattern = Pattern.compile(this.regex, 8);
    private JsonElement ele = null;
    private String tmpPath = null;
    private OrderJson makeOrder = new OrderJson();

    public JFlat(String jsonString) {
        this.jsonString = jsonString;
    }

    public JFlat json2Sheet() {
        Configuration.setDefaults((Configuration.Defaults)new Configuration.Defaults(){
            private final JsonProvider jsonProvider = new JacksonJsonProvider();
            private final MappingProvider mappingProvider = new JacksonMappingProvider();

            public JsonProvider jsonProvider() {
                return this.jsonProvider;
            }

            public MappingProvider mappingProvider() {
                return this.mappingProvider;
            }

            public Set options() {
                return EnumSet.noneOf(Option.class);
            }
        });
        Configuration conf = Configuration.defaultConfiguration().addOptions(new Option[]{Option.DEFAULT_PATH_LEAF_TO_NULL}).addOptions(new Option[]{Option.SUPPRESS_EXCEPTIONS});
        Configuration pathConf = Configuration.defaultConfiguration().addOptions(new Option[]{Option.AS_PATH_LIST}).addOptions(new Option[]{Option.ALWAYS_RETURN_LIST});
        DocumentContext parse = null;
        this.sheetMatrix = new ArrayList<Object[]>();
        this.ele = new JsonParser().parse(this.jsonString);
        this.pathList = (List)JsonPath.using((Configuration)pathConf).parse(this.jsonString).read("$..*", new Predicate[0]);
        parse = JsonPath.using((Configuration)conf).parse(this.jsonString);
        this.primitivePath = new LinkedHashSet<String>();
        this.primitiveUniquePath = new LinkedHashSet<String>();
        for (String o : this.pathList) {
            Object tmp = parse.read(o, new Predicate[0]);
            if (tmp == null) {
                this.primitivePath.add(o);
                continue;
            }
            String dataType = tmp.getClass().getSimpleName();
            if (!dataType.equals("Boolean") && !dataType.equals("Integer") && !dataType.equals("String") && !dataType.equals("Double") && !dataType.equals("Long")) continue;
            this.primitivePath.add(o);
        }
        for (String o : this.primitivePath) {
            Matcher m = this.pattern.matcher(o);
            if (m.find()) {
                this.tmp = o.replace("$", "").split("(\\[[0-9]*\\]$)");
                this.tmp[0] = this.tmp[0].replaceAll("(\\[[0-9]*\\])", "");
                this.primitiveUniquePath.add("/" + (this.tmp[0] + m.group()).replace("'][", "/").replace("[", "").replace("]", "").replace("''", "/").replace("'", ""));
                continue;
            }
            this.primitiveUniquePath.add("/" + o.replace("$", "").replaceAll("(\\[[0-9]*\\])", "").replace("[", "").replace("]", "").replace("''", "/").replace("'", ""));
        }
        this.unique = new ArrayList<String>(this.primitiveUniquePath);
        Object[] header = new Object[this.unique.size()];
        int i = 0;
        for (String o : this.unique) {
            header[i] = o;
            ++i;
        }
        this.sheetMatrix.add(header);
        this.sheetMatrix.add(this.make2D(new Object[this.unique.size()], new Object[this.unique.size()], this.ele, "$"));
        Object[] last = this.sheetMatrix.get(this.sheetMatrix.size() - 1);
        Object[] secondLast = this.sheetMatrix.get(this.sheetMatrix.size() - 2);
        boolean delete = true;
        for (Object o : last) {
            if (o == null) continue;
            delete = false;
            break;
        }
        if (!delete) {
            delete = true;
            for (int DEL = 0; DEL < last.length; ++DEL) {
                if (last[DEL] == null || last[DEL].equals(secondLast[DEL])) continue;
                delete = false;
                break;
            }
        }
        if (delete) {
            this.sheetMatrix.remove(this.sheetMatrix.size() - 1);
        }
        return this;
    }

    private Object[] make2D(Object[] cur, Object[] old, JsonElement ele, String path) {
        block17: {
            boolean gotArray;
            block16: {
                cur = (Object[])old.clone();
                gotArray = false;
                if (!ele.isJsonObject()) break block16;
                ele = this.makeOrder.orderJson(ele);
                for (Map.Entry entry : ele.getAsJsonObject().entrySet()) {
                    if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                        this.tmpPath = path + "['" + (String)entry.getKey() + "']";
                        Matcher m = this.pattern.matcher(this.tmpPath);
                        if (m.find()) {
                            String[] tmp = this.tmpPath.replace("$", "").split("(\\[[0-9]*\\]$)");
                            tmp[0] = tmp[0].replaceAll("(\\[[0-9]*\\])", "");
                            this.tmpPath = "/" + (tmp[0] + m.group()).replace("'][", "/").replace("[", "").replace("]", "").replace("''", "/").replace("'", "");
                        } else {
                            this.tmpPath = "/" + this.tmpPath.replace("$", "").replaceAll("(\\[[0-9]*\\])", "").replace("[", "").replace("]", "").replace("''", "/").replace("'", "");
                        }
                        if (this.unique.contains(this.tmpPath)) {
                            int index = this.unique.indexOf(this.tmpPath);
                            cur[index] = ((JsonElement)entry.getValue()).getAsJsonPrimitive();
                        }
                        this.tmpPath = null;
                        continue;
                    }
                    if (((JsonElement)entry.getValue()).isJsonObject()) {
                        cur = this.make2D(new Object[this.unique.size()], cur, (JsonElement)((JsonElement)entry.getValue()).getAsJsonObject(), path + "['" + (String)entry.getKey() + "']");
                        continue;
                    }
                    if (!((JsonElement)entry.getValue()).isJsonArray()) continue;
                    cur = this.make2D(new Object[this.unique.size()], cur, (JsonElement)((JsonElement)entry.getValue()).getAsJsonArray(), path + "['" + (String)entry.getKey() + "']");
                }
                break block17;
            }
            if (!ele.isJsonArray()) break block17;
            int arrIndex = 0;
            for (JsonElement tmp : ele.getAsJsonArray()) {
                if (tmp.isJsonPrimitive()) {
                    this.tmpPath = path + "['" + arrIndex + "']";
                    Matcher m = this.pattern.matcher(this.tmpPath);
                    if (m.find()) {
                        String[] tmp1 = this.tmpPath.replace("$", "").split("(\\[[0-9]*\\]$)");
                        tmp1[0] = tmp1[0].replaceAll("(\\[[0-9]*\\])", "");
                        this.tmpPath = "/" + (tmp1[0] + m.group()).replace("'][", "/").replace("[", "").replace("]", "").replace("''", "/").replace("'", "");
                    } else {
                        this.tmpPath = "/" + this.tmpPath.replace("$", "").replaceAll("(\\[[0-9]*\\])", "").replace("[", "").replace("]", "").replace("''", "/").replace("'", "");
                    }
                    if (this.unique.contains(this.tmpPath)) {
                        int index = this.unique.indexOf(this.tmpPath);
                        cur[index] = tmp.getAsJsonPrimitive();
                    }
                    this.tmpPath = null;
                } else if (tmp.isJsonObject()) {
                    gotArray = this.isInnerArray(tmp);
                    this.sheetMatrix.add(this.make2D(new Object[this.unique.size()], cur, (JsonElement)tmp.getAsJsonObject(), path + "[" + arrIndex + "]"));
                    if (gotArray) {
                        this.sheetMatrix.remove(this.sheetMatrix.size() - 1);
                    }
                } else if (tmp.isJsonArray()) {
                    this.make2D(new Object[this.unique.size()], cur, (JsonElement)tmp.getAsJsonArray(), path + "[" + arrIndex + "]");
                }
                ++arrIndex;
            }
        }
        return cur;
    }

    private boolean isInnerArray(JsonElement ele) {
        for (Map.Entry entry : ele.getAsJsonObject().entrySet()) {
            if (!((JsonElement)entry.getValue()).isJsonArray() || ((JsonElement)entry.getValue()).getAsJsonArray().size() <= 0) continue;
            for (JsonElement checkPrimitive : ((JsonElement)entry.getValue()).getAsJsonArray()) {
                if (!checkPrimitive.isJsonObject()) continue;
                return true;
            }
        }
        return false;
    }

    public JFlat headerSeparator() throws Exception {
        return this.headerSeparator(" ");
    }

    public JFlat headerSeparator(String separator) throws Exception {
        try {
            int sheetMatrixLen = this.sheetMatrix.get(0).length;
            for (int I = 0; I < sheetMatrixLen; ++I) {
                this.sheetMatrix.get((int)0)[I] = this.sheetMatrix.get(0)[I].toString().replaceFirst("^\\/", "").replaceAll("/", separator).trim();
            }
        }
        catch (NullPointerException nullex) {
            throw new Exception("The JSON document hasn't been transformed yet. Try using json2Sheet() before using headerSeparator");
        }
        return this;
    }

    public List<Object[]> getJsonAsSheet() {
        return this.sheetMatrix;
    }

    public List<String> getUniqueFields() {
        return this.unique;
    }

    public void write2csv(String destination) throws FileNotFoundException, UnsupportedEncodingException {
        this.write2csv(destination, ',');
    }

    public void write2csv(String destination, char delimiter) throws FileNotFoundException, UnsupportedEncodingException {
        PrintWriter writer = new PrintWriter(new File(destination), "UTF-8");
        boolean comma = false;
        for (Object[] o : this.sheetMatrix) {
            comma = false;
            for (Object t : o) {
                if (t == null) {
                    writer.print(comma ? Character.valueOf(delimiter) : "");
                } else {
                    writer.print(comma ? delimiter + t.toString() : t.toString());
                }
                if (comma) continue;
                comma = true;
            }
            writer.println();
        }
        writer.close();
    }
}

