/*
 * Decompiled with CFR 0.152.
 */
package net.rithms.riot.api;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Handler;
import java.util.logging.LogRecord;

public class LogHandler
extends Handler {
    private static final String FILE_DATE_PATTERN = "yyyy-MM-dd HH:mm:ss.SSS";
    private final boolean writeToFile;
    private final PrintWriter fileWriter;

    public LogHandler() {
        this(false);
    }

    public LogHandler(boolean toFile) {
        PrintWriter out = null;
        if (toFile) {
            try {
                File log = new File("riot-api.log");
                if (!log.exists()) {
                    log.createNewFile();
                }
                out = new PrintWriter((Writer)new BufferedWriter(new FileWriter(log, true)), true);
            }
            catch (IOException io) {
                System.err.println("Could not set log handler! Using System.out instead");
                io.printStackTrace();
                toFile = false;
            }
        }
        this.writeToFile = toFile;
        this.fileWriter = out;
    }

    @Override
    public void close() {
        if (this.writeToFile) {
            this.fileWriter.flush();
            this.fileWriter.close();
        }
    }

    @Override
    public void flush() {
        if (this.writeToFile) {
            this.fileWriter.flush();
        }
    }

    @Override
    public void publish(LogRecord record) {
        StringBuilder logMessage = new StringBuilder();
        SimpleDateFormat format = new SimpleDateFormat(FILE_DATE_PATTERN);
        logMessage.append("[").append(format.format(new Date())).append("] ");
        logMessage.append("[").append(record.getLevel()).append("] ");
        logMessage.append(record.getMessage());
        Throwable t = record.getThrown();
        if (t != null) {
            logMessage.append("\n");
            StringWriter stackTrace = new StringWriter();
            t.printStackTrace(new PrintWriter(stackTrace));
            logMessage.append(stackTrace.getBuffer());
        }
        System.out.println(logMessage);
        if (this.writeToFile) {
            this.fileWriter.println(logMessage);
        }
    }
}

