/*
 * Decompiled with CFR 0.152.
 */
package net.rithms.riot.api.endpoints.league.dto;

import java.io.Serializable;
import java.util.List;
import net.rithms.riot.api.Dto;
import net.rithms.riot.api.endpoints.league.dto.LeagueItem;

public class LeagueList
extends Dto
implements Serializable {
    private static final long serialVersionUID = 1878237445691308532L;
    private List<LeagueItem> entries;
    private String leagueId;
    private String name;
    private String queue;
    private String tier;

    public List<LeagueItem> getEntries() {
        return this.entries;
    }

    public LeagueItem getEntryBySummonerId(long summonerId) {
        List<LeagueItem> entries = this.getEntries();
        if (entries != null) {
            String summonerIdString = String.valueOf(summonerId);
            for (LeagueItem entry : entries) {
                if (!entry.getPlayerOrTeamId().equals(summonerIdString)) continue;
                return entry;
            }
        }
        return null;
    }

    public LeagueItem getEntryBySummonerName(String summonerName) {
        List<LeagueItem> entries = this.getEntries();
        if (entries != null) {
            for (LeagueItem entry : entries) {
                if (!entry.getPlayerOrTeamName().equalsIgnoreCase(summonerName)) continue;
                return entry;
            }
        }
        return null;
    }

    public String getLeagueId() {
        return this.leagueId;
    }

    public String getName() {
        return this.name;
    }

    public String getQueue() {
        return this.queue;
    }

    public String getTier() {
        return this.tier;
    }

    public String toString() {
        return this.getName();
    }
}

