/*
 * Decompiled with CFR 0.152.
 */
package net.rithms.riot.api.endpoints.tournament;

import net.rithms.riot.api.ApiConfig;
import net.rithms.riot.api.ApiMethod;
import net.rithms.riot.api.HttpHeadParameter;
import net.rithms.riot.api.RiotApiException;

public abstract class TournamentApiMethod
extends ApiMethod {
    protected final String HOST = "https://americas.api.riotgames.com";
    private boolean allowMockMode = false;
    private boolean requireTournamentApiKey = false;

    protected TournamentApiMethod(ApiConfig config) {
        super(config, "tournament");
        this.requireTournamentApiKey();
    }

    protected void addTournamentApiKeyParameter() {
        this.add(new HttpHeadParameter("X-Riot-Token", this.getConfig().getTournamentKey()));
    }

    protected void allowMockMode() {
        this.allowMockMode = true;
    }

    @Override
    public void checkRequirements() throws RiotApiException {
        if (!this.allowMockMode && this.getConfig().getTournamentMockMode()) {
            throw new RiotApiException(403, "This method isn't available in tournament mock mode");
        }
        if (this.requireTournamentApiKey && this.getConfig().getTournamentKey() == null) {
            throw new RiotApiException(612);
        }
    }

    protected void requireTournamentApiKey() {
        this.requireTournamentApiKey = true;
    }
}

