/*
 * Decompiled with CFR 0.152.
 */
package net.rithms.riot.api.endpoints.tournament.methods;

import com.google.gson.reflect.TypeToken;
import java.util.HashMap;
import java.util.List;
import net.rithms.riot.api.ApiConfig;
import net.rithms.riot.api.UrlParameter;
import net.rithms.riot.api.endpoints.tournament.TournamentApiMethod;
import net.rithms.riot.api.endpoints.tournament.constant.PickType;
import net.rithms.riot.api.endpoints.tournament.constant.SpectatorType;
import net.rithms.riot.api.endpoints.tournament.constant.TournamentMap;
import net.rithms.riot.api.request.RequestMethod;

public class CreateTournamentCodes
extends TournamentApiMethod {
    public CreateTournamentCodes(ApiConfig config, int tournamentId, int count, int teamSize, TournamentMap mapType, PickType pickType, SpectatorType spectatorType, String metaData, long ... allowedSummonerIds) {
        super(config);
        this.setHttpMethod(RequestMethod.POST);
        this.setReturnType(new TypeToken<List<String>>(){}.getType());
        if (config.getTournamentMockMode()) {
            this.setUrlBase("https://americas.api.riotgames.com/lol/tournament-stub/v3/codes");
        } else {
            this.setUrlBase("https://americas.api.riotgames.com/lol/tournament/v3/codes");
        }
        this.add(new UrlParameter("tournamentId", tournamentId));
        this.add(new UrlParameter("count", count));
        this.addTournamentApiKeyParameter();
        this.allowMockMode();
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.put("teamSize", teamSize);
        body.put("mapType", (Object)mapType);
        body.put("pickType", (Object)pickType);
        body.put("spectatorType", (Object)spectatorType);
        if (metaData != null) {
            body.put("metaData", metaData);
        }
        if (allowedSummonerIds != null && allowedSummonerIds.length > 0) {
            body.put("allowedSummonerIds", allowedSummonerIds);
        }
        this.buildJsonBody(body);
    }
}

