/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.extension.responsetemplating.helpers;

import com.github.tomakehurst.wiremock.extension.responsetemplating.helpers.HandlebarsCurrentDateHelper;
import com.github.tomakehurst.wiremock.extension.responsetemplating.helpers.HandlebarsJsonPathHelper;
import com.github.tomakehurst.wiremock.extension.responsetemplating.helpers.HandlebarsRandomValuesHelper;
import com.github.tomakehurst.wiremock.extension.responsetemplating.helpers.HandlebarsSoapHelper;
import com.github.tomakehurst.wiremock.extension.responsetemplating.helpers.HandlebarsXPathHelper;
import com.github.tomakehurst.wiremock.extension.responsetemplating.helpers.ParseDateHelper;
import java.io.IOException;
import java.util.Date;
import wiremock.com.github.jknack.handlebars.Helper;
import wiremock.com.github.jknack.handlebars.Options;

public enum WireMockHelpers implements Helper<Object>
{
    xPath{
        private HandlebarsXPathHelper helper = new HandlebarsXPathHelper();

        @Override
        public Object apply(Object context, Options options) throws IOException {
            return this.helper.apply(String.valueOf(context), options);
        }
    }
    ,
    soapXPath{
        private HandlebarsSoapHelper helper = new HandlebarsSoapHelper();

        @Override
        public Object apply(Object context, Options options) throws IOException {
            return this.helper.apply(String.valueOf(context), options);
        }
    }
    ,
    jsonPath{
        private HandlebarsJsonPathHelper helper = new HandlebarsJsonPathHelper();

        @Override
        public Object apply(Object context, Options options) throws IOException {
            return this.helper.apply(String.valueOf(context), options);
        }
    }
    ,
    randomValue{
        private HandlebarsRandomValuesHelper helper = new HandlebarsRandomValuesHelper();

        @Override
        public Object apply(Object context, Options options) throws IOException {
            return this.helper.apply(null, options);
        }
    }
    ,
    date{
        private HandlebarsCurrentDateHelper helper = new HandlebarsCurrentDateHelper();

        @Override
        public Object apply(Object context, Options options) throws IOException {
            Date dateContext = context instanceof Date ? (Date)context : null;
            return this.helper.apply(dateContext, options);
        }
    }
    ,
    now{
        private HandlebarsCurrentDateHelper helper = new HandlebarsCurrentDateHelper();

        @Override
        public Object apply(Object context, Options options) throws IOException {
            return this.helper.apply(null, options);
        }
    }
    ,
    parseDate{
        private ParseDateHelper helper = new ParseDateHelper();

        @Override
        public Object apply(Object context, Options options) throws IOException {
            return this.helper.apply(context.toString(), options);
        }
    };

}

