/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.jetty9;

import com.github.tomakehurst.wiremock.common.Exceptions;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.http.AdminRequestHandler;
import com.github.tomakehurst.wiremock.http.HttpServer;
import com.github.tomakehurst.wiremock.http.HttpServerFactory;
import com.github.tomakehurst.wiremock.http.StubRequestHandler;
import com.github.tomakehurst.wiremock.jetty9.JettyHttpServer;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

public class JettyHttpServerFactory
implements HttpServerFactory {
    private static final Constructor<? extends JettyHttpServer> SERVER_CONSTRUCTOR = JettyHttpServerFactory.getServerConstructor();

    private static Constructor<? extends JettyHttpServer> getServerConstructor() {
        try {
            Class<?> serverClass = Class.forName("com.github.tomakehurst.wiremock.jetty94.Jetty94HttpServer");
            return JettyHttpServerFactory.safelyGetConstructor(serverClass, Options.class, AdminRequestHandler.class, StubRequestHandler.class);
        }
        catch (ClassNotFoundException e) {
            try {
                Class<?> serverClass = Class.forName("com.github.tomakehurst.wiremock.jetty92.Jetty92HttpServer");
                return JettyHttpServerFactory.safelyGetConstructor(serverClass, Options.class, AdminRequestHandler.class, StubRequestHandler.class);
            }
            catch (ClassNotFoundException cnfe) {
                return JettyHttpServerFactory.safelyGetConstructor(JettyHttpServer.class, Options.class, AdminRequestHandler.class, StubRequestHandler.class);
            }
        }
    }

    private static <T> Constructor<T> safelyGetConstructor(Class<T> clazz, Class<?> ... parameterTypes) {
        try {
            return clazz.getConstructor(parameterTypes);
        }
        catch (NoSuchMethodException e) {
            return Exceptions.throwUnchecked(e, Constructor.class);
        }
    }

    @Override
    public HttpServer buildHttpServer(Options options, AdminRequestHandler adminRequestHandler, StubRequestHandler stubRequestHandler) {
        try {
            return SERVER_CONSTRUCTOR.newInstance(options, adminRequestHandler, stubRequestHandler);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            return Exceptions.throwUnchecked(e, HttpServer.class);
        }
    }
}

