/*
 * Decompiled with CFR 0.152.
 */
package com.github.tuupertunut.powershelllibjava;

import java.io.IOException;
import java.io.Reader;
import java.util.Optional;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class AsyncReaderRecorder
implements Runnable {
    private final Reader reader;
    private final StringBuilder buffer = new StringBuilder();
    private IOException storedException = null;
    private boolean endOfStreamReached = false;
    private boolean inputReadingInProgress = false;
    private final Lock lock = new ReentrantLock();
    private final Condition consumptionCondition = this.lock.newCondition();
    private ConsumptionConditionType conditionType;
    private String delimiter;
    private int amount;
    private int firstDelimiterIndex;

    public AsyncReaderRecorder(Reader reader) {
        this.reader = reader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (true) {
            IOException exception = null;
            int readResult = -1;
            try {
                readResult = this.reader.read();
            }
            catch (IOException ex) {
                exception = ex;
            }
            if (Thread.interrupted()) break;
            this.lock.lock();
            try {
                if (exception != null) {
                    this.storedException = exception;
                    this.consumptionCondition.signalAll();
                    break;
                }
                if (readResult == -1) {
                    this.endOfStreamReached = true;
                    this.consumptionCondition.signalAll();
                    break;
                }
                this.buffer.append((char)readResult);
                try {
                    this.inputReadingInProgress = this.reader.ready();
                }
                catch (IOException ex) {
                    this.storedException = ex;
                    this.consumptionCondition.signalAll();
                    this.lock.unlock();
                    break;
                }
                if (this.conditionType == ConsumptionConditionType.CURRENT_INPUT) {
                    if (this.inputReadingInProgress) continue;
                    this.consumptionCondition.signalAll();
                    continue;
                }
                if (this.conditionType == ConsumptionConditionType.DELIMITER) {
                    if (!this.bufferEndsWith(this.delimiter)) continue;
                    this.firstDelimiterIndex = this.buffer.length();
                    this.consumptionCondition.signalAll();
                    continue;
                }
                if (this.conditionType != ConsumptionConditionType.AMOUNT || this.buffer.length() < this.amount) continue;
                this.consumptionCondition.signalAll();
                continue;
            }
            finally {
                this.lock.unlock();
                continue;
            }
            break;
        }
    }

    private boolean bufferEndsWith(String s) {
        if (this.buffer.length() < s.length()) {
            return false;
        }
        for (int i = 0; i < s.length(); ++i) {
            if (this.buffer.charAt(this.buffer.length() - 1 - i) == s.charAt(s.length() - 1 - i)) continue;
            return false;
        }
        return true;
    }

    private int bufferFirstEndIndexOf(String s) {
        int index = this.buffer.indexOf(s);
        if (index != -1) {
            index += s.length();
        }
        return index;
    }

    private boolean shouldWaitForCurrentInput() {
        return this.inputReadingInProgress && !this.endOfStreamReached && this.storedException == null;
    }

    private boolean shouldWaitForDelimiter() {
        return this.firstDelimiterIndex == -1 && !this.endOfStreamReached && this.storedException == null;
    }

    private boolean shouldWaitForAmount() {
        return this.buffer.length() < this.amount && !this.endOfStreamReached && this.storedException == null;
    }

    public boolean hasStreamEnded() {
        this.lock.lock();
        try {
            boolean bl = this.endOfStreamReached;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean hasExceptionOccurred() {
        this.lock.lock();
        try {
            boolean bl = this.storedException != null;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public IOException getException() {
        this.lock.lock();
        try {
            IOException iOException = this.storedException;
            return iOException;
        }
        finally {
            this.lock.unlock();
        }
    }

    public String getBuffer() throws IOException {
        this.lock.lock();
        try {
            if (this.storedException != null) {
                throw this.storedException;
            }
            String string = this.buffer.toString();
            return string;
        }
        finally {
            this.lock.unlock();
        }
    }

    public int getBufferedAmount() throws IOException {
        this.lock.lock();
        try {
            if (this.storedException != null) {
                throw this.storedException;
            }
            int n = this.buffer.length();
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    public String consumeAll() throws IOException {
        this.lock.lock();
        try {
            if (this.storedException != null) {
                throw this.storedException;
            }
            String bufferContent = this.buffer.toString();
            this.buffer.setLength(0);
            String string = bufferContent;
            return string;
        }
        finally {
            this.lock.unlock();
        }
    }

    public String consumeAllAfterCurrentInput() throws IOException, InterruptedException {
        this.lock.lock();
        try {
            if (this.shouldWaitForCurrentInput()) {
                this.conditionType = ConsumptionConditionType.CURRENT_INPUT;
                while (this.shouldWaitForCurrentInput()) {
                    this.consumptionCondition.await();
                }
                this.conditionType = ConsumptionConditionType.NONE;
            }
            if (this.storedException != null) {
                throw this.storedException;
            }
            String bufferContent = this.buffer.toString();
            this.buffer.setLength(0);
            String string = bufferContent;
            return string;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<String> consumeToNextDelimiter(String delimiter) throws IOException, InterruptedException {
        this.lock.lock();
        try {
            this.firstDelimiterIndex = this.bufferFirstEndIndexOf(delimiter);
            if (this.shouldWaitForDelimiter()) {
                this.conditionType = ConsumptionConditionType.DELIMITER;
                this.delimiter = delimiter;
                while (this.shouldWaitForDelimiter()) {
                    this.consumptionCondition.await();
                }
                this.conditionType = ConsumptionConditionType.NONE;
            }
            if (this.storedException != null) {
                throw this.storedException;
            }
            if (this.firstDelimiterIndex != -1) {
                String bufferContent = this.buffer.substring(0, this.firstDelimiterIndex);
                this.buffer.delete(0, this.firstDelimiterIndex);
                Optional<String> optional = Optional.of(bufferContent);
                return optional;
            }
            Optional<String> optional = Optional.empty();
            return optional;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<String> consumeAmount(int amount) throws IOException, InterruptedException {
        this.lock.lock();
        try {
            if (this.shouldWaitForAmount()) {
                this.conditionType = ConsumptionConditionType.AMOUNT;
                this.amount = amount;
                while (this.shouldWaitForAmount()) {
                    this.consumptionCondition.await();
                }
                this.conditionType = ConsumptionConditionType.NONE;
            }
            if (this.storedException != null) {
                throw this.storedException;
            }
            if (this.buffer.length() >= amount) {
                String bufferContent = this.buffer.substring(0, amount);
                this.buffer.delete(0, amount);
                Optional<String> optional = Optional.of(bufferContent);
                return optional;
            }
            Optional<String> optional = Optional.empty();
            return optional;
        }
        finally {
            this.lock.unlock();
        }
    }

    private static enum ConsumptionConditionType {
        NONE,
        CURRENT_INPUT,
        DELIMITER,
        AMOUNT;

    }
}

