/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.aiplatform.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class FeatureViewName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_FEATURE_ONLINE_STORE_FEATURE_VIEW = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/featureOnlineStores/{feature_online_store}/featureViews/{feature_view}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String featureOnlineStore;
    private final String featureView;

    @Deprecated
    protected FeatureViewName() {
        this.project = null;
        this.location = null;
        this.featureOnlineStore = null;
        this.featureView = null;
    }

    private FeatureViewName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.featureOnlineStore = (String)Preconditions.checkNotNull((Object)builder.getFeatureOnlineStore());
        this.featureView = (String)Preconditions.checkNotNull((Object)builder.getFeatureView());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getFeatureOnlineStore() {
        return this.featureOnlineStore;
    }

    public String getFeatureView() {
        return this.featureView;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static FeatureViewName of(String project, String location, String featureOnlineStore, String featureView) {
        return FeatureViewName.newBuilder().setProject(project).setLocation(location).setFeatureOnlineStore(featureOnlineStore).setFeatureView(featureView).build();
    }

    public static String format(String project, String location, String featureOnlineStore, String featureView) {
        return FeatureViewName.newBuilder().setProject(project).setLocation(location).setFeatureOnlineStore(featureOnlineStore).setFeatureView(featureView).build().toString();
    }

    public static FeatureViewName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_FEATURE_ONLINE_STORE_FEATURE_VIEW.validatedMatch(formattedString, "FeatureViewName.parse: formattedString not in valid format");
        return FeatureViewName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("feature_online_store"), (String)matchMap.get("feature_view"));
    }

    public static List<FeatureViewName> parseList(List<String> formattedStrings) {
        ArrayList<FeatureViewName> list = new ArrayList<FeatureViewName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(FeatureViewName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<FeatureViewName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (FeatureViewName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_FEATURE_ONLINE_STORE_FEATURE_VIEW.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            FeatureViewName featureViewName = this;
            synchronized (featureViewName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.featureOnlineStore != null) {
                        fieldMapBuilder.put((Object)"feature_online_store", (Object)this.featureOnlineStore);
                    }
                    if (this.featureView != null) {
                        fieldMapBuilder.put((Object)"feature_view", (Object)this.featureView);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_FEATURE_ONLINE_STORE_FEATURE_VIEW.instantiate(new String[]{"project", this.project, "location", this.location, "feature_online_store", this.featureOnlineStore, "feature_view", this.featureView});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            FeatureViewName that = (FeatureViewName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.featureOnlineStore, that.featureOnlineStore) && Objects.equals(this.featureView, that.featureView);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.featureOnlineStore);
        h *= 1000003;
        return h ^= Objects.hashCode(this.featureView);
    }

    public static class Builder {
        private String project;
        private String location;
        private String featureOnlineStore;
        private String featureView;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getFeatureOnlineStore() {
            return this.featureOnlineStore;
        }

        public String getFeatureView() {
            return this.featureView;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setFeatureOnlineStore(String featureOnlineStore) {
            this.featureOnlineStore = featureOnlineStore;
            return this;
        }

        public Builder setFeatureView(String featureView) {
            this.featureView = featureView;
            return this;
        }

        private Builder(FeatureViewName featureViewName) {
            this.project = featureViewName.project;
            this.location = featureViewName.location;
            this.featureOnlineStore = featureViewName.featureOnlineStore;
            this.featureView = featureViewName.featureView;
        }

        public FeatureViewName build() {
            return new FeatureViewName(this);
        }
    }
}

