/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.aiplatform.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class IndexName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_INDEX = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/indexes/{index}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String index;

    @Deprecated
    protected IndexName() {
        this.project = null;
        this.location = null;
        this.index = null;
    }

    private IndexName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.index = (String)Preconditions.checkNotNull((Object)builder.getIndex());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getIndex() {
        return this.index;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static IndexName of(String project, String location, String index) {
        return IndexName.newBuilder().setProject(project).setLocation(location).setIndex(index).build();
    }

    public static String format(String project, String location, String index) {
        return IndexName.newBuilder().setProject(project).setLocation(location).setIndex(index).build().toString();
    }

    public static IndexName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_INDEX.validatedMatch(formattedString, "IndexName.parse: formattedString not in valid format");
        return IndexName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("index"));
    }

    public static List<IndexName> parseList(List<String> formattedStrings) {
        ArrayList<IndexName> list = new ArrayList<IndexName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(IndexName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<IndexName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (IndexName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_INDEX.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            IndexName indexName = this;
            synchronized (indexName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.index != null) {
                        fieldMapBuilder.put((Object)"index", (Object)this.index);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_INDEX.instantiate(new String[]{"project", this.project, "location", this.location, "index", this.index});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            IndexName that = (IndexName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.index, that.index);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.index);
    }

    public static class Builder {
        private String project;
        private String location;
        private String index;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getIndex() {
            return this.index;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setIndex(String index) {
            this.index = index;
            return this;
        }

        private Builder(IndexName indexName) {
            this.project = indexName.project;
            this.location = indexName.location;
            this.index = indexName.index;
        }

        public IndexName build() {
            return new IndexName(this);
        }
    }
}

