/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.aiplatform.v1beta1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class NasJobName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_NAS_JOB = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/nasJobs/{nas_job}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String nasJob;

    @Deprecated
    protected NasJobName() {
        this.project = null;
        this.location = null;
        this.nasJob = null;
    }

    private NasJobName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.nasJob = (String)Preconditions.checkNotNull((Object)builder.getNasJob());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getNasJob() {
        return this.nasJob;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static NasJobName of(String project, String location, String nasJob) {
        return NasJobName.newBuilder().setProject(project).setLocation(location).setNasJob(nasJob).build();
    }

    public static String format(String project, String location, String nasJob) {
        return NasJobName.newBuilder().setProject(project).setLocation(location).setNasJob(nasJob).build().toString();
    }

    public static NasJobName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_NAS_JOB.validatedMatch(formattedString, "NasJobName.parse: formattedString not in valid format");
        return NasJobName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("nas_job"));
    }

    public static List<NasJobName> parseList(List<String> formattedStrings) {
        ArrayList<NasJobName> list = new ArrayList<NasJobName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(NasJobName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<NasJobName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (NasJobName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_NAS_JOB.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            NasJobName nasJobName = this;
            synchronized (nasJobName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.nasJob != null) {
                        fieldMapBuilder.put((Object)"nas_job", (Object)this.nasJob);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_NAS_JOB.instantiate(new String[]{"project", this.project, "location", this.location, "nas_job", this.nasJob});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            NasJobName that = (NasJobName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.nasJob, that.nasJob);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.nasJob);
    }

    public static class Builder {
        private String project;
        private String location;
        private String nasJob;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getNasJob() {
            return this.nasJob;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setNasJob(String nasJob) {
            this.nasJob = nasJob;
            return this;
        }

        private Builder(NasJobName nasJobName) {
            this.project = nasJobName.project;
            this.location = nasJobName.location;
            this.nasJob = nasJobName.nasJob;
        }

        public NasJobName build() {
            return new NasJobName(this);
        }
    }
}

