/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1beta1/dataset_service.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.aiplatform.v1beta1;

/**
 *
 *
 * <pre>
 * Request message for
 * [DatasetService.AssessData][google.cloud.aiplatform.v1beta1.DatasetService.AssessData].
 * Used only for MULTIMODAL datasets.
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1beta1.AssessDataRequest}
 */
public final class AssessDataRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.AssessDataRequest)
    AssessDataRequestOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use AssessDataRequest.newBuilder() to construct.
  private AssessDataRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private AssessDataRequest() {
    name_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new AssessDataRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1beta1.DatasetServiceProto
        .internal_static_google_cloud_aiplatform_v1beta1_AssessDataRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1beta1.DatasetServiceProto
        .internal_static_google_cloud_aiplatform_v1beta1_AssessDataRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1beta1.AssessDataRequest.class,
            com.google.cloud.aiplatform.v1beta1.AssessDataRequest.Builder.class);
  }

  public interface TuningValidationAssessmentConfigOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1beta1.AssessDataRequest.TuningValidationAssessmentConfig)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. The name of the model used for tuning.
     * </pre>
     *
     * <code>string model_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The modelName.
     */
    java.lang.String getModelName();

    /**
     *
     *
     * <pre>
     * Required. The name of the model used for tuning.
     * </pre>
     *
     * <code>string model_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for modelName.
     */
    com.google.protobuf.ByteString getModelNameBytes();

    /**
     *
     *
     * <pre>
     * Required. The dataset usage (e.g. training/validation).
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.AssessDataRequest.TuningValidationAssessmentConfig.DatasetUsage dataset_usage = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The enum numeric value on the wire for datasetUsage.
     */
    int getDatasetUsageValue();

    /**
     *
     *
     * <pre>
     * Required. The dataset usage (e.g. training/validation).
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.AssessDataRequest.TuningValidationAssessmentConfig.DatasetUsage dataset_usage = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The datasetUsage.
     */
    com.google.cloud.aiplatform.v1beta1.AssessDataRequest.TuningValidationAssessmentConfig
            .DatasetUsage
        getDatasetUsage();
  }

  /**
   *
   *
   * <pre>
   * Configuration for the tuning validation assessment.
   * </pre>
   *
   * Protobuf type {@code
   * google.cloud.aiplatform.v1beta1.AssessDataRequest.TuningValidationAssessmentConfig}
   */
  public static final class TuningValidationAssessmentConfig
      extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.AssessDataRequest.TuningValidationAssessmentConfig)
      TuningValidationAssessmentConfigOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use TuningValidationAssessmentConfig.newBuilder() to construct.
    private TuningValidationAssessmentConfig(
        com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private TuningValidationAssessmentConfig() {
      modelName_ = "";
      datasetUsage_ = 0;
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new TuningValidationAssessmentConfig();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.DatasetServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_AssessDataRequest_TuningValidationAssessmentConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.DatasetServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_AssessDataRequest_TuningValidationAssessmentConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.AssessDataRequest.TuningValidationAssessmentConfig
                  .class,
              com.google.cloud.aiplatform.v1beta1.AssessDataRequest.TuningValidationAssessmentConfig
                  .Builder.class);
    }

    /**
     *
     *
     * <pre>
     * The dataset usage (e.g. training/validation).
     * </pre>
     *
     * Protobuf enum {@code
     * google.cloud.aiplatform.v1beta1.AssessDataRequest.TuningValidationAssessmentConfig.DatasetUsage}
     */
    public enum DatasetUsage implements com.google.protobuf.ProtocolMessageEnum {
      /**
       *
       *
       * <pre>
       * Default value. Should not be used.
       * </pre>
       *
       * <code>DATASET_USAGE_UNSPECIFIED = 0;</code>
       */
      DATASET_USAGE_UNSPECIFIED(0),
      /**
       *
       *
       * <pre>
       * Supervised fine-tuning training dataset.
       * </pre>
       *
       * <code>SFT_TRAINING = 1;</code>
       */
      SFT_TRAINING(1),
      /**
       *
       *
       * <pre>
       * Supervised fine-tuning validation dataset.
       * </pre>
       *
       * <code>SFT_VALIDATION = 2;</code>
       */
      SFT_VALIDATION(2),
      UNRECOGNIZED(-1),
      ;

      /**
       *
       *
       * <pre>
       * Default value. Should not be used.
       * </pre>
       *
       * <code>DATASET_USAGE_UNSPECIFIED = 0;</code>
       */
      public static final int DATASET_USAGE_UNSPECIFIED_VALUE = 0;

      /**
       *
       *
       * <pre>
       * Supervised fine-tuning training dataset.
       * </pre>
       *
       * <code>SFT_TRAINING = 1;</code>
       */
      public static final int SFT_TRAINING_VALUE = 1;

      /**
       *
       *
       * <pre>
       * Supervised fine-tuning validation dataset.
       * </pre>
       *
       * <code>SFT_VALIDATION = 2;</code>
       */
      public static final int SFT_VALIDATION_VALUE = 2;

      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static DatasetUsage valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static DatasetUsage forNumber(int value) {
        switch (value) {
          case 0:
            return DATASET_USAGE_UNSPECIFIED;
          case 1:
            return SFT_TRAINING;
          case 2:
            return SFT_VALIDATION;
          default:
            return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<DatasetUsage> internalGetValueMap() {
        return internalValueMap;
      }

      private static final com.google.protobuf.Internal.EnumLiteMap<DatasetUsage> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<DatasetUsage>() {
            public DatasetUsage findValueByNumber(int number) {
              return DatasetUsage.forNumber(number);
            }
          };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalStateException(
              "Can't get the descriptor of an unrecognized enum value.");
        }
        return getDescriptor().getValues().get(ordinal());
      }

      public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
        return getDescriptor();
      }

      public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1beta1.AssessDataRequest
            .TuningValidationAssessmentConfig.getDescriptor()
            .getEnumTypes()
            .get(0);
      }

      private static final DatasetUsage[] VALUES = values();

      public static DatasetUsage valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private DatasetUsage(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:google.cloud.aiplatform.v1beta1.AssessDataRequest.TuningValidationAssessmentConfig.DatasetUsage)
    }

    public static final int MODEL_NAME_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object modelName_ = "";

    /**
     *
     *
     * <pre>
     * Required. The name of the model used for tuning.
     * </pre>
     *
     * <code>string model_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The modelName.
     */
    @java.lang.Override
    public java.lang.String getModelName() {
      java.lang.Object ref = modelName_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        modelName_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The name of the model used for tuning.
     * </pre>
     *
     * <code>string model_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for modelName.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getModelNameBytes() {
      java.lang.Object ref = modelName_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        modelName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int DATASET_USAGE_FIELD_NUMBER = 2;
    private int datasetUsage_ = 0;

    /**
     *
     *
     * <pre>
     * Required. The dataset usage (e.g. training/validation).
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.AssessDataRequest.TuningValidationAssessmentConfig.DatasetUsage dataset_usage = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The enum numeric value on the wire for datasetUsage.
     */
    @java.lang.Override
    public int getDatasetUsageValue() {
      return datasetUsage_;
    }

    /**
     *
     *
     * <pre>
     * Required. The dataset usage (e.g. training/validation).
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.AssessDataRequest.TuningValidationAssessmentConfig.DatasetUsage dataset_usage = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The datasetUsage.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.AssessDataRequest.TuningValidationAssessmentConfig
            .DatasetUsage
        getDatasetUsage() {
      com.google.cloud.aiplatform.v1beta1.AssessDataRequest.TuningValidationAssessmentConfig
              .DatasetUsage
          result =
              com.google.cloud.aiplatform.v1beta1.AssessDataRequest.TuningValidationAssessmentConfig
                  .DatasetUsage.forNumber(datasetUsage_);
      return result == null
          ? com.google.cloud.aiplatform.v1beta1.AssessDataRequest.TuningValidationAssessmentConfig
              .DatasetUsage.UNRECOGNIZED
          : result;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(modelName_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, modelName_);
      }
      if (datasetUsage_
          != com.google.cloud.aiplatform.v1beta1.AssessDataRequest.TuningValidationAssessmentConfig
              .DatasetUsage.DATASET_USAGE_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(2, datasetUsage_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(modelName_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, modelName_);
      }
      if (datasetUsage_
          != com.google.cloud.aiplatform.v1beta1.AssessDataRequest.TuningValidationAssessmentConfig
              .DatasetUsage.DATASET_USAGE_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(2, datasetUsage_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof
          com.google.cloud.aiplatform.v1beta1.AssessDataRequest.TuningValidationAssessmentConfig)) {
        return super.equals(obj);
      }
      com.google.cloud.aiplatform.v1beta1.AssessDataRequest.TuningValidationAssessmentConfig other =
          (com.google.cloud.aiplatform.v1beta1.AssessDataRequest.TuningValidationAssessmentConfig)
              obj;

      if (!getModelName().equals(other.getModelName())) return false;
      if (datasetUsage_ != other.datasetUsage_) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + MODEL_NAME_FIELD_NUMBER;
      hash = (53 * hash) + getModelName().hashCode();
      hash = (37 * hash) + DATASET_USAGE_FIELD_NUMBER;
      hash = (53 * hash) + datasetUsage_;
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.aiplatform.v1beta1.AssessDataRequest
            .TuningValidationAssessmentConfig
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.AssessDataRequest
            .TuningValidationAssessmentConfig
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.AssessDataRequest
            .TuningValidationAssessmentConfig
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.AssessDataRequest
            .TuningValidationAssessmentConfig
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.AssessDataRequest
            .TuningValidationAssessmentConfig
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.AssessDataRequest
            .TuningValidationAssessmentConfig
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.AssessDataRequest
            .TuningValidationAssessmentConfig
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.AssessDataRequest
            .TuningValidationAssessmentConfig
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.AssessDataRequest
            .TuningValidationAssessmentConfig
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.AssessDataRequest
            .TuningValidationAssessmentConfig
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.AssessDataRequest
            .TuningValidationAssessmentConfig
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.AssessDataRequest
            .TuningValidationAssessmentConfig
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.aiplatform.v1beta1.AssessDataRequest.TuningValidationAssessmentConfig
            prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * Configuration for the tuning validation assessment.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.aiplatform.v1beta1.AssessDataRequest.TuningValidationAssessmentConfig}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.AssessDataRequest.TuningValidationAssessmentConfig)
        com.google.cloud.aiplatform.v1beta1.AssessDataRequest
            .TuningValidationAssessmentConfigOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1beta1.DatasetServiceProto
            .internal_static_google_cloud_aiplatform_v1beta1_AssessDataRequest_TuningValidationAssessmentConfig_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1beta1.DatasetServiceProto
            .internal_static_google_cloud_aiplatform_v1beta1_AssessDataRequest_TuningValidationAssessmentConfig_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1beta1.AssessDataRequest
                    .TuningValidationAssessmentConfig.class,
                com.google.cloud.aiplatform.v1beta1.AssessDataRequest
                    .TuningValidationAssessmentConfig.Builder.class);
      }

      // Construct using
      // com.google.cloud.aiplatform.v1beta1.AssessDataRequest.TuningValidationAssessmentConfig.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        modelName_ = "";
        datasetUsage_ = 0;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.aiplatform.v1beta1.DatasetServiceProto
            .internal_static_google_cloud_aiplatform_v1beta1_AssessDataRequest_TuningValidationAssessmentConfig_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.AssessDataRequest.TuningValidationAssessmentConfig
          getDefaultInstanceForType() {
        return com.google.cloud.aiplatform.v1beta1.AssessDataRequest
            .TuningValidationAssessmentConfig.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.AssessDataRequest.TuningValidationAssessmentConfig
          build() {
        com.google.cloud.aiplatform.v1beta1.AssessDataRequest.TuningValidationAssessmentConfig
            result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.AssessDataRequest.TuningValidationAssessmentConfig
          buildPartial() {
        com.google.cloud.aiplatform.v1beta1.AssessDataRequest.TuningValidationAssessmentConfig
            result =
                new com.google.cloud.aiplatform.v1beta1.AssessDataRequest
                    .TuningValidationAssessmentConfig(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.aiplatform.v1beta1.AssessDataRequest.TuningValidationAssessmentConfig
              result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.modelName_ = modelName_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.datasetUsage_ = datasetUsage_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.cloud.aiplatform.v1beta1.AssessDataRequest
                .TuningValidationAssessmentConfig) {
          return mergeFrom(
              (com.google.cloud.aiplatform.v1beta1.AssessDataRequest
                      .TuningValidationAssessmentConfig)
                  other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.aiplatform.v1beta1.AssessDataRequest.TuningValidationAssessmentConfig
              other) {
        if (other
            == com.google.cloud.aiplatform.v1beta1.AssessDataRequest
                .TuningValidationAssessmentConfig.getDefaultInstance()) return this;
        if (!other.getModelName().isEmpty()) {
          modelName_ = other.modelName_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (other.datasetUsage_ != 0) {
          setDatasetUsageValue(other.getDatasetUsageValue());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  modelName_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 16:
                {
                  datasetUsage_ = input.readEnum();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 16
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object modelName_ = "";

      /**
       *
       *
       * <pre>
       * Required. The name of the model used for tuning.
       * </pre>
       *
       * <code>string model_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The modelName.
       */
      public java.lang.String getModelName() {
        java.lang.Object ref = modelName_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          modelName_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Required. The name of the model used for tuning.
       * </pre>
       *
       * <code>string model_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for modelName.
       */
      public com.google.protobuf.ByteString getModelNameBytes() {
        java.lang.Object ref = modelName_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          modelName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Required. The name of the model used for tuning.
       * </pre>
       *
       * <code>string model_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The modelName to set.
       * @return This builder for chaining.
       */
      public Builder setModelName(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        modelName_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required. The name of the model used for tuning.
       * </pre>
       *
       * <code>string model_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearModelName() {
        modelName_ = getDefaultInstance().getModelName();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required. The name of the model used for tuning.
       * </pre>
       *
       * <code>string model_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bytes for modelName to set.
       * @return This builder for chaining.
       */
      public Builder setModelNameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        modelName_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private int datasetUsage_ = 0;

      /**
       *
       *
       * <pre>
       * Required. The dataset usage (e.g. training/validation).
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.AssessDataRequest.TuningValidationAssessmentConfig.DatasetUsage dataset_usage = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return The enum numeric value on the wire for datasetUsage.
       */
      @java.lang.Override
      public int getDatasetUsageValue() {
        return datasetUsage_;
      }

      /**
       *
       *
       * <pre>
       * Required. The dataset usage (e.g. training/validation).
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.AssessDataRequest.TuningValidationAssessmentConfig.DatasetUsage dataset_usage = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @param value The enum numeric value on the wire for datasetUsage to set.
       * @return This builder for chaining.
       */
      public Builder setDatasetUsageValue(int value) {
        datasetUsage_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required. The dataset usage (e.g. training/validation).
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.AssessDataRequest.TuningValidationAssessmentConfig.DatasetUsage dataset_usage = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return The datasetUsage.
       */
      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.AssessDataRequest.TuningValidationAssessmentConfig
              .DatasetUsage
          getDatasetUsage() {
        com.google.cloud.aiplatform.v1beta1.AssessDataRequest.TuningValidationAssessmentConfig
                .DatasetUsage
            result =
                com.google.cloud.aiplatform.v1beta1.AssessDataRequest
                    .TuningValidationAssessmentConfig.DatasetUsage.forNumber(datasetUsage_);
        return result == null
            ? com.google.cloud.aiplatform.v1beta1.AssessDataRequest.TuningValidationAssessmentConfig
                .DatasetUsage.UNRECOGNIZED
            : result;
      }

      /**
       *
       *
       * <pre>
       * Required. The dataset usage (e.g. training/validation).
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.AssessDataRequest.TuningValidationAssessmentConfig.DatasetUsage dataset_usage = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @param value The datasetUsage to set.
       * @return This builder for chaining.
       */
      public Builder setDatasetUsage(
          com.google.cloud.aiplatform.v1beta1.AssessDataRequest.TuningValidationAssessmentConfig
                  .DatasetUsage
              value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000002;
        datasetUsage_ = value.getNumber();
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required. The dataset usage (e.g. training/validation).
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.AssessDataRequest.TuningValidationAssessmentConfig.DatasetUsage dataset_usage = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearDatasetUsage() {
        bitField0_ = (bitField0_ & ~0x00000002);
        datasetUsage_ = 0;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.AssessDataRequest.TuningValidationAssessmentConfig)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.AssessDataRequest.TuningValidationAssessmentConfig)
    private static final com.google.cloud.aiplatform.v1beta1.AssessDataRequest
            .TuningValidationAssessmentConfig
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.aiplatform.v1beta1.AssessDataRequest
              .TuningValidationAssessmentConfig();
    }

    public static com.google.cloud.aiplatform.v1beta1.AssessDataRequest
            .TuningValidationAssessmentConfig
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<TuningValidationAssessmentConfig> PARSER =
        new com.google.protobuf.AbstractParser<TuningValidationAssessmentConfig>() {
          @java.lang.Override
          public TuningValidationAssessmentConfig parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<TuningValidationAssessmentConfig> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<TuningValidationAssessmentConfig> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.AssessDataRequest.TuningValidationAssessmentConfig
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface TuningResourceUsageAssessmentConfigOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1beta1.AssessDataRequest.TuningResourceUsageAssessmentConfig)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. The name of the model used for tuning.
     * </pre>
     *
     * <code>string model_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The modelName.
     */
    java.lang.String getModelName();

    /**
     *
     *
     * <pre>
     * Required. The name of the model used for tuning.
     * </pre>
     *
     * <code>string model_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for modelName.
     */
    com.google.protobuf.ByteString getModelNameBytes();
  }

  /**
   *
   *
   * <pre>
   * Configuration for the tuning resource usage assessment.
   * </pre>
   *
   * Protobuf type {@code
   * google.cloud.aiplatform.v1beta1.AssessDataRequest.TuningResourceUsageAssessmentConfig}
   */
  public static final class TuningResourceUsageAssessmentConfig
      extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.AssessDataRequest.TuningResourceUsageAssessmentConfig)
      TuningResourceUsageAssessmentConfigOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use TuningResourceUsageAssessmentConfig.newBuilder() to construct.
    private TuningResourceUsageAssessmentConfig(
        com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private TuningResourceUsageAssessmentConfig() {
      modelName_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new TuningResourceUsageAssessmentConfig();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.DatasetServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_AssessDataRequest_TuningResourceUsageAssessmentConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.DatasetServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_AssessDataRequest_TuningResourceUsageAssessmentConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.AssessDataRequest
                  .TuningResourceUsageAssessmentConfig.class,
              com.google.cloud.aiplatform.v1beta1.AssessDataRequest
                  .TuningResourceUsageAssessmentConfig.Builder.class);
    }

    public static final int MODEL_NAME_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object modelName_ = "";

    /**
     *
     *
     * <pre>
     * Required. The name of the model used for tuning.
     * </pre>
     *
     * <code>string model_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The modelName.
     */
    @java.lang.Override
    public java.lang.String getModelName() {
      java.lang.Object ref = modelName_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        modelName_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The name of the model used for tuning.
     * </pre>
     *
     * <code>string model_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for modelName.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getModelNameBytes() {
      java.lang.Object ref = modelName_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        modelName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(modelName_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, modelName_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(modelName_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, modelName_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof
          com.google.cloud.aiplatform.v1beta1.AssessDataRequest
              .TuningResourceUsageAssessmentConfig)) {
        return super.equals(obj);
      }
      com.google.cloud.aiplatform.v1beta1.AssessDataRequest.TuningResourceUsageAssessmentConfig
          other =
              (com.google.cloud.aiplatform.v1beta1.AssessDataRequest
                      .TuningResourceUsageAssessmentConfig)
                  obj;

      if (!getModelName().equals(other.getModelName())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + MODEL_NAME_FIELD_NUMBER;
      hash = (53 * hash) + getModelName().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.aiplatform.v1beta1.AssessDataRequest
            .TuningResourceUsageAssessmentConfig
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.AssessDataRequest
            .TuningResourceUsageAssessmentConfig
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.AssessDataRequest
            .TuningResourceUsageAssessmentConfig
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.AssessDataRequest
            .TuningResourceUsageAssessmentConfig
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.AssessDataRequest
            .TuningResourceUsageAssessmentConfig
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.AssessDataRequest
            .TuningResourceUsageAssessmentConfig
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.AssessDataRequest
            .TuningResourceUsageAssessmentConfig
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.AssessDataRequest
            .TuningResourceUsageAssessmentConfig
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.AssessDataRequest
            .TuningResourceUsageAssessmentConfig
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.AssessDataRequest
            .TuningResourceUsageAssessmentConfig
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.AssessDataRequest
            .TuningResourceUsageAssessmentConfig
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.AssessDataRequest
            .TuningResourceUsageAssessmentConfig
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.aiplatform.v1beta1.AssessDataRequest.TuningResourceUsageAssessmentConfig
            prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * Configuration for the tuning resource usage assessment.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.aiplatform.v1beta1.AssessDataRequest.TuningResourceUsageAssessmentConfig}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.AssessDataRequest.TuningResourceUsageAssessmentConfig)
        com.google.cloud.aiplatform.v1beta1.AssessDataRequest
            .TuningResourceUsageAssessmentConfigOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1beta1.DatasetServiceProto
            .internal_static_google_cloud_aiplatform_v1beta1_AssessDataRequest_TuningResourceUsageAssessmentConfig_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1beta1.DatasetServiceProto
            .internal_static_google_cloud_aiplatform_v1beta1_AssessDataRequest_TuningResourceUsageAssessmentConfig_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1beta1.AssessDataRequest
                    .TuningResourceUsageAssessmentConfig.class,
                com.google.cloud.aiplatform.v1beta1.AssessDataRequest
                    .TuningResourceUsageAssessmentConfig.Builder.class);
      }

      // Construct using
      // com.google.cloud.aiplatform.v1beta1.AssessDataRequest.TuningResourceUsageAssessmentConfig.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        modelName_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.aiplatform.v1beta1.DatasetServiceProto
            .internal_static_google_cloud_aiplatform_v1beta1_AssessDataRequest_TuningResourceUsageAssessmentConfig_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.AssessDataRequest
              .TuningResourceUsageAssessmentConfig
          getDefaultInstanceForType() {
        return com.google.cloud.aiplatform.v1beta1.AssessDataRequest
            .TuningResourceUsageAssessmentConfig.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.AssessDataRequest
              .TuningResourceUsageAssessmentConfig
          build() {
        com.google.cloud.aiplatform.v1beta1.AssessDataRequest.TuningResourceUsageAssessmentConfig
            result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.AssessDataRequest
              .TuningResourceUsageAssessmentConfig
          buildPartial() {
        com.google.cloud.aiplatform.v1beta1.AssessDataRequest.TuningResourceUsageAssessmentConfig
            result =
                new com.google.cloud.aiplatform.v1beta1.AssessDataRequest
                    .TuningResourceUsageAssessmentConfig(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.aiplatform.v1beta1.AssessDataRequest.TuningResourceUsageAssessmentConfig
              result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.modelName_ = modelName_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.cloud.aiplatform.v1beta1.AssessDataRequest
                .TuningResourceUsageAssessmentConfig) {
          return mergeFrom(
              (com.google.cloud.aiplatform.v1beta1.AssessDataRequest
                      .TuningResourceUsageAssessmentConfig)
                  other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.aiplatform.v1beta1.AssessDataRequest.TuningResourceUsageAssessmentConfig
              other) {
        if (other
            == com.google.cloud.aiplatform.v1beta1.AssessDataRequest
                .TuningResourceUsageAssessmentConfig.getDefaultInstance()) return this;
        if (!other.getModelName().isEmpty()) {
          modelName_ = other.modelName_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  modelName_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object modelName_ = "";

      /**
       *
       *
       * <pre>
       * Required. The name of the model used for tuning.
       * </pre>
       *
       * <code>string model_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The modelName.
       */
      public java.lang.String getModelName() {
        java.lang.Object ref = modelName_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          modelName_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Required. The name of the model used for tuning.
       * </pre>
       *
       * <code>string model_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for modelName.
       */
      public com.google.protobuf.ByteString getModelNameBytes() {
        java.lang.Object ref = modelName_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          modelName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Required. The name of the model used for tuning.
       * </pre>
       *
       * <code>string model_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The modelName to set.
       * @return This builder for chaining.
       */
      public Builder setModelName(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        modelName_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required. The name of the model used for tuning.
       * </pre>
       *
       * <code>string model_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearModelName() {
        modelName_ = getDefaultInstance().getModelName();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required. The name of the model used for tuning.
       * </pre>
       *
       * <code>string model_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bytes for modelName to set.
       * @return This builder for chaining.
       */
      public Builder setModelNameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        modelName_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.AssessDataRequest.TuningResourceUsageAssessmentConfig)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.AssessDataRequest.TuningResourceUsageAssessmentConfig)
    private static final com.google.cloud.aiplatform.v1beta1.AssessDataRequest
            .TuningResourceUsageAssessmentConfig
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.aiplatform.v1beta1.AssessDataRequest
              .TuningResourceUsageAssessmentConfig();
    }

    public static com.google.cloud.aiplatform.v1beta1.AssessDataRequest
            .TuningResourceUsageAssessmentConfig
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<TuningResourceUsageAssessmentConfig> PARSER =
        new com.google.protobuf.AbstractParser<TuningResourceUsageAssessmentConfig>() {
          @java.lang.Override
          public TuningResourceUsageAssessmentConfig parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<TuningResourceUsageAssessmentConfig> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<TuningResourceUsageAssessmentConfig> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.AssessDataRequest.TuningResourceUsageAssessmentConfig
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface BatchPredictionValidationAssessmentConfigOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1beta1.AssessDataRequest.BatchPredictionValidationAssessmentConfig)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. The name of the model used for batch prediction.
     * </pre>
     *
     * <code>string model_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The modelName.
     */
    java.lang.String getModelName();

    /**
     *
     *
     * <pre>
     * Required. The name of the model used for batch prediction.
     * </pre>
     *
     * <code>string model_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for modelName.
     */
    com.google.protobuf.ByteString getModelNameBytes();
  }

  /**
   *
   *
   * <pre>
   * Configuration for the batch prediction validation assessment.
   * </pre>
   *
   * Protobuf type {@code
   * google.cloud.aiplatform.v1beta1.AssessDataRequest.BatchPredictionValidationAssessmentConfig}
   */
  public static final class BatchPredictionValidationAssessmentConfig
      extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.AssessDataRequest.BatchPredictionValidationAssessmentConfig)
      BatchPredictionValidationAssessmentConfigOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use BatchPredictionValidationAssessmentConfig.newBuilder() to construct.
    private BatchPredictionValidationAssessmentConfig(
        com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private BatchPredictionValidationAssessmentConfig() {
      modelName_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new BatchPredictionValidationAssessmentConfig();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.DatasetServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_AssessDataRequest_BatchPredictionValidationAssessmentConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.DatasetServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_AssessDataRequest_BatchPredictionValidationAssessmentConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.AssessDataRequest
                  .BatchPredictionValidationAssessmentConfig.class,
              com.google.cloud.aiplatform.v1beta1.AssessDataRequest
                  .BatchPredictionValidationAssessmentConfig.Builder.class);
    }

    public static final int MODEL_NAME_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object modelName_ = "";

    /**
     *
     *
     * <pre>
     * Required. The name of the model used for batch prediction.
     * </pre>
     *
     * <code>string model_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The modelName.
     */
    @java.lang.Override
    public java.lang.String getModelName() {
      java.lang.Object ref = modelName_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        modelName_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The name of the model used for batch prediction.
     * </pre>
     *
     * <code>string model_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for modelName.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getModelNameBytes() {
      java.lang.Object ref = modelName_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        modelName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(modelName_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, modelName_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(modelName_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, modelName_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof
          com.google.cloud.aiplatform.v1beta1.AssessDataRequest
              .BatchPredictionValidationAssessmentConfig)) {
        return super.equals(obj);
      }
      com.google.cloud.aiplatform.v1beta1.AssessDataRequest
              .BatchPredictionValidationAssessmentConfig
          other =
              (com.google.cloud.aiplatform.v1beta1.AssessDataRequest
                      .BatchPredictionValidationAssessmentConfig)
                  obj;

      if (!getModelName().equals(other.getModelName())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + MODEL_NAME_FIELD_NUMBER;
      hash = (53 * hash) + getModelName().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.aiplatform.v1beta1.AssessDataRequest
            .BatchPredictionValidationAssessmentConfig
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.AssessDataRequest
            .BatchPredictionValidationAssessmentConfig
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.AssessDataRequest
            .BatchPredictionValidationAssessmentConfig
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.AssessDataRequest
            .BatchPredictionValidationAssessmentConfig
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.AssessDataRequest
            .BatchPredictionValidationAssessmentConfig
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.AssessDataRequest
            .BatchPredictionValidationAssessmentConfig
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.AssessDataRequest
            .BatchPredictionValidationAssessmentConfig
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.AssessDataRequest
            .BatchPredictionValidationAssessmentConfig
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.AssessDataRequest
            .BatchPredictionValidationAssessmentConfig
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.AssessDataRequest
            .BatchPredictionValidationAssessmentConfig
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.AssessDataRequest
            .BatchPredictionValidationAssessmentConfig
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.AssessDataRequest
            .BatchPredictionValidationAssessmentConfig
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.aiplatform.v1beta1.AssessDataRequest
                .BatchPredictionValidationAssessmentConfig
            prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * Configuration for the batch prediction validation assessment.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.aiplatform.v1beta1.AssessDataRequest.BatchPredictionValidationAssessmentConfig}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.AssessDataRequest.BatchPredictionValidationAssessmentConfig)
        com.google.cloud.aiplatform.v1beta1.AssessDataRequest
            .BatchPredictionValidationAssessmentConfigOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1beta1.DatasetServiceProto
            .internal_static_google_cloud_aiplatform_v1beta1_AssessDataRequest_BatchPredictionValidationAssessmentConfig_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1beta1.DatasetServiceProto
            .internal_static_google_cloud_aiplatform_v1beta1_AssessDataRequest_BatchPredictionValidationAssessmentConfig_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1beta1.AssessDataRequest
                    .BatchPredictionValidationAssessmentConfig.class,
                com.google.cloud.aiplatform.v1beta1.AssessDataRequest
                    .BatchPredictionValidationAssessmentConfig.Builder.class);
      }

      // Construct using
      // com.google.cloud.aiplatform.v1beta1.AssessDataRequest.BatchPredictionValidationAssessmentConfig.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        modelName_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.aiplatform.v1beta1.DatasetServiceProto
            .internal_static_google_cloud_aiplatform_v1beta1_AssessDataRequest_BatchPredictionValidationAssessmentConfig_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.AssessDataRequest
              .BatchPredictionValidationAssessmentConfig
          getDefaultInstanceForType() {
        return com.google.cloud.aiplatform.v1beta1.AssessDataRequest
            .BatchPredictionValidationAssessmentConfig.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.AssessDataRequest
              .BatchPredictionValidationAssessmentConfig
          build() {
        com.google.cloud.aiplatform.v1beta1.AssessDataRequest
                .BatchPredictionValidationAssessmentConfig
            result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.AssessDataRequest
              .BatchPredictionValidationAssessmentConfig
          buildPartial() {
        com.google.cloud.aiplatform.v1beta1.AssessDataRequest
                .BatchPredictionValidationAssessmentConfig
            result =
                new com.google.cloud.aiplatform.v1beta1.AssessDataRequest
                    .BatchPredictionValidationAssessmentConfig(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.aiplatform.v1beta1.AssessDataRequest
                  .BatchPredictionValidationAssessmentConfig
              result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.modelName_ = modelName_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.cloud.aiplatform.v1beta1.AssessDataRequest
                .BatchPredictionValidationAssessmentConfig) {
          return mergeFrom(
              (com.google.cloud.aiplatform.v1beta1.AssessDataRequest
                      .BatchPredictionValidationAssessmentConfig)
                  other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.aiplatform.v1beta1.AssessDataRequest
                  .BatchPredictionValidationAssessmentConfig
              other) {
        if (other
            == com.google.cloud.aiplatform.v1beta1.AssessDataRequest
                .BatchPredictionValidationAssessmentConfig.getDefaultInstance()) return this;
        if (!other.getModelName().isEmpty()) {
          modelName_ = other.modelName_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  modelName_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object modelName_ = "";

      /**
       *
       *
       * <pre>
       * Required. The name of the model used for batch prediction.
       * </pre>
       *
       * <code>string model_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The modelName.
       */
      public java.lang.String getModelName() {
        java.lang.Object ref = modelName_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          modelName_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Required. The name of the model used for batch prediction.
       * </pre>
       *
       * <code>string model_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for modelName.
       */
      public com.google.protobuf.ByteString getModelNameBytes() {
        java.lang.Object ref = modelName_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          modelName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Required. The name of the model used for batch prediction.
       * </pre>
       *
       * <code>string model_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The modelName to set.
       * @return This builder for chaining.
       */
      public Builder setModelName(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        modelName_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required. The name of the model used for batch prediction.
       * </pre>
       *
       * <code>string model_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearModelName() {
        modelName_ = getDefaultInstance().getModelName();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required. The name of the model used for batch prediction.
       * </pre>
       *
       * <code>string model_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bytes for modelName to set.
       * @return This builder for chaining.
       */
      public Builder setModelNameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        modelName_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.AssessDataRequest.BatchPredictionValidationAssessmentConfig)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.AssessDataRequest.BatchPredictionValidationAssessmentConfig)
    private static final com.google.cloud.aiplatform.v1beta1.AssessDataRequest
            .BatchPredictionValidationAssessmentConfig
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.aiplatform.v1beta1.AssessDataRequest
              .BatchPredictionValidationAssessmentConfig();
    }

    public static com.google.cloud.aiplatform.v1beta1.AssessDataRequest
            .BatchPredictionValidationAssessmentConfig
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<BatchPredictionValidationAssessmentConfig>
        PARSER =
            new com.google.protobuf.AbstractParser<BatchPredictionValidationAssessmentConfig>() {
              @java.lang.Override
              public BatchPredictionValidationAssessmentConfig parsePartialFrom(
                  com.google.protobuf.CodedInputStream input,
                  com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                  throws com.google.protobuf.InvalidProtocolBufferException {
                Builder builder = newBuilder();
                try {
                  builder.mergeFrom(input, extensionRegistry);
                } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                  throw e.setUnfinishedMessage(builder.buildPartial());
                } catch (com.google.protobuf.UninitializedMessageException e) {
                  throw e.asInvalidProtocolBufferException()
                      .setUnfinishedMessage(builder.buildPartial());
                } catch (java.io.IOException e) {
                  throw new com.google.protobuf.InvalidProtocolBufferException(e)
                      .setUnfinishedMessage(builder.buildPartial());
                }
                return builder.buildPartial();
              }
            };

    public static com.google.protobuf.Parser<BatchPredictionValidationAssessmentConfig> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<BatchPredictionValidationAssessmentConfig>
        getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.AssessDataRequest
            .BatchPredictionValidationAssessmentConfig
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface BatchPredictionResourceUsageAssessmentConfigOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1beta1.AssessDataRequest.BatchPredictionResourceUsageAssessmentConfig)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. The name of the model used for batch prediction.
     * </pre>
     *
     * <code>string model_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The modelName.
     */
    java.lang.String getModelName();

    /**
     *
     *
     * <pre>
     * Required. The name of the model used for batch prediction.
     * </pre>
     *
     * <code>string model_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for modelName.
     */
    com.google.protobuf.ByteString getModelNameBytes();
  }

  /**
   *
   *
   * <pre>
   * Configuration for the batch prediction resource usage assessment.
   * </pre>
   *
   * Protobuf type {@code
   * google.cloud.aiplatform.v1beta1.AssessDataRequest.BatchPredictionResourceUsageAssessmentConfig}
   */
  public static final class BatchPredictionResourceUsageAssessmentConfig
      extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.AssessDataRequest.BatchPredictionResourceUsageAssessmentConfig)
      BatchPredictionResourceUsageAssessmentConfigOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use BatchPredictionResourceUsageAssessmentConfig.newBuilder() to construct.
    private BatchPredictionResourceUsageAssessmentConfig(
        com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private BatchPredictionResourceUsageAssessmentConfig() {
      modelName_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new BatchPredictionResourceUsageAssessmentConfig();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.DatasetServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_AssessDataRequest_BatchPredictionResourceUsageAssessmentConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.DatasetServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_AssessDataRequest_BatchPredictionResourceUsageAssessmentConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.AssessDataRequest
                  .BatchPredictionResourceUsageAssessmentConfig.class,
              com.google.cloud.aiplatform.v1beta1.AssessDataRequest
                  .BatchPredictionResourceUsageAssessmentConfig.Builder.class);
    }

    public static final int MODEL_NAME_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object modelName_ = "";

    /**
     *
     *
     * <pre>
     * Required. The name of the model used for batch prediction.
     * </pre>
     *
     * <code>string model_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The modelName.
     */
    @java.lang.Override
    public java.lang.String getModelName() {
      java.lang.Object ref = modelName_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        modelName_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The name of the model used for batch prediction.
     * </pre>
     *
     * <code>string model_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for modelName.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getModelNameBytes() {
      java.lang.Object ref = modelName_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        modelName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(modelName_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, modelName_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(modelName_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, modelName_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof
          com.google.cloud.aiplatform.v1beta1.AssessDataRequest
              .BatchPredictionResourceUsageAssessmentConfig)) {
        return super.equals(obj);
      }
      com.google.cloud.aiplatform.v1beta1.AssessDataRequest
              .BatchPredictionResourceUsageAssessmentConfig
          other =
              (com.google.cloud.aiplatform.v1beta1.AssessDataRequest
                      .BatchPredictionResourceUsageAssessmentConfig)
                  obj;

      if (!getModelName().equals(other.getModelName())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + MODEL_NAME_FIELD_NUMBER;
      hash = (53 * hash) + getModelName().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.aiplatform.v1beta1.AssessDataRequest
            .BatchPredictionResourceUsageAssessmentConfig
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.AssessDataRequest
            .BatchPredictionResourceUsageAssessmentConfig
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.AssessDataRequest
            .BatchPredictionResourceUsageAssessmentConfig
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.AssessDataRequest
            .BatchPredictionResourceUsageAssessmentConfig
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.AssessDataRequest
            .BatchPredictionResourceUsageAssessmentConfig
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.AssessDataRequest
            .BatchPredictionResourceUsageAssessmentConfig
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.AssessDataRequest
            .BatchPredictionResourceUsageAssessmentConfig
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.AssessDataRequest
            .BatchPredictionResourceUsageAssessmentConfig
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.AssessDataRequest
            .BatchPredictionResourceUsageAssessmentConfig
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.AssessDataRequest
            .BatchPredictionResourceUsageAssessmentConfig
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.AssessDataRequest
            .BatchPredictionResourceUsageAssessmentConfig
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.AssessDataRequest
            .BatchPredictionResourceUsageAssessmentConfig
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.aiplatform.v1beta1.AssessDataRequest
                .BatchPredictionResourceUsageAssessmentConfig
            prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * Configuration for the batch prediction resource usage assessment.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.aiplatform.v1beta1.AssessDataRequest.BatchPredictionResourceUsageAssessmentConfig}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.AssessDataRequest.BatchPredictionResourceUsageAssessmentConfig)
        com.google.cloud.aiplatform.v1beta1.AssessDataRequest
            .BatchPredictionResourceUsageAssessmentConfigOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1beta1.DatasetServiceProto
            .internal_static_google_cloud_aiplatform_v1beta1_AssessDataRequest_BatchPredictionResourceUsageAssessmentConfig_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1beta1.DatasetServiceProto
            .internal_static_google_cloud_aiplatform_v1beta1_AssessDataRequest_BatchPredictionResourceUsageAssessmentConfig_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1beta1.AssessDataRequest
                    .BatchPredictionResourceUsageAssessmentConfig.class,
                com.google.cloud.aiplatform.v1beta1.AssessDataRequest
                    .BatchPredictionResourceUsageAssessmentConfig.Builder.class);
      }

      // Construct using
      // com.google.cloud.aiplatform.v1beta1.AssessDataRequest.BatchPredictionResourceUsageAssessmentConfig.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        modelName_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.aiplatform.v1beta1.DatasetServiceProto
            .internal_static_google_cloud_aiplatform_v1beta1_AssessDataRequest_BatchPredictionResourceUsageAssessmentConfig_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.AssessDataRequest
              .BatchPredictionResourceUsageAssessmentConfig
          getDefaultInstanceForType() {
        return com.google.cloud.aiplatform.v1beta1.AssessDataRequest
            .BatchPredictionResourceUsageAssessmentConfig.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.AssessDataRequest
              .BatchPredictionResourceUsageAssessmentConfig
          build() {
        com.google.cloud.aiplatform.v1beta1.AssessDataRequest
                .BatchPredictionResourceUsageAssessmentConfig
            result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.AssessDataRequest
              .BatchPredictionResourceUsageAssessmentConfig
          buildPartial() {
        com.google.cloud.aiplatform.v1beta1.AssessDataRequest
                .BatchPredictionResourceUsageAssessmentConfig
            result =
                new com.google.cloud.aiplatform.v1beta1.AssessDataRequest
                    .BatchPredictionResourceUsageAssessmentConfig(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.aiplatform.v1beta1.AssessDataRequest
                  .BatchPredictionResourceUsageAssessmentConfig
              result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.modelName_ = modelName_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.cloud.aiplatform.v1beta1.AssessDataRequest
                .BatchPredictionResourceUsageAssessmentConfig) {
          return mergeFrom(
              (com.google.cloud.aiplatform.v1beta1.AssessDataRequest
                      .BatchPredictionResourceUsageAssessmentConfig)
                  other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.aiplatform.v1beta1.AssessDataRequest
                  .BatchPredictionResourceUsageAssessmentConfig
              other) {
        if (other
            == com.google.cloud.aiplatform.v1beta1.AssessDataRequest
                .BatchPredictionResourceUsageAssessmentConfig.getDefaultInstance()) return this;
        if (!other.getModelName().isEmpty()) {
          modelName_ = other.modelName_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  modelName_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object modelName_ = "";

      /**
       *
       *
       * <pre>
       * Required. The name of the model used for batch prediction.
       * </pre>
       *
       * <code>string model_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The modelName.
       */
      public java.lang.String getModelName() {
        java.lang.Object ref = modelName_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          modelName_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Required. The name of the model used for batch prediction.
       * </pre>
       *
       * <code>string model_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for modelName.
       */
      public com.google.protobuf.ByteString getModelNameBytes() {
        java.lang.Object ref = modelName_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          modelName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Required. The name of the model used for batch prediction.
       * </pre>
       *
       * <code>string model_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The modelName to set.
       * @return This builder for chaining.
       */
      public Builder setModelName(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        modelName_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required. The name of the model used for batch prediction.
       * </pre>
       *
       * <code>string model_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearModelName() {
        modelName_ = getDefaultInstance().getModelName();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required. The name of the model used for batch prediction.
       * </pre>
       *
       * <code>string model_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bytes for modelName to set.
       * @return This builder for chaining.
       */
      public Builder setModelNameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        modelName_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.AssessDataRequest.BatchPredictionResourceUsageAssessmentConfig)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.AssessDataRequest.BatchPredictionResourceUsageAssessmentConfig)
    private static final com.google.cloud.aiplatform.v1beta1.AssessDataRequest
            .BatchPredictionResourceUsageAssessmentConfig
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.aiplatform.v1beta1.AssessDataRequest
              .BatchPredictionResourceUsageAssessmentConfig();
    }

    public static com.google.cloud.aiplatform.v1beta1.AssessDataRequest
            .BatchPredictionResourceUsageAssessmentConfig
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<BatchPredictionResourceUsageAssessmentConfig>
        PARSER =
            new com.google.protobuf.AbstractParser<BatchPredictionResourceUsageAssessmentConfig>() {
              @java.lang.Override
              public BatchPredictionResourceUsageAssessmentConfig parsePartialFrom(
                  com.google.protobuf.CodedInputStream input,
                  com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                  throws com.google.protobuf.InvalidProtocolBufferException {
                Builder builder = newBuilder();
                try {
                  builder.mergeFrom(input, extensionRegistry);
                } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                  throw e.setUnfinishedMessage(builder.buildPartial());
                } catch (com.google.protobuf.UninitializedMessageException e) {
                  throw e.asInvalidProtocolBufferException()
                      .setUnfinishedMessage(builder.buildPartial());
                } catch (java.io.IOException e) {
                  throw new com.google.protobuf.InvalidProtocolBufferException(e)
                      .setUnfinishedMessage(builder.buildPartial());
                }
                return builder.buildPartial();
              }
            };

    public static com.google.protobuf.Parser<BatchPredictionResourceUsageAssessmentConfig>
        parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<BatchPredictionResourceUsageAssessmentConfig>
        getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.AssessDataRequest
            .BatchPredictionResourceUsageAssessmentConfig
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  private int assessmentConfigCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object assessmentConfig_;

  public enum AssessmentConfigCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    TUNING_VALIDATION_ASSESSMENT_CONFIG(2),
    TUNING_RESOURCE_USAGE_ASSESSMENT_CONFIG(3),
    BATCH_PREDICTION_VALIDATION_ASSESSMENT_CONFIG(6),
    BATCH_PREDICTION_RESOURCE_USAGE_ASSESSMENT_CONFIG(7),
    ASSESSMENTCONFIG_NOT_SET(0);
    private final int value;

    private AssessmentConfigCase(int value) {
      this.value = value;
    }

    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static AssessmentConfigCase valueOf(int value) {
      return forNumber(value);
    }

    public static AssessmentConfigCase forNumber(int value) {
      switch (value) {
        case 2:
          return TUNING_VALIDATION_ASSESSMENT_CONFIG;
        case 3:
          return TUNING_RESOURCE_USAGE_ASSESSMENT_CONFIG;
        case 6:
          return BATCH_PREDICTION_VALIDATION_ASSESSMENT_CONFIG;
        case 7:
          return BATCH_PREDICTION_RESOURCE_USAGE_ASSESSMENT_CONFIG;
        case 0:
          return ASSESSMENTCONFIG_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public AssessmentConfigCase getAssessmentConfigCase() {
    return AssessmentConfigCase.forNumber(assessmentConfigCase_);
  }

  private int readConfigCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object readConfig_;

  public enum ReadConfigCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    GEMINI_TEMPLATE_CONFIG(4),
    REQUEST_COLUMN_NAME(5),
    READCONFIG_NOT_SET(0);
    private final int value;

    private ReadConfigCase(int value) {
      this.value = value;
    }

    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ReadConfigCase valueOf(int value) {
      return forNumber(value);
    }

    public static ReadConfigCase forNumber(int value) {
      switch (value) {
        case 4:
          return GEMINI_TEMPLATE_CONFIG;
        case 5:
          return REQUEST_COLUMN_NAME;
        case 0:
          return READCONFIG_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public ReadConfigCase getReadConfigCase() {
    return ReadConfigCase.forNumber(readConfigCase_);
  }

  public static final int TUNING_VALIDATION_ASSESSMENT_CONFIG_FIELD_NUMBER = 2;

  /**
   *
   *
   * <pre>
   * Optional. Configuration for the tuning validation assessment.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.AssessDataRequest.TuningValidationAssessmentConfig tuning_validation_assessment_config = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the tuningValidationAssessmentConfig field is set.
   */
  @java.lang.Override
  public boolean hasTuningValidationAssessmentConfig() {
    return assessmentConfigCase_ == 2;
  }

  /**
   *
   *
   * <pre>
   * Optional. Configuration for the tuning validation assessment.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.AssessDataRequest.TuningValidationAssessmentConfig tuning_validation_assessment_config = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The tuningValidationAssessmentConfig.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.AssessDataRequest.TuningValidationAssessmentConfig
      getTuningValidationAssessmentConfig() {
    if (assessmentConfigCase_ == 2) {
      return (com.google.cloud.aiplatform.v1beta1.AssessDataRequest
              .TuningValidationAssessmentConfig)
          assessmentConfig_;
    }
    return com.google.cloud.aiplatform.v1beta1.AssessDataRequest.TuningValidationAssessmentConfig
        .getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * Optional. Configuration for the tuning validation assessment.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.AssessDataRequest.TuningValidationAssessmentConfig tuning_validation_assessment_config = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.AssessDataRequest
          .TuningValidationAssessmentConfigOrBuilder
      getTuningValidationAssessmentConfigOrBuilder() {
    if (assessmentConfigCase_ == 2) {
      return (com.google.cloud.aiplatform.v1beta1.AssessDataRequest
              .TuningValidationAssessmentConfig)
          assessmentConfig_;
    }
    return com.google.cloud.aiplatform.v1beta1.AssessDataRequest.TuningValidationAssessmentConfig
        .getDefaultInstance();
  }

  public static final int TUNING_RESOURCE_USAGE_ASSESSMENT_CONFIG_FIELD_NUMBER = 3;

  /**
   *
   *
   * <pre>
   * Optional. Configuration for the tuning resource usage assessment.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.AssessDataRequest.TuningResourceUsageAssessmentConfig tuning_resource_usage_assessment_config = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the tuningResourceUsageAssessmentConfig field is set.
   */
  @java.lang.Override
  public boolean hasTuningResourceUsageAssessmentConfig() {
    return assessmentConfigCase_ == 3;
  }

  /**
   *
   *
   * <pre>
   * Optional. Configuration for the tuning resource usage assessment.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.AssessDataRequest.TuningResourceUsageAssessmentConfig tuning_resource_usage_assessment_config = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The tuningResourceUsageAssessmentConfig.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.AssessDataRequest.TuningResourceUsageAssessmentConfig
      getTuningResourceUsageAssessmentConfig() {
    if (assessmentConfigCase_ == 3) {
      return (com.google.cloud.aiplatform.v1beta1.AssessDataRequest
              .TuningResourceUsageAssessmentConfig)
          assessmentConfig_;
    }
    return com.google.cloud.aiplatform.v1beta1.AssessDataRequest.TuningResourceUsageAssessmentConfig
        .getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * Optional. Configuration for the tuning resource usage assessment.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.AssessDataRequest.TuningResourceUsageAssessmentConfig tuning_resource_usage_assessment_config = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.AssessDataRequest
          .TuningResourceUsageAssessmentConfigOrBuilder
      getTuningResourceUsageAssessmentConfigOrBuilder() {
    if (assessmentConfigCase_ == 3) {
      return (com.google.cloud.aiplatform.v1beta1.AssessDataRequest
              .TuningResourceUsageAssessmentConfig)
          assessmentConfig_;
    }
    return com.google.cloud.aiplatform.v1beta1.AssessDataRequest.TuningResourceUsageAssessmentConfig
        .getDefaultInstance();
  }

  public static final int BATCH_PREDICTION_VALIDATION_ASSESSMENT_CONFIG_FIELD_NUMBER = 6;

  /**
   *
   *
   * <pre>
   * Optional. Configuration for the batch prediction validation assessment.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.AssessDataRequest.BatchPredictionValidationAssessmentConfig batch_prediction_validation_assessment_config = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the batchPredictionValidationAssessmentConfig field is set.
   */
  @java.lang.Override
  public boolean hasBatchPredictionValidationAssessmentConfig() {
    return assessmentConfigCase_ == 6;
  }

  /**
   *
   *
   * <pre>
   * Optional. Configuration for the batch prediction validation assessment.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.AssessDataRequest.BatchPredictionValidationAssessmentConfig batch_prediction_validation_assessment_config = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The batchPredictionValidationAssessmentConfig.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.AssessDataRequest
          .BatchPredictionValidationAssessmentConfig
      getBatchPredictionValidationAssessmentConfig() {
    if (assessmentConfigCase_ == 6) {
      return (com.google.cloud.aiplatform.v1beta1.AssessDataRequest
              .BatchPredictionValidationAssessmentConfig)
          assessmentConfig_;
    }
    return com.google.cloud.aiplatform.v1beta1.AssessDataRequest
        .BatchPredictionValidationAssessmentConfig.getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * Optional. Configuration for the batch prediction validation assessment.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.AssessDataRequest.BatchPredictionValidationAssessmentConfig batch_prediction_validation_assessment_config = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.AssessDataRequest
          .BatchPredictionValidationAssessmentConfigOrBuilder
      getBatchPredictionValidationAssessmentConfigOrBuilder() {
    if (assessmentConfigCase_ == 6) {
      return (com.google.cloud.aiplatform.v1beta1.AssessDataRequest
              .BatchPredictionValidationAssessmentConfig)
          assessmentConfig_;
    }
    return com.google.cloud.aiplatform.v1beta1.AssessDataRequest
        .BatchPredictionValidationAssessmentConfig.getDefaultInstance();
  }

  public static final int BATCH_PREDICTION_RESOURCE_USAGE_ASSESSMENT_CONFIG_FIELD_NUMBER = 7;

  /**
   *
   *
   * <pre>
   * Optional. Configuration for the batch prediction resource usage
   * assessment.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.AssessDataRequest.BatchPredictionResourceUsageAssessmentConfig batch_prediction_resource_usage_assessment_config = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the batchPredictionResourceUsageAssessmentConfig field is set.
   */
  @java.lang.Override
  public boolean hasBatchPredictionResourceUsageAssessmentConfig() {
    return assessmentConfigCase_ == 7;
  }

  /**
   *
   *
   * <pre>
   * Optional. Configuration for the batch prediction resource usage
   * assessment.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.AssessDataRequest.BatchPredictionResourceUsageAssessmentConfig batch_prediction_resource_usage_assessment_config = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The batchPredictionResourceUsageAssessmentConfig.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.AssessDataRequest
          .BatchPredictionResourceUsageAssessmentConfig
      getBatchPredictionResourceUsageAssessmentConfig() {
    if (assessmentConfigCase_ == 7) {
      return (com.google.cloud.aiplatform.v1beta1.AssessDataRequest
              .BatchPredictionResourceUsageAssessmentConfig)
          assessmentConfig_;
    }
    return com.google.cloud.aiplatform.v1beta1.AssessDataRequest
        .BatchPredictionResourceUsageAssessmentConfig.getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * Optional. Configuration for the batch prediction resource usage
   * assessment.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.AssessDataRequest.BatchPredictionResourceUsageAssessmentConfig batch_prediction_resource_usage_assessment_config = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.AssessDataRequest
          .BatchPredictionResourceUsageAssessmentConfigOrBuilder
      getBatchPredictionResourceUsageAssessmentConfigOrBuilder() {
    if (assessmentConfigCase_ == 7) {
      return (com.google.cloud.aiplatform.v1beta1.AssessDataRequest
              .BatchPredictionResourceUsageAssessmentConfig)
          assessmentConfig_;
    }
    return com.google.cloud.aiplatform.v1beta1.AssessDataRequest
        .BatchPredictionResourceUsageAssessmentConfig.getDefaultInstance();
  }

  public static final int GEMINI_TEMPLATE_CONFIG_FIELD_NUMBER = 4;

  /**
   *
   *
   * <pre>
   * Optional. Config for assembling templates with a Gemini API structure to
   * assess assembled data.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.GeminiTemplateConfig gemini_template_config = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the geminiTemplateConfig field is set.
   */
  @java.lang.Override
  public boolean hasGeminiTemplateConfig() {
    return readConfigCase_ == 4;
  }

  /**
   *
   *
   * <pre>
   * Optional. Config for assembling templates with a Gemini API structure to
   * assess assembled data.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.GeminiTemplateConfig gemini_template_config = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The geminiTemplateConfig.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.GeminiTemplateConfig getGeminiTemplateConfig() {
    if (readConfigCase_ == 4) {
      return (com.google.cloud.aiplatform.v1beta1.GeminiTemplateConfig) readConfig_;
    }
    return com.google.cloud.aiplatform.v1beta1.GeminiTemplateConfig.getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * Optional. Config for assembling templates with a Gemini API structure to
   * assess assembled data.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.GeminiTemplateConfig gemini_template_config = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.GeminiTemplateConfigOrBuilder
      getGeminiTemplateConfigOrBuilder() {
    if (readConfigCase_ == 4) {
      return (com.google.cloud.aiplatform.v1beta1.GeminiTemplateConfig) readConfig_;
    }
    return com.google.cloud.aiplatform.v1beta1.GeminiTemplateConfig.getDefaultInstance();
  }

  public static final int REQUEST_COLUMN_NAME_FIELD_NUMBER = 5;

  /**
   *
   *
   * <pre>
   * Optional. The column name in the underlying table that contains already
   * fully assembled requests.
   * </pre>
   *
   * <code>string request_column_name = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return Whether the requestColumnName field is set.
   */
  public boolean hasRequestColumnName() {
    return readConfigCase_ == 5;
  }

  /**
   *
   *
   * <pre>
   * Optional. The column name in the underlying table that contains already
   * fully assembled requests.
   * </pre>
   *
   * <code>string request_column_name = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The requestColumnName.
   */
  public java.lang.String getRequestColumnName() {
    java.lang.Object ref = "";
    if (readConfigCase_ == 5) {
      ref = readConfig_;
    }
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (readConfigCase_ == 5) {
        readConfig_ = s;
      }
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Optional. The column name in the underlying table that contains already
   * fully assembled requests.
   * </pre>
   *
   * <code>string request_column_name = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for requestColumnName.
   */
  public com.google.protobuf.ByteString getRequestColumnNameBytes() {
    java.lang.Object ref = "";
    if (readConfigCase_ == 5) {
      ref = readConfig_;
    }
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      if (readConfigCase_ == 5) {
        readConfig_ = b;
      }
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";

  /**
   *
   *
   * <pre>
   * Required. The name of the Dataset resource. Used only for MULTIMODAL
   * datasets. Format:
   * `projects/{project}/locations/{location}/datasets/{dataset}`
   * </pre>
   *
   * <code>
   * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Required. The name of the Dataset resource. Used only for MULTIMODAL
   * datasets. Format:
   * `projects/{project}/locations/{location}/datasets/{dataset}`
   * </pre>
   *
   * <code>
   * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int GEMINI_REQUEST_READ_CONFIG_FIELD_NUMBER = 8;
  private com.google.cloud.aiplatform.v1beta1.GeminiRequestReadConfig geminiRequestReadConfig_;

  /**
   *
   *
   * <pre>
   * Optional. The Gemini request read config for the dataset.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.GeminiRequestReadConfig gemini_request_read_config = 8 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the geminiRequestReadConfig field is set.
   */
  @java.lang.Override
  public boolean hasGeminiRequestReadConfig() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * Optional. The Gemini request read config for the dataset.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.GeminiRequestReadConfig gemini_request_read_config = 8 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The geminiRequestReadConfig.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.GeminiRequestReadConfig getGeminiRequestReadConfig() {
    return geminiRequestReadConfig_ == null
        ? com.google.cloud.aiplatform.v1beta1.GeminiRequestReadConfig.getDefaultInstance()
        : geminiRequestReadConfig_;
  }

  /**
   *
   *
   * <pre>
   * Optional. The Gemini request read config for the dataset.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.GeminiRequestReadConfig gemini_request_read_config = 8 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.GeminiRequestReadConfigOrBuilder
      getGeminiRequestReadConfigOrBuilder() {
    return geminiRequestReadConfig_ == null
        ? com.google.cloud.aiplatform.v1beta1.GeminiRequestReadConfig.getDefaultInstance()
        : geminiRequestReadConfig_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (assessmentConfigCase_ == 2) {
      output.writeMessage(
          2,
          (com.google.cloud.aiplatform.v1beta1.AssessDataRequest.TuningValidationAssessmentConfig)
              assessmentConfig_);
    }
    if (assessmentConfigCase_ == 3) {
      output.writeMessage(
          3,
          (com.google.cloud.aiplatform.v1beta1.AssessDataRequest
                  .TuningResourceUsageAssessmentConfig)
              assessmentConfig_);
    }
    if (readConfigCase_ == 4) {
      output.writeMessage(
          4, (com.google.cloud.aiplatform.v1beta1.GeminiTemplateConfig) readConfig_);
    }
    if (readConfigCase_ == 5) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, readConfig_);
    }
    if (assessmentConfigCase_ == 6) {
      output.writeMessage(
          6,
          (com.google.cloud.aiplatform.v1beta1.AssessDataRequest
                  .BatchPredictionValidationAssessmentConfig)
              assessmentConfig_);
    }
    if (assessmentConfigCase_ == 7) {
      output.writeMessage(
          7,
          (com.google.cloud.aiplatform.v1beta1.AssessDataRequest
                  .BatchPredictionResourceUsageAssessmentConfig)
              assessmentConfig_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(8, getGeminiRequestReadConfig());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (assessmentConfigCase_ == 2) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              2,
              (com.google.cloud.aiplatform.v1beta1.AssessDataRequest
                      .TuningValidationAssessmentConfig)
                  assessmentConfig_);
    }
    if (assessmentConfigCase_ == 3) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              3,
              (com.google.cloud.aiplatform.v1beta1.AssessDataRequest
                      .TuningResourceUsageAssessmentConfig)
                  assessmentConfig_);
    }
    if (readConfigCase_ == 4) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              4, (com.google.cloud.aiplatform.v1beta1.GeminiTemplateConfig) readConfig_);
    }
    if (readConfigCase_ == 5) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, readConfig_);
    }
    if (assessmentConfigCase_ == 6) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              6,
              (com.google.cloud.aiplatform.v1beta1.AssessDataRequest
                      .BatchPredictionValidationAssessmentConfig)
                  assessmentConfig_);
    }
    if (assessmentConfigCase_ == 7) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              7,
              (com.google.cloud.aiplatform.v1beta1.AssessDataRequest
                      .BatchPredictionResourceUsageAssessmentConfig)
                  assessmentConfig_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(8, getGeminiRequestReadConfig());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.AssessDataRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1beta1.AssessDataRequest other =
        (com.google.cloud.aiplatform.v1beta1.AssessDataRequest) obj;

    if (!getName().equals(other.getName())) return false;
    if (hasGeminiRequestReadConfig() != other.hasGeminiRequestReadConfig()) return false;
    if (hasGeminiRequestReadConfig()) {
      if (!getGeminiRequestReadConfig().equals(other.getGeminiRequestReadConfig())) return false;
    }
    if (!getAssessmentConfigCase().equals(other.getAssessmentConfigCase())) return false;
    switch (assessmentConfigCase_) {
      case 2:
        if (!getTuningValidationAssessmentConfig()
            .equals(other.getTuningValidationAssessmentConfig())) return false;
        break;
      case 3:
        if (!getTuningResourceUsageAssessmentConfig()
            .equals(other.getTuningResourceUsageAssessmentConfig())) return false;
        break;
      case 6:
        if (!getBatchPredictionValidationAssessmentConfig()
            .equals(other.getBatchPredictionValidationAssessmentConfig())) return false;
        break;
      case 7:
        if (!getBatchPredictionResourceUsageAssessmentConfig()
            .equals(other.getBatchPredictionResourceUsageAssessmentConfig())) return false;
        break;
      case 0:
      default:
    }
    if (!getReadConfigCase().equals(other.getReadConfigCase())) return false;
    switch (readConfigCase_) {
      case 4:
        if (!getGeminiTemplateConfig().equals(other.getGeminiTemplateConfig())) return false;
        break;
      case 5:
        if (!getRequestColumnName().equals(other.getRequestColumnName())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    if (hasGeminiRequestReadConfig()) {
      hash = (37 * hash) + GEMINI_REQUEST_READ_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getGeminiRequestReadConfig().hashCode();
    }
    switch (assessmentConfigCase_) {
      case 2:
        hash = (37 * hash) + TUNING_VALIDATION_ASSESSMENT_CONFIG_FIELD_NUMBER;
        hash = (53 * hash) + getTuningValidationAssessmentConfig().hashCode();
        break;
      case 3:
        hash = (37 * hash) + TUNING_RESOURCE_USAGE_ASSESSMENT_CONFIG_FIELD_NUMBER;
        hash = (53 * hash) + getTuningResourceUsageAssessmentConfig().hashCode();
        break;
      case 6:
        hash = (37 * hash) + BATCH_PREDICTION_VALIDATION_ASSESSMENT_CONFIG_FIELD_NUMBER;
        hash = (53 * hash) + getBatchPredictionValidationAssessmentConfig().hashCode();
        break;
      case 7:
        hash = (37 * hash) + BATCH_PREDICTION_RESOURCE_USAGE_ASSESSMENT_CONFIG_FIELD_NUMBER;
        hash = (53 * hash) + getBatchPredictionResourceUsageAssessmentConfig().hashCode();
        break;
      case 0:
      default:
    }
    switch (readConfigCase_) {
      case 4:
        hash = (37 * hash) + GEMINI_TEMPLATE_CONFIG_FIELD_NUMBER;
        hash = (53 * hash) + getGeminiTemplateConfig().hashCode();
        break;
      case 5:
        hash = (37 * hash) + REQUEST_COLUMN_NAME_FIELD_NUMBER;
        hash = (53 * hash) + getRequestColumnName().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1beta1.AssessDataRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.AssessDataRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.AssessDataRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.AssessDataRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.AssessDataRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.AssessDataRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.AssessDataRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.AssessDataRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.AssessDataRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.AssessDataRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.AssessDataRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.AssessDataRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.aiplatform.v1beta1.AssessDataRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Request message for
   * [DatasetService.AssessData][google.cloud.aiplatform.v1beta1.DatasetService.AssessData].
   * Used only for MULTIMODAL datasets.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.AssessDataRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.AssessDataRequest)
      com.google.cloud.aiplatform.v1beta1.AssessDataRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.DatasetServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_AssessDataRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.DatasetServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_AssessDataRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.AssessDataRequest.class,
              com.google.cloud.aiplatform.v1beta1.AssessDataRequest.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1beta1.AssessDataRequest.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getGeminiRequestReadConfigFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (tuningValidationAssessmentConfigBuilder_ != null) {
        tuningValidationAssessmentConfigBuilder_.clear();
      }
      if (tuningResourceUsageAssessmentConfigBuilder_ != null) {
        tuningResourceUsageAssessmentConfigBuilder_.clear();
      }
      if (batchPredictionValidationAssessmentConfigBuilder_ != null) {
        batchPredictionValidationAssessmentConfigBuilder_.clear();
      }
      if (batchPredictionResourceUsageAssessmentConfigBuilder_ != null) {
        batchPredictionResourceUsageAssessmentConfigBuilder_.clear();
      }
      if (geminiTemplateConfigBuilder_ != null) {
        geminiTemplateConfigBuilder_.clear();
      }
      name_ = "";
      geminiRequestReadConfig_ = null;
      if (geminiRequestReadConfigBuilder_ != null) {
        geminiRequestReadConfigBuilder_.dispose();
        geminiRequestReadConfigBuilder_ = null;
      }
      assessmentConfigCase_ = 0;
      assessmentConfig_ = null;
      readConfigCase_ = 0;
      readConfig_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1beta1.DatasetServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_AssessDataRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.AssessDataRequest getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1beta1.AssessDataRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.AssessDataRequest build() {
      com.google.cloud.aiplatform.v1beta1.AssessDataRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.AssessDataRequest buildPartial() {
      com.google.cloud.aiplatform.v1beta1.AssessDataRequest result =
          new com.google.cloud.aiplatform.v1beta1.AssessDataRequest(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.aiplatform.v1beta1.AssessDataRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.name_ = name_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.geminiRequestReadConfig_ =
            geminiRequestReadConfigBuilder_ == null
                ? geminiRequestReadConfig_
                : geminiRequestReadConfigBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      result.bitField0_ |= to_bitField0_;
    }

    private void buildPartialOneofs(com.google.cloud.aiplatform.v1beta1.AssessDataRequest result) {
      result.assessmentConfigCase_ = assessmentConfigCase_;
      result.assessmentConfig_ = this.assessmentConfig_;
      if (assessmentConfigCase_ == 2 && tuningValidationAssessmentConfigBuilder_ != null) {
        result.assessmentConfig_ = tuningValidationAssessmentConfigBuilder_.build();
      }
      if (assessmentConfigCase_ == 3 && tuningResourceUsageAssessmentConfigBuilder_ != null) {
        result.assessmentConfig_ = tuningResourceUsageAssessmentConfigBuilder_.build();
      }
      if (assessmentConfigCase_ == 6 && batchPredictionValidationAssessmentConfigBuilder_ != null) {
        result.assessmentConfig_ = batchPredictionValidationAssessmentConfigBuilder_.build();
      }
      if (assessmentConfigCase_ == 7
          && batchPredictionResourceUsageAssessmentConfigBuilder_ != null) {
        result.assessmentConfig_ = batchPredictionResourceUsageAssessmentConfigBuilder_.build();
      }
      result.readConfigCase_ = readConfigCase_;
      result.readConfig_ = this.readConfig_;
      if (readConfigCase_ == 4 && geminiTemplateConfigBuilder_ != null) {
        result.readConfig_ = geminiTemplateConfigBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1beta1.AssessDataRequest) {
        return mergeFrom((com.google.cloud.aiplatform.v1beta1.AssessDataRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1beta1.AssessDataRequest other) {
      if (other == com.google.cloud.aiplatform.v1beta1.AssessDataRequest.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000040;
        onChanged();
      }
      if (other.hasGeminiRequestReadConfig()) {
        mergeGeminiRequestReadConfig(other.getGeminiRequestReadConfig());
      }
      switch (other.getAssessmentConfigCase()) {
        case TUNING_VALIDATION_ASSESSMENT_CONFIG:
          {
            mergeTuningValidationAssessmentConfig(other.getTuningValidationAssessmentConfig());
            break;
          }
        case TUNING_RESOURCE_USAGE_ASSESSMENT_CONFIG:
          {
            mergeTuningResourceUsageAssessmentConfig(
                other.getTuningResourceUsageAssessmentConfig());
            break;
          }
        case BATCH_PREDICTION_VALIDATION_ASSESSMENT_CONFIG:
          {
            mergeBatchPredictionValidationAssessmentConfig(
                other.getBatchPredictionValidationAssessmentConfig());
            break;
          }
        case BATCH_PREDICTION_RESOURCE_USAGE_ASSESSMENT_CONFIG:
          {
            mergeBatchPredictionResourceUsageAssessmentConfig(
                other.getBatchPredictionResourceUsageAssessmentConfig());
            break;
          }
        case ASSESSMENTCONFIG_NOT_SET:
          {
            break;
          }
      }
      switch (other.getReadConfigCase()) {
        case GEMINI_TEMPLATE_CONFIG:
          {
            mergeGeminiTemplateConfig(other.getGeminiTemplateConfig());
            break;
          }
        case REQUEST_COLUMN_NAME:
          {
            readConfigCase_ = 5;
            readConfig_ = other.readConfig_;
            onChanged();
            break;
          }
        case READCONFIG_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000040;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(
                    getTuningValidationAssessmentConfigFieldBuilder().getBuilder(),
                    extensionRegistry);
                assessmentConfigCase_ = 2;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(
                    getTuningResourceUsageAssessmentConfigFieldBuilder().getBuilder(),
                    extensionRegistry);
                assessmentConfigCase_ = 3;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(
                    getGeminiTemplateConfigFieldBuilder().getBuilder(), extensionRegistry);
                readConfigCase_ = 4;
                break;
              } // case 34
            case 42:
              {
                java.lang.String s = input.readStringRequireUtf8();
                readConfigCase_ = 5;
                readConfig_ = s;
                break;
              } // case 42
            case 50:
              {
                input.readMessage(
                    getBatchPredictionValidationAssessmentConfigFieldBuilder().getBuilder(),
                    extensionRegistry);
                assessmentConfigCase_ = 6;
                break;
              } // case 50
            case 58:
              {
                input.readMessage(
                    getBatchPredictionResourceUsageAssessmentConfigFieldBuilder().getBuilder(),
                    extensionRegistry);
                assessmentConfigCase_ = 7;
                break;
              } // case 58
            case 66:
              {
                input.readMessage(
                    getGeminiRequestReadConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000080;
                break;
              } // case 66
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int assessmentConfigCase_ = 0;
    private java.lang.Object assessmentConfig_;

    public AssessmentConfigCase getAssessmentConfigCase() {
      return AssessmentConfigCase.forNumber(assessmentConfigCase_);
    }

    public Builder clearAssessmentConfig() {
      assessmentConfigCase_ = 0;
      assessmentConfig_ = null;
      onChanged();
      return this;
    }

    private int readConfigCase_ = 0;
    private java.lang.Object readConfig_;

    public ReadConfigCase getReadConfigCase() {
      return ReadConfigCase.forNumber(readConfigCase_);
    }

    public Builder clearReadConfig() {
      readConfigCase_ = 0;
      readConfig_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.AssessDataRequest.TuningValidationAssessmentConfig,
            com.google.cloud.aiplatform.v1beta1.AssessDataRequest.TuningValidationAssessmentConfig
                .Builder,
            com.google.cloud.aiplatform.v1beta1.AssessDataRequest
                .TuningValidationAssessmentConfigOrBuilder>
        tuningValidationAssessmentConfigBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. Configuration for the tuning validation assessment.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.AssessDataRequest.TuningValidationAssessmentConfig tuning_validation_assessment_config = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the tuningValidationAssessmentConfig field is set.
     */
    @java.lang.Override
    public boolean hasTuningValidationAssessmentConfig() {
      return assessmentConfigCase_ == 2;
    }

    /**
     *
     *
     * <pre>
     * Optional. Configuration for the tuning validation assessment.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.AssessDataRequest.TuningValidationAssessmentConfig tuning_validation_assessment_config = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The tuningValidationAssessmentConfig.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.AssessDataRequest.TuningValidationAssessmentConfig
        getTuningValidationAssessmentConfig() {
      if (tuningValidationAssessmentConfigBuilder_ == null) {
        if (assessmentConfigCase_ == 2) {
          return (com.google.cloud.aiplatform.v1beta1.AssessDataRequest
                  .TuningValidationAssessmentConfig)
              assessmentConfig_;
        }
        return com.google.cloud.aiplatform.v1beta1.AssessDataRequest
            .TuningValidationAssessmentConfig.getDefaultInstance();
      } else {
        if (assessmentConfigCase_ == 2) {
          return tuningValidationAssessmentConfigBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1beta1.AssessDataRequest
            .TuningValidationAssessmentConfig.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Configuration for the tuning validation assessment.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.AssessDataRequest.TuningValidationAssessmentConfig tuning_validation_assessment_config = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setTuningValidationAssessmentConfig(
        com.google.cloud.aiplatform.v1beta1.AssessDataRequest.TuningValidationAssessmentConfig
            value) {
      if (tuningValidationAssessmentConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        assessmentConfig_ = value;
        onChanged();
      } else {
        tuningValidationAssessmentConfigBuilder_.setMessage(value);
      }
      assessmentConfigCase_ = 2;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Configuration for the tuning validation assessment.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.AssessDataRequest.TuningValidationAssessmentConfig tuning_validation_assessment_config = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setTuningValidationAssessmentConfig(
        com.google.cloud.aiplatform.v1beta1.AssessDataRequest.TuningValidationAssessmentConfig
                .Builder
            builderForValue) {
      if (tuningValidationAssessmentConfigBuilder_ == null) {
        assessmentConfig_ = builderForValue.build();
        onChanged();
      } else {
        tuningValidationAssessmentConfigBuilder_.setMessage(builderForValue.build());
      }
      assessmentConfigCase_ = 2;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Configuration for the tuning validation assessment.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.AssessDataRequest.TuningValidationAssessmentConfig tuning_validation_assessment_config = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeTuningValidationAssessmentConfig(
        com.google.cloud.aiplatform.v1beta1.AssessDataRequest.TuningValidationAssessmentConfig
            value) {
      if (tuningValidationAssessmentConfigBuilder_ == null) {
        if (assessmentConfigCase_ == 2
            && assessmentConfig_
                != com.google.cloud.aiplatform.v1beta1.AssessDataRequest
                    .TuningValidationAssessmentConfig.getDefaultInstance()) {
          assessmentConfig_ =
              com.google.cloud.aiplatform.v1beta1.AssessDataRequest.TuningValidationAssessmentConfig
                  .newBuilder(
                      (com.google.cloud.aiplatform.v1beta1.AssessDataRequest
                              .TuningValidationAssessmentConfig)
                          assessmentConfig_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          assessmentConfig_ = value;
        }
        onChanged();
      } else {
        if (assessmentConfigCase_ == 2) {
          tuningValidationAssessmentConfigBuilder_.mergeFrom(value);
        } else {
          tuningValidationAssessmentConfigBuilder_.setMessage(value);
        }
      }
      assessmentConfigCase_ = 2;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Configuration for the tuning validation assessment.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.AssessDataRequest.TuningValidationAssessmentConfig tuning_validation_assessment_config = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearTuningValidationAssessmentConfig() {
      if (tuningValidationAssessmentConfigBuilder_ == null) {
        if (assessmentConfigCase_ == 2) {
          assessmentConfigCase_ = 0;
          assessmentConfig_ = null;
          onChanged();
        }
      } else {
        if (assessmentConfigCase_ == 2) {
          assessmentConfigCase_ = 0;
          assessmentConfig_ = null;
        }
        tuningValidationAssessmentConfigBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Configuration for the tuning validation assessment.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.AssessDataRequest.TuningValidationAssessmentConfig tuning_validation_assessment_config = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.AssessDataRequest.TuningValidationAssessmentConfig
            .Builder
        getTuningValidationAssessmentConfigBuilder() {
      return getTuningValidationAssessmentConfigFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Optional. Configuration for the tuning validation assessment.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.AssessDataRequest.TuningValidationAssessmentConfig tuning_validation_assessment_config = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.AssessDataRequest
            .TuningValidationAssessmentConfigOrBuilder
        getTuningValidationAssessmentConfigOrBuilder() {
      if ((assessmentConfigCase_ == 2) && (tuningValidationAssessmentConfigBuilder_ != null)) {
        return tuningValidationAssessmentConfigBuilder_.getMessageOrBuilder();
      } else {
        if (assessmentConfigCase_ == 2) {
          return (com.google.cloud.aiplatform.v1beta1.AssessDataRequest
                  .TuningValidationAssessmentConfig)
              assessmentConfig_;
        }
        return com.google.cloud.aiplatform.v1beta1.AssessDataRequest
            .TuningValidationAssessmentConfig.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Configuration for the tuning validation assessment.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.AssessDataRequest.TuningValidationAssessmentConfig tuning_validation_assessment_config = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.AssessDataRequest.TuningValidationAssessmentConfig,
            com.google.cloud.aiplatform.v1beta1.AssessDataRequest.TuningValidationAssessmentConfig
                .Builder,
            com.google.cloud.aiplatform.v1beta1.AssessDataRequest
                .TuningValidationAssessmentConfigOrBuilder>
        getTuningValidationAssessmentConfigFieldBuilder() {
      if (tuningValidationAssessmentConfigBuilder_ == null) {
        if (!(assessmentConfigCase_ == 2)) {
          assessmentConfig_ =
              com.google.cloud.aiplatform.v1beta1.AssessDataRequest.TuningValidationAssessmentConfig
                  .getDefaultInstance();
        }
        tuningValidationAssessmentConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.AssessDataRequest
                    .TuningValidationAssessmentConfig,
                com.google.cloud.aiplatform.v1beta1.AssessDataRequest
                    .TuningValidationAssessmentConfig.Builder,
                com.google.cloud.aiplatform.v1beta1.AssessDataRequest
                    .TuningValidationAssessmentConfigOrBuilder>(
                (com.google.cloud.aiplatform.v1beta1.AssessDataRequest
                        .TuningValidationAssessmentConfig)
                    assessmentConfig_,
                getParentForChildren(),
                isClean());
        assessmentConfig_ = null;
      }
      assessmentConfigCase_ = 2;
      onChanged();
      return tuningValidationAssessmentConfigBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.AssessDataRequest
                .TuningResourceUsageAssessmentConfig,
            com.google.cloud.aiplatform.v1beta1.AssessDataRequest
                .TuningResourceUsageAssessmentConfig.Builder,
            com.google.cloud.aiplatform.v1beta1.AssessDataRequest
                .TuningResourceUsageAssessmentConfigOrBuilder>
        tuningResourceUsageAssessmentConfigBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. Configuration for the tuning resource usage assessment.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.AssessDataRequest.TuningResourceUsageAssessmentConfig tuning_resource_usage_assessment_config = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the tuningResourceUsageAssessmentConfig field is set.
     */
    @java.lang.Override
    public boolean hasTuningResourceUsageAssessmentConfig() {
      return assessmentConfigCase_ == 3;
    }

    /**
     *
     *
     * <pre>
     * Optional. Configuration for the tuning resource usage assessment.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.AssessDataRequest.TuningResourceUsageAssessmentConfig tuning_resource_usage_assessment_config = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The tuningResourceUsageAssessmentConfig.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.AssessDataRequest.TuningResourceUsageAssessmentConfig
        getTuningResourceUsageAssessmentConfig() {
      if (tuningResourceUsageAssessmentConfigBuilder_ == null) {
        if (assessmentConfigCase_ == 3) {
          return (com.google.cloud.aiplatform.v1beta1.AssessDataRequest
                  .TuningResourceUsageAssessmentConfig)
              assessmentConfig_;
        }
        return com.google.cloud.aiplatform.v1beta1.AssessDataRequest
            .TuningResourceUsageAssessmentConfig.getDefaultInstance();
      } else {
        if (assessmentConfigCase_ == 3) {
          return tuningResourceUsageAssessmentConfigBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1beta1.AssessDataRequest
            .TuningResourceUsageAssessmentConfig.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Configuration for the tuning resource usage assessment.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.AssessDataRequest.TuningResourceUsageAssessmentConfig tuning_resource_usage_assessment_config = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setTuningResourceUsageAssessmentConfig(
        com.google.cloud.aiplatform.v1beta1.AssessDataRequest.TuningResourceUsageAssessmentConfig
            value) {
      if (tuningResourceUsageAssessmentConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        assessmentConfig_ = value;
        onChanged();
      } else {
        tuningResourceUsageAssessmentConfigBuilder_.setMessage(value);
      }
      assessmentConfigCase_ = 3;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Configuration for the tuning resource usage assessment.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.AssessDataRequest.TuningResourceUsageAssessmentConfig tuning_resource_usage_assessment_config = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setTuningResourceUsageAssessmentConfig(
        com.google.cloud.aiplatform.v1beta1.AssessDataRequest.TuningResourceUsageAssessmentConfig
                .Builder
            builderForValue) {
      if (tuningResourceUsageAssessmentConfigBuilder_ == null) {
        assessmentConfig_ = builderForValue.build();
        onChanged();
      } else {
        tuningResourceUsageAssessmentConfigBuilder_.setMessage(builderForValue.build());
      }
      assessmentConfigCase_ = 3;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Configuration for the tuning resource usage assessment.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.AssessDataRequest.TuningResourceUsageAssessmentConfig tuning_resource_usage_assessment_config = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeTuningResourceUsageAssessmentConfig(
        com.google.cloud.aiplatform.v1beta1.AssessDataRequest.TuningResourceUsageAssessmentConfig
            value) {
      if (tuningResourceUsageAssessmentConfigBuilder_ == null) {
        if (assessmentConfigCase_ == 3
            && assessmentConfig_
                != com.google.cloud.aiplatform.v1beta1.AssessDataRequest
                    .TuningResourceUsageAssessmentConfig.getDefaultInstance()) {
          assessmentConfig_ =
              com.google.cloud.aiplatform.v1beta1.AssessDataRequest
                  .TuningResourceUsageAssessmentConfig.newBuilder(
                      (com.google.cloud.aiplatform.v1beta1.AssessDataRequest
                              .TuningResourceUsageAssessmentConfig)
                          assessmentConfig_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          assessmentConfig_ = value;
        }
        onChanged();
      } else {
        if (assessmentConfigCase_ == 3) {
          tuningResourceUsageAssessmentConfigBuilder_.mergeFrom(value);
        } else {
          tuningResourceUsageAssessmentConfigBuilder_.setMessage(value);
        }
      }
      assessmentConfigCase_ = 3;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Configuration for the tuning resource usage assessment.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.AssessDataRequest.TuningResourceUsageAssessmentConfig tuning_resource_usage_assessment_config = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearTuningResourceUsageAssessmentConfig() {
      if (tuningResourceUsageAssessmentConfigBuilder_ == null) {
        if (assessmentConfigCase_ == 3) {
          assessmentConfigCase_ = 0;
          assessmentConfig_ = null;
          onChanged();
        }
      } else {
        if (assessmentConfigCase_ == 3) {
          assessmentConfigCase_ = 0;
          assessmentConfig_ = null;
        }
        tuningResourceUsageAssessmentConfigBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Configuration for the tuning resource usage assessment.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.AssessDataRequest.TuningResourceUsageAssessmentConfig tuning_resource_usage_assessment_config = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.AssessDataRequest.TuningResourceUsageAssessmentConfig
            .Builder
        getTuningResourceUsageAssessmentConfigBuilder() {
      return getTuningResourceUsageAssessmentConfigFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Optional. Configuration for the tuning resource usage assessment.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.AssessDataRequest.TuningResourceUsageAssessmentConfig tuning_resource_usage_assessment_config = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.AssessDataRequest
            .TuningResourceUsageAssessmentConfigOrBuilder
        getTuningResourceUsageAssessmentConfigOrBuilder() {
      if ((assessmentConfigCase_ == 3) && (tuningResourceUsageAssessmentConfigBuilder_ != null)) {
        return tuningResourceUsageAssessmentConfigBuilder_.getMessageOrBuilder();
      } else {
        if (assessmentConfigCase_ == 3) {
          return (com.google.cloud.aiplatform.v1beta1.AssessDataRequest
                  .TuningResourceUsageAssessmentConfig)
              assessmentConfig_;
        }
        return com.google.cloud.aiplatform.v1beta1.AssessDataRequest
            .TuningResourceUsageAssessmentConfig.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Configuration for the tuning resource usage assessment.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.AssessDataRequest.TuningResourceUsageAssessmentConfig tuning_resource_usage_assessment_config = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.AssessDataRequest
                .TuningResourceUsageAssessmentConfig,
            com.google.cloud.aiplatform.v1beta1.AssessDataRequest
                .TuningResourceUsageAssessmentConfig.Builder,
            com.google.cloud.aiplatform.v1beta1.AssessDataRequest
                .TuningResourceUsageAssessmentConfigOrBuilder>
        getTuningResourceUsageAssessmentConfigFieldBuilder() {
      if (tuningResourceUsageAssessmentConfigBuilder_ == null) {
        if (!(assessmentConfigCase_ == 3)) {
          assessmentConfig_ =
              com.google.cloud.aiplatform.v1beta1.AssessDataRequest
                  .TuningResourceUsageAssessmentConfig.getDefaultInstance();
        }
        tuningResourceUsageAssessmentConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.AssessDataRequest
                    .TuningResourceUsageAssessmentConfig,
                com.google.cloud.aiplatform.v1beta1.AssessDataRequest
                    .TuningResourceUsageAssessmentConfig.Builder,
                com.google.cloud.aiplatform.v1beta1.AssessDataRequest
                    .TuningResourceUsageAssessmentConfigOrBuilder>(
                (com.google.cloud.aiplatform.v1beta1.AssessDataRequest
                        .TuningResourceUsageAssessmentConfig)
                    assessmentConfig_,
                getParentForChildren(),
                isClean());
        assessmentConfig_ = null;
      }
      assessmentConfigCase_ = 3;
      onChanged();
      return tuningResourceUsageAssessmentConfigBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.AssessDataRequest
                .BatchPredictionValidationAssessmentConfig,
            com.google.cloud.aiplatform.v1beta1.AssessDataRequest
                .BatchPredictionValidationAssessmentConfig.Builder,
            com.google.cloud.aiplatform.v1beta1.AssessDataRequest
                .BatchPredictionValidationAssessmentConfigOrBuilder>
        batchPredictionValidationAssessmentConfigBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. Configuration for the batch prediction validation assessment.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.AssessDataRequest.BatchPredictionValidationAssessmentConfig batch_prediction_validation_assessment_config = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the batchPredictionValidationAssessmentConfig field is set.
     */
    @java.lang.Override
    public boolean hasBatchPredictionValidationAssessmentConfig() {
      return assessmentConfigCase_ == 6;
    }

    /**
     *
     *
     * <pre>
     * Optional. Configuration for the batch prediction validation assessment.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.AssessDataRequest.BatchPredictionValidationAssessmentConfig batch_prediction_validation_assessment_config = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The batchPredictionValidationAssessmentConfig.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.AssessDataRequest
            .BatchPredictionValidationAssessmentConfig
        getBatchPredictionValidationAssessmentConfig() {
      if (batchPredictionValidationAssessmentConfigBuilder_ == null) {
        if (assessmentConfigCase_ == 6) {
          return (com.google.cloud.aiplatform.v1beta1.AssessDataRequest
                  .BatchPredictionValidationAssessmentConfig)
              assessmentConfig_;
        }
        return com.google.cloud.aiplatform.v1beta1.AssessDataRequest
            .BatchPredictionValidationAssessmentConfig.getDefaultInstance();
      } else {
        if (assessmentConfigCase_ == 6) {
          return batchPredictionValidationAssessmentConfigBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1beta1.AssessDataRequest
            .BatchPredictionValidationAssessmentConfig.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Configuration for the batch prediction validation assessment.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.AssessDataRequest.BatchPredictionValidationAssessmentConfig batch_prediction_validation_assessment_config = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setBatchPredictionValidationAssessmentConfig(
        com.google.cloud.aiplatform.v1beta1.AssessDataRequest
                .BatchPredictionValidationAssessmentConfig
            value) {
      if (batchPredictionValidationAssessmentConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        assessmentConfig_ = value;
        onChanged();
      } else {
        batchPredictionValidationAssessmentConfigBuilder_.setMessage(value);
      }
      assessmentConfigCase_ = 6;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Configuration for the batch prediction validation assessment.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.AssessDataRequest.BatchPredictionValidationAssessmentConfig batch_prediction_validation_assessment_config = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setBatchPredictionValidationAssessmentConfig(
        com.google.cloud.aiplatform.v1beta1.AssessDataRequest
                .BatchPredictionValidationAssessmentConfig.Builder
            builderForValue) {
      if (batchPredictionValidationAssessmentConfigBuilder_ == null) {
        assessmentConfig_ = builderForValue.build();
        onChanged();
      } else {
        batchPredictionValidationAssessmentConfigBuilder_.setMessage(builderForValue.build());
      }
      assessmentConfigCase_ = 6;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Configuration for the batch prediction validation assessment.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.AssessDataRequest.BatchPredictionValidationAssessmentConfig batch_prediction_validation_assessment_config = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeBatchPredictionValidationAssessmentConfig(
        com.google.cloud.aiplatform.v1beta1.AssessDataRequest
                .BatchPredictionValidationAssessmentConfig
            value) {
      if (batchPredictionValidationAssessmentConfigBuilder_ == null) {
        if (assessmentConfigCase_ == 6
            && assessmentConfig_
                != com.google.cloud.aiplatform.v1beta1.AssessDataRequest
                    .BatchPredictionValidationAssessmentConfig.getDefaultInstance()) {
          assessmentConfig_ =
              com.google.cloud.aiplatform.v1beta1.AssessDataRequest
                  .BatchPredictionValidationAssessmentConfig.newBuilder(
                      (com.google.cloud.aiplatform.v1beta1.AssessDataRequest
                              .BatchPredictionValidationAssessmentConfig)
                          assessmentConfig_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          assessmentConfig_ = value;
        }
        onChanged();
      } else {
        if (assessmentConfigCase_ == 6) {
          batchPredictionValidationAssessmentConfigBuilder_.mergeFrom(value);
        } else {
          batchPredictionValidationAssessmentConfigBuilder_.setMessage(value);
        }
      }
      assessmentConfigCase_ = 6;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Configuration for the batch prediction validation assessment.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.AssessDataRequest.BatchPredictionValidationAssessmentConfig batch_prediction_validation_assessment_config = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearBatchPredictionValidationAssessmentConfig() {
      if (batchPredictionValidationAssessmentConfigBuilder_ == null) {
        if (assessmentConfigCase_ == 6) {
          assessmentConfigCase_ = 0;
          assessmentConfig_ = null;
          onChanged();
        }
      } else {
        if (assessmentConfigCase_ == 6) {
          assessmentConfigCase_ = 0;
          assessmentConfig_ = null;
        }
        batchPredictionValidationAssessmentConfigBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Configuration for the batch prediction validation assessment.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.AssessDataRequest.BatchPredictionValidationAssessmentConfig batch_prediction_validation_assessment_config = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.AssessDataRequest
            .BatchPredictionValidationAssessmentConfig.Builder
        getBatchPredictionValidationAssessmentConfigBuilder() {
      return getBatchPredictionValidationAssessmentConfigFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Optional. Configuration for the batch prediction validation assessment.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.AssessDataRequest.BatchPredictionValidationAssessmentConfig batch_prediction_validation_assessment_config = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.AssessDataRequest
            .BatchPredictionValidationAssessmentConfigOrBuilder
        getBatchPredictionValidationAssessmentConfigOrBuilder() {
      if ((assessmentConfigCase_ == 6)
          && (batchPredictionValidationAssessmentConfigBuilder_ != null)) {
        return batchPredictionValidationAssessmentConfigBuilder_.getMessageOrBuilder();
      } else {
        if (assessmentConfigCase_ == 6) {
          return (com.google.cloud.aiplatform.v1beta1.AssessDataRequest
                  .BatchPredictionValidationAssessmentConfig)
              assessmentConfig_;
        }
        return com.google.cloud.aiplatform.v1beta1.AssessDataRequest
            .BatchPredictionValidationAssessmentConfig.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Configuration for the batch prediction validation assessment.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.AssessDataRequest.BatchPredictionValidationAssessmentConfig batch_prediction_validation_assessment_config = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.AssessDataRequest
                .BatchPredictionValidationAssessmentConfig,
            com.google.cloud.aiplatform.v1beta1.AssessDataRequest
                .BatchPredictionValidationAssessmentConfig.Builder,
            com.google.cloud.aiplatform.v1beta1.AssessDataRequest
                .BatchPredictionValidationAssessmentConfigOrBuilder>
        getBatchPredictionValidationAssessmentConfigFieldBuilder() {
      if (batchPredictionValidationAssessmentConfigBuilder_ == null) {
        if (!(assessmentConfigCase_ == 6)) {
          assessmentConfig_ =
              com.google.cloud.aiplatform.v1beta1.AssessDataRequest
                  .BatchPredictionValidationAssessmentConfig.getDefaultInstance();
        }
        batchPredictionValidationAssessmentConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.AssessDataRequest
                    .BatchPredictionValidationAssessmentConfig,
                com.google.cloud.aiplatform.v1beta1.AssessDataRequest
                    .BatchPredictionValidationAssessmentConfig.Builder,
                com.google.cloud.aiplatform.v1beta1.AssessDataRequest
                    .BatchPredictionValidationAssessmentConfigOrBuilder>(
                (com.google.cloud.aiplatform.v1beta1.AssessDataRequest
                        .BatchPredictionValidationAssessmentConfig)
                    assessmentConfig_,
                getParentForChildren(),
                isClean());
        assessmentConfig_ = null;
      }
      assessmentConfigCase_ = 6;
      onChanged();
      return batchPredictionValidationAssessmentConfigBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.AssessDataRequest
                .BatchPredictionResourceUsageAssessmentConfig,
            com.google.cloud.aiplatform.v1beta1.AssessDataRequest
                .BatchPredictionResourceUsageAssessmentConfig.Builder,
            com.google.cloud.aiplatform.v1beta1.AssessDataRequest
                .BatchPredictionResourceUsageAssessmentConfigOrBuilder>
        batchPredictionResourceUsageAssessmentConfigBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. Configuration for the batch prediction resource usage
     * assessment.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.AssessDataRequest.BatchPredictionResourceUsageAssessmentConfig batch_prediction_resource_usage_assessment_config = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the batchPredictionResourceUsageAssessmentConfig field is set.
     */
    @java.lang.Override
    public boolean hasBatchPredictionResourceUsageAssessmentConfig() {
      return assessmentConfigCase_ == 7;
    }

    /**
     *
     *
     * <pre>
     * Optional. Configuration for the batch prediction resource usage
     * assessment.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.AssessDataRequest.BatchPredictionResourceUsageAssessmentConfig batch_prediction_resource_usage_assessment_config = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The batchPredictionResourceUsageAssessmentConfig.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.AssessDataRequest
            .BatchPredictionResourceUsageAssessmentConfig
        getBatchPredictionResourceUsageAssessmentConfig() {
      if (batchPredictionResourceUsageAssessmentConfigBuilder_ == null) {
        if (assessmentConfigCase_ == 7) {
          return (com.google.cloud.aiplatform.v1beta1.AssessDataRequest
                  .BatchPredictionResourceUsageAssessmentConfig)
              assessmentConfig_;
        }
        return com.google.cloud.aiplatform.v1beta1.AssessDataRequest
            .BatchPredictionResourceUsageAssessmentConfig.getDefaultInstance();
      } else {
        if (assessmentConfigCase_ == 7) {
          return batchPredictionResourceUsageAssessmentConfigBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1beta1.AssessDataRequest
            .BatchPredictionResourceUsageAssessmentConfig.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Configuration for the batch prediction resource usage
     * assessment.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.AssessDataRequest.BatchPredictionResourceUsageAssessmentConfig batch_prediction_resource_usage_assessment_config = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setBatchPredictionResourceUsageAssessmentConfig(
        com.google.cloud.aiplatform.v1beta1.AssessDataRequest
                .BatchPredictionResourceUsageAssessmentConfig
            value) {
      if (batchPredictionResourceUsageAssessmentConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        assessmentConfig_ = value;
        onChanged();
      } else {
        batchPredictionResourceUsageAssessmentConfigBuilder_.setMessage(value);
      }
      assessmentConfigCase_ = 7;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Configuration for the batch prediction resource usage
     * assessment.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.AssessDataRequest.BatchPredictionResourceUsageAssessmentConfig batch_prediction_resource_usage_assessment_config = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setBatchPredictionResourceUsageAssessmentConfig(
        com.google.cloud.aiplatform.v1beta1.AssessDataRequest
                .BatchPredictionResourceUsageAssessmentConfig.Builder
            builderForValue) {
      if (batchPredictionResourceUsageAssessmentConfigBuilder_ == null) {
        assessmentConfig_ = builderForValue.build();
        onChanged();
      } else {
        batchPredictionResourceUsageAssessmentConfigBuilder_.setMessage(builderForValue.build());
      }
      assessmentConfigCase_ = 7;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Configuration for the batch prediction resource usage
     * assessment.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.AssessDataRequest.BatchPredictionResourceUsageAssessmentConfig batch_prediction_resource_usage_assessment_config = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeBatchPredictionResourceUsageAssessmentConfig(
        com.google.cloud.aiplatform.v1beta1.AssessDataRequest
                .BatchPredictionResourceUsageAssessmentConfig
            value) {
      if (batchPredictionResourceUsageAssessmentConfigBuilder_ == null) {
        if (assessmentConfigCase_ == 7
            && assessmentConfig_
                != com.google.cloud.aiplatform.v1beta1.AssessDataRequest
                    .BatchPredictionResourceUsageAssessmentConfig.getDefaultInstance()) {
          assessmentConfig_ =
              com.google.cloud.aiplatform.v1beta1.AssessDataRequest
                  .BatchPredictionResourceUsageAssessmentConfig.newBuilder(
                      (com.google.cloud.aiplatform.v1beta1.AssessDataRequest
                              .BatchPredictionResourceUsageAssessmentConfig)
                          assessmentConfig_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          assessmentConfig_ = value;
        }
        onChanged();
      } else {
        if (assessmentConfigCase_ == 7) {
          batchPredictionResourceUsageAssessmentConfigBuilder_.mergeFrom(value);
        } else {
          batchPredictionResourceUsageAssessmentConfigBuilder_.setMessage(value);
        }
      }
      assessmentConfigCase_ = 7;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Configuration for the batch prediction resource usage
     * assessment.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.AssessDataRequest.BatchPredictionResourceUsageAssessmentConfig batch_prediction_resource_usage_assessment_config = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearBatchPredictionResourceUsageAssessmentConfig() {
      if (batchPredictionResourceUsageAssessmentConfigBuilder_ == null) {
        if (assessmentConfigCase_ == 7) {
          assessmentConfigCase_ = 0;
          assessmentConfig_ = null;
          onChanged();
        }
      } else {
        if (assessmentConfigCase_ == 7) {
          assessmentConfigCase_ = 0;
          assessmentConfig_ = null;
        }
        batchPredictionResourceUsageAssessmentConfigBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Configuration for the batch prediction resource usage
     * assessment.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.AssessDataRequest.BatchPredictionResourceUsageAssessmentConfig batch_prediction_resource_usage_assessment_config = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.AssessDataRequest
            .BatchPredictionResourceUsageAssessmentConfig.Builder
        getBatchPredictionResourceUsageAssessmentConfigBuilder() {
      return getBatchPredictionResourceUsageAssessmentConfigFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Optional. Configuration for the batch prediction resource usage
     * assessment.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.AssessDataRequest.BatchPredictionResourceUsageAssessmentConfig batch_prediction_resource_usage_assessment_config = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.AssessDataRequest
            .BatchPredictionResourceUsageAssessmentConfigOrBuilder
        getBatchPredictionResourceUsageAssessmentConfigOrBuilder() {
      if ((assessmentConfigCase_ == 7)
          && (batchPredictionResourceUsageAssessmentConfigBuilder_ != null)) {
        return batchPredictionResourceUsageAssessmentConfigBuilder_.getMessageOrBuilder();
      } else {
        if (assessmentConfigCase_ == 7) {
          return (com.google.cloud.aiplatform.v1beta1.AssessDataRequest
                  .BatchPredictionResourceUsageAssessmentConfig)
              assessmentConfig_;
        }
        return com.google.cloud.aiplatform.v1beta1.AssessDataRequest
            .BatchPredictionResourceUsageAssessmentConfig.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Configuration for the batch prediction resource usage
     * assessment.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.AssessDataRequest.BatchPredictionResourceUsageAssessmentConfig batch_prediction_resource_usage_assessment_config = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.AssessDataRequest
                .BatchPredictionResourceUsageAssessmentConfig,
            com.google.cloud.aiplatform.v1beta1.AssessDataRequest
                .BatchPredictionResourceUsageAssessmentConfig.Builder,
            com.google.cloud.aiplatform.v1beta1.AssessDataRequest
                .BatchPredictionResourceUsageAssessmentConfigOrBuilder>
        getBatchPredictionResourceUsageAssessmentConfigFieldBuilder() {
      if (batchPredictionResourceUsageAssessmentConfigBuilder_ == null) {
        if (!(assessmentConfigCase_ == 7)) {
          assessmentConfig_ =
              com.google.cloud.aiplatform.v1beta1.AssessDataRequest
                  .BatchPredictionResourceUsageAssessmentConfig.getDefaultInstance();
        }
        batchPredictionResourceUsageAssessmentConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.AssessDataRequest
                    .BatchPredictionResourceUsageAssessmentConfig,
                com.google.cloud.aiplatform.v1beta1.AssessDataRequest
                    .BatchPredictionResourceUsageAssessmentConfig.Builder,
                com.google.cloud.aiplatform.v1beta1.AssessDataRequest
                    .BatchPredictionResourceUsageAssessmentConfigOrBuilder>(
                (com.google.cloud.aiplatform.v1beta1.AssessDataRequest
                        .BatchPredictionResourceUsageAssessmentConfig)
                    assessmentConfig_,
                getParentForChildren(),
                isClean());
        assessmentConfig_ = null;
      }
      assessmentConfigCase_ = 7;
      onChanged();
      return batchPredictionResourceUsageAssessmentConfigBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.GeminiTemplateConfig,
            com.google.cloud.aiplatform.v1beta1.GeminiTemplateConfig.Builder,
            com.google.cloud.aiplatform.v1beta1.GeminiTemplateConfigOrBuilder>
        geminiTemplateConfigBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. Config for assembling templates with a Gemini API structure to
     * assess assembled data.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.GeminiTemplateConfig gemini_template_config = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the geminiTemplateConfig field is set.
     */
    @java.lang.Override
    public boolean hasGeminiTemplateConfig() {
      return readConfigCase_ == 4;
    }

    /**
     *
     *
     * <pre>
     * Optional. Config for assembling templates with a Gemini API structure to
     * assess assembled data.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.GeminiTemplateConfig gemini_template_config = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The geminiTemplateConfig.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.GeminiTemplateConfig getGeminiTemplateConfig() {
      if (geminiTemplateConfigBuilder_ == null) {
        if (readConfigCase_ == 4) {
          return (com.google.cloud.aiplatform.v1beta1.GeminiTemplateConfig) readConfig_;
        }
        return com.google.cloud.aiplatform.v1beta1.GeminiTemplateConfig.getDefaultInstance();
      } else {
        if (readConfigCase_ == 4) {
          return geminiTemplateConfigBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1beta1.GeminiTemplateConfig.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Config for assembling templates with a Gemini API structure to
     * assess assembled data.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.GeminiTemplateConfig gemini_template_config = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setGeminiTemplateConfig(
        com.google.cloud.aiplatform.v1beta1.GeminiTemplateConfig value) {
      if (geminiTemplateConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        readConfig_ = value;
        onChanged();
      } else {
        geminiTemplateConfigBuilder_.setMessage(value);
      }
      readConfigCase_ = 4;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Config for assembling templates with a Gemini API structure to
     * assess assembled data.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.GeminiTemplateConfig gemini_template_config = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setGeminiTemplateConfig(
        com.google.cloud.aiplatform.v1beta1.GeminiTemplateConfig.Builder builderForValue) {
      if (geminiTemplateConfigBuilder_ == null) {
        readConfig_ = builderForValue.build();
        onChanged();
      } else {
        geminiTemplateConfigBuilder_.setMessage(builderForValue.build());
      }
      readConfigCase_ = 4;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Config for assembling templates with a Gemini API structure to
     * assess assembled data.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.GeminiTemplateConfig gemini_template_config = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeGeminiTemplateConfig(
        com.google.cloud.aiplatform.v1beta1.GeminiTemplateConfig value) {
      if (geminiTemplateConfigBuilder_ == null) {
        if (readConfigCase_ == 4
            && readConfig_
                != com.google.cloud.aiplatform.v1beta1.GeminiTemplateConfig.getDefaultInstance()) {
          readConfig_ =
              com.google.cloud.aiplatform.v1beta1.GeminiTemplateConfig.newBuilder(
                      (com.google.cloud.aiplatform.v1beta1.GeminiTemplateConfig) readConfig_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          readConfig_ = value;
        }
        onChanged();
      } else {
        if (readConfigCase_ == 4) {
          geminiTemplateConfigBuilder_.mergeFrom(value);
        } else {
          geminiTemplateConfigBuilder_.setMessage(value);
        }
      }
      readConfigCase_ = 4;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Config for assembling templates with a Gemini API structure to
     * assess assembled data.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.GeminiTemplateConfig gemini_template_config = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearGeminiTemplateConfig() {
      if (geminiTemplateConfigBuilder_ == null) {
        if (readConfigCase_ == 4) {
          readConfigCase_ = 0;
          readConfig_ = null;
          onChanged();
        }
      } else {
        if (readConfigCase_ == 4) {
          readConfigCase_ = 0;
          readConfig_ = null;
        }
        geminiTemplateConfigBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Config for assembling templates with a Gemini API structure to
     * assess assembled data.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.GeminiTemplateConfig gemini_template_config = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.GeminiTemplateConfig.Builder
        getGeminiTemplateConfigBuilder() {
      return getGeminiTemplateConfigFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Optional. Config for assembling templates with a Gemini API structure to
     * assess assembled data.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.GeminiTemplateConfig gemini_template_config = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.GeminiTemplateConfigOrBuilder
        getGeminiTemplateConfigOrBuilder() {
      if ((readConfigCase_ == 4) && (geminiTemplateConfigBuilder_ != null)) {
        return geminiTemplateConfigBuilder_.getMessageOrBuilder();
      } else {
        if (readConfigCase_ == 4) {
          return (com.google.cloud.aiplatform.v1beta1.GeminiTemplateConfig) readConfig_;
        }
        return com.google.cloud.aiplatform.v1beta1.GeminiTemplateConfig.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Config for assembling templates with a Gemini API structure to
     * assess assembled data.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.GeminiTemplateConfig gemini_template_config = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.GeminiTemplateConfig,
            com.google.cloud.aiplatform.v1beta1.GeminiTemplateConfig.Builder,
            com.google.cloud.aiplatform.v1beta1.GeminiTemplateConfigOrBuilder>
        getGeminiTemplateConfigFieldBuilder() {
      if (geminiTemplateConfigBuilder_ == null) {
        if (!(readConfigCase_ == 4)) {
          readConfig_ =
              com.google.cloud.aiplatform.v1beta1.GeminiTemplateConfig.getDefaultInstance();
        }
        geminiTemplateConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.GeminiTemplateConfig,
                com.google.cloud.aiplatform.v1beta1.GeminiTemplateConfig.Builder,
                com.google.cloud.aiplatform.v1beta1.GeminiTemplateConfigOrBuilder>(
                (com.google.cloud.aiplatform.v1beta1.GeminiTemplateConfig) readConfig_,
                getParentForChildren(),
                isClean());
        readConfig_ = null;
      }
      readConfigCase_ = 4;
      onChanged();
      return geminiTemplateConfigBuilder_;
    }

    /**
     *
     *
     * <pre>
     * Optional. The column name in the underlying table that contains already
     * fully assembled requests.
     * </pre>
     *
     * <code>string request_column_name = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return Whether the requestColumnName field is set.
     */
    @java.lang.Override
    public boolean hasRequestColumnName() {
      return readConfigCase_ == 5;
    }

    /**
     *
     *
     * <pre>
     * Optional. The column name in the underlying table that contains already
     * fully assembled requests.
     * </pre>
     *
     * <code>string request_column_name = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The requestColumnName.
     */
    @java.lang.Override
    public java.lang.String getRequestColumnName() {
      java.lang.Object ref = "";
      if (readConfigCase_ == 5) {
        ref = readConfig_;
      }
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (readConfigCase_ == 5) {
          readConfig_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The column name in the underlying table that contains already
     * fully assembled requests.
     * </pre>
     *
     * <code>string request_column_name = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for requestColumnName.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getRequestColumnNameBytes() {
      java.lang.Object ref = "";
      if (readConfigCase_ == 5) {
        ref = readConfig_;
      }
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (readConfigCase_ == 5) {
          readConfig_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The column name in the underlying table that contains already
     * fully assembled requests.
     * </pre>
     *
     * <code>string request_column_name = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The requestColumnName to set.
     * @return This builder for chaining.
     */
    public Builder setRequestColumnName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      readConfigCase_ = 5;
      readConfig_ = value;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The column name in the underlying table that contains already
     * fully assembled requests.
     * </pre>
     *
     * <code>string request_column_name = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRequestColumnName() {
      if (readConfigCase_ == 5) {
        readConfigCase_ = 0;
        readConfig_ = null;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The column name in the underlying table that contains already
     * fully assembled requests.
     * </pre>
     *
     * <code>string request_column_name = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for requestColumnName to set.
     * @return This builder for chaining.
     */
    public Builder setRequestColumnNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      readConfigCase_ = 5;
      readConfig_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object name_ = "";

    /**
     *
     *
     * <pre>
     * Required. The name of the Dataset resource. Used only for MULTIMODAL
     * datasets. Format:
     * `projects/{project}/locations/{location}/datasets/{dataset}`
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The name of the Dataset resource. Used only for MULTIMODAL
     * datasets. Format:
     * `projects/{project}/locations/{location}/datasets/{dataset}`
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The name of the Dataset resource. Used only for MULTIMODAL
     * datasets. Format:
     * `projects/{project}/locations/{location}/datasets/{dataset}`
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The name of the Dataset resource. Used only for MULTIMODAL
     * datasets. Format:
     * `projects/{project}/locations/{location}/datasets/{dataset}`
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000040);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The name of the Dataset resource. Used only for MULTIMODAL
     * datasets. Format:
     * `projects/{project}/locations/{location}/datasets/{dataset}`
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    private com.google.cloud.aiplatform.v1beta1.GeminiRequestReadConfig geminiRequestReadConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.GeminiRequestReadConfig,
            com.google.cloud.aiplatform.v1beta1.GeminiRequestReadConfig.Builder,
            com.google.cloud.aiplatform.v1beta1.GeminiRequestReadConfigOrBuilder>
        geminiRequestReadConfigBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. The Gemini request read config for the dataset.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.GeminiRequestReadConfig gemini_request_read_config = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the geminiRequestReadConfig field is set.
     */
    public boolean hasGeminiRequestReadConfig() {
      return ((bitField0_ & 0x00000080) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. The Gemini request read config for the dataset.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.GeminiRequestReadConfig gemini_request_read_config = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The geminiRequestReadConfig.
     */
    public com.google.cloud.aiplatform.v1beta1.GeminiRequestReadConfig
        getGeminiRequestReadConfig() {
      if (geminiRequestReadConfigBuilder_ == null) {
        return geminiRequestReadConfig_ == null
            ? com.google.cloud.aiplatform.v1beta1.GeminiRequestReadConfig.getDefaultInstance()
            : geminiRequestReadConfig_;
      } else {
        return geminiRequestReadConfigBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The Gemini request read config for the dataset.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.GeminiRequestReadConfig gemini_request_read_config = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setGeminiRequestReadConfig(
        com.google.cloud.aiplatform.v1beta1.GeminiRequestReadConfig value) {
      if (geminiRequestReadConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        geminiRequestReadConfig_ = value;
      } else {
        geminiRequestReadConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The Gemini request read config for the dataset.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.GeminiRequestReadConfig gemini_request_read_config = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setGeminiRequestReadConfig(
        com.google.cloud.aiplatform.v1beta1.GeminiRequestReadConfig.Builder builderForValue) {
      if (geminiRequestReadConfigBuilder_ == null) {
        geminiRequestReadConfig_ = builderForValue.build();
      } else {
        geminiRequestReadConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The Gemini request read config for the dataset.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.GeminiRequestReadConfig gemini_request_read_config = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeGeminiRequestReadConfig(
        com.google.cloud.aiplatform.v1beta1.GeminiRequestReadConfig value) {
      if (geminiRequestReadConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000080) != 0)
            && geminiRequestReadConfig_ != null
            && geminiRequestReadConfig_
                != com.google.cloud.aiplatform.v1beta1.GeminiRequestReadConfig
                    .getDefaultInstance()) {
          getGeminiRequestReadConfigBuilder().mergeFrom(value);
        } else {
          geminiRequestReadConfig_ = value;
        }
      } else {
        geminiRequestReadConfigBuilder_.mergeFrom(value);
      }
      if (geminiRequestReadConfig_ != null) {
        bitField0_ |= 0x00000080;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The Gemini request read config for the dataset.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.GeminiRequestReadConfig gemini_request_read_config = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearGeminiRequestReadConfig() {
      bitField0_ = (bitField0_ & ~0x00000080);
      geminiRequestReadConfig_ = null;
      if (geminiRequestReadConfigBuilder_ != null) {
        geminiRequestReadConfigBuilder_.dispose();
        geminiRequestReadConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The Gemini request read config for the dataset.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.GeminiRequestReadConfig gemini_request_read_config = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.GeminiRequestReadConfig.Builder
        getGeminiRequestReadConfigBuilder() {
      bitField0_ |= 0x00000080;
      onChanged();
      return getGeminiRequestReadConfigFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Optional. The Gemini request read config for the dataset.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.GeminiRequestReadConfig gemini_request_read_config = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.GeminiRequestReadConfigOrBuilder
        getGeminiRequestReadConfigOrBuilder() {
      if (geminiRequestReadConfigBuilder_ != null) {
        return geminiRequestReadConfigBuilder_.getMessageOrBuilder();
      } else {
        return geminiRequestReadConfig_ == null
            ? com.google.cloud.aiplatform.v1beta1.GeminiRequestReadConfig.getDefaultInstance()
            : geminiRequestReadConfig_;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The Gemini request read config for the dataset.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.GeminiRequestReadConfig gemini_request_read_config = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.GeminiRequestReadConfig,
            com.google.cloud.aiplatform.v1beta1.GeminiRequestReadConfig.Builder,
            com.google.cloud.aiplatform.v1beta1.GeminiRequestReadConfigOrBuilder>
        getGeminiRequestReadConfigFieldBuilder() {
      if (geminiRequestReadConfigBuilder_ == null) {
        geminiRequestReadConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.GeminiRequestReadConfig,
                com.google.cloud.aiplatform.v1beta1.GeminiRequestReadConfig.Builder,
                com.google.cloud.aiplatform.v1beta1.GeminiRequestReadConfigOrBuilder>(
                getGeminiRequestReadConfig(), getParentForChildren(), isClean());
        geminiRequestReadConfig_ = null;
      }
      return geminiRequestReadConfigBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.AssessDataRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.AssessDataRequest)
  private static final com.google.cloud.aiplatform.v1beta1.AssessDataRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.AssessDataRequest();
  }

  public static com.google.cloud.aiplatform.v1beta1.AssessDataRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<AssessDataRequest> PARSER =
      new com.google.protobuf.AbstractParser<AssessDataRequest>() {
        @java.lang.Override
        public AssessDataRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<AssessDataRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<AssessDataRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.AssessDataRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
