/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1beta1/model_garden_service.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.aiplatform.v1beta1;

/**
 *
 *
 * <pre>
 * Request message for
 * [ModelGardenService.Deploy][google.cloud.aiplatform.v1beta1.ModelGardenService.Deploy].
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1beta1.DeployRequest}
 */
public final class DeployRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.DeployRequest)
    DeployRequestOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use DeployRequest.newBuilder() to construct.
  private DeployRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private DeployRequest() {
    destination_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new DeployRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1beta1.ModelGardenServiceProto
        .internal_static_google_cloud_aiplatform_v1beta1_DeployRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1beta1.ModelGardenServiceProto
        .internal_static_google_cloud_aiplatform_v1beta1_DeployRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1beta1.DeployRequest.class,
            com.google.cloud.aiplatform.v1beta1.DeployRequest.Builder.class);
  }

  public interface ModelConfigOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1beta1.DeployRequest.ModelConfig)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Optional. Whether the user accepts the End User License Agreement (EULA)
     * for the model.
     * </pre>
     *
     * <code>bool accept_eula = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The acceptEula.
     */
    boolean getAcceptEula();

    /**
     *
     *
     * <pre>
     * Optional. The Hugging Face read access token used to access the model
     * artifacts of gated models.
     * </pre>
     *
     * <code>string hugging_face_access_token = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The huggingFaceAccessToken.
     */
    java.lang.String getHuggingFaceAccessToken();

    /**
     *
     *
     * <pre>
     * Optional. The Hugging Face read access token used to access the model
     * artifacts of gated models.
     * </pre>
     *
     * <code>string hugging_face_access_token = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for huggingFaceAccessToken.
     */
    com.google.protobuf.ByteString getHuggingFaceAccessTokenBytes();

    /**
     *
     *
     * <pre>
     * Optional. If true, the model will deploy with a cached version instead of
     * directly downloading the model artifacts from Hugging Face. This is
     * suitable for VPC-SC users with limited internet access.
     * </pre>
     *
     * <code>bool hugging_face_cache_enabled = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The huggingFaceCacheEnabled.
     */
    boolean getHuggingFaceCacheEnabled();

    /**
     *
     *
     * <pre>
     * Optional. The user-specified display name of the uploaded model. If not
     * set, a default name will be used.
     * </pre>
     *
     * <code>string model_display_name = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The modelDisplayName.
     */
    java.lang.String getModelDisplayName();

    /**
     *
     *
     * <pre>
     * Optional. The user-specified display name of the uploaded model. If not
     * set, a default name will be used.
     * </pre>
     *
     * <code>string model_display_name = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for modelDisplayName.
     */
    com.google.protobuf.ByteString getModelDisplayNameBytes();

    /**
     *
     *
     * <pre>
     * Optional. The specification of the container that is to be used when
     * deploying. If not set, the default container spec will be used.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelContainerSpec container_spec = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the containerSpec field is set.
     */
    boolean hasContainerSpec();

    /**
     *
     *
     * <pre>
     * Optional. The specification of the container that is to be used when
     * deploying. If not set, the default container spec will be used.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelContainerSpec container_spec = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The containerSpec.
     */
    com.google.cloud.aiplatform.v1beta1.ModelContainerSpec getContainerSpec();

    /**
     *
     *
     * <pre>
     * Optional. The specification of the container that is to be used when
     * deploying. If not set, the default container spec will be used.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelContainerSpec container_spec = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    com.google.cloud.aiplatform.v1beta1.ModelContainerSpecOrBuilder getContainerSpecOrBuilder();
  }

  /**
   *
   *
   * <pre>
   * The model config to use for the deployment.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.DeployRequest.ModelConfig}
   */
  public static final class ModelConfig extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.DeployRequest.ModelConfig)
      ModelConfigOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use ModelConfig.newBuilder() to construct.
    private ModelConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ModelConfig() {
      huggingFaceAccessToken_ = "";
      modelDisplayName_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new ModelConfig();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.ModelGardenServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_DeployRequest_ModelConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.ModelGardenServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_DeployRequest_ModelConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.DeployRequest.ModelConfig.class,
              com.google.cloud.aiplatform.v1beta1.DeployRequest.ModelConfig.Builder.class);
    }

    private int bitField0_;
    public static final int ACCEPT_EULA_FIELD_NUMBER = 1;
    private boolean acceptEula_ = false;

    /**
     *
     *
     * <pre>
     * Optional. Whether the user accepts the End User License Agreement (EULA)
     * for the model.
     * </pre>
     *
     * <code>bool accept_eula = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The acceptEula.
     */
    @java.lang.Override
    public boolean getAcceptEula() {
      return acceptEula_;
    }

    public static final int HUGGING_FACE_ACCESS_TOKEN_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object huggingFaceAccessToken_ = "";

    /**
     *
     *
     * <pre>
     * Optional. The Hugging Face read access token used to access the model
     * artifacts of gated models.
     * </pre>
     *
     * <code>string hugging_face_access_token = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The huggingFaceAccessToken.
     */
    @java.lang.Override
    public java.lang.String getHuggingFaceAccessToken() {
      java.lang.Object ref = huggingFaceAccessToken_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        huggingFaceAccessToken_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The Hugging Face read access token used to access the model
     * artifacts of gated models.
     * </pre>
     *
     * <code>string hugging_face_access_token = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for huggingFaceAccessToken.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getHuggingFaceAccessTokenBytes() {
      java.lang.Object ref = huggingFaceAccessToken_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        huggingFaceAccessToken_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int HUGGING_FACE_CACHE_ENABLED_FIELD_NUMBER = 3;
    private boolean huggingFaceCacheEnabled_ = false;

    /**
     *
     *
     * <pre>
     * Optional. If true, the model will deploy with a cached version instead of
     * directly downloading the model artifacts from Hugging Face. This is
     * suitable for VPC-SC users with limited internet access.
     * </pre>
     *
     * <code>bool hugging_face_cache_enabled = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The huggingFaceCacheEnabled.
     */
    @java.lang.Override
    public boolean getHuggingFaceCacheEnabled() {
      return huggingFaceCacheEnabled_;
    }

    public static final int MODEL_DISPLAY_NAME_FIELD_NUMBER = 4;

    @SuppressWarnings("serial")
    private volatile java.lang.Object modelDisplayName_ = "";

    /**
     *
     *
     * <pre>
     * Optional. The user-specified display name of the uploaded model. If not
     * set, a default name will be used.
     * </pre>
     *
     * <code>string model_display_name = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The modelDisplayName.
     */
    @java.lang.Override
    public java.lang.String getModelDisplayName() {
      java.lang.Object ref = modelDisplayName_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        modelDisplayName_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The user-specified display name of the uploaded model. If not
     * set, a default name will be used.
     * </pre>
     *
     * <code>string model_display_name = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for modelDisplayName.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getModelDisplayNameBytes() {
      java.lang.Object ref = modelDisplayName_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        modelDisplayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int CONTAINER_SPEC_FIELD_NUMBER = 5;
    private com.google.cloud.aiplatform.v1beta1.ModelContainerSpec containerSpec_;

    /**
     *
     *
     * <pre>
     * Optional. The specification of the container that is to be used when
     * deploying. If not set, the default container spec will be used.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelContainerSpec container_spec = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the containerSpec field is set.
     */
    @java.lang.Override
    public boolean hasContainerSpec() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. The specification of the container that is to be used when
     * deploying. If not set, the default container spec will be used.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelContainerSpec container_spec = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The containerSpec.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ModelContainerSpec getContainerSpec() {
      return containerSpec_ == null
          ? com.google.cloud.aiplatform.v1beta1.ModelContainerSpec.getDefaultInstance()
          : containerSpec_;
    }

    /**
     *
     *
     * <pre>
     * Optional. The specification of the container that is to be used when
     * deploying. If not set, the default container spec will be used.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelContainerSpec container_spec = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ModelContainerSpecOrBuilder
        getContainerSpecOrBuilder() {
      return containerSpec_ == null
          ? com.google.cloud.aiplatform.v1beta1.ModelContainerSpec.getDefaultInstance()
          : containerSpec_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (acceptEula_ != false) {
        output.writeBool(1, acceptEula_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(huggingFaceAccessToken_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, huggingFaceAccessToken_);
      }
      if (huggingFaceCacheEnabled_ != false) {
        output.writeBool(3, huggingFaceCacheEnabled_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(modelDisplayName_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 4, modelDisplayName_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(5, getContainerSpec());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (acceptEula_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(1, acceptEula_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(huggingFaceAccessToken_)) {
        size +=
            com.google.protobuf.GeneratedMessageV3.computeStringSize(2, huggingFaceAccessToken_);
      }
      if (huggingFaceCacheEnabled_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(3, huggingFaceCacheEnabled_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(modelDisplayName_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, modelDisplayName_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getContainerSpec());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.DeployRequest.ModelConfig)) {
        return super.equals(obj);
      }
      com.google.cloud.aiplatform.v1beta1.DeployRequest.ModelConfig other =
          (com.google.cloud.aiplatform.v1beta1.DeployRequest.ModelConfig) obj;

      if (getAcceptEula() != other.getAcceptEula()) return false;
      if (!getHuggingFaceAccessToken().equals(other.getHuggingFaceAccessToken())) return false;
      if (getHuggingFaceCacheEnabled() != other.getHuggingFaceCacheEnabled()) return false;
      if (!getModelDisplayName().equals(other.getModelDisplayName())) return false;
      if (hasContainerSpec() != other.hasContainerSpec()) return false;
      if (hasContainerSpec()) {
        if (!getContainerSpec().equals(other.getContainerSpec())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + ACCEPT_EULA_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getAcceptEula());
      hash = (37 * hash) + HUGGING_FACE_ACCESS_TOKEN_FIELD_NUMBER;
      hash = (53 * hash) + getHuggingFaceAccessToken().hashCode();
      hash = (37 * hash) + HUGGING_FACE_CACHE_ENABLED_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getHuggingFaceCacheEnabled());
      hash = (37 * hash) + MODEL_DISPLAY_NAME_FIELD_NUMBER;
      hash = (53 * hash) + getModelDisplayName().hashCode();
      if (hasContainerSpec()) {
        hash = (37 * hash) + CONTAINER_SPEC_FIELD_NUMBER;
        hash = (53 * hash) + getContainerSpec().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.aiplatform.v1beta1.DeployRequest.ModelConfig parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.DeployRequest.ModelConfig parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.DeployRequest.ModelConfig parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.DeployRequest.ModelConfig parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.DeployRequest.ModelConfig parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.DeployRequest.ModelConfig parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.DeployRequest.ModelConfig parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.DeployRequest.ModelConfig parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.DeployRequest.ModelConfig parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.DeployRequest.ModelConfig parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.DeployRequest.ModelConfig parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.DeployRequest.ModelConfig parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.aiplatform.v1beta1.DeployRequest.ModelConfig prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * The model config to use for the deployment.
     * </pre>
     *
     * Protobuf type {@code google.cloud.aiplatform.v1beta1.DeployRequest.ModelConfig}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.DeployRequest.ModelConfig)
        com.google.cloud.aiplatform.v1beta1.DeployRequest.ModelConfigOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1beta1.ModelGardenServiceProto
            .internal_static_google_cloud_aiplatform_v1beta1_DeployRequest_ModelConfig_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1beta1.ModelGardenServiceProto
            .internal_static_google_cloud_aiplatform_v1beta1_DeployRequest_ModelConfig_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1beta1.DeployRequest.ModelConfig.class,
                com.google.cloud.aiplatform.v1beta1.DeployRequest.ModelConfig.Builder.class);
      }

      // Construct using com.google.cloud.aiplatform.v1beta1.DeployRequest.ModelConfig.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getContainerSpecFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        acceptEula_ = false;
        huggingFaceAccessToken_ = "";
        huggingFaceCacheEnabled_ = false;
        modelDisplayName_ = "";
        containerSpec_ = null;
        if (containerSpecBuilder_ != null) {
          containerSpecBuilder_.dispose();
          containerSpecBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.aiplatform.v1beta1.ModelGardenServiceProto
            .internal_static_google_cloud_aiplatform_v1beta1_DeployRequest_ModelConfig_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.DeployRequest.ModelConfig
          getDefaultInstanceForType() {
        return com.google.cloud.aiplatform.v1beta1.DeployRequest.ModelConfig.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.DeployRequest.ModelConfig build() {
        com.google.cloud.aiplatform.v1beta1.DeployRequest.ModelConfig result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.DeployRequest.ModelConfig buildPartial() {
        com.google.cloud.aiplatform.v1beta1.DeployRequest.ModelConfig result =
            new com.google.cloud.aiplatform.v1beta1.DeployRequest.ModelConfig(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.aiplatform.v1beta1.DeployRequest.ModelConfig result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.acceptEula_ = acceptEula_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.huggingFaceAccessToken_ = huggingFaceAccessToken_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.huggingFaceCacheEnabled_ = huggingFaceCacheEnabled_;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.modelDisplayName_ = modelDisplayName_;
        }
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000010) != 0)) {
          result.containerSpec_ =
              containerSpecBuilder_ == null ? containerSpec_ : containerSpecBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.aiplatform.v1beta1.DeployRequest.ModelConfig) {
          return mergeFrom((com.google.cloud.aiplatform.v1beta1.DeployRequest.ModelConfig) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.aiplatform.v1beta1.DeployRequest.ModelConfig other) {
        if (other
            == com.google.cloud.aiplatform.v1beta1.DeployRequest.ModelConfig.getDefaultInstance())
          return this;
        if (other.getAcceptEula() != false) {
          setAcceptEula(other.getAcceptEula());
        }
        if (!other.getHuggingFaceAccessToken().isEmpty()) {
          huggingFaceAccessToken_ = other.huggingFaceAccessToken_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        if (other.getHuggingFaceCacheEnabled() != false) {
          setHuggingFaceCacheEnabled(other.getHuggingFaceCacheEnabled());
        }
        if (!other.getModelDisplayName().isEmpty()) {
          modelDisplayName_ = other.modelDisplayName_;
          bitField0_ |= 0x00000008;
          onChanged();
        }
        if (other.hasContainerSpec()) {
          mergeContainerSpec(other.getContainerSpec());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  acceptEula_ = input.readBool();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 8
              case 18:
                {
                  huggingFaceAccessToken_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              case 24:
                {
                  huggingFaceCacheEnabled_ = input.readBool();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 24
              case 34:
                {
                  modelDisplayName_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000008;
                  break;
                } // case 34
              case 42:
                {
                  input.readMessage(getContainerSpecFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000010;
                  break;
                } // case 42
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private boolean acceptEula_;

      /**
       *
       *
       * <pre>
       * Optional. Whether the user accepts the End User License Agreement (EULA)
       * for the model.
       * </pre>
       *
       * <code>bool accept_eula = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The acceptEula.
       */
      @java.lang.Override
      public boolean getAcceptEula() {
        return acceptEula_;
      }

      /**
       *
       *
       * <pre>
       * Optional. Whether the user accepts the End User License Agreement (EULA)
       * for the model.
       * </pre>
       *
       * <code>bool accept_eula = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The acceptEula to set.
       * @return This builder for chaining.
       */
      public Builder setAcceptEula(boolean value) {

        acceptEula_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Whether the user accepts the End User License Agreement (EULA)
       * for the model.
       * </pre>
       *
       * <code>bool accept_eula = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearAcceptEula() {
        bitField0_ = (bitField0_ & ~0x00000001);
        acceptEula_ = false;
        onChanged();
        return this;
      }

      private java.lang.Object huggingFaceAccessToken_ = "";

      /**
       *
       *
       * <pre>
       * Optional. The Hugging Face read access token used to access the model
       * artifacts of gated models.
       * </pre>
       *
       * <code>string hugging_face_access_token = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The huggingFaceAccessToken.
       */
      public java.lang.String getHuggingFaceAccessToken() {
        java.lang.Object ref = huggingFaceAccessToken_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          huggingFaceAccessToken_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. The Hugging Face read access token used to access the model
       * artifacts of gated models.
       * </pre>
       *
       * <code>string hugging_face_access_token = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The bytes for huggingFaceAccessToken.
       */
      public com.google.protobuf.ByteString getHuggingFaceAccessTokenBytes() {
        java.lang.Object ref = huggingFaceAccessToken_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          huggingFaceAccessToken_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. The Hugging Face read access token used to access the model
       * artifacts of gated models.
       * </pre>
       *
       * <code>string hugging_face_access_token = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @param value The huggingFaceAccessToken to set.
       * @return This builder for chaining.
       */
      public Builder setHuggingFaceAccessToken(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        huggingFaceAccessToken_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. The Hugging Face read access token used to access the model
       * artifacts of gated models.
       * </pre>
       *
       * <code>string hugging_face_access_token = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearHuggingFaceAccessToken() {
        huggingFaceAccessToken_ = getDefaultInstance().getHuggingFaceAccessToken();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. The Hugging Face read access token used to access the model
       * artifacts of gated models.
       * </pre>
       *
       * <code>string hugging_face_access_token = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @param value The bytes for huggingFaceAccessToken to set.
       * @return This builder for chaining.
       */
      public Builder setHuggingFaceAccessTokenBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        huggingFaceAccessToken_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      private boolean huggingFaceCacheEnabled_;

      /**
       *
       *
       * <pre>
       * Optional. If true, the model will deploy with a cached version instead of
       * directly downloading the model artifacts from Hugging Face. This is
       * suitable for VPC-SC users with limited internet access.
       * </pre>
       *
       * <code>bool hugging_face_cache_enabled = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The huggingFaceCacheEnabled.
       */
      @java.lang.Override
      public boolean getHuggingFaceCacheEnabled() {
        return huggingFaceCacheEnabled_;
      }

      /**
       *
       *
       * <pre>
       * Optional. If true, the model will deploy with a cached version instead of
       * directly downloading the model artifacts from Hugging Face. This is
       * suitable for VPC-SC users with limited internet access.
       * </pre>
       *
       * <code>bool hugging_face_cache_enabled = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The huggingFaceCacheEnabled to set.
       * @return This builder for chaining.
       */
      public Builder setHuggingFaceCacheEnabled(boolean value) {

        huggingFaceCacheEnabled_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. If true, the model will deploy with a cached version instead of
       * directly downloading the model artifacts from Hugging Face. This is
       * suitable for VPC-SC users with limited internet access.
       * </pre>
       *
       * <code>bool hugging_face_cache_enabled = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearHuggingFaceCacheEnabled() {
        bitField0_ = (bitField0_ & ~0x00000004);
        huggingFaceCacheEnabled_ = false;
        onChanged();
        return this;
      }

      private java.lang.Object modelDisplayName_ = "";

      /**
       *
       *
       * <pre>
       * Optional. The user-specified display name of the uploaded model. If not
       * set, a default name will be used.
       * </pre>
       *
       * <code>string model_display_name = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The modelDisplayName.
       */
      public java.lang.String getModelDisplayName() {
        java.lang.Object ref = modelDisplayName_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          modelDisplayName_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. The user-specified display name of the uploaded model. If not
       * set, a default name will be used.
       * </pre>
       *
       * <code>string model_display_name = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for modelDisplayName.
       */
      public com.google.protobuf.ByteString getModelDisplayNameBytes() {
        java.lang.Object ref = modelDisplayName_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          modelDisplayName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. The user-specified display name of the uploaded model. If not
       * set, a default name will be used.
       * </pre>
       *
       * <code>string model_display_name = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The modelDisplayName to set.
       * @return This builder for chaining.
       */
      public Builder setModelDisplayName(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        modelDisplayName_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. The user-specified display name of the uploaded model. If not
       * set, a default name will be used.
       * </pre>
       *
       * <code>string model_display_name = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearModelDisplayName() {
        modelDisplayName_ = getDefaultInstance().getModelDisplayName();
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. The user-specified display name of the uploaded model. If not
       * set, a default name will be used.
       * </pre>
       *
       * <code>string model_display_name = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The bytes for modelDisplayName to set.
       * @return This builder for chaining.
       */
      public Builder setModelDisplayNameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        modelDisplayName_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }

      private com.google.cloud.aiplatform.v1beta1.ModelContainerSpec containerSpec_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1beta1.ModelContainerSpec,
              com.google.cloud.aiplatform.v1beta1.ModelContainerSpec.Builder,
              com.google.cloud.aiplatform.v1beta1.ModelContainerSpecOrBuilder>
          containerSpecBuilder_;

      /**
       *
       *
       * <pre>
       * Optional. The specification of the container that is to be used when
       * deploying. If not set, the default container spec will be used.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.ModelContainerSpec container_spec = 5 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return Whether the containerSpec field is set.
       */
      public boolean hasContainerSpec() {
        return ((bitField0_ & 0x00000010) != 0);
      }

      /**
       *
       *
       * <pre>
       * Optional. The specification of the container that is to be used when
       * deploying. If not set, the default container spec will be used.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.ModelContainerSpec container_spec = 5 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The containerSpec.
       */
      public com.google.cloud.aiplatform.v1beta1.ModelContainerSpec getContainerSpec() {
        if (containerSpecBuilder_ == null) {
          return containerSpec_ == null
              ? com.google.cloud.aiplatform.v1beta1.ModelContainerSpec.getDefaultInstance()
              : containerSpec_;
        } else {
          return containerSpecBuilder_.getMessage();
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. The specification of the container that is to be used when
       * deploying. If not set, the default container spec will be used.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.ModelContainerSpec container_spec = 5 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setContainerSpec(
          com.google.cloud.aiplatform.v1beta1.ModelContainerSpec value) {
        if (containerSpecBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          containerSpec_ = value;
        } else {
          containerSpecBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. The specification of the container that is to be used when
       * deploying. If not set, the default container spec will be used.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.ModelContainerSpec container_spec = 5 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setContainerSpec(
          com.google.cloud.aiplatform.v1beta1.ModelContainerSpec.Builder builderForValue) {
        if (containerSpecBuilder_ == null) {
          containerSpec_ = builderForValue.build();
        } else {
          containerSpecBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. The specification of the container that is to be used when
       * deploying. If not set, the default container spec will be used.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.ModelContainerSpec container_spec = 5 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder mergeContainerSpec(
          com.google.cloud.aiplatform.v1beta1.ModelContainerSpec value) {
        if (containerSpecBuilder_ == null) {
          if (((bitField0_ & 0x00000010) != 0)
              && containerSpec_ != null
              && containerSpec_
                  != com.google.cloud.aiplatform.v1beta1.ModelContainerSpec.getDefaultInstance()) {
            getContainerSpecBuilder().mergeFrom(value);
          } else {
            containerSpec_ = value;
          }
        } else {
          containerSpecBuilder_.mergeFrom(value);
        }
        if (containerSpec_ != null) {
          bitField0_ |= 0x00000010;
          onChanged();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. The specification of the container that is to be used when
       * deploying. If not set, the default container spec will be used.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.ModelContainerSpec container_spec = 5 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder clearContainerSpec() {
        bitField0_ = (bitField0_ & ~0x00000010);
        containerSpec_ = null;
        if (containerSpecBuilder_ != null) {
          containerSpecBuilder_.dispose();
          containerSpecBuilder_ = null;
        }
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. The specification of the container that is to be used when
       * deploying. If not set, the default container spec will be used.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.ModelContainerSpec container_spec = 5 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.cloud.aiplatform.v1beta1.ModelContainerSpec.Builder
          getContainerSpecBuilder() {
        bitField0_ |= 0x00000010;
        onChanged();
        return getContainerSpecFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * Optional. The specification of the container that is to be used when
       * deploying. If not set, the default container spec will be used.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.ModelContainerSpec container_spec = 5 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.cloud.aiplatform.v1beta1.ModelContainerSpecOrBuilder
          getContainerSpecOrBuilder() {
        if (containerSpecBuilder_ != null) {
          return containerSpecBuilder_.getMessageOrBuilder();
        } else {
          return containerSpec_ == null
              ? com.google.cloud.aiplatform.v1beta1.ModelContainerSpec.getDefaultInstance()
              : containerSpec_;
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. The specification of the container that is to be used when
       * deploying. If not set, the default container spec will be used.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.ModelContainerSpec container_spec = 5 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1beta1.ModelContainerSpec,
              com.google.cloud.aiplatform.v1beta1.ModelContainerSpec.Builder,
              com.google.cloud.aiplatform.v1beta1.ModelContainerSpecOrBuilder>
          getContainerSpecFieldBuilder() {
        if (containerSpecBuilder_ == null) {
          containerSpecBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.aiplatform.v1beta1.ModelContainerSpec,
                  com.google.cloud.aiplatform.v1beta1.ModelContainerSpec.Builder,
                  com.google.cloud.aiplatform.v1beta1.ModelContainerSpecOrBuilder>(
                  getContainerSpec(), getParentForChildren(), isClean());
          containerSpec_ = null;
        }
        return containerSpecBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.DeployRequest.ModelConfig)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.DeployRequest.ModelConfig)
    private static final com.google.cloud.aiplatform.v1beta1.DeployRequest.ModelConfig
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.DeployRequest.ModelConfig();
    }

    public static com.google.cloud.aiplatform.v1beta1.DeployRequest.ModelConfig
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ModelConfig> PARSER =
        new com.google.protobuf.AbstractParser<ModelConfig>() {
          @java.lang.Override
          public ModelConfig parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<ModelConfig> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ModelConfig> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.DeployRequest.ModelConfig
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface EndpointConfigOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1beta1.DeployRequest.EndpointConfig)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Optional. The user-specified display name of the endpoint. If not set, a
     * default name will be used.
     * </pre>
     *
     * <code>string endpoint_display_name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The endpointDisplayName.
     */
    java.lang.String getEndpointDisplayName();

    /**
     *
     *
     * <pre>
     * Optional. The user-specified display name of the endpoint. If not set, a
     * default name will be used.
     * </pre>
     *
     * <code>string endpoint_display_name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for endpointDisplayName.
     */
    com.google.protobuf.ByteString getEndpointDisplayNameBytes();

    /**
     *
     *
     * <pre>
     * Optional. If true, the endpoint will be exposed through a dedicated
     * DNS [Endpoint.dedicated_endpoint_dns]. Your request to the dedicated DNS
     * will be isolated from other users' traffic and will have better
     * performance and reliability. Note: Once you enabled dedicated endpoint,
     * you won't be able to send request to the shared DNS
     * {region}-aiplatform.googleapis.com. The limitations will be removed soon.
     * </pre>
     *
     * <code>bool dedicated_endpoint_enabled = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The dedicatedEndpointEnabled.
     */
    boolean getDedicatedEndpointEnabled();
  }

  /**
   *
   *
   * <pre>
   * The endpoint config to use for the deployment.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.DeployRequest.EndpointConfig}
   */
  public static final class EndpointConfig extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.DeployRequest.EndpointConfig)
      EndpointConfigOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use EndpointConfig.newBuilder() to construct.
    private EndpointConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private EndpointConfig() {
      endpointDisplayName_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new EndpointConfig();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.ModelGardenServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_DeployRequest_EndpointConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.ModelGardenServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_DeployRequest_EndpointConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.DeployRequest.EndpointConfig.class,
              com.google.cloud.aiplatform.v1beta1.DeployRequest.EndpointConfig.Builder.class);
    }

    public static final int ENDPOINT_DISPLAY_NAME_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object endpointDisplayName_ = "";

    /**
     *
     *
     * <pre>
     * Optional. The user-specified display name of the endpoint. If not set, a
     * default name will be used.
     * </pre>
     *
     * <code>string endpoint_display_name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The endpointDisplayName.
     */
    @java.lang.Override
    public java.lang.String getEndpointDisplayName() {
      java.lang.Object ref = endpointDisplayName_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        endpointDisplayName_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The user-specified display name of the endpoint. If not set, a
     * default name will be used.
     * </pre>
     *
     * <code>string endpoint_display_name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for endpointDisplayName.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getEndpointDisplayNameBytes() {
      java.lang.Object ref = endpointDisplayName_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        endpointDisplayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int DEDICATED_ENDPOINT_ENABLED_FIELD_NUMBER = 2;
    private boolean dedicatedEndpointEnabled_ = false;

    /**
     *
     *
     * <pre>
     * Optional. If true, the endpoint will be exposed through a dedicated
     * DNS [Endpoint.dedicated_endpoint_dns]. Your request to the dedicated DNS
     * will be isolated from other users' traffic and will have better
     * performance and reliability. Note: Once you enabled dedicated endpoint,
     * you won't be able to send request to the shared DNS
     * {region}-aiplatform.googleapis.com. The limitations will be removed soon.
     * </pre>
     *
     * <code>bool dedicated_endpoint_enabled = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The dedicatedEndpointEnabled.
     */
    @java.lang.Override
    public boolean getDedicatedEndpointEnabled() {
      return dedicatedEndpointEnabled_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(endpointDisplayName_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, endpointDisplayName_);
      }
      if (dedicatedEndpointEnabled_ != false) {
        output.writeBool(2, dedicatedEndpointEnabled_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(endpointDisplayName_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, endpointDisplayName_);
      }
      if (dedicatedEndpointEnabled_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(2, dedicatedEndpointEnabled_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.DeployRequest.EndpointConfig)) {
        return super.equals(obj);
      }
      com.google.cloud.aiplatform.v1beta1.DeployRequest.EndpointConfig other =
          (com.google.cloud.aiplatform.v1beta1.DeployRequest.EndpointConfig) obj;

      if (!getEndpointDisplayName().equals(other.getEndpointDisplayName())) return false;
      if (getDedicatedEndpointEnabled() != other.getDedicatedEndpointEnabled()) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + ENDPOINT_DISPLAY_NAME_FIELD_NUMBER;
      hash = (53 * hash) + getEndpointDisplayName().hashCode();
      hash = (37 * hash) + DEDICATED_ENDPOINT_ENABLED_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getDedicatedEndpointEnabled());
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.aiplatform.v1beta1.DeployRequest.EndpointConfig parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.DeployRequest.EndpointConfig parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.DeployRequest.EndpointConfig parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.DeployRequest.EndpointConfig parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.DeployRequest.EndpointConfig parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.DeployRequest.EndpointConfig parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.DeployRequest.EndpointConfig parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.DeployRequest.EndpointConfig parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.DeployRequest.EndpointConfig
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.DeployRequest.EndpointConfig
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.DeployRequest.EndpointConfig parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.DeployRequest.EndpointConfig parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.aiplatform.v1beta1.DeployRequest.EndpointConfig prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * The endpoint config to use for the deployment.
     * </pre>
     *
     * Protobuf type {@code google.cloud.aiplatform.v1beta1.DeployRequest.EndpointConfig}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.DeployRequest.EndpointConfig)
        com.google.cloud.aiplatform.v1beta1.DeployRequest.EndpointConfigOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1beta1.ModelGardenServiceProto
            .internal_static_google_cloud_aiplatform_v1beta1_DeployRequest_EndpointConfig_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1beta1.ModelGardenServiceProto
            .internal_static_google_cloud_aiplatform_v1beta1_DeployRequest_EndpointConfig_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1beta1.DeployRequest.EndpointConfig.class,
                com.google.cloud.aiplatform.v1beta1.DeployRequest.EndpointConfig.Builder.class);
      }

      // Construct using
      // com.google.cloud.aiplatform.v1beta1.DeployRequest.EndpointConfig.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        endpointDisplayName_ = "";
        dedicatedEndpointEnabled_ = false;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.aiplatform.v1beta1.ModelGardenServiceProto
            .internal_static_google_cloud_aiplatform_v1beta1_DeployRequest_EndpointConfig_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.DeployRequest.EndpointConfig
          getDefaultInstanceForType() {
        return com.google.cloud.aiplatform.v1beta1.DeployRequest.EndpointConfig
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.DeployRequest.EndpointConfig build() {
        com.google.cloud.aiplatform.v1beta1.DeployRequest.EndpointConfig result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.DeployRequest.EndpointConfig buildPartial() {
        com.google.cloud.aiplatform.v1beta1.DeployRequest.EndpointConfig result =
            new com.google.cloud.aiplatform.v1beta1.DeployRequest.EndpointConfig(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.aiplatform.v1beta1.DeployRequest.EndpointConfig result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.endpointDisplayName_ = endpointDisplayName_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.dedicatedEndpointEnabled_ = dedicatedEndpointEnabled_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.aiplatform.v1beta1.DeployRequest.EndpointConfig) {
          return mergeFrom(
              (com.google.cloud.aiplatform.v1beta1.DeployRequest.EndpointConfig) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.aiplatform.v1beta1.DeployRequest.EndpointConfig other) {
        if (other
            == com.google.cloud.aiplatform.v1beta1.DeployRequest.EndpointConfig
                .getDefaultInstance()) return this;
        if (!other.getEndpointDisplayName().isEmpty()) {
          endpointDisplayName_ = other.endpointDisplayName_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (other.getDedicatedEndpointEnabled() != false) {
          setDedicatedEndpointEnabled(other.getDedicatedEndpointEnabled());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  endpointDisplayName_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 16:
                {
                  dedicatedEndpointEnabled_ = input.readBool();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 16
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object endpointDisplayName_ = "";

      /**
       *
       *
       * <pre>
       * Optional. The user-specified display name of the endpoint. If not set, a
       * default name will be used.
       * </pre>
       *
       * <code>string endpoint_display_name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The endpointDisplayName.
       */
      public java.lang.String getEndpointDisplayName() {
        java.lang.Object ref = endpointDisplayName_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          endpointDisplayName_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. The user-specified display name of the endpoint. If not set, a
       * default name will be used.
       * </pre>
       *
       * <code>string endpoint_display_name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for endpointDisplayName.
       */
      public com.google.protobuf.ByteString getEndpointDisplayNameBytes() {
        java.lang.Object ref = endpointDisplayName_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          endpointDisplayName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. The user-specified display name of the endpoint. If not set, a
       * default name will be used.
       * </pre>
       *
       * <code>string endpoint_display_name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The endpointDisplayName to set.
       * @return This builder for chaining.
       */
      public Builder setEndpointDisplayName(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        endpointDisplayName_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. The user-specified display name of the endpoint. If not set, a
       * default name will be used.
       * </pre>
       *
       * <code>string endpoint_display_name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearEndpointDisplayName() {
        endpointDisplayName_ = getDefaultInstance().getEndpointDisplayName();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. The user-specified display name of the endpoint. If not set, a
       * default name will be used.
       * </pre>
       *
       * <code>string endpoint_display_name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The bytes for endpointDisplayName to set.
       * @return This builder for chaining.
       */
      public Builder setEndpointDisplayNameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        endpointDisplayName_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private boolean dedicatedEndpointEnabled_;

      /**
       *
       *
       * <pre>
       * Optional. If true, the endpoint will be exposed through a dedicated
       * DNS [Endpoint.dedicated_endpoint_dns]. Your request to the dedicated DNS
       * will be isolated from other users' traffic and will have better
       * performance and reliability. Note: Once you enabled dedicated endpoint,
       * you won't be able to send request to the shared DNS
       * {region}-aiplatform.googleapis.com. The limitations will be removed soon.
       * </pre>
       *
       * <code>bool dedicated_endpoint_enabled = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The dedicatedEndpointEnabled.
       */
      @java.lang.Override
      public boolean getDedicatedEndpointEnabled() {
        return dedicatedEndpointEnabled_;
      }

      /**
       *
       *
       * <pre>
       * Optional. If true, the endpoint will be exposed through a dedicated
       * DNS [Endpoint.dedicated_endpoint_dns]. Your request to the dedicated DNS
       * will be isolated from other users' traffic and will have better
       * performance and reliability. Note: Once you enabled dedicated endpoint,
       * you won't be able to send request to the shared DNS
       * {region}-aiplatform.googleapis.com. The limitations will be removed soon.
       * </pre>
       *
       * <code>bool dedicated_endpoint_enabled = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The dedicatedEndpointEnabled to set.
       * @return This builder for chaining.
       */
      public Builder setDedicatedEndpointEnabled(boolean value) {

        dedicatedEndpointEnabled_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. If true, the endpoint will be exposed through a dedicated
       * DNS [Endpoint.dedicated_endpoint_dns]. Your request to the dedicated DNS
       * will be isolated from other users' traffic and will have better
       * performance and reliability. Note: Once you enabled dedicated endpoint,
       * you won't be able to send request to the shared DNS
       * {region}-aiplatform.googleapis.com. The limitations will be removed soon.
       * </pre>
       *
       * <code>bool dedicated_endpoint_enabled = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearDedicatedEndpointEnabled() {
        bitField0_ = (bitField0_ & ~0x00000002);
        dedicatedEndpointEnabled_ = false;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.DeployRequest.EndpointConfig)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.DeployRequest.EndpointConfig)
    private static final com.google.cloud.aiplatform.v1beta1.DeployRequest.EndpointConfig
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.DeployRequest.EndpointConfig();
    }

    public static com.google.cloud.aiplatform.v1beta1.DeployRequest.EndpointConfig
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<EndpointConfig> PARSER =
        new com.google.protobuf.AbstractParser<EndpointConfig>() {
          @java.lang.Override
          public EndpointConfig parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<EndpointConfig> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<EndpointConfig> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.DeployRequest.EndpointConfig
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface DeployConfigOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1beta1.DeployRequest.DeployConfig)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Optional. The dedicated resources to use for the endpoint. If not set,
     * the default resources will be used.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.DedicatedResources dedicated_resources = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the dedicatedResources field is set.
     */
    boolean hasDedicatedResources();

    /**
     *
     *
     * <pre>
     * Optional. The dedicated resources to use for the endpoint. If not set,
     * the default resources will be used.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.DedicatedResources dedicated_resources = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The dedicatedResources.
     */
    com.google.cloud.aiplatform.v1beta1.DedicatedResources getDedicatedResources();

    /**
     *
     *
     * <pre>
     * Optional. The dedicated resources to use for the endpoint. If not set,
     * the default resources will be used.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.DedicatedResources dedicated_resources = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    com.google.cloud.aiplatform.v1beta1.DedicatedResourcesOrBuilder
        getDedicatedResourcesOrBuilder();

    /**
     *
     *
     * <pre>
     * Optional. If true, enable the QMT fast tryout feature for this model if
     * possible.
     * </pre>
     *
     * <code>bool fast_tryout_enabled = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The fastTryoutEnabled.
     */
    boolean getFastTryoutEnabled();

    /**
     *
     *
     * <pre>
     * Optional. System labels for Model Garden deployments.
     * These labels are managed by Google and for tracking purposes only.
     * </pre>
     *
     * <code>map&lt;string, string&gt; system_labels = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    int getSystemLabelsCount();

    /**
     *
     *
     * <pre>
     * Optional. System labels for Model Garden deployments.
     * These labels are managed by Google and for tracking purposes only.
     * </pre>
     *
     * <code>map&lt;string, string&gt; system_labels = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    boolean containsSystemLabels(java.lang.String key);

    /** Use {@link #getSystemLabelsMap()} instead. */
    @java.lang.Deprecated
    java.util.Map<java.lang.String, java.lang.String> getSystemLabels();

    /**
     *
     *
     * <pre>
     * Optional. System labels for Model Garden deployments.
     * These labels are managed by Google and for tracking purposes only.
     * </pre>
     *
     * <code>map&lt;string, string&gt; system_labels = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    java.util.Map<java.lang.String, java.lang.String> getSystemLabelsMap();

    /**
     *
     *
     * <pre>
     * Optional. System labels for Model Garden deployments.
     * These labels are managed by Google and for tracking purposes only.
     * </pre>
     *
     * <code>map&lt;string, string&gt; system_labels = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    /* nullable */
    java.lang.String getSystemLabelsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue);

    /**
     *
     *
     * <pre>
     * Optional. System labels for Model Garden deployments.
     * These labels are managed by Google and for tracking purposes only.
     * </pre>
     *
     * <code>map&lt;string, string&gt; system_labels = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    java.lang.String getSystemLabelsOrThrow(java.lang.String key);
  }

  /**
   *
   *
   * <pre>
   * The deploy config to use for the deployment.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.DeployRequest.DeployConfig}
   */
  public static final class DeployConfig extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.DeployRequest.DeployConfig)
      DeployConfigOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use DeployConfig.newBuilder() to construct.
    private DeployConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private DeployConfig() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new DeployConfig();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.ModelGardenServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_DeployRequest_DeployConfig_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    @java.lang.Override
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 3:
          return internalGetSystemLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.ModelGardenServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_DeployRequest_DeployConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.DeployRequest.DeployConfig.class,
              com.google.cloud.aiplatform.v1beta1.DeployRequest.DeployConfig.Builder.class);
    }

    private int bitField0_;
    public static final int DEDICATED_RESOURCES_FIELD_NUMBER = 1;
    private com.google.cloud.aiplatform.v1beta1.DedicatedResources dedicatedResources_;

    /**
     *
     *
     * <pre>
     * Optional. The dedicated resources to use for the endpoint. If not set,
     * the default resources will be used.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.DedicatedResources dedicated_resources = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the dedicatedResources field is set.
     */
    @java.lang.Override
    public boolean hasDedicatedResources() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. The dedicated resources to use for the endpoint. If not set,
     * the default resources will be used.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.DedicatedResources dedicated_resources = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The dedicatedResources.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.DedicatedResources getDedicatedResources() {
      return dedicatedResources_ == null
          ? com.google.cloud.aiplatform.v1beta1.DedicatedResources.getDefaultInstance()
          : dedicatedResources_;
    }

    /**
     *
     *
     * <pre>
     * Optional. The dedicated resources to use for the endpoint. If not set,
     * the default resources will be used.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.DedicatedResources dedicated_resources = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.DedicatedResourcesOrBuilder
        getDedicatedResourcesOrBuilder() {
      return dedicatedResources_ == null
          ? com.google.cloud.aiplatform.v1beta1.DedicatedResources.getDefaultInstance()
          : dedicatedResources_;
    }

    public static final int FAST_TRYOUT_ENABLED_FIELD_NUMBER = 2;
    private boolean fastTryoutEnabled_ = false;

    /**
     *
     *
     * <pre>
     * Optional. If true, enable the QMT fast tryout feature for this model if
     * possible.
     * </pre>
     *
     * <code>bool fast_tryout_enabled = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The fastTryoutEnabled.
     */
    @java.lang.Override
    public boolean getFastTryoutEnabled() {
      return fastTryoutEnabled_;
    }

    public static final int SYSTEM_LABELS_FIELD_NUMBER = 3;

    private static final class SystemLabelsDefaultEntryHolder {
      static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
          com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
              com.google.cloud.aiplatform.v1beta1.ModelGardenServiceProto
                  .internal_static_google_cloud_aiplatform_v1beta1_DeployRequest_DeployConfig_SystemLabelsEntry_descriptor,
              com.google.protobuf.WireFormat.FieldType.STRING,
              "",
              com.google.protobuf.WireFormat.FieldType.STRING,
              "");
    }

    @SuppressWarnings("serial")
    private com.google.protobuf.MapField<java.lang.String, java.lang.String> systemLabels_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetSystemLabels() {
      if (systemLabels_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            SystemLabelsDefaultEntryHolder.defaultEntry);
      }
      return systemLabels_;
    }

    public int getSystemLabelsCount() {
      return internalGetSystemLabels().getMap().size();
    }

    /**
     *
     *
     * <pre>
     * Optional. System labels for Model Garden deployments.
     * These labels are managed by Google and for tracking purposes only.
     * </pre>
     *
     * <code>map&lt;string, string&gt; system_labels = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public boolean containsSystemLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetSystemLabels().getMap().containsKey(key);
    }

    /** Use {@link #getSystemLabelsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getSystemLabels() {
      return getSystemLabelsMap();
    }

    /**
     *
     *
     * <pre>
     * Optional. System labels for Model Garden deployments.
     * These labels are managed by Google and for tracking purposes only.
     * </pre>
     *
     * <code>map&lt;string, string&gt; system_labels = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getSystemLabelsMap() {
      return internalGetSystemLabels().getMap();
    }

    /**
     *
     *
     * <pre>
     * Optional. System labels for Model Garden deployments.
     * These labels are managed by Google and for tracking purposes only.
     * </pre>
     *
     * <code>map&lt;string, string&gt; system_labels = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getSystemLabelsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetSystemLabels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }

    /**
     *
     *
     * <pre>
     * Optional. System labels for Model Garden deployments.
     * These labels are managed by Google and for tracking purposes only.
     * </pre>
     *
     * <code>map&lt;string, string&gt; system_labels = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public java.lang.String getSystemLabelsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetSystemLabels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(1, getDedicatedResources());
      }
      if (fastTryoutEnabled_ != false) {
        output.writeBool(2, fastTryoutEnabled_);
      }
      com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
          output, internalGetSystemLabels(), SystemLabelsDefaultEntryHolder.defaultEntry, 3);
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(1, getDedicatedResources());
      }
      if (fastTryoutEnabled_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(2, fastTryoutEnabled_);
      }
      for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
          internalGetSystemLabels().getMap().entrySet()) {
        com.google.protobuf.MapEntry<java.lang.String, java.lang.String> systemLabels__ =
            SystemLabelsDefaultEntryHolder.defaultEntry
                .newBuilderForType()
                .setKey(entry.getKey())
                .setValue(entry.getValue())
                .build();
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, systemLabels__);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.DeployRequest.DeployConfig)) {
        return super.equals(obj);
      }
      com.google.cloud.aiplatform.v1beta1.DeployRequest.DeployConfig other =
          (com.google.cloud.aiplatform.v1beta1.DeployRequest.DeployConfig) obj;

      if (hasDedicatedResources() != other.hasDedicatedResources()) return false;
      if (hasDedicatedResources()) {
        if (!getDedicatedResources().equals(other.getDedicatedResources())) return false;
      }
      if (getFastTryoutEnabled() != other.getFastTryoutEnabled()) return false;
      if (!internalGetSystemLabels().equals(other.internalGetSystemLabels())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasDedicatedResources()) {
        hash = (37 * hash) + DEDICATED_RESOURCES_FIELD_NUMBER;
        hash = (53 * hash) + getDedicatedResources().hashCode();
      }
      hash = (37 * hash) + FAST_TRYOUT_ENABLED_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getFastTryoutEnabled());
      if (!internalGetSystemLabels().getMap().isEmpty()) {
        hash = (37 * hash) + SYSTEM_LABELS_FIELD_NUMBER;
        hash = (53 * hash) + internalGetSystemLabels().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.aiplatform.v1beta1.DeployRequest.DeployConfig parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.DeployRequest.DeployConfig parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.DeployRequest.DeployConfig parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.DeployRequest.DeployConfig parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.DeployRequest.DeployConfig parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.DeployRequest.DeployConfig parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.DeployRequest.DeployConfig parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.DeployRequest.DeployConfig parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.DeployRequest.DeployConfig parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.DeployRequest.DeployConfig parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.DeployRequest.DeployConfig parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.DeployRequest.DeployConfig parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.aiplatform.v1beta1.DeployRequest.DeployConfig prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * The deploy config to use for the deployment.
     * </pre>
     *
     * Protobuf type {@code google.cloud.aiplatform.v1beta1.DeployRequest.DeployConfig}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.DeployRequest.DeployConfig)
        com.google.cloud.aiplatform.v1beta1.DeployRequest.DeployConfigOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1beta1.ModelGardenServiceProto
            .internal_static_google_cloud_aiplatform_v1beta1_DeployRequest_DeployConfig_descriptor;
      }

      @SuppressWarnings({"rawtypes"})
      protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
          int number) {
        switch (number) {
          case 3:
            return internalGetSystemLabels();
          default:
            throw new RuntimeException("Invalid map field number: " + number);
        }
      }

      @SuppressWarnings({"rawtypes"})
      protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
          int number) {
        switch (number) {
          case 3:
            return internalGetMutableSystemLabels();
          default:
            throw new RuntimeException("Invalid map field number: " + number);
        }
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1beta1.ModelGardenServiceProto
            .internal_static_google_cloud_aiplatform_v1beta1_DeployRequest_DeployConfig_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1beta1.DeployRequest.DeployConfig.class,
                com.google.cloud.aiplatform.v1beta1.DeployRequest.DeployConfig.Builder.class);
      }

      // Construct using com.google.cloud.aiplatform.v1beta1.DeployRequest.DeployConfig.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getDedicatedResourcesFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        dedicatedResources_ = null;
        if (dedicatedResourcesBuilder_ != null) {
          dedicatedResourcesBuilder_.dispose();
          dedicatedResourcesBuilder_ = null;
        }
        fastTryoutEnabled_ = false;
        internalGetMutableSystemLabels().clear();
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.aiplatform.v1beta1.ModelGardenServiceProto
            .internal_static_google_cloud_aiplatform_v1beta1_DeployRequest_DeployConfig_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.DeployRequest.DeployConfig
          getDefaultInstanceForType() {
        return com.google.cloud.aiplatform.v1beta1.DeployRequest.DeployConfig.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.DeployRequest.DeployConfig build() {
        com.google.cloud.aiplatform.v1beta1.DeployRequest.DeployConfig result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.DeployRequest.DeployConfig buildPartial() {
        com.google.cloud.aiplatform.v1beta1.DeployRequest.DeployConfig result =
            new com.google.cloud.aiplatform.v1beta1.DeployRequest.DeployConfig(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.aiplatform.v1beta1.DeployRequest.DeployConfig result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.dedicatedResources_ =
              dedicatedResourcesBuilder_ == null
                  ? dedicatedResources_
                  : dedicatedResourcesBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.fastTryoutEnabled_ = fastTryoutEnabled_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.systemLabels_ = internalGetSystemLabels();
          result.systemLabels_.makeImmutable();
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.aiplatform.v1beta1.DeployRequest.DeployConfig) {
          return mergeFrom((com.google.cloud.aiplatform.v1beta1.DeployRequest.DeployConfig) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.aiplatform.v1beta1.DeployRequest.DeployConfig other) {
        if (other
            == com.google.cloud.aiplatform.v1beta1.DeployRequest.DeployConfig.getDefaultInstance())
          return this;
        if (other.hasDedicatedResources()) {
          mergeDedicatedResources(other.getDedicatedResources());
        }
        if (other.getFastTryoutEnabled() != false) {
          setFastTryoutEnabled(other.getFastTryoutEnabled());
        }
        internalGetMutableSystemLabels().mergeFrom(other.internalGetSystemLabels());
        bitField0_ |= 0x00000004;
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(
                      getDedicatedResourcesFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 16:
                {
                  fastTryoutEnabled_ = input.readBool();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 16
              case 26:
                {
                  com.google.protobuf.MapEntry<java.lang.String, java.lang.String> systemLabels__ =
                      input.readMessage(
                          SystemLabelsDefaultEntryHolder.defaultEntry.getParserForType(),
                          extensionRegistry);
                  internalGetMutableSystemLabels()
                      .getMutableMap()
                      .put(systemLabels__.getKey(), systemLabels__.getValue());
                  bitField0_ |= 0x00000004;
                  break;
                } // case 26
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.cloud.aiplatform.v1beta1.DedicatedResources dedicatedResources_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1beta1.DedicatedResources,
              com.google.cloud.aiplatform.v1beta1.DedicatedResources.Builder,
              com.google.cloud.aiplatform.v1beta1.DedicatedResourcesOrBuilder>
          dedicatedResourcesBuilder_;

      /**
       *
       *
       * <pre>
       * Optional. The dedicated resources to use for the endpoint. If not set,
       * the default resources will be used.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.DedicatedResources dedicated_resources = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return Whether the dedicatedResources field is set.
       */
      public boolean hasDedicatedResources() {
        return ((bitField0_ & 0x00000001) != 0);
      }

      /**
       *
       *
       * <pre>
       * Optional. The dedicated resources to use for the endpoint. If not set,
       * the default resources will be used.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.DedicatedResources dedicated_resources = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The dedicatedResources.
       */
      public com.google.cloud.aiplatform.v1beta1.DedicatedResources getDedicatedResources() {
        if (dedicatedResourcesBuilder_ == null) {
          return dedicatedResources_ == null
              ? com.google.cloud.aiplatform.v1beta1.DedicatedResources.getDefaultInstance()
              : dedicatedResources_;
        } else {
          return dedicatedResourcesBuilder_.getMessage();
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. The dedicated resources to use for the endpoint. If not set,
       * the default resources will be used.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.DedicatedResources dedicated_resources = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setDedicatedResources(
          com.google.cloud.aiplatform.v1beta1.DedicatedResources value) {
        if (dedicatedResourcesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          dedicatedResources_ = value;
        } else {
          dedicatedResourcesBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. The dedicated resources to use for the endpoint. If not set,
       * the default resources will be used.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.DedicatedResources dedicated_resources = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setDedicatedResources(
          com.google.cloud.aiplatform.v1beta1.DedicatedResources.Builder builderForValue) {
        if (dedicatedResourcesBuilder_ == null) {
          dedicatedResources_ = builderForValue.build();
        } else {
          dedicatedResourcesBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. The dedicated resources to use for the endpoint. If not set,
       * the default resources will be used.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.DedicatedResources dedicated_resources = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder mergeDedicatedResources(
          com.google.cloud.aiplatform.v1beta1.DedicatedResources value) {
        if (dedicatedResourcesBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)
              && dedicatedResources_ != null
              && dedicatedResources_
                  != com.google.cloud.aiplatform.v1beta1.DedicatedResources.getDefaultInstance()) {
            getDedicatedResourcesBuilder().mergeFrom(value);
          } else {
            dedicatedResources_ = value;
          }
        } else {
          dedicatedResourcesBuilder_.mergeFrom(value);
        }
        if (dedicatedResources_ != null) {
          bitField0_ |= 0x00000001;
          onChanged();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. The dedicated resources to use for the endpoint. If not set,
       * the default resources will be used.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.DedicatedResources dedicated_resources = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder clearDedicatedResources() {
        bitField0_ = (bitField0_ & ~0x00000001);
        dedicatedResources_ = null;
        if (dedicatedResourcesBuilder_ != null) {
          dedicatedResourcesBuilder_.dispose();
          dedicatedResourcesBuilder_ = null;
        }
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. The dedicated resources to use for the endpoint. If not set,
       * the default resources will be used.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.DedicatedResources dedicated_resources = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.cloud.aiplatform.v1beta1.DedicatedResources.Builder
          getDedicatedResourcesBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getDedicatedResourcesFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * Optional. The dedicated resources to use for the endpoint. If not set,
       * the default resources will be used.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.DedicatedResources dedicated_resources = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.cloud.aiplatform.v1beta1.DedicatedResourcesOrBuilder
          getDedicatedResourcesOrBuilder() {
        if (dedicatedResourcesBuilder_ != null) {
          return dedicatedResourcesBuilder_.getMessageOrBuilder();
        } else {
          return dedicatedResources_ == null
              ? com.google.cloud.aiplatform.v1beta1.DedicatedResources.getDefaultInstance()
              : dedicatedResources_;
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. The dedicated resources to use for the endpoint. If not set,
       * the default resources will be used.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.DedicatedResources dedicated_resources = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1beta1.DedicatedResources,
              com.google.cloud.aiplatform.v1beta1.DedicatedResources.Builder,
              com.google.cloud.aiplatform.v1beta1.DedicatedResourcesOrBuilder>
          getDedicatedResourcesFieldBuilder() {
        if (dedicatedResourcesBuilder_ == null) {
          dedicatedResourcesBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.aiplatform.v1beta1.DedicatedResources,
                  com.google.cloud.aiplatform.v1beta1.DedicatedResources.Builder,
                  com.google.cloud.aiplatform.v1beta1.DedicatedResourcesOrBuilder>(
                  getDedicatedResources(), getParentForChildren(), isClean());
          dedicatedResources_ = null;
        }
        return dedicatedResourcesBuilder_;
      }

      private boolean fastTryoutEnabled_;

      /**
       *
       *
       * <pre>
       * Optional. If true, enable the QMT fast tryout feature for this model if
       * possible.
       * </pre>
       *
       * <code>bool fast_tryout_enabled = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The fastTryoutEnabled.
       */
      @java.lang.Override
      public boolean getFastTryoutEnabled() {
        return fastTryoutEnabled_;
      }

      /**
       *
       *
       * <pre>
       * Optional. If true, enable the QMT fast tryout feature for this model if
       * possible.
       * </pre>
       *
       * <code>bool fast_tryout_enabled = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The fastTryoutEnabled to set.
       * @return This builder for chaining.
       */
      public Builder setFastTryoutEnabled(boolean value) {

        fastTryoutEnabled_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. If true, enable the QMT fast tryout feature for this model if
       * possible.
       * </pre>
       *
       * <code>bool fast_tryout_enabled = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearFastTryoutEnabled() {
        bitField0_ = (bitField0_ & ~0x00000002);
        fastTryoutEnabled_ = false;
        onChanged();
        return this;
      }

      private com.google.protobuf.MapField<java.lang.String, java.lang.String> systemLabels_;

      private com.google.protobuf.MapField<java.lang.String, java.lang.String>
          internalGetSystemLabels() {
        if (systemLabels_ == null) {
          return com.google.protobuf.MapField.emptyMapField(
              SystemLabelsDefaultEntryHolder.defaultEntry);
        }
        return systemLabels_;
      }

      private com.google.protobuf.MapField<java.lang.String, java.lang.String>
          internalGetMutableSystemLabels() {
        if (systemLabels_ == null) {
          systemLabels_ =
              com.google.protobuf.MapField.newMapField(SystemLabelsDefaultEntryHolder.defaultEntry);
        }
        if (!systemLabels_.isMutable()) {
          systemLabels_ = systemLabels_.copy();
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return systemLabels_;
      }

      public int getSystemLabelsCount() {
        return internalGetSystemLabels().getMap().size();
      }

      /**
       *
       *
       * <pre>
       * Optional. System labels for Model Garden deployments.
       * These labels are managed by Google and for tracking purposes only.
       * </pre>
       *
       * <code>
       * map&lt;string, string&gt; system_labels = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      @java.lang.Override
      public boolean containsSystemLabels(java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        return internalGetSystemLabels().getMap().containsKey(key);
      }

      /** Use {@link #getSystemLabelsMap()} instead. */
      @java.lang.Override
      @java.lang.Deprecated
      public java.util.Map<java.lang.String, java.lang.String> getSystemLabels() {
        return getSystemLabelsMap();
      }

      /**
       *
       *
       * <pre>
       * Optional. System labels for Model Garden deployments.
       * These labels are managed by Google and for tracking purposes only.
       * </pre>
       *
       * <code>
       * map&lt;string, string&gt; system_labels = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      @java.lang.Override
      public java.util.Map<java.lang.String, java.lang.String> getSystemLabelsMap() {
        return internalGetSystemLabels().getMap();
      }

      /**
       *
       *
       * <pre>
       * Optional. System labels for Model Garden deployments.
       * These labels are managed by Google and for tracking purposes only.
       * </pre>
       *
       * <code>
       * map&lt;string, string&gt; system_labels = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      @java.lang.Override
      public /* nullable */ java.lang.String getSystemLabelsOrDefault(
          java.lang.String key,
          /* nullable */
          java.lang.String defaultValue) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        java.util.Map<java.lang.String, java.lang.String> map = internalGetSystemLabels().getMap();
        return map.containsKey(key) ? map.get(key) : defaultValue;
      }

      /**
       *
       *
       * <pre>
       * Optional. System labels for Model Garden deployments.
       * These labels are managed by Google and for tracking purposes only.
       * </pre>
       *
       * <code>
       * map&lt;string, string&gt; system_labels = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      @java.lang.Override
      public java.lang.String getSystemLabelsOrThrow(java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        java.util.Map<java.lang.String, java.lang.String> map = internalGetSystemLabels().getMap();
        if (!map.containsKey(key)) {
          throw new java.lang.IllegalArgumentException();
        }
        return map.get(key);
      }

      public Builder clearSystemLabels() {
        bitField0_ = (bitField0_ & ~0x00000004);
        internalGetMutableSystemLabels().getMutableMap().clear();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. System labels for Model Garden deployments.
       * These labels are managed by Google and for tracking purposes only.
       * </pre>
       *
       * <code>
       * map&lt;string, string&gt; system_labels = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder removeSystemLabels(java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        internalGetMutableSystemLabels().getMutableMap().remove(key);
        return this;
      }

      /** Use alternate mutation accessors instead. */
      @java.lang.Deprecated
      public java.util.Map<java.lang.String, java.lang.String> getMutableSystemLabels() {
        bitField0_ |= 0x00000004;
        return internalGetMutableSystemLabels().getMutableMap();
      }

      /**
       *
       *
       * <pre>
       * Optional. System labels for Model Garden deployments.
       * These labels are managed by Google and for tracking purposes only.
       * </pre>
       *
       * <code>
       * map&lt;string, string&gt; system_labels = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder putSystemLabels(java.lang.String key, java.lang.String value) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        if (value == null) {
          throw new NullPointerException("map value");
        }
        internalGetMutableSystemLabels().getMutableMap().put(key, value);
        bitField0_ |= 0x00000004;
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. System labels for Model Garden deployments.
       * These labels are managed by Google and for tracking purposes only.
       * </pre>
       *
       * <code>
       * map&lt;string, string&gt; system_labels = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder putAllSystemLabels(java.util.Map<java.lang.String, java.lang.String> values) {
        internalGetMutableSystemLabels().getMutableMap().putAll(values);
        bitField0_ |= 0x00000004;
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.DeployRequest.DeployConfig)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.DeployRequest.DeployConfig)
    private static final com.google.cloud.aiplatform.v1beta1.DeployRequest.DeployConfig
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.DeployRequest.DeployConfig();
    }

    public static com.google.cloud.aiplatform.v1beta1.DeployRequest.DeployConfig
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<DeployConfig> PARSER =
        new com.google.protobuf.AbstractParser<DeployConfig>() {
          @java.lang.Override
          public DeployConfig parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<DeployConfig> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<DeployConfig> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.DeployRequest.DeployConfig
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  private int artifactsCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object artifacts_;

  public enum ArtifactsCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    PUBLISHER_MODEL_NAME(1),
    HUGGING_FACE_MODEL_ID(2),
    ARTIFACTS_NOT_SET(0);
    private final int value;

    private ArtifactsCase(int value) {
      this.value = value;
    }

    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ArtifactsCase valueOf(int value) {
      return forNumber(value);
    }

    public static ArtifactsCase forNumber(int value) {
      switch (value) {
        case 1:
          return PUBLISHER_MODEL_NAME;
        case 2:
          return HUGGING_FACE_MODEL_ID;
        case 0:
          return ARTIFACTS_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public ArtifactsCase getArtifactsCase() {
    return ArtifactsCase.forNumber(artifactsCase_);
  }

  public static final int PUBLISHER_MODEL_NAME_FIELD_NUMBER = 1;

  /**
   *
   *
   * <pre>
   * The Model Garden model to deploy.
   * Format:
   * `publishers/{publisher}/models/{publisher_model}&#64;{version_id}`, or
   * `publishers/hf-{hugging-face-author}/models/{hugging-face-model-name}&#64;001`.
   * </pre>
   *
   * <code>string publisher_model_name = 1 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return Whether the publisherModelName field is set.
   */
  public boolean hasPublisherModelName() {
    return artifactsCase_ == 1;
  }

  /**
   *
   *
   * <pre>
   * The Model Garden model to deploy.
   * Format:
   * `publishers/{publisher}/models/{publisher_model}&#64;{version_id}`, or
   * `publishers/hf-{hugging-face-author}/models/{hugging-face-model-name}&#64;001`.
   * </pre>
   *
   * <code>string publisher_model_name = 1 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The publisherModelName.
   */
  public java.lang.String getPublisherModelName() {
    java.lang.Object ref = "";
    if (artifactsCase_ == 1) {
      ref = artifacts_;
    }
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (artifactsCase_ == 1) {
        artifacts_ = s;
      }
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * The Model Garden model to deploy.
   * Format:
   * `publishers/{publisher}/models/{publisher_model}&#64;{version_id}`, or
   * `publishers/hf-{hugging-face-author}/models/{hugging-face-model-name}&#64;001`.
   * </pre>
   *
   * <code>string publisher_model_name = 1 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The bytes for publisherModelName.
   */
  public com.google.protobuf.ByteString getPublisherModelNameBytes() {
    java.lang.Object ref = "";
    if (artifactsCase_ == 1) {
      ref = artifacts_;
    }
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      if (artifactsCase_ == 1) {
        artifacts_ = b;
      }
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int HUGGING_FACE_MODEL_ID_FIELD_NUMBER = 2;

  /**
   *
   *
   * <pre>
   * The Hugging Face model to deploy.
   * Format: Hugging Face model ID like `google/gemma-2-2b-it`.
   * </pre>
   *
   * <code>string hugging_face_model_id = 2;</code>
   *
   * @return Whether the huggingFaceModelId field is set.
   */
  public boolean hasHuggingFaceModelId() {
    return artifactsCase_ == 2;
  }

  /**
   *
   *
   * <pre>
   * The Hugging Face model to deploy.
   * Format: Hugging Face model ID like `google/gemma-2-2b-it`.
   * </pre>
   *
   * <code>string hugging_face_model_id = 2;</code>
   *
   * @return The huggingFaceModelId.
   */
  public java.lang.String getHuggingFaceModelId() {
    java.lang.Object ref = "";
    if (artifactsCase_ == 2) {
      ref = artifacts_;
    }
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (artifactsCase_ == 2) {
        artifacts_ = s;
      }
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * The Hugging Face model to deploy.
   * Format: Hugging Face model ID like `google/gemma-2-2b-it`.
   * </pre>
   *
   * <code>string hugging_face_model_id = 2;</code>
   *
   * @return The bytes for huggingFaceModelId.
   */
  public com.google.protobuf.ByteString getHuggingFaceModelIdBytes() {
    java.lang.Object ref = "";
    if (artifactsCase_ == 2) {
      ref = artifacts_;
    }
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      if (artifactsCase_ == 2) {
        artifacts_ = b;
      }
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DESTINATION_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object destination_ = "";

  /**
   *
   *
   * <pre>
   * Required. The resource name of the Location to deploy the model in.
   * Format: `projects/{project}/locations/{location}`
   * </pre>
   *
   * <code>
   * string destination = 4 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The destination.
   */
  @java.lang.Override
  public java.lang.String getDestination() {
    java.lang.Object ref = destination_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      destination_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Required. The resource name of the Location to deploy the model in.
   * Format: `projects/{project}/locations/{location}`
   * </pre>
   *
   * <code>
   * string destination = 4 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for destination.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDestinationBytes() {
    java.lang.Object ref = destination_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      destination_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int MODEL_CONFIG_FIELD_NUMBER = 5;
  private com.google.cloud.aiplatform.v1beta1.DeployRequest.ModelConfig modelConfig_;

  /**
   *
   *
   * <pre>
   * Optional. The model config to use for the deployment.
   * If not specified, the default model config will be used.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.DeployRequest.ModelConfig model_config = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the modelConfig field is set.
   */
  @java.lang.Override
  public boolean hasModelConfig() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * Optional. The model config to use for the deployment.
   * If not specified, the default model config will be used.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.DeployRequest.ModelConfig model_config = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The modelConfig.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.DeployRequest.ModelConfig getModelConfig() {
    return modelConfig_ == null
        ? com.google.cloud.aiplatform.v1beta1.DeployRequest.ModelConfig.getDefaultInstance()
        : modelConfig_;
  }

  /**
   *
   *
   * <pre>
   * Optional. The model config to use for the deployment.
   * If not specified, the default model config will be used.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.DeployRequest.ModelConfig model_config = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.DeployRequest.ModelConfigOrBuilder
      getModelConfigOrBuilder() {
    return modelConfig_ == null
        ? com.google.cloud.aiplatform.v1beta1.DeployRequest.ModelConfig.getDefaultInstance()
        : modelConfig_;
  }

  public static final int ENDPOINT_CONFIG_FIELD_NUMBER = 6;
  private com.google.cloud.aiplatform.v1beta1.DeployRequest.EndpointConfig endpointConfig_;

  /**
   *
   *
   * <pre>
   * Optional. The endpoint config to use for the deployment.
   * If not specified, the default endpoint config will be used.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.DeployRequest.EndpointConfig endpoint_config = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the endpointConfig field is set.
   */
  @java.lang.Override
  public boolean hasEndpointConfig() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * Optional. The endpoint config to use for the deployment.
   * If not specified, the default endpoint config will be used.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.DeployRequest.EndpointConfig endpoint_config = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The endpointConfig.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.DeployRequest.EndpointConfig getEndpointConfig() {
    return endpointConfig_ == null
        ? com.google.cloud.aiplatform.v1beta1.DeployRequest.EndpointConfig.getDefaultInstance()
        : endpointConfig_;
  }

  /**
   *
   *
   * <pre>
   * Optional. The endpoint config to use for the deployment.
   * If not specified, the default endpoint config will be used.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.DeployRequest.EndpointConfig endpoint_config = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.DeployRequest.EndpointConfigOrBuilder
      getEndpointConfigOrBuilder() {
    return endpointConfig_ == null
        ? com.google.cloud.aiplatform.v1beta1.DeployRequest.EndpointConfig.getDefaultInstance()
        : endpointConfig_;
  }

  public static final int DEPLOY_CONFIG_FIELD_NUMBER = 7;
  private com.google.cloud.aiplatform.v1beta1.DeployRequest.DeployConfig deployConfig_;

  /**
   *
   *
   * <pre>
   * Optional. The deploy config to use for the deployment.
   * If not specified, the default deploy config will be used.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.DeployRequest.DeployConfig deploy_config = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the deployConfig field is set.
   */
  @java.lang.Override
  public boolean hasDeployConfig() {
    return ((bitField0_ & 0x00000004) != 0);
  }

  /**
   *
   *
   * <pre>
   * Optional. The deploy config to use for the deployment.
   * If not specified, the default deploy config will be used.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.DeployRequest.DeployConfig deploy_config = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The deployConfig.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.DeployRequest.DeployConfig getDeployConfig() {
    return deployConfig_ == null
        ? com.google.cloud.aiplatform.v1beta1.DeployRequest.DeployConfig.getDefaultInstance()
        : deployConfig_;
  }

  /**
   *
   *
   * <pre>
   * Optional. The deploy config to use for the deployment.
   * If not specified, the default deploy config will be used.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.DeployRequest.DeployConfig deploy_config = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.DeployRequest.DeployConfigOrBuilder
      getDeployConfigOrBuilder() {
    return deployConfig_ == null
        ? com.google.cloud.aiplatform.v1beta1.DeployRequest.DeployConfig.getDefaultInstance()
        : deployConfig_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (artifactsCase_ == 1) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, artifacts_);
    }
    if (artifactsCase_ == 2) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, artifacts_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(destination_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, destination_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(5, getModelConfig());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(6, getEndpointConfig());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(7, getDeployConfig());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (artifactsCase_ == 1) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, artifacts_);
    }
    if (artifactsCase_ == 2) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, artifacts_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(destination_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, destination_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getModelConfig());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getEndpointConfig());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getDeployConfig());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.DeployRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1beta1.DeployRequest other =
        (com.google.cloud.aiplatform.v1beta1.DeployRequest) obj;

    if (!getDestination().equals(other.getDestination())) return false;
    if (hasModelConfig() != other.hasModelConfig()) return false;
    if (hasModelConfig()) {
      if (!getModelConfig().equals(other.getModelConfig())) return false;
    }
    if (hasEndpointConfig() != other.hasEndpointConfig()) return false;
    if (hasEndpointConfig()) {
      if (!getEndpointConfig().equals(other.getEndpointConfig())) return false;
    }
    if (hasDeployConfig() != other.hasDeployConfig()) return false;
    if (hasDeployConfig()) {
      if (!getDeployConfig().equals(other.getDeployConfig())) return false;
    }
    if (!getArtifactsCase().equals(other.getArtifactsCase())) return false;
    switch (artifactsCase_) {
      case 1:
        if (!getPublisherModelName().equals(other.getPublisherModelName())) return false;
        break;
      case 2:
        if (!getHuggingFaceModelId().equals(other.getHuggingFaceModelId())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + DESTINATION_FIELD_NUMBER;
    hash = (53 * hash) + getDestination().hashCode();
    if (hasModelConfig()) {
      hash = (37 * hash) + MODEL_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getModelConfig().hashCode();
    }
    if (hasEndpointConfig()) {
      hash = (37 * hash) + ENDPOINT_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getEndpointConfig().hashCode();
    }
    if (hasDeployConfig()) {
      hash = (37 * hash) + DEPLOY_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getDeployConfig().hashCode();
    }
    switch (artifactsCase_) {
      case 1:
        hash = (37 * hash) + PUBLISHER_MODEL_NAME_FIELD_NUMBER;
        hash = (53 * hash) + getPublisherModelName().hashCode();
        break;
      case 2:
        hash = (37 * hash) + HUGGING_FACE_MODEL_ID_FIELD_NUMBER;
        hash = (53 * hash) + getHuggingFaceModelId().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1beta1.DeployRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.DeployRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.DeployRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.DeployRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.DeployRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.DeployRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.DeployRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.DeployRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.DeployRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.DeployRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.DeployRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.DeployRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.aiplatform.v1beta1.DeployRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Request message for
   * [ModelGardenService.Deploy][google.cloud.aiplatform.v1beta1.ModelGardenService.Deploy].
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.DeployRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.DeployRequest)
      com.google.cloud.aiplatform.v1beta1.DeployRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.ModelGardenServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_DeployRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.ModelGardenServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_DeployRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.DeployRequest.class,
              com.google.cloud.aiplatform.v1beta1.DeployRequest.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1beta1.DeployRequest.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getModelConfigFieldBuilder();
        getEndpointConfigFieldBuilder();
        getDeployConfigFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      destination_ = "";
      modelConfig_ = null;
      if (modelConfigBuilder_ != null) {
        modelConfigBuilder_.dispose();
        modelConfigBuilder_ = null;
      }
      endpointConfig_ = null;
      if (endpointConfigBuilder_ != null) {
        endpointConfigBuilder_.dispose();
        endpointConfigBuilder_ = null;
      }
      deployConfig_ = null;
      if (deployConfigBuilder_ != null) {
        deployConfigBuilder_.dispose();
        deployConfigBuilder_ = null;
      }
      artifactsCase_ = 0;
      artifacts_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1beta1.ModelGardenServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_DeployRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.DeployRequest getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1beta1.DeployRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.DeployRequest build() {
      com.google.cloud.aiplatform.v1beta1.DeployRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.DeployRequest buildPartial() {
      com.google.cloud.aiplatform.v1beta1.DeployRequest result =
          new com.google.cloud.aiplatform.v1beta1.DeployRequest(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.aiplatform.v1beta1.DeployRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.destination_ = destination_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.modelConfig_ =
            modelConfigBuilder_ == null ? modelConfig_ : modelConfigBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.endpointConfig_ =
            endpointConfigBuilder_ == null ? endpointConfig_ : endpointConfigBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.deployConfig_ =
            deployConfigBuilder_ == null ? deployConfig_ : deployConfigBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      result.bitField0_ |= to_bitField0_;
    }

    private void buildPartialOneofs(com.google.cloud.aiplatform.v1beta1.DeployRequest result) {
      result.artifactsCase_ = artifactsCase_;
      result.artifacts_ = this.artifacts_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1beta1.DeployRequest) {
        return mergeFrom((com.google.cloud.aiplatform.v1beta1.DeployRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1beta1.DeployRequest other) {
      if (other == com.google.cloud.aiplatform.v1beta1.DeployRequest.getDefaultInstance())
        return this;
      if (!other.getDestination().isEmpty()) {
        destination_ = other.destination_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.hasModelConfig()) {
        mergeModelConfig(other.getModelConfig());
      }
      if (other.hasEndpointConfig()) {
        mergeEndpointConfig(other.getEndpointConfig());
      }
      if (other.hasDeployConfig()) {
        mergeDeployConfig(other.getDeployConfig());
      }
      switch (other.getArtifactsCase()) {
        case PUBLISHER_MODEL_NAME:
          {
            artifactsCase_ = 1;
            artifacts_ = other.artifacts_;
            onChanged();
            break;
          }
        case HUGGING_FACE_MODEL_ID:
          {
            artifactsCase_ = 2;
            artifacts_ = other.artifacts_;
            onChanged();
            break;
          }
        case ARTIFACTS_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                java.lang.String s = input.readStringRequireUtf8();
                artifactsCase_ = 1;
                artifacts_ = s;
                break;
              } // case 10
            case 18:
              {
                java.lang.String s = input.readStringRequireUtf8();
                artifactsCase_ = 2;
                artifacts_ = s;
                break;
              } // case 18
            case 34:
              {
                destination_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(getModelConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 42
            case 50:
              {
                input.readMessage(getEndpointConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 50
            case 58:
              {
                input.readMessage(getDeployConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000020;
                break;
              } // case 58
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int artifactsCase_ = 0;
    private java.lang.Object artifacts_;

    public ArtifactsCase getArtifactsCase() {
      return ArtifactsCase.forNumber(artifactsCase_);
    }

    public Builder clearArtifacts() {
      artifactsCase_ = 0;
      artifacts_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    /**
     *
     *
     * <pre>
     * The Model Garden model to deploy.
     * Format:
     * `publishers/{publisher}/models/{publisher_model}&#64;{version_id}`, or
     * `publishers/hf-{hugging-face-author}/models/{hugging-face-model-name}&#64;001`.
     * </pre>
     *
     * <code>string publisher_model_name = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return Whether the publisherModelName field is set.
     */
    @java.lang.Override
    public boolean hasPublisherModelName() {
      return artifactsCase_ == 1;
    }

    /**
     *
     *
     * <pre>
     * The Model Garden model to deploy.
     * Format:
     * `publishers/{publisher}/models/{publisher_model}&#64;{version_id}`, or
     * `publishers/hf-{hugging-face-author}/models/{hugging-face-model-name}&#64;001`.
     * </pre>
     *
     * <code>string publisher_model_name = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The publisherModelName.
     */
    @java.lang.Override
    public java.lang.String getPublisherModelName() {
      java.lang.Object ref = "";
      if (artifactsCase_ == 1) {
        ref = artifacts_;
      }
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (artifactsCase_ == 1) {
          artifacts_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The Model Garden model to deploy.
     * Format:
     * `publishers/{publisher}/models/{publisher_model}&#64;{version_id}`, or
     * `publishers/hf-{hugging-face-author}/models/{hugging-face-model-name}&#64;001`.
     * </pre>
     *
     * <code>string publisher_model_name = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The bytes for publisherModelName.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getPublisherModelNameBytes() {
      java.lang.Object ref = "";
      if (artifactsCase_ == 1) {
        ref = artifacts_;
      }
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (artifactsCase_ == 1) {
          artifacts_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The Model Garden model to deploy.
     * Format:
     * `publishers/{publisher}/models/{publisher_model}&#64;{version_id}`, or
     * `publishers/hf-{hugging-face-author}/models/{hugging-face-model-name}&#64;001`.
     * </pre>
     *
     * <code>string publisher_model_name = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The publisherModelName to set.
     * @return This builder for chaining.
     */
    public Builder setPublisherModelName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      artifactsCase_ = 1;
      artifacts_ = value;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The Model Garden model to deploy.
     * Format:
     * `publishers/{publisher}/models/{publisher_model}&#64;{version_id}`, or
     * `publishers/hf-{hugging-face-author}/models/{hugging-face-model-name}&#64;001`.
     * </pre>
     *
     * <code>string publisher_model_name = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPublisherModelName() {
      if (artifactsCase_ == 1) {
        artifactsCase_ = 0;
        artifacts_ = null;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The Model Garden model to deploy.
     * Format:
     * `publishers/{publisher}/models/{publisher_model}&#64;{version_id}`, or
     * `publishers/hf-{hugging-face-author}/models/{hugging-face-model-name}&#64;001`.
     * </pre>
     *
     * <code>string publisher_model_name = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The bytes for publisherModelName to set.
     * @return This builder for chaining.
     */
    public Builder setPublisherModelNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      artifactsCase_ = 1;
      artifacts_ = value;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The Hugging Face model to deploy.
     * Format: Hugging Face model ID like `google/gemma-2-2b-it`.
     * </pre>
     *
     * <code>string hugging_face_model_id = 2;</code>
     *
     * @return Whether the huggingFaceModelId field is set.
     */
    @java.lang.Override
    public boolean hasHuggingFaceModelId() {
      return artifactsCase_ == 2;
    }

    /**
     *
     *
     * <pre>
     * The Hugging Face model to deploy.
     * Format: Hugging Face model ID like `google/gemma-2-2b-it`.
     * </pre>
     *
     * <code>string hugging_face_model_id = 2;</code>
     *
     * @return The huggingFaceModelId.
     */
    @java.lang.Override
    public java.lang.String getHuggingFaceModelId() {
      java.lang.Object ref = "";
      if (artifactsCase_ == 2) {
        ref = artifacts_;
      }
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (artifactsCase_ == 2) {
          artifacts_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The Hugging Face model to deploy.
     * Format: Hugging Face model ID like `google/gemma-2-2b-it`.
     * </pre>
     *
     * <code>string hugging_face_model_id = 2;</code>
     *
     * @return The bytes for huggingFaceModelId.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getHuggingFaceModelIdBytes() {
      java.lang.Object ref = "";
      if (artifactsCase_ == 2) {
        ref = artifacts_;
      }
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (artifactsCase_ == 2) {
          artifacts_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The Hugging Face model to deploy.
     * Format: Hugging Face model ID like `google/gemma-2-2b-it`.
     * </pre>
     *
     * <code>string hugging_face_model_id = 2;</code>
     *
     * @param value The huggingFaceModelId to set.
     * @return This builder for chaining.
     */
    public Builder setHuggingFaceModelId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      artifactsCase_ = 2;
      artifacts_ = value;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The Hugging Face model to deploy.
     * Format: Hugging Face model ID like `google/gemma-2-2b-it`.
     * </pre>
     *
     * <code>string hugging_face_model_id = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearHuggingFaceModelId() {
      if (artifactsCase_ == 2) {
        artifactsCase_ = 0;
        artifacts_ = null;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The Hugging Face model to deploy.
     * Format: Hugging Face model ID like `google/gemma-2-2b-it`.
     * </pre>
     *
     * <code>string hugging_face_model_id = 2;</code>
     *
     * @param value The bytes for huggingFaceModelId to set.
     * @return This builder for chaining.
     */
    public Builder setHuggingFaceModelIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      artifactsCase_ = 2;
      artifacts_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object destination_ = "";

    /**
     *
     *
     * <pre>
     * Required. The resource name of the Location to deploy the model in.
     * Format: `projects/{project}/locations/{location}`
     * </pre>
     *
     * <code>
     * string destination = 4 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The destination.
     */
    public java.lang.String getDestination() {
      java.lang.Object ref = destination_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        destination_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The resource name of the Location to deploy the model in.
     * Format: `projects/{project}/locations/{location}`
     * </pre>
     *
     * <code>
     * string destination = 4 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for destination.
     */
    public com.google.protobuf.ByteString getDestinationBytes() {
      java.lang.Object ref = destination_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        destination_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The resource name of the Location to deploy the model in.
     * Format: `projects/{project}/locations/{location}`
     * </pre>
     *
     * <code>
     * string destination = 4 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The destination to set.
     * @return This builder for chaining.
     */
    public Builder setDestination(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      destination_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The resource name of the Location to deploy the model in.
     * Format: `projects/{project}/locations/{location}`
     * </pre>
     *
     * <code>
     * string destination = 4 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDestination() {
      destination_ = getDefaultInstance().getDestination();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The resource name of the Location to deploy the model in.
     * Format: `projects/{project}/locations/{location}`
     * </pre>
     *
     * <code>
     * string destination = 4 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for destination to set.
     * @return This builder for chaining.
     */
    public Builder setDestinationBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      destination_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private com.google.cloud.aiplatform.v1beta1.DeployRequest.ModelConfig modelConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.DeployRequest.ModelConfig,
            com.google.cloud.aiplatform.v1beta1.DeployRequest.ModelConfig.Builder,
            com.google.cloud.aiplatform.v1beta1.DeployRequest.ModelConfigOrBuilder>
        modelConfigBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. The model config to use for the deployment.
     * If not specified, the default model config will be used.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.DeployRequest.ModelConfig model_config = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the modelConfig field is set.
     */
    public boolean hasModelConfig() {
      return ((bitField0_ & 0x00000008) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. The model config to use for the deployment.
     * If not specified, the default model config will be used.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.DeployRequest.ModelConfig model_config = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The modelConfig.
     */
    public com.google.cloud.aiplatform.v1beta1.DeployRequest.ModelConfig getModelConfig() {
      if (modelConfigBuilder_ == null) {
        return modelConfig_ == null
            ? com.google.cloud.aiplatform.v1beta1.DeployRequest.ModelConfig.getDefaultInstance()
            : modelConfig_;
      } else {
        return modelConfigBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The model config to use for the deployment.
     * If not specified, the default model config will be used.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.DeployRequest.ModelConfig model_config = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setModelConfig(
        com.google.cloud.aiplatform.v1beta1.DeployRequest.ModelConfig value) {
      if (modelConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        modelConfig_ = value;
      } else {
        modelConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The model config to use for the deployment.
     * If not specified, the default model config will be used.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.DeployRequest.ModelConfig model_config = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setModelConfig(
        com.google.cloud.aiplatform.v1beta1.DeployRequest.ModelConfig.Builder builderForValue) {
      if (modelConfigBuilder_ == null) {
        modelConfig_ = builderForValue.build();
      } else {
        modelConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The model config to use for the deployment.
     * If not specified, the default model config will be used.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.DeployRequest.ModelConfig model_config = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeModelConfig(
        com.google.cloud.aiplatform.v1beta1.DeployRequest.ModelConfig value) {
      if (modelConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && modelConfig_ != null
            && modelConfig_
                != com.google.cloud.aiplatform.v1beta1.DeployRequest.ModelConfig
                    .getDefaultInstance()) {
          getModelConfigBuilder().mergeFrom(value);
        } else {
          modelConfig_ = value;
        }
      } else {
        modelConfigBuilder_.mergeFrom(value);
      }
      if (modelConfig_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The model config to use for the deployment.
     * If not specified, the default model config will be used.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.DeployRequest.ModelConfig model_config = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearModelConfig() {
      bitField0_ = (bitField0_ & ~0x00000008);
      modelConfig_ = null;
      if (modelConfigBuilder_ != null) {
        modelConfigBuilder_.dispose();
        modelConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The model config to use for the deployment.
     * If not specified, the default model config will be used.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.DeployRequest.ModelConfig model_config = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.DeployRequest.ModelConfig.Builder
        getModelConfigBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getModelConfigFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Optional. The model config to use for the deployment.
     * If not specified, the default model config will be used.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.DeployRequest.ModelConfig model_config = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.DeployRequest.ModelConfigOrBuilder
        getModelConfigOrBuilder() {
      if (modelConfigBuilder_ != null) {
        return modelConfigBuilder_.getMessageOrBuilder();
      } else {
        return modelConfig_ == null
            ? com.google.cloud.aiplatform.v1beta1.DeployRequest.ModelConfig.getDefaultInstance()
            : modelConfig_;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The model config to use for the deployment.
     * If not specified, the default model config will be used.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.DeployRequest.ModelConfig model_config = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.DeployRequest.ModelConfig,
            com.google.cloud.aiplatform.v1beta1.DeployRequest.ModelConfig.Builder,
            com.google.cloud.aiplatform.v1beta1.DeployRequest.ModelConfigOrBuilder>
        getModelConfigFieldBuilder() {
      if (modelConfigBuilder_ == null) {
        modelConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.DeployRequest.ModelConfig,
                com.google.cloud.aiplatform.v1beta1.DeployRequest.ModelConfig.Builder,
                com.google.cloud.aiplatform.v1beta1.DeployRequest.ModelConfigOrBuilder>(
                getModelConfig(), getParentForChildren(), isClean());
        modelConfig_ = null;
      }
      return modelConfigBuilder_;
    }

    private com.google.cloud.aiplatform.v1beta1.DeployRequest.EndpointConfig endpointConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.DeployRequest.EndpointConfig,
            com.google.cloud.aiplatform.v1beta1.DeployRequest.EndpointConfig.Builder,
            com.google.cloud.aiplatform.v1beta1.DeployRequest.EndpointConfigOrBuilder>
        endpointConfigBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. The endpoint config to use for the deployment.
     * If not specified, the default endpoint config will be used.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.DeployRequest.EndpointConfig endpoint_config = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the endpointConfig field is set.
     */
    public boolean hasEndpointConfig() {
      return ((bitField0_ & 0x00000010) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. The endpoint config to use for the deployment.
     * If not specified, the default endpoint config will be used.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.DeployRequest.EndpointConfig endpoint_config = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The endpointConfig.
     */
    public com.google.cloud.aiplatform.v1beta1.DeployRequest.EndpointConfig getEndpointConfig() {
      if (endpointConfigBuilder_ == null) {
        return endpointConfig_ == null
            ? com.google.cloud.aiplatform.v1beta1.DeployRequest.EndpointConfig.getDefaultInstance()
            : endpointConfig_;
      } else {
        return endpointConfigBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The endpoint config to use for the deployment.
     * If not specified, the default endpoint config will be used.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.DeployRequest.EndpointConfig endpoint_config = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setEndpointConfig(
        com.google.cloud.aiplatform.v1beta1.DeployRequest.EndpointConfig value) {
      if (endpointConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        endpointConfig_ = value;
      } else {
        endpointConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The endpoint config to use for the deployment.
     * If not specified, the default endpoint config will be used.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.DeployRequest.EndpointConfig endpoint_config = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setEndpointConfig(
        com.google.cloud.aiplatform.v1beta1.DeployRequest.EndpointConfig.Builder builderForValue) {
      if (endpointConfigBuilder_ == null) {
        endpointConfig_ = builderForValue.build();
      } else {
        endpointConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The endpoint config to use for the deployment.
     * If not specified, the default endpoint config will be used.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.DeployRequest.EndpointConfig endpoint_config = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeEndpointConfig(
        com.google.cloud.aiplatform.v1beta1.DeployRequest.EndpointConfig value) {
      if (endpointConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && endpointConfig_ != null
            && endpointConfig_
                != com.google.cloud.aiplatform.v1beta1.DeployRequest.EndpointConfig
                    .getDefaultInstance()) {
          getEndpointConfigBuilder().mergeFrom(value);
        } else {
          endpointConfig_ = value;
        }
      } else {
        endpointConfigBuilder_.mergeFrom(value);
      }
      if (endpointConfig_ != null) {
        bitField0_ |= 0x00000010;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The endpoint config to use for the deployment.
     * If not specified, the default endpoint config will be used.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.DeployRequest.EndpointConfig endpoint_config = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearEndpointConfig() {
      bitField0_ = (bitField0_ & ~0x00000010);
      endpointConfig_ = null;
      if (endpointConfigBuilder_ != null) {
        endpointConfigBuilder_.dispose();
        endpointConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The endpoint config to use for the deployment.
     * If not specified, the default endpoint config will be used.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.DeployRequest.EndpointConfig endpoint_config = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.DeployRequest.EndpointConfig.Builder
        getEndpointConfigBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getEndpointConfigFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Optional. The endpoint config to use for the deployment.
     * If not specified, the default endpoint config will be used.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.DeployRequest.EndpointConfig endpoint_config = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.DeployRequest.EndpointConfigOrBuilder
        getEndpointConfigOrBuilder() {
      if (endpointConfigBuilder_ != null) {
        return endpointConfigBuilder_.getMessageOrBuilder();
      } else {
        return endpointConfig_ == null
            ? com.google.cloud.aiplatform.v1beta1.DeployRequest.EndpointConfig.getDefaultInstance()
            : endpointConfig_;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The endpoint config to use for the deployment.
     * If not specified, the default endpoint config will be used.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.DeployRequest.EndpointConfig endpoint_config = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.DeployRequest.EndpointConfig,
            com.google.cloud.aiplatform.v1beta1.DeployRequest.EndpointConfig.Builder,
            com.google.cloud.aiplatform.v1beta1.DeployRequest.EndpointConfigOrBuilder>
        getEndpointConfigFieldBuilder() {
      if (endpointConfigBuilder_ == null) {
        endpointConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.DeployRequest.EndpointConfig,
                com.google.cloud.aiplatform.v1beta1.DeployRequest.EndpointConfig.Builder,
                com.google.cloud.aiplatform.v1beta1.DeployRequest.EndpointConfigOrBuilder>(
                getEndpointConfig(), getParentForChildren(), isClean());
        endpointConfig_ = null;
      }
      return endpointConfigBuilder_;
    }

    private com.google.cloud.aiplatform.v1beta1.DeployRequest.DeployConfig deployConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.DeployRequest.DeployConfig,
            com.google.cloud.aiplatform.v1beta1.DeployRequest.DeployConfig.Builder,
            com.google.cloud.aiplatform.v1beta1.DeployRequest.DeployConfigOrBuilder>
        deployConfigBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. The deploy config to use for the deployment.
     * If not specified, the default deploy config will be used.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.DeployRequest.DeployConfig deploy_config = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the deployConfig field is set.
     */
    public boolean hasDeployConfig() {
      return ((bitField0_ & 0x00000020) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. The deploy config to use for the deployment.
     * If not specified, the default deploy config will be used.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.DeployRequest.DeployConfig deploy_config = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The deployConfig.
     */
    public com.google.cloud.aiplatform.v1beta1.DeployRequest.DeployConfig getDeployConfig() {
      if (deployConfigBuilder_ == null) {
        return deployConfig_ == null
            ? com.google.cloud.aiplatform.v1beta1.DeployRequest.DeployConfig.getDefaultInstance()
            : deployConfig_;
      } else {
        return deployConfigBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The deploy config to use for the deployment.
     * If not specified, the default deploy config will be used.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.DeployRequest.DeployConfig deploy_config = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setDeployConfig(
        com.google.cloud.aiplatform.v1beta1.DeployRequest.DeployConfig value) {
      if (deployConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        deployConfig_ = value;
      } else {
        deployConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The deploy config to use for the deployment.
     * If not specified, the default deploy config will be used.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.DeployRequest.DeployConfig deploy_config = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setDeployConfig(
        com.google.cloud.aiplatform.v1beta1.DeployRequest.DeployConfig.Builder builderForValue) {
      if (deployConfigBuilder_ == null) {
        deployConfig_ = builderForValue.build();
      } else {
        deployConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The deploy config to use for the deployment.
     * If not specified, the default deploy config will be used.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.DeployRequest.DeployConfig deploy_config = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeDeployConfig(
        com.google.cloud.aiplatform.v1beta1.DeployRequest.DeployConfig value) {
      if (deployConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)
            && deployConfig_ != null
            && deployConfig_
                != com.google.cloud.aiplatform.v1beta1.DeployRequest.DeployConfig
                    .getDefaultInstance()) {
          getDeployConfigBuilder().mergeFrom(value);
        } else {
          deployConfig_ = value;
        }
      } else {
        deployConfigBuilder_.mergeFrom(value);
      }
      if (deployConfig_ != null) {
        bitField0_ |= 0x00000020;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The deploy config to use for the deployment.
     * If not specified, the default deploy config will be used.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.DeployRequest.DeployConfig deploy_config = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearDeployConfig() {
      bitField0_ = (bitField0_ & ~0x00000020);
      deployConfig_ = null;
      if (deployConfigBuilder_ != null) {
        deployConfigBuilder_.dispose();
        deployConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The deploy config to use for the deployment.
     * If not specified, the default deploy config will be used.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.DeployRequest.DeployConfig deploy_config = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.DeployRequest.DeployConfig.Builder
        getDeployConfigBuilder() {
      bitField0_ |= 0x00000020;
      onChanged();
      return getDeployConfigFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Optional. The deploy config to use for the deployment.
     * If not specified, the default deploy config will be used.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.DeployRequest.DeployConfig deploy_config = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.DeployRequest.DeployConfigOrBuilder
        getDeployConfigOrBuilder() {
      if (deployConfigBuilder_ != null) {
        return deployConfigBuilder_.getMessageOrBuilder();
      } else {
        return deployConfig_ == null
            ? com.google.cloud.aiplatform.v1beta1.DeployRequest.DeployConfig.getDefaultInstance()
            : deployConfig_;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The deploy config to use for the deployment.
     * If not specified, the default deploy config will be used.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.DeployRequest.DeployConfig deploy_config = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.DeployRequest.DeployConfig,
            com.google.cloud.aiplatform.v1beta1.DeployRequest.DeployConfig.Builder,
            com.google.cloud.aiplatform.v1beta1.DeployRequest.DeployConfigOrBuilder>
        getDeployConfigFieldBuilder() {
      if (deployConfigBuilder_ == null) {
        deployConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.DeployRequest.DeployConfig,
                com.google.cloud.aiplatform.v1beta1.DeployRequest.DeployConfig.Builder,
                com.google.cloud.aiplatform.v1beta1.DeployRequest.DeployConfigOrBuilder>(
                getDeployConfig(), getParentForChildren(), isClean());
        deployConfig_ = null;
      }
      return deployConfigBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.DeployRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.DeployRequest)
  private static final com.google.cloud.aiplatform.v1beta1.DeployRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.DeployRequest();
  }

  public static com.google.cloud.aiplatform.v1beta1.DeployRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<DeployRequest> PARSER =
      new com.google.protobuf.AbstractParser<DeployRequest>() {
        @java.lang.Override
        public DeployRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<DeployRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<DeployRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.DeployRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
