/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1beta1/tuning_job.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.aiplatform.v1beta1;

/**
 *
 *
 * <pre>
 * Tuning Spec for Distillation.
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1beta1.DistillationSpec}
 */
public final class DistillationSpec extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.DistillationSpec)
    DistillationSpecOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use DistillationSpec.newBuilder() to construct.
  private DistillationSpec(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private DistillationSpec() {
    trainingDatasetUri_ = "";
    validationDatasetUri_ = "";
    studentModel_ = "";
    pipelineRootDirectory_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new DistillationSpec();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1beta1.TuningJobProto
        .internal_static_google_cloud_aiplatform_v1beta1_DistillationSpec_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1beta1.TuningJobProto
        .internal_static_google_cloud_aiplatform_v1beta1_DistillationSpec_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1beta1.DistillationSpec.class,
            com.google.cloud.aiplatform.v1beta1.DistillationSpec.Builder.class);
  }

  private int bitField0_;
  private int teacherModelCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object teacherModel_;

  public enum TeacherModelCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    BASE_TEACHER_MODEL(5),
    TUNED_TEACHER_MODEL_SOURCE(6),
    TEACHERMODEL_NOT_SET(0);
    private final int value;

    private TeacherModelCase(int value) {
      this.value = value;
    }

    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static TeacherModelCase valueOf(int value) {
      return forNumber(value);
    }

    public static TeacherModelCase forNumber(int value) {
      switch (value) {
        case 5:
          return BASE_TEACHER_MODEL;
        case 6:
          return TUNED_TEACHER_MODEL_SOURCE;
        case 0:
          return TEACHERMODEL_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public TeacherModelCase getTeacherModelCase() {
    return TeacherModelCase.forNumber(teacherModelCase_);
  }

  public static final int BASE_TEACHER_MODEL_FIELD_NUMBER = 5;

  /**
   *
   *
   * <pre>
   * The base teacher model that is being distilled. See [Supported
   * models](https://cloud.google.com/vertex-ai/generative-ai/docs/model-reference/tuning#supported_models).
   * </pre>
   *
   * <code>string base_teacher_model = 5;</code>
   *
   * @return Whether the baseTeacherModel field is set.
   */
  public boolean hasBaseTeacherModel() {
    return teacherModelCase_ == 5;
  }

  /**
   *
   *
   * <pre>
   * The base teacher model that is being distilled. See [Supported
   * models](https://cloud.google.com/vertex-ai/generative-ai/docs/model-reference/tuning#supported_models).
   * </pre>
   *
   * <code>string base_teacher_model = 5;</code>
   *
   * @return The baseTeacherModel.
   */
  public java.lang.String getBaseTeacherModel() {
    java.lang.Object ref = "";
    if (teacherModelCase_ == 5) {
      ref = teacherModel_;
    }
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (teacherModelCase_ == 5) {
        teacherModel_ = s;
      }
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * The base teacher model that is being distilled. See [Supported
   * models](https://cloud.google.com/vertex-ai/generative-ai/docs/model-reference/tuning#supported_models).
   * </pre>
   *
   * <code>string base_teacher_model = 5;</code>
   *
   * @return The bytes for baseTeacherModel.
   */
  public com.google.protobuf.ByteString getBaseTeacherModelBytes() {
    java.lang.Object ref = "";
    if (teacherModelCase_ == 5) {
      ref = teacherModel_;
    }
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      if (teacherModelCase_ == 5) {
        teacherModel_ = b;
      }
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TUNED_TEACHER_MODEL_SOURCE_FIELD_NUMBER = 6;

  /**
   *
   *
   * <pre>
   * The resource name of the Tuned teacher model. Format:
   * `projects/{project}/locations/{location}/models/{model}`.
   * </pre>
   *
   * <code>string tuned_teacher_model_source = 6 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return Whether the tunedTeacherModelSource field is set.
   */
  public boolean hasTunedTeacherModelSource() {
    return teacherModelCase_ == 6;
  }

  /**
   *
   *
   * <pre>
   * The resource name of the Tuned teacher model. Format:
   * `projects/{project}/locations/{location}/models/{model}`.
   * </pre>
   *
   * <code>string tuned_teacher_model_source = 6 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The tunedTeacherModelSource.
   */
  public java.lang.String getTunedTeacherModelSource() {
    java.lang.Object ref = "";
    if (teacherModelCase_ == 6) {
      ref = teacherModel_;
    }
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (teacherModelCase_ == 6) {
        teacherModel_ = s;
      }
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * The resource name of the Tuned teacher model. Format:
   * `projects/{project}/locations/{location}/models/{model}`.
   * </pre>
   *
   * <code>string tuned_teacher_model_source = 6 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The bytes for tunedTeacherModelSource.
   */
  public com.google.protobuf.ByteString getTunedTeacherModelSourceBytes() {
    java.lang.Object ref = "";
    if (teacherModelCase_ == 6) {
      ref = teacherModel_;
    }
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      if (teacherModelCase_ == 6) {
        teacherModel_ = b;
      }
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TRAINING_DATASET_URI_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object trainingDatasetUri_ = "";

  /**
   *
   *
   * <pre>
   * Required. Cloud Storage path to file containing training dataset for
   * tuning. The dataset must be formatted as a JSONL file.
   * </pre>
   *
   * <code>string training_dataset_uri = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The trainingDatasetUri.
   */
  @java.lang.Override
  public java.lang.String getTrainingDatasetUri() {
    java.lang.Object ref = trainingDatasetUri_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      trainingDatasetUri_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Required. Cloud Storage path to file containing training dataset for
   * tuning. The dataset must be formatted as a JSONL file.
   * </pre>
   *
   * <code>string training_dataset_uri = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for trainingDatasetUri.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getTrainingDatasetUriBytes() {
    java.lang.Object ref = trainingDatasetUri_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      trainingDatasetUri_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int VALIDATION_DATASET_URI_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object validationDatasetUri_ = "";

  /**
   *
   *
   * <pre>
   * Optional. Cloud Storage path to file containing validation dataset for
   * tuning. The dataset must be formatted as a JSONL file.
   * </pre>
   *
   * <code>optional string validation_dataset_uri = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the validationDatasetUri field is set.
   */
  @java.lang.Override
  public boolean hasValidationDatasetUri() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * Optional. Cloud Storage path to file containing validation dataset for
   * tuning. The dataset must be formatted as a JSONL file.
   * </pre>
   *
   * <code>optional string validation_dataset_uri = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The validationDatasetUri.
   */
  @java.lang.Override
  public java.lang.String getValidationDatasetUri() {
    java.lang.Object ref = validationDatasetUri_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      validationDatasetUri_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Optional. Cloud Storage path to file containing validation dataset for
   * tuning. The dataset must be formatted as a JSONL file.
   * </pre>
   *
   * <code>optional string validation_dataset_uri = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The bytes for validationDatasetUri.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getValidationDatasetUriBytes() {
    java.lang.Object ref = validationDatasetUri_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      validationDatasetUri_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int HYPER_PARAMETERS_FIELD_NUMBER = 3;
  private com.google.cloud.aiplatform.v1beta1.DistillationHyperParameters hyperParameters_;

  /**
   *
   *
   * <pre>
   * Optional. Hyperparameters for Distillation.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.DistillationHyperParameters hyper_parameters = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the hyperParameters field is set.
   */
  @java.lang.Override
  public boolean hasHyperParameters() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * Optional. Hyperparameters for Distillation.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.DistillationHyperParameters hyper_parameters = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The hyperParameters.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.DistillationHyperParameters getHyperParameters() {
    return hyperParameters_ == null
        ? com.google.cloud.aiplatform.v1beta1.DistillationHyperParameters.getDefaultInstance()
        : hyperParameters_;
  }

  /**
   *
   *
   * <pre>
   * Optional. Hyperparameters for Distillation.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.DistillationHyperParameters hyper_parameters = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.DistillationHyperParametersOrBuilder
      getHyperParametersOrBuilder() {
    return hyperParameters_ == null
        ? com.google.cloud.aiplatform.v1beta1.DistillationHyperParameters.getDefaultInstance()
        : hyperParameters_;
  }

  public static final int STUDENT_MODEL_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object studentModel_ = "";

  /**
   *
   *
   * <pre>
   * The student model that is being tuned, e.g., "google/gemma-2b-1.1-it".
   * </pre>
   *
   * <code>string student_model = 4;</code>
   *
   * @return The studentModel.
   */
  @java.lang.Override
  public java.lang.String getStudentModel() {
    java.lang.Object ref = studentModel_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      studentModel_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * The student model that is being tuned, e.g., "google/gemma-2b-1.1-it".
   * </pre>
   *
   * <code>string student_model = 4;</code>
   *
   * @return The bytes for studentModel.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getStudentModelBytes() {
    java.lang.Object ref = studentModel_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      studentModel_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PIPELINE_ROOT_DIRECTORY_FIELD_NUMBER = 7;

  @SuppressWarnings("serial")
  private volatile java.lang.Object pipelineRootDirectory_ = "";

  /**
   *
   *
   * <pre>
   * Required. A path in a Cloud Storage bucket, which will be treated as the
   * root output directory of the distillation pipeline. It is used by the
   * system to generate the paths of output artifacts.
   * </pre>
   *
   * <code>string pipeline_root_directory = 7 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The pipelineRootDirectory.
   */
  @java.lang.Override
  public java.lang.String getPipelineRootDirectory() {
    java.lang.Object ref = pipelineRootDirectory_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      pipelineRootDirectory_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Required. A path in a Cloud Storage bucket, which will be treated as the
   * root output directory of the distillation pipeline. It is used by the
   * system to generate the paths of output artifacts.
   * </pre>
   *
   * <code>string pipeline_root_directory = 7 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for pipelineRootDirectory.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPipelineRootDirectoryBytes() {
    java.lang.Object ref = pipelineRootDirectory_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      pipelineRootDirectory_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(trainingDatasetUri_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, trainingDatasetUri_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, validationDatasetUri_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(3, getHyperParameters());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(studentModel_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, studentModel_);
    }
    if (teacherModelCase_ == 5) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, teacherModel_);
    }
    if (teacherModelCase_ == 6) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, teacherModel_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(pipelineRootDirectory_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 7, pipelineRootDirectory_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(trainingDatasetUri_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, trainingDatasetUri_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, validationDatasetUri_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getHyperParameters());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(studentModel_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, studentModel_);
    }
    if (teacherModelCase_ == 5) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, teacherModel_);
    }
    if (teacherModelCase_ == 6) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, teacherModel_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(pipelineRootDirectory_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(7, pipelineRootDirectory_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.DistillationSpec)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1beta1.DistillationSpec other =
        (com.google.cloud.aiplatform.v1beta1.DistillationSpec) obj;

    if (!getTrainingDatasetUri().equals(other.getTrainingDatasetUri())) return false;
    if (hasValidationDatasetUri() != other.hasValidationDatasetUri()) return false;
    if (hasValidationDatasetUri()) {
      if (!getValidationDatasetUri().equals(other.getValidationDatasetUri())) return false;
    }
    if (hasHyperParameters() != other.hasHyperParameters()) return false;
    if (hasHyperParameters()) {
      if (!getHyperParameters().equals(other.getHyperParameters())) return false;
    }
    if (!getStudentModel().equals(other.getStudentModel())) return false;
    if (!getPipelineRootDirectory().equals(other.getPipelineRootDirectory())) return false;
    if (!getTeacherModelCase().equals(other.getTeacherModelCase())) return false;
    switch (teacherModelCase_) {
      case 5:
        if (!getBaseTeacherModel().equals(other.getBaseTeacherModel())) return false;
        break;
      case 6:
        if (!getTunedTeacherModelSource().equals(other.getTunedTeacherModelSource())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + TRAINING_DATASET_URI_FIELD_NUMBER;
    hash = (53 * hash) + getTrainingDatasetUri().hashCode();
    if (hasValidationDatasetUri()) {
      hash = (37 * hash) + VALIDATION_DATASET_URI_FIELD_NUMBER;
      hash = (53 * hash) + getValidationDatasetUri().hashCode();
    }
    if (hasHyperParameters()) {
      hash = (37 * hash) + HYPER_PARAMETERS_FIELD_NUMBER;
      hash = (53 * hash) + getHyperParameters().hashCode();
    }
    hash = (37 * hash) + STUDENT_MODEL_FIELD_NUMBER;
    hash = (53 * hash) + getStudentModel().hashCode();
    hash = (37 * hash) + PIPELINE_ROOT_DIRECTORY_FIELD_NUMBER;
    hash = (53 * hash) + getPipelineRootDirectory().hashCode();
    switch (teacherModelCase_) {
      case 5:
        hash = (37 * hash) + BASE_TEACHER_MODEL_FIELD_NUMBER;
        hash = (53 * hash) + getBaseTeacherModel().hashCode();
        break;
      case 6:
        hash = (37 * hash) + TUNED_TEACHER_MODEL_SOURCE_FIELD_NUMBER;
        hash = (53 * hash) + getTunedTeacherModelSource().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1beta1.DistillationSpec parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.DistillationSpec parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.DistillationSpec parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.DistillationSpec parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.DistillationSpec parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.DistillationSpec parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.DistillationSpec parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.DistillationSpec parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.DistillationSpec parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.DistillationSpec parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.DistillationSpec parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.DistillationSpec parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.aiplatform.v1beta1.DistillationSpec prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Tuning Spec for Distillation.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.DistillationSpec}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.DistillationSpec)
      com.google.cloud.aiplatform.v1beta1.DistillationSpecOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.TuningJobProto
          .internal_static_google_cloud_aiplatform_v1beta1_DistillationSpec_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.TuningJobProto
          .internal_static_google_cloud_aiplatform_v1beta1_DistillationSpec_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.DistillationSpec.class,
              com.google.cloud.aiplatform.v1beta1.DistillationSpec.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1beta1.DistillationSpec.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getHyperParametersFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      trainingDatasetUri_ = "";
      validationDatasetUri_ = "";
      hyperParameters_ = null;
      if (hyperParametersBuilder_ != null) {
        hyperParametersBuilder_.dispose();
        hyperParametersBuilder_ = null;
      }
      studentModel_ = "";
      pipelineRootDirectory_ = "";
      teacherModelCase_ = 0;
      teacherModel_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1beta1.TuningJobProto
          .internal_static_google_cloud_aiplatform_v1beta1_DistillationSpec_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.DistillationSpec getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1beta1.DistillationSpec.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.DistillationSpec build() {
      com.google.cloud.aiplatform.v1beta1.DistillationSpec result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.DistillationSpec buildPartial() {
      com.google.cloud.aiplatform.v1beta1.DistillationSpec result =
          new com.google.cloud.aiplatform.v1beta1.DistillationSpec(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.aiplatform.v1beta1.DistillationSpec result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.trainingDatasetUri_ = trainingDatasetUri_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.validationDatasetUri_ = validationDatasetUri_;
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.hyperParameters_ =
            hyperParametersBuilder_ == null ? hyperParameters_ : hyperParametersBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.studentModel_ = studentModel_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.pipelineRootDirectory_ = pipelineRootDirectory_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    private void buildPartialOneofs(com.google.cloud.aiplatform.v1beta1.DistillationSpec result) {
      result.teacherModelCase_ = teacherModelCase_;
      result.teacherModel_ = this.teacherModel_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1beta1.DistillationSpec) {
        return mergeFrom((com.google.cloud.aiplatform.v1beta1.DistillationSpec) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1beta1.DistillationSpec other) {
      if (other == com.google.cloud.aiplatform.v1beta1.DistillationSpec.getDefaultInstance())
        return this;
      if (!other.getTrainingDatasetUri().isEmpty()) {
        trainingDatasetUri_ = other.trainingDatasetUri_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.hasValidationDatasetUri()) {
        validationDatasetUri_ = other.validationDatasetUri_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (other.hasHyperParameters()) {
        mergeHyperParameters(other.getHyperParameters());
      }
      if (!other.getStudentModel().isEmpty()) {
        studentModel_ = other.studentModel_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      if (!other.getPipelineRootDirectory().isEmpty()) {
        pipelineRootDirectory_ = other.pipelineRootDirectory_;
        bitField0_ |= 0x00000040;
        onChanged();
      }
      switch (other.getTeacherModelCase()) {
        case BASE_TEACHER_MODEL:
          {
            teacherModelCase_ = 5;
            teacherModel_ = other.teacherModel_;
            onChanged();
            break;
          }
        case TUNED_TEACHER_MODEL_SOURCE:
          {
            teacherModelCase_ = 6;
            teacherModel_ = other.teacherModel_;
            onChanged();
            break;
          }
        case TEACHERMODEL_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                trainingDatasetUri_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 10
            case 18:
              {
                validationDatasetUri_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getHyperParametersFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 26
            case 34:
              {
                studentModel_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 34
            case 42:
              {
                java.lang.String s = input.readStringRequireUtf8();
                teacherModelCase_ = 5;
                teacherModel_ = s;
                break;
              } // case 42
            case 50:
              {
                java.lang.String s = input.readStringRequireUtf8();
                teacherModelCase_ = 6;
                teacherModel_ = s;
                break;
              } // case 50
            case 58:
              {
                pipelineRootDirectory_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000040;
                break;
              } // case 58
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int teacherModelCase_ = 0;
    private java.lang.Object teacherModel_;

    public TeacherModelCase getTeacherModelCase() {
      return TeacherModelCase.forNumber(teacherModelCase_);
    }

    public Builder clearTeacherModel() {
      teacherModelCase_ = 0;
      teacherModel_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    /**
     *
     *
     * <pre>
     * The base teacher model that is being distilled. See [Supported
     * models](https://cloud.google.com/vertex-ai/generative-ai/docs/model-reference/tuning#supported_models).
     * </pre>
     *
     * <code>string base_teacher_model = 5;</code>
     *
     * @return Whether the baseTeacherModel field is set.
     */
    @java.lang.Override
    public boolean hasBaseTeacherModel() {
      return teacherModelCase_ == 5;
    }

    /**
     *
     *
     * <pre>
     * The base teacher model that is being distilled. See [Supported
     * models](https://cloud.google.com/vertex-ai/generative-ai/docs/model-reference/tuning#supported_models).
     * </pre>
     *
     * <code>string base_teacher_model = 5;</code>
     *
     * @return The baseTeacherModel.
     */
    @java.lang.Override
    public java.lang.String getBaseTeacherModel() {
      java.lang.Object ref = "";
      if (teacherModelCase_ == 5) {
        ref = teacherModel_;
      }
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (teacherModelCase_ == 5) {
          teacherModel_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The base teacher model that is being distilled. See [Supported
     * models](https://cloud.google.com/vertex-ai/generative-ai/docs/model-reference/tuning#supported_models).
     * </pre>
     *
     * <code>string base_teacher_model = 5;</code>
     *
     * @return The bytes for baseTeacherModel.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getBaseTeacherModelBytes() {
      java.lang.Object ref = "";
      if (teacherModelCase_ == 5) {
        ref = teacherModel_;
      }
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (teacherModelCase_ == 5) {
          teacherModel_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The base teacher model that is being distilled. See [Supported
     * models](https://cloud.google.com/vertex-ai/generative-ai/docs/model-reference/tuning#supported_models).
     * </pre>
     *
     * <code>string base_teacher_model = 5;</code>
     *
     * @param value The baseTeacherModel to set.
     * @return This builder for chaining.
     */
    public Builder setBaseTeacherModel(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      teacherModelCase_ = 5;
      teacherModel_ = value;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The base teacher model that is being distilled. See [Supported
     * models](https://cloud.google.com/vertex-ai/generative-ai/docs/model-reference/tuning#supported_models).
     * </pre>
     *
     * <code>string base_teacher_model = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearBaseTeacherModel() {
      if (teacherModelCase_ == 5) {
        teacherModelCase_ = 0;
        teacherModel_ = null;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The base teacher model that is being distilled. See [Supported
     * models](https://cloud.google.com/vertex-ai/generative-ai/docs/model-reference/tuning#supported_models).
     * </pre>
     *
     * <code>string base_teacher_model = 5;</code>
     *
     * @param value The bytes for baseTeacherModel to set.
     * @return This builder for chaining.
     */
    public Builder setBaseTeacherModelBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      teacherModelCase_ = 5;
      teacherModel_ = value;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The resource name of the Tuned teacher model. Format:
     * `projects/{project}/locations/{location}/models/{model}`.
     * </pre>
     *
     * <code>string tuned_teacher_model_source = 6 [(.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return Whether the tunedTeacherModelSource field is set.
     */
    @java.lang.Override
    public boolean hasTunedTeacherModelSource() {
      return teacherModelCase_ == 6;
    }

    /**
     *
     *
     * <pre>
     * The resource name of the Tuned teacher model. Format:
     * `projects/{project}/locations/{location}/models/{model}`.
     * </pre>
     *
     * <code>string tuned_teacher_model_source = 6 [(.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The tunedTeacherModelSource.
     */
    @java.lang.Override
    public java.lang.String getTunedTeacherModelSource() {
      java.lang.Object ref = "";
      if (teacherModelCase_ == 6) {
        ref = teacherModel_;
      }
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (teacherModelCase_ == 6) {
          teacherModel_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The resource name of the Tuned teacher model. Format:
     * `projects/{project}/locations/{location}/models/{model}`.
     * </pre>
     *
     * <code>string tuned_teacher_model_source = 6 [(.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for tunedTeacherModelSource.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getTunedTeacherModelSourceBytes() {
      java.lang.Object ref = "";
      if (teacherModelCase_ == 6) {
        ref = teacherModel_;
      }
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (teacherModelCase_ == 6) {
          teacherModel_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The resource name of the Tuned teacher model. Format:
     * `projects/{project}/locations/{location}/models/{model}`.
     * </pre>
     *
     * <code>string tuned_teacher_model_source = 6 [(.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The tunedTeacherModelSource to set.
     * @return This builder for chaining.
     */
    public Builder setTunedTeacherModelSource(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      teacherModelCase_ = 6;
      teacherModel_ = value;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The resource name of the Tuned teacher model. Format:
     * `projects/{project}/locations/{location}/models/{model}`.
     * </pre>
     *
     * <code>string tuned_teacher_model_source = 6 [(.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTunedTeacherModelSource() {
      if (teacherModelCase_ == 6) {
        teacherModelCase_ = 0;
        teacherModel_ = null;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The resource name of the Tuned teacher model. Format:
     * `projects/{project}/locations/{location}/models/{model}`.
     * </pre>
     *
     * <code>string tuned_teacher_model_source = 6 [(.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for tunedTeacherModelSource to set.
     * @return This builder for chaining.
     */
    public Builder setTunedTeacherModelSourceBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      teacherModelCase_ = 6;
      teacherModel_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object trainingDatasetUri_ = "";

    /**
     *
     *
     * <pre>
     * Required. Cloud Storage path to file containing training dataset for
     * tuning. The dataset must be formatted as a JSONL file.
     * </pre>
     *
     * <code>string training_dataset_uri = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The trainingDatasetUri.
     */
    public java.lang.String getTrainingDatasetUri() {
      java.lang.Object ref = trainingDatasetUri_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        trainingDatasetUri_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. Cloud Storage path to file containing training dataset for
     * tuning. The dataset must be formatted as a JSONL file.
     * </pre>
     *
     * <code>string training_dataset_uri = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for trainingDatasetUri.
     */
    public com.google.protobuf.ByteString getTrainingDatasetUriBytes() {
      java.lang.Object ref = trainingDatasetUri_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        trainingDatasetUri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. Cloud Storage path to file containing training dataset for
     * tuning. The dataset must be formatted as a JSONL file.
     * </pre>
     *
     * <code>string training_dataset_uri = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The trainingDatasetUri to set.
     * @return This builder for chaining.
     */
    public Builder setTrainingDatasetUri(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      trainingDatasetUri_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. Cloud Storage path to file containing training dataset for
     * tuning. The dataset must be formatted as a JSONL file.
     * </pre>
     *
     * <code>string training_dataset_uri = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTrainingDatasetUri() {
      trainingDatasetUri_ = getDefaultInstance().getTrainingDatasetUri();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. Cloud Storage path to file containing training dataset for
     * tuning. The dataset must be formatted as a JSONL file.
     * </pre>
     *
     * <code>string training_dataset_uri = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for trainingDatasetUri to set.
     * @return This builder for chaining.
     */
    public Builder setTrainingDatasetUriBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      trainingDatasetUri_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object validationDatasetUri_ = "";

    /**
     *
     *
     * <pre>
     * Optional. Cloud Storage path to file containing validation dataset for
     * tuning. The dataset must be formatted as a JSONL file.
     * </pre>
     *
     * <code>optional string validation_dataset_uri = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the validationDatasetUri field is set.
     */
    public boolean hasValidationDatasetUri() {
      return ((bitField0_ & 0x00000008) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. Cloud Storage path to file containing validation dataset for
     * tuning. The dataset must be formatted as a JSONL file.
     * </pre>
     *
     * <code>optional string validation_dataset_uri = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The validationDatasetUri.
     */
    public java.lang.String getValidationDatasetUri() {
      java.lang.Object ref = validationDatasetUri_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        validationDatasetUri_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Cloud Storage path to file containing validation dataset for
     * tuning. The dataset must be formatted as a JSONL file.
     * </pre>
     *
     * <code>optional string validation_dataset_uri = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The bytes for validationDatasetUri.
     */
    public com.google.protobuf.ByteString getValidationDatasetUriBytes() {
      java.lang.Object ref = validationDatasetUri_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        validationDatasetUri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Cloud Storage path to file containing validation dataset for
     * tuning. The dataset must be formatted as a JSONL file.
     * </pre>
     *
     * <code>optional string validation_dataset_uri = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The validationDatasetUri to set.
     * @return This builder for chaining.
     */
    public Builder setValidationDatasetUri(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      validationDatasetUri_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Cloud Storage path to file containing validation dataset for
     * tuning. The dataset must be formatted as a JSONL file.
     * </pre>
     *
     * <code>optional string validation_dataset_uri = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearValidationDatasetUri() {
      validationDatasetUri_ = getDefaultInstance().getValidationDatasetUri();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Cloud Storage path to file containing validation dataset for
     * tuning. The dataset must be formatted as a JSONL file.
     * </pre>
     *
     * <code>optional string validation_dataset_uri = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The bytes for validationDatasetUri to set.
     * @return This builder for chaining.
     */
    public Builder setValidationDatasetUriBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      validationDatasetUri_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private com.google.cloud.aiplatform.v1beta1.DistillationHyperParameters hyperParameters_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.DistillationHyperParameters,
            com.google.cloud.aiplatform.v1beta1.DistillationHyperParameters.Builder,
            com.google.cloud.aiplatform.v1beta1.DistillationHyperParametersOrBuilder>
        hyperParametersBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. Hyperparameters for Distillation.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.DistillationHyperParameters hyper_parameters = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the hyperParameters field is set.
     */
    public boolean hasHyperParameters() {
      return ((bitField0_ & 0x00000010) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. Hyperparameters for Distillation.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.DistillationHyperParameters hyper_parameters = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The hyperParameters.
     */
    public com.google.cloud.aiplatform.v1beta1.DistillationHyperParameters getHyperParameters() {
      if (hyperParametersBuilder_ == null) {
        return hyperParameters_ == null
            ? com.google.cloud.aiplatform.v1beta1.DistillationHyperParameters.getDefaultInstance()
            : hyperParameters_;
      } else {
        return hyperParametersBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Hyperparameters for Distillation.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.DistillationHyperParameters hyper_parameters = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setHyperParameters(
        com.google.cloud.aiplatform.v1beta1.DistillationHyperParameters value) {
      if (hyperParametersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        hyperParameters_ = value;
      } else {
        hyperParametersBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Hyperparameters for Distillation.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.DistillationHyperParameters hyper_parameters = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setHyperParameters(
        com.google.cloud.aiplatform.v1beta1.DistillationHyperParameters.Builder builderForValue) {
      if (hyperParametersBuilder_ == null) {
        hyperParameters_ = builderForValue.build();
      } else {
        hyperParametersBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Hyperparameters for Distillation.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.DistillationHyperParameters hyper_parameters = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeHyperParameters(
        com.google.cloud.aiplatform.v1beta1.DistillationHyperParameters value) {
      if (hyperParametersBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && hyperParameters_ != null
            && hyperParameters_
                != com.google.cloud.aiplatform.v1beta1.DistillationHyperParameters
                    .getDefaultInstance()) {
          getHyperParametersBuilder().mergeFrom(value);
        } else {
          hyperParameters_ = value;
        }
      } else {
        hyperParametersBuilder_.mergeFrom(value);
      }
      if (hyperParameters_ != null) {
        bitField0_ |= 0x00000010;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Hyperparameters for Distillation.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.DistillationHyperParameters hyper_parameters = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearHyperParameters() {
      bitField0_ = (bitField0_ & ~0x00000010);
      hyperParameters_ = null;
      if (hyperParametersBuilder_ != null) {
        hyperParametersBuilder_.dispose();
        hyperParametersBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Hyperparameters for Distillation.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.DistillationHyperParameters hyper_parameters = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.DistillationHyperParameters.Builder
        getHyperParametersBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getHyperParametersFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Optional. Hyperparameters for Distillation.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.DistillationHyperParameters hyper_parameters = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.DistillationHyperParametersOrBuilder
        getHyperParametersOrBuilder() {
      if (hyperParametersBuilder_ != null) {
        return hyperParametersBuilder_.getMessageOrBuilder();
      } else {
        return hyperParameters_ == null
            ? com.google.cloud.aiplatform.v1beta1.DistillationHyperParameters.getDefaultInstance()
            : hyperParameters_;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Hyperparameters for Distillation.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.DistillationHyperParameters hyper_parameters = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.DistillationHyperParameters,
            com.google.cloud.aiplatform.v1beta1.DistillationHyperParameters.Builder,
            com.google.cloud.aiplatform.v1beta1.DistillationHyperParametersOrBuilder>
        getHyperParametersFieldBuilder() {
      if (hyperParametersBuilder_ == null) {
        hyperParametersBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.DistillationHyperParameters,
                com.google.cloud.aiplatform.v1beta1.DistillationHyperParameters.Builder,
                com.google.cloud.aiplatform.v1beta1.DistillationHyperParametersOrBuilder>(
                getHyperParameters(), getParentForChildren(), isClean());
        hyperParameters_ = null;
      }
      return hyperParametersBuilder_;
    }

    private java.lang.Object studentModel_ = "";

    /**
     *
     *
     * <pre>
     * The student model that is being tuned, e.g., "google/gemma-2b-1.1-it".
     * </pre>
     *
     * <code>string student_model = 4;</code>
     *
     * @return The studentModel.
     */
    public java.lang.String getStudentModel() {
      java.lang.Object ref = studentModel_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        studentModel_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The student model that is being tuned, e.g., "google/gemma-2b-1.1-it".
     * </pre>
     *
     * <code>string student_model = 4;</code>
     *
     * @return The bytes for studentModel.
     */
    public com.google.protobuf.ByteString getStudentModelBytes() {
      java.lang.Object ref = studentModel_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        studentModel_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The student model that is being tuned, e.g., "google/gemma-2b-1.1-it".
     * </pre>
     *
     * <code>string student_model = 4;</code>
     *
     * @param value The studentModel to set.
     * @return This builder for chaining.
     */
    public Builder setStudentModel(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      studentModel_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The student model that is being tuned, e.g., "google/gemma-2b-1.1-it".
     * </pre>
     *
     * <code>string student_model = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearStudentModel() {
      studentModel_ = getDefaultInstance().getStudentModel();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The student model that is being tuned, e.g., "google/gemma-2b-1.1-it".
     * </pre>
     *
     * <code>string student_model = 4;</code>
     *
     * @param value The bytes for studentModel to set.
     * @return This builder for chaining.
     */
    public Builder setStudentModelBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      studentModel_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private java.lang.Object pipelineRootDirectory_ = "";

    /**
     *
     *
     * <pre>
     * Required. A path in a Cloud Storage bucket, which will be treated as the
     * root output directory of the distillation pipeline. It is used by the
     * system to generate the paths of output artifacts.
     * </pre>
     *
     * <code>string pipeline_root_directory = 7 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The pipelineRootDirectory.
     */
    public java.lang.String getPipelineRootDirectory() {
      java.lang.Object ref = pipelineRootDirectory_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        pipelineRootDirectory_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. A path in a Cloud Storage bucket, which will be treated as the
     * root output directory of the distillation pipeline. It is used by the
     * system to generate the paths of output artifacts.
     * </pre>
     *
     * <code>string pipeline_root_directory = 7 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for pipelineRootDirectory.
     */
    public com.google.protobuf.ByteString getPipelineRootDirectoryBytes() {
      java.lang.Object ref = pipelineRootDirectory_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        pipelineRootDirectory_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. A path in a Cloud Storage bucket, which will be treated as the
     * root output directory of the distillation pipeline. It is used by the
     * system to generate the paths of output artifacts.
     * </pre>
     *
     * <code>string pipeline_root_directory = 7 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The pipelineRootDirectory to set.
     * @return This builder for chaining.
     */
    public Builder setPipelineRootDirectory(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      pipelineRootDirectory_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. A path in a Cloud Storage bucket, which will be treated as the
     * root output directory of the distillation pipeline. It is used by the
     * system to generate the paths of output artifacts.
     * </pre>
     *
     * <code>string pipeline_root_directory = 7 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPipelineRootDirectory() {
      pipelineRootDirectory_ = getDefaultInstance().getPipelineRootDirectory();
      bitField0_ = (bitField0_ & ~0x00000040);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. A path in a Cloud Storage bucket, which will be treated as the
     * root output directory of the distillation pipeline. It is used by the
     * system to generate the paths of output artifacts.
     * </pre>
     *
     * <code>string pipeline_root_directory = 7 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for pipelineRootDirectory to set.
     * @return This builder for chaining.
     */
    public Builder setPipelineRootDirectoryBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      pipelineRootDirectory_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.DistillationSpec)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.DistillationSpec)
  private static final com.google.cloud.aiplatform.v1beta1.DistillationSpec DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.DistillationSpec();
  }

  public static com.google.cloud.aiplatform.v1beta1.DistillationSpec getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<DistillationSpec> PARSER =
      new com.google.protobuf.AbstractParser<DistillationSpec>() {
        @java.lang.Override
        public DistillationSpec parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<DistillationSpec> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<DistillationSpec> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.DistillationSpec getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
