/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1beta1/feature.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.aiplatform.v1beta1;

/**
 *
 *
 * <pre>
 * Feature Metadata information.
 * For example, color is a feature that describes an apple.
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1beta1.Feature}
 */
public final class Feature extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.Feature)
    FeatureOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use Feature.newBuilder() to construct.
  private Feature(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Feature() {
    name_ = "";
    description_ = "";
    valueType_ = 0;
    etag_ = "";
    monitoringStats_ = java.util.Collections.emptyList();
    monitoringStatsAnomalies_ = java.util.Collections.emptyList();
    featureStatsAndAnomaly_ = java.util.Collections.emptyList();
    versionColumnName_ = "";
    pointOfContact_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Feature();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1beta1.FeatureProto
        .internal_static_google_cloud_aiplatform_v1beta1_Feature_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
      int number) {
    switch (number) {
      case 6:
        return internalGetLabels();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1beta1.FeatureProto
        .internal_static_google_cloud_aiplatform_v1beta1_Feature_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1beta1.Feature.class,
            com.google.cloud.aiplatform.v1beta1.Feature.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Only applicable for Vertex AI Legacy Feature Store.
   * An enum representing the value type of a feature.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.aiplatform.v1beta1.Feature.ValueType}
   */
  public enum ValueType implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * The value type is unspecified.
     * </pre>
     *
     * <code>VALUE_TYPE_UNSPECIFIED = 0;</code>
     */
    VALUE_TYPE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Used for Feature that is a boolean.
     * </pre>
     *
     * <code>BOOL = 1;</code>
     */
    BOOL(1),
    /**
     *
     *
     * <pre>
     * Used for Feature that is a list of boolean.
     * </pre>
     *
     * <code>BOOL_ARRAY = 2;</code>
     */
    BOOL_ARRAY(2),
    /**
     *
     *
     * <pre>
     * Used for Feature that is double.
     * </pre>
     *
     * <code>DOUBLE = 3;</code>
     */
    DOUBLE(3),
    /**
     *
     *
     * <pre>
     * Used for Feature that is a list of double.
     * </pre>
     *
     * <code>DOUBLE_ARRAY = 4;</code>
     */
    DOUBLE_ARRAY(4),
    /**
     *
     *
     * <pre>
     * Used for Feature that is INT64.
     * </pre>
     *
     * <code>INT64 = 9;</code>
     */
    INT64(9),
    /**
     *
     *
     * <pre>
     * Used for Feature that is a list of INT64.
     * </pre>
     *
     * <code>INT64_ARRAY = 10;</code>
     */
    INT64_ARRAY(10),
    /**
     *
     *
     * <pre>
     * Used for Feature that is string.
     * </pre>
     *
     * <code>STRING = 11;</code>
     */
    STRING(11),
    /**
     *
     *
     * <pre>
     * Used for Feature that is a list of String.
     * </pre>
     *
     * <code>STRING_ARRAY = 12;</code>
     */
    STRING_ARRAY(12),
    /**
     *
     *
     * <pre>
     * Used for Feature that is bytes.
     * </pre>
     *
     * <code>BYTES = 13;</code>
     */
    BYTES(13),
    /**
     *
     *
     * <pre>
     * Used for Feature that is struct.
     * </pre>
     *
     * <code>STRUCT = 14;</code>
     */
    STRUCT(14),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * The value type is unspecified.
     * </pre>
     *
     * <code>VALUE_TYPE_UNSPECIFIED = 0;</code>
     */
    public static final int VALUE_TYPE_UNSPECIFIED_VALUE = 0;

    /**
     *
     *
     * <pre>
     * Used for Feature that is a boolean.
     * </pre>
     *
     * <code>BOOL = 1;</code>
     */
    public static final int BOOL_VALUE = 1;

    /**
     *
     *
     * <pre>
     * Used for Feature that is a list of boolean.
     * </pre>
     *
     * <code>BOOL_ARRAY = 2;</code>
     */
    public static final int BOOL_ARRAY_VALUE = 2;

    /**
     *
     *
     * <pre>
     * Used for Feature that is double.
     * </pre>
     *
     * <code>DOUBLE = 3;</code>
     */
    public static final int DOUBLE_VALUE = 3;

    /**
     *
     *
     * <pre>
     * Used for Feature that is a list of double.
     * </pre>
     *
     * <code>DOUBLE_ARRAY = 4;</code>
     */
    public static final int DOUBLE_ARRAY_VALUE = 4;

    /**
     *
     *
     * <pre>
     * Used for Feature that is INT64.
     * </pre>
     *
     * <code>INT64 = 9;</code>
     */
    public static final int INT64_VALUE = 9;

    /**
     *
     *
     * <pre>
     * Used for Feature that is a list of INT64.
     * </pre>
     *
     * <code>INT64_ARRAY = 10;</code>
     */
    public static final int INT64_ARRAY_VALUE = 10;

    /**
     *
     *
     * <pre>
     * Used for Feature that is string.
     * </pre>
     *
     * <code>STRING = 11;</code>
     */
    public static final int STRING_VALUE = 11;

    /**
     *
     *
     * <pre>
     * Used for Feature that is a list of String.
     * </pre>
     *
     * <code>STRING_ARRAY = 12;</code>
     */
    public static final int STRING_ARRAY_VALUE = 12;

    /**
     *
     *
     * <pre>
     * Used for Feature that is bytes.
     * </pre>
     *
     * <code>BYTES = 13;</code>
     */
    public static final int BYTES_VALUE = 13;

    /**
     *
     *
     * <pre>
     * Used for Feature that is struct.
     * </pre>
     *
     * <code>STRUCT = 14;</code>
     */
    public static final int STRUCT_VALUE = 14;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ValueType valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static ValueType forNumber(int value) {
      switch (value) {
        case 0:
          return VALUE_TYPE_UNSPECIFIED;
        case 1:
          return BOOL;
        case 2:
          return BOOL_ARRAY;
        case 3:
          return DOUBLE;
        case 4:
          return DOUBLE_ARRAY;
        case 9:
          return INT64;
        case 10:
          return INT64_ARRAY;
        case 11:
          return STRING;
        case 12:
          return STRING_ARRAY;
        case 13:
          return BYTES;
        case 14:
          return STRUCT;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<ValueType> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<ValueType> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<ValueType>() {
          public ValueType findValueByNumber(int number) {
            return ValueType.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.Feature.getDescriptor().getEnumTypes().get(0);
    }

    private static final ValueType[] VALUES = values();

    public static ValueType valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private ValueType(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.aiplatform.v1beta1.Feature.ValueType)
  }

  public interface MonitoringStatsAnomalyOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1beta1.Feature.MonitoringStatsAnomaly)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Output only. The objective for each stats.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.Feature.MonitoringStatsAnomaly.Objective objective = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for objective.
     */
    int getObjectiveValue();

    /**
     *
     *
     * <pre>
     * Output only. The objective for each stats.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.Feature.MonitoringStatsAnomaly.Objective objective = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The objective.
     */
    com.google.cloud.aiplatform.v1beta1.Feature.MonitoringStatsAnomaly.Objective getObjective();

    /**
     *
     *
     * <pre>
     * Output only. The stats and anomalies generated at specific timestamp.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly feature_stats_anomaly = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the featureStatsAnomaly field is set.
     */
    boolean hasFeatureStatsAnomaly();

    /**
     *
     *
     * <pre>
     * Output only. The stats and anomalies generated at specific timestamp.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly feature_stats_anomaly = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The featureStatsAnomaly.
     */
    com.google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly getFeatureStatsAnomaly();

    /**
     *
     *
     * <pre>
     * Output only. The stats and anomalies generated at specific timestamp.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly feature_stats_anomaly = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    com.google.cloud.aiplatform.v1beta1.FeatureStatsAnomalyOrBuilder
        getFeatureStatsAnomalyOrBuilder();
  }

  /**
   *
   *
   * <pre>
   * A list of historical
   * [SnapshotAnalysis][google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig.SnapshotAnalysis]
   * or
   * [ImportFeaturesAnalysis][google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig.ImportFeaturesAnalysis]
   * stats requested by user, sorted by
   * [FeatureStatsAnomaly.start_time][google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly.start_time]
   * descending.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.Feature.MonitoringStatsAnomaly}
   */
  public static final class MonitoringStatsAnomaly extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.Feature.MonitoringStatsAnomaly)
      MonitoringStatsAnomalyOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use MonitoringStatsAnomaly.newBuilder() to construct.
    private MonitoringStatsAnomaly(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private MonitoringStatsAnomaly() {
      objective_ = 0;
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new MonitoringStatsAnomaly();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.FeatureProto
          .internal_static_google_cloud_aiplatform_v1beta1_Feature_MonitoringStatsAnomaly_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.FeatureProto
          .internal_static_google_cloud_aiplatform_v1beta1_Feature_MonitoringStatsAnomaly_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.Feature.MonitoringStatsAnomaly.class,
              com.google.cloud.aiplatform.v1beta1.Feature.MonitoringStatsAnomaly.Builder.class);
    }

    /**
     *
     *
     * <pre>
     * If the objective in the request is both
     * Import Feature Analysis and Snapshot Analysis, this objective could be
     * one of them. Otherwise, this objective should be the same as the
     * objective in the request.
     * </pre>
     *
     * Protobuf enum {@code
     * google.cloud.aiplatform.v1beta1.Feature.MonitoringStatsAnomaly.Objective}
     */
    public enum Objective implements com.google.protobuf.ProtocolMessageEnum {
      /**
       *
       *
       * <pre>
       * If it's OBJECTIVE_UNSPECIFIED, monitoring_stats will be empty.
       * </pre>
       *
       * <code>OBJECTIVE_UNSPECIFIED = 0;</code>
       */
      OBJECTIVE_UNSPECIFIED(0),
      /**
       *
       *
       * <pre>
       * Stats are generated by Import Feature Analysis.
       * </pre>
       *
       * <code>IMPORT_FEATURE_ANALYSIS = 1;</code>
       */
      IMPORT_FEATURE_ANALYSIS(1),
      /**
       *
       *
       * <pre>
       * Stats are generated by Snapshot Analysis.
       * </pre>
       *
       * <code>SNAPSHOT_ANALYSIS = 2;</code>
       */
      SNAPSHOT_ANALYSIS(2),
      UNRECOGNIZED(-1),
      ;

      /**
       *
       *
       * <pre>
       * If it's OBJECTIVE_UNSPECIFIED, monitoring_stats will be empty.
       * </pre>
       *
       * <code>OBJECTIVE_UNSPECIFIED = 0;</code>
       */
      public static final int OBJECTIVE_UNSPECIFIED_VALUE = 0;

      /**
       *
       *
       * <pre>
       * Stats are generated by Import Feature Analysis.
       * </pre>
       *
       * <code>IMPORT_FEATURE_ANALYSIS = 1;</code>
       */
      public static final int IMPORT_FEATURE_ANALYSIS_VALUE = 1;

      /**
       *
       *
       * <pre>
       * Stats are generated by Snapshot Analysis.
       * </pre>
       *
       * <code>SNAPSHOT_ANALYSIS = 2;</code>
       */
      public static final int SNAPSHOT_ANALYSIS_VALUE = 2;

      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static Objective valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static Objective forNumber(int value) {
        switch (value) {
          case 0:
            return OBJECTIVE_UNSPECIFIED;
          case 1:
            return IMPORT_FEATURE_ANALYSIS;
          case 2:
            return SNAPSHOT_ANALYSIS;
          default:
            return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<Objective> internalGetValueMap() {
        return internalValueMap;
      }

      private static final com.google.protobuf.Internal.EnumLiteMap<Objective> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<Objective>() {
            public Objective findValueByNumber(int number) {
              return Objective.forNumber(number);
            }
          };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalStateException(
              "Can't get the descriptor of an unrecognized enum value.");
        }
        return getDescriptor().getValues().get(ordinal());
      }

      public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
        return getDescriptor();
      }

      public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1beta1.Feature.MonitoringStatsAnomaly.getDescriptor()
            .getEnumTypes()
            .get(0);
      }

      private static final Objective[] VALUES = values();

      public static Objective valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private Objective(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:google.cloud.aiplatform.v1beta1.Feature.MonitoringStatsAnomaly.Objective)
    }

    private int bitField0_;
    public static final int OBJECTIVE_FIELD_NUMBER = 1;
    private int objective_ = 0;

    /**
     *
     *
     * <pre>
     * Output only. The objective for each stats.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.Feature.MonitoringStatsAnomaly.Objective objective = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for objective.
     */
    @java.lang.Override
    public int getObjectiveValue() {
      return objective_;
    }

    /**
     *
     *
     * <pre>
     * Output only. The objective for each stats.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.Feature.MonitoringStatsAnomaly.Objective objective = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The objective.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.Feature.MonitoringStatsAnomaly.Objective
        getObjective() {
      com.google.cloud.aiplatform.v1beta1.Feature.MonitoringStatsAnomaly.Objective result =
          com.google.cloud.aiplatform.v1beta1.Feature.MonitoringStatsAnomaly.Objective.forNumber(
              objective_);
      return result == null
          ? com.google.cloud.aiplatform.v1beta1.Feature.MonitoringStatsAnomaly.Objective
              .UNRECOGNIZED
          : result;
    }

    public static final int FEATURE_STATS_ANOMALY_FIELD_NUMBER = 2;
    private com.google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly featureStatsAnomaly_;

    /**
     *
     *
     * <pre>
     * Output only. The stats and anomalies generated at specific timestamp.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly feature_stats_anomaly = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the featureStatsAnomaly field is set.
     */
    @java.lang.Override
    public boolean hasFeatureStatsAnomaly() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * Output only. The stats and anomalies generated at specific timestamp.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly feature_stats_anomaly = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The featureStatsAnomaly.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly getFeatureStatsAnomaly() {
      return featureStatsAnomaly_ == null
          ? com.google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly.getDefaultInstance()
          : featureStatsAnomaly_;
    }

    /**
     *
     *
     * <pre>
     * Output only. The stats and anomalies generated at specific timestamp.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly feature_stats_anomaly = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.FeatureStatsAnomalyOrBuilder
        getFeatureStatsAnomalyOrBuilder() {
      return featureStatsAnomaly_ == null
          ? com.google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly.getDefaultInstance()
          : featureStatsAnomaly_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (objective_
          != com.google.cloud.aiplatform.v1beta1.Feature.MonitoringStatsAnomaly.Objective
              .OBJECTIVE_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(1, objective_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(2, getFeatureStatsAnomaly());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (objective_
          != com.google.cloud.aiplatform.v1beta1.Feature.MonitoringStatsAnomaly.Objective
              .OBJECTIVE_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, objective_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(2, getFeatureStatsAnomaly());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.Feature.MonitoringStatsAnomaly)) {
        return super.equals(obj);
      }
      com.google.cloud.aiplatform.v1beta1.Feature.MonitoringStatsAnomaly other =
          (com.google.cloud.aiplatform.v1beta1.Feature.MonitoringStatsAnomaly) obj;

      if (objective_ != other.objective_) return false;
      if (hasFeatureStatsAnomaly() != other.hasFeatureStatsAnomaly()) return false;
      if (hasFeatureStatsAnomaly()) {
        if (!getFeatureStatsAnomaly().equals(other.getFeatureStatsAnomaly())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + OBJECTIVE_FIELD_NUMBER;
      hash = (53 * hash) + objective_;
      if (hasFeatureStatsAnomaly()) {
        hash = (37 * hash) + FEATURE_STATS_ANOMALY_FIELD_NUMBER;
        hash = (53 * hash) + getFeatureStatsAnomaly().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.aiplatform.v1beta1.Feature.MonitoringStatsAnomaly parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.Feature.MonitoringStatsAnomaly parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.Feature.MonitoringStatsAnomaly parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.Feature.MonitoringStatsAnomaly parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.Feature.MonitoringStatsAnomaly parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.Feature.MonitoringStatsAnomaly parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.Feature.MonitoringStatsAnomaly parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.Feature.MonitoringStatsAnomaly parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.Feature.MonitoringStatsAnomaly
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.Feature.MonitoringStatsAnomaly
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.Feature.MonitoringStatsAnomaly parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.Feature.MonitoringStatsAnomaly parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.aiplatform.v1beta1.Feature.MonitoringStatsAnomaly prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * A list of historical
     * [SnapshotAnalysis][google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig.SnapshotAnalysis]
     * or
     * [ImportFeaturesAnalysis][google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig.ImportFeaturesAnalysis]
     * stats requested by user, sorted by
     * [FeatureStatsAnomaly.start_time][google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly.start_time]
     * descending.
     * </pre>
     *
     * Protobuf type {@code google.cloud.aiplatform.v1beta1.Feature.MonitoringStatsAnomaly}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.Feature.MonitoringStatsAnomaly)
        com.google.cloud.aiplatform.v1beta1.Feature.MonitoringStatsAnomalyOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1beta1.FeatureProto
            .internal_static_google_cloud_aiplatform_v1beta1_Feature_MonitoringStatsAnomaly_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1beta1.FeatureProto
            .internal_static_google_cloud_aiplatform_v1beta1_Feature_MonitoringStatsAnomaly_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1beta1.Feature.MonitoringStatsAnomaly.class,
                com.google.cloud.aiplatform.v1beta1.Feature.MonitoringStatsAnomaly.Builder.class);
      }

      // Construct using
      // com.google.cloud.aiplatform.v1beta1.Feature.MonitoringStatsAnomaly.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getFeatureStatsAnomalyFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        objective_ = 0;
        featureStatsAnomaly_ = null;
        if (featureStatsAnomalyBuilder_ != null) {
          featureStatsAnomalyBuilder_.dispose();
          featureStatsAnomalyBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.aiplatform.v1beta1.FeatureProto
            .internal_static_google_cloud_aiplatform_v1beta1_Feature_MonitoringStatsAnomaly_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.Feature.MonitoringStatsAnomaly
          getDefaultInstanceForType() {
        return com.google.cloud.aiplatform.v1beta1.Feature.MonitoringStatsAnomaly
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.Feature.MonitoringStatsAnomaly build() {
        com.google.cloud.aiplatform.v1beta1.Feature.MonitoringStatsAnomaly result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.Feature.MonitoringStatsAnomaly buildPartial() {
        com.google.cloud.aiplatform.v1beta1.Feature.MonitoringStatsAnomaly result =
            new com.google.cloud.aiplatform.v1beta1.Feature.MonitoringStatsAnomaly(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.aiplatform.v1beta1.Feature.MonitoringStatsAnomaly result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.objective_ = objective_;
        }
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.featureStatsAnomaly_ =
              featureStatsAnomalyBuilder_ == null
                  ? featureStatsAnomaly_
                  : featureStatsAnomalyBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.aiplatform.v1beta1.Feature.MonitoringStatsAnomaly) {
          return mergeFrom(
              (com.google.cloud.aiplatform.v1beta1.Feature.MonitoringStatsAnomaly) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.aiplatform.v1beta1.Feature.MonitoringStatsAnomaly other) {
        if (other
            == com.google.cloud.aiplatform.v1beta1.Feature.MonitoringStatsAnomaly
                .getDefaultInstance()) return this;
        if (other.objective_ != 0) {
          setObjectiveValue(other.getObjectiveValue());
        }
        if (other.hasFeatureStatsAnomaly()) {
          mergeFeatureStatsAnomaly(other.getFeatureStatsAnomaly());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  objective_ = input.readEnum();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 8
              case 18:
                {
                  input.readMessage(
                      getFeatureStatsAnomalyFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private int objective_ = 0;

      /**
       *
       *
       * <pre>
       * Output only. The objective for each stats.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.Feature.MonitoringStatsAnomaly.Objective objective = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return The enum numeric value on the wire for objective.
       */
      @java.lang.Override
      public int getObjectiveValue() {
        return objective_;
      }

      /**
       *
       *
       * <pre>
       * Output only. The objective for each stats.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.Feature.MonitoringStatsAnomaly.Objective objective = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @param value The enum numeric value on the wire for objective to set.
       * @return This builder for chaining.
       */
      public Builder setObjectiveValue(int value) {
        objective_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Output only. The objective for each stats.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.Feature.MonitoringStatsAnomaly.Objective objective = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return The objective.
       */
      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.Feature.MonitoringStatsAnomaly.Objective
          getObjective() {
        com.google.cloud.aiplatform.v1beta1.Feature.MonitoringStatsAnomaly.Objective result =
            com.google.cloud.aiplatform.v1beta1.Feature.MonitoringStatsAnomaly.Objective.forNumber(
                objective_);
        return result == null
            ? com.google.cloud.aiplatform.v1beta1.Feature.MonitoringStatsAnomaly.Objective
                .UNRECOGNIZED
            : result;
      }

      /**
       *
       *
       * <pre>
       * Output only. The objective for each stats.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.Feature.MonitoringStatsAnomaly.Objective objective = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @param value The objective to set.
       * @return This builder for chaining.
       */
      public Builder setObjective(
          com.google.cloud.aiplatform.v1beta1.Feature.MonitoringStatsAnomaly.Objective value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000001;
        objective_ = value.getNumber();
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Output only. The objective for each stats.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.Feature.MonitoringStatsAnomaly.Objective objective = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearObjective() {
        bitField0_ = (bitField0_ & ~0x00000001);
        objective_ = 0;
        onChanged();
        return this;
      }

      private com.google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly featureStatsAnomaly_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly,
              com.google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly.Builder,
              com.google.cloud.aiplatform.v1beta1.FeatureStatsAnomalyOrBuilder>
          featureStatsAnomalyBuilder_;

      /**
       *
       *
       * <pre>
       * Output only. The stats and anomalies generated at specific timestamp.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly feature_stats_anomaly = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return Whether the featureStatsAnomaly field is set.
       */
      public boolean hasFeatureStatsAnomaly() {
        return ((bitField0_ & 0x00000002) != 0);
      }

      /**
       *
       *
       * <pre>
       * Output only. The stats and anomalies generated at specific timestamp.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly feature_stats_anomaly = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return The featureStatsAnomaly.
       */
      public com.google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly getFeatureStatsAnomaly() {
        if (featureStatsAnomalyBuilder_ == null) {
          return featureStatsAnomaly_ == null
              ? com.google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly.getDefaultInstance()
              : featureStatsAnomaly_;
        } else {
          return featureStatsAnomalyBuilder_.getMessage();
        }
      }

      /**
       *
       *
       * <pre>
       * Output only. The stats and anomalies generated at specific timestamp.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly feature_stats_anomaly = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder setFeatureStatsAnomaly(
          com.google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly value) {
        if (featureStatsAnomalyBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          featureStatsAnomaly_ = value;
        } else {
          featureStatsAnomalyBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Output only. The stats and anomalies generated at specific timestamp.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly feature_stats_anomaly = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder setFeatureStatsAnomaly(
          com.google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly.Builder builderForValue) {
        if (featureStatsAnomalyBuilder_ == null) {
          featureStatsAnomaly_ = builderForValue.build();
        } else {
          featureStatsAnomalyBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Output only. The stats and anomalies generated at specific timestamp.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly feature_stats_anomaly = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder mergeFeatureStatsAnomaly(
          com.google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly value) {
        if (featureStatsAnomalyBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)
              && featureStatsAnomaly_ != null
              && featureStatsAnomaly_
                  != com.google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly.getDefaultInstance()) {
            getFeatureStatsAnomalyBuilder().mergeFrom(value);
          } else {
            featureStatsAnomaly_ = value;
          }
        } else {
          featureStatsAnomalyBuilder_.mergeFrom(value);
        }
        if (featureStatsAnomaly_ != null) {
          bitField0_ |= 0x00000002;
          onChanged();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Output only. The stats and anomalies generated at specific timestamp.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly feature_stats_anomaly = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder clearFeatureStatsAnomaly() {
        bitField0_ = (bitField0_ & ~0x00000002);
        featureStatsAnomaly_ = null;
        if (featureStatsAnomalyBuilder_ != null) {
          featureStatsAnomalyBuilder_.dispose();
          featureStatsAnomalyBuilder_ = null;
        }
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Output only. The stats and anomalies generated at specific timestamp.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly feature_stats_anomaly = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public com.google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly.Builder
          getFeatureStatsAnomalyBuilder() {
        bitField0_ |= 0x00000002;
        onChanged();
        return getFeatureStatsAnomalyFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * Output only. The stats and anomalies generated at specific timestamp.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly feature_stats_anomaly = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public com.google.cloud.aiplatform.v1beta1.FeatureStatsAnomalyOrBuilder
          getFeatureStatsAnomalyOrBuilder() {
        if (featureStatsAnomalyBuilder_ != null) {
          return featureStatsAnomalyBuilder_.getMessageOrBuilder();
        } else {
          return featureStatsAnomaly_ == null
              ? com.google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly.getDefaultInstance()
              : featureStatsAnomaly_;
        }
      }

      /**
       *
       *
       * <pre>
       * Output only. The stats and anomalies generated at specific timestamp.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly feature_stats_anomaly = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly,
              com.google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly.Builder,
              com.google.cloud.aiplatform.v1beta1.FeatureStatsAnomalyOrBuilder>
          getFeatureStatsAnomalyFieldBuilder() {
        if (featureStatsAnomalyBuilder_ == null) {
          featureStatsAnomalyBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly,
                  com.google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly.Builder,
                  com.google.cloud.aiplatform.v1beta1.FeatureStatsAnomalyOrBuilder>(
                  getFeatureStatsAnomaly(), getParentForChildren(), isClean());
          featureStatsAnomaly_ = null;
        }
        return featureStatsAnomalyBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.Feature.MonitoringStatsAnomaly)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.Feature.MonitoringStatsAnomaly)
    private static final com.google.cloud.aiplatform.v1beta1.Feature.MonitoringStatsAnomaly
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.Feature.MonitoringStatsAnomaly();
    }

    public static com.google.cloud.aiplatform.v1beta1.Feature.MonitoringStatsAnomaly
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<MonitoringStatsAnomaly> PARSER =
        new com.google.protobuf.AbstractParser<MonitoringStatsAnomaly>() {
          @java.lang.Override
          public MonitoringStatsAnomaly parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<MonitoringStatsAnomaly> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<MonitoringStatsAnomaly> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.Feature.MonitoringStatsAnomaly
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";

  /**
   *
   *
   * <pre>
   * Immutable. Name of the Feature.
   * Format:
   * `projects/{project}/locations/{location}/featurestores/{featurestore}/entityTypes/{entity_type}/features/{feature}`
   * `projects/{project}/locations/{location}/featureGroups/{feature_group}/features/{feature}`
   *
   * The last part feature is assigned by the client. The feature can be up to
   * 64 characters long and can consist only of ASCII Latin letters A-Z and a-z,
   * underscore(_), and ASCII digits 0-9 starting with a letter. The value will
   * be unique given an entity type.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Immutable. Name of the Feature.
   * Format:
   * `projects/{project}/locations/{location}/featurestores/{featurestore}/entityTypes/{entity_type}/features/{feature}`
   * `projects/{project}/locations/{location}/featureGroups/{feature_group}/features/{feature}`
   *
   * The last part feature is assigned by the client. The feature can be up to
   * 64 characters long and can consist only of ASCII Latin letters A-Z and a-z,
   * underscore(_), and ASCII digits 0-9 starting with a letter. The value will
   * be unique given an entity type.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object description_ = "";

  /**
   *
   *
   * <pre>
   * Description of the Feature.
   * </pre>
   *
   * <code>string description = 2;</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Description of the Feature.
   * </pre>
   *
   * <code>string description = 2;</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int VALUE_TYPE_FIELD_NUMBER = 3;
  private int valueType_ = 0;

  /**
   *
   *
   * <pre>
   * Immutable. Only applicable for Vertex AI Feature Store (Legacy).
   * Type of Feature value.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.Feature.ValueType value_type = 3 [(.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return The enum numeric value on the wire for valueType.
   */
  @java.lang.Override
  public int getValueTypeValue() {
    return valueType_;
  }

  /**
   *
   *
   * <pre>
   * Immutable. Only applicable for Vertex AI Feature Store (Legacy).
   * Type of Feature value.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.Feature.ValueType value_type = 3 [(.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return The valueType.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.Feature.ValueType getValueType() {
    com.google.cloud.aiplatform.v1beta1.Feature.ValueType result =
        com.google.cloud.aiplatform.v1beta1.Feature.ValueType.forNumber(valueType_);
    return result == null
        ? com.google.cloud.aiplatform.v1beta1.Feature.ValueType.UNRECOGNIZED
        : result;
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 4;
  private com.google.protobuf.Timestamp createTime_;

  /**
   *
   *
   * <pre>
   * Output only. Only applicable for Vertex AI Feature Store (Legacy).
   * Timestamp when this EntityType was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * Output only. Only applicable for Vertex AI Feature Store (Legacy).
   * Timestamp when this EntityType was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  /**
   *
   *
   * <pre>
   * Output only. Only applicable for Vertex AI Feature Store (Legacy).
   * Timestamp when this EntityType was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int UPDATE_TIME_FIELD_NUMBER = 5;
  private com.google.protobuf.Timestamp updateTime_;

  /**
   *
   *
   * <pre>
   * Output only. Only applicable for Vertex AI Feature Store (Legacy).
   * Timestamp when this EntityType was most recently updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the updateTime field is set.
   */
  @java.lang.Override
  public boolean hasUpdateTime() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * Output only. Only applicable for Vertex AI Feature Store (Legacy).
   * Timestamp when this EntityType was most recently updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The updateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getUpdateTime() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }

  /**
   *
   *
   * <pre>
   * Output only. Only applicable for Vertex AI Feature Store (Legacy).
   * Timestamp when this EntityType was most recently updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }

  public static final int LABELS_FIELD_NUMBER = 6;

  private static final class LabelsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.aiplatform.v1beta1.FeatureProto
                .internal_static_google_cloud_aiplatform_v1beta1_Feature_LabelsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
    if (labels_ == null) {
      return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
    }
    return labels_;
  }

  public int getLabelsCount() {
    return internalGetLabels().getMap().size();
  }

  /**
   *
   *
   * <pre>
   * Optional. The labels with user-defined metadata to organize your Features.
   *
   * Label keys and values can be no longer than 64 characters
   * (Unicode codepoints), can only contain lowercase letters, numeric
   * characters, underscores and dashes. International characters are allowed.
   *
   * See https://goo.gl/xmQnxf for more information on and examples of labels.
   * No more than 64 user labels can be associated with one Feature (System
   * labels are excluded)."
   * System reserved label keys are prefixed with "aiplatform.googleapis.com/"
   * and are immutable.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public boolean containsLabels(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetLabels().getMap().containsKey(key);
  }

  /** Use {@link #getLabelsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getLabels() {
    return getLabelsMap();
  }

  /**
   *
   *
   * <pre>
   * Optional. The labels with user-defined metadata to organize your Features.
   *
   * Label keys and values can be no longer than 64 characters
   * (Unicode codepoints), can only contain lowercase letters, numeric
   * characters, underscores and dashes. International characters are allowed.
   *
   * See https://goo.gl/xmQnxf for more information on and examples of labels.
   * No more than 64 user labels can be associated with one Feature (System
   * labels are excluded)."
   * System reserved label keys are prefixed with "aiplatform.googleapis.com/"
   * and are immutable.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
    return internalGetLabels().getMap();
  }

  /**
   *
   *
   * <pre>
   * Optional. The labels with user-defined metadata to organize your Features.
   *
   * Label keys and values can be no longer than 64 characters
   * (Unicode codepoints), can only contain lowercase letters, numeric
   * characters, underscores and dashes. International characters are allowed.
   *
   * See https://goo.gl/xmQnxf for more information on and examples of labels.
   * No more than 64 user labels can be associated with one Feature (System
   * labels are excluded)."
   * System reserved label keys are prefixed with "aiplatform.googleapis.com/"
   * and are immutable.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getLabelsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }

  /**
   *
   *
   * <pre>
   * Optional. The labels with user-defined metadata to organize your Features.
   *
   * Label keys and values can be no longer than 64 characters
   * (Unicode codepoints), can only contain lowercase letters, numeric
   * characters, underscores and dashes. International characters are allowed.
   *
   * See https://goo.gl/xmQnxf for more information on and examples of labels.
   * No more than 64 user labels can be associated with one Feature (System
   * labels are excluded)."
   * System reserved label keys are prefixed with "aiplatform.googleapis.com/"
   * and are immutable.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public java.lang.String getLabelsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int ETAG_FIELD_NUMBER = 7;

  @SuppressWarnings("serial")
  private volatile java.lang.Object etag_ = "";

  /**
   *
   *
   * <pre>
   * Used to perform a consistent read-modify-write updates. If not set, a blind
   * "overwrite" update happens.
   * </pre>
   *
   * <code>string etag = 7;</code>
   *
   * @return The etag.
   */
  @java.lang.Override
  public java.lang.String getEtag() {
    java.lang.Object ref = etag_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      etag_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Used to perform a consistent read-modify-write updates. If not set, a blind
   * "overwrite" update happens.
   * </pre>
   *
   * <code>string etag = 7;</code>
   *
   * @return The bytes for etag.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getEtagBytes() {
    java.lang.Object ref = etag_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      etag_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int MONITORING_CONFIG_FIELD_NUMBER = 9;
  private com.google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig monitoringConfig_;

  /**
   *
   *
   * <pre>
   * Optional. Only applicable for Vertex AI Feature Store (Legacy).
   * Deprecated: The custom monitoring configuration for this Feature, if not
   * set, use the monitoring_config defined for the EntityType this Feature
   * belongs to.
   * Only Features with type
   * ([Feature.ValueType][google.cloud.aiplatform.v1beta1.Feature.ValueType])
   * BOOL, STRING, DOUBLE or INT64 can enable monitoring.
   *
   * If this is populated with
   * [FeaturestoreMonitoringConfig.disabled][] = true, snapshot analysis
   * monitoring is disabled; if
   * [FeaturestoreMonitoringConfig.monitoring_interval][] specified, snapshot
   * analysis monitoring is enabled. Otherwise, snapshot analysis monitoring
   * config is same as the EntityType's this Feature belongs to.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig monitoring_config = 9 [deprecated = true, (.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @deprecated google.cloud.aiplatform.v1beta1.Feature.monitoring_config is deprecated. See
   *     google/cloud/aiplatform/v1beta1/feature.proto;l=171
   * @return Whether the monitoringConfig field is set.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public boolean hasMonitoringConfig() {
    return ((bitField0_ & 0x00000004) != 0);
  }

  /**
   *
   *
   * <pre>
   * Optional. Only applicable for Vertex AI Feature Store (Legacy).
   * Deprecated: The custom monitoring configuration for this Feature, if not
   * set, use the monitoring_config defined for the EntityType this Feature
   * belongs to.
   * Only Features with type
   * ([Feature.ValueType][google.cloud.aiplatform.v1beta1.Feature.ValueType])
   * BOOL, STRING, DOUBLE or INT64 can enable monitoring.
   *
   * If this is populated with
   * [FeaturestoreMonitoringConfig.disabled][] = true, snapshot analysis
   * monitoring is disabled; if
   * [FeaturestoreMonitoringConfig.monitoring_interval][] specified, snapshot
   * analysis monitoring is enabled. Otherwise, snapshot analysis monitoring
   * config is same as the EntityType's this Feature belongs to.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig monitoring_config = 9 [deprecated = true, (.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @deprecated google.cloud.aiplatform.v1beta1.Feature.monitoring_config is deprecated. See
   *     google/cloud/aiplatform/v1beta1/feature.proto;l=171
   * @return The monitoringConfig.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public com.google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig getMonitoringConfig() {
    return monitoringConfig_ == null
        ? com.google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig.getDefaultInstance()
        : monitoringConfig_;
  }

  /**
   *
   *
   * <pre>
   * Optional. Only applicable for Vertex AI Feature Store (Legacy).
   * Deprecated: The custom monitoring configuration for this Feature, if not
   * set, use the monitoring_config defined for the EntityType this Feature
   * belongs to.
   * Only Features with type
   * ([Feature.ValueType][google.cloud.aiplatform.v1beta1.Feature.ValueType])
   * BOOL, STRING, DOUBLE or INT64 can enable monitoring.
   *
   * If this is populated with
   * [FeaturestoreMonitoringConfig.disabled][] = true, snapshot analysis
   * monitoring is disabled; if
   * [FeaturestoreMonitoringConfig.monitoring_interval][] specified, snapshot
   * analysis monitoring is enabled. Otherwise, snapshot analysis monitoring
   * config is same as the EntityType's this Feature belongs to.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig monitoring_config = 9 [deprecated = true, (.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  @java.lang.Deprecated
  public com.google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfigOrBuilder
      getMonitoringConfigOrBuilder() {
    return monitoringConfig_ == null
        ? com.google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig.getDefaultInstance()
        : monitoringConfig_;
  }

  public static final int DISABLE_MONITORING_FIELD_NUMBER = 12;
  private boolean disableMonitoring_ = false;

  /**
   *
   *
   * <pre>
   * Optional. Only applicable for Vertex AI Feature Store (Legacy).
   * If not set, use the monitoring_config defined for the EntityType this
   * Feature belongs to.
   * Only Features with type
   * ([Feature.ValueType][google.cloud.aiplatform.v1beta1.Feature.ValueType])
   * BOOL, STRING, DOUBLE or INT64 can enable monitoring.
   *
   * If set to true, all types of data monitoring are disabled despite the
   * config on EntityType.
   * </pre>
   *
   * <code>bool disable_monitoring = 12 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The disableMonitoring.
   */
  @java.lang.Override
  public boolean getDisableMonitoring() {
    return disableMonitoring_;
  }

  public static final int MONITORING_STATS_FIELD_NUMBER = 10;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly> monitoringStats_;

  /**
   *
   *
   * <pre>
   * Output only. Only applicable for Vertex AI Feature Store (Legacy).
   * A list of historical
   * [SnapshotAnalysis][google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig.SnapshotAnalysis]
   * stats requested by user, sorted by
   * [FeatureStatsAnomaly.start_time][google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly.start_time]
   * descending.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly monitoring_stats = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly>
      getMonitoringStatsList() {
    return monitoringStats_;
  }

  /**
   *
   *
   * <pre>
   * Output only. Only applicable for Vertex AI Feature Store (Legacy).
   * A list of historical
   * [SnapshotAnalysis][google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig.SnapshotAnalysis]
   * stats requested by user, sorted by
   * [FeatureStatsAnomaly.start_time][google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly.start_time]
   * descending.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly monitoring_stats = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.aiplatform.v1beta1.FeatureStatsAnomalyOrBuilder>
      getMonitoringStatsOrBuilderList() {
    return monitoringStats_;
  }

  /**
   *
   *
   * <pre>
   * Output only. Only applicable for Vertex AI Feature Store (Legacy).
   * A list of historical
   * [SnapshotAnalysis][google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig.SnapshotAnalysis]
   * stats requested by user, sorted by
   * [FeatureStatsAnomaly.start_time][google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly.start_time]
   * descending.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly monitoring_stats = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public int getMonitoringStatsCount() {
    return monitoringStats_.size();
  }

  /**
   *
   *
   * <pre>
   * Output only. Only applicable for Vertex AI Feature Store (Legacy).
   * A list of historical
   * [SnapshotAnalysis][google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig.SnapshotAnalysis]
   * stats requested by user, sorted by
   * [FeatureStatsAnomaly.start_time][google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly.start_time]
   * descending.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly monitoring_stats = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly getMonitoringStats(int index) {
    return monitoringStats_.get(index);
  }

  /**
   *
   *
   * <pre>
   * Output only. Only applicable for Vertex AI Feature Store (Legacy).
   * A list of historical
   * [SnapshotAnalysis][google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig.SnapshotAnalysis]
   * stats requested by user, sorted by
   * [FeatureStatsAnomaly.start_time][google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly.start_time]
   * descending.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly monitoring_stats = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.FeatureStatsAnomalyOrBuilder
      getMonitoringStatsOrBuilder(int index) {
    return monitoringStats_.get(index);
  }

  public static final int MONITORING_STATS_ANOMALIES_FIELD_NUMBER = 11;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.aiplatform.v1beta1.Feature.MonitoringStatsAnomaly>
      monitoringStatsAnomalies_;

  /**
   *
   *
   * <pre>
   * Output only. Only applicable for Vertex AI Feature Store (Legacy).
   * The list of historical stats and anomalies with specified objectives.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.Feature.MonitoringStatsAnomaly monitoring_stats_anomalies = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.aiplatform.v1beta1.Feature.MonitoringStatsAnomaly>
      getMonitoringStatsAnomaliesList() {
    return monitoringStatsAnomalies_;
  }

  /**
   *
   *
   * <pre>
   * Output only. Only applicable for Vertex AI Feature Store (Legacy).
   * The list of historical stats and anomalies with specified objectives.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.Feature.MonitoringStatsAnomaly monitoring_stats_anomalies = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends com.google.cloud.aiplatform.v1beta1.Feature.MonitoringStatsAnomalyOrBuilder>
      getMonitoringStatsAnomaliesOrBuilderList() {
    return monitoringStatsAnomalies_;
  }

  /**
   *
   *
   * <pre>
   * Output only. Only applicable for Vertex AI Feature Store (Legacy).
   * The list of historical stats and anomalies with specified objectives.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.Feature.MonitoringStatsAnomaly monitoring_stats_anomalies = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public int getMonitoringStatsAnomaliesCount() {
    return monitoringStatsAnomalies_.size();
  }

  /**
   *
   *
   * <pre>
   * Output only. Only applicable for Vertex AI Feature Store (Legacy).
   * The list of historical stats and anomalies with specified objectives.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.Feature.MonitoringStatsAnomaly monitoring_stats_anomalies = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.Feature.MonitoringStatsAnomaly
      getMonitoringStatsAnomalies(int index) {
    return monitoringStatsAnomalies_.get(index);
  }

  /**
   *
   *
   * <pre>
   * Output only. Only applicable for Vertex AI Feature Store (Legacy).
   * The list of historical stats and anomalies with specified objectives.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.Feature.MonitoringStatsAnomaly monitoring_stats_anomalies = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.Feature.MonitoringStatsAnomalyOrBuilder
      getMonitoringStatsAnomaliesOrBuilder(int index) {
    return monitoringStatsAnomalies_.get(index);
  }

  public static final int FEATURE_STATS_AND_ANOMALY_FIELD_NUMBER = 13;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.aiplatform.v1beta1.FeatureStatsAndAnomaly>
      featureStatsAndAnomaly_;

  /**
   *
   *
   * <pre>
   * Output only. Only applicable for Vertex AI Feature Store.
   * The list of historical stats and anomalies.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.FeatureStatsAndAnomaly feature_stats_and_anomaly = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.aiplatform.v1beta1.FeatureStatsAndAnomaly>
      getFeatureStatsAndAnomalyList() {
    return featureStatsAndAnomaly_;
  }

  /**
   *
   *
   * <pre>
   * Output only. Only applicable for Vertex AI Feature Store.
   * The list of historical stats and anomalies.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.FeatureStatsAndAnomaly feature_stats_and_anomaly = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends com.google.cloud.aiplatform.v1beta1.FeatureStatsAndAnomalyOrBuilder>
      getFeatureStatsAndAnomalyOrBuilderList() {
    return featureStatsAndAnomaly_;
  }

  /**
   *
   *
   * <pre>
   * Output only. Only applicable for Vertex AI Feature Store.
   * The list of historical stats and anomalies.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.FeatureStatsAndAnomaly feature_stats_and_anomaly = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public int getFeatureStatsAndAnomalyCount() {
    return featureStatsAndAnomaly_.size();
  }

  /**
   *
   *
   * <pre>
   * Output only. Only applicable for Vertex AI Feature Store.
   * The list of historical stats and anomalies.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.FeatureStatsAndAnomaly feature_stats_and_anomaly = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.FeatureStatsAndAnomaly getFeatureStatsAndAnomaly(
      int index) {
    return featureStatsAndAnomaly_.get(index);
  }

  /**
   *
   *
   * <pre>
   * Output only. Only applicable for Vertex AI Feature Store.
   * The list of historical stats and anomalies.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.FeatureStatsAndAnomaly feature_stats_and_anomaly = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.FeatureStatsAndAnomalyOrBuilder
      getFeatureStatsAndAnomalyOrBuilder(int index) {
    return featureStatsAndAnomaly_.get(index);
  }

  public static final int VERSION_COLUMN_NAME_FIELD_NUMBER = 106;

  @SuppressWarnings("serial")
  private volatile java.lang.Object versionColumnName_ = "";

  /**
   *
   *
   * <pre>
   * Only applicable for Vertex AI Feature Store.
   * The name of the BigQuery Table/View column hosting data for this version.
   * If no value is provided, will use feature_id.
   * </pre>
   *
   * <code>string version_column_name = 106;</code>
   *
   * @return The versionColumnName.
   */
  @java.lang.Override
  public java.lang.String getVersionColumnName() {
    java.lang.Object ref = versionColumnName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      versionColumnName_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Only applicable for Vertex AI Feature Store.
   * The name of the BigQuery Table/View column hosting data for this version.
   * If no value is provided, will use feature_id.
   * </pre>
   *
   * <code>string version_column_name = 106;</code>
   *
   * @return The bytes for versionColumnName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getVersionColumnNameBytes() {
    java.lang.Object ref = versionColumnName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      versionColumnName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int POINT_OF_CONTACT_FIELD_NUMBER = 107;

  @SuppressWarnings("serial")
  private volatile java.lang.Object pointOfContact_ = "";

  /**
   *
   *
   * <pre>
   * Entity responsible for maintaining this feature. Can be comma separated
   * list of email addresses or URIs.
   * </pre>
   *
   * <code>string point_of_contact = 107;</code>
   *
   * @return The pointOfContact.
   */
  @java.lang.Override
  public java.lang.String getPointOfContact() {
    java.lang.Object ref = pointOfContact_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      pointOfContact_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Entity responsible for maintaining this feature. Can be comma separated
   * list of email addresses or URIs.
   * </pre>
   *
   * <code>string point_of_contact = 107;</code>
   *
   * @return The bytes for pointOfContact.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPointOfContactBytes() {
    java.lang.Object ref = pointOfContact_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      pointOfContact_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, description_);
    }
    if (valueType_
        != com.google.cloud.aiplatform.v1beta1.Feature.ValueType.VALUE_TYPE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(3, valueType_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(4, getCreateTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(5, getUpdateTime());
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetLabels(), LabelsDefaultEntryHolder.defaultEntry, 6);
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(etag_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 7, etag_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(9, getMonitoringConfig());
    }
    for (int i = 0; i < monitoringStats_.size(); i++) {
      output.writeMessage(10, monitoringStats_.get(i));
    }
    for (int i = 0; i < monitoringStatsAnomalies_.size(); i++) {
      output.writeMessage(11, monitoringStatsAnomalies_.get(i));
    }
    if (disableMonitoring_ != false) {
      output.writeBool(12, disableMonitoring_);
    }
    for (int i = 0; i < featureStatsAndAnomaly_.size(); i++) {
      output.writeMessage(13, featureStatsAndAnomaly_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(versionColumnName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 106, versionColumnName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(pointOfContact_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 107, pointOfContact_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, description_);
    }
    if (valueType_
        != com.google.cloud.aiplatform.v1beta1.Feature.ValueType.VALUE_TYPE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(3, valueType_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getCreateTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getUpdateTime());
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetLabels().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
          LabelsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, labels__);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(etag_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(7, etag_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(9, getMonitoringConfig());
    }
    for (int i = 0; i < monitoringStats_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(10, monitoringStats_.get(i));
    }
    for (int i = 0; i < monitoringStatsAnomalies_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              11, monitoringStatsAnomalies_.get(i));
    }
    if (disableMonitoring_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(12, disableMonitoring_);
    }
    for (int i = 0; i < featureStatsAndAnomaly_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              13, featureStatsAndAnomaly_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(versionColumnName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(106, versionColumnName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(pointOfContact_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(107, pointOfContact_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.Feature)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1beta1.Feature other =
        (com.google.cloud.aiplatform.v1beta1.Feature) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getDescription().equals(other.getDescription())) return false;
    if (valueType_ != other.valueType_) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasUpdateTime() != other.hasUpdateTime()) return false;
    if (hasUpdateTime()) {
      if (!getUpdateTime().equals(other.getUpdateTime())) return false;
    }
    if (!internalGetLabels().equals(other.internalGetLabels())) return false;
    if (!getEtag().equals(other.getEtag())) return false;
    if (hasMonitoringConfig() != other.hasMonitoringConfig()) return false;
    if (hasMonitoringConfig()) {
      if (!getMonitoringConfig().equals(other.getMonitoringConfig())) return false;
    }
    if (getDisableMonitoring() != other.getDisableMonitoring()) return false;
    if (!getMonitoringStatsList().equals(other.getMonitoringStatsList())) return false;
    if (!getMonitoringStatsAnomaliesList().equals(other.getMonitoringStatsAnomaliesList()))
      return false;
    if (!getFeatureStatsAndAnomalyList().equals(other.getFeatureStatsAndAnomalyList()))
      return false;
    if (!getVersionColumnName().equals(other.getVersionColumnName())) return false;
    if (!getPointOfContact().equals(other.getPointOfContact())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
    hash = (53 * hash) + getDescription().hashCode();
    hash = (37 * hash) + VALUE_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + valueType_;
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasUpdateTime()) {
      hash = (37 * hash) + UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateTime().hashCode();
    }
    if (!internalGetLabels().getMap().isEmpty()) {
      hash = (37 * hash) + LABELS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetLabels().hashCode();
    }
    hash = (37 * hash) + ETAG_FIELD_NUMBER;
    hash = (53 * hash) + getEtag().hashCode();
    if (hasMonitoringConfig()) {
      hash = (37 * hash) + MONITORING_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getMonitoringConfig().hashCode();
    }
    hash = (37 * hash) + DISABLE_MONITORING_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getDisableMonitoring());
    if (getMonitoringStatsCount() > 0) {
      hash = (37 * hash) + MONITORING_STATS_FIELD_NUMBER;
      hash = (53 * hash) + getMonitoringStatsList().hashCode();
    }
    if (getMonitoringStatsAnomaliesCount() > 0) {
      hash = (37 * hash) + MONITORING_STATS_ANOMALIES_FIELD_NUMBER;
      hash = (53 * hash) + getMonitoringStatsAnomaliesList().hashCode();
    }
    if (getFeatureStatsAndAnomalyCount() > 0) {
      hash = (37 * hash) + FEATURE_STATS_AND_ANOMALY_FIELD_NUMBER;
      hash = (53 * hash) + getFeatureStatsAndAnomalyList().hashCode();
    }
    hash = (37 * hash) + VERSION_COLUMN_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getVersionColumnName().hashCode();
    hash = (37 * hash) + POINT_OF_CONTACT_FIELD_NUMBER;
    hash = (53 * hash) + getPointOfContact().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1beta1.Feature parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.Feature parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.Feature parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.Feature parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.Feature parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.Feature parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.Feature parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.Feature parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.Feature parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.Feature parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.Feature parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.Feature parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.aiplatform.v1beta1.Feature prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Feature Metadata information.
   * For example, color is a feature that describes an apple.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.Feature}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.Feature)
      com.google.cloud.aiplatform.v1beta1.FeatureOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.FeatureProto
          .internal_static_google_cloud_aiplatform_v1beta1_Feature_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 6:
          return internalGetLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
        int number) {
      switch (number) {
        case 6:
          return internalGetMutableLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.FeatureProto
          .internal_static_google_cloud_aiplatform_v1beta1_Feature_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.Feature.class,
              com.google.cloud.aiplatform.v1beta1.Feature.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1beta1.Feature.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getCreateTimeFieldBuilder();
        getUpdateTimeFieldBuilder();
        getMonitoringConfigFieldBuilder();
        getMonitoringStatsFieldBuilder();
        getMonitoringStatsAnomaliesFieldBuilder();
        getFeatureStatsAndAnomalyFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      description_ = "";
      valueType_ = 0;
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      internalGetMutableLabels().clear();
      etag_ = "";
      monitoringConfig_ = null;
      if (monitoringConfigBuilder_ != null) {
        monitoringConfigBuilder_.dispose();
        monitoringConfigBuilder_ = null;
      }
      disableMonitoring_ = false;
      if (monitoringStatsBuilder_ == null) {
        monitoringStats_ = java.util.Collections.emptyList();
      } else {
        monitoringStats_ = null;
        monitoringStatsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000200);
      if (monitoringStatsAnomaliesBuilder_ == null) {
        monitoringStatsAnomalies_ = java.util.Collections.emptyList();
      } else {
        monitoringStatsAnomalies_ = null;
        monitoringStatsAnomaliesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000400);
      if (featureStatsAndAnomalyBuilder_ == null) {
        featureStatsAndAnomaly_ = java.util.Collections.emptyList();
      } else {
        featureStatsAndAnomaly_ = null;
        featureStatsAndAnomalyBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000800);
      versionColumnName_ = "";
      pointOfContact_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1beta1.FeatureProto
          .internal_static_google_cloud_aiplatform_v1beta1_Feature_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.Feature getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1beta1.Feature.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.Feature build() {
      com.google.cloud.aiplatform.v1beta1.Feature result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.Feature buildPartial() {
      com.google.cloud.aiplatform.v1beta1.Feature result =
          new com.google.cloud.aiplatform.v1beta1.Feature(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.aiplatform.v1beta1.Feature result) {
      if (monitoringStatsBuilder_ == null) {
        if (((bitField0_ & 0x00000200) != 0)) {
          monitoringStats_ = java.util.Collections.unmodifiableList(monitoringStats_);
          bitField0_ = (bitField0_ & ~0x00000200);
        }
        result.monitoringStats_ = monitoringStats_;
      } else {
        result.monitoringStats_ = monitoringStatsBuilder_.build();
      }
      if (monitoringStatsAnomaliesBuilder_ == null) {
        if (((bitField0_ & 0x00000400) != 0)) {
          monitoringStatsAnomalies_ =
              java.util.Collections.unmodifiableList(monitoringStatsAnomalies_);
          bitField0_ = (bitField0_ & ~0x00000400);
        }
        result.monitoringStatsAnomalies_ = monitoringStatsAnomalies_;
      } else {
        result.monitoringStatsAnomalies_ = monitoringStatsAnomaliesBuilder_.build();
      }
      if (featureStatsAndAnomalyBuilder_ == null) {
        if (((bitField0_ & 0x00000800) != 0)) {
          featureStatsAndAnomaly_ = java.util.Collections.unmodifiableList(featureStatsAndAnomaly_);
          bitField0_ = (bitField0_ & ~0x00000800);
        }
        result.featureStatsAndAnomaly_ = featureStatsAndAnomaly_;
      } else {
        result.featureStatsAndAnomaly_ = featureStatsAndAnomalyBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.aiplatform.v1beta1.Feature result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.description_ = description_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.valueType_ = valueType_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.updateTime_ = updateTimeBuilder_ == null ? updateTime_ : updateTimeBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.labels_ = internalGetLabels();
        result.labels_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.etag_ = etag_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.monitoringConfig_ =
            monitoringConfigBuilder_ == null ? monitoringConfig_ : monitoringConfigBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.disableMonitoring_ = disableMonitoring_;
      }
      if (((from_bitField0_ & 0x00001000) != 0)) {
        result.versionColumnName_ = versionColumnName_;
      }
      if (((from_bitField0_ & 0x00002000) != 0)) {
        result.pointOfContact_ = pointOfContact_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1beta1.Feature) {
        return mergeFrom((com.google.cloud.aiplatform.v1beta1.Feature) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1beta1.Feature other) {
      if (other == com.google.cloud.aiplatform.v1beta1.Feature.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getDescription().isEmpty()) {
        description_ = other.description_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.valueType_ != 0) {
        setValueTypeValue(other.getValueTypeValue());
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasUpdateTime()) {
        mergeUpdateTime(other.getUpdateTime());
      }
      internalGetMutableLabels().mergeFrom(other.internalGetLabels());
      bitField0_ |= 0x00000020;
      if (!other.getEtag().isEmpty()) {
        etag_ = other.etag_;
        bitField0_ |= 0x00000040;
        onChanged();
      }
      if (other.hasMonitoringConfig()) {
        mergeMonitoringConfig(other.getMonitoringConfig());
      }
      if (other.getDisableMonitoring() != false) {
        setDisableMonitoring(other.getDisableMonitoring());
      }
      if (monitoringStatsBuilder_ == null) {
        if (!other.monitoringStats_.isEmpty()) {
          if (monitoringStats_.isEmpty()) {
            monitoringStats_ = other.monitoringStats_;
            bitField0_ = (bitField0_ & ~0x00000200);
          } else {
            ensureMonitoringStatsIsMutable();
            monitoringStats_.addAll(other.monitoringStats_);
          }
          onChanged();
        }
      } else {
        if (!other.monitoringStats_.isEmpty()) {
          if (monitoringStatsBuilder_.isEmpty()) {
            monitoringStatsBuilder_.dispose();
            monitoringStatsBuilder_ = null;
            monitoringStats_ = other.monitoringStats_;
            bitField0_ = (bitField0_ & ~0x00000200);
            monitoringStatsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getMonitoringStatsFieldBuilder()
                    : null;
          } else {
            monitoringStatsBuilder_.addAllMessages(other.monitoringStats_);
          }
        }
      }
      if (monitoringStatsAnomaliesBuilder_ == null) {
        if (!other.monitoringStatsAnomalies_.isEmpty()) {
          if (monitoringStatsAnomalies_.isEmpty()) {
            monitoringStatsAnomalies_ = other.monitoringStatsAnomalies_;
            bitField0_ = (bitField0_ & ~0x00000400);
          } else {
            ensureMonitoringStatsAnomaliesIsMutable();
            monitoringStatsAnomalies_.addAll(other.monitoringStatsAnomalies_);
          }
          onChanged();
        }
      } else {
        if (!other.monitoringStatsAnomalies_.isEmpty()) {
          if (monitoringStatsAnomaliesBuilder_.isEmpty()) {
            monitoringStatsAnomaliesBuilder_.dispose();
            monitoringStatsAnomaliesBuilder_ = null;
            monitoringStatsAnomalies_ = other.monitoringStatsAnomalies_;
            bitField0_ = (bitField0_ & ~0x00000400);
            monitoringStatsAnomaliesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getMonitoringStatsAnomaliesFieldBuilder()
                    : null;
          } else {
            monitoringStatsAnomaliesBuilder_.addAllMessages(other.monitoringStatsAnomalies_);
          }
        }
      }
      if (featureStatsAndAnomalyBuilder_ == null) {
        if (!other.featureStatsAndAnomaly_.isEmpty()) {
          if (featureStatsAndAnomaly_.isEmpty()) {
            featureStatsAndAnomaly_ = other.featureStatsAndAnomaly_;
            bitField0_ = (bitField0_ & ~0x00000800);
          } else {
            ensureFeatureStatsAndAnomalyIsMutable();
            featureStatsAndAnomaly_.addAll(other.featureStatsAndAnomaly_);
          }
          onChanged();
        }
      } else {
        if (!other.featureStatsAndAnomaly_.isEmpty()) {
          if (featureStatsAndAnomalyBuilder_.isEmpty()) {
            featureStatsAndAnomalyBuilder_.dispose();
            featureStatsAndAnomalyBuilder_ = null;
            featureStatsAndAnomaly_ = other.featureStatsAndAnomaly_;
            bitField0_ = (bitField0_ & ~0x00000800);
            featureStatsAndAnomalyBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getFeatureStatsAndAnomalyFieldBuilder()
                    : null;
          } else {
            featureStatsAndAnomalyBuilder_.addAllMessages(other.featureStatsAndAnomaly_);
          }
        }
      }
      if (!other.getVersionColumnName().isEmpty()) {
        versionColumnName_ = other.versionColumnName_;
        bitField0_ |= 0x00001000;
        onChanged();
      }
      if (!other.getPointOfContact().isEmpty()) {
        pointOfContact_ = other.pointOfContact_;
        bitField0_ |= 0x00002000;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                description_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 24:
              {
                valueType_ = input.readEnum();
                bitField0_ |= 0x00000004;
                break;
              } // case 24
            case 34:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(getUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 50:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
                    input.readMessage(
                        LabelsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableLabels()
                    .getMutableMap()
                    .put(labels__.getKey(), labels__.getValue());
                bitField0_ |= 0x00000020;
                break;
              } // case 50
            case 58:
              {
                etag_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000040;
                break;
              } // case 58
            case 74:
              {
                input.readMessage(
                    getMonitoringConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000080;
                break;
              } // case 74
            case 82:
              {
                com.google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly m =
                    input.readMessage(
                        com.google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly.parser(),
                        extensionRegistry);
                if (monitoringStatsBuilder_ == null) {
                  ensureMonitoringStatsIsMutable();
                  monitoringStats_.add(m);
                } else {
                  monitoringStatsBuilder_.addMessage(m);
                }
                break;
              } // case 82
            case 90:
              {
                com.google.cloud.aiplatform.v1beta1.Feature.MonitoringStatsAnomaly m =
                    input.readMessage(
                        com.google.cloud.aiplatform.v1beta1.Feature.MonitoringStatsAnomaly.parser(),
                        extensionRegistry);
                if (monitoringStatsAnomaliesBuilder_ == null) {
                  ensureMonitoringStatsAnomaliesIsMutable();
                  monitoringStatsAnomalies_.add(m);
                } else {
                  monitoringStatsAnomaliesBuilder_.addMessage(m);
                }
                break;
              } // case 90
            case 96:
              {
                disableMonitoring_ = input.readBool();
                bitField0_ |= 0x00000100;
                break;
              } // case 96
            case 106:
              {
                com.google.cloud.aiplatform.v1beta1.FeatureStatsAndAnomaly m =
                    input.readMessage(
                        com.google.cloud.aiplatform.v1beta1.FeatureStatsAndAnomaly.parser(),
                        extensionRegistry);
                if (featureStatsAndAnomalyBuilder_ == null) {
                  ensureFeatureStatsAndAnomalyIsMutable();
                  featureStatsAndAnomaly_.add(m);
                } else {
                  featureStatsAndAnomalyBuilder_.addMessage(m);
                }
                break;
              } // case 106
            case 850:
              {
                versionColumnName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00001000;
                break;
              } // case 850
            case 858:
              {
                pointOfContact_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00002000;
                break;
              } // case 858
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";

    /**
     *
     *
     * <pre>
     * Immutable. Name of the Feature.
     * Format:
     * `projects/{project}/locations/{location}/featurestores/{featurestore}/entityTypes/{entity_type}/features/{feature}`
     * `projects/{project}/locations/{location}/featureGroups/{feature_group}/features/{feature}`
     *
     * The last part feature is assigned by the client. The feature can be up to
     * 64 characters long and can consist only of ASCII Latin letters A-Z and a-z,
     * underscore(_), and ASCII digits 0-9 starting with a letter. The value will
     * be unique given an entity type.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Immutable. Name of the Feature.
     * Format:
     * `projects/{project}/locations/{location}/featurestores/{featurestore}/entityTypes/{entity_type}/features/{feature}`
     * `projects/{project}/locations/{location}/featureGroups/{feature_group}/features/{feature}`
     *
     * The last part feature is assigned by the client. The feature can be up to
     * 64 characters long and can consist only of ASCII Latin letters A-Z and a-z,
     * underscore(_), and ASCII digits 0-9 starting with a letter. The value will
     * be unique given an entity type.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Immutable. Name of the Feature.
     * Format:
     * `projects/{project}/locations/{location}/featurestores/{featurestore}/entityTypes/{entity_type}/features/{feature}`
     * `projects/{project}/locations/{location}/featureGroups/{feature_group}/features/{feature}`
     *
     * The last part feature is assigned by the client. The feature can be up to
     * 64 characters long and can consist only of ASCII Latin letters A-Z and a-z,
     * underscore(_), and ASCII digits 0-9 starting with a letter. The value will
     * be unique given an entity type.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Immutable. Name of the Feature.
     * Format:
     * `projects/{project}/locations/{location}/featurestores/{featurestore}/entityTypes/{entity_type}/features/{feature}`
     * `projects/{project}/locations/{location}/featureGroups/{feature_group}/features/{feature}`
     *
     * The last part feature is assigned by the client. The feature can be up to
     * 64 characters long and can consist only of ASCII Latin letters A-Z and a-z,
     * underscore(_), and ASCII digits 0-9 starting with a letter. The value will
     * be unique given an entity type.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Immutable. Name of the Feature.
     * Format:
     * `projects/{project}/locations/{location}/featurestores/{featurestore}/entityTypes/{entity_type}/features/{feature}`
     * `projects/{project}/locations/{location}/featureGroups/{feature_group}/features/{feature}`
     *
     * The last part feature is assigned by the client. The feature can be up to
     * 64 characters long and can consist only of ASCII Latin letters A-Z and a-z,
     * underscore(_), and ASCII digits 0-9 starting with a letter. The value will
     * be unique given an entity type.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object description_ = "";

    /**
     *
     *
     * <pre>
     * Description of the Feature.
     * </pre>
     *
     * <code>string description = 2;</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Description of the Feature.
     * </pre>
     *
     * <code>string description = 2;</code>
     *
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Description of the Feature.
     * </pre>
     *
     * <code>string description = 2;</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      description_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Description of the Feature.
     * </pre>
     *
     * <code>string description = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {
      description_ = getDefaultInstance().getDescription();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Description of the Feature.
     * </pre>
     *
     * <code>string description = 2;</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      description_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private int valueType_ = 0;

    /**
     *
     *
     * <pre>
     * Immutable. Only applicable for Vertex AI Feature Store (Legacy).
     * Type of Feature value.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.Feature.ValueType value_type = 3 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return The enum numeric value on the wire for valueType.
     */
    @java.lang.Override
    public int getValueTypeValue() {
      return valueType_;
    }

    /**
     *
     *
     * <pre>
     * Immutable. Only applicable for Vertex AI Feature Store (Legacy).
     * Type of Feature value.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.Feature.ValueType value_type = 3 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @param value The enum numeric value on the wire for valueType to set.
     * @return This builder for chaining.
     */
    public Builder setValueTypeValue(int value) {
      valueType_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Immutable. Only applicable for Vertex AI Feature Store (Legacy).
     * Type of Feature value.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.Feature.ValueType value_type = 3 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return The valueType.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.Feature.ValueType getValueType() {
      com.google.cloud.aiplatform.v1beta1.Feature.ValueType result =
          com.google.cloud.aiplatform.v1beta1.Feature.ValueType.forNumber(valueType_);
      return result == null
          ? com.google.cloud.aiplatform.v1beta1.Feature.ValueType.UNRECOGNIZED
          : result;
    }

    /**
     *
     *
     * <pre>
     * Immutable. Only applicable for Vertex AI Feature Store (Legacy).
     * Type of Feature value.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.Feature.ValueType value_type = 3 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @param value The valueType to set.
     * @return This builder for chaining.
     */
    public Builder setValueType(com.google.cloud.aiplatform.v1beta1.Feature.ValueType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000004;
      valueType_ = value.getNumber();
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Immutable. Only applicable for Vertex AI Feature Store (Legacy).
     * Type of Feature value.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.Feature.ValueType value_type = 3 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearValueType() {
      bitField0_ = (bitField0_ & ~0x00000004);
      valueType_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. Only applicable for Vertex AI Feature Store (Legacy).
     * Timestamp when this EntityType was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000008) != 0);
    }

    /**
     *
     *
     * <pre>
     * Output only. Only applicable for Vertex AI Feature Store (Legacy).
     * Timestamp when this EntityType was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Only applicable for Vertex AI Feature Store (Legacy).
     * Timestamp when this EntityType was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Only applicable for Vertex AI Feature Store (Legacy).
     * Timestamp when this EntityType was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Only applicable for Vertex AI Feature Store (Legacy).
     * Timestamp when this EntityType was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      if (createTime_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Only applicable for Vertex AI Feature Store (Legacy).
     * Timestamp when this EntityType was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000008);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Only applicable for Vertex AI Feature Store (Legacy).
     * Timestamp when this EntityType was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Output only. Only applicable for Vertex AI Feature Store (Legacy).
     * Timestamp when this EntityType was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Only applicable for Vertex AI Feature Store (Legacy).
     * Timestamp when this EntityType was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.Timestamp updateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        updateTimeBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. Only applicable for Vertex AI Feature Store (Legacy).
     * Timestamp when this EntityType was most recently updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the updateTime field is set.
     */
    public boolean hasUpdateTime() {
      return ((bitField0_ & 0x00000010) != 0);
    }

    /**
     *
     *
     * <pre>
     * Output only. Only applicable for Vertex AI Feature Store (Legacy).
     * Timestamp when this EntityType was most recently updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The updateTime.
     */
    public com.google.protobuf.Timestamp getUpdateTime() {
      if (updateTimeBuilder_ == null) {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      } else {
        return updateTimeBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Only applicable for Vertex AI Feature Store (Legacy).
     * Timestamp when this EntityType was most recently updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateTime_ = value;
      } else {
        updateTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Only applicable for Vertex AI Feature Store (Legacy).
     * Timestamp when this EntityType was most recently updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (updateTimeBuilder_ == null) {
        updateTime_ = builderForValue.build();
      } else {
        updateTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Only applicable for Vertex AI Feature Store (Legacy).
     * Timestamp when this EntityType was most recently updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && updateTime_ != null
            && updateTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getUpdateTimeBuilder().mergeFrom(value);
        } else {
          updateTime_ = value;
        }
      } else {
        updateTimeBuilder_.mergeFrom(value);
      }
      if (updateTime_ != null) {
        bitField0_ |= 0x00000010;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Only applicable for Vertex AI Feature Store (Legacy).
     * Timestamp when this EntityType was most recently updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearUpdateTime() {
      bitField0_ = (bitField0_ & ~0x00000010);
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Only applicable for Vertex AI Feature Store (Legacy).
     * Timestamp when this EntityType was most recently updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getUpdateTimeBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getUpdateTimeFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Output only. Only applicable for Vertex AI Feature Store (Legacy).
     * Timestamp when this EntityType was most recently updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
      if (updateTimeBuilder_ != null) {
        return updateTimeBuilder_.getMessageOrBuilder();
      } else {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Only applicable for Vertex AI Feature Store (Legacy).
     * Timestamp when this EntityType was most recently updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getUpdateTimeFieldBuilder() {
      if (updateTimeBuilder_ == null) {
        updateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getUpdateTime(), getParentForChildren(), isClean());
        updateTime_ = null;
      }
      return updateTimeBuilder_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
      if (labels_ == null) {
        return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      return labels_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableLabels() {
      if (labels_ == null) {
        labels_ = com.google.protobuf.MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      if (!labels_.isMutable()) {
        labels_ = labels_.copy();
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return labels_;
    }

    public int getLabelsCount() {
      return internalGetLabels().getMap().size();
    }

    /**
     *
     *
     * <pre>
     * Optional. The labels with user-defined metadata to organize your Features.
     *
     * Label keys and values can be no longer than 64 characters
     * (Unicode codepoints), can only contain lowercase letters, numeric
     * characters, underscores and dashes. International characters are allowed.
     *
     * See https://goo.gl/xmQnxf for more information on and examples of labels.
     * No more than 64 user labels can be associated with one Feature (System
     * labels are excluded)."
     * System reserved label keys are prefixed with "aiplatform.googleapis.com/"
     * and are immutable.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    @java.lang.Override
    public boolean containsLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetLabels().getMap().containsKey(key);
    }

    /** Use {@link #getLabelsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getLabels() {
      return getLabelsMap();
    }

    /**
     *
     *
     * <pre>
     * Optional. The labels with user-defined metadata to organize your Features.
     *
     * Label keys and values can be no longer than 64 characters
     * (Unicode codepoints), can only contain lowercase letters, numeric
     * characters, underscores and dashes. International characters are allowed.
     *
     * See https://goo.gl/xmQnxf for more information on and examples of labels.
     * No more than 64 user labels can be associated with one Feature (System
     * labels are excluded)."
     * System reserved label keys are prefixed with "aiplatform.googleapis.com/"
     * and are immutable.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
      return internalGetLabels().getMap();
    }

    /**
     *
     *
     * <pre>
     * Optional. The labels with user-defined metadata to organize your Features.
     *
     * Label keys and values can be no longer than 64 characters
     * (Unicode codepoints), can only contain lowercase letters, numeric
     * characters, underscores and dashes. International characters are allowed.
     *
     * See https://goo.gl/xmQnxf for more information on and examples of labels.
     * No more than 64 user labels can be associated with one Feature (System
     * labels are excluded)."
     * System reserved label keys are prefixed with "aiplatform.googleapis.com/"
     * and are immutable.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getLabelsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }

    /**
     *
     *
     * <pre>
     * Optional. The labels with user-defined metadata to organize your Features.
     *
     * Label keys and values can be no longer than 64 characters
     * (Unicode codepoints), can only contain lowercase letters, numeric
     * characters, underscores and dashes. International characters are allowed.
     *
     * See https://goo.gl/xmQnxf for more information on and examples of labels.
     * No more than 64 user labels can be associated with one Feature (System
     * labels are excluded)."
     * System reserved label keys are prefixed with "aiplatform.googleapis.com/"
     * and are immutable.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearLabels() {
      bitField0_ = (bitField0_ & ~0x00000020);
      internalGetMutableLabels().getMutableMap().clear();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The labels with user-defined metadata to organize your Features.
     *
     * Label keys and values can be no longer than 64 characters
     * (Unicode codepoints), can only contain lowercase letters, numeric
     * characters, underscores and dashes. International characters are allowed.
     *
     * See https://goo.gl/xmQnxf for more information on and examples of labels.
     * No more than 64 user labels can be associated with one Feature (System
     * labels are excluded)."
     * System reserved label keys are prefixed with "aiplatform.googleapis.com/"
     * and are immutable.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public Builder removeLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableLabels().getMutableMap().remove(key);
      return this;
    }

    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableLabels() {
      bitField0_ |= 0x00000020;
      return internalGetMutableLabels().getMutableMap();
    }

    /**
     *
     *
     * <pre>
     * Optional. The labels with user-defined metadata to organize your Features.
     *
     * Label keys and values can be no longer than 64 characters
     * (Unicode codepoints), can only contain lowercase letters, numeric
     * characters, underscores and dashes. International characters are allowed.
     *
     * See https://goo.gl/xmQnxf for more information on and examples of labels.
     * No more than 64 user labels can be associated with one Feature (System
     * labels are excluded)."
     * System reserved label keys are prefixed with "aiplatform.googleapis.com/"
     * and are immutable.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public Builder putLabels(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableLabels().getMutableMap().put(key, value);
      bitField0_ |= 0x00000020;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The labels with user-defined metadata to organize your Features.
     *
     * Label keys and values can be no longer than 64 characters
     * (Unicode codepoints), can only contain lowercase letters, numeric
     * characters, underscores and dashes. International characters are allowed.
     *
     * See https://goo.gl/xmQnxf for more information on and examples of labels.
     * No more than 64 user labels can be associated with one Feature (System
     * labels are excluded)."
     * System reserved label keys are prefixed with "aiplatform.googleapis.com/"
     * and are immutable.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public Builder putAllLabels(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableLabels().getMutableMap().putAll(values);
      bitField0_ |= 0x00000020;
      return this;
    }

    private java.lang.Object etag_ = "";

    /**
     *
     *
     * <pre>
     * Used to perform a consistent read-modify-write updates. If not set, a blind
     * "overwrite" update happens.
     * </pre>
     *
     * <code>string etag = 7;</code>
     *
     * @return The etag.
     */
    public java.lang.String getEtag() {
      java.lang.Object ref = etag_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        etag_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Used to perform a consistent read-modify-write updates. If not set, a blind
     * "overwrite" update happens.
     * </pre>
     *
     * <code>string etag = 7;</code>
     *
     * @return The bytes for etag.
     */
    public com.google.protobuf.ByteString getEtagBytes() {
      java.lang.Object ref = etag_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        etag_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Used to perform a consistent read-modify-write updates. If not set, a blind
     * "overwrite" update happens.
     * </pre>
     *
     * <code>string etag = 7;</code>
     *
     * @param value The etag to set.
     * @return This builder for chaining.
     */
    public Builder setEtag(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      etag_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Used to perform a consistent read-modify-write updates. If not set, a blind
     * "overwrite" update happens.
     * </pre>
     *
     * <code>string etag = 7;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEtag() {
      etag_ = getDefaultInstance().getEtag();
      bitField0_ = (bitField0_ & ~0x00000040);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Used to perform a consistent read-modify-write updates. If not set, a blind
     * "overwrite" update happens.
     * </pre>
     *
     * <code>string etag = 7;</code>
     *
     * @param value The bytes for etag to set.
     * @return This builder for chaining.
     */
    public Builder setEtagBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      etag_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    private com.google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig monitoringConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig,
            com.google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig.Builder,
            com.google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfigOrBuilder>
        monitoringConfigBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. Only applicable for Vertex AI Feature Store (Legacy).
     * Deprecated: The custom monitoring configuration for this Feature, if not
     * set, use the monitoring_config defined for the EntityType this Feature
     * belongs to.
     * Only Features with type
     * ([Feature.ValueType][google.cloud.aiplatform.v1beta1.Feature.ValueType])
     * BOOL, STRING, DOUBLE or INT64 can enable monitoring.
     *
     * If this is populated with
     * [FeaturestoreMonitoringConfig.disabled][] = true, snapshot analysis
     * monitoring is disabled; if
     * [FeaturestoreMonitoringConfig.monitoring_interval][] specified, snapshot
     * analysis monitoring is enabled. Otherwise, snapshot analysis monitoring
     * config is same as the EntityType's this Feature belongs to.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig monitoring_config = 9 [deprecated = true, (.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @deprecated google.cloud.aiplatform.v1beta1.Feature.monitoring_config is deprecated. See
     *     google/cloud/aiplatform/v1beta1/feature.proto;l=171
     * @return Whether the monitoringConfig field is set.
     */
    @java.lang.Deprecated
    public boolean hasMonitoringConfig() {
      return ((bitField0_ & 0x00000080) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. Only applicable for Vertex AI Feature Store (Legacy).
     * Deprecated: The custom monitoring configuration for this Feature, if not
     * set, use the monitoring_config defined for the EntityType this Feature
     * belongs to.
     * Only Features with type
     * ([Feature.ValueType][google.cloud.aiplatform.v1beta1.Feature.ValueType])
     * BOOL, STRING, DOUBLE or INT64 can enable monitoring.
     *
     * If this is populated with
     * [FeaturestoreMonitoringConfig.disabled][] = true, snapshot analysis
     * monitoring is disabled; if
     * [FeaturestoreMonitoringConfig.monitoring_interval][] specified, snapshot
     * analysis monitoring is enabled. Otherwise, snapshot analysis monitoring
     * config is same as the EntityType's this Feature belongs to.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig monitoring_config = 9 [deprecated = true, (.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @deprecated google.cloud.aiplatform.v1beta1.Feature.monitoring_config is deprecated. See
     *     google/cloud/aiplatform/v1beta1/feature.proto;l=171
     * @return The monitoringConfig.
     */
    @java.lang.Deprecated
    public com.google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig getMonitoringConfig() {
      if (monitoringConfigBuilder_ == null) {
        return monitoringConfig_ == null
            ? com.google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig.getDefaultInstance()
            : monitoringConfig_;
      } else {
        return monitoringConfigBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Only applicable for Vertex AI Feature Store (Legacy).
     * Deprecated: The custom monitoring configuration for this Feature, if not
     * set, use the monitoring_config defined for the EntityType this Feature
     * belongs to.
     * Only Features with type
     * ([Feature.ValueType][google.cloud.aiplatform.v1beta1.Feature.ValueType])
     * BOOL, STRING, DOUBLE or INT64 can enable monitoring.
     *
     * If this is populated with
     * [FeaturestoreMonitoringConfig.disabled][] = true, snapshot analysis
     * monitoring is disabled; if
     * [FeaturestoreMonitoringConfig.monitoring_interval][] specified, snapshot
     * analysis monitoring is enabled. Otherwise, snapshot analysis monitoring
     * config is same as the EntityType's this Feature belongs to.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig monitoring_config = 9 [deprecated = true, (.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Deprecated
    public Builder setMonitoringConfig(
        com.google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig value) {
      if (monitoringConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        monitoringConfig_ = value;
      } else {
        monitoringConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Only applicable for Vertex AI Feature Store (Legacy).
     * Deprecated: The custom monitoring configuration for this Feature, if not
     * set, use the monitoring_config defined for the EntityType this Feature
     * belongs to.
     * Only Features with type
     * ([Feature.ValueType][google.cloud.aiplatform.v1beta1.Feature.ValueType])
     * BOOL, STRING, DOUBLE or INT64 can enable monitoring.
     *
     * If this is populated with
     * [FeaturestoreMonitoringConfig.disabled][] = true, snapshot analysis
     * monitoring is disabled; if
     * [FeaturestoreMonitoringConfig.monitoring_interval][] specified, snapshot
     * analysis monitoring is enabled. Otherwise, snapshot analysis monitoring
     * config is same as the EntityType's this Feature belongs to.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig monitoring_config = 9 [deprecated = true, (.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Deprecated
    public Builder setMonitoringConfig(
        com.google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig.Builder builderForValue) {
      if (monitoringConfigBuilder_ == null) {
        monitoringConfig_ = builderForValue.build();
      } else {
        monitoringConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Only applicable for Vertex AI Feature Store (Legacy).
     * Deprecated: The custom monitoring configuration for this Feature, if not
     * set, use the monitoring_config defined for the EntityType this Feature
     * belongs to.
     * Only Features with type
     * ([Feature.ValueType][google.cloud.aiplatform.v1beta1.Feature.ValueType])
     * BOOL, STRING, DOUBLE or INT64 can enable monitoring.
     *
     * If this is populated with
     * [FeaturestoreMonitoringConfig.disabled][] = true, snapshot analysis
     * monitoring is disabled; if
     * [FeaturestoreMonitoringConfig.monitoring_interval][] specified, snapshot
     * analysis monitoring is enabled. Otherwise, snapshot analysis monitoring
     * config is same as the EntityType's this Feature belongs to.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig monitoring_config = 9 [deprecated = true, (.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Deprecated
    public Builder mergeMonitoringConfig(
        com.google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig value) {
      if (monitoringConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000080) != 0)
            && monitoringConfig_ != null
            && monitoringConfig_
                != com.google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig
                    .getDefaultInstance()) {
          getMonitoringConfigBuilder().mergeFrom(value);
        } else {
          monitoringConfig_ = value;
        }
      } else {
        monitoringConfigBuilder_.mergeFrom(value);
      }
      if (monitoringConfig_ != null) {
        bitField0_ |= 0x00000080;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Only applicable for Vertex AI Feature Store (Legacy).
     * Deprecated: The custom monitoring configuration for this Feature, if not
     * set, use the monitoring_config defined for the EntityType this Feature
     * belongs to.
     * Only Features with type
     * ([Feature.ValueType][google.cloud.aiplatform.v1beta1.Feature.ValueType])
     * BOOL, STRING, DOUBLE or INT64 can enable monitoring.
     *
     * If this is populated with
     * [FeaturestoreMonitoringConfig.disabled][] = true, snapshot analysis
     * monitoring is disabled; if
     * [FeaturestoreMonitoringConfig.monitoring_interval][] specified, snapshot
     * analysis monitoring is enabled. Otherwise, snapshot analysis monitoring
     * config is same as the EntityType's this Feature belongs to.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig monitoring_config = 9 [deprecated = true, (.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Deprecated
    public Builder clearMonitoringConfig() {
      bitField0_ = (bitField0_ & ~0x00000080);
      monitoringConfig_ = null;
      if (monitoringConfigBuilder_ != null) {
        monitoringConfigBuilder_.dispose();
        monitoringConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Only applicable for Vertex AI Feature Store (Legacy).
     * Deprecated: The custom monitoring configuration for this Feature, if not
     * set, use the monitoring_config defined for the EntityType this Feature
     * belongs to.
     * Only Features with type
     * ([Feature.ValueType][google.cloud.aiplatform.v1beta1.Feature.ValueType])
     * BOOL, STRING, DOUBLE or INT64 can enable monitoring.
     *
     * If this is populated with
     * [FeaturestoreMonitoringConfig.disabled][] = true, snapshot analysis
     * monitoring is disabled; if
     * [FeaturestoreMonitoringConfig.monitoring_interval][] specified, snapshot
     * analysis monitoring is enabled. Otherwise, snapshot analysis monitoring
     * config is same as the EntityType's this Feature belongs to.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig monitoring_config = 9 [deprecated = true, (.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Deprecated
    public com.google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig.Builder
        getMonitoringConfigBuilder() {
      bitField0_ |= 0x00000080;
      onChanged();
      return getMonitoringConfigFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Optional. Only applicable for Vertex AI Feature Store (Legacy).
     * Deprecated: The custom monitoring configuration for this Feature, if not
     * set, use the monitoring_config defined for the EntityType this Feature
     * belongs to.
     * Only Features with type
     * ([Feature.ValueType][google.cloud.aiplatform.v1beta1.Feature.ValueType])
     * BOOL, STRING, DOUBLE or INT64 can enable monitoring.
     *
     * If this is populated with
     * [FeaturestoreMonitoringConfig.disabled][] = true, snapshot analysis
     * monitoring is disabled; if
     * [FeaturestoreMonitoringConfig.monitoring_interval][] specified, snapshot
     * analysis monitoring is enabled. Otherwise, snapshot analysis monitoring
     * config is same as the EntityType's this Feature belongs to.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig monitoring_config = 9 [deprecated = true, (.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Deprecated
    public com.google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfigOrBuilder
        getMonitoringConfigOrBuilder() {
      if (monitoringConfigBuilder_ != null) {
        return monitoringConfigBuilder_.getMessageOrBuilder();
      } else {
        return monitoringConfig_ == null
            ? com.google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig.getDefaultInstance()
            : monitoringConfig_;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Only applicable for Vertex AI Feature Store (Legacy).
     * Deprecated: The custom monitoring configuration for this Feature, if not
     * set, use the monitoring_config defined for the EntityType this Feature
     * belongs to.
     * Only Features with type
     * ([Feature.ValueType][google.cloud.aiplatform.v1beta1.Feature.ValueType])
     * BOOL, STRING, DOUBLE or INT64 can enable monitoring.
     *
     * If this is populated with
     * [FeaturestoreMonitoringConfig.disabled][] = true, snapshot analysis
     * monitoring is disabled; if
     * [FeaturestoreMonitoringConfig.monitoring_interval][] specified, snapshot
     * analysis monitoring is enabled. Otherwise, snapshot analysis monitoring
     * config is same as the EntityType's this Feature belongs to.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig monitoring_config = 9 [deprecated = true, (.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig,
            com.google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig.Builder,
            com.google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfigOrBuilder>
        getMonitoringConfigFieldBuilder() {
      if (monitoringConfigBuilder_ == null) {
        monitoringConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig,
                com.google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig.Builder,
                com.google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfigOrBuilder>(
                getMonitoringConfig(), getParentForChildren(), isClean());
        monitoringConfig_ = null;
      }
      return monitoringConfigBuilder_;
    }

    private boolean disableMonitoring_;

    /**
     *
     *
     * <pre>
     * Optional. Only applicable for Vertex AI Feature Store (Legacy).
     * If not set, use the monitoring_config defined for the EntityType this
     * Feature belongs to.
     * Only Features with type
     * ([Feature.ValueType][google.cloud.aiplatform.v1beta1.Feature.ValueType])
     * BOOL, STRING, DOUBLE or INT64 can enable monitoring.
     *
     * If set to true, all types of data monitoring are disabled despite the
     * config on EntityType.
     * </pre>
     *
     * <code>bool disable_monitoring = 12 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The disableMonitoring.
     */
    @java.lang.Override
    public boolean getDisableMonitoring() {
      return disableMonitoring_;
    }

    /**
     *
     *
     * <pre>
     * Optional. Only applicable for Vertex AI Feature Store (Legacy).
     * If not set, use the monitoring_config defined for the EntityType this
     * Feature belongs to.
     * Only Features with type
     * ([Feature.ValueType][google.cloud.aiplatform.v1beta1.Feature.ValueType])
     * BOOL, STRING, DOUBLE or INT64 can enable monitoring.
     *
     * If set to true, all types of data monitoring are disabled despite the
     * config on EntityType.
     * </pre>
     *
     * <code>bool disable_monitoring = 12 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The disableMonitoring to set.
     * @return This builder for chaining.
     */
    public Builder setDisableMonitoring(boolean value) {

      disableMonitoring_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Only applicable for Vertex AI Feature Store (Legacy).
     * If not set, use the monitoring_config defined for the EntityType this
     * Feature belongs to.
     * Only Features with type
     * ([Feature.ValueType][google.cloud.aiplatform.v1beta1.Feature.ValueType])
     * BOOL, STRING, DOUBLE or INT64 can enable monitoring.
     *
     * If set to true, all types of data monitoring are disabled despite the
     * config on EntityType.
     * </pre>
     *
     * <code>bool disable_monitoring = 12 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisableMonitoring() {
      bitField0_ = (bitField0_ & ~0x00000100);
      disableMonitoring_ = false;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly>
        monitoringStats_ = java.util.Collections.emptyList();

    private void ensureMonitoringStatsIsMutable() {
      if (!((bitField0_ & 0x00000200) != 0)) {
        monitoringStats_ =
            new java.util.ArrayList<com.google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly>(
                monitoringStats_);
        bitField0_ |= 0x00000200;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly,
            com.google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly.Builder,
            com.google.cloud.aiplatform.v1beta1.FeatureStatsAnomalyOrBuilder>
        monitoringStatsBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. Only applicable for Vertex AI Feature Store (Legacy).
     * A list of historical
     * [SnapshotAnalysis][google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig.SnapshotAnalysis]
     * stats requested by user, sorted by
     * [FeatureStatsAnomaly.start_time][google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly.start_time]
     * descending.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly monitoring_stats = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly>
        getMonitoringStatsList() {
      if (monitoringStatsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(monitoringStats_);
      } else {
        return monitoringStatsBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Only applicable for Vertex AI Feature Store (Legacy).
     * A list of historical
     * [SnapshotAnalysis][google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig.SnapshotAnalysis]
     * stats requested by user, sorted by
     * [FeatureStatsAnomaly.start_time][google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly.start_time]
     * descending.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly monitoring_stats = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public int getMonitoringStatsCount() {
      if (monitoringStatsBuilder_ == null) {
        return monitoringStats_.size();
      } else {
        return monitoringStatsBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Only applicable for Vertex AI Feature Store (Legacy).
     * A list of historical
     * [SnapshotAnalysis][google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig.SnapshotAnalysis]
     * stats requested by user, sorted by
     * [FeatureStatsAnomaly.start_time][google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly.start_time]
     * descending.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly monitoring_stats = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly getMonitoringStats(int index) {
      if (monitoringStatsBuilder_ == null) {
        return monitoringStats_.get(index);
      } else {
        return monitoringStatsBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Only applicable for Vertex AI Feature Store (Legacy).
     * A list of historical
     * [SnapshotAnalysis][google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig.SnapshotAnalysis]
     * stats requested by user, sorted by
     * [FeatureStatsAnomaly.start_time][google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly.start_time]
     * descending.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly monitoring_stats = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setMonitoringStats(
        int index, com.google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly value) {
      if (monitoringStatsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureMonitoringStatsIsMutable();
        monitoringStats_.set(index, value);
        onChanged();
      } else {
        monitoringStatsBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Only applicable for Vertex AI Feature Store (Legacy).
     * A list of historical
     * [SnapshotAnalysis][google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig.SnapshotAnalysis]
     * stats requested by user, sorted by
     * [FeatureStatsAnomaly.start_time][google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly.start_time]
     * descending.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly monitoring_stats = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setMonitoringStats(
        int index,
        com.google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly.Builder builderForValue) {
      if (monitoringStatsBuilder_ == null) {
        ensureMonitoringStatsIsMutable();
        monitoringStats_.set(index, builderForValue.build());
        onChanged();
      } else {
        monitoringStatsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Only applicable for Vertex AI Feature Store (Legacy).
     * A list of historical
     * [SnapshotAnalysis][google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig.SnapshotAnalysis]
     * stats requested by user, sorted by
     * [FeatureStatsAnomaly.start_time][google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly.start_time]
     * descending.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly monitoring_stats = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addMonitoringStats(
        com.google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly value) {
      if (monitoringStatsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureMonitoringStatsIsMutable();
        monitoringStats_.add(value);
        onChanged();
      } else {
        monitoringStatsBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Only applicable for Vertex AI Feature Store (Legacy).
     * A list of historical
     * [SnapshotAnalysis][google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig.SnapshotAnalysis]
     * stats requested by user, sorted by
     * [FeatureStatsAnomaly.start_time][google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly.start_time]
     * descending.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly monitoring_stats = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addMonitoringStats(
        int index, com.google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly value) {
      if (monitoringStatsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureMonitoringStatsIsMutable();
        monitoringStats_.add(index, value);
        onChanged();
      } else {
        monitoringStatsBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Only applicable for Vertex AI Feature Store (Legacy).
     * A list of historical
     * [SnapshotAnalysis][google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig.SnapshotAnalysis]
     * stats requested by user, sorted by
     * [FeatureStatsAnomaly.start_time][google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly.start_time]
     * descending.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly monitoring_stats = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addMonitoringStats(
        com.google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly.Builder builderForValue) {
      if (monitoringStatsBuilder_ == null) {
        ensureMonitoringStatsIsMutable();
        monitoringStats_.add(builderForValue.build());
        onChanged();
      } else {
        monitoringStatsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Only applicable for Vertex AI Feature Store (Legacy).
     * A list of historical
     * [SnapshotAnalysis][google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig.SnapshotAnalysis]
     * stats requested by user, sorted by
     * [FeatureStatsAnomaly.start_time][google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly.start_time]
     * descending.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly monitoring_stats = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addMonitoringStats(
        int index,
        com.google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly.Builder builderForValue) {
      if (monitoringStatsBuilder_ == null) {
        ensureMonitoringStatsIsMutable();
        monitoringStats_.add(index, builderForValue.build());
        onChanged();
      } else {
        monitoringStatsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Only applicable for Vertex AI Feature Store (Legacy).
     * A list of historical
     * [SnapshotAnalysis][google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig.SnapshotAnalysis]
     * stats requested by user, sorted by
     * [FeatureStatsAnomaly.start_time][google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly.start_time]
     * descending.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly monitoring_stats = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addAllMonitoringStats(
        java.lang.Iterable<? extends com.google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly>
            values) {
      if (monitoringStatsBuilder_ == null) {
        ensureMonitoringStatsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, monitoringStats_);
        onChanged();
      } else {
        monitoringStatsBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Only applicable for Vertex AI Feature Store (Legacy).
     * A list of historical
     * [SnapshotAnalysis][google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig.SnapshotAnalysis]
     * stats requested by user, sorted by
     * [FeatureStatsAnomaly.start_time][google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly.start_time]
     * descending.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly monitoring_stats = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearMonitoringStats() {
      if (monitoringStatsBuilder_ == null) {
        monitoringStats_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000200);
        onChanged();
      } else {
        monitoringStatsBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Only applicable for Vertex AI Feature Store (Legacy).
     * A list of historical
     * [SnapshotAnalysis][google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig.SnapshotAnalysis]
     * stats requested by user, sorted by
     * [FeatureStatsAnomaly.start_time][google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly.start_time]
     * descending.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly monitoring_stats = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder removeMonitoringStats(int index) {
      if (monitoringStatsBuilder_ == null) {
        ensureMonitoringStatsIsMutable();
        monitoringStats_.remove(index);
        onChanged();
      } else {
        monitoringStatsBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Only applicable for Vertex AI Feature Store (Legacy).
     * A list of historical
     * [SnapshotAnalysis][google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig.SnapshotAnalysis]
     * stats requested by user, sorted by
     * [FeatureStatsAnomaly.start_time][google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly.start_time]
     * descending.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly monitoring_stats = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly.Builder
        getMonitoringStatsBuilder(int index) {
      return getMonitoringStatsFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * Output only. Only applicable for Vertex AI Feature Store (Legacy).
     * A list of historical
     * [SnapshotAnalysis][google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig.SnapshotAnalysis]
     * stats requested by user, sorted by
     * [FeatureStatsAnomaly.start_time][google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly.start_time]
     * descending.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly monitoring_stats = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.FeatureStatsAnomalyOrBuilder
        getMonitoringStatsOrBuilder(int index) {
      if (monitoringStatsBuilder_ == null) {
        return monitoringStats_.get(index);
      } else {
        return monitoringStatsBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Only applicable for Vertex AI Feature Store (Legacy).
     * A list of historical
     * [SnapshotAnalysis][google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig.SnapshotAnalysis]
     * stats requested by user, sorted by
     * [FeatureStatsAnomaly.start_time][google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly.start_time]
     * descending.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly monitoring_stats = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<
            ? extends com.google.cloud.aiplatform.v1beta1.FeatureStatsAnomalyOrBuilder>
        getMonitoringStatsOrBuilderList() {
      if (monitoringStatsBuilder_ != null) {
        return monitoringStatsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(monitoringStats_);
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Only applicable for Vertex AI Feature Store (Legacy).
     * A list of historical
     * [SnapshotAnalysis][google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig.SnapshotAnalysis]
     * stats requested by user, sorted by
     * [FeatureStatsAnomaly.start_time][google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly.start_time]
     * descending.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly monitoring_stats = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly.Builder
        addMonitoringStatsBuilder() {
      return getMonitoringStatsFieldBuilder()
          .addBuilder(com.google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Output only. Only applicable for Vertex AI Feature Store (Legacy).
     * A list of historical
     * [SnapshotAnalysis][google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig.SnapshotAnalysis]
     * stats requested by user, sorted by
     * [FeatureStatsAnomaly.start_time][google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly.start_time]
     * descending.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly monitoring_stats = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly.Builder
        addMonitoringStatsBuilder(int index) {
      return getMonitoringStatsFieldBuilder()
          .addBuilder(
              index, com.google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Output only. Only applicable for Vertex AI Feature Store (Legacy).
     * A list of historical
     * [SnapshotAnalysis][google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig.SnapshotAnalysis]
     * stats requested by user, sorted by
     * [FeatureStatsAnomaly.start_time][google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly.start_time]
     * descending.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly monitoring_stats = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly.Builder>
        getMonitoringStatsBuilderList() {
      return getMonitoringStatsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly,
            com.google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly.Builder,
            com.google.cloud.aiplatform.v1beta1.FeatureStatsAnomalyOrBuilder>
        getMonitoringStatsFieldBuilder() {
      if (monitoringStatsBuilder_ == null) {
        monitoringStatsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly,
                com.google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly.Builder,
                com.google.cloud.aiplatform.v1beta1.FeatureStatsAnomalyOrBuilder>(
                monitoringStats_,
                ((bitField0_ & 0x00000200) != 0),
                getParentForChildren(),
                isClean());
        monitoringStats_ = null;
      }
      return monitoringStatsBuilder_;
    }

    private java.util.List<com.google.cloud.aiplatform.v1beta1.Feature.MonitoringStatsAnomaly>
        monitoringStatsAnomalies_ = java.util.Collections.emptyList();

    private void ensureMonitoringStatsAnomaliesIsMutable() {
      if (!((bitField0_ & 0x00000400) != 0)) {
        monitoringStatsAnomalies_ =
            new java.util.ArrayList<
                com.google.cloud.aiplatform.v1beta1.Feature.MonitoringStatsAnomaly>(
                monitoringStatsAnomalies_);
        bitField0_ |= 0x00000400;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.Feature.MonitoringStatsAnomaly,
            com.google.cloud.aiplatform.v1beta1.Feature.MonitoringStatsAnomaly.Builder,
            com.google.cloud.aiplatform.v1beta1.Feature.MonitoringStatsAnomalyOrBuilder>
        monitoringStatsAnomaliesBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. Only applicable for Vertex AI Feature Store (Legacy).
     * The list of historical stats and anomalies with specified objectives.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Feature.MonitoringStatsAnomaly monitoring_stats_anomalies = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.cloud.aiplatform.v1beta1.Feature.MonitoringStatsAnomaly>
        getMonitoringStatsAnomaliesList() {
      if (monitoringStatsAnomaliesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(monitoringStatsAnomalies_);
      } else {
        return monitoringStatsAnomaliesBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Only applicable for Vertex AI Feature Store (Legacy).
     * The list of historical stats and anomalies with specified objectives.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Feature.MonitoringStatsAnomaly monitoring_stats_anomalies = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public int getMonitoringStatsAnomaliesCount() {
      if (monitoringStatsAnomaliesBuilder_ == null) {
        return monitoringStatsAnomalies_.size();
      } else {
        return monitoringStatsAnomaliesBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Only applicable for Vertex AI Feature Store (Legacy).
     * The list of historical stats and anomalies with specified objectives.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Feature.MonitoringStatsAnomaly monitoring_stats_anomalies = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.Feature.MonitoringStatsAnomaly
        getMonitoringStatsAnomalies(int index) {
      if (monitoringStatsAnomaliesBuilder_ == null) {
        return monitoringStatsAnomalies_.get(index);
      } else {
        return monitoringStatsAnomaliesBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Only applicable for Vertex AI Feature Store (Legacy).
     * The list of historical stats and anomalies with specified objectives.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Feature.MonitoringStatsAnomaly monitoring_stats_anomalies = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setMonitoringStatsAnomalies(
        int index, com.google.cloud.aiplatform.v1beta1.Feature.MonitoringStatsAnomaly value) {
      if (monitoringStatsAnomaliesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureMonitoringStatsAnomaliesIsMutable();
        monitoringStatsAnomalies_.set(index, value);
        onChanged();
      } else {
        monitoringStatsAnomaliesBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Only applicable for Vertex AI Feature Store (Legacy).
     * The list of historical stats and anomalies with specified objectives.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Feature.MonitoringStatsAnomaly monitoring_stats_anomalies = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setMonitoringStatsAnomalies(
        int index,
        com.google.cloud.aiplatform.v1beta1.Feature.MonitoringStatsAnomaly.Builder
            builderForValue) {
      if (monitoringStatsAnomaliesBuilder_ == null) {
        ensureMonitoringStatsAnomaliesIsMutable();
        monitoringStatsAnomalies_.set(index, builderForValue.build());
        onChanged();
      } else {
        monitoringStatsAnomaliesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Only applicable for Vertex AI Feature Store (Legacy).
     * The list of historical stats and anomalies with specified objectives.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Feature.MonitoringStatsAnomaly monitoring_stats_anomalies = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addMonitoringStatsAnomalies(
        com.google.cloud.aiplatform.v1beta1.Feature.MonitoringStatsAnomaly value) {
      if (monitoringStatsAnomaliesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureMonitoringStatsAnomaliesIsMutable();
        monitoringStatsAnomalies_.add(value);
        onChanged();
      } else {
        monitoringStatsAnomaliesBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Only applicable for Vertex AI Feature Store (Legacy).
     * The list of historical stats and anomalies with specified objectives.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Feature.MonitoringStatsAnomaly monitoring_stats_anomalies = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addMonitoringStatsAnomalies(
        int index, com.google.cloud.aiplatform.v1beta1.Feature.MonitoringStatsAnomaly value) {
      if (monitoringStatsAnomaliesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureMonitoringStatsAnomaliesIsMutable();
        monitoringStatsAnomalies_.add(index, value);
        onChanged();
      } else {
        monitoringStatsAnomaliesBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Only applicable for Vertex AI Feature Store (Legacy).
     * The list of historical stats and anomalies with specified objectives.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Feature.MonitoringStatsAnomaly monitoring_stats_anomalies = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addMonitoringStatsAnomalies(
        com.google.cloud.aiplatform.v1beta1.Feature.MonitoringStatsAnomaly.Builder
            builderForValue) {
      if (monitoringStatsAnomaliesBuilder_ == null) {
        ensureMonitoringStatsAnomaliesIsMutable();
        monitoringStatsAnomalies_.add(builderForValue.build());
        onChanged();
      } else {
        monitoringStatsAnomaliesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Only applicable for Vertex AI Feature Store (Legacy).
     * The list of historical stats and anomalies with specified objectives.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Feature.MonitoringStatsAnomaly monitoring_stats_anomalies = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addMonitoringStatsAnomalies(
        int index,
        com.google.cloud.aiplatform.v1beta1.Feature.MonitoringStatsAnomaly.Builder
            builderForValue) {
      if (monitoringStatsAnomaliesBuilder_ == null) {
        ensureMonitoringStatsAnomaliesIsMutable();
        monitoringStatsAnomalies_.add(index, builderForValue.build());
        onChanged();
      } else {
        monitoringStatsAnomaliesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Only applicable for Vertex AI Feature Store (Legacy).
     * The list of historical stats and anomalies with specified objectives.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Feature.MonitoringStatsAnomaly monitoring_stats_anomalies = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addAllMonitoringStatsAnomalies(
        java.lang.Iterable<
                ? extends com.google.cloud.aiplatform.v1beta1.Feature.MonitoringStatsAnomaly>
            values) {
      if (monitoringStatsAnomaliesBuilder_ == null) {
        ensureMonitoringStatsAnomaliesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, monitoringStatsAnomalies_);
        onChanged();
      } else {
        monitoringStatsAnomaliesBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Only applicable for Vertex AI Feature Store (Legacy).
     * The list of historical stats and anomalies with specified objectives.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Feature.MonitoringStatsAnomaly monitoring_stats_anomalies = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearMonitoringStatsAnomalies() {
      if (monitoringStatsAnomaliesBuilder_ == null) {
        monitoringStatsAnomalies_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000400);
        onChanged();
      } else {
        monitoringStatsAnomaliesBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Only applicable for Vertex AI Feature Store (Legacy).
     * The list of historical stats and anomalies with specified objectives.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Feature.MonitoringStatsAnomaly monitoring_stats_anomalies = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder removeMonitoringStatsAnomalies(int index) {
      if (monitoringStatsAnomaliesBuilder_ == null) {
        ensureMonitoringStatsAnomaliesIsMutable();
        monitoringStatsAnomalies_.remove(index);
        onChanged();
      } else {
        monitoringStatsAnomaliesBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Only applicable for Vertex AI Feature Store (Legacy).
     * The list of historical stats and anomalies with specified objectives.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Feature.MonitoringStatsAnomaly monitoring_stats_anomalies = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.Feature.MonitoringStatsAnomaly.Builder
        getMonitoringStatsAnomaliesBuilder(int index) {
      return getMonitoringStatsAnomaliesFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * Output only. Only applicable for Vertex AI Feature Store (Legacy).
     * The list of historical stats and anomalies with specified objectives.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Feature.MonitoringStatsAnomaly monitoring_stats_anomalies = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.Feature.MonitoringStatsAnomalyOrBuilder
        getMonitoringStatsAnomaliesOrBuilder(int index) {
      if (monitoringStatsAnomaliesBuilder_ == null) {
        return monitoringStatsAnomalies_.get(index);
      } else {
        return monitoringStatsAnomaliesBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Only applicable for Vertex AI Feature Store (Legacy).
     * The list of historical stats and anomalies with specified objectives.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Feature.MonitoringStatsAnomaly monitoring_stats_anomalies = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<
            ? extends com.google.cloud.aiplatform.v1beta1.Feature.MonitoringStatsAnomalyOrBuilder>
        getMonitoringStatsAnomaliesOrBuilderList() {
      if (monitoringStatsAnomaliesBuilder_ != null) {
        return monitoringStatsAnomaliesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(monitoringStatsAnomalies_);
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Only applicable for Vertex AI Feature Store (Legacy).
     * The list of historical stats and anomalies with specified objectives.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Feature.MonitoringStatsAnomaly monitoring_stats_anomalies = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.Feature.MonitoringStatsAnomaly.Builder
        addMonitoringStatsAnomaliesBuilder() {
      return getMonitoringStatsAnomaliesFieldBuilder()
          .addBuilder(
              com.google.cloud.aiplatform.v1beta1.Feature.MonitoringStatsAnomaly
                  .getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Output only. Only applicable for Vertex AI Feature Store (Legacy).
     * The list of historical stats and anomalies with specified objectives.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Feature.MonitoringStatsAnomaly monitoring_stats_anomalies = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.Feature.MonitoringStatsAnomaly.Builder
        addMonitoringStatsAnomaliesBuilder(int index) {
      return getMonitoringStatsAnomaliesFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.aiplatform.v1beta1.Feature.MonitoringStatsAnomaly
                  .getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Output only. Only applicable for Vertex AI Feature Store (Legacy).
     * The list of historical stats and anomalies with specified objectives.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Feature.MonitoringStatsAnomaly monitoring_stats_anomalies = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<
            com.google.cloud.aiplatform.v1beta1.Feature.MonitoringStatsAnomaly.Builder>
        getMonitoringStatsAnomaliesBuilderList() {
      return getMonitoringStatsAnomaliesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.Feature.MonitoringStatsAnomaly,
            com.google.cloud.aiplatform.v1beta1.Feature.MonitoringStatsAnomaly.Builder,
            com.google.cloud.aiplatform.v1beta1.Feature.MonitoringStatsAnomalyOrBuilder>
        getMonitoringStatsAnomaliesFieldBuilder() {
      if (monitoringStatsAnomaliesBuilder_ == null) {
        monitoringStatsAnomaliesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.Feature.MonitoringStatsAnomaly,
                com.google.cloud.aiplatform.v1beta1.Feature.MonitoringStatsAnomaly.Builder,
                com.google.cloud.aiplatform.v1beta1.Feature.MonitoringStatsAnomalyOrBuilder>(
                monitoringStatsAnomalies_,
                ((bitField0_ & 0x00000400) != 0),
                getParentForChildren(),
                isClean());
        monitoringStatsAnomalies_ = null;
      }
      return monitoringStatsAnomaliesBuilder_;
    }

    private java.util.List<com.google.cloud.aiplatform.v1beta1.FeatureStatsAndAnomaly>
        featureStatsAndAnomaly_ = java.util.Collections.emptyList();

    private void ensureFeatureStatsAndAnomalyIsMutable() {
      if (!((bitField0_ & 0x00000800) != 0)) {
        featureStatsAndAnomaly_ =
            new java.util.ArrayList<com.google.cloud.aiplatform.v1beta1.FeatureStatsAndAnomaly>(
                featureStatsAndAnomaly_);
        bitField0_ |= 0x00000800;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.FeatureStatsAndAnomaly,
            com.google.cloud.aiplatform.v1beta1.FeatureStatsAndAnomaly.Builder,
            com.google.cloud.aiplatform.v1beta1.FeatureStatsAndAnomalyOrBuilder>
        featureStatsAndAnomalyBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. Only applicable for Vertex AI Feature Store.
     * The list of historical stats and anomalies.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.FeatureStatsAndAnomaly feature_stats_and_anomaly = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.cloud.aiplatform.v1beta1.FeatureStatsAndAnomaly>
        getFeatureStatsAndAnomalyList() {
      if (featureStatsAndAnomalyBuilder_ == null) {
        return java.util.Collections.unmodifiableList(featureStatsAndAnomaly_);
      } else {
        return featureStatsAndAnomalyBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Only applicable for Vertex AI Feature Store.
     * The list of historical stats and anomalies.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.FeatureStatsAndAnomaly feature_stats_and_anomaly = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public int getFeatureStatsAndAnomalyCount() {
      if (featureStatsAndAnomalyBuilder_ == null) {
        return featureStatsAndAnomaly_.size();
      } else {
        return featureStatsAndAnomalyBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Only applicable for Vertex AI Feature Store.
     * The list of historical stats and anomalies.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.FeatureStatsAndAnomaly feature_stats_and_anomaly = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.FeatureStatsAndAnomaly getFeatureStatsAndAnomaly(
        int index) {
      if (featureStatsAndAnomalyBuilder_ == null) {
        return featureStatsAndAnomaly_.get(index);
      } else {
        return featureStatsAndAnomalyBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Only applicable for Vertex AI Feature Store.
     * The list of historical stats and anomalies.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.FeatureStatsAndAnomaly feature_stats_and_anomaly = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setFeatureStatsAndAnomaly(
        int index, com.google.cloud.aiplatform.v1beta1.FeatureStatsAndAnomaly value) {
      if (featureStatsAndAnomalyBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFeatureStatsAndAnomalyIsMutable();
        featureStatsAndAnomaly_.set(index, value);
        onChanged();
      } else {
        featureStatsAndAnomalyBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Only applicable for Vertex AI Feature Store.
     * The list of historical stats and anomalies.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.FeatureStatsAndAnomaly feature_stats_and_anomaly = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setFeatureStatsAndAnomaly(
        int index,
        com.google.cloud.aiplatform.v1beta1.FeatureStatsAndAnomaly.Builder builderForValue) {
      if (featureStatsAndAnomalyBuilder_ == null) {
        ensureFeatureStatsAndAnomalyIsMutable();
        featureStatsAndAnomaly_.set(index, builderForValue.build());
        onChanged();
      } else {
        featureStatsAndAnomalyBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Only applicable for Vertex AI Feature Store.
     * The list of historical stats and anomalies.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.FeatureStatsAndAnomaly feature_stats_and_anomaly = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addFeatureStatsAndAnomaly(
        com.google.cloud.aiplatform.v1beta1.FeatureStatsAndAnomaly value) {
      if (featureStatsAndAnomalyBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFeatureStatsAndAnomalyIsMutable();
        featureStatsAndAnomaly_.add(value);
        onChanged();
      } else {
        featureStatsAndAnomalyBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Only applicable for Vertex AI Feature Store.
     * The list of historical stats and anomalies.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.FeatureStatsAndAnomaly feature_stats_and_anomaly = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addFeatureStatsAndAnomaly(
        int index, com.google.cloud.aiplatform.v1beta1.FeatureStatsAndAnomaly value) {
      if (featureStatsAndAnomalyBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFeatureStatsAndAnomalyIsMutable();
        featureStatsAndAnomaly_.add(index, value);
        onChanged();
      } else {
        featureStatsAndAnomalyBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Only applicable for Vertex AI Feature Store.
     * The list of historical stats and anomalies.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.FeatureStatsAndAnomaly feature_stats_and_anomaly = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addFeatureStatsAndAnomaly(
        com.google.cloud.aiplatform.v1beta1.FeatureStatsAndAnomaly.Builder builderForValue) {
      if (featureStatsAndAnomalyBuilder_ == null) {
        ensureFeatureStatsAndAnomalyIsMutable();
        featureStatsAndAnomaly_.add(builderForValue.build());
        onChanged();
      } else {
        featureStatsAndAnomalyBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Only applicable for Vertex AI Feature Store.
     * The list of historical stats and anomalies.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.FeatureStatsAndAnomaly feature_stats_and_anomaly = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addFeatureStatsAndAnomaly(
        int index,
        com.google.cloud.aiplatform.v1beta1.FeatureStatsAndAnomaly.Builder builderForValue) {
      if (featureStatsAndAnomalyBuilder_ == null) {
        ensureFeatureStatsAndAnomalyIsMutable();
        featureStatsAndAnomaly_.add(index, builderForValue.build());
        onChanged();
      } else {
        featureStatsAndAnomalyBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Only applicable for Vertex AI Feature Store.
     * The list of historical stats and anomalies.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.FeatureStatsAndAnomaly feature_stats_and_anomaly = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addAllFeatureStatsAndAnomaly(
        java.lang.Iterable<? extends com.google.cloud.aiplatform.v1beta1.FeatureStatsAndAnomaly>
            values) {
      if (featureStatsAndAnomalyBuilder_ == null) {
        ensureFeatureStatsAndAnomalyIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, featureStatsAndAnomaly_);
        onChanged();
      } else {
        featureStatsAndAnomalyBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Only applicable for Vertex AI Feature Store.
     * The list of historical stats and anomalies.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.FeatureStatsAndAnomaly feature_stats_and_anomaly = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearFeatureStatsAndAnomaly() {
      if (featureStatsAndAnomalyBuilder_ == null) {
        featureStatsAndAnomaly_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000800);
        onChanged();
      } else {
        featureStatsAndAnomalyBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Only applicable for Vertex AI Feature Store.
     * The list of historical stats and anomalies.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.FeatureStatsAndAnomaly feature_stats_and_anomaly = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder removeFeatureStatsAndAnomaly(int index) {
      if (featureStatsAndAnomalyBuilder_ == null) {
        ensureFeatureStatsAndAnomalyIsMutable();
        featureStatsAndAnomaly_.remove(index);
        onChanged();
      } else {
        featureStatsAndAnomalyBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Only applicable for Vertex AI Feature Store.
     * The list of historical stats and anomalies.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.FeatureStatsAndAnomaly feature_stats_and_anomaly = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.FeatureStatsAndAnomaly.Builder
        getFeatureStatsAndAnomalyBuilder(int index) {
      return getFeatureStatsAndAnomalyFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * Output only. Only applicable for Vertex AI Feature Store.
     * The list of historical stats and anomalies.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.FeatureStatsAndAnomaly feature_stats_and_anomaly = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.FeatureStatsAndAnomalyOrBuilder
        getFeatureStatsAndAnomalyOrBuilder(int index) {
      if (featureStatsAndAnomalyBuilder_ == null) {
        return featureStatsAndAnomaly_.get(index);
      } else {
        return featureStatsAndAnomalyBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Only applicable for Vertex AI Feature Store.
     * The list of historical stats and anomalies.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.FeatureStatsAndAnomaly feature_stats_and_anomaly = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<
            ? extends com.google.cloud.aiplatform.v1beta1.FeatureStatsAndAnomalyOrBuilder>
        getFeatureStatsAndAnomalyOrBuilderList() {
      if (featureStatsAndAnomalyBuilder_ != null) {
        return featureStatsAndAnomalyBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(featureStatsAndAnomaly_);
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Only applicable for Vertex AI Feature Store.
     * The list of historical stats and anomalies.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.FeatureStatsAndAnomaly feature_stats_and_anomaly = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.FeatureStatsAndAnomaly.Builder
        addFeatureStatsAndAnomalyBuilder() {
      return getFeatureStatsAndAnomalyFieldBuilder()
          .addBuilder(
              com.google.cloud.aiplatform.v1beta1.FeatureStatsAndAnomaly.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Output only. Only applicable for Vertex AI Feature Store.
     * The list of historical stats and anomalies.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.FeatureStatsAndAnomaly feature_stats_and_anomaly = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.FeatureStatsAndAnomaly.Builder
        addFeatureStatsAndAnomalyBuilder(int index) {
      return getFeatureStatsAndAnomalyFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.aiplatform.v1beta1.FeatureStatsAndAnomaly.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Output only. Only applicable for Vertex AI Feature Store.
     * The list of historical stats and anomalies.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.FeatureStatsAndAnomaly feature_stats_and_anomaly = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.cloud.aiplatform.v1beta1.FeatureStatsAndAnomaly.Builder>
        getFeatureStatsAndAnomalyBuilderList() {
      return getFeatureStatsAndAnomalyFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.FeatureStatsAndAnomaly,
            com.google.cloud.aiplatform.v1beta1.FeatureStatsAndAnomaly.Builder,
            com.google.cloud.aiplatform.v1beta1.FeatureStatsAndAnomalyOrBuilder>
        getFeatureStatsAndAnomalyFieldBuilder() {
      if (featureStatsAndAnomalyBuilder_ == null) {
        featureStatsAndAnomalyBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.FeatureStatsAndAnomaly,
                com.google.cloud.aiplatform.v1beta1.FeatureStatsAndAnomaly.Builder,
                com.google.cloud.aiplatform.v1beta1.FeatureStatsAndAnomalyOrBuilder>(
                featureStatsAndAnomaly_,
                ((bitField0_ & 0x00000800) != 0),
                getParentForChildren(),
                isClean());
        featureStatsAndAnomaly_ = null;
      }
      return featureStatsAndAnomalyBuilder_;
    }

    private java.lang.Object versionColumnName_ = "";

    /**
     *
     *
     * <pre>
     * Only applicable for Vertex AI Feature Store.
     * The name of the BigQuery Table/View column hosting data for this version.
     * If no value is provided, will use feature_id.
     * </pre>
     *
     * <code>string version_column_name = 106;</code>
     *
     * @return The versionColumnName.
     */
    public java.lang.String getVersionColumnName() {
      java.lang.Object ref = versionColumnName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        versionColumnName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Only applicable for Vertex AI Feature Store.
     * The name of the BigQuery Table/View column hosting data for this version.
     * If no value is provided, will use feature_id.
     * </pre>
     *
     * <code>string version_column_name = 106;</code>
     *
     * @return The bytes for versionColumnName.
     */
    public com.google.protobuf.ByteString getVersionColumnNameBytes() {
      java.lang.Object ref = versionColumnName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        versionColumnName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Only applicable for Vertex AI Feature Store.
     * The name of the BigQuery Table/View column hosting data for this version.
     * If no value is provided, will use feature_id.
     * </pre>
     *
     * <code>string version_column_name = 106;</code>
     *
     * @param value The versionColumnName to set.
     * @return This builder for chaining.
     */
    public Builder setVersionColumnName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      versionColumnName_ = value;
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Only applicable for Vertex AI Feature Store.
     * The name of the BigQuery Table/View column hosting data for this version.
     * If no value is provided, will use feature_id.
     * </pre>
     *
     * <code>string version_column_name = 106;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearVersionColumnName() {
      versionColumnName_ = getDefaultInstance().getVersionColumnName();
      bitField0_ = (bitField0_ & ~0x00001000);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Only applicable for Vertex AI Feature Store.
     * The name of the BigQuery Table/View column hosting data for this version.
     * If no value is provided, will use feature_id.
     * </pre>
     *
     * <code>string version_column_name = 106;</code>
     *
     * @param value The bytes for versionColumnName to set.
     * @return This builder for chaining.
     */
    public Builder setVersionColumnNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      versionColumnName_ = value;
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }

    private java.lang.Object pointOfContact_ = "";

    /**
     *
     *
     * <pre>
     * Entity responsible for maintaining this feature. Can be comma separated
     * list of email addresses or URIs.
     * </pre>
     *
     * <code>string point_of_contact = 107;</code>
     *
     * @return The pointOfContact.
     */
    public java.lang.String getPointOfContact() {
      java.lang.Object ref = pointOfContact_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        pointOfContact_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Entity responsible for maintaining this feature. Can be comma separated
     * list of email addresses or URIs.
     * </pre>
     *
     * <code>string point_of_contact = 107;</code>
     *
     * @return The bytes for pointOfContact.
     */
    public com.google.protobuf.ByteString getPointOfContactBytes() {
      java.lang.Object ref = pointOfContact_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        pointOfContact_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Entity responsible for maintaining this feature. Can be comma separated
     * list of email addresses or URIs.
     * </pre>
     *
     * <code>string point_of_contact = 107;</code>
     *
     * @param value The pointOfContact to set.
     * @return This builder for chaining.
     */
    public Builder setPointOfContact(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      pointOfContact_ = value;
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Entity responsible for maintaining this feature. Can be comma separated
     * list of email addresses or URIs.
     * </pre>
     *
     * <code>string point_of_contact = 107;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPointOfContact() {
      pointOfContact_ = getDefaultInstance().getPointOfContact();
      bitField0_ = (bitField0_ & ~0x00002000);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Entity responsible for maintaining this feature. Can be comma separated
     * list of email addresses or URIs.
     * </pre>
     *
     * <code>string point_of_contact = 107;</code>
     *
     * @param value The bytes for pointOfContact to set.
     * @return This builder for chaining.
     */
    public Builder setPointOfContactBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      pointOfContact_ = value;
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.Feature)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.Feature)
  private static final com.google.cloud.aiplatform.v1beta1.Feature DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.Feature();
  }

  public static com.google.cloud.aiplatform.v1beta1.Feature getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Feature> PARSER =
      new com.google.protobuf.AbstractParser<Feature>() {
        @java.lang.Override
        public Feature parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Feature> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Feature> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.Feature getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
