/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1beta1/vertex_rag_data.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.aiplatform.v1beta1;

/**
 *
 *
 * <pre>
 * Config for importing RagFiles.
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1beta1.ImportRagFilesConfig}
 */
public final class ImportRagFilesConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.ImportRagFilesConfig)
    ImportRagFilesConfigOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use ImportRagFilesConfig.newBuilder() to construct.
  private ImportRagFilesConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ImportRagFilesConfig() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ImportRagFilesConfig();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1beta1.VertexRagDataProto
        .internal_static_google_cloud_aiplatform_v1beta1_ImportRagFilesConfig_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1beta1.VertexRagDataProto
        .internal_static_google_cloud_aiplatform_v1beta1_ImportRagFilesConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1beta1.ImportRagFilesConfig.class,
            com.google.cloud.aiplatform.v1beta1.ImportRagFilesConfig.Builder.class);
  }

  private int bitField0_;
  private int importSourceCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object importSource_;

  public enum ImportSourceCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    GCS_SOURCE(2),
    GOOGLE_DRIVE_SOURCE(3),
    SLACK_SOURCE(6),
    JIRA_SOURCE(7),
    SHARE_POINT_SOURCES(13),
    IMPORTSOURCE_NOT_SET(0);
    private final int value;

    private ImportSourceCase(int value) {
      this.value = value;
    }

    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ImportSourceCase valueOf(int value) {
      return forNumber(value);
    }

    public static ImportSourceCase forNumber(int value) {
      switch (value) {
        case 2:
          return GCS_SOURCE;
        case 3:
          return GOOGLE_DRIVE_SOURCE;
        case 6:
          return SLACK_SOURCE;
        case 7:
          return JIRA_SOURCE;
        case 13:
          return SHARE_POINT_SOURCES;
        case 0:
          return IMPORTSOURCE_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public ImportSourceCase getImportSourceCase() {
    return ImportSourceCase.forNumber(importSourceCase_);
  }

  private int partialFailureSinkCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object partialFailureSink_;

  public enum PartialFailureSinkCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    @java.lang.Deprecated
    PARTIAL_FAILURE_GCS_SINK(11),
    @java.lang.Deprecated
    PARTIAL_FAILURE_BIGQUERY_SINK(12),
    PARTIALFAILURESINK_NOT_SET(0);
    private final int value;

    private PartialFailureSinkCase(int value) {
      this.value = value;
    }

    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static PartialFailureSinkCase valueOf(int value) {
      return forNumber(value);
    }

    public static PartialFailureSinkCase forNumber(int value) {
      switch (value) {
        case 11:
          return PARTIAL_FAILURE_GCS_SINK;
        case 12:
          return PARTIAL_FAILURE_BIGQUERY_SINK;
        case 0:
          return PARTIALFAILURESINK_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public PartialFailureSinkCase getPartialFailureSinkCase() {
    return PartialFailureSinkCase.forNumber(partialFailureSinkCase_);
  }

  private int importResultSinkCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object importResultSink_;

  public enum ImportResultSinkCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    IMPORT_RESULT_GCS_SINK(14),
    IMPORT_RESULT_BIGQUERY_SINK(15),
    IMPORTRESULTSINK_NOT_SET(0);
    private final int value;

    private ImportResultSinkCase(int value) {
      this.value = value;
    }

    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ImportResultSinkCase valueOf(int value) {
      return forNumber(value);
    }

    public static ImportResultSinkCase forNumber(int value) {
      switch (value) {
        case 14:
          return IMPORT_RESULT_GCS_SINK;
        case 15:
          return IMPORT_RESULT_BIGQUERY_SINK;
        case 0:
          return IMPORTRESULTSINK_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public ImportResultSinkCase getImportResultSinkCase() {
    return ImportResultSinkCase.forNumber(importResultSinkCase_);
  }

  public static final int GCS_SOURCE_FIELD_NUMBER = 2;

  /**
   *
   *
   * <pre>
   * Google Cloud Storage location. Supports importing individual files as
   * well as entire Google Cloud Storage directories. Sample formats:
   * - `gs://bucket_name/my_directory/object_name/my_file.txt`
   * - `gs://bucket_name/my_directory`
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.GcsSource gcs_source = 2;</code>
   *
   * @return Whether the gcsSource field is set.
   */
  @java.lang.Override
  public boolean hasGcsSource() {
    return importSourceCase_ == 2;
  }

  /**
   *
   *
   * <pre>
   * Google Cloud Storage location. Supports importing individual files as
   * well as entire Google Cloud Storage directories. Sample formats:
   * - `gs://bucket_name/my_directory/object_name/my_file.txt`
   * - `gs://bucket_name/my_directory`
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.GcsSource gcs_source = 2;</code>
   *
   * @return The gcsSource.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.GcsSource getGcsSource() {
    if (importSourceCase_ == 2) {
      return (com.google.cloud.aiplatform.v1beta1.GcsSource) importSource_;
    }
    return com.google.cloud.aiplatform.v1beta1.GcsSource.getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * Google Cloud Storage location. Supports importing individual files as
   * well as entire Google Cloud Storage directories. Sample formats:
   * - `gs://bucket_name/my_directory/object_name/my_file.txt`
   * - `gs://bucket_name/my_directory`
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.GcsSource gcs_source = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.GcsSourceOrBuilder getGcsSourceOrBuilder() {
    if (importSourceCase_ == 2) {
      return (com.google.cloud.aiplatform.v1beta1.GcsSource) importSource_;
    }
    return com.google.cloud.aiplatform.v1beta1.GcsSource.getDefaultInstance();
  }

  public static final int GOOGLE_DRIVE_SOURCE_FIELD_NUMBER = 3;

  /**
   *
   *
   * <pre>
   * Google Drive location. Supports importing individual files as
   * well as Google Drive folders.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.GoogleDriveSource google_drive_source = 3;</code>
   *
   * @return Whether the googleDriveSource field is set.
   */
  @java.lang.Override
  public boolean hasGoogleDriveSource() {
    return importSourceCase_ == 3;
  }

  /**
   *
   *
   * <pre>
   * Google Drive location. Supports importing individual files as
   * well as Google Drive folders.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.GoogleDriveSource google_drive_source = 3;</code>
   *
   * @return The googleDriveSource.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.GoogleDriveSource getGoogleDriveSource() {
    if (importSourceCase_ == 3) {
      return (com.google.cloud.aiplatform.v1beta1.GoogleDriveSource) importSource_;
    }
    return com.google.cloud.aiplatform.v1beta1.GoogleDriveSource.getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * Google Drive location. Supports importing individual files as
   * well as Google Drive folders.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.GoogleDriveSource google_drive_source = 3;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.GoogleDriveSourceOrBuilder
      getGoogleDriveSourceOrBuilder() {
    if (importSourceCase_ == 3) {
      return (com.google.cloud.aiplatform.v1beta1.GoogleDriveSource) importSource_;
    }
    return com.google.cloud.aiplatform.v1beta1.GoogleDriveSource.getDefaultInstance();
  }

  public static final int SLACK_SOURCE_FIELD_NUMBER = 6;

  /**
   *
   *
   * <pre>
   * Slack channels with their corresponding access tokens.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.SlackSource slack_source = 6;</code>
   *
   * @return Whether the slackSource field is set.
   */
  @java.lang.Override
  public boolean hasSlackSource() {
    return importSourceCase_ == 6;
  }

  /**
   *
   *
   * <pre>
   * Slack channels with their corresponding access tokens.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.SlackSource slack_source = 6;</code>
   *
   * @return The slackSource.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.SlackSource getSlackSource() {
    if (importSourceCase_ == 6) {
      return (com.google.cloud.aiplatform.v1beta1.SlackSource) importSource_;
    }
    return com.google.cloud.aiplatform.v1beta1.SlackSource.getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * Slack channels with their corresponding access tokens.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.SlackSource slack_source = 6;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.SlackSourceOrBuilder getSlackSourceOrBuilder() {
    if (importSourceCase_ == 6) {
      return (com.google.cloud.aiplatform.v1beta1.SlackSource) importSource_;
    }
    return com.google.cloud.aiplatform.v1beta1.SlackSource.getDefaultInstance();
  }

  public static final int JIRA_SOURCE_FIELD_NUMBER = 7;

  /**
   *
   *
   * <pre>
   * Jira queries with their corresponding authentication.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.JiraSource jira_source = 7;</code>
   *
   * @return Whether the jiraSource field is set.
   */
  @java.lang.Override
  public boolean hasJiraSource() {
    return importSourceCase_ == 7;
  }

  /**
   *
   *
   * <pre>
   * Jira queries with their corresponding authentication.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.JiraSource jira_source = 7;</code>
   *
   * @return The jiraSource.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.JiraSource getJiraSource() {
    if (importSourceCase_ == 7) {
      return (com.google.cloud.aiplatform.v1beta1.JiraSource) importSource_;
    }
    return com.google.cloud.aiplatform.v1beta1.JiraSource.getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * Jira queries with their corresponding authentication.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.JiraSource jira_source = 7;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.JiraSourceOrBuilder getJiraSourceOrBuilder() {
    if (importSourceCase_ == 7) {
      return (com.google.cloud.aiplatform.v1beta1.JiraSource) importSource_;
    }
    return com.google.cloud.aiplatform.v1beta1.JiraSource.getDefaultInstance();
  }

  public static final int SHARE_POINT_SOURCES_FIELD_NUMBER = 13;

  /**
   *
   *
   * <pre>
   * SharePoint sources.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.SharePointSources share_point_sources = 13;</code>
   *
   * @return Whether the sharePointSources field is set.
   */
  @java.lang.Override
  public boolean hasSharePointSources() {
    return importSourceCase_ == 13;
  }

  /**
   *
   *
   * <pre>
   * SharePoint sources.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.SharePointSources share_point_sources = 13;</code>
   *
   * @return The sharePointSources.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.SharePointSources getSharePointSources() {
    if (importSourceCase_ == 13) {
      return (com.google.cloud.aiplatform.v1beta1.SharePointSources) importSource_;
    }
    return com.google.cloud.aiplatform.v1beta1.SharePointSources.getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * SharePoint sources.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.SharePointSources share_point_sources = 13;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.SharePointSourcesOrBuilder
      getSharePointSourcesOrBuilder() {
    if (importSourceCase_ == 13) {
      return (com.google.cloud.aiplatform.v1beta1.SharePointSources) importSource_;
    }
    return com.google.cloud.aiplatform.v1beta1.SharePointSources.getDefaultInstance();
  }

  public static final int PARTIAL_FAILURE_GCS_SINK_FIELD_NUMBER = 11;

  /**
   *
   *
   * <pre>
   * The Cloud Storage path to write partial failures to.
   * Deprecated. Prefer to use `import_result_gcs_sink`.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.GcsDestination partial_failure_gcs_sink = 11 [deprecated = true];
   * </code>
   *
   * @deprecated google.cloud.aiplatform.v1beta1.ImportRagFilesConfig.partial_failure_gcs_sink is
   *     deprecated. See google/cloud/aiplatform/v1beta1/vertex_rag_data.proto;l=605
   * @return Whether the partialFailureGcsSink field is set.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public boolean hasPartialFailureGcsSink() {
    return partialFailureSinkCase_ == 11;
  }

  /**
   *
   *
   * <pre>
   * The Cloud Storage path to write partial failures to.
   * Deprecated. Prefer to use `import_result_gcs_sink`.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.GcsDestination partial_failure_gcs_sink = 11 [deprecated = true];
   * </code>
   *
   * @deprecated google.cloud.aiplatform.v1beta1.ImportRagFilesConfig.partial_failure_gcs_sink is
   *     deprecated. See google/cloud/aiplatform/v1beta1/vertex_rag_data.proto;l=605
   * @return The partialFailureGcsSink.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public com.google.cloud.aiplatform.v1beta1.GcsDestination getPartialFailureGcsSink() {
    if (partialFailureSinkCase_ == 11) {
      return (com.google.cloud.aiplatform.v1beta1.GcsDestination) partialFailureSink_;
    }
    return com.google.cloud.aiplatform.v1beta1.GcsDestination.getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * The Cloud Storage path to write partial failures to.
   * Deprecated. Prefer to use `import_result_gcs_sink`.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.GcsDestination partial_failure_gcs_sink = 11 [deprecated = true];
   * </code>
   */
  @java.lang.Override
  @java.lang.Deprecated
  public com.google.cloud.aiplatform.v1beta1.GcsDestinationOrBuilder
      getPartialFailureGcsSinkOrBuilder() {
    if (partialFailureSinkCase_ == 11) {
      return (com.google.cloud.aiplatform.v1beta1.GcsDestination) partialFailureSink_;
    }
    return com.google.cloud.aiplatform.v1beta1.GcsDestination.getDefaultInstance();
  }

  public static final int PARTIAL_FAILURE_BIGQUERY_SINK_FIELD_NUMBER = 12;

  /**
   *
   *
   * <pre>
   * The BigQuery destination to write partial failures to. It should be a
   * bigquery table resource name (e.g.
   * "bq://projectId.bqDatasetId.bqTableId"). The dataset must exist. If the
   * table does not exist, it will be created with the expected schema. If the
   * table exists, the schema will be validated and data will be added to this
   * existing table.
   * Deprecated. Prefer to use `import_result_bq_sink`.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.BigQueryDestination partial_failure_bigquery_sink = 12 [deprecated = true];
   * </code>
   *
   * @deprecated google.cloud.aiplatform.v1beta1.ImportRagFilesConfig.partial_failure_bigquery_sink
   *     is deprecated. See google/cloud/aiplatform/v1beta1/vertex_rag_data.proto;l=614
   * @return Whether the partialFailureBigquerySink field is set.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public boolean hasPartialFailureBigquerySink() {
    return partialFailureSinkCase_ == 12;
  }

  /**
   *
   *
   * <pre>
   * The BigQuery destination to write partial failures to. It should be a
   * bigquery table resource name (e.g.
   * "bq://projectId.bqDatasetId.bqTableId"). The dataset must exist. If the
   * table does not exist, it will be created with the expected schema. If the
   * table exists, the schema will be validated and data will be added to this
   * existing table.
   * Deprecated. Prefer to use `import_result_bq_sink`.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.BigQueryDestination partial_failure_bigquery_sink = 12 [deprecated = true];
   * </code>
   *
   * @deprecated google.cloud.aiplatform.v1beta1.ImportRagFilesConfig.partial_failure_bigquery_sink
   *     is deprecated. See google/cloud/aiplatform/v1beta1/vertex_rag_data.proto;l=614
   * @return The partialFailureBigquerySink.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public com.google.cloud.aiplatform.v1beta1.BigQueryDestination getPartialFailureBigquerySink() {
    if (partialFailureSinkCase_ == 12) {
      return (com.google.cloud.aiplatform.v1beta1.BigQueryDestination) partialFailureSink_;
    }
    return com.google.cloud.aiplatform.v1beta1.BigQueryDestination.getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * The BigQuery destination to write partial failures to. It should be a
   * bigquery table resource name (e.g.
   * "bq://projectId.bqDatasetId.bqTableId"). The dataset must exist. If the
   * table does not exist, it will be created with the expected schema. If the
   * table exists, the schema will be validated and data will be added to this
   * existing table.
   * Deprecated. Prefer to use `import_result_bq_sink`.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.BigQueryDestination partial_failure_bigquery_sink = 12 [deprecated = true];
   * </code>
   */
  @java.lang.Override
  @java.lang.Deprecated
  public com.google.cloud.aiplatform.v1beta1.BigQueryDestinationOrBuilder
      getPartialFailureBigquerySinkOrBuilder() {
    if (partialFailureSinkCase_ == 12) {
      return (com.google.cloud.aiplatform.v1beta1.BigQueryDestination) partialFailureSink_;
    }
    return com.google.cloud.aiplatform.v1beta1.BigQueryDestination.getDefaultInstance();
  }

  public static final int IMPORT_RESULT_GCS_SINK_FIELD_NUMBER = 14;

  /**
   *
   *
   * <pre>
   * The Cloud Storage path to write import result to.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.GcsDestination import_result_gcs_sink = 14;</code>
   *
   * @return Whether the importResultGcsSink field is set.
   */
  @java.lang.Override
  public boolean hasImportResultGcsSink() {
    return importResultSinkCase_ == 14;
  }

  /**
   *
   *
   * <pre>
   * The Cloud Storage path to write import result to.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.GcsDestination import_result_gcs_sink = 14;</code>
   *
   * @return The importResultGcsSink.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.GcsDestination getImportResultGcsSink() {
    if (importResultSinkCase_ == 14) {
      return (com.google.cloud.aiplatform.v1beta1.GcsDestination) importResultSink_;
    }
    return com.google.cloud.aiplatform.v1beta1.GcsDestination.getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * The Cloud Storage path to write import result to.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.GcsDestination import_result_gcs_sink = 14;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.GcsDestinationOrBuilder
      getImportResultGcsSinkOrBuilder() {
    if (importResultSinkCase_ == 14) {
      return (com.google.cloud.aiplatform.v1beta1.GcsDestination) importResultSink_;
    }
    return com.google.cloud.aiplatform.v1beta1.GcsDestination.getDefaultInstance();
  }

  public static final int IMPORT_RESULT_BIGQUERY_SINK_FIELD_NUMBER = 15;

  /**
   *
   *
   * <pre>
   * The BigQuery destination to write import result to. It should be a
   * bigquery table resource name (e.g.
   * "bq://projectId.bqDatasetId.bqTableId"). The dataset must exist. If the
   * table does not exist, it will be created with the expected schema. If the
   * table exists, the schema will be validated and data will be added to this
   * existing table.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.BigQueryDestination import_result_bigquery_sink = 15;
   * </code>
   *
   * @return Whether the importResultBigquerySink field is set.
   */
  @java.lang.Override
  public boolean hasImportResultBigquerySink() {
    return importResultSinkCase_ == 15;
  }

  /**
   *
   *
   * <pre>
   * The BigQuery destination to write import result to. It should be a
   * bigquery table resource name (e.g.
   * "bq://projectId.bqDatasetId.bqTableId"). The dataset must exist. If the
   * table does not exist, it will be created with the expected schema. If the
   * table exists, the schema will be validated and data will be added to this
   * existing table.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.BigQueryDestination import_result_bigquery_sink = 15;
   * </code>
   *
   * @return The importResultBigquerySink.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.BigQueryDestination getImportResultBigquerySink() {
    if (importResultSinkCase_ == 15) {
      return (com.google.cloud.aiplatform.v1beta1.BigQueryDestination) importResultSink_;
    }
    return com.google.cloud.aiplatform.v1beta1.BigQueryDestination.getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * The BigQuery destination to write import result to. It should be a
   * bigquery table resource name (e.g.
   * "bq://projectId.bqDatasetId.bqTableId"). The dataset must exist. If the
   * table does not exist, it will be created with the expected schema. If the
   * table exists, the schema will be validated and data will be added to this
   * existing table.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.BigQueryDestination import_result_bigquery_sink = 15;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.BigQueryDestinationOrBuilder
      getImportResultBigquerySinkOrBuilder() {
    if (importResultSinkCase_ == 15) {
      return (com.google.cloud.aiplatform.v1beta1.BigQueryDestination) importResultSink_;
    }
    return com.google.cloud.aiplatform.v1beta1.BigQueryDestination.getDefaultInstance();
  }

  public static final int RAG_FILE_CHUNKING_CONFIG_FIELD_NUMBER = 4;
  private com.google.cloud.aiplatform.v1beta1.RagFileChunkingConfig ragFileChunkingConfig_;

  /**
   *
   *
   * <pre>
   * Specifies the size and overlap of chunks after importing RagFiles.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.RagFileChunkingConfig rag_file_chunking_config = 4 [deprecated = true];
   * </code>
   *
   * @deprecated google.cloud.aiplatform.v1beta1.ImportRagFilesConfig.rag_file_chunking_config is
   *     deprecated. See google/cloud/aiplatform/v1beta1/vertex_rag_data.proto;l=633
   * @return Whether the ragFileChunkingConfig field is set.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public boolean hasRagFileChunkingConfig() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * Specifies the size and overlap of chunks after importing RagFiles.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.RagFileChunkingConfig rag_file_chunking_config = 4 [deprecated = true];
   * </code>
   *
   * @deprecated google.cloud.aiplatform.v1beta1.ImportRagFilesConfig.rag_file_chunking_config is
   *     deprecated. See google/cloud/aiplatform/v1beta1/vertex_rag_data.proto;l=633
   * @return The ragFileChunkingConfig.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public com.google.cloud.aiplatform.v1beta1.RagFileChunkingConfig getRagFileChunkingConfig() {
    return ragFileChunkingConfig_ == null
        ? com.google.cloud.aiplatform.v1beta1.RagFileChunkingConfig.getDefaultInstance()
        : ragFileChunkingConfig_;
  }

  /**
   *
   *
   * <pre>
   * Specifies the size and overlap of chunks after importing RagFiles.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.RagFileChunkingConfig rag_file_chunking_config = 4 [deprecated = true];
   * </code>
   */
  @java.lang.Override
  @java.lang.Deprecated
  public com.google.cloud.aiplatform.v1beta1.RagFileChunkingConfigOrBuilder
      getRagFileChunkingConfigOrBuilder() {
    return ragFileChunkingConfig_ == null
        ? com.google.cloud.aiplatform.v1beta1.RagFileChunkingConfig.getDefaultInstance()
        : ragFileChunkingConfig_;
  }

  public static final int RAG_FILE_TRANSFORMATION_CONFIG_FIELD_NUMBER = 16;
  private com.google.cloud.aiplatform.v1beta1.RagFileTransformationConfig
      ragFileTransformationConfig_;

  /**
   *
   *
   * <pre>
   * Specifies the transformation config for RagFiles.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.RagFileTransformationConfig rag_file_transformation_config = 16;
   * </code>
   *
   * @return Whether the ragFileTransformationConfig field is set.
   */
  @java.lang.Override
  public boolean hasRagFileTransformationConfig() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * Specifies the transformation config for RagFiles.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.RagFileTransformationConfig rag_file_transformation_config = 16;
   * </code>
   *
   * @return The ragFileTransformationConfig.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.RagFileTransformationConfig
      getRagFileTransformationConfig() {
    return ragFileTransformationConfig_ == null
        ? com.google.cloud.aiplatform.v1beta1.RagFileTransformationConfig.getDefaultInstance()
        : ragFileTransformationConfig_;
  }

  /**
   *
   *
   * <pre>
   * Specifies the transformation config for RagFiles.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.RagFileTransformationConfig rag_file_transformation_config = 16;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.RagFileTransformationConfigOrBuilder
      getRagFileTransformationConfigOrBuilder() {
    return ragFileTransformationConfig_ == null
        ? com.google.cloud.aiplatform.v1beta1.RagFileTransformationConfig.getDefaultInstance()
        : ragFileTransformationConfig_;
  }

  public static final int RAG_FILE_PARSING_CONFIG_FIELD_NUMBER = 8;
  private com.google.cloud.aiplatform.v1beta1.RagFileParsingConfig ragFileParsingConfig_;

  /**
   *
   *
   * <pre>
   * Optional. Specifies the parsing config for RagFiles.
   * RAG will use the default parser if this field is not set.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.RagFileParsingConfig rag_file_parsing_config = 8 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the ragFileParsingConfig field is set.
   */
  @java.lang.Override
  public boolean hasRagFileParsingConfig() {
    return ((bitField0_ & 0x00000004) != 0);
  }

  /**
   *
   *
   * <pre>
   * Optional. Specifies the parsing config for RagFiles.
   * RAG will use the default parser if this field is not set.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.RagFileParsingConfig rag_file_parsing_config = 8 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The ragFileParsingConfig.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.RagFileParsingConfig getRagFileParsingConfig() {
    return ragFileParsingConfig_ == null
        ? com.google.cloud.aiplatform.v1beta1.RagFileParsingConfig.getDefaultInstance()
        : ragFileParsingConfig_;
  }

  /**
   *
   *
   * <pre>
   * Optional. Specifies the parsing config for RagFiles.
   * RAG will use the default parser if this field is not set.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.RagFileParsingConfig rag_file_parsing_config = 8 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.RagFileParsingConfigOrBuilder
      getRagFileParsingConfigOrBuilder() {
    return ragFileParsingConfig_ == null
        ? com.google.cloud.aiplatform.v1beta1.RagFileParsingConfig.getDefaultInstance()
        : ragFileParsingConfig_;
  }

  public static final int MAX_EMBEDDING_REQUESTS_PER_MIN_FIELD_NUMBER = 5;
  private int maxEmbeddingRequestsPerMin_ = 0;

  /**
   *
   *
   * <pre>
   * Optional. The max number of queries per minute that this job is allowed to
   * make to the embedding model specified on the corpus. This value is specific
   * to this job and not shared across other import jobs. Consult the Quotas
   * page on the project to set an appropriate value here.
   * If unspecified, a default value of 1,000 QPM would be used.
   * </pre>
   *
   * <code>int32 max_embedding_requests_per_min = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The maxEmbeddingRequestsPerMin.
   */
  @java.lang.Override
  public int getMaxEmbeddingRequestsPerMin() {
    return maxEmbeddingRequestsPerMin_;
  }

  public static final int GLOBAL_MAX_EMBEDDING_REQUESTS_PER_MIN_FIELD_NUMBER = 18;
  private int globalMaxEmbeddingRequestsPerMin_ = 0;

  /**
   *
   *
   * <pre>
   * Optional. The max number of queries per minute that the indexing pipeline
   * job is allowed to make to the embedding model specified in the project.
   * Please follow the quota usage guideline of the embedding model you use to
   * set the value properly. If this value is not specified,
   * max_embedding_requests_per_min will be used by indexing pipeline job as the
   * global limit.
   * </pre>
   *
   * <code>
   * int32 global_max_embedding_requests_per_min = 18 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The globalMaxEmbeddingRequestsPerMin.
   */
  @java.lang.Override
  public int getGlobalMaxEmbeddingRequestsPerMin() {
    return globalMaxEmbeddingRequestsPerMin_;
  }

  public static final int REBUILD_ANN_INDEX_FIELD_NUMBER = 19;
  private boolean rebuildAnnIndex_ = false;

  /**
   *
   *
   * <pre>
   * Rebuilds the ANN index to optimize for recall on the imported data.
   * Only applicable for RagCorpora running on RagManagedDb with
   * `retrieval_strategy` set to `ANN`. The rebuild will be performed using the
   * existing ANN config set on the RagCorpus. To change the ANN config, please
   * use the UpdateRagCorpus API.
   *
   * Default is false, i.e., index is not rebuilt.
   * </pre>
   *
   * <code>bool rebuild_ann_index = 19;</code>
   *
   * @return The rebuildAnnIndex.
   */
  @java.lang.Override
  public boolean getRebuildAnnIndex() {
    return rebuildAnnIndex_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (importSourceCase_ == 2) {
      output.writeMessage(2, (com.google.cloud.aiplatform.v1beta1.GcsSource) importSource_);
    }
    if (importSourceCase_ == 3) {
      output.writeMessage(3, (com.google.cloud.aiplatform.v1beta1.GoogleDriveSource) importSource_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(4, getRagFileChunkingConfig());
    }
    if (maxEmbeddingRequestsPerMin_ != 0) {
      output.writeInt32(5, maxEmbeddingRequestsPerMin_);
    }
    if (importSourceCase_ == 6) {
      output.writeMessage(6, (com.google.cloud.aiplatform.v1beta1.SlackSource) importSource_);
    }
    if (importSourceCase_ == 7) {
      output.writeMessage(7, (com.google.cloud.aiplatform.v1beta1.JiraSource) importSource_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(8, getRagFileParsingConfig());
    }
    if (partialFailureSinkCase_ == 11) {
      output.writeMessage(
          11, (com.google.cloud.aiplatform.v1beta1.GcsDestination) partialFailureSink_);
    }
    if (partialFailureSinkCase_ == 12) {
      output.writeMessage(
          12, (com.google.cloud.aiplatform.v1beta1.BigQueryDestination) partialFailureSink_);
    }
    if (importSourceCase_ == 13) {
      output.writeMessage(
          13, (com.google.cloud.aiplatform.v1beta1.SharePointSources) importSource_);
    }
    if (importResultSinkCase_ == 14) {
      output.writeMessage(
          14, (com.google.cloud.aiplatform.v1beta1.GcsDestination) importResultSink_);
    }
    if (importResultSinkCase_ == 15) {
      output.writeMessage(
          15, (com.google.cloud.aiplatform.v1beta1.BigQueryDestination) importResultSink_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(16, getRagFileTransformationConfig());
    }
    if (globalMaxEmbeddingRequestsPerMin_ != 0) {
      output.writeInt32(18, globalMaxEmbeddingRequestsPerMin_);
    }
    if (rebuildAnnIndex_ != false) {
      output.writeBool(19, rebuildAnnIndex_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (importSourceCase_ == 2) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              2, (com.google.cloud.aiplatform.v1beta1.GcsSource) importSource_);
    }
    if (importSourceCase_ == 3) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              3, (com.google.cloud.aiplatform.v1beta1.GoogleDriveSource) importSource_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(4, getRagFileChunkingConfig());
    }
    if (maxEmbeddingRequestsPerMin_ != 0) {
      size +=
          com.google.protobuf.CodedOutputStream.computeInt32Size(5, maxEmbeddingRequestsPerMin_);
    }
    if (importSourceCase_ == 6) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              6, (com.google.cloud.aiplatform.v1beta1.SlackSource) importSource_);
    }
    if (importSourceCase_ == 7) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              7, (com.google.cloud.aiplatform.v1beta1.JiraSource) importSource_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(8, getRagFileParsingConfig());
    }
    if (partialFailureSinkCase_ == 11) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              11, (com.google.cloud.aiplatform.v1beta1.GcsDestination) partialFailureSink_);
    }
    if (partialFailureSinkCase_ == 12) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              12, (com.google.cloud.aiplatform.v1beta1.BigQueryDestination) partialFailureSink_);
    }
    if (importSourceCase_ == 13) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              13, (com.google.cloud.aiplatform.v1beta1.SharePointSources) importSource_);
    }
    if (importResultSinkCase_ == 14) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              14, (com.google.cloud.aiplatform.v1beta1.GcsDestination) importResultSink_);
    }
    if (importResultSinkCase_ == 15) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              15, (com.google.cloud.aiplatform.v1beta1.BigQueryDestination) importResultSink_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              16, getRagFileTransformationConfig());
    }
    if (globalMaxEmbeddingRequestsPerMin_ != 0) {
      size +=
          com.google.protobuf.CodedOutputStream.computeInt32Size(
              18, globalMaxEmbeddingRequestsPerMin_);
    }
    if (rebuildAnnIndex_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(19, rebuildAnnIndex_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.ImportRagFilesConfig)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1beta1.ImportRagFilesConfig other =
        (com.google.cloud.aiplatform.v1beta1.ImportRagFilesConfig) obj;

    if (hasRagFileChunkingConfig() != other.hasRagFileChunkingConfig()) return false;
    if (hasRagFileChunkingConfig()) {
      if (!getRagFileChunkingConfig().equals(other.getRagFileChunkingConfig())) return false;
    }
    if (hasRagFileTransformationConfig() != other.hasRagFileTransformationConfig()) return false;
    if (hasRagFileTransformationConfig()) {
      if (!getRagFileTransformationConfig().equals(other.getRagFileTransformationConfig()))
        return false;
    }
    if (hasRagFileParsingConfig() != other.hasRagFileParsingConfig()) return false;
    if (hasRagFileParsingConfig()) {
      if (!getRagFileParsingConfig().equals(other.getRagFileParsingConfig())) return false;
    }
    if (getMaxEmbeddingRequestsPerMin() != other.getMaxEmbeddingRequestsPerMin()) return false;
    if (getGlobalMaxEmbeddingRequestsPerMin() != other.getGlobalMaxEmbeddingRequestsPerMin())
      return false;
    if (getRebuildAnnIndex() != other.getRebuildAnnIndex()) return false;
    if (!getImportSourceCase().equals(other.getImportSourceCase())) return false;
    switch (importSourceCase_) {
      case 2:
        if (!getGcsSource().equals(other.getGcsSource())) return false;
        break;
      case 3:
        if (!getGoogleDriveSource().equals(other.getGoogleDriveSource())) return false;
        break;
      case 6:
        if (!getSlackSource().equals(other.getSlackSource())) return false;
        break;
      case 7:
        if (!getJiraSource().equals(other.getJiraSource())) return false;
        break;
      case 13:
        if (!getSharePointSources().equals(other.getSharePointSources())) return false;
        break;
      case 0:
      default:
    }
    if (!getPartialFailureSinkCase().equals(other.getPartialFailureSinkCase())) return false;
    switch (partialFailureSinkCase_) {
      case 11:
        if (!getPartialFailureGcsSink().equals(other.getPartialFailureGcsSink())) return false;
        break;
      case 12:
        if (!getPartialFailureBigquerySink().equals(other.getPartialFailureBigquerySink()))
          return false;
        break;
      case 0:
      default:
    }
    if (!getImportResultSinkCase().equals(other.getImportResultSinkCase())) return false;
    switch (importResultSinkCase_) {
      case 14:
        if (!getImportResultGcsSink().equals(other.getImportResultGcsSink())) return false;
        break;
      case 15:
        if (!getImportResultBigquerySink().equals(other.getImportResultBigquerySink()))
          return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasRagFileChunkingConfig()) {
      hash = (37 * hash) + RAG_FILE_CHUNKING_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getRagFileChunkingConfig().hashCode();
    }
    if (hasRagFileTransformationConfig()) {
      hash = (37 * hash) + RAG_FILE_TRANSFORMATION_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getRagFileTransformationConfig().hashCode();
    }
    if (hasRagFileParsingConfig()) {
      hash = (37 * hash) + RAG_FILE_PARSING_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getRagFileParsingConfig().hashCode();
    }
    hash = (37 * hash) + MAX_EMBEDDING_REQUESTS_PER_MIN_FIELD_NUMBER;
    hash = (53 * hash) + getMaxEmbeddingRequestsPerMin();
    hash = (37 * hash) + GLOBAL_MAX_EMBEDDING_REQUESTS_PER_MIN_FIELD_NUMBER;
    hash = (53 * hash) + getGlobalMaxEmbeddingRequestsPerMin();
    hash = (37 * hash) + REBUILD_ANN_INDEX_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getRebuildAnnIndex());
    switch (importSourceCase_) {
      case 2:
        hash = (37 * hash) + GCS_SOURCE_FIELD_NUMBER;
        hash = (53 * hash) + getGcsSource().hashCode();
        break;
      case 3:
        hash = (37 * hash) + GOOGLE_DRIVE_SOURCE_FIELD_NUMBER;
        hash = (53 * hash) + getGoogleDriveSource().hashCode();
        break;
      case 6:
        hash = (37 * hash) + SLACK_SOURCE_FIELD_NUMBER;
        hash = (53 * hash) + getSlackSource().hashCode();
        break;
      case 7:
        hash = (37 * hash) + JIRA_SOURCE_FIELD_NUMBER;
        hash = (53 * hash) + getJiraSource().hashCode();
        break;
      case 13:
        hash = (37 * hash) + SHARE_POINT_SOURCES_FIELD_NUMBER;
        hash = (53 * hash) + getSharePointSources().hashCode();
        break;
      case 0:
      default:
    }
    switch (partialFailureSinkCase_) {
      case 11:
        hash = (37 * hash) + PARTIAL_FAILURE_GCS_SINK_FIELD_NUMBER;
        hash = (53 * hash) + getPartialFailureGcsSink().hashCode();
        break;
      case 12:
        hash = (37 * hash) + PARTIAL_FAILURE_BIGQUERY_SINK_FIELD_NUMBER;
        hash = (53 * hash) + getPartialFailureBigquerySink().hashCode();
        break;
      case 0:
      default:
    }
    switch (importResultSinkCase_) {
      case 14:
        hash = (37 * hash) + IMPORT_RESULT_GCS_SINK_FIELD_NUMBER;
        hash = (53 * hash) + getImportResultGcsSink().hashCode();
        break;
      case 15:
        hash = (37 * hash) + IMPORT_RESULT_BIGQUERY_SINK_FIELD_NUMBER;
        hash = (53 * hash) + getImportResultBigquerySink().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1beta1.ImportRagFilesConfig parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.ImportRagFilesConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.ImportRagFilesConfig parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.ImportRagFilesConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.ImportRagFilesConfig parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.ImportRagFilesConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.ImportRagFilesConfig parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.ImportRagFilesConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.ImportRagFilesConfig parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.ImportRagFilesConfig parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.ImportRagFilesConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.ImportRagFilesConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.aiplatform.v1beta1.ImportRagFilesConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Config for importing RagFiles.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.ImportRagFilesConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.ImportRagFilesConfig)
      com.google.cloud.aiplatform.v1beta1.ImportRagFilesConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.VertexRagDataProto
          .internal_static_google_cloud_aiplatform_v1beta1_ImportRagFilesConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.VertexRagDataProto
          .internal_static_google_cloud_aiplatform_v1beta1_ImportRagFilesConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.ImportRagFilesConfig.class,
              com.google.cloud.aiplatform.v1beta1.ImportRagFilesConfig.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1beta1.ImportRagFilesConfig.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getRagFileChunkingConfigFieldBuilder();
        getRagFileTransformationConfigFieldBuilder();
        getRagFileParsingConfigFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (gcsSourceBuilder_ != null) {
        gcsSourceBuilder_.clear();
      }
      if (googleDriveSourceBuilder_ != null) {
        googleDriveSourceBuilder_.clear();
      }
      if (slackSourceBuilder_ != null) {
        slackSourceBuilder_.clear();
      }
      if (jiraSourceBuilder_ != null) {
        jiraSourceBuilder_.clear();
      }
      if (sharePointSourcesBuilder_ != null) {
        sharePointSourcesBuilder_.clear();
      }
      if (partialFailureGcsSinkBuilder_ != null) {
        partialFailureGcsSinkBuilder_.clear();
      }
      if (partialFailureBigquerySinkBuilder_ != null) {
        partialFailureBigquerySinkBuilder_.clear();
      }
      if (importResultGcsSinkBuilder_ != null) {
        importResultGcsSinkBuilder_.clear();
      }
      if (importResultBigquerySinkBuilder_ != null) {
        importResultBigquerySinkBuilder_.clear();
      }
      ragFileChunkingConfig_ = null;
      if (ragFileChunkingConfigBuilder_ != null) {
        ragFileChunkingConfigBuilder_.dispose();
        ragFileChunkingConfigBuilder_ = null;
      }
      ragFileTransformationConfig_ = null;
      if (ragFileTransformationConfigBuilder_ != null) {
        ragFileTransformationConfigBuilder_.dispose();
        ragFileTransformationConfigBuilder_ = null;
      }
      ragFileParsingConfig_ = null;
      if (ragFileParsingConfigBuilder_ != null) {
        ragFileParsingConfigBuilder_.dispose();
        ragFileParsingConfigBuilder_ = null;
      }
      maxEmbeddingRequestsPerMin_ = 0;
      globalMaxEmbeddingRequestsPerMin_ = 0;
      rebuildAnnIndex_ = false;
      importSourceCase_ = 0;
      importSource_ = null;
      partialFailureSinkCase_ = 0;
      partialFailureSink_ = null;
      importResultSinkCase_ = 0;
      importResultSink_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1beta1.VertexRagDataProto
          .internal_static_google_cloud_aiplatform_v1beta1_ImportRagFilesConfig_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ImportRagFilesConfig getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1beta1.ImportRagFilesConfig.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ImportRagFilesConfig build() {
      com.google.cloud.aiplatform.v1beta1.ImportRagFilesConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ImportRagFilesConfig buildPartial() {
      com.google.cloud.aiplatform.v1beta1.ImportRagFilesConfig result =
          new com.google.cloud.aiplatform.v1beta1.ImportRagFilesConfig(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.aiplatform.v1beta1.ImportRagFilesConfig result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.ragFileChunkingConfig_ =
            ragFileChunkingConfigBuilder_ == null
                ? ragFileChunkingConfig_
                : ragFileChunkingConfigBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.ragFileTransformationConfig_ =
            ragFileTransformationConfigBuilder_ == null
                ? ragFileTransformationConfig_
                : ragFileTransformationConfigBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.ragFileParsingConfig_ =
            ragFileParsingConfigBuilder_ == null
                ? ragFileParsingConfig_
                : ragFileParsingConfigBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00001000) != 0)) {
        result.maxEmbeddingRequestsPerMin_ = maxEmbeddingRequestsPerMin_;
      }
      if (((from_bitField0_ & 0x00002000) != 0)) {
        result.globalMaxEmbeddingRequestsPerMin_ = globalMaxEmbeddingRequestsPerMin_;
      }
      if (((from_bitField0_ & 0x00004000) != 0)) {
        result.rebuildAnnIndex_ = rebuildAnnIndex_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    private void buildPartialOneofs(
        com.google.cloud.aiplatform.v1beta1.ImportRagFilesConfig result) {
      result.importSourceCase_ = importSourceCase_;
      result.importSource_ = this.importSource_;
      if (importSourceCase_ == 2 && gcsSourceBuilder_ != null) {
        result.importSource_ = gcsSourceBuilder_.build();
      }
      if (importSourceCase_ == 3 && googleDriveSourceBuilder_ != null) {
        result.importSource_ = googleDriveSourceBuilder_.build();
      }
      if (importSourceCase_ == 6 && slackSourceBuilder_ != null) {
        result.importSource_ = slackSourceBuilder_.build();
      }
      if (importSourceCase_ == 7 && jiraSourceBuilder_ != null) {
        result.importSource_ = jiraSourceBuilder_.build();
      }
      if (importSourceCase_ == 13 && sharePointSourcesBuilder_ != null) {
        result.importSource_ = sharePointSourcesBuilder_.build();
      }
      result.partialFailureSinkCase_ = partialFailureSinkCase_;
      result.partialFailureSink_ = this.partialFailureSink_;
      if (partialFailureSinkCase_ == 11 && partialFailureGcsSinkBuilder_ != null) {
        result.partialFailureSink_ = partialFailureGcsSinkBuilder_.build();
      }
      if (partialFailureSinkCase_ == 12 && partialFailureBigquerySinkBuilder_ != null) {
        result.partialFailureSink_ = partialFailureBigquerySinkBuilder_.build();
      }
      result.importResultSinkCase_ = importResultSinkCase_;
      result.importResultSink_ = this.importResultSink_;
      if (importResultSinkCase_ == 14 && importResultGcsSinkBuilder_ != null) {
        result.importResultSink_ = importResultGcsSinkBuilder_.build();
      }
      if (importResultSinkCase_ == 15 && importResultBigquerySinkBuilder_ != null) {
        result.importResultSink_ = importResultBigquerySinkBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1beta1.ImportRagFilesConfig) {
        return mergeFrom((com.google.cloud.aiplatform.v1beta1.ImportRagFilesConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1beta1.ImportRagFilesConfig other) {
      if (other == com.google.cloud.aiplatform.v1beta1.ImportRagFilesConfig.getDefaultInstance())
        return this;
      if (other.hasRagFileChunkingConfig()) {
        mergeRagFileChunkingConfig(other.getRagFileChunkingConfig());
      }
      if (other.hasRagFileTransformationConfig()) {
        mergeRagFileTransformationConfig(other.getRagFileTransformationConfig());
      }
      if (other.hasRagFileParsingConfig()) {
        mergeRagFileParsingConfig(other.getRagFileParsingConfig());
      }
      if (other.getMaxEmbeddingRequestsPerMin() != 0) {
        setMaxEmbeddingRequestsPerMin(other.getMaxEmbeddingRequestsPerMin());
      }
      if (other.getGlobalMaxEmbeddingRequestsPerMin() != 0) {
        setGlobalMaxEmbeddingRequestsPerMin(other.getGlobalMaxEmbeddingRequestsPerMin());
      }
      if (other.getRebuildAnnIndex() != false) {
        setRebuildAnnIndex(other.getRebuildAnnIndex());
      }
      switch (other.getImportSourceCase()) {
        case GCS_SOURCE:
          {
            mergeGcsSource(other.getGcsSource());
            break;
          }
        case GOOGLE_DRIVE_SOURCE:
          {
            mergeGoogleDriveSource(other.getGoogleDriveSource());
            break;
          }
        case SLACK_SOURCE:
          {
            mergeSlackSource(other.getSlackSource());
            break;
          }
        case JIRA_SOURCE:
          {
            mergeJiraSource(other.getJiraSource());
            break;
          }
        case SHARE_POINT_SOURCES:
          {
            mergeSharePointSources(other.getSharePointSources());
            break;
          }
        case IMPORTSOURCE_NOT_SET:
          {
            break;
          }
      }
      switch (other.getPartialFailureSinkCase()) {
        case PARTIAL_FAILURE_GCS_SINK:
          {
            mergePartialFailureGcsSink(other.getPartialFailureGcsSink());
            break;
          }
        case PARTIAL_FAILURE_BIGQUERY_SINK:
          {
            mergePartialFailureBigquerySink(other.getPartialFailureBigquerySink());
            break;
          }
        case PARTIALFAILURESINK_NOT_SET:
          {
            break;
          }
      }
      switch (other.getImportResultSinkCase()) {
        case IMPORT_RESULT_GCS_SINK:
          {
            mergeImportResultGcsSink(other.getImportResultGcsSink());
            break;
          }
        case IMPORT_RESULT_BIGQUERY_SINK:
          {
            mergeImportResultBigquerySink(other.getImportResultBigquerySink());
            break;
          }
        case IMPORTRESULTSINK_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 18:
              {
                input.readMessage(getGcsSourceFieldBuilder().getBuilder(), extensionRegistry);
                importSourceCase_ = 2;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(
                    getGoogleDriveSourceFieldBuilder().getBuilder(), extensionRegistry);
                importSourceCase_ = 3;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(
                    getRagFileChunkingConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000200;
                break;
              } // case 34
            case 40:
              {
                maxEmbeddingRequestsPerMin_ = input.readInt32();
                bitField0_ |= 0x00001000;
                break;
              } // case 40
            case 50:
              {
                input.readMessage(getSlackSourceFieldBuilder().getBuilder(), extensionRegistry);
                importSourceCase_ = 6;
                break;
              } // case 50
            case 58:
              {
                input.readMessage(getJiraSourceFieldBuilder().getBuilder(), extensionRegistry);
                importSourceCase_ = 7;
                break;
              } // case 58
            case 66:
              {
                input.readMessage(
                    getRagFileParsingConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000800;
                break;
              } // case 66
            case 90:
              {
                input.readMessage(
                    getPartialFailureGcsSinkFieldBuilder().getBuilder(), extensionRegistry);
                partialFailureSinkCase_ = 11;
                break;
              } // case 90
            case 98:
              {
                input.readMessage(
                    getPartialFailureBigquerySinkFieldBuilder().getBuilder(), extensionRegistry);
                partialFailureSinkCase_ = 12;
                break;
              } // case 98
            case 106:
              {
                input.readMessage(
                    getSharePointSourcesFieldBuilder().getBuilder(), extensionRegistry);
                importSourceCase_ = 13;
                break;
              } // case 106
            case 114:
              {
                input.readMessage(
                    getImportResultGcsSinkFieldBuilder().getBuilder(), extensionRegistry);
                importResultSinkCase_ = 14;
                break;
              } // case 114
            case 122:
              {
                input.readMessage(
                    getImportResultBigquerySinkFieldBuilder().getBuilder(), extensionRegistry);
                importResultSinkCase_ = 15;
                break;
              } // case 122
            case 130:
              {
                input.readMessage(
                    getRagFileTransformationConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000400;
                break;
              } // case 130
            case 144:
              {
                globalMaxEmbeddingRequestsPerMin_ = input.readInt32();
                bitField0_ |= 0x00002000;
                break;
              } // case 144
            case 152:
              {
                rebuildAnnIndex_ = input.readBool();
                bitField0_ |= 0x00004000;
                break;
              } // case 152
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int importSourceCase_ = 0;
    private java.lang.Object importSource_;

    public ImportSourceCase getImportSourceCase() {
      return ImportSourceCase.forNumber(importSourceCase_);
    }

    public Builder clearImportSource() {
      importSourceCase_ = 0;
      importSource_ = null;
      onChanged();
      return this;
    }

    private int partialFailureSinkCase_ = 0;
    private java.lang.Object partialFailureSink_;

    public PartialFailureSinkCase getPartialFailureSinkCase() {
      return PartialFailureSinkCase.forNumber(partialFailureSinkCase_);
    }

    public Builder clearPartialFailureSink() {
      partialFailureSinkCase_ = 0;
      partialFailureSink_ = null;
      onChanged();
      return this;
    }

    private int importResultSinkCase_ = 0;
    private java.lang.Object importResultSink_;

    public ImportResultSinkCase getImportResultSinkCase() {
      return ImportResultSinkCase.forNumber(importResultSinkCase_);
    }

    public Builder clearImportResultSink() {
      importResultSinkCase_ = 0;
      importResultSink_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.GcsSource,
            com.google.cloud.aiplatform.v1beta1.GcsSource.Builder,
            com.google.cloud.aiplatform.v1beta1.GcsSourceOrBuilder>
        gcsSourceBuilder_;

    /**
     *
     *
     * <pre>
     * Google Cloud Storage location. Supports importing individual files as
     * well as entire Google Cloud Storage directories. Sample formats:
     * - `gs://bucket_name/my_directory/object_name/my_file.txt`
     * - `gs://bucket_name/my_directory`
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GcsSource gcs_source = 2;</code>
     *
     * @return Whether the gcsSource field is set.
     */
    @java.lang.Override
    public boolean hasGcsSource() {
      return importSourceCase_ == 2;
    }

    /**
     *
     *
     * <pre>
     * Google Cloud Storage location. Supports importing individual files as
     * well as entire Google Cloud Storage directories. Sample formats:
     * - `gs://bucket_name/my_directory/object_name/my_file.txt`
     * - `gs://bucket_name/my_directory`
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GcsSource gcs_source = 2;</code>
     *
     * @return The gcsSource.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.GcsSource getGcsSource() {
      if (gcsSourceBuilder_ == null) {
        if (importSourceCase_ == 2) {
          return (com.google.cloud.aiplatform.v1beta1.GcsSource) importSource_;
        }
        return com.google.cloud.aiplatform.v1beta1.GcsSource.getDefaultInstance();
      } else {
        if (importSourceCase_ == 2) {
          return gcsSourceBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1beta1.GcsSource.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Google Cloud Storage location. Supports importing individual files as
     * well as entire Google Cloud Storage directories. Sample formats:
     * - `gs://bucket_name/my_directory/object_name/my_file.txt`
     * - `gs://bucket_name/my_directory`
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GcsSource gcs_source = 2;</code>
     */
    public Builder setGcsSource(com.google.cloud.aiplatform.v1beta1.GcsSource value) {
      if (gcsSourceBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        importSource_ = value;
        onChanged();
      } else {
        gcsSourceBuilder_.setMessage(value);
      }
      importSourceCase_ = 2;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Google Cloud Storage location. Supports importing individual files as
     * well as entire Google Cloud Storage directories. Sample formats:
     * - `gs://bucket_name/my_directory/object_name/my_file.txt`
     * - `gs://bucket_name/my_directory`
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GcsSource gcs_source = 2;</code>
     */
    public Builder setGcsSource(
        com.google.cloud.aiplatform.v1beta1.GcsSource.Builder builderForValue) {
      if (gcsSourceBuilder_ == null) {
        importSource_ = builderForValue.build();
        onChanged();
      } else {
        gcsSourceBuilder_.setMessage(builderForValue.build());
      }
      importSourceCase_ = 2;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Google Cloud Storage location. Supports importing individual files as
     * well as entire Google Cloud Storage directories. Sample formats:
     * - `gs://bucket_name/my_directory/object_name/my_file.txt`
     * - `gs://bucket_name/my_directory`
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GcsSource gcs_source = 2;</code>
     */
    public Builder mergeGcsSource(com.google.cloud.aiplatform.v1beta1.GcsSource value) {
      if (gcsSourceBuilder_ == null) {
        if (importSourceCase_ == 2
            && importSource_
                != com.google.cloud.aiplatform.v1beta1.GcsSource.getDefaultInstance()) {
          importSource_ =
              com.google.cloud.aiplatform.v1beta1.GcsSource.newBuilder(
                      (com.google.cloud.aiplatform.v1beta1.GcsSource) importSource_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          importSource_ = value;
        }
        onChanged();
      } else {
        if (importSourceCase_ == 2) {
          gcsSourceBuilder_.mergeFrom(value);
        } else {
          gcsSourceBuilder_.setMessage(value);
        }
      }
      importSourceCase_ = 2;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Google Cloud Storage location. Supports importing individual files as
     * well as entire Google Cloud Storage directories. Sample formats:
     * - `gs://bucket_name/my_directory/object_name/my_file.txt`
     * - `gs://bucket_name/my_directory`
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GcsSource gcs_source = 2;</code>
     */
    public Builder clearGcsSource() {
      if (gcsSourceBuilder_ == null) {
        if (importSourceCase_ == 2) {
          importSourceCase_ = 0;
          importSource_ = null;
          onChanged();
        }
      } else {
        if (importSourceCase_ == 2) {
          importSourceCase_ = 0;
          importSource_ = null;
        }
        gcsSourceBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Google Cloud Storage location. Supports importing individual files as
     * well as entire Google Cloud Storage directories. Sample formats:
     * - `gs://bucket_name/my_directory/object_name/my_file.txt`
     * - `gs://bucket_name/my_directory`
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GcsSource gcs_source = 2;</code>
     */
    public com.google.cloud.aiplatform.v1beta1.GcsSource.Builder getGcsSourceBuilder() {
      return getGcsSourceFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Google Cloud Storage location. Supports importing individual files as
     * well as entire Google Cloud Storage directories. Sample formats:
     * - `gs://bucket_name/my_directory/object_name/my_file.txt`
     * - `gs://bucket_name/my_directory`
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GcsSource gcs_source = 2;</code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.GcsSourceOrBuilder getGcsSourceOrBuilder() {
      if ((importSourceCase_ == 2) && (gcsSourceBuilder_ != null)) {
        return gcsSourceBuilder_.getMessageOrBuilder();
      } else {
        if (importSourceCase_ == 2) {
          return (com.google.cloud.aiplatform.v1beta1.GcsSource) importSource_;
        }
        return com.google.cloud.aiplatform.v1beta1.GcsSource.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Google Cloud Storage location. Supports importing individual files as
     * well as entire Google Cloud Storage directories. Sample formats:
     * - `gs://bucket_name/my_directory/object_name/my_file.txt`
     * - `gs://bucket_name/my_directory`
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GcsSource gcs_source = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.GcsSource,
            com.google.cloud.aiplatform.v1beta1.GcsSource.Builder,
            com.google.cloud.aiplatform.v1beta1.GcsSourceOrBuilder>
        getGcsSourceFieldBuilder() {
      if (gcsSourceBuilder_ == null) {
        if (!(importSourceCase_ == 2)) {
          importSource_ = com.google.cloud.aiplatform.v1beta1.GcsSource.getDefaultInstance();
        }
        gcsSourceBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.GcsSource,
                com.google.cloud.aiplatform.v1beta1.GcsSource.Builder,
                com.google.cloud.aiplatform.v1beta1.GcsSourceOrBuilder>(
                (com.google.cloud.aiplatform.v1beta1.GcsSource) importSource_,
                getParentForChildren(),
                isClean());
        importSource_ = null;
      }
      importSourceCase_ = 2;
      onChanged();
      return gcsSourceBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.GoogleDriveSource,
            com.google.cloud.aiplatform.v1beta1.GoogleDriveSource.Builder,
            com.google.cloud.aiplatform.v1beta1.GoogleDriveSourceOrBuilder>
        googleDriveSourceBuilder_;

    /**
     *
     *
     * <pre>
     * Google Drive location. Supports importing individual files as
     * well as Google Drive folders.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GoogleDriveSource google_drive_source = 3;</code>
     *
     * @return Whether the googleDriveSource field is set.
     */
    @java.lang.Override
    public boolean hasGoogleDriveSource() {
      return importSourceCase_ == 3;
    }

    /**
     *
     *
     * <pre>
     * Google Drive location. Supports importing individual files as
     * well as Google Drive folders.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GoogleDriveSource google_drive_source = 3;</code>
     *
     * @return The googleDriveSource.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.GoogleDriveSource getGoogleDriveSource() {
      if (googleDriveSourceBuilder_ == null) {
        if (importSourceCase_ == 3) {
          return (com.google.cloud.aiplatform.v1beta1.GoogleDriveSource) importSource_;
        }
        return com.google.cloud.aiplatform.v1beta1.GoogleDriveSource.getDefaultInstance();
      } else {
        if (importSourceCase_ == 3) {
          return googleDriveSourceBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1beta1.GoogleDriveSource.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Google Drive location. Supports importing individual files as
     * well as Google Drive folders.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GoogleDriveSource google_drive_source = 3;</code>
     */
    public Builder setGoogleDriveSource(
        com.google.cloud.aiplatform.v1beta1.GoogleDriveSource value) {
      if (googleDriveSourceBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        importSource_ = value;
        onChanged();
      } else {
        googleDriveSourceBuilder_.setMessage(value);
      }
      importSourceCase_ = 3;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Google Drive location. Supports importing individual files as
     * well as Google Drive folders.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GoogleDriveSource google_drive_source = 3;</code>
     */
    public Builder setGoogleDriveSource(
        com.google.cloud.aiplatform.v1beta1.GoogleDriveSource.Builder builderForValue) {
      if (googleDriveSourceBuilder_ == null) {
        importSource_ = builderForValue.build();
        onChanged();
      } else {
        googleDriveSourceBuilder_.setMessage(builderForValue.build());
      }
      importSourceCase_ = 3;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Google Drive location. Supports importing individual files as
     * well as Google Drive folders.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GoogleDriveSource google_drive_source = 3;</code>
     */
    public Builder mergeGoogleDriveSource(
        com.google.cloud.aiplatform.v1beta1.GoogleDriveSource value) {
      if (googleDriveSourceBuilder_ == null) {
        if (importSourceCase_ == 3
            && importSource_
                != com.google.cloud.aiplatform.v1beta1.GoogleDriveSource.getDefaultInstance()) {
          importSource_ =
              com.google.cloud.aiplatform.v1beta1.GoogleDriveSource.newBuilder(
                      (com.google.cloud.aiplatform.v1beta1.GoogleDriveSource) importSource_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          importSource_ = value;
        }
        onChanged();
      } else {
        if (importSourceCase_ == 3) {
          googleDriveSourceBuilder_.mergeFrom(value);
        } else {
          googleDriveSourceBuilder_.setMessage(value);
        }
      }
      importSourceCase_ = 3;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Google Drive location. Supports importing individual files as
     * well as Google Drive folders.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GoogleDriveSource google_drive_source = 3;</code>
     */
    public Builder clearGoogleDriveSource() {
      if (googleDriveSourceBuilder_ == null) {
        if (importSourceCase_ == 3) {
          importSourceCase_ = 0;
          importSource_ = null;
          onChanged();
        }
      } else {
        if (importSourceCase_ == 3) {
          importSourceCase_ = 0;
          importSource_ = null;
        }
        googleDriveSourceBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Google Drive location. Supports importing individual files as
     * well as Google Drive folders.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GoogleDriveSource google_drive_source = 3;</code>
     */
    public com.google.cloud.aiplatform.v1beta1.GoogleDriveSource.Builder
        getGoogleDriveSourceBuilder() {
      return getGoogleDriveSourceFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Google Drive location. Supports importing individual files as
     * well as Google Drive folders.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GoogleDriveSource google_drive_source = 3;</code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.GoogleDriveSourceOrBuilder
        getGoogleDriveSourceOrBuilder() {
      if ((importSourceCase_ == 3) && (googleDriveSourceBuilder_ != null)) {
        return googleDriveSourceBuilder_.getMessageOrBuilder();
      } else {
        if (importSourceCase_ == 3) {
          return (com.google.cloud.aiplatform.v1beta1.GoogleDriveSource) importSource_;
        }
        return com.google.cloud.aiplatform.v1beta1.GoogleDriveSource.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Google Drive location. Supports importing individual files as
     * well as Google Drive folders.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GoogleDriveSource google_drive_source = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.GoogleDriveSource,
            com.google.cloud.aiplatform.v1beta1.GoogleDriveSource.Builder,
            com.google.cloud.aiplatform.v1beta1.GoogleDriveSourceOrBuilder>
        getGoogleDriveSourceFieldBuilder() {
      if (googleDriveSourceBuilder_ == null) {
        if (!(importSourceCase_ == 3)) {
          importSource_ =
              com.google.cloud.aiplatform.v1beta1.GoogleDriveSource.getDefaultInstance();
        }
        googleDriveSourceBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.GoogleDriveSource,
                com.google.cloud.aiplatform.v1beta1.GoogleDriveSource.Builder,
                com.google.cloud.aiplatform.v1beta1.GoogleDriveSourceOrBuilder>(
                (com.google.cloud.aiplatform.v1beta1.GoogleDriveSource) importSource_,
                getParentForChildren(),
                isClean());
        importSource_ = null;
      }
      importSourceCase_ = 3;
      onChanged();
      return googleDriveSourceBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.SlackSource,
            com.google.cloud.aiplatform.v1beta1.SlackSource.Builder,
            com.google.cloud.aiplatform.v1beta1.SlackSourceOrBuilder>
        slackSourceBuilder_;

    /**
     *
     *
     * <pre>
     * Slack channels with their corresponding access tokens.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.SlackSource slack_source = 6;</code>
     *
     * @return Whether the slackSource field is set.
     */
    @java.lang.Override
    public boolean hasSlackSource() {
      return importSourceCase_ == 6;
    }

    /**
     *
     *
     * <pre>
     * Slack channels with their corresponding access tokens.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.SlackSource slack_source = 6;</code>
     *
     * @return The slackSource.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.SlackSource getSlackSource() {
      if (slackSourceBuilder_ == null) {
        if (importSourceCase_ == 6) {
          return (com.google.cloud.aiplatform.v1beta1.SlackSource) importSource_;
        }
        return com.google.cloud.aiplatform.v1beta1.SlackSource.getDefaultInstance();
      } else {
        if (importSourceCase_ == 6) {
          return slackSourceBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1beta1.SlackSource.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Slack channels with their corresponding access tokens.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.SlackSource slack_source = 6;</code>
     */
    public Builder setSlackSource(com.google.cloud.aiplatform.v1beta1.SlackSource value) {
      if (slackSourceBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        importSource_ = value;
        onChanged();
      } else {
        slackSourceBuilder_.setMessage(value);
      }
      importSourceCase_ = 6;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Slack channels with their corresponding access tokens.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.SlackSource slack_source = 6;</code>
     */
    public Builder setSlackSource(
        com.google.cloud.aiplatform.v1beta1.SlackSource.Builder builderForValue) {
      if (slackSourceBuilder_ == null) {
        importSource_ = builderForValue.build();
        onChanged();
      } else {
        slackSourceBuilder_.setMessage(builderForValue.build());
      }
      importSourceCase_ = 6;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Slack channels with their corresponding access tokens.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.SlackSource slack_source = 6;</code>
     */
    public Builder mergeSlackSource(com.google.cloud.aiplatform.v1beta1.SlackSource value) {
      if (slackSourceBuilder_ == null) {
        if (importSourceCase_ == 6
            && importSource_
                != com.google.cloud.aiplatform.v1beta1.SlackSource.getDefaultInstance()) {
          importSource_ =
              com.google.cloud.aiplatform.v1beta1.SlackSource.newBuilder(
                      (com.google.cloud.aiplatform.v1beta1.SlackSource) importSource_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          importSource_ = value;
        }
        onChanged();
      } else {
        if (importSourceCase_ == 6) {
          slackSourceBuilder_.mergeFrom(value);
        } else {
          slackSourceBuilder_.setMessage(value);
        }
      }
      importSourceCase_ = 6;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Slack channels with their corresponding access tokens.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.SlackSource slack_source = 6;</code>
     */
    public Builder clearSlackSource() {
      if (slackSourceBuilder_ == null) {
        if (importSourceCase_ == 6) {
          importSourceCase_ = 0;
          importSource_ = null;
          onChanged();
        }
      } else {
        if (importSourceCase_ == 6) {
          importSourceCase_ = 0;
          importSource_ = null;
        }
        slackSourceBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Slack channels with their corresponding access tokens.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.SlackSource slack_source = 6;</code>
     */
    public com.google.cloud.aiplatform.v1beta1.SlackSource.Builder getSlackSourceBuilder() {
      return getSlackSourceFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Slack channels with their corresponding access tokens.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.SlackSource slack_source = 6;</code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.SlackSourceOrBuilder getSlackSourceOrBuilder() {
      if ((importSourceCase_ == 6) && (slackSourceBuilder_ != null)) {
        return slackSourceBuilder_.getMessageOrBuilder();
      } else {
        if (importSourceCase_ == 6) {
          return (com.google.cloud.aiplatform.v1beta1.SlackSource) importSource_;
        }
        return com.google.cloud.aiplatform.v1beta1.SlackSource.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Slack channels with their corresponding access tokens.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.SlackSource slack_source = 6;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.SlackSource,
            com.google.cloud.aiplatform.v1beta1.SlackSource.Builder,
            com.google.cloud.aiplatform.v1beta1.SlackSourceOrBuilder>
        getSlackSourceFieldBuilder() {
      if (slackSourceBuilder_ == null) {
        if (!(importSourceCase_ == 6)) {
          importSource_ = com.google.cloud.aiplatform.v1beta1.SlackSource.getDefaultInstance();
        }
        slackSourceBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.SlackSource,
                com.google.cloud.aiplatform.v1beta1.SlackSource.Builder,
                com.google.cloud.aiplatform.v1beta1.SlackSourceOrBuilder>(
                (com.google.cloud.aiplatform.v1beta1.SlackSource) importSource_,
                getParentForChildren(),
                isClean());
        importSource_ = null;
      }
      importSourceCase_ = 6;
      onChanged();
      return slackSourceBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.JiraSource,
            com.google.cloud.aiplatform.v1beta1.JiraSource.Builder,
            com.google.cloud.aiplatform.v1beta1.JiraSourceOrBuilder>
        jiraSourceBuilder_;

    /**
     *
     *
     * <pre>
     * Jira queries with their corresponding authentication.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.JiraSource jira_source = 7;</code>
     *
     * @return Whether the jiraSource field is set.
     */
    @java.lang.Override
    public boolean hasJiraSource() {
      return importSourceCase_ == 7;
    }

    /**
     *
     *
     * <pre>
     * Jira queries with their corresponding authentication.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.JiraSource jira_source = 7;</code>
     *
     * @return The jiraSource.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.JiraSource getJiraSource() {
      if (jiraSourceBuilder_ == null) {
        if (importSourceCase_ == 7) {
          return (com.google.cloud.aiplatform.v1beta1.JiraSource) importSource_;
        }
        return com.google.cloud.aiplatform.v1beta1.JiraSource.getDefaultInstance();
      } else {
        if (importSourceCase_ == 7) {
          return jiraSourceBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1beta1.JiraSource.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Jira queries with their corresponding authentication.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.JiraSource jira_source = 7;</code>
     */
    public Builder setJiraSource(com.google.cloud.aiplatform.v1beta1.JiraSource value) {
      if (jiraSourceBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        importSource_ = value;
        onChanged();
      } else {
        jiraSourceBuilder_.setMessage(value);
      }
      importSourceCase_ = 7;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Jira queries with their corresponding authentication.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.JiraSource jira_source = 7;</code>
     */
    public Builder setJiraSource(
        com.google.cloud.aiplatform.v1beta1.JiraSource.Builder builderForValue) {
      if (jiraSourceBuilder_ == null) {
        importSource_ = builderForValue.build();
        onChanged();
      } else {
        jiraSourceBuilder_.setMessage(builderForValue.build());
      }
      importSourceCase_ = 7;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Jira queries with their corresponding authentication.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.JiraSource jira_source = 7;</code>
     */
    public Builder mergeJiraSource(com.google.cloud.aiplatform.v1beta1.JiraSource value) {
      if (jiraSourceBuilder_ == null) {
        if (importSourceCase_ == 7
            && importSource_
                != com.google.cloud.aiplatform.v1beta1.JiraSource.getDefaultInstance()) {
          importSource_ =
              com.google.cloud.aiplatform.v1beta1.JiraSource.newBuilder(
                      (com.google.cloud.aiplatform.v1beta1.JiraSource) importSource_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          importSource_ = value;
        }
        onChanged();
      } else {
        if (importSourceCase_ == 7) {
          jiraSourceBuilder_.mergeFrom(value);
        } else {
          jiraSourceBuilder_.setMessage(value);
        }
      }
      importSourceCase_ = 7;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Jira queries with their corresponding authentication.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.JiraSource jira_source = 7;</code>
     */
    public Builder clearJiraSource() {
      if (jiraSourceBuilder_ == null) {
        if (importSourceCase_ == 7) {
          importSourceCase_ = 0;
          importSource_ = null;
          onChanged();
        }
      } else {
        if (importSourceCase_ == 7) {
          importSourceCase_ = 0;
          importSource_ = null;
        }
        jiraSourceBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Jira queries with their corresponding authentication.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.JiraSource jira_source = 7;</code>
     */
    public com.google.cloud.aiplatform.v1beta1.JiraSource.Builder getJiraSourceBuilder() {
      return getJiraSourceFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Jira queries with their corresponding authentication.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.JiraSource jira_source = 7;</code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.JiraSourceOrBuilder getJiraSourceOrBuilder() {
      if ((importSourceCase_ == 7) && (jiraSourceBuilder_ != null)) {
        return jiraSourceBuilder_.getMessageOrBuilder();
      } else {
        if (importSourceCase_ == 7) {
          return (com.google.cloud.aiplatform.v1beta1.JiraSource) importSource_;
        }
        return com.google.cloud.aiplatform.v1beta1.JiraSource.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Jira queries with their corresponding authentication.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.JiraSource jira_source = 7;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.JiraSource,
            com.google.cloud.aiplatform.v1beta1.JiraSource.Builder,
            com.google.cloud.aiplatform.v1beta1.JiraSourceOrBuilder>
        getJiraSourceFieldBuilder() {
      if (jiraSourceBuilder_ == null) {
        if (!(importSourceCase_ == 7)) {
          importSource_ = com.google.cloud.aiplatform.v1beta1.JiraSource.getDefaultInstance();
        }
        jiraSourceBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.JiraSource,
                com.google.cloud.aiplatform.v1beta1.JiraSource.Builder,
                com.google.cloud.aiplatform.v1beta1.JiraSourceOrBuilder>(
                (com.google.cloud.aiplatform.v1beta1.JiraSource) importSource_,
                getParentForChildren(),
                isClean());
        importSource_ = null;
      }
      importSourceCase_ = 7;
      onChanged();
      return jiraSourceBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.SharePointSources,
            com.google.cloud.aiplatform.v1beta1.SharePointSources.Builder,
            com.google.cloud.aiplatform.v1beta1.SharePointSourcesOrBuilder>
        sharePointSourcesBuilder_;

    /**
     *
     *
     * <pre>
     * SharePoint sources.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.SharePointSources share_point_sources = 13;</code>
     *
     * @return Whether the sharePointSources field is set.
     */
    @java.lang.Override
    public boolean hasSharePointSources() {
      return importSourceCase_ == 13;
    }

    /**
     *
     *
     * <pre>
     * SharePoint sources.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.SharePointSources share_point_sources = 13;</code>
     *
     * @return The sharePointSources.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.SharePointSources getSharePointSources() {
      if (sharePointSourcesBuilder_ == null) {
        if (importSourceCase_ == 13) {
          return (com.google.cloud.aiplatform.v1beta1.SharePointSources) importSource_;
        }
        return com.google.cloud.aiplatform.v1beta1.SharePointSources.getDefaultInstance();
      } else {
        if (importSourceCase_ == 13) {
          return sharePointSourcesBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1beta1.SharePointSources.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * SharePoint sources.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.SharePointSources share_point_sources = 13;</code>
     */
    public Builder setSharePointSources(
        com.google.cloud.aiplatform.v1beta1.SharePointSources value) {
      if (sharePointSourcesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        importSource_ = value;
        onChanged();
      } else {
        sharePointSourcesBuilder_.setMessage(value);
      }
      importSourceCase_ = 13;
      return this;
    }

    /**
     *
     *
     * <pre>
     * SharePoint sources.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.SharePointSources share_point_sources = 13;</code>
     */
    public Builder setSharePointSources(
        com.google.cloud.aiplatform.v1beta1.SharePointSources.Builder builderForValue) {
      if (sharePointSourcesBuilder_ == null) {
        importSource_ = builderForValue.build();
        onChanged();
      } else {
        sharePointSourcesBuilder_.setMessage(builderForValue.build());
      }
      importSourceCase_ = 13;
      return this;
    }

    /**
     *
     *
     * <pre>
     * SharePoint sources.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.SharePointSources share_point_sources = 13;</code>
     */
    public Builder mergeSharePointSources(
        com.google.cloud.aiplatform.v1beta1.SharePointSources value) {
      if (sharePointSourcesBuilder_ == null) {
        if (importSourceCase_ == 13
            && importSource_
                != com.google.cloud.aiplatform.v1beta1.SharePointSources.getDefaultInstance()) {
          importSource_ =
              com.google.cloud.aiplatform.v1beta1.SharePointSources.newBuilder(
                      (com.google.cloud.aiplatform.v1beta1.SharePointSources) importSource_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          importSource_ = value;
        }
        onChanged();
      } else {
        if (importSourceCase_ == 13) {
          sharePointSourcesBuilder_.mergeFrom(value);
        } else {
          sharePointSourcesBuilder_.setMessage(value);
        }
      }
      importSourceCase_ = 13;
      return this;
    }

    /**
     *
     *
     * <pre>
     * SharePoint sources.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.SharePointSources share_point_sources = 13;</code>
     */
    public Builder clearSharePointSources() {
      if (sharePointSourcesBuilder_ == null) {
        if (importSourceCase_ == 13) {
          importSourceCase_ = 0;
          importSource_ = null;
          onChanged();
        }
      } else {
        if (importSourceCase_ == 13) {
          importSourceCase_ = 0;
          importSource_ = null;
        }
        sharePointSourcesBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * SharePoint sources.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.SharePointSources share_point_sources = 13;</code>
     */
    public com.google.cloud.aiplatform.v1beta1.SharePointSources.Builder
        getSharePointSourcesBuilder() {
      return getSharePointSourcesFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * SharePoint sources.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.SharePointSources share_point_sources = 13;</code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.SharePointSourcesOrBuilder
        getSharePointSourcesOrBuilder() {
      if ((importSourceCase_ == 13) && (sharePointSourcesBuilder_ != null)) {
        return sharePointSourcesBuilder_.getMessageOrBuilder();
      } else {
        if (importSourceCase_ == 13) {
          return (com.google.cloud.aiplatform.v1beta1.SharePointSources) importSource_;
        }
        return com.google.cloud.aiplatform.v1beta1.SharePointSources.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * SharePoint sources.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.SharePointSources share_point_sources = 13;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.SharePointSources,
            com.google.cloud.aiplatform.v1beta1.SharePointSources.Builder,
            com.google.cloud.aiplatform.v1beta1.SharePointSourcesOrBuilder>
        getSharePointSourcesFieldBuilder() {
      if (sharePointSourcesBuilder_ == null) {
        if (!(importSourceCase_ == 13)) {
          importSource_ =
              com.google.cloud.aiplatform.v1beta1.SharePointSources.getDefaultInstance();
        }
        sharePointSourcesBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.SharePointSources,
                com.google.cloud.aiplatform.v1beta1.SharePointSources.Builder,
                com.google.cloud.aiplatform.v1beta1.SharePointSourcesOrBuilder>(
                (com.google.cloud.aiplatform.v1beta1.SharePointSources) importSource_,
                getParentForChildren(),
                isClean());
        importSource_ = null;
      }
      importSourceCase_ = 13;
      onChanged();
      return sharePointSourcesBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.GcsDestination,
            com.google.cloud.aiplatform.v1beta1.GcsDestination.Builder,
            com.google.cloud.aiplatform.v1beta1.GcsDestinationOrBuilder>
        partialFailureGcsSinkBuilder_;

    /**
     *
     *
     * <pre>
     * The Cloud Storage path to write partial failures to.
     * Deprecated. Prefer to use `import_result_gcs_sink`.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.GcsDestination partial_failure_gcs_sink = 11 [deprecated = true];
     * </code>
     *
     * @deprecated google.cloud.aiplatform.v1beta1.ImportRagFilesConfig.partial_failure_gcs_sink is
     *     deprecated. See google/cloud/aiplatform/v1beta1/vertex_rag_data.proto;l=605
     * @return Whether the partialFailureGcsSink field is set.
     */
    @java.lang.Override
    @java.lang.Deprecated
    public boolean hasPartialFailureGcsSink() {
      return partialFailureSinkCase_ == 11;
    }

    /**
     *
     *
     * <pre>
     * The Cloud Storage path to write partial failures to.
     * Deprecated. Prefer to use `import_result_gcs_sink`.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.GcsDestination partial_failure_gcs_sink = 11 [deprecated = true];
     * </code>
     *
     * @deprecated google.cloud.aiplatform.v1beta1.ImportRagFilesConfig.partial_failure_gcs_sink is
     *     deprecated. See google/cloud/aiplatform/v1beta1/vertex_rag_data.proto;l=605
     * @return The partialFailureGcsSink.
     */
    @java.lang.Override
    @java.lang.Deprecated
    public com.google.cloud.aiplatform.v1beta1.GcsDestination getPartialFailureGcsSink() {
      if (partialFailureGcsSinkBuilder_ == null) {
        if (partialFailureSinkCase_ == 11) {
          return (com.google.cloud.aiplatform.v1beta1.GcsDestination) partialFailureSink_;
        }
        return com.google.cloud.aiplatform.v1beta1.GcsDestination.getDefaultInstance();
      } else {
        if (partialFailureSinkCase_ == 11) {
          return partialFailureGcsSinkBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1beta1.GcsDestination.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * The Cloud Storage path to write partial failures to.
     * Deprecated. Prefer to use `import_result_gcs_sink`.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.GcsDestination partial_failure_gcs_sink = 11 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder setPartialFailureGcsSink(
        com.google.cloud.aiplatform.v1beta1.GcsDestination value) {
      if (partialFailureGcsSinkBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        partialFailureSink_ = value;
        onChanged();
      } else {
        partialFailureGcsSinkBuilder_.setMessage(value);
      }
      partialFailureSinkCase_ = 11;
      return this;
    }

    /**
     *
     *
     * <pre>
     * The Cloud Storage path to write partial failures to.
     * Deprecated. Prefer to use `import_result_gcs_sink`.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.GcsDestination partial_failure_gcs_sink = 11 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder setPartialFailureGcsSink(
        com.google.cloud.aiplatform.v1beta1.GcsDestination.Builder builderForValue) {
      if (partialFailureGcsSinkBuilder_ == null) {
        partialFailureSink_ = builderForValue.build();
        onChanged();
      } else {
        partialFailureGcsSinkBuilder_.setMessage(builderForValue.build());
      }
      partialFailureSinkCase_ = 11;
      return this;
    }

    /**
     *
     *
     * <pre>
     * The Cloud Storage path to write partial failures to.
     * Deprecated. Prefer to use `import_result_gcs_sink`.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.GcsDestination partial_failure_gcs_sink = 11 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder mergePartialFailureGcsSink(
        com.google.cloud.aiplatform.v1beta1.GcsDestination value) {
      if (partialFailureGcsSinkBuilder_ == null) {
        if (partialFailureSinkCase_ == 11
            && partialFailureSink_
                != com.google.cloud.aiplatform.v1beta1.GcsDestination.getDefaultInstance()) {
          partialFailureSink_ =
              com.google.cloud.aiplatform.v1beta1.GcsDestination.newBuilder(
                      (com.google.cloud.aiplatform.v1beta1.GcsDestination) partialFailureSink_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          partialFailureSink_ = value;
        }
        onChanged();
      } else {
        if (partialFailureSinkCase_ == 11) {
          partialFailureGcsSinkBuilder_.mergeFrom(value);
        } else {
          partialFailureGcsSinkBuilder_.setMessage(value);
        }
      }
      partialFailureSinkCase_ = 11;
      return this;
    }

    /**
     *
     *
     * <pre>
     * The Cloud Storage path to write partial failures to.
     * Deprecated. Prefer to use `import_result_gcs_sink`.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.GcsDestination partial_failure_gcs_sink = 11 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder clearPartialFailureGcsSink() {
      if (partialFailureGcsSinkBuilder_ == null) {
        if (partialFailureSinkCase_ == 11) {
          partialFailureSinkCase_ = 0;
          partialFailureSink_ = null;
          onChanged();
        }
      } else {
        if (partialFailureSinkCase_ == 11) {
          partialFailureSinkCase_ = 0;
          partialFailureSink_ = null;
        }
        partialFailureGcsSinkBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The Cloud Storage path to write partial failures to.
     * Deprecated. Prefer to use `import_result_gcs_sink`.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.GcsDestination partial_failure_gcs_sink = 11 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public com.google.cloud.aiplatform.v1beta1.GcsDestination.Builder
        getPartialFailureGcsSinkBuilder() {
      return getPartialFailureGcsSinkFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * The Cloud Storage path to write partial failures to.
     * Deprecated. Prefer to use `import_result_gcs_sink`.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.GcsDestination partial_failure_gcs_sink = 11 [deprecated = true];
     * </code>
     */
    @java.lang.Override
    @java.lang.Deprecated
    public com.google.cloud.aiplatform.v1beta1.GcsDestinationOrBuilder
        getPartialFailureGcsSinkOrBuilder() {
      if ((partialFailureSinkCase_ == 11) && (partialFailureGcsSinkBuilder_ != null)) {
        return partialFailureGcsSinkBuilder_.getMessageOrBuilder();
      } else {
        if (partialFailureSinkCase_ == 11) {
          return (com.google.cloud.aiplatform.v1beta1.GcsDestination) partialFailureSink_;
        }
        return com.google.cloud.aiplatform.v1beta1.GcsDestination.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * The Cloud Storage path to write partial failures to.
     * Deprecated. Prefer to use `import_result_gcs_sink`.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.GcsDestination partial_failure_gcs_sink = 11 [deprecated = true];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.GcsDestination,
            com.google.cloud.aiplatform.v1beta1.GcsDestination.Builder,
            com.google.cloud.aiplatform.v1beta1.GcsDestinationOrBuilder>
        getPartialFailureGcsSinkFieldBuilder() {
      if (partialFailureGcsSinkBuilder_ == null) {
        if (!(partialFailureSinkCase_ == 11)) {
          partialFailureSink_ =
              com.google.cloud.aiplatform.v1beta1.GcsDestination.getDefaultInstance();
        }
        partialFailureGcsSinkBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.GcsDestination,
                com.google.cloud.aiplatform.v1beta1.GcsDestination.Builder,
                com.google.cloud.aiplatform.v1beta1.GcsDestinationOrBuilder>(
                (com.google.cloud.aiplatform.v1beta1.GcsDestination) partialFailureSink_,
                getParentForChildren(),
                isClean());
        partialFailureSink_ = null;
      }
      partialFailureSinkCase_ = 11;
      onChanged();
      return partialFailureGcsSinkBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.BigQueryDestination,
            com.google.cloud.aiplatform.v1beta1.BigQueryDestination.Builder,
            com.google.cloud.aiplatform.v1beta1.BigQueryDestinationOrBuilder>
        partialFailureBigquerySinkBuilder_;

    /**
     *
     *
     * <pre>
     * The BigQuery destination to write partial failures to. It should be a
     * bigquery table resource name (e.g.
     * "bq://projectId.bqDatasetId.bqTableId"). The dataset must exist. If the
     * table does not exist, it will be created with the expected schema. If the
     * table exists, the schema will be validated and data will be added to this
     * existing table.
     * Deprecated. Prefer to use `import_result_bq_sink`.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.BigQueryDestination partial_failure_bigquery_sink = 12 [deprecated = true];
     * </code>
     *
     * @deprecated
     *     google.cloud.aiplatform.v1beta1.ImportRagFilesConfig.partial_failure_bigquery_sink is
     *     deprecated. See google/cloud/aiplatform/v1beta1/vertex_rag_data.proto;l=614
     * @return Whether the partialFailureBigquerySink field is set.
     */
    @java.lang.Override
    @java.lang.Deprecated
    public boolean hasPartialFailureBigquerySink() {
      return partialFailureSinkCase_ == 12;
    }

    /**
     *
     *
     * <pre>
     * The BigQuery destination to write partial failures to. It should be a
     * bigquery table resource name (e.g.
     * "bq://projectId.bqDatasetId.bqTableId"). The dataset must exist. If the
     * table does not exist, it will be created with the expected schema. If the
     * table exists, the schema will be validated and data will be added to this
     * existing table.
     * Deprecated. Prefer to use `import_result_bq_sink`.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.BigQueryDestination partial_failure_bigquery_sink = 12 [deprecated = true];
     * </code>
     *
     * @deprecated
     *     google.cloud.aiplatform.v1beta1.ImportRagFilesConfig.partial_failure_bigquery_sink is
     *     deprecated. See google/cloud/aiplatform/v1beta1/vertex_rag_data.proto;l=614
     * @return The partialFailureBigquerySink.
     */
    @java.lang.Override
    @java.lang.Deprecated
    public com.google.cloud.aiplatform.v1beta1.BigQueryDestination getPartialFailureBigquerySink() {
      if (partialFailureBigquerySinkBuilder_ == null) {
        if (partialFailureSinkCase_ == 12) {
          return (com.google.cloud.aiplatform.v1beta1.BigQueryDestination) partialFailureSink_;
        }
        return com.google.cloud.aiplatform.v1beta1.BigQueryDestination.getDefaultInstance();
      } else {
        if (partialFailureSinkCase_ == 12) {
          return partialFailureBigquerySinkBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1beta1.BigQueryDestination.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * The BigQuery destination to write partial failures to. It should be a
     * bigquery table resource name (e.g.
     * "bq://projectId.bqDatasetId.bqTableId"). The dataset must exist. If the
     * table does not exist, it will be created with the expected schema. If the
     * table exists, the schema will be validated and data will be added to this
     * existing table.
     * Deprecated. Prefer to use `import_result_bq_sink`.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.BigQueryDestination partial_failure_bigquery_sink = 12 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder setPartialFailureBigquerySink(
        com.google.cloud.aiplatform.v1beta1.BigQueryDestination value) {
      if (partialFailureBigquerySinkBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        partialFailureSink_ = value;
        onChanged();
      } else {
        partialFailureBigquerySinkBuilder_.setMessage(value);
      }
      partialFailureSinkCase_ = 12;
      return this;
    }

    /**
     *
     *
     * <pre>
     * The BigQuery destination to write partial failures to. It should be a
     * bigquery table resource name (e.g.
     * "bq://projectId.bqDatasetId.bqTableId"). The dataset must exist. If the
     * table does not exist, it will be created with the expected schema. If the
     * table exists, the schema will be validated and data will be added to this
     * existing table.
     * Deprecated. Prefer to use `import_result_bq_sink`.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.BigQueryDestination partial_failure_bigquery_sink = 12 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder setPartialFailureBigquerySink(
        com.google.cloud.aiplatform.v1beta1.BigQueryDestination.Builder builderForValue) {
      if (partialFailureBigquerySinkBuilder_ == null) {
        partialFailureSink_ = builderForValue.build();
        onChanged();
      } else {
        partialFailureBigquerySinkBuilder_.setMessage(builderForValue.build());
      }
      partialFailureSinkCase_ = 12;
      return this;
    }

    /**
     *
     *
     * <pre>
     * The BigQuery destination to write partial failures to. It should be a
     * bigquery table resource name (e.g.
     * "bq://projectId.bqDatasetId.bqTableId"). The dataset must exist. If the
     * table does not exist, it will be created with the expected schema. If the
     * table exists, the schema will be validated and data will be added to this
     * existing table.
     * Deprecated. Prefer to use `import_result_bq_sink`.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.BigQueryDestination partial_failure_bigquery_sink = 12 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder mergePartialFailureBigquerySink(
        com.google.cloud.aiplatform.v1beta1.BigQueryDestination value) {
      if (partialFailureBigquerySinkBuilder_ == null) {
        if (partialFailureSinkCase_ == 12
            && partialFailureSink_
                != com.google.cloud.aiplatform.v1beta1.BigQueryDestination.getDefaultInstance()) {
          partialFailureSink_ =
              com.google.cloud.aiplatform.v1beta1.BigQueryDestination.newBuilder(
                      (com.google.cloud.aiplatform.v1beta1.BigQueryDestination) partialFailureSink_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          partialFailureSink_ = value;
        }
        onChanged();
      } else {
        if (partialFailureSinkCase_ == 12) {
          partialFailureBigquerySinkBuilder_.mergeFrom(value);
        } else {
          partialFailureBigquerySinkBuilder_.setMessage(value);
        }
      }
      partialFailureSinkCase_ = 12;
      return this;
    }

    /**
     *
     *
     * <pre>
     * The BigQuery destination to write partial failures to. It should be a
     * bigquery table resource name (e.g.
     * "bq://projectId.bqDatasetId.bqTableId"). The dataset must exist. If the
     * table does not exist, it will be created with the expected schema. If the
     * table exists, the schema will be validated and data will be added to this
     * existing table.
     * Deprecated. Prefer to use `import_result_bq_sink`.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.BigQueryDestination partial_failure_bigquery_sink = 12 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder clearPartialFailureBigquerySink() {
      if (partialFailureBigquerySinkBuilder_ == null) {
        if (partialFailureSinkCase_ == 12) {
          partialFailureSinkCase_ = 0;
          partialFailureSink_ = null;
          onChanged();
        }
      } else {
        if (partialFailureSinkCase_ == 12) {
          partialFailureSinkCase_ = 0;
          partialFailureSink_ = null;
        }
        partialFailureBigquerySinkBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The BigQuery destination to write partial failures to. It should be a
     * bigquery table resource name (e.g.
     * "bq://projectId.bqDatasetId.bqTableId"). The dataset must exist. If the
     * table does not exist, it will be created with the expected schema. If the
     * table exists, the schema will be validated and data will be added to this
     * existing table.
     * Deprecated. Prefer to use `import_result_bq_sink`.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.BigQueryDestination partial_failure_bigquery_sink = 12 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public com.google.cloud.aiplatform.v1beta1.BigQueryDestination.Builder
        getPartialFailureBigquerySinkBuilder() {
      return getPartialFailureBigquerySinkFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * The BigQuery destination to write partial failures to. It should be a
     * bigquery table resource name (e.g.
     * "bq://projectId.bqDatasetId.bqTableId"). The dataset must exist. If the
     * table does not exist, it will be created with the expected schema. If the
     * table exists, the schema will be validated and data will be added to this
     * existing table.
     * Deprecated. Prefer to use `import_result_bq_sink`.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.BigQueryDestination partial_failure_bigquery_sink = 12 [deprecated = true];
     * </code>
     */
    @java.lang.Override
    @java.lang.Deprecated
    public com.google.cloud.aiplatform.v1beta1.BigQueryDestinationOrBuilder
        getPartialFailureBigquerySinkOrBuilder() {
      if ((partialFailureSinkCase_ == 12) && (partialFailureBigquerySinkBuilder_ != null)) {
        return partialFailureBigquerySinkBuilder_.getMessageOrBuilder();
      } else {
        if (partialFailureSinkCase_ == 12) {
          return (com.google.cloud.aiplatform.v1beta1.BigQueryDestination) partialFailureSink_;
        }
        return com.google.cloud.aiplatform.v1beta1.BigQueryDestination.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * The BigQuery destination to write partial failures to. It should be a
     * bigquery table resource name (e.g.
     * "bq://projectId.bqDatasetId.bqTableId"). The dataset must exist. If the
     * table does not exist, it will be created with the expected schema. If the
     * table exists, the schema will be validated and data will be added to this
     * existing table.
     * Deprecated. Prefer to use `import_result_bq_sink`.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.BigQueryDestination partial_failure_bigquery_sink = 12 [deprecated = true];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.BigQueryDestination,
            com.google.cloud.aiplatform.v1beta1.BigQueryDestination.Builder,
            com.google.cloud.aiplatform.v1beta1.BigQueryDestinationOrBuilder>
        getPartialFailureBigquerySinkFieldBuilder() {
      if (partialFailureBigquerySinkBuilder_ == null) {
        if (!(partialFailureSinkCase_ == 12)) {
          partialFailureSink_ =
              com.google.cloud.aiplatform.v1beta1.BigQueryDestination.getDefaultInstance();
        }
        partialFailureBigquerySinkBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.BigQueryDestination,
                com.google.cloud.aiplatform.v1beta1.BigQueryDestination.Builder,
                com.google.cloud.aiplatform.v1beta1.BigQueryDestinationOrBuilder>(
                (com.google.cloud.aiplatform.v1beta1.BigQueryDestination) partialFailureSink_,
                getParentForChildren(),
                isClean());
        partialFailureSink_ = null;
      }
      partialFailureSinkCase_ = 12;
      onChanged();
      return partialFailureBigquerySinkBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.GcsDestination,
            com.google.cloud.aiplatform.v1beta1.GcsDestination.Builder,
            com.google.cloud.aiplatform.v1beta1.GcsDestinationOrBuilder>
        importResultGcsSinkBuilder_;

    /**
     *
     *
     * <pre>
     * The Cloud Storage path to write import result to.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GcsDestination import_result_gcs_sink = 14;</code>
     *
     * @return Whether the importResultGcsSink field is set.
     */
    @java.lang.Override
    public boolean hasImportResultGcsSink() {
      return importResultSinkCase_ == 14;
    }

    /**
     *
     *
     * <pre>
     * The Cloud Storage path to write import result to.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GcsDestination import_result_gcs_sink = 14;</code>
     *
     * @return The importResultGcsSink.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.GcsDestination getImportResultGcsSink() {
      if (importResultGcsSinkBuilder_ == null) {
        if (importResultSinkCase_ == 14) {
          return (com.google.cloud.aiplatform.v1beta1.GcsDestination) importResultSink_;
        }
        return com.google.cloud.aiplatform.v1beta1.GcsDestination.getDefaultInstance();
      } else {
        if (importResultSinkCase_ == 14) {
          return importResultGcsSinkBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1beta1.GcsDestination.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * The Cloud Storage path to write import result to.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GcsDestination import_result_gcs_sink = 14;</code>
     */
    public Builder setImportResultGcsSink(
        com.google.cloud.aiplatform.v1beta1.GcsDestination value) {
      if (importResultGcsSinkBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        importResultSink_ = value;
        onChanged();
      } else {
        importResultGcsSinkBuilder_.setMessage(value);
      }
      importResultSinkCase_ = 14;
      return this;
    }

    /**
     *
     *
     * <pre>
     * The Cloud Storage path to write import result to.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GcsDestination import_result_gcs_sink = 14;</code>
     */
    public Builder setImportResultGcsSink(
        com.google.cloud.aiplatform.v1beta1.GcsDestination.Builder builderForValue) {
      if (importResultGcsSinkBuilder_ == null) {
        importResultSink_ = builderForValue.build();
        onChanged();
      } else {
        importResultGcsSinkBuilder_.setMessage(builderForValue.build());
      }
      importResultSinkCase_ = 14;
      return this;
    }

    /**
     *
     *
     * <pre>
     * The Cloud Storage path to write import result to.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GcsDestination import_result_gcs_sink = 14;</code>
     */
    public Builder mergeImportResultGcsSink(
        com.google.cloud.aiplatform.v1beta1.GcsDestination value) {
      if (importResultGcsSinkBuilder_ == null) {
        if (importResultSinkCase_ == 14
            && importResultSink_
                != com.google.cloud.aiplatform.v1beta1.GcsDestination.getDefaultInstance()) {
          importResultSink_ =
              com.google.cloud.aiplatform.v1beta1.GcsDestination.newBuilder(
                      (com.google.cloud.aiplatform.v1beta1.GcsDestination) importResultSink_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          importResultSink_ = value;
        }
        onChanged();
      } else {
        if (importResultSinkCase_ == 14) {
          importResultGcsSinkBuilder_.mergeFrom(value);
        } else {
          importResultGcsSinkBuilder_.setMessage(value);
        }
      }
      importResultSinkCase_ = 14;
      return this;
    }

    /**
     *
     *
     * <pre>
     * The Cloud Storage path to write import result to.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GcsDestination import_result_gcs_sink = 14;</code>
     */
    public Builder clearImportResultGcsSink() {
      if (importResultGcsSinkBuilder_ == null) {
        if (importResultSinkCase_ == 14) {
          importResultSinkCase_ = 0;
          importResultSink_ = null;
          onChanged();
        }
      } else {
        if (importResultSinkCase_ == 14) {
          importResultSinkCase_ = 0;
          importResultSink_ = null;
        }
        importResultGcsSinkBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The Cloud Storage path to write import result to.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GcsDestination import_result_gcs_sink = 14;</code>
     */
    public com.google.cloud.aiplatform.v1beta1.GcsDestination.Builder
        getImportResultGcsSinkBuilder() {
      return getImportResultGcsSinkFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * The Cloud Storage path to write import result to.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GcsDestination import_result_gcs_sink = 14;</code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.GcsDestinationOrBuilder
        getImportResultGcsSinkOrBuilder() {
      if ((importResultSinkCase_ == 14) && (importResultGcsSinkBuilder_ != null)) {
        return importResultGcsSinkBuilder_.getMessageOrBuilder();
      } else {
        if (importResultSinkCase_ == 14) {
          return (com.google.cloud.aiplatform.v1beta1.GcsDestination) importResultSink_;
        }
        return com.google.cloud.aiplatform.v1beta1.GcsDestination.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * The Cloud Storage path to write import result to.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GcsDestination import_result_gcs_sink = 14;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.GcsDestination,
            com.google.cloud.aiplatform.v1beta1.GcsDestination.Builder,
            com.google.cloud.aiplatform.v1beta1.GcsDestinationOrBuilder>
        getImportResultGcsSinkFieldBuilder() {
      if (importResultGcsSinkBuilder_ == null) {
        if (!(importResultSinkCase_ == 14)) {
          importResultSink_ =
              com.google.cloud.aiplatform.v1beta1.GcsDestination.getDefaultInstance();
        }
        importResultGcsSinkBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.GcsDestination,
                com.google.cloud.aiplatform.v1beta1.GcsDestination.Builder,
                com.google.cloud.aiplatform.v1beta1.GcsDestinationOrBuilder>(
                (com.google.cloud.aiplatform.v1beta1.GcsDestination) importResultSink_,
                getParentForChildren(),
                isClean());
        importResultSink_ = null;
      }
      importResultSinkCase_ = 14;
      onChanged();
      return importResultGcsSinkBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.BigQueryDestination,
            com.google.cloud.aiplatform.v1beta1.BigQueryDestination.Builder,
            com.google.cloud.aiplatform.v1beta1.BigQueryDestinationOrBuilder>
        importResultBigquerySinkBuilder_;

    /**
     *
     *
     * <pre>
     * The BigQuery destination to write import result to. It should be a
     * bigquery table resource name (e.g.
     * "bq://projectId.bqDatasetId.bqTableId"). The dataset must exist. If the
     * table does not exist, it will be created with the expected schema. If the
     * table exists, the schema will be validated and data will be added to this
     * existing table.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.BigQueryDestination import_result_bigquery_sink = 15;
     * </code>
     *
     * @return Whether the importResultBigquerySink field is set.
     */
    @java.lang.Override
    public boolean hasImportResultBigquerySink() {
      return importResultSinkCase_ == 15;
    }

    /**
     *
     *
     * <pre>
     * The BigQuery destination to write import result to. It should be a
     * bigquery table resource name (e.g.
     * "bq://projectId.bqDatasetId.bqTableId"). The dataset must exist. If the
     * table does not exist, it will be created with the expected schema. If the
     * table exists, the schema will be validated and data will be added to this
     * existing table.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.BigQueryDestination import_result_bigquery_sink = 15;
     * </code>
     *
     * @return The importResultBigquerySink.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.BigQueryDestination getImportResultBigquerySink() {
      if (importResultBigquerySinkBuilder_ == null) {
        if (importResultSinkCase_ == 15) {
          return (com.google.cloud.aiplatform.v1beta1.BigQueryDestination) importResultSink_;
        }
        return com.google.cloud.aiplatform.v1beta1.BigQueryDestination.getDefaultInstance();
      } else {
        if (importResultSinkCase_ == 15) {
          return importResultBigquerySinkBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1beta1.BigQueryDestination.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * The BigQuery destination to write import result to. It should be a
     * bigquery table resource name (e.g.
     * "bq://projectId.bqDatasetId.bqTableId"). The dataset must exist. If the
     * table does not exist, it will be created with the expected schema. If the
     * table exists, the schema will be validated and data will be added to this
     * existing table.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.BigQueryDestination import_result_bigquery_sink = 15;
     * </code>
     */
    public Builder setImportResultBigquerySink(
        com.google.cloud.aiplatform.v1beta1.BigQueryDestination value) {
      if (importResultBigquerySinkBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        importResultSink_ = value;
        onChanged();
      } else {
        importResultBigquerySinkBuilder_.setMessage(value);
      }
      importResultSinkCase_ = 15;
      return this;
    }

    /**
     *
     *
     * <pre>
     * The BigQuery destination to write import result to. It should be a
     * bigquery table resource name (e.g.
     * "bq://projectId.bqDatasetId.bqTableId"). The dataset must exist. If the
     * table does not exist, it will be created with the expected schema. If the
     * table exists, the schema will be validated and data will be added to this
     * existing table.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.BigQueryDestination import_result_bigquery_sink = 15;
     * </code>
     */
    public Builder setImportResultBigquerySink(
        com.google.cloud.aiplatform.v1beta1.BigQueryDestination.Builder builderForValue) {
      if (importResultBigquerySinkBuilder_ == null) {
        importResultSink_ = builderForValue.build();
        onChanged();
      } else {
        importResultBigquerySinkBuilder_.setMessage(builderForValue.build());
      }
      importResultSinkCase_ = 15;
      return this;
    }

    /**
     *
     *
     * <pre>
     * The BigQuery destination to write import result to. It should be a
     * bigquery table resource name (e.g.
     * "bq://projectId.bqDatasetId.bqTableId"). The dataset must exist. If the
     * table does not exist, it will be created with the expected schema. If the
     * table exists, the schema will be validated and data will be added to this
     * existing table.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.BigQueryDestination import_result_bigquery_sink = 15;
     * </code>
     */
    public Builder mergeImportResultBigquerySink(
        com.google.cloud.aiplatform.v1beta1.BigQueryDestination value) {
      if (importResultBigquerySinkBuilder_ == null) {
        if (importResultSinkCase_ == 15
            && importResultSink_
                != com.google.cloud.aiplatform.v1beta1.BigQueryDestination.getDefaultInstance()) {
          importResultSink_ =
              com.google.cloud.aiplatform.v1beta1.BigQueryDestination.newBuilder(
                      (com.google.cloud.aiplatform.v1beta1.BigQueryDestination) importResultSink_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          importResultSink_ = value;
        }
        onChanged();
      } else {
        if (importResultSinkCase_ == 15) {
          importResultBigquerySinkBuilder_.mergeFrom(value);
        } else {
          importResultBigquerySinkBuilder_.setMessage(value);
        }
      }
      importResultSinkCase_ = 15;
      return this;
    }

    /**
     *
     *
     * <pre>
     * The BigQuery destination to write import result to. It should be a
     * bigquery table resource name (e.g.
     * "bq://projectId.bqDatasetId.bqTableId"). The dataset must exist. If the
     * table does not exist, it will be created with the expected schema. If the
     * table exists, the schema will be validated and data will be added to this
     * existing table.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.BigQueryDestination import_result_bigquery_sink = 15;
     * </code>
     */
    public Builder clearImportResultBigquerySink() {
      if (importResultBigquerySinkBuilder_ == null) {
        if (importResultSinkCase_ == 15) {
          importResultSinkCase_ = 0;
          importResultSink_ = null;
          onChanged();
        }
      } else {
        if (importResultSinkCase_ == 15) {
          importResultSinkCase_ = 0;
          importResultSink_ = null;
        }
        importResultBigquerySinkBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The BigQuery destination to write import result to. It should be a
     * bigquery table resource name (e.g.
     * "bq://projectId.bqDatasetId.bqTableId"). The dataset must exist. If the
     * table does not exist, it will be created with the expected schema. If the
     * table exists, the schema will be validated and data will be added to this
     * existing table.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.BigQueryDestination import_result_bigquery_sink = 15;
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.BigQueryDestination.Builder
        getImportResultBigquerySinkBuilder() {
      return getImportResultBigquerySinkFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * The BigQuery destination to write import result to. It should be a
     * bigquery table resource name (e.g.
     * "bq://projectId.bqDatasetId.bqTableId"). The dataset must exist. If the
     * table does not exist, it will be created with the expected schema. If the
     * table exists, the schema will be validated and data will be added to this
     * existing table.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.BigQueryDestination import_result_bigquery_sink = 15;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.BigQueryDestinationOrBuilder
        getImportResultBigquerySinkOrBuilder() {
      if ((importResultSinkCase_ == 15) && (importResultBigquerySinkBuilder_ != null)) {
        return importResultBigquerySinkBuilder_.getMessageOrBuilder();
      } else {
        if (importResultSinkCase_ == 15) {
          return (com.google.cloud.aiplatform.v1beta1.BigQueryDestination) importResultSink_;
        }
        return com.google.cloud.aiplatform.v1beta1.BigQueryDestination.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * The BigQuery destination to write import result to. It should be a
     * bigquery table resource name (e.g.
     * "bq://projectId.bqDatasetId.bqTableId"). The dataset must exist. If the
     * table does not exist, it will be created with the expected schema. If the
     * table exists, the schema will be validated and data will be added to this
     * existing table.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.BigQueryDestination import_result_bigquery_sink = 15;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.BigQueryDestination,
            com.google.cloud.aiplatform.v1beta1.BigQueryDestination.Builder,
            com.google.cloud.aiplatform.v1beta1.BigQueryDestinationOrBuilder>
        getImportResultBigquerySinkFieldBuilder() {
      if (importResultBigquerySinkBuilder_ == null) {
        if (!(importResultSinkCase_ == 15)) {
          importResultSink_ =
              com.google.cloud.aiplatform.v1beta1.BigQueryDestination.getDefaultInstance();
        }
        importResultBigquerySinkBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.BigQueryDestination,
                com.google.cloud.aiplatform.v1beta1.BigQueryDestination.Builder,
                com.google.cloud.aiplatform.v1beta1.BigQueryDestinationOrBuilder>(
                (com.google.cloud.aiplatform.v1beta1.BigQueryDestination) importResultSink_,
                getParentForChildren(),
                isClean());
        importResultSink_ = null;
      }
      importResultSinkCase_ = 15;
      onChanged();
      return importResultBigquerySinkBuilder_;
    }

    private com.google.cloud.aiplatform.v1beta1.RagFileChunkingConfig ragFileChunkingConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.RagFileChunkingConfig,
            com.google.cloud.aiplatform.v1beta1.RagFileChunkingConfig.Builder,
            com.google.cloud.aiplatform.v1beta1.RagFileChunkingConfigOrBuilder>
        ragFileChunkingConfigBuilder_;

    /**
     *
     *
     * <pre>
     * Specifies the size and overlap of chunks after importing RagFiles.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.RagFileChunkingConfig rag_file_chunking_config = 4 [deprecated = true];
     * </code>
     *
     * @deprecated google.cloud.aiplatform.v1beta1.ImportRagFilesConfig.rag_file_chunking_config is
     *     deprecated. See google/cloud/aiplatform/v1beta1/vertex_rag_data.proto;l=633
     * @return Whether the ragFileChunkingConfig field is set.
     */
    @java.lang.Deprecated
    public boolean hasRagFileChunkingConfig() {
      return ((bitField0_ & 0x00000200) != 0);
    }

    /**
     *
     *
     * <pre>
     * Specifies the size and overlap of chunks after importing RagFiles.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.RagFileChunkingConfig rag_file_chunking_config = 4 [deprecated = true];
     * </code>
     *
     * @deprecated google.cloud.aiplatform.v1beta1.ImportRagFilesConfig.rag_file_chunking_config is
     *     deprecated. See google/cloud/aiplatform/v1beta1/vertex_rag_data.proto;l=633
     * @return The ragFileChunkingConfig.
     */
    @java.lang.Deprecated
    public com.google.cloud.aiplatform.v1beta1.RagFileChunkingConfig getRagFileChunkingConfig() {
      if (ragFileChunkingConfigBuilder_ == null) {
        return ragFileChunkingConfig_ == null
            ? com.google.cloud.aiplatform.v1beta1.RagFileChunkingConfig.getDefaultInstance()
            : ragFileChunkingConfig_;
      } else {
        return ragFileChunkingConfigBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Specifies the size and overlap of chunks after importing RagFiles.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.RagFileChunkingConfig rag_file_chunking_config = 4 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder setRagFileChunkingConfig(
        com.google.cloud.aiplatform.v1beta1.RagFileChunkingConfig value) {
      if (ragFileChunkingConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ragFileChunkingConfig_ = value;
      } else {
        ragFileChunkingConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Specifies the size and overlap of chunks after importing RagFiles.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.RagFileChunkingConfig rag_file_chunking_config = 4 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder setRagFileChunkingConfig(
        com.google.cloud.aiplatform.v1beta1.RagFileChunkingConfig.Builder builderForValue) {
      if (ragFileChunkingConfigBuilder_ == null) {
        ragFileChunkingConfig_ = builderForValue.build();
      } else {
        ragFileChunkingConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Specifies the size and overlap of chunks after importing RagFiles.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.RagFileChunkingConfig rag_file_chunking_config = 4 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder mergeRagFileChunkingConfig(
        com.google.cloud.aiplatform.v1beta1.RagFileChunkingConfig value) {
      if (ragFileChunkingConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000200) != 0)
            && ragFileChunkingConfig_ != null
            && ragFileChunkingConfig_
                != com.google.cloud.aiplatform.v1beta1.RagFileChunkingConfig.getDefaultInstance()) {
          getRagFileChunkingConfigBuilder().mergeFrom(value);
        } else {
          ragFileChunkingConfig_ = value;
        }
      } else {
        ragFileChunkingConfigBuilder_.mergeFrom(value);
      }
      if (ragFileChunkingConfig_ != null) {
        bitField0_ |= 0x00000200;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Specifies the size and overlap of chunks after importing RagFiles.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.RagFileChunkingConfig rag_file_chunking_config = 4 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder clearRagFileChunkingConfig() {
      bitField0_ = (bitField0_ & ~0x00000200);
      ragFileChunkingConfig_ = null;
      if (ragFileChunkingConfigBuilder_ != null) {
        ragFileChunkingConfigBuilder_.dispose();
        ragFileChunkingConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Specifies the size and overlap of chunks after importing RagFiles.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.RagFileChunkingConfig rag_file_chunking_config = 4 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public com.google.cloud.aiplatform.v1beta1.RagFileChunkingConfig.Builder
        getRagFileChunkingConfigBuilder() {
      bitField0_ |= 0x00000200;
      onChanged();
      return getRagFileChunkingConfigFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Specifies the size and overlap of chunks after importing RagFiles.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.RagFileChunkingConfig rag_file_chunking_config = 4 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public com.google.cloud.aiplatform.v1beta1.RagFileChunkingConfigOrBuilder
        getRagFileChunkingConfigOrBuilder() {
      if (ragFileChunkingConfigBuilder_ != null) {
        return ragFileChunkingConfigBuilder_.getMessageOrBuilder();
      } else {
        return ragFileChunkingConfig_ == null
            ? com.google.cloud.aiplatform.v1beta1.RagFileChunkingConfig.getDefaultInstance()
            : ragFileChunkingConfig_;
      }
    }

    /**
     *
     *
     * <pre>
     * Specifies the size and overlap of chunks after importing RagFiles.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.RagFileChunkingConfig rag_file_chunking_config = 4 [deprecated = true];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.RagFileChunkingConfig,
            com.google.cloud.aiplatform.v1beta1.RagFileChunkingConfig.Builder,
            com.google.cloud.aiplatform.v1beta1.RagFileChunkingConfigOrBuilder>
        getRagFileChunkingConfigFieldBuilder() {
      if (ragFileChunkingConfigBuilder_ == null) {
        ragFileChunkingConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.RagFileChunkingConfig,
                com.google.cloud.aiplatform.v1beta1.RagFileChunkingConfig.Builder,
                com.google.cloud.aiplatform.v1beta1.RagFileChunkingConfigOrBuilder>(
                getRagFileChunkingConfig(), getParentForChildren(), isClean());
        ragFileChunkingConfig_ = null;
      }
      return ragFileChunkingConfigBuilder_;
    }

    private com.google.cloud.aiplatform.v1beta1.RagFileTransformationConfig
        ragFileTransformationConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.RagFileTransformationConfig,
            com.google.cloud.aiplatform.v1beta1.RagFileTransformationConfig.Builder,
            com.google.cloud.aiplatform.v1beta1.RagFileTransformationConfigOrBuilder>
        ragFileTransformationConfigBuilder_;

    /**
     *
     *
     * <pre>
     * Specifies the transformation config for RagFiles.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.RagFileTransformationConfig rag_file_transformation_config = 16;
     * </code>
     *
     * @return Whether the ragFileTransformationConfig field is set.
     */
    public boolean hasRagFileTransformationConfig() {
      return ((bitField0_ & 0x00000400) != 0);
    }

    /**
     *
     *
     * <pre>
     * Specifies the transformation config for RagFiles.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.RagFileTransformationConfig rag_file_transformation_config = 16;
     * </code>
     *
     * @return The ragFileTransformationConfig.
     */
    public com.google.cloud.aiplatform.v1beta1.RagFileTransformationConfig
        getRagFileTransformationConfig() {
      if (ragFileTransformationConfigBuilder_ == null) {
        return ragFileTransformationConfig_ == null
            ? com.google.cloud.aiplatform.v1beta1.RagFileTransformationConfig.getDefaultInstance()
            : ragFileTransformationConfig_;
      } else {
        return ragFileTransformationConfigBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Specifies the transformation config for RagFiles.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.RagFileTransformationConfig rag_file_transformation_config = 16;
     * </code>
     */
    public Builder setRagFileTransformationConfig(
        com.google.cloud.aiplatform.v1beta1.RagFileTransformationConfig value) {
      if (ragFileTransformationConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ragFileTransformationConfig_ = value;
      } else {
        ragFileTransformationConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Specifies the transformation config for RagFiles.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.RagFileTransformationConfig rag_file_transformation_config = 16;
     * </code>
     */
    public Builder setRagFileTransformationConfig(
        com.google.cloud.aiplatform.v1beta1.RagFileTransformationConfig.Builder builderForValue) {
      if (ragFileTransformationConfigBuilder_ == null) {
        ragFileTransformationConfig_ = builderForValue.build();
      } else {
        ragFileTransformationConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Specifies the transformation config for RagFiles.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.RagFileTransformationConfig rag_file_transformation_config = 16;
     * </code>
     */
    public Builder mergeRagFileTransformationConfig(
        com.google.cloud.aiplatform.v1beta1.RagFileTransformationConfig value) {
      if (ragFileTransformationConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000400) != 0)
            && ragFileTransformationConfig_ != null
            && ragFileTransformationConfig_
                != com.google.cloud.aiplatform.v1beta1.RagFileTransformationConfig
                    .getDefaultInstance()) {
          getRagFileTransformationConfigBuilder().mergeFrom(value);
        } else {
          ragFileTransformationConfig_ = value;
        }
      } else {
        ragFileTransformationConfigBuilder_.mergeFrom(value);
      }
      if (ragFileTransformationConfig_ != null) {
        bitField0_ |= 0x00000400;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Specifies the transformation config for RagFiles.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.RagFileTransformationConfig rag_file_transformation_config = 16;
     * </code>
     */
    public Builder clearRagFileTransformationConfig() {
      bitField0_ = (bitField0_ & ~0x00000400);
      ragFileTransformationConfig_ = null;
      if (ragFileTransformationConfigBuilder_ != null) {
        ragFileTransformationConfigBuilder_.dispose();
        ragFileTransformationConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Specifies the transformation config for RagFiles.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.RagFileTransformationConfig rag_file_transformation_config = 16;
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.RagFileTransformationConfig.Builder
        getRagFileTransformationConfigBuilder() {
      bitField0_ |= 0x00000400;
      onChanged();
      return getRagFileTransformationConfigFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Specifies the transformation config for RagFiles.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.RagFileTransformationConfig rag_file_transformation_config = 16;
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.RagFileTransformationConfigOrBuilder
        getRagFileTransformationConfigOrBuilder() {
      if (ragFileTransformationConfigBuilder_ != null) {
        return ragFileTransformationConfigBuilder_.getMessageOrBuilder();
      } else {
        return ragFileTransformationConfig_ == null
            ? com.google.cloud.aiplatform.v1beta1.RagFileTransformationConfig.getDefaultInstance()
            : ragFileTransformationConfig_;
      }
    }

    /**
     *
     *
     * <pre>
     * Specifies the transformation config for RagFiles.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.RagFileTransformationConfig rag_file_transformation_config = 16;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.RagFileTransformationConfig,
            com.google.cloud.aiplatform.v1beta1.RagFileTransformationConfig.Builder,
            com.google.cloud.aiplatform.v1beta1.RagFileTransformationConfigOrBuilder>
        getRagFileTransformationConfigFieldBuilder() {
      if (ragFileTransformationConfigBuilder_ == null) {
        ragFileTransformationConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.RagFileTransformationConfig,
                com.google.cloud.aiplatform.v1beta1.RagFileTransformationConfig.Builder,
                com.google.cloud.aiplatform.v1beta1.RagFileTransformationConfigOrBuilder>(
                getRagFileTransformationConfig(), getParentForChildren(), isClean());
        ragFileTransformationConfig_ = null;
      }
      return ragFileTransformationConfigBuilder_;
    }

    private com.google.cloud.aiplatform.v1beta1.RagFileParsingConfig ragFileParsingConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.RagFileParsingConfig,
            com.google.cloud.aiplatform.v1beta1.RagFileParsingConfig.Builder,
            com.google.cloud.aiplatform.v1beta1.RagFileParsingConfigOrBuilder>
        ragFileParsingConfigBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. Specifies the parsing config for RagFiles.
     * RAG will use the default parser if this field is not set.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.RagFileParsingConfig rag_file_parsing_config = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the ragFileParsingConfig field is set.
     */
    public boolean hasRagFileParsingConfig() {
      return ((bitField0_ & 0x00000800) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. Specifies the parsing config for RagFiles.
     * RAG will use the default parser if this field is not set.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.RagFileParsingConfig rag_file_parsing_config = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The ragFileParsingConfig.
     */
    public com.google.cloud.aiplatform.v1beta1.RagFileParsingConfig getRagFileParsingConfig() {
      if (ragFileParsingConfigBuilder_ == null) {
        return ragFileParsingConfig_ == null
            ? com.google.cloud.aiplatform.v1beta1.RagFileParsingConfig.getDefaultInstance()
            : ragFileParsingConfig_;
      } else {
        return ragFileParsingConfigBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Specifies the parsing config for RagFiles.
     * RAG will use the default parser if this field is not set.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.RagFileParsingConfig rag_file_parsing_config = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setRagFileParsingConfig(
        com.google.cloud.aiplatform.v1beta1.RagFileParsingConfig value) {
      if (ragFileParsingConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ragFileParsingConfig_ = value;
      } else {
        ragFileParsingConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Specifies the parsing config for RagFiles.
     * RAG will use the default parser if this field is not set.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.RagFileParsingConfig rag_file_parsing_config = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setRagFileParsingConfig(
        com.google.cloud.aiplatform.v1beta1.RagFileParsingConfig.Builder builderForValue) {
      if (ragFileParsingConfigBuilder_ == null) {
        ragFileParsingConfig_ = builderForValue.build();
      } else {
        ragFileParsingConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Specifies the parsing config for RagFiles.
     * RAG will use the default parser if this field is not set.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.RagFileParsingConfig rag_file_parsing_config = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeRagFileParsingConfig(
        com.google.cloud.aiplatform.v1beta1.RagFileParsingConfig value) {
      if (ragFileParsingConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000800) != 0)
            && ragFileParsingConfig_ != null
            && ragFileParsingConfig_
                != com.google.cloud.aiplatform.v1beta1.RagFileParsingConfig.getDefaultInstance()) {
          getRagFileParsingConfigBuilder().mergeFrom(value);
        } else {
          ragFileParsingConfig_ = value;
        }
      } else {
        ragFileParsingConfigBuilder_.mergeFrom(value);
      }
      if (ragFileParsingConfig_ != null) {
        bitField0_ |= 0x00000800;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Specifies the parsing config for RagFiles.
     * RAG will use the default parser if this field is not set.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.RagFileParsingConfig rag_file_parsing_config = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearRagFileParsingConfig() {
      bitField0_ = (bitField0_ & ~0x00000800);
      ragFileParsingConfig_ = null;
      if (ragFileParsingConfigBuilder_ != null) {
        ragFileParsingConfigBuilder_.dispose();
        ragFileParsingConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Specifies the parsing config for RagFiles.
     * RAG will use the default parser if this field is not set.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.RagFileParsingConfig rag_file_parsing_config = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.RagFileParsingConfig.Builder
        getRagFileParsingConfigBuilder() {
      bitField0_ |= 0x00000800;
      onChanged();
      return getRagFileParsingConfigFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Optional. Specifies the parsing config for RagFiles.
     * RAG will use the default parser if this field is not set.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.RagFileParsingConfig rag_file_parsing_config = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.RagFileParsingConfigOrBuilder
        getRagFileParsingConfigOrBuilder() {
      if (ragFileParsingConfigBuilder_ != null) {
        return ragFileParsingConfigBuilder_.getMessageOrBuilder();
      } else {
        return ragFileParsingConfig_ == null
            ? com.google.cloud.aiplatform.v1beta1.RagFileParsingConfig.getDefaultInstance()
            : ragFileParsingConfig_;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Specifies the parsing config for RagFiles.
     * RAG will use the default parser if this field is not set.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.RagFileParsingConfig rag_file_parsing_config = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.RagFileParsingConfig,
            com.google.cloud.aiplatform.v1beta1.RagFileParsingConfig.Builder,
            com.google.cloud.aiplatform.v1beta1.RagFileParsingConfigOrBuilder>
        getRagFileParsingConfigFieldBuilder() {
      if (ragFileParsingConfigBuilder_ == null) {
        ragFileParsingConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.RagFileParsingConfig,
                com.google.cloud.aiplatform.v1beta1.RagFileParsingConfig.Builder,
                com.google.cloud.aiplatform.v1beta1.RagFileParsingConfigOrBuilder>(
                getRagFileParsingConfig(), getParentForChildren(), isClean());
        ragFileParsingConfig_ = null;
      }
      return ragFileParsingConfigBuilder_;
    }

    private int maxEmbeddingRequestsPerMin_;

    /**
     *
     *
     * <pre>
     * Optional. The max number of queries per minute that this job is allowed to
     * make to the embedding model specified on the corpus. This value is specific
     * to this job and not shared across other import jobs. Consult the Quotas
     * page on the project to set an appropriate value here.
     * If unspecified, a default value of 1,000 QPM would be used.
     * </pre>
     *
     * <code>int32 max_embedding_requests_per_min = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The maxEmbeddingRequestsPerMin.
     */
    @java.lang.Override
    public int getMaxEmbeddingRequestsPerMin() {
      return maxEmbeddingRequestsPerMin_;
    }

    /**
     *
     *
     * <pre>
     * Optional. The max number of queries per minute that this job is allowed to
     * make to the embedding model specified on the corpus. This value is specific
     * to this job and not shared across other import jobs. Consult the Quotas
     * page on the project to set an appropriate value here.
     * If unspecified, a default value of 1,000 QPM would be used.
     * </pre>
     *
     * <code>int32 max_embedding_requests_per_min = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The maxEmbeddingRequestsPerMin to set.
     * @return This builder for chaining.
     */
    public Builder setMaxEmbeddingRequestsPerMin(int value) {

      maxEmbeddingRequestsPerMin_ = value;
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The max number of queries per minute that this job is allowed to
     * make to the embedding model specified on the corpus. This value is specific
     * to this job and not shared across other import jobs. Consult the Quotas
     * page on the project to set an appropriate value here.
     * If unspecified, a default value of 1,000 QPM would be used.
     * </pre>
     *
     * <code>int32 max_embedding_requests_per_min = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMaxEmbeddingRequestsPerMin() {
      bitField0_ = (bitField0_ & ~0x00001000);
      maxEmbeddingRequestsPerMin_ = 0;
      onChanged();
      return this;
    }

    private int globalMaxEmbeddingRequestsPerMin_;

    /**
     *
     *
     * <pre>
     * Optional. The max number of queries per minute that the indexing pipeline
     * job is allowed to make to the embedding model specified in the project.
     * Please follow the quota usage guideline of the embedding model you use to
     * set the value properly. If this value is not specified,
     * max_embedding_requests_per_min will be used by indexing pipeline job as the
     * global limit.
     * </pre>
     *
     * <code>
     * int32 global_max_embedding_requests_per_min = 18 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The globalMaxEmbeddingRequestsPerMin.
     */
    @java.lang.Override
    public int getGlobalMaxEmbeddingRequestsPerMin() {
      return globalMaxEmbeddingRequestsPerMin_;
    }

    /**
     *
     *
     * <pre>
     * Optional. The max number of queries per minute that the indexing pipeline
     * job is allowed to make to the embedding model specified in the project.
     * Please follow the quota usage guideline of the embedding model you use to
     * set the value properly. If this value is not specified,
     * max_embedding_requests_per_min will be used by indexing pipeline job as the
     * global limit.
     * </pre>
     *
     * <code>
     * int32 global_max_embedding_requests_per_min = 18 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The globalMaxEmbeddingRequestsPerMin to set.
     * @return This builder for chaining.
     */
    public Builder setGlobalMaxEmbeddingRequestsPerMin(int value) {

      globalMaxEmbeddingRequestsPerMin_ = value;
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The max number of queries per minute that the indexing pipeline
     * job is allowed to make to the embedding model specified in the project.
     * Please follow the quota usage guideline of the embedding model you use to
     * set the value properly. If this value is not specified,
     * max_embedding_requests_per_min will be used by indexing pipeline job as the
     * global limit.
     * </pre>
     *
     * <code>
     * int32 global_max_embedding_requests_per_min = 18 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearGlobalMaxEmbeddingRequestsPerMin() {
      bitField0_ = (bitField0_ & ~0x00002000);
      globalMaxEmbeddingRequestsPerMin_ = 0;
      onChanged();
      return this;
    }

    private boolean rebuildAnnIndex_;

    /**
     *
     *
     * <pre>
     * Rebuilds the ANN index to optimize for recall on the imported data.
     * Only applicable for RagCorpora running on RagManagedDb with
     * `retrieval_strategy` set to `ANN`. The rebuild will be performed using the
     * existing ANN config set on the RagCorpus. To change the ANN config, please
     * use the UpdateRagCorpus API.
     *
     * Default is false, i.e., index is not rebuilt.
     * </pre>
     *
     * <code>bool rebuild_ann_index = 19;</code>
     *
     * @return The rebuildAnnIndex.
     */
    @java.lang.Override
    public boolean getRebuildAnnIndex() {
      return rebuildAnnIndex_;
    }

    /**
     *
     *
     * <pre>
     * Rebuilds the ANN index to optimize for recall on the imported data.
     * Only applicable for RagCorpora running on RagManagedDb with
     * `retrieval_strategy` set to `ANN`. The rebuild will be performed using the
     * existing ANN config set on the RagCorpus. To change the ANN config, please
     * use the UpdateRagCorpus API.
     *
     * Default is false, i.e., index is not rebuilt.
     * </pre>
     *
     * <code>bool rebuild_ann_index = 19;</code>
     *
     * @param value The rebuildAnnIndex to set.
     * @return This builder for chaining.
     */
    public Builder setRebuildAnnIndex(boolean value) {

      rebuildAnnIndex_ = value;
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Rebuilds the ANN index to optimize for recall on the imported data.
     * Only applicable for RagCorpora running on RagManagedDb with
     * `retrieval_strategy` set to `ANN`. The rebuild will be performed using the
     * existing ANN config set on the RagCorpus. To change the ANN config, please
     * use the UpdateRagCorpus API.
     *
     * Default is false, i.e., index is not rebuilt.
     * </pre>
     *
     * <code>bool rebuild_ann_index = 19;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRebuildAnnIndex() {
      bitField0_ = (bitField0_ & ~0x00004000);
      rebuildAnnIndex_ = false;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.ImportRagFilesConfig)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.ImportRagFilesConfig)
  private static final com.google.cloud.aiplatform.v1beta1.ImportRagFilesConfig DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.ImportRagFilesConfig();
  }

  public static com.google.cloud.aiplatform.v1beta1.ImportRagFilesConfig getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ImportRagFilesConfig> PARSER =
      new com.google.protobuf.AbstractParser<ImportRagFilesConfig>() {
        @java.lang.Override
        public ImportRagFilesConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ImportRagFilesConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ImportRagFilesConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ImportRagFilesConfig getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
