/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1beta1/model_monitoring_stats.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.aiplatform.v1beta1;

/**
 *
 *
 * <pre>
 * Represents a single statistics data point.
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint}
 */
public final class ModelMonitoringStatsDataPoint extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint)
    ModelMonitoringStatsDataPointOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use ModelMonitoringStatsDataPoint.newBuilder() to construct.
  private ModelMonitoringStatsDataPoint(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ModelMonitoringStatsDataPoint() {
    modelMonitoringJob_ = "";
    schedule_ = "";
    algorithm_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ModelMonitoringStatsDataPoint();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsProto
        .internal_static_google_cloud_aiplatform_v1beta1_ModelMonitoringStatsDataPoint_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsProto
        .internal_static_google_cloud_aiplatform_v1beta1_ModelMonitoringStatsDataPoint_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.class,
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.Builder.class);
  }

  public interface TypedValueOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Double.
     * </pre>
     *
     * <code>double double_value = 1;</code>
     *
     * @return Whether the doubleValue field is set.
     */
    boolean hasDoubleValue();

    /**
     *
     *
     * <pre>
     * Double.
     * </pre>
     *
     * <code>double double_value = 1;</code>
     *
     * @return The doubleValue.
     */
    double getDoubleValue();

    /**
     *
     *
     * <pre>
     * Distribution.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue.DistributionDataValue distribution_value = 2;
     * </code>
     *
     * @return Whether the distributionValue field is set.
     */
    boolean hasDistributionValue();

    /**
     *
     *
     * <pre>
     * Distribution.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue.DistributionDataValue distribution_value = 2;
     * </code>
     *
     * @return The distributionValue.
     */
    com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue
            .DistributionDataValue
        getDistributionValue();

    /**
     *
     *
     * <pre>
     * Distribution.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue.DistributionDataValue distribution_value = 2;
     * </code>
     */
    com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue
            .DistributionDataValueOrBuilder
        getDistributionValueOrBuilder();

    com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue.ValueCase
        getValueCase();
  }

  /**
   *
   *
   * <pre>
   * Typed value of the statistics.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue}
   */
  public static final class TypedValue extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue)
      TypedValueOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use TypedValue.newBuilder() to construct.
    private TypedValue(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private TypedValue() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new TypedValue();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsProto
          .internal_static_google_cloud_aiplatform_v1beta1_ModelMonitoringStatsDataPoint_TypedValue_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsProto
          .internal_static_google_cloud_aiplatform_v1beta1_ModelMonitoringStatsDataPoint_TypedValue_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue.class,
              com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue.Builder
                  .class);
    }

    public interface DistributionDataValueOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue.DistributionDataValue)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Predictive monitoring drift distribution in
       * `tensorflow.metadata.v0.DatasetFeatureStatistics` format.
       * </pre>
       *
       * <code>.google.protobuf.Value distribution = 1;</code>
       *
       * @return Whether the distribution field is set.
       */
      boolean hasDistribution();

      /**
       *
       *
       * <pre>
       * Predictive monitoring drift distribution in
       * `tensorflow.metadata.v0.DatasetFeatureStatistics` format.
       * </pre>
       *
       * <code>.google.protobuf.Value distribution = 1;</code>
       *
       * @return The distribution.
       */
      com.google.protobuf.Value getDistribution();

      /**
       *
       *
       * <pre>
       * Predictive monitoring drift distribution in
       * `tensorflow.metadata.v0.DatasetFeatureStatistics` format.
       * </pre>
       *
       * <code>.google.protobuf.Value distribution = 1;</code>
       */
      com.google.protobuf.ValueOrBuilder getDistributionOrBuilder();

      /**
       *
       *
       * <pre>
       * Distribution distance deviation from the current dataset's statistics
       * to baseline dataset's statistics.
       *   * For categorical feature, the distribution distance is calculated
       *     by L-inifinity norm or Jensen–Shannon divergence.
       *   * For numerical feature, the distribution distance is calculated by
       *     Jensen–Shannon divergence.
       * </pre>
       *
       * <code>double distribution_deviation = 2;</code>
       *
       * @return The distributionDeviation.
       */
      double getDistributionDeviation();
    }

    /**
     *
     *
     * <pre>
     * Summary statistics for a population of values.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue.DistributionDataValue}
     */
    public static final class DistributionDataValue extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue.DistributionDataValue)
        DistributionDataValueOrBuilder {
      private static final long serialVersionUID = 0L;

      // Use DistributionDataValue.newBuilder() to construct.
      private DistributionDataValue(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private DistributionDataValue() {}

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new DistributionDataValue();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsProto
            .internal_static_google_cloud_aiplatform_v1beta1_ModelMonitoringStatsDataPoint_TypedValue_DistributionDataValue_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsProto
            .internal_static_google_cloud_aiplatform_v1beta1_ModelMonitoringStatsDataPoint_TypedValue_DistributionDataValue_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue
                    .DistributionDataValue.class,
                com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue
                    .DistributionDataValue.Builder.class);
      }

      private int bitField0_;
      public static final int DISTRIBUTION_FIELD_NUMBER = 1;
      private com.google.protobuf.Value distribution_;

      /**
       *
       *
       * <pre>
       * Predictive monitoring drift distribution in
       * `tensorflow.metadata.v0.DatasetFeatureStatistics` format.
       * </pre>
       *
       * <code>.google.protobuf.Value distribution = 1;</code>
       *
       * @return Whether the distribution field is set.
       */
      @java.lang.Override
      public boolean hasDistribution() {
        return ((bitField0_ & 0x00000001) != 0);
      }

      /**
       *
       *
       * <pre>
       * Predictive monitoring drift distribution in
       * `tensorflow.metadata.v0.DatasetFeatureStatistics` format.
       * </pre>
       *
       * <code>.google.protobuf.Value distribution = 1;</code>
       *
       * @return The distribution.
       */
      @java.lang.Override
      public com.google.protobuf.Value getDistribution() {
        return distribution_ == null
            ? com.google.protobuf.Value.getDefaultInstance()
            : distribution_;
      }

      /**
       *
       *
       * <pre>
       * Predictive monitoring drift distribution in
       * `tensorflow.metadata.v0.DatasetFeatureStatistics` format.
       * </pre>
       *
       * <code>.google.protobuf.Value distribution = 1;</code>
       */
      @java.lang.Override
      public com.google.protobuf.ValueOrBuilder getDistributionOrBuilder() {
        return distribution_ == null
            ? com.google.protobuf.Value.getDefaultInstance()
            : distribution_;
      }

      public static final int DISTRIBUTION_DEVIATION_FIELD_NUMBER = 2;
      private double distributionDeviation_ = 0D;

      /**
       *
       *
       * <pre>
       * Distribution distance deviation from the current dataset's statistics
       * to baseline dataset's statistics.
       *   * For categorical feature, the distribution distance is calculated
       *     by L-inifinity norm or Jensen–Shannon divergence.
       *   * For numerical feature, the distribution distance is calculated by
       *     Jensen–Shannon divergence.
       * </pre>
       *
       * <code>double distribution_deviation = 2;</code>
       *
       * @return The distributionDeviation.
       */
      @java.lang.Override
      public double getDistributionDeviation() {
        return distributionDeviation_;
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (((bitField0_ & 0x00000001) != 0)) {
          output.writeMessage(1, getDistribution());
        }
        if (java.lang.Double.doubleToRawLongBits(distributionDeviation_) != 0) {
          output.writeDouble(2, distributionDeviation_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (((bitField0_ & 0x00000001) != 0)) {
          size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getDistribution());
        }
        if (java.lang.Double.doubleToRawLongBits(distributionDeviation_) != 0) {
          size +=
              com.google.protobuf.CodedOutputStream.computeDoubleSize(2, distributionDeviation_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue
                .DistributionDataValue)) {
          return super.equals(obj);
        }
        com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue
                .DistributionDataValue
            other =
                (com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue
                        .DistributionDataValue)
                    obj;

        if (hasDistribution() != other.hasDistribution()) return false;
        if (hasDistribution()) {
          if (!getDistribution().equals(other.getDistribution())) return false;
        }
        if (java.lang.Double.doubleToLongBits(getDistributionDeviation())
            != java.lang.Double.doubleToLongBits(other.getDistributionDeviation())) return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        if (hasDistribution()) {
          hash = (37 * hash) + DISTRIBUTION_FIELD_NUMBER;
          hash = (53 * hash) + getDistribution().hashCode();
        }
        hash = (37 * hash) + DISTRIBUTION_DEVIATION_FIELD_NUMBER;
        hash =
            (53 * hash)
                + com.google.protobuf.Internal.hashLong(
                    java.lang.Double.doubleToLongBits(getDistributionDeviation()));
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue
              .DistributionDataValue
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue
              .DistributionDataValue
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue
              .DistributionDataValue
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue
              .DistributionDataValue
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue
              .DistributionDataValue
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue
              .DistributionDataValue
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue
              .DistributionDataValue
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue
              .DistributionDataValue
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue
              .DistributionDataValue
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue
              .DistributionDataValue
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue
              .DistributionDataValue
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue
              .DistributionDataValue
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue
                  .DistributionDataValue
              prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }

      /**
       *
       *
       * <pre>
       * Summary statistics for a population of values.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue.DistributionDataValue}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue.DistributionDataValue)
          com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue
              .DistributionDataValueOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsProto
              .internal_static_google_cloud_aiplatform_v1beta1_ModelMonitoringStatsDataPoint_TypedValue_DistributionDataValue_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsProto
              .internal_static_google_cloud_aiplatform_v1beta1_ModelMonitoringStatsDataPoint_TypedValue_DistributionDataValue_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue
                      .DistributionDataValue.class,
                  com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue
                      .DistributionDataValue.Builder.class);
        }

        // Construct using
        // com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue.DistributionDataValue.newBuilder()
        private Builder() {
          maybeForceBuilderInitialization();
        }

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
          maybeForceBuilderInitialization();
        }

        private void maybeForceBuilderInitialization() {
          if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
            getDistributionFieldBuilder();
          }
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          distribution_ = null;
          if (distributionBuilder_ != null) {
            distributionBuilder_.dispose();
            distributionBuilder_ = null;
          }
          distributionDeviation_ = 0D;
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsProto
              .internal_static_google_cloud_aiplatform_v1beta1_ModelMonitoringStatsDataPoint_TypedValue_DistributionDataValue_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue
                .DistributionDataValue
            getDefaultInstanceForType() {
          return com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue
              .DistributionDataValue.getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue
                .DistributionDataValue
            build() {
          com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue
                  .DistributionDataValue
              result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue
                .DistributionDataValue
            buildPartial() {
          com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue
                  .DistributionDataValue
              result =
                  new com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue
                      .DistributionDataValue(this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue
                    .DistributionDataValue
                result) {
          int from_bitField0_ = bitField0_;
          int to_bitField0_ = 0;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.distribution_ =
                distributionBuilder_ == null ? distribution_ : distributionBuilder_.build();
            to_bitField0_ |= 0x00000001;
          }
          if (((from_bitField0_ & 0x00000002) != 0)) {
            result.distributionDeviation_ = distributionDeviation_;
          }
          result.bitField0_ |= to_bitField0_;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue
                  .DistributionDataValue) {
            return mergeFrom(
                (com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue
                        .DistributionDataValue)
                    other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue
                    .DistributionDataValue
                other) {
          if (other
              == com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue
                  .DistributionDataValue.getDefaultInstance()) return this;
          if (other.hasDistribution()) {
            mergeDistribution(other.getDistribution());
          }
          if (other.getDistributionDeviation() != 0D) {
            setDistributionDeviation(other.getDistributionDeviation());
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    input.readMessage(
                        getDistributionFieldBuilder().getBuilder(), extensionRegistry);
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 10
                case 17:
                  {
                    distributionDeviation_ = input.readDouble();
                    bitField0_ |= 0x00000002;
                    break;
                  } // case 17
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private com.google.protobuf.Value distribution_;
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Value,
                com.google.protobuf.Value.Builder,
                com.google.protobuf.ValueOrBuilder>
            distributionBuilder_;

        /**
         *
         *
         * <pre>
         * Predictive monitoring drift distribution in
         * `tensorflow.metadata.v0.DatasetFeatureStatistics` format.
         * </pre>
         *
         * <code>.google.protobuf.Value distribution = 1;</code>
         *
         * @return Whether the distribution field is set.
         */
        public boolean hasDistribution() {
          return ((bitField0_ & 0x00000001) != 0);
        }

        /**
         *
         *
         * <pre>
         * Predictive monitoring drift distribution in
         * `tensorflow.metadata.v0.DatasetFeatureStatistics` format.
         * </pre>
         *
         * <code>.google.protobuf.Value distribution = 1;</code>
         *
         * @return The distribution.
         */
        public com.google.protobuf.Value getDistribution() {
          if (distributionBuilder_ == null) {
            return distribution_ == null
                ? com.google.protobuf.Value.getDefaultInstance()
                : distribution_;
          } else {
            return distributionBuilder_.getMessage();
          }
        }

        /**
         *
         *
         * <pre>
         * Predictive monitoring drift distribution in
         * `tensorflow.metadata.v0.DatasetFeatureStatistics` format.
         * </pre>
         *
         * <code>.google.protobuf.Value distribution = 1;</code>
         */
        public Builder setDistribution(com.google.protobuf.Value value) {
          if (distributionBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            distribution_ = value;
          } else {
            distributionBuilder_.setMessage(value);
          }
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Predictive monitoring drift distribution in
         * `tensorflow.metadata.v0.DatasetFeatureStatistics` format.
         * </pre>
         *
         * <code>.google.protobuf.Value distribution = 1;</code>
         */
        public Builder setDistribution(com.google.protobuf.Value.Builder builderForValue) {
          if (distributionBuilder_ == null) {
            distribution_ = builderForValue.build();
          } else {
            distributionBuilder_.setMessage(builderForValue.build());
          }
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Predictive monitoring drift distribution in
         * `tensorflow.metadata.v0.DatasetFeatureStatistics` format.
         * </pre>
         *
         * <code>.google.protobuf.Value distribution = 1;</code>
         */
        public Builder mergeDistribution(com.google.protobuf.Value value) {
          if (distributionBuilder_ == null) {
            if (((bitField0_ & 0x00000001) != 0)
                && distribution_ != null
                && distribution_ != com.google.protobuf.Value.getDefaultInstance()) {
              getDistributionBuilder().mergeFrom(value);
            } else {
              distribution_ = value;
            }
          } else {
            distributionBuilder_.mergeFrom(value);
          }
          if (distribution_ != null) {
            bitField0_ |= 0x00000001;
            onChanged();
          }
          return this;
        }

        /**
         *
         *
         * <pre>
         * Predictive monitoring drift distribution in
         * `tensorflow.metadata.v0.DatasetFeatureStatistics` format.
         * </pre>
         *
         * <code>.google.protobuf.Value distribution = 1;</code>
         */
        public Builder clearDistribution() {
          bitField0_ = (bitField0_ & ~0x00000001);
          distribution_ = null;
          if (distributionBuilder_ != null) {
            distributionBuilder_.dispose();
            distributionBuilder_ = null;
          }
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Predictive monitoring drift distribution in
         * `tensorflow.metadata.v0.DatasetFeatureStatistics` format.
         * </pre>
         *
         * <code>.google.protobuf.Value distribution = 1;</code>
         */
        public com.google.protobuf.Value.Builder getDistributionBuilder() {
          bitField0_ |= 0x00000001;
          onChanged();
          return getDistributionFieldBuilder().getBuilder();
        }

        /**
         *
         *
         * <pre>
         * Predictive monitoring drift distribution in
         * `tensorflow.metadata.v0.DatasetFeatureStatistics` format.
         * </pre>
         *
         * <code>.google.protobuf.Value distribution = 1;</code>
         */
        public com.google.protobuf.ValueOrBuilder getDistributionOrBuilder() {
          if (distributionBuilder_ != null) {
            return distributionBuilder_.getMessageOrBuilder();
          } else {
            return distribution_ == null
                ? com.google.protobuf.Value.getDefaultInstance()
                : distribution_;
          }
        }

        /**
         *
         *
         * <pre>
         * Predictive monitoring drift distribution in
         * `tensorflow.metadata.v0.DatasetFeatureStatistics` format.
         * </pre>
         *
         * <code>.google.protobuf.Value distribution = 1;</code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Value,
                com.google.protobuf.Value.Builder,
                com.google.protobuf.ValueOrBuilder>
            getDistributionFieldBuilder() {
          if (distributionBuilder_ == null) {
            distributionBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.protobuf.Value,
                    com.google.protobuf.Value.Builder,
                    com.google.protobuf.ValueOrBuilder>(
                    getDistribution(), getParentForChildren(), isClean());
            distribution_ = null;
          }
          return distributionBuilder_;
        }

        private double distributionDeviation_;

        /**
         *
         *
         * <pre>
         * Distribution distance deviation from the current dataset's statistics
         * to baseline dataset's statistics.
         *   * For categorical feature, the distribution distance is calculated
         *     by L-inifinity norm or Jensen–Shannon divergence.
         *   * For numerical feature, the distribution distance is calculated by
         *     Jensen–Shannon divergence.
         * </pre>
         *
         * <code>double distribution_deviation = 2;</code>
         *
         * @return The distributionDeviation.
         */
        @java.lang.Override
        public double getDistributionDeviation() {
          return distributionDeviation_;
        }

        /**
         *
         *
         * <pre>
         * Distribution distance deviation from the current dataset's statistics
         * to baseline dataset's statistics.
         *   * For categorical feature, the distribution distance is calculated
         *     by L-inifinity norm or Jensen–Shannon divergence.
         *   * For numerical feature, the distribution distance is calculated by
         *     Jensen–Shannon divergence.
         * </pre>
         *
         * <code>double distribution_deviation = 2;</code>
         *
         * @param value The distributionDeviation to set.
         * @return This builder for chaining.
         */
        public Builder setDistributionDeviation(double value) {

          distributionDeviation_ = value;
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Distribution distance deviation from the current dataset's statistics
         * to baseline dataset's statistics.
         *   * For categorical feature, the distribution distance is calculated
         *     by L-inifinity norm or Jensen–Shannon divergence.
         *   * For numerical feature, the distribution distance is calculated by
         *     Jensen–Shannon divergence.
         * </pre>
         *
         * <code>double distribution_deviation = 2;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearDistributionDeviation() {
          bitField0_ = (bitField0_ & ~0x00000002);
          distributionDeviation_ = 0D;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue.DistributionDataValue)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue.DistributionDataValue)
      private static final com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint
              .TypedValue.DistributionDataValue
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue
                .DistributionDataValue();
      }

      public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue
              .DistributionDataValue
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<DistributionDataValue> PARSER =
          new com.google.protobuf.AbstractParser<DistributionDataValue>() {
            @java.lang.Override
            public DistributionDataValue parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<DistributionDataValue> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<DistributionDataValue> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue
              .DistributionDataValue
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    private int valueCase_ = 0;

    @SuppressWarnings("serial")
    private java.lang.Object value_;

    public enum ValueCase
        implements
            com.google.protobuf.Internal.EnumLite,
            com.google.protobuf.AbstractMessage.InternalOneOfEnum {
      DOUBLE_VALUE(1),
      DISTRIBUTION_VALUE(2),
      VALUE_NOT_SET(0);
      private final int value;

      private ValueCase(int value) {
        this.value = value;
      }

      /**
       * @param value The number of the enum to look for.
       * @return The enum associated with the given number.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static ValueCase valueOf(int value) {
        return forNumber(value);
      }

      public static ValueCase forNumber(int value) {
        switch (value) {
          case 1:
            return DOUBLE_VALUE;
          case 2:
            return DISTRIBUTION_VALUE;
          case 0:
            return VALUE_NOT_SET;
          default:
            return null;
        }
      }

      public int getNumber() {
        return this.value;
      }
    };

    public ValueCase getValueCase() {
      return ValueCase.forNumber(valueCase_);
    }

    public static final int DOUBLE_VALUE_FIELD_NUMBER = 1;

    /**
     *
     *
     * <pre>
     * Double.
     * </pre>
     *
     * <code>double double_value = 1;</code>
     *
     * @return Whether the doubleValue field is set.
     */
    @java.lang.Override
    public boolean hasDoubleValue() {
      return valueCase_ == 1;
    }

    /**
     *
     *
     * <pre>
     * Double.
     * </pre>
     *
     * <code>double double_value = 1;</code>
     *
     * @return The doubleValue.
     */
    @java.lang.Override
    public double getDoubleValue() {
      if (valueCase_ == 1) {
        return (java.lang.Double) value_;
      }
      return 0D;
    }

    public static final int DISTRIBUTION_VALUE_FIELD_NUMBER = 2;

    /**
     *
     *
     * <pre>
     * Distribution.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue.DistributionDataValue distribution_value = 2;
     * </code>
     *
     * @return Whether the distributionValue field is set.
     */
    @java.lang.Override
    public boolean hasDistributionValue() {
      return valueCase_ == 2;
    }

    /**
     *
     *
     * <pre>
     * Distribution.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue.DistributionDataValue distribution_value = 2;
     * </code>
     *
     * @return The distributionValue.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue
            .DistributionDataValue
        getDistributionValue() {
      if (valueCase_ == 2) {
        return (com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue
                .DistributionDataValue)
            value_;
      }
      return com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue
          .DistributionDataValue.getDefaultInstance();
    }

    /**
     *
     *
     * <pre>
     * Distribution.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue.DistributionDataValue distribution_value = 2;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue
            .DistributionDataValueOrBuilder
        getDistributionValueOrBuilder() {
      if (valueCase_ == 2) {
        return (com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue
                .DistributionDataValue)
            value_;
      }
      return com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue
          .DistributionDataValue.getDefaultInstance();
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (valueCase_ == 1) {
        output.writeDouble(1, (double) ((java.lang.Double) value_));
      }
      if (valueCase_ == 2) {
        output.writeMessage(
            2,
            (com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue
                    .DistributionDataValue)
                value_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (valueCase_ == 1) {
        size +=
            com.google.protobuf.CodedOutputStream.computeDoubleSize(
                1, (double) ((java.lang.Double) value_));
      }
      if (valueCase_ == 2) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                2,
                (com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue
                        .DistributionDataValue)
                    value_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof
          com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue)) {
        return super.equals(obj);
      }
      com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue other =
          (com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue) obj;

      if (!getValueCase().equals(other.getValueCase())) return false;
      switch (valueCase_) {
        case 1:
          if (java.lang.Double.doubleToLongBits(getDoubleValue())
              != java.lang.Double.doubleToLongBits(other.getDoubleValue())) return false;
          break;
        case 2:
          if (!getDistributionValue().equals(other.getDistributionValue())) return false;
          break;
        case 0:
        default:
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      switch (valueCase_) {
        case 1:
          hash = (37 * hash) + DOUBLE_VALUE_FIELD_NUMBER;
          hash =
              (53 * hash)
                  + com.google.protobuf.Internal.hashLong(
                      java.lang.Double.doubleToLongBits(getDoubleValue()));
          break;
        case 2:
          hash = (37 * hash) + DISTRIBUTION_VALUE_FIELD_NUMBER;
          hash = (53 * hash) + getDistributionValue().hashCode();
          break;
        case 0:
        default:
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * Typed value of the statistics.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue)
        com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValueOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsProto
            .internal_static_google_cloud_aiplatform_v1beta1_ModelMonitoringStatsDataPoint_TypedValue_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsProto
            .internal_static_google_cloud_aiplatform_v1beta1_ModelMonitoringStatsDataPoint_TypedValue_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue.class,
                com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        if (distributionValueBuilder_ != null) {
          distributionValueBuilder_.clear();
        }
        valueCase_ = 0;
        value_ = null;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsProto
            .internal_static_google_cloud_aiplatform_v1beta1_ModelMonitoringStatsDataPoint_TypedValue_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue
          getDefaultInstanceForType() {
        return com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue build() {
        com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue
          buildPartial() {
        com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue result =
            new com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        buildPartialOneofs(result);
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue result) {
        int from_bitField0_ = bitField0_;
      }

      private void buildPartialOneofs(
          com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue result) {
        result.valueCase_ = valueCase_;
        result.value_ = this.value_;
        if (valueCase_ == 2 && distributionValueBuilder_ != null) {
          result.value_ = distributionValueBuilder_.build();
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue) {
          return mergeFrom(
              (com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue other) {
        if (other
            == com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue
                .getDefaultInstance()) return this;
        switch (other.getValueCase()) {
          case DOUBLE_VALUE:
            {
              setDoubleValue(other.getDoubleValue());
              break;
            }
          case DISTRIBUTION_VALUE:
            {
              mergeDistributionValue(other.getDistributionValue());
              break;
            }
          case VALUE_NOT_SET:
            {
              break;
            }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 9:
                {
                  value_ = input.readDouble();
                  valueCase_ = 1;
                  break;
                } // case 9
              case 18:
                {
                  input.readMessage(
                      getDistributionValueFieldBuilder().getBuilder(), extensionRegistry);
                  valueCase_ = 2;
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int valueCase_ = 0;
      private java.lang.Object value_;

      public ValueCase getValueCase() {
        return ValueCase.forNumber(valueCase_);
      }

      public Builder clearValue() {
        valueCase_ = 0;
        value_ = null;
        onChanged();
        return this;
      }

      private int bitField0_;

      /**
       *
       *
       * <pre>
       * Double.
       * </pre>
       *
       * <code>double double_value = 1;</code>
       *
       * @return Whether the doubleValue field is set.
       */
      public boolean hasDoubleValue() {
        return valueCase_ == 1;
      }

      /**
       *
       *
       * <pre>
       * Double.
       * </pre>
       *
       * <code>double double_value = 1;</code>
       *
       * @return The doubleValue.
       */
      public double getDoubleValue() {
        if (valueCase_ == 1) {
          return (java.lang.Double) value_;
        }
        return 0D;
      }

      /**
       *
       *
       * <pre>
       * Double.
       * </pre>
       *
       * <code>double double_value = 1;</code>
       *
       * @param value The doubleValue to set.
       * @return This builder for chaining.
       */
      public Builder setDoubleValue(double value) {

        valueCase_ = 1;
        value_ = value;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Double.
       * </pre>
       *
       * <code>double double_value = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearDoubleValue() {
        if (valueCase_ == 1) {
          valueCase_ = 0;
          value_ = null;
          onChanged();
        }
        return this;
      }

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue
                  .DistributionDataValue,
              com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue
                  .DistributionDataValue.Builder,
              com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue
                  .DistributionDataValueOrBuilder>
          distributionValueBuilder_;

      /**
       *
       *
       * <pre>
       * Distribution.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue.DistributionDataValue distribution_value = 2;
       * </code>
       *
       * @return Whether the distributionValue field is set.
       */
      @java.lang.Override
      public boolean hasDistributionValue() {
        return valueCase_ == 2;
      }

      /**
       *
       *
       * <pre>
       * Distribution.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue.DistributionDataValue distribution_value = 2;
       * </code>
       *
       * @return The distributionValue.
       */
      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue
              .DistributionDataValue
          getDistributionValue() {
        if (distributionValueBuilder_ == null) {
          if (valueCase_ == 2) {
            return (com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue
                    .DistributionDataValue)
                value_;
          }
          return com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue
              .DistributionDataValue.getDefaultInstance();
        } else {
          if (valueCase_ == 2) {
            return distributionValueBuilder_.getMessage();
          }
          return com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue
              .DistributionDataValue.getDefaultInstance();
        }
      }

      /**
       *
       *
       * <pre>
       * Distribution.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue.DistributionDataValue distribution_value = 2;
       * </code>
       */
      public Builder setDistributionValue(
          com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue
                  .DistributionDataValue
              value) {
        if (distributionValueBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          value_ = value;
          onChanged();
        } else {
          distributionValueBuilder_.setMessage(value);
        }
        valueCase_ = 2;
        return this;
      }

      /**
       *
       *
       * <pre>
       * Distribution.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue.DistributionDataValue distribution_value = 2;
       * </code>
       */
      public Builder setDistributionValue(
          com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue
                  .DistributionDataValue.Builder
              builderForValue) {
        if (distributionValueBuilder_ == null) {
          value_ = builderForValue.build();
          onChanged();
        } else {
          distributionValueBuilder_.setMessage(builderForValue.build());
        }
        valueCase_ = 2;
        return this;
      }

      /**
       *
       *
       * <pre>
       * Distribution.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue.DistributionDataValue distribution_value = 2;
       * </code>
       */
      public Builder mergeDistributionValue(
          com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue
                  .DistributionDataValue
              value) {
        if (distributionValueBuilder_ == null) {
          if (valueCase_ == 2
              && value_
                  != com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue
                      .DistributionDataValue.getDefaultInstance()) {
            value_ =
                com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue
                    .DistributionDataValue.newBuilder(
                        (com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint
                                .TypedValue.DistributionDataValue)
                            value_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            value_ = value;
          }
          onChanged();
        } else {
          if (valueCase_ == 2) {
            distributionValueBuilder_.mergeFrom(value);
          } else {
            distributionValueBuilder_.setMessage(value);
          }
        }
        valueCase_ = 2;
        return this;
      }

      /**
       *
       *
       * <pre>
       * Distribution.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue.DistributionDataValue distribution_value = 2;
       * </code>
       */
      public Builder clearDistributionValue() {
        if (distributionValueBuilder_ == null) {
          if (valueCase_ == 2) {
            valueCase_ = 0;
            value_ = null;
            onChanged();
          }
        } else {
          if (valueCase_ == 2) {
            valueCase_ = 0;
            value_ = null;
          }
          distributionValueBuilder_.clear();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Distribution.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue.DistributionDataValue distribution_value = 2;
       * </code>
       */
      public com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue
              .DistributionDataValue.Builder
          getDistributionValueBuilder() {
        return getDistributionValueFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * Distribution.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue.DistributionDataValue distribution_value = 2;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue
              .DistributionDataValueOrBuilder
          getDistributionValueOrBuilder() {
        if ((valueCase_ == 2) && (distributionValueBuilder_ != null)) {
          return distributionValueBuilder_.getMessageOrBuilder();
        } else {
          if (valueCase_ == 2) {
            return (com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue
                    .DistributionDataValue)
                value_;
          }
          return com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue
              .DistributionDataValue.getDefaultInstance();
        }
      }

      /**
       *
       *
       * <pre>
       * Distribution.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue.DistributionDataValue distribution_value = 2;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue
                  .DistributionDataValue,
              com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue
                  .DistributionDataValue.Builder,
              com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue
                  .DistributionDataValueOrBuilder>
          getDistributionValueFieldBuilder() {
        if (distributionValueBuilder_ == null) {
          if (!(valueCase_ == 2)) {
            value_ =
                com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue
                    .DistributionDataValue.getDefaultInstance();
          }
          distributionValueBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue
                      .DistributionDataValue,
                  com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue
                      .DistributionDataValue.Builder,
                  com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue
                      .DistributionDataValueOrBuilder>(
                  (com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue
                          .DistributionDataValue)
                      value_,
                  getParentForChildren(),
                  isClean());
          value_ = null;
        }
        valueCase_ = 2;
        onChanged();
        return distributionValueBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue)
    private static final com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint
            .TypedValue
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue();
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<TypedValue> PARSER =
        new com.google.protobuf.AbstractParser<TypedValue>() {
          @java.lang.Override
          public TypedValue parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<TypedValue> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<TypedValue> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  public static final int CURRENT_STATS_FIELD_NUMBER = 1;
  private com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue
      currentStats_;

  /**
   *
   *
   * <pre>
   * Statistics from current dataset.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue current_stats = 1;
   * </code>
   *
   * @return Whether the currentStats field is set.
   */
  @java.lang.Override
  public boolean hasCurrentStats() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * Statistics from current dataset.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue current_stats = 1;
   * </code>
   *
   * @return The currentStats.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue
      getCurrentStats() {
    return currentStats_ == null
        ? com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue
            .getDefaultInstance()
        : currentStats_;
  }

  /**
   *
   *
   * <pre>
   * Statistics from current dataset.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue current_stats = 1;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValueOrBuilder
      getCurrentStatsOrBuilder() {
    return currentStats_ == null
        ? com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue
            .getDefaultInstance()
        : currentStats_;
  }

  public static final int BASELINE_STATS_FIELD_NUMBER = 2;
  private com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue
      baselineStats_;

  /**
   *
   *
   * <pre>
   * Statistics from baseline dataset.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue baseline_stats = 2;
   * </code>
   *
   * @return Whether the baselineStats field is set.
   */
  @java.lang.Override
  public boolean hasBaselineStats() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * Statistics from baseline dataset.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue baseline_stats = 2;
   * </code>
   *
   * @return The baselineStats.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue
      getBaselineStats() {
    return baselineStats_ == null
        ? com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue
            .getDefaultInstance()
        : baselineStats_;
  }

  /**
   *
   *
   * <pre>
   * Statistics from baseline dataset.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue baseline_stats = 2;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValueOrBuilder
      getBaselineStatsOrBuilder() {
    return baselineStats_ == null
        ? com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue
            .getDefaultInstance()
        : baselineStats_;
  }

  public static final int THRESHOLD_VALUE_FIELD_NUMBER = 3;
  private double thresholdValue_ = 0D;

  /**
   *
   *
   * <pre>
   * Threshold value.
   * </pre>
   *
   * <code>double threshold_value = 3;</code>
   *
   * @return The thresholdValue.
   */
  @java.lang.Override
  public double getThresholdValue() {
    return thresholdValue_;
  }

  public static final int HAS_ANOMALY_FIELD_NUMBER = 4;
  private boolean hasAnomaly_ = false;

  /**
   *
   *
   * <pre>
   * Indicate if the statistics has anomaly.
   * </pre>
   *
   * <code>bool has_anomaly = 4;</code>
   *
   * @return The hasAnomaly.
   */
  @java.lang.Override
  public boolean getHasAnomaly() {
    return hasAnomaly_;
  }

  public static final int MODEL_MONITORING_JOB_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private volatile java.lang.Object modelMonitoringJob_ = "";

  /**
   *
   *
   * <pre>
   * Model monitoring job resource name.
   * </pre>
   *
   * <code>string model_monitoring_job = 5;</code>
   *
   * @return The modelMonitoringJob.
   */
  @java.lang.Override
  public java.lang.String getModelMonitoringJob() {
    java.lang.Object ref = modelMonitoringJob_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      modelMonitoringJob_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Model monitoring job resource name.
   * </pre>
   *
   * <code>string model_monitoring_job = 5;</code>
   *
   * @return The bytes for modelMonitoringJob.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getModelMonitoringJobBytes() {
    java.lang.Object ref = modelMonitoringJob_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      modelMonitoringJob_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SCHEDULE_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private volatile java.lang.Object schedule_ = "";

  /**
   *
   *
   * <pre>
   * Schedule resource name.
   * </pre>
   *
   * <code>string schedule = 6;</code>
   *
   * @return The schedule.
   */
  @java.lang.Override
  public java.lang.String getSchedule() {
    java.lang.Object ref = schedule_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      schedule_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Schedule resource name.
   * </pre>
   *
   * <code>string schedule = 6;</code>
   *
   * @return The bytes for schedule.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getScheduleBytes() {
    java.lang.Object ref = schedule_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      schedule_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 7;
  private com.google.protobuf.Timestamp createTime_;

  /**
   *
   *
   * <pre>
   * Statistics create time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 7;</code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return ((bitField0_ & 0x00000004) != 0);
  }

  /**
   *
   *
   * <pre>
   * Statistics create time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 7;</code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  /**
   *
   *
   * <pre>
   * Statistics create time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 7;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int ALGORITHM_FIELD_NUMBER = 8;

  @SuppressWarnings("serial")
  private volatile java.lang.Object algorithm_ = "";

  /**
   *
   *
   * <pre>
   * Algorithm used to calculated the metrics, eg: jensen_shannon_divergence,
   * l_infinity.
   * </pre>
   *
   * <code>string algorithm = 8;</code>
   *
   * @return The algorithm.
   */
  @java.lang.Override
  public java.lang.String getAlgorithm() {
    java.lang.Object ref = algorithm_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      algorithm_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Algorithm used to calculated the metrics, eg: jensen_shannon_divergence,
   * l_infinity.
   * </pre>
   *
   * <code>string algorithm = 8;</code>
   *
   * @return The bytes for algorithm.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getAlgorithmBytes() {
    java.lang.Object ref = algorithm_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      algorithm_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(1, getCurrentStats());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(2, getBaselineStats());
    }
    if (java.lang.Double.doubleToRawLongBits(thresholdValue_) != 0) {
      output.writeDouble(3, thresholdValue_);
    }
    if (hasAnomaly_ != false) {
      output.writeBool(4, hasAnomaly_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(modelMonitoringJob_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, modelMonitoringJob_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(schedule_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, schedule_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(7, getCreateTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(algorithm_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 8, algorithm_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getCurrentStats());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getBaselineStats());
    }
    if (java.lang.Double.doubleToRawLongBits(thresholdValue_) != 0) {
      size += com.google.protobuf.CodedOutputStream.computeDoubleSize(3, thresholdValue_);
    }
    if (hasAnomaly_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(4, hasAnomaly_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(modelMonitoringJob_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, modelMonitoringJob_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(schedule_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, schedule_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getCreateTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(algorithm_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(8, algorithm_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint other =
        (com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint) obj;

    if (hasCurrentStats() != other.hasCurrentStats()) return false;
    if (hasCurrentStats()) {
      if (!getCurrentStats().equals(other.getCurrentStats())) return false;
    }
    if (hasBaselineStats() != other.hasBaselineStats()) return false;
    if (hasBaselineStats()) {
      if (!getBaselineStats().equals(other.getBaselineStats())) return false;
    }
    if (java.lang.Double.doubleToLongBits(getThresholdValue())
        != java.lang.Double.doubleToLongBits(other.getThresholdValue())) return false;
    if (getHasAnomaly() != other.getHasAnomaly()) return false;
    if (!getModelMonitoringJob().equals(other.getModelMonitoringJob())) return false;
    if (!getSchedule().equals(other.getSchedule())) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (!getAlgorithm().equals(other.getAlgorithm())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasCurrentStats()) {
      hash = (37 * hash) + CURRENT_STATS_FIELD_NUMBER;
      hash = (53 * hash) + getCurrentStats().hashCode();
    }
    if (hasBaselineStats()) {
      hash = (37 * hash) + BASELINE_STATS_FIELD_NUMBER;
      hash = (53 * hash) + getBaselineStats().hashCode();
    }
    hash = (37 * hash) + THRESHOLD_VALUE_FIELD_NUMBER;
    hash =
        (53 * hash)
            + com.google.protobuf.Internal.hashLong(
                java.lang.Double.doubleToLongBits(getThresholdValue()));
    hash = (37 * hash) + HAS_ANOMALY_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getHasAnomaly());
    hash = (37 * hash) + MODEL_MONITORING_JOB_FIELD_NUMBER;
    hash = (53 * hash) + getModelMonitoringJob().hashCode();
    hash = (37 * hash) + SCHEDULE_FIELD_NUMBER;
    hash = (53 * hash) + getSchedule().hashCode();
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    hash = (37 * hash) + ALGORITHM_FIELD_NUMBER;
    hash = (53 * hash) + getAlgorithm().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint parseFrom(
      byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint
      parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint
      parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Represents a single statistics data point.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint)
      com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPointOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsProto
          .internal_static_google_cloud_aiplatform_v1beta1_ModelMonitoringStatsDataPoint_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsProto
          .internal_static_google_cloud_aiplatform_v1beta1_ModelMonitoringStatsDataPoint_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.class,
              com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.Builder.class);
    }

    // Construct using
    // com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getCurrentStatsFieldBuilder();
        getBaselineStatsFieldBuilder();
        getCreateTimeFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      currentStats_ = null;
      if (currentStatsBuilder_ != null) {
        currentStatsBuilder_.dispose();
        currentStatsBuilder_ = null;
      }
      baselineStats_ = null;
      if (baselineStatsBuilder_ != null) {
        baselineStatsBuilder_.dispose();
        baselineStatsBuilder_ = null;
      }
      thresholdValue_ = 0D;
      hasAnomaly_ = false;
      modelMonitoringJob_ = "";
      schedule_ = "";
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      algorithm_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsProto
          .internal_static_google_cloud_aiplatform_v1beta1_ModelMonitoringStatsDataPoint_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint
        getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint build() {
      com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint buildPartial() {
      com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint result =
          new com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(
        com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.currentStats_ =
            currentStatsBuilder_ == null ? currentStats_ : currentStatsBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.baselineStats_ =
            baselineStatsBuilder_ == null ? baselineStats_ : baselineStatsBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.thresholdValue_ = thresholdValue_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.hasAnomaly_ = hasAnomaly_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.modelMonitoringJob_ = modelMonitoringJob_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.schedule_ = schedule_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.algorithm_ = algorithm_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint) {
        return mergeFrom((com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(
        com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint other) {
      if (other
          == com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.getDefaultInstance())
        return this;
      if (other.hasCurrentStats()) {
        mergeCurrentStats(other.getCurrentStats());
      }
      if (other.hasBaselineStats()) {
        mergeBaselineStats(other.getBaselineStats());
      }
      if (other.getThresholdValue() != 0D) {
        setThresholdValue(other.getThresholdValue());
      }
      if (other.getHasAnomaly() != false) {
        setHasAnomaly(other.getHasAnomaly());
      }
      if (!other.getModelMonitoringJob().isEmpty()) {
        modelMonitoringJob_ = other.modelMonitoringJob_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (!other.getSchedule().isEmpty()) {
        schedule_ = other.schedule_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (!other.getAlgorithm().isEmpty()) {
        algorithm_ = other.algorithm_;
        bitField0_ |= 0x00000080;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getCurrentStatsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getBaselineStatsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 25:
              {
                thresholdValue_ = input.readDouble();
                bitField0_ |= 0x00000004;
                break;
              } // case 25
            case 32:
              {
                hasAnomaly_ = input.readBool();
                bitField0_ |= 0x00000008;
                break;
              } // case 32
            case 42:
              {
                modelMonitoringJob_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 50:
              {
                schedule_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 50
            case 58:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000040;
                break;
              } // case 58
            case 66:
              {
                algorithm_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000080;
                break;
              } // case 66
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue
        currentStats_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue,
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue.Builder,
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValueOrBuilder>
        currentStatsBuilder_;

    /**
     *
     *
     * <pre>
     * Statistics from current dataset.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue current_stats = 1;
     * </code>
     *
     * @return Whether the currentStats field is set.
     */
    public boolean hasCurrentStats() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * Statistics from current dataset.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue current_stats = 1;
     * </code>
     *
     * @return The currentStats.
     */
    public com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue
        getCurrentStats() {
      if (currentStatsBuilder_ == null) {
        return currentStats_ == null
            ? com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue
                .getDefaultInstance()
            : currentStats_;
      } else {
        return currentStatsBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Statistics from current dataset.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue current_stats = 1;
     * </code>
     */
    public Builder setCurrentStats(
        com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue value) {
      if (currentStatsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        currentStats_ = value;
      } else {
        currentStatsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Statistics from current dataset.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue current_stats = 1;
     * </code>
     */
    public Builder setCurrentStats(
        com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue.Builder
            builderForValue) {
      if (currentStatsBuilder_ == null) {
        currentStats_ = builderForValue.build();
      } else {
        currentStatsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Statistics from current dataset.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue current_stats = 1;
     * </code>
     */
    public Builder mergeCurrentStats(
        com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue value) {
      if (currentStatsBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)
            && currentStats_ != null
            && currentStats_
                != com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue
                    .getDefaultInstance()) {
          getCurrentStatsBuilder().mergeFrom(value);
        } else {
          currentStats_ = value;
        }
      } else {
        currentStatsBuilder_.mergeFrom(value);
      }
      if (currentStats_ != null) {
        bitField0_ |= 0x00000001;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Statistics from current dataset.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue current_stats = 1;
     * </code>
     */
    public Builder clearCurrentStats() {
      bitField0_ = (bitField0_ & ~0x00000001);
      currentStats_ = null;
      if (currentStatsBuilder_ != null) {
        currentStatsBuilder_.dispose();
        currentStatsBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Statistics from current dataset.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue current_stats = 1;
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue.Builder
        getCurrentStatsBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getCurrentStatsFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Statistics from current dataset.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue current_stats = 1;
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValueOrBuilder
        getCurrentStatsOrBuilder() {
      if (currentStatsBuilder_ != null) {
        return currentStatsBuilder_.getMessageOrBuilder();
      } else {
        return currentStats_ == null
            ? com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue
                .getDefaultInstance()
            : currentStats_;
      }
    }

    /**
     *
     *
     * <pre>
     * Statistics from current dataset.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue current_stats = 1;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue,
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue.Builder,
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValueOrBuilder>
        getCurrentStatsFieldBuilder() {
      if (currentStatsBuilder_ == null) {
        currentStatsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue,
                com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue
                    .Builder,
                com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint
                    .TypedValueOrBuilder>(getCurrentStats(), getParentForChildren(), isClean());
        currentStats_ = null;
      }
      return currentStatsBuilder_;
    }

    private com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue
        baselineStats_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue,
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue.Builder,
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValueOrBuilder>
        baselineStatsBuilder_;

    /**
     *
     *
     * <pre>
     * Statistics from baseline dataset.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue baseline_stats = 2;
     * </code>
     *
     * @return Whether the baselineStats field is set.
     */
    public boolean hasBaselineStats() {
      return ((bitField0_ & 0x00000002) != 0);
    }

    /**
     *
     *
     * <pre>
     * Statistics from baseline dataset.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue baseline_stats = 2;
     * </code>
     *
     * @return The baselineStats.
     */
    public com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue
        getBaselineStats() {
      if (baselineStatsBuilder_ == null) {
        return baselineStats_ == null
            ? com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue
                .getDefaultInstance()
            : baselineStats_;
      } else {
        return baselineStatsBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Statistics from baseline dataset.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue baseline_stats = 2;
     * </code>
     */
    public Builder setBaselineStats(
        com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue value) {
      if (baselineStatsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        baselineStats_ = value;
      } else {
        baselineStatsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Statistics from baseline dataset.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue baseline_stats = 2;
     * </code>
     */
    public Builder setBaselineStats(
        com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue.Builder
            builderForValue) {
      if (baselineStatsBuilder_ == null) {
        baselineStats_ = builderForValue.build();
      } else {
        baselineStatsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Statistics from baseline dataset.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue baseline_stats = 2;
     * </code>
     */
    public Builder mergeBaselineStats(
        com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue value) {
      if (baselineStatsBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && baselineStats_ != null
            && baselineStats_
                != com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue
                    .getDefaultInstance()) {
          getBaselineStatsBuilder().mergeFrom(value);
        } else {
          baselineStats_ = value;
        }
      } else {
        baselineStatsBuilder_.mergeFrom(value);
      }
      if (baselineStats_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Statistics from baseline dataset.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue baseline_stats = 2;
     * </code>
     */
    public Builder clearBaselineStats() {
      bitField0_ = (bitField0_ & ~0x00000002);
      baselineStats_ = null;
      if (baselineStatsBuilder_ != null) {
        baselineStatsBuilder_.dispose();
        baselineStatsBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Statistics from baseline dataset.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue baseline_stats = 2;
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue.Builder
        getBaselineStatsBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getBaselineStatsFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Statistics from baseline dataset.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue baseline_stats = 2;
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValueOrBuilder
        getBaselineStatsOrBuilder() {
      if (baselineStatsBuilder_ != null) {
        return baselineStatsBuilder_.getMessageOrBuilder();
      } else {
        return baselineStats_ == null
            ? com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue
                .getDefaultInstance()
            : baselineStats_;
      }
    }

    /**
     *
     *
     * <pre>
     * Statistics from baseline dataset.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue baseline_stats = 2;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue,
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue.Builder,
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValueOrBuilder>
        getBaselineStatsFieldBuilder() {
      if (baselineStatsBuilder_ == null) {
        baselineStatsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue,
                com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue
                    .Builder,
                com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint
                    .TypedValueOrBuilder>(getBaselineStats(), getParentForChildren(), isClean());
        baselineStats_ = null;
      }
      return baselineStatsBuilder_;
    }

    private double thresholdValue_;

    /**
     *
     *
     * <pre>
     * Threshold value.
     * </pre>
     *
     * <code>double threshold_value = 3;</code>
     *
     * @return The thresholdValue.
     */
    @java.lang.Override
    public double getThresholdValue() {
      return thresholdValue_;
    }

    /**
     *
     *
     * <pre>
     * Threshold value.
     * </pre>
     *
     * <code>double threshold_value = 3;</code>
     *
     * @param value The thresholdValue to set.
     * @return This builder for chaining.
     */
    public Builder setThresholdValue(double value) {

      thresholdValue_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Threshold value.
     * </pre>
     *
     * <code>double threshold_value = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearThresholdValue() {
      bitField0_ = (bitField0_ & ~0x00000004);
      thresholdValue_ = 0D;
      onChanged();
      return this;
    }

    private boolean hasAnomaly_;

    /**
     *
     *
     * <pre>
     * Indicate if the statistics has anomaly.
     * </pre>
     *
     * <code>bool has_anomaly = 4;</code>
     *
     * @return The hasAnomaly.
     */
    @java.lang.Override
    public boolean getHasAnomaly() {
      return hasAnomaly_;
    }

    /**
     *
     *
     * <pre>
     * Indicate if the statistics has anomaly.
     * </pre>
     *
     * <code>bool has_anomaly = 4;</code>
     *
     * @param value The hasAnomaly to set.
     * @return This builder for chaining.
     */
    public Builder setHasAnomaly(boolean value) {

      hasAnomaly_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Indicate if the statistics has anomaly.
     * </pre>
     *
     * <code>bool has_anomaly = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearHasAnomaly() {
      bitField0_ = (bitField0_ & ~0x00000008);
      hasAnomaly_ = false;
      onChanged();
      return this;
    }

    private java.lang.Object modelMonitoringJob_ = "";

    /**
     *
     *
     * <pre>
     * Model monitoring job resource name.
     * </pre>
     *
     * <code>string model_monitoring_job = 5;</code>
     *
     * @return The modelMonitoringJob.
     */
    public java.lang.String getModelMonitoringJob() {
      java.lang.Object ref = modelMonitoringJob_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        modelMonitoringJob_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Model monitoring job resource name.
     * </pre>
     *
     * <code>string model_monitoring_job = 5;</code>
     *
     * @return The bytes for modelMonitoringJob.
     */
    public com.google.protobuf.ByteString getModelMonitoringJobBytes() {
      java.lang.Object ref = modelMonitoringJob_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        modelMonitoringJob_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Model monitoring job resource name.
     * </pre>
     *
     * <code>string model_monitoring_job = 5;</code>
     *
     * @param value The modelMonitoringJob to set.
     * @return This builder for chaining.
     */
    public Builder setModelMonitoringJob(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      modelMonitoringJob_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Model monitoring job resource name.
     * </pre>
     *
     * <code>string model_monitoring_job = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearModelMonitoringJob() {
      modelMonitoringJob_ = getDefaultInstance().getModelMonitoringJob();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Model monitoring job resource name.
     * </pre>
     *
     * <code>string model_monitoring_job = 5;</code>
     *
     * @param value The bytes for modelMonitoringJob to set.
     * @return This builder for chaining.
     */
    public Builder setModelMonitoringJobBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      modelMonitoringJob_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private java.lang.Object schedule_ = "";

    /**
     *
     *
     * <pre>
     * Schedule resource name.
     * </pre>
     *
     * <code>string schedule = 6;</code>
     *
     * @return The schedule.
     */
    public java.lang.String getSchedule() {
      java.lang.Object ref = schedule_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        schedule_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Schedule resource name.
     * </pre>
     *
     * <code>string schedule = 6;</code>
     *
     * @return The bytes for schedule.
     */
    public com.google.protobuf.ByteString getScheduleBytes() {
      java.lang.Object ref = schedule_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        schedule_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Schedule resource name.
     * </pre>
     *
     * <code>string schedule = 6;</code>
     *
     * @param value The schedule to set.
     * @return This builder for chaining.
     */
    public Builder setSchedule(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      schedule_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Schedule resource name.
     * </pre>
     *
     * <code>string schedule = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSchedule() {
      schedule_ = getDefaultInstance().getSchedule();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Schedule resource name.
     * </pre>
     *
     * <code>string schedule = 6;</code>
     *
     * @param value The bytes for schedule to set.
     * @return This builder for chaining.
     */
    public Builder setScheduleBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      schedule_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;

    /**
     *
     *
     * <pre>
     * Statistics create time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 7;</code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000040) != 0);
    }

    /**
     *
     *
     * <pre>
     * Statistics create time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 7;</code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Statistics create time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 7;</code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Statistics create time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 7;</code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Statistics create time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 7;</code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      if (createTime_ != null) {
        bitField0_ |= 0x00000040;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Statistics create time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 7;</code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000040);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Statistics create time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 7;</code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000040;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Statistics create time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 7;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }

    /**
     *
     *
     * <pre>
     * Statistics create time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 7;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private java.lang.Object algorithm_ = "";

    /**
     *
     *
     * <pre>
     * Algorithm used to calculated the metrics, eg: jensen_shannon_divergence,
     * l_infinity.
     * </pre>
     *
     * <code>string algorithm = 8;</code>
     *
     * @return The algorithm.
     */
    public java.lang.String getAlgorithm() {
      java.lang.Object ref = algorithm_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        algorithm_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Algorithm used to calculated the metrics, eg: jensen_shannon_divergence,
     * l_infinity.
     * </pre>
     *
     * <code>string algorithm = 8;</code>
     *
     * @return The bytes for algorithm.
     */
    public com.google.protobuf.ByteString getAlgorithmBytes() {
      java.lang.Object ref = algorithm_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        algorithm_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Algorithm used to calculated the metrics, eg: jensen_shannon_divergence,
     * l_infinity.
     * </pre>
     *
     * <code>string algorithm = 8;</code>
     *
     * @param value The algorithm to set.
     * @return This builder for chaining.
     */
    public Builder setAlgorithm(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      algorithm_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Algorithm used to calculated the metrics, eg: jensen_shannon_divergence,
     * l_infinity.
     * </pre>
     *
     * <code>string algorithm = 8;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAlgorithm() {
      algorithm_ = getDefaultInstance().getAlgorithm();
      bitField0_ = (bitField0_ & ~0x00000080);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Algorithm used to calculated the metrics, eg: jensen_shannon_divergence,
     * l_infinity.
     * </pre>
     *
     * <code>string algorithm = 8;</code>
     *
     * @param value The bytes for algorithm to set.
     * @return This builder for chaining.
     */
    public Builder setAlgorithmBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      algorithm_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint)
  private static final com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint();
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ModelMonitoringStatsDataPoint> PARSER =
      new com.google.protobuf.AbstractParser<ModelMonitoringStatsDataPoint>() {
        @java.lang.Override
        public ModelMonitoringStatsDataPoint parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ModelMonitoringStatsDataPoint> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ModelMonitoringStatsDataPoint> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
