/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1beta1/tuning_job.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.aiplatform.v1beta1;

/**
 *
 *
 * <pre>
 * Tuning spec for Partner models.
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1beta1.PartnerModelTuningSpec}
 */
public final class PartnerModelTuningSpec extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.PartnerModelTuningSpec)
    PartnerModelTuningSpecOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use PartnerModelTuningSpec.newBuilder() to construct.
  private PartnerModelTuningSpec(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private PartnerModelTuningSpec() {
    trainingDatasetUri_ = "";
    validationDatasetUri_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new PartnerModelTuningSpec();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1beta1.TuningJobProto
        .internal_static_google_cloud_aiplatform_v1beta1_PartnerModelTuningSpec_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
      int number) {
    switch (number) {
      case 3:
        return internalGetHyperParameters();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1beta1.TuningJobProto
        .internal_static_google_cloud_aiplatform_v1beta1_PartnerModelTuningSpec_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1beta1.PartnerModelTuningSpec.class,
            com.google.cloud.aiplatform.v1beta1.PartnerModelTuningSpec.Builder.class);
  }

  public static final int TRAINING_DATASET_URI_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object trainingDatasetUri_ = "";

  /**
   *
   *
   * <pre>
   * Required. Cloud Storage path to file containing training dataset for
   * tuning. The dataset must be formatted as a JSONL file.
   * </pre>
   *
   * <code>string training_dataset_uri = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The trainingDatasetUri.
   */
  @java.lang.Override
  public java.lang.String getTrainingDatasetUri() {
    java.lang.Object ref = trainingDatasetUri_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      trainingDatasetUri_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Required. Cloud Storage path to file containing training dataset for
   * tuning. The dataset must be formatted as a JSONL file.
   * </pre>
   *
   * <code>string training_dataset_uri = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for trainingDatasetUri.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getTrainingDatasetUriBytes() {
    java.lang.Object ref = trainingDatasetUri_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      trainingDatasetUri_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int VALIDATION_DATASET_URI_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object validationDatasetUri_ = "";

  /**
   *
   *
   * <pre>
   * Optional. Cloud Storage path to file containing validation dataset for
   * tuning. The dataset must be formatted as a JSONL file.
   * </pre>
   *
   * <code>string validation_dataset_uri = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The validationDatasetUri.
   */
  @java.lang.Override
  public java.lang.String getValidationDatasetUri() {
    java.lang.Object ref = validationDatasetUri_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      validationDatasetUri_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Optional. Cloud Storage path to file containing validation dataset for
   * tuning. The dataset must be formatted as a JSONL file.
   * </pre>
   *
   * <code>string validation_dataset_uri = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for validationDatasetUri.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getValidationDatasetUriBytes() {
    java.lang.Object ref = validationDatasetUri_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      validationDatasetUri_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int HYPER_PARAMETERS_FIELD_NUMBER = 3;

  private static final class HyperParametersDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, com.google.protobuf.Value>
        defaultEntry =
            com.google.protobuf.MapEntry
                .<java.lang.String, com.google.protobuf.Value>newDefaultInstance(
                    com.google.cloud.aiplatform.v1beta1.TuningJobProto
                        .internal_static_google_cloud_aiplatform_v1beta1_PartnerModelTuningSpec_HyperParametersEntry_descriptor,
                    com.google.protobuf.WireFormat.FieldType.STRING,
                    "",
                    com.google.protobuf.WireFormat.FieldType.MESSAGE,
                    com.google.protobuf.Value.getDefaultInstance());
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, com.google.protobuf.Value>
      hyperParameters_;

  private com.google.protobuf.MapField<java.lang.String, com.google.protobuf.Value>
      internalGetHyperParameters() {
    if (hyperParameters_ == null) {
      return com.google.protobuf.MapField.emptyMapField(
          HyperParametersDefaultEntryHolder.defaultEntry);
    }
    return hyperParameters_;
  }

  public int getHyperParametersCount() {
    return internalGetHyperParameters().getMap().size();
  }

  /**
   *
   *
   * <pre>
   * Hyperparameters for tuning. The accepted hyper_parameters and their valid
   * range of values will differ depending on the base model.
   * </pre>
   *
   * <code>map&lt;string, .google.protobuf.Value&gt; hyper_parameters = 3;</code>
   */
  @java.lang.Override
  public boolean containsHyperParameters(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetHyperParameters().getMap().containsKey(key);
  }

  /** Use {@link #getHyperParametersMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, com.google.protobuf.Value> getHyperParameters() {
    return getHyperParametersMap();
  }

  /**
   *
   *
   * <pre>
   * Hyperparameters for tuning. The accepted hyper_parameters and their valid
   * range of values will differ depending on the base model.
   * </pre>
   *
   * <code>map&lt;string, .google.protobuf.Value&gt; hyper_parameters = 3;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, com.google.protobuf.Value> getHyperParametersMap() {
    return internalGetHyperParameters().getMap();
  }

  /**
   *
   *
   * <pre>
   * Hyperparameters for tuning. The accepted hyper_parameters and their valid
   * range of values will differ depending on the base model.
   * </pre>
   *
   * <code>map&lt;string, .google.protobuf.Value&gt; hyper_parameters = 3;</code>
   */
  @java.lang.Override
  public /* nullable */ com.google.protobuf.Value getHyperParametersOrDefault(
      java.lang.String key,
      /* nullable */
      com.google.protobuf.Value defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, com.google.protobuf.Value> map =
        internalGetHyperParameters().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }

  /**
   *
   *
   * <pre>
   * Hyperparameters for tuning. The accepted hyper_parameters and their valid
   * range of values will differ depending on the base model.
   * </pre>
   *
   * <code>map&lt;string, .google.protobuf.Value&gt; hyper_parameters = 3;</code>
   */
  @java.lang.Override
  public com.google.protobuf.Value getHyperParametersOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, com.google.protobuf.Value> map =
        internalGetHyperParameters().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(trainingDatasetUri_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, trainingDatasetUri_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(validationDatasetUri_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, validationDatasetUri_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetHyperParameters(), HyperParametersDefaultEntryHolder.defaultEntry, 3);
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(trainingDatasetUri_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, trainingDatasetUri_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(validationDatasetUri_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, validationDatasetUri_);
    }
    for (java.util.Map.Entry<java.lang.String, com.google.protobuf.Value> entry :
        internalGetHyperParameters().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, com.google.protobuf.Value> hyperParameters__ =
          HyperParametersDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, hyperParameters__);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.PartnerModelTuningSpec)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1beta1.PartnerModelTuningSpec other =
        (com.google.cloud.aiplatform.v1beta1.PartnerModelTuningSpec) obj;

    if (!getTrainingDatasetUri().equals(other.getTrainingDatasetUri())) return false;
    if (!getValidationDatasetUri().equals(other.getValidationDatasetUri())) return false;
    if (!internalGetHyperParameters().equals(other.internalGetHyperParameters())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + TRAINING_DATASET_URI_FIELD_NUMBER;
    hash = (53 * hash) + getTrainingDatasetUri().hashCode();
    hash = (37 * hash) + VALIDATION_DATASET_URI_FIELD_NUMBER;
    hash = (53 * hash) + getValidationDatasetUri().hashCode();
    if (!internalGetHyperParameters().getMap().isEmpty()) {
      hash = (37 * hash) + HYPER_PARAMETERS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetHyperParameters().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1beta1.PartnerModelTuningSpec parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.PartnerModelTuningSpec parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.PartnerModelTuningSpec parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.PartnerModelTuningSpec parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.PartnerModelTuningSpec parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.PartnerModelTuningSpec parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.PartnerModelTuningSpec parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.PartnerModelTuningSpec parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.PartnerModelTuningSpec parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.PartnerModelTuningSpec parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.PartnerModelTuningSpec parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.PartnerModelTuningSpec parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.aiplatform.v1beta1.PartnerModelTuningSpec prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Tuning spec for Partner models.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.PartnerModelTuningSpec}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.PartnerModelTuningSpec)
      com.google.cloud.aiplatform.v1beta1.PartnerModelTuningSpecOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.TuningJobProto
          .internal_static_google_cloud_aiplatform_v1beta1_PartnerModelTuningSpec_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 3:
          return internalGetHyperParameters();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
        int number) {
      switch (number) {
        case 3:
          return internalGetMutableHyperParameters();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.TuningJobProto
          .internal_static_google_cloud_aiplatform_v1beta1_PartnerModelTuningSpec_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.PartnerModelTuningSpec.class,
              com.google.cloud.aiplatform.v1beta1.PartnerModelTuningSpec.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1beta1.PartnerModelTuningSpec.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      trainingDatasetUri_ = "";
      validationDatasetUri_ = "";
      internalGetMutableHyperParameters().clear();
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1beta1.TuningJobProto
          .internal_static_google_cloud_aiplatform_v1beta1_PartnerModelTuningSpec_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.PartnerModelTuningSpec getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1beta1.PartnerModelTuningSpec.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.PartnerModelTuningSpec build() {
      com.google.cloud.aiplatform.v1beta1.PartnerModelTuningSpec result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.PartnerModelTuningSpec buildPartial() {
      com.google.cloud.aiplatform.v1beta1.PartnerModelTuningSpec result =
          new com.google.cloud.aiplatform.v1beta1.PartnerModelTuningSpec(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.aiplatform.v1beta1.PartnerModelTuningSpec result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.trainingDatasetUri_ = trainingDatasetUri_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.validationDatasetUri_ = validationDatasetUri_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.hyperParameters_ =
            internalGetHyperParameters().build(HyperParametersDefaultEntryHolder.defaultEntry);
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1beta1.PartnerModelTuningSpec) {
        return mergeFrom((com.google.cloud.aiplatform.v1beta1.PartnerModelTuningSpec) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1beta1.PartnerModelTuningSpec other) {
      if (other == com.google.cloud.aiplatform.v1beta1.PartnerModelTuningSpec.getDefaultInstance())
        return this;
      if (!other.getTrainingDatasetUri().isEmpty()) {
        trainingDatasetUri_ = other.trainingDatasetUri_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getValidationDatasetUri().isEmpty()) {
        validationDatasetUri_ = other.validationDatasetUri_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      internalGetMutableHyperParameters().mergeFrom(other.internalGetHyperParameters());
      bitField0_ |= 0x00000004;
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                trainingDatasetUri_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                validationDatasetUri_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                com.google.protobuf.MapEntry<java.lang.String, com.google.protobuf.Value>
                    hyperParameters__ =
                        input.readMessage(
                            HyperParametersDefaultEntryHolder.defaultEntry.getParserForType(),
                            extensionRegistry);
                internalGetMutableHyperParameters()
                    .ensureBuilderMap()
                    .put(hyperParameters__.getKey(), hyperParameters__.getValue());
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object trainingDatasetUri_ = "";

    /**
     *
     *
     * <pre>
     * Required. Cloud Storage path to file containing training dataset for
     * tuning. The dataset must be formatted as a JSONL file.
     * </pre>
     *
     * <code>string training_dataset_uri = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The trainingDatasetUri.
     */
    public java.lang.String getTrainingDatasetUri() {
      java.lang.Object ref = trainingDatasetUri_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        trainingDatasetUri_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. Cloud Storage path to file containing training dataset for
     * tuning. The dataset must be formatted as a JSONL file.
     * </pre>
     *
     * <code>string training_dataset_uri = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for trainingDatasetUri.
     */
    public com.google.protobuf.ByteString getTrainingDatasetUriBytes() {
      java.lang.Object ref = trainingDatasetUri_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        trainingDatasetUri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. Cloud Storage path to file containing training dataset for
     * tuning. The dataset must be formatted as a JSONL file.
     * </pre>
     *
     * <code>string training_dataset_uri = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The trainingDatasetUri to set.
     * @return This builder for chaining.
     */
    public Builder setTrainingDatasetUri(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      trainingDatasetUri_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. Cloud Storage path to file containing training dataset for
     * tuning. The dataset must be formatted as a JSONL file.
     * </pre>
     *
     * <code>string training_dataset_uri = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTrainingDatasetUri() {
      trainingDatasetUri_ = getDefaultInstance().getTrainingDatasetUri();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. Cloud Storage path to file containing training dataset for
     * tuning. The dataset must be formatted as a JSONL file.
     * </pre>
     *
     * <code>string training_dataset_uri = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for trainingDatasetUri to set.
     * @return This builder for chaining.
     */
    public Builder setTrainingDatasetUriBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      trainingDatasetUri_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object validationDatasetUri_ = "";

    /**
     *
     *
     * <pre>
     * Optional. Cloud Storage path to file containing validation dataset for
     * tuning. The dataset must be formatted as a JSONL file.
     * </pre>
     *
     * <code>string validation_dataset_uri = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The validationDatasetUri.
     */
    public java.lang.String getValidationDatasetUri() {
      java.lang.Object ref = validationDatasetUri_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        validationDatasetUri_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Cloud Storage path to file containing validation dataset for
     * tuning. The dataset must be formatted as a JSONL file.
     * </pre>
     *
     * <code>string validation_dataset_uri = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for validationDatasetUri.
     */
    public com.google.protobuf.ByteString getValidationDatasetUriBytes() {
      java.lang.Object ref = validationDatasetUri_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        validationDatasetUri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Cloud Storage path to file containing validation dataset for
     * tuning. The dataset must be formatted as a JSONL file.
     * </pre>
     *
     * <code>string validation_dataset_uri = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The validationDatasetUri to set.
     * @return This builder for chaining.
     */
    public Builder setValidationDatasetUri(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      validationDatasetUri_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Cloud Storage path to file containing validation dataset for
     * tuning. The dataset must be formatted as a JSONL file.
     * </pre>
     *
     * <code>string validation_dataset_uri = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearValidationDatasetUri() {
      validationDatasetUri_ = getDefaultInstance().getValidationDatasetUri();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Cloud Storage path to file containing validation dataset for
     * tuning. The dataset must be formatted as a JSONL file.
     * </pre>
     *
     * <code>string validation_dataset_uri = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for validationDatasetUri to set.
     * @return This builder for chaining.
     */
    public Builder setValidationDatasetUriBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      validationDatasetUri_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private static final class HyperParametersConverter
        implements com.google.protobuf.MapFieldBuilder.Converter<
            java.lang.String, com.google.protobuf.ValueOrBuilder, com.google.protobuf.Value> {
      @java.lang.Override
      public com.google.protobuf.Value build(com.google.protobuf.ValueOrBuilder val) {
        if (val instanceof com.google.protobuf.Value) {
          return (com.google.protobuf.Value) val;
        }
        return ((com.google.protobuf.Value.Builder) val).build();
      }

      @java.lang.Override
      public com.google.protobuf.MapEntry<java.lang.String, com.google.protobuf.Value>
          defaultEntry() {
        return HyperParametersDefaultEntryHolder.defaultEntry;
      }
    }
    ;

    private static final HyperParametersConverter hyperParametersConverter =
        new HyperParametersConverter();

    private com.google.protobuf.MapFieldBuilder<
            java.lang.String,
            com.google.protobuf.ValueOrBuilder,
            com.google.protobuf.Value,
            com.google.protobuf.Value.Builder>
        hyperParameters_;

    private com.google.protobuf.MapFieldBuilder<
            java.lang.String,
            com.google.protobuf.ValueOrBuilder,
            com.google.protobuf.Value,
            com.google.protobuf.Value.Builder>
        internalGetHyperParameters() {
      if (hyperParameters_ == null) {
        return new com.google.protobuf.MapFieldBuilder<>(hyperParametersConverter);
      }
      return hyperParameters_;
    }

    private com.google.protobuf.MapFieldBuilder<
            java.lang.String,
            com.google.protobuf.ValueOrBuilder,
            com.google.protobuf.Value,
            com.google.protobuf.Value.Builder>
        internalGetMutableHyperParameters() {
      if (hyperParameters_ == null) {
        hyperParameters_ = new com.google.protobuf.MapFieldBuilder<>(hyperParametersConverter);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return hyperParameters_;
    }

    public int getHyperParametersCount() {
      return internalGetHyperParameters().ensureBuilderMap().size();
    }

    /**
     *
     *
     * <pre>
     * Hyperparameters for tuning. The accepted hyper_parameters and their valid
     * range of values will differ depending on the base model.
     * </pre>
     *
     * <code>map&lt;string, .google.protobuf.Value&gt; hyper_parameters = 3;</code>
     */
    @java.lang.Override
    public boolean containsHyperParameters(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetHyperParameters().ensureBuilderMap().containsKey(key);
    }

    /** Use {@link #getHyperParametersMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, com.google.protobuf.Value> getHyperParameters() {
      return getHyperParametersMap();
    }

    /**
     *
     *
     * <pre>
     * Hyperparameters for tuning. The accepted hyper_parameters and their valid
     * range of values will differ depending on the base model.
     * </pre>
     *
     * <code>map&lt;string, .google.protobuf.Value&gt; hyper_parameters = 3;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, com.google.protobuf.Value> getHyperParametersMap() {
      return internalGetHyperParameters().getImmutableMap();
    }

    /**
     *
     *
     * <pre>
     * Hyperparameters for tuning. The accepted hyper_parameters and their valid
     * range of values will differ depending on the base model.
     * </pre>
     *
     * <code>map&lt;string, .google.protobuf.Value&gt; hyper_parameters = 3;</code>
     */
    @java.lang.Override
    public /* nullable */ com.google.protobuf.Value getHyperParametersOrDefault(
        java.lang.String key,
        /* nullable */
        com.google.protobuf.Value defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, com.google.protobuf.ValueOrBuilder> map =
          internalGetMutableHyperParameters().ensureBuilderMap();
      return map.containsKey(key) ? hyperParametersConverter.build(map.get(key)) : defaultValue;
    }

    /**
     *
     *
     * <pre>
     * Hyperparameters for tuning. The accepted hyper_parameters and their valid
     * range of values will differ depending on the base model.
     * </pre>
     *
     * <code>map&lt;string, .google.protobuf.Value&gt; hyper_parameters = 3;</code>
     */
    @java.lang.Override
    public com.google.protobuf.Value getHyperParametersOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, com.google.protobuf.ValueOrBuilder> map =
          internalGetMutableHyperParameters().ensureBuilderMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return hyperParametersConverter.build(map.get(key));
    }

    public Builder clearHyperParameters() {
      bitField0_ = (bitField0_ & ~0x00000004);
      internalGetMutableHyperParameters().clear();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Hyperparameters for tuning. The accepted hyper_parameters and their valid
     * range of values will differ depending on the base model.
     * </pre>
     *
     * <code>map&lt;string, .google.protobuf.Value&gt; hyper_parameters = 3;</code>
     */
    public Builder removeHyperParameters(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableHyperParameters().ensureBuilderMap().remove(key);
      return this;
    }

    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, com.google.protobuf.Value> getMutableHyperParameters() {
      bitField0_ |= 0x00000004;
      return internalGetMutableHyperParameters().ensureMessageMap();
    }

    /**
     *
     *
     * <pre>
     * Hyperparameters for tuning. The accepted hyper_parameters and their valid
     * range of values will differ depending on the base model.
     * </pre>
     *
     * <code>map&lt;string, .google.protobuf.Value&gt; hyper_parameters = 3;</code>
     */
    public Builder putHyperParameters(java.lang.String key, com.google.protobuf.Value value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableHyperParameters().ensureBuilderMap().put(key, value);
      bitField0_ |= 0x00000004;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Hyperparameters for tuning. The accepted hyper_parameters and their valid
     * range of values will differ depending on the base model.
     * </pre>
     *
     * <code>map&lt;string, .google.protobuf.Value&gt; hyper_parameters = 3;</code>
     */
    public Builder putAllHyperParameters(
        java.util.Map<java.lang.String, com.google.protobuf.Value> values) {
      for (java.util.Map.Entry<java.lang.String, com.google.protobuf.Value> e : values.entrySet()) {
        if (e.getKey() == null || e.getValue() == null) {
          throw new NullPointerException();
        }
      }
      internalGetMutableHyperParameters().ensureBuilderMap().putAll(values);
      bitField0_ |= 0x00000004;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Hyperparameters for tuning. The accepted hyper_parameters and their valid
     * range of values will differ depending on the base model.
     * </pre>
     *
     * <code>map&lt;string, .google.protobuf.Value&gt; hyper_parameters = 3;</code>
     */
    public com.google.protobuf.Value.Builder putHyperParametersBuilderIfAbsent(
        java.lang.String key) {
      java.util.Map<java.lang.String, com.google.protobuf.ValueOrBuilder> builderMap =
          internalGetMutableHyperParameters().ensureBuilderMap();
      com.google.protobuf.ValueOrBuilder entry = builderMap.get(key);
      if (entry == null) {
        entry = com.google.protobuf.Value.newBuilder();
        builderMap.put(key, entry);
      }
      if (entry instanceof com.google.protobuf.Value) {
        entry = ((com.google.protobuf.Value) entry).toBuilder();
        builderMap.put(key, entry);
      }
      return (com.google.protobuf.Value.Builder) entry;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.PartnerModelTuningSpec)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.PartnerModelTuningSpec)
  private static final com.google.cloud.aiplatform.v1beta1.PartnerModelTuningSpec DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.PartnerModelTuningSpec();
  }

  public static com.google.cloud.aiplatform.v1beta1.PartnerModelTuningSpec getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<PartnerModelTuningSpec> PARSER =
      new com.google.protobuf.AbstractParser<PartnerModelTuningSpec>() {
        @java.lang.Override
        public PartnerModelTuningSpec parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<PartnerModelTuningSpec> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<PartnerModelTuningSpec> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.PartnerModelTuningSpec getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
