/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1beta1/pipeline_job.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.aiplatform.v1beta1;

/**
 *
 *
 * <pre>
 * An instance of a machine learning PipelineJob.
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1beta1.PipelineJob}
 */
public final class PipelineJob extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.PipelineJob)
    PipelineJobOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use PipelineJob.newBuilder() to construct.
  private PipelineJob(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private PipelineJob() {
    name_ = "";
    displayName_ = "";
    state_ = 0;
    serviceAccount_ = "";
    network_ = "";
    reservedIpRanges_ = com.google.protobuf.LazyStringArrayList.emptyList();
    templateUri_ = "";
    scheduleName_ = "";
    pipelineTaskRerunConfigs_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new PipelineJob();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1beta1.Pipeline
        .internal_static_google_cloud_aiplatform_v1beta1_PipelineJob_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
      int number) {
    switch (number) {
      case 11:
        return internalGetLabels();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1beta1.Pipeline
        .internal_static_google_cloud_aiplatform_v1beta1_PipelineJob_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1beta1.PipelineJob.class,
            com.google.cloud.aiplatform.v1beta1.PipelineJob.Builder.class);
  }

  public interface RuntimeConfigOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Deprecated. Use
     * [RuntimeConfig.parameter_values][google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.parameter_values]
     * instead. The runtime parameters of the PipelineJob. The parameters will
     * be passed into
     * [PipelineJob.pipeline_spec][google.cloud.aiplatform.v1beta1.PipelineJob.pipeline_spec]
     * to replace the placeholders at runtime. This field is used by pipelines
     * built using `PipelineJob.pipeline_spec.schema_version` 2.0.0 or lower,
     * such as pipelines built using Kubeflow Pipelines SDK 1.8 or lower.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.aiplatform.v1beta1.Value&gt; parameters = 1 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    int getParametersCount();

    /**
     *
     *
     * <pre>
     * Deprecated. Use
     * [RuntimeConfig.parameter_values][google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.parameter_values]
     * instead. The runtime parameters of the PipelineJob. The parameters will
     * be passed into
     * [PipelineJob.pipeline_spec][google.cloud.aiplatform.v1beta1.PipelineJob.pipeline_spec]
     * to replace the placeholders at runtime. This field is used by pipelines
     * built using `PipelineJob.pipeline_spec.schema_version` 2.0.0 or lower,
     * such as pipelines built using Kubeflow Pipelines SDK 1.8 or lower.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.aiplatform.v1beta1.Value&gt; parameters = 1 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    boolean containsParameters(java.lang.String key);

    /** Use {@link #getParametersMap()} instead. */
    @java.lang.Deprecated
    java.util.Map<java.lang.String, com.google.cloud.aiplatform.v1beta1.Value> getParameters();

    /**
     *
     *
     * <pre>
     * Deprecated. Use
     * [RuntimeConfig.parameter_values][google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.parameter_values]
     * instead. The runtime parameters of the PipelineJob. The parameters will
     * be passed into
     * [PipelineJob.pipeline_spec][google.cloud.aiplatform.v1beta1.PipelineJob.pipeline_spec]
     * to replace the placeholders at runtime. This field is used by pipelines
     * built using `PipelineJob.pipeline_spec.schema_version` 2.0.0 or lower,
     * such as pipelines built using Kubeflow Pipelines SDK 1.8 or lower.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.aiplatform.v1beta1.Value&gt; parameters = 1 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    java.util.Map<java.lang.String, com.google.cloud.aiplatform.v1beta1.Value> getParametersMap();

    /**
     *
     *
     * <pre>
     * Deprecated. Use
     * [RuntimeConfig.parameter_values][google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.parameter_values]
     * instead. The runtime parameters of the PipelineJob. The parameters will
     * be passed into
     * [PipelineJob.pipeline_spec][google.cloud.aiplatform.v1beta1.PipelineJob.pipeline_spec]
     * to replace the placeholders at runtime. This field is used by pipelines
     * built using `PipelineJob.pipeline_spec.schema_version` 2.0.0 or lower,
     * such as pipelines built using Kubeflow Pipelines SDK 1.8 or lower.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.aiplatform.v1beta1.Value&gt; parameters = 1 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated /* nullable */
    com.google.cloud.aiplatform.v1beta1.Value getParametersOrDefault(
        java.lang.String key,
        /* nullable */
        com.google.cloud.aiplatform.v1beta1.Value defaultValue);

    /**
     *
     *
     * <pre>
     * Deprecated. Use
     * [RuntimeConfig.parameter_values][google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.parameter_values]
     * instead. The runtime parameters of the PipelineJob. The parameters will
     * be passed into
     * [PipelineJob.pipeline_spec][google.cloud.aiplatform.v1beta1.PipelineJob.pipeline_spec]
     * to replace the placeholders at runtime. This field is used by pipelines
     * built using `PipelineJob.pipeline_spec.schema_version` 2.0.0 or lower,
     * such as pipelines built using Kubeflow Pipelines SDK 1.8 or lower.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.aiplatform.v1beta1.Value&gt; parameters = 1 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    com.google.cloud.aiplatform.v1beta1.Value getParametersOrThrow(java.lang.String key);

    /**
     *
     *
     * <pre>
     * Required. A path in a Cloud Storage bucket, which will be treated as the
     * root output directory of the pipeline. It is used by the system to
     * generate the paths of output artifacts. The artifact paths are generated
     * with a sub-path pattern `{job_id}/{task_id}/{output_key}` under the
     * specified output directory. The service account specified in this
     * pipeline must have the `storage.objects.get` and `storage.objects.create`
     * permissions for this bucket.
     * </pre>
     *
     * <code>string gcs_output_directory = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The gcsOutputDirectory.
     */
    java.lang.String getGcsOutputDirectory();

    /**
     *
     *
     * <pre>
     * Required. A path in a Cloud Storage bucket, which will be treated as the
     * root output directory of the pipeline. It is used by the system to
     * generate the paths of output artifacts. The artifact paths are generated
     * with a sub-path pattern `{job_id}/{task_id}/{output_key}` under the
     * specified output directory. The service account specified in this
     * pipeline must have the `storage.objects.get` and `storage.objects.create`
     * permissions for this bucket.
     * </pre>
     *
     * <code>string gcs_output_directory = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for gcsOutputDirectory.
     */
    com.google.protobuf.ByteString getGcsOutputDirectoryBytes();

    /**
     *
     *
     * <pre>
     * The runtime parameters of the PipelineJob. The parameters will be
     * passed into
     * [PipelineJob.pipeline_spec][google.cloud.aiplatform.v1beta1.PipelineJob.pipeline_spec]
     * to replace the placeholders at runtime. This field is used by pipelines
     * built using `PipelineJob.pipeline_spec.schema_version` 2.1.0, such as
     * pipelines built using Kubeflow Pipelines SDK 1.9 or higher and the v2
     * DSL.
     * </pre>
     *
     * <code>map&lt;string, .google.protobuf.Value&gt; parameter_values = 3;</code>
     */
    int getParameterValuesCount();

    /**
     *
     *
     * <pre>
     * The runtime parameters of the PipelineJob. The parameters will be
     * passed into
     * [PipelineJob.pipeline_spec][google.cloud.aiplatform.v1beta1.PipelineJob.pipeline_spec]
     * to replace the placeholders at runtime. This field is used by pipelines
     * built using `PipelineJob.pipeline_spec.schema_version` 2.1.0, such as
     * pipelines built using Kubeflow Pipelines SDK 1.9 or higher and the v2
     * DSL.
     * </pre>
     *
     * <code>map&lt;string, .google.protobuf.Value&gt; parameter_values = 3;</code>
     */
    boolean containsParameterValues(java.lang.String key);

    /** Use {@link #getParameterValuesMap()} instead. */
    @java.lang.Deprecated
    java.util.Map<java.lang.String, com.google.protobuf.Value> getParameterValues();

    /**
     *
     *
     * <pre>
     * The runtime parameters of the PipelineJob. The parameters will be
     * passed into
     * [PipelineJob.pipeline_spec][google.cloud.aiplatform.v1beta1.PipelineJob.pipeline_spec]
     * to replace the placeholders at runtime. This field is used by pipelines
     * built using `PipelineJob.pipeline_spec.schema_version` 2.1.0, such as
     * pipelines built using Kubeflow Pipelines SDK 1.9 or higher and the v2
     * DSL.
     * </pre>
     *
     * <code>map&lt;string, .google.protobuf.Value&gt; parameter_values = 3;</code>
     */
    java.util.Map<java.lang.String, com.google.protobuf.Value> getParameterValuesMap();

    /**
     *
     *
     * <pre>
     * The runtime parameters of the PipelineJob. The parameters will be
     * passed into
     * [PipelineJob.pipeline_spec][google.cloud.aiplatform.v1beta1.PipelineJob.pipeline_spec]
     * to replace the placeholders at runtime. This field is used by pipelines
     * built using `PipelineJob.pipeline_spec.schema_version` 2.1.0, such as
     * pipelines built using Kubeflow Pipelines SDK 1.9 or higher and the v2
     * DSL.
     * </pre>
     *
     * <code>map&lt;string, .google.protobuf.Value&gt; parameter_values = 3;</code>
     */
    /* nullable */
    com.google.protobuf.Value getParameterValuesOrDefault(
        java.lang.String key,
        /* nullable */
        com.google.protobuf.Value defaultValue);

    /**
     *
     *
     * <pre>
     * The runtime parameters of the PipelineJob. The parameters will be
     * passed into
     * [PipelineJob.pipeline_spec][google.cloud.aiplatform.v1beta1.PipelineJob.pipeline_spec]
     * to replace the placeholders at runtime. This field is used by pipelines
     * built using `PipelineJob.pipeline_spec.schema_version` 2.1.0, such as
     * pipelines built using Kubeflow Pipelines SDK 1.9 or higher and the v2
     * DSL.
     * </pre>
     *
     * <code>map&lt;string, .google.protobuf.Value&gt; parameter_values = 3;</code>
     */
    com.google.protobuf.Value getParameterValuesOrThrow(java.lang.String key);

    /**
     *
     *
     * <pre>
     * Represents the failure policy of a pipeline. Currently, the default of a
     * pipeline is that the pipeline will continue to run until no more tasks
     * can be executed, also known as PIPELINE_FAILURE_POLICY_FAIL_SLOW.
     * However, if a pipeline is set to PIPELINE_FAILURE_POLICY_FAIL_FAST, it
     * will stop scheduling any new tasks when a task has failed. Any scheduled
     * tasks will continue to completion.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.PipelineFailurePolicy failure_policy = 4;</code>
     *
     * @return The enum numeric value on the wire for failurePolicy.
     */
    int getFailurePolicyValue();

    /**
     *
     *
     * <pre>
     * Represents the failure policy of a pipeline. Currently, the default of a
     * pipeline is that the pipeline will continue to run until no more tasks
     * can be executed, also known as PIPELINE_FAILURE_POLICY_FAIL_SLOW.
     * However, if a pipeline is set to PIPELINE_FAILURE_POLICY_FAIL_FAST, it
     * will stop scheduling any new tasks when a task has failed. Any scheduled
     * tasks will continue to completion.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.PipelineFailurePolicy failure_policy = 4;</code>
     *
     * @return The failurePolicy.
     */
    com.google.cloud.aiplatform.v1beta1.PipelineFailurePolicy getFailurePolicy();

    /**
     *
     *
     * <pre>
     * The runtime artifacts of the PipelineJob. The key will be the input
     * artifact name and the value would be one of the InputArtifact.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.InputArtifact&gt; input_artifacts = 5;
     * </code>
     */
    int getInputArtifactsCount();

    /**
     *
     *
     * <pre>
     * The runtime artifacts of the PipelineJob. The key will be the input
     * artifact name and the value would be one of the InputArtifact.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.InputArtifact&gt; input_artifacts = 5;
     * </code>
     */
    boolean containsInputArtifacts(java.lang.String key);

    /** Use {@link #getInputArtifactsMap()} instead. */
    @java.lang.Deprecated
    java.util.Map<
            java.lang.String,
            com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.InputArtifact>
        getInputArtifacts();

    /**
     *
     *
     * <pre>
     * The runtime artifacts of the PipelineJob. The key will be the input
     * artifact name and the value would be one of the InputArtifact.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.InputArtifact&gt; input_artifacts = 5;
     * </code>
     */
    java.util.Map<
            java.lang.String,
            com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.InputArtifact>
        getInputArtifactsMap();

    /**
     *
     *
     * <pre>
     * The runtime artifacts of the PipelineJob. The key will be the input
     * artifact name and the value would be one of the InputArtifact.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.InputArtifact&gt; input_artifacts = 5;
     * </code>
     */
    /* nullable */
    com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.InputArtifact
        getInputArtifactsOrDefault(
            java.lang.String key,
            /* nullable */
            com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.InputArtifact
                defaultValue);

    /**
     *
     *
     * <pre>
     * The runtime artifacts of the PipelineJob. The key will be the input
     * artifact name and the value would be one of the InputArtifact.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.InputArtifact&gt; input_artifacts = 5;
     * </code>
     */
    com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.InputArtifact
        getInputArtifactsOrThrow(java.lang.String key);

    /**
     *
     *
     * <pre>
     * Optional. The default runtime for the PipelineJob. If not provided,
     * Vertex Custom Job(on demand) is used as the runtime. For Vertex Custom
     * Job, please refer to
     * https://cloud.google.com/vertex-ai/docs/training/overview.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.DefaultRuntime default_runtime = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the defaultRuntime field is set.
     */
    boolean hasDefaultRuntime();

    /**
     *
     *
     * <pre>
     * Optional. The default runtime for the PipelineJob. If not provided,
     * Vertex Custom Job(on demand) is used as the runtime. For Vertex Custom
     * Job, please refer to
     * https://cloud.google.com/vertex-ai/docs/training/overview.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.DefaultRuntime default_runtime = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The defaultRuntime.
     */
    com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.DefaultRuntime
        getDefaultRuntime();

    /**
     *
     *
     * <pre>
     * Optional. The default runtime for the PipelineJob. If not provided,
     * Vertex Custom Job(on demand) is used as the runtime. For Vertex Custom
     * Job, please refer to
     * https://cloud.google.com/vertex-ai/docs/training/overview.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.DefaultRuntime default_runtime = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.DefaultRuntimeOrBuilder
        getDefaultRuntimeOrBuilder();
  }

  /**
   *
   *
   * <pre>
   * The runtime config of a PipelineJob.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig}
   */
  public static final class RuntimeConfig extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig)
      RuntimeConfigOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use RuntimeConfig.newBuilder() to construct.
    private RuntimeConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private RuntimeConfig() {
      gcsOutputDirectory_ = "";
      failurePolicy_ = 0;
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new RuntimeConfig();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.Pipeline
          .internal_static_google_cloud_aiplatform_v1beta1_PipelineJob_RuntimeConfig_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    @java.lang.Override
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 1:
          return internalGetParameters();
        case 3:
          return internalGetParameterValues();
        case 5:
          return internalGetInputArtifacts();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.Pipeline
          .internal_static_google_cloud_aiplatform_v1beta1_PipelineJob_RuntimeConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.class,
              com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.Builder.class);
    }

    public interface InputArtifactOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.InputArtifact)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Artifact resource id from MLMD. Which is the last portion of an
       * artifact resource name:
       * `projects/{project}/locations/{location}/metadataStores/default/artifacts/{artifact_id}`.
       * The artifact must stay within the same project, location and default
       * metadatastore as the pipeline.
       * </pre>
       *
       * <code>string artifact_id = 1;</code>
       *
       * @return Whether the artifactId field is set.
       */
      boolean hasArtifactId();

      /**
       *
       *
       * <pre>
       * Artifact resource id from MLMD. Which is the last portion of an
       * artifact resource name:
       * `projects/{project}/locations/{location}/metadataStores/default/artifacts/{artifact_id}`.
       * The artifact must stay within the same project, location and default
       * metadatastore as the pipeline.
       * </pre>
       *
       * <code>string artifact_id = 1;</code>
       *
       * @return The artifactId.
       */
      java.lang.String getArtifactId();

      /**
       *
       *
       * <pre>
       * Artifact resource id from MLMD. Which is the last portion of an
       * artifact resource name:
       * `projects/{project}/locations/{location}/metadataStores/default/artifacts/{artifact_id}`.
       * The artifact must stay within the same project, location and default
       * metadatastore as the pipeline.
       * </pre>
       *
       * <code>string artifact_id = 1;</code>
       *
       * @return The bytes for artifactId.
       */
      com.google.protobuf.ByteString getArtifactIdBytes();

      com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.InputArtifact.KindCase
          getKindCase();
    }

    /**
     *
     *
     * <pre>
     * The type of an input artifact.
     * </pre>
     *
     * Protobuf type {@code google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.InputArtifact}
     */
    public static final class InputArtifact extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.InputArtifact)
        InputArtifactOrBuilder {
      private static final long serialVersionUID = 0L;

      // Use InputArtifact.newBuilder() to construct.
      private InputArtifact(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private InputArtifact() {}

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new InputArtifact();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1beta1.Pipeline
            .internal_static_google_cloud_aiplatform_v1beta1_PipelineJob_RuntimeConfig_InputArtifact_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1beta1.Pipeline
            .internal_static_google_cloud_aiplatform_v1beta1_PipelineJob_RuntimeConfig_InputArtifact_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.InputArtifact.class,
                com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.InputArtifact.Builder
                    .class);
      }

      private int kindCase_ = 0;

      @SuppressWarnings("serial")
      private java.lang.Object kind_;

      public enum KindCase
          implements
              com.google.protobuf.Internal.EnumLite,
              com.google.protobuf.AbstractMessage.InternalOneOfEnum {
        ARTIFACT_ID(1),
        KIND_NOT_SET(0);
        private final int value;

        private KindCase(int value) {
          this.value = value;
        }

        /**
         * @param value The number of the enum to look for.
         * @return The enum associated with the given number.
         * @deprecated Use {@link #forNumber(int)} instead.
         */
        @java.lang.Deprecated
        public static KindCase valueOf(int value) {
          return forNumber(value);
        }

        public static KindCase forNumber(int value) {
          switch (value) {
            case 1:
              return ARTIFACT_ID;
            case 0:
              return KIND_NOT_SET;
            default:
              return null;
          }
        }

        public int getNumber() {
          return this.value;
        }
      };

      public KindCase getKindCase() {
        return KindCase.forNumber(kindCase_);
      }

      public static final int ARTIFACT_ID_FIELD_NUMBER = 1;

      /**
       *
       *
       * <pre>
       * Artifact resource id from MLMD. Which is the last portion of an
       * artifact resource name:
       * `projects/{project}/locations/{location}/metadataStores/default/artifacts/{artifact_id}`.
       * The artifact must stay within the same project, location and default
       * metadatastore as the pipeline.
       * </pre>
       *
       * <code>string artifact_id = 1;</code>
       *
       * @return Whether the artifactId field is set.
       */
      public boolean hasArtifactId() {
        return kindCase_ == 1;
      }

      /**
       *
       *
       * <pre>
       * Artifact resource id from MLMD. Which is the last portion of an
       * artifact resource name:
       * `projects/{project}/locations/{location}/metadataStores/default/artifacts/{artifact_id}`.
       * The artifact must stay within the same project, location and default
       * metadatastore as the pipeline.
       * </pre>
       *
       * <code>string artifact_id = 1;</code>
       *
       * @return The artifactId.
       */
      public java.lang.String getArtifactId() {
        java.lang.Object ref = "";
        if (kindCase_ == 1) {
          ref = kind_;
        }
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (kindCase_ == 1) {
            kind_ = s;
          }
          return s;
        }
      }

      /**
       *
       *
       * <pre>
       * Artifact resource id from MLMD. Which is the last portion of an
       * artifact resource name:
       * `projects/{project}/locations/{location}/metadataStores/default/artifacts/{artifact_id}`.
       * The artifact must stay within the same project, location and default
       * metadatastore as the pipeline.
       * </pre>
       *
       * <code>string artifact_id = 1;</code>
       *
       * @return The bytes for artifactId.
       */
      public com.google.protobuf.ByteString getArtifactIdBytes() {
        java.lang.Object ref = "";
        if (kindCase_ == 1) {
          ref = kind_;
        }
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          if (kindCase_ == 1) {
            kind_ = b;
          }
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (kindCase_ == 1) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 1, kind_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (kindCase_ == 1) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, kind_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof
            com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.InputArtifact)) {
          return super.equals(obj);
        }
        com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.InputArtifact other =
            (com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.InputArtifact) obj;

        if (!getKindCase().equals(other.getKindCase())) return false;
        switch (kindCase_) {
          case 1:
            if (!getArtifactId().equals(other.getArtifactId())) return false;
            break;
          case 0:
          default:
        }
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        switch (kindCase_) {
          case 1:
            hash = (37 * hash) + ARTIFACT_ID_FIELD_NUMBER;
            hash = (53 * hash) + getArtifactId().hashCode();
            break;
          case 0:
          default:
        }
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.InputArtifact
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.InputArtifact
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.InputArtifact
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.InputArtifact
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.InputArtifact
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.InputArtifact
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.InputArtifact
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.InputArtifact
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.InputArtifact
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.InputArtifact
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.InputArtifact
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.InputArtifact
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.InputArtifact prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }

      /**
       *
       *
       * <pre>
       * The type of an input artifact.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.InputArtifact}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.InputArtifact)
          com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.InputArtifactOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.aiplatform.v1beta1.Pipeline
              .internal_static_google_cloud_aiplatform_v1beta1_PipelineJob_RuntimeConfig_InputArtifact_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.aiplatform.v1beta1.Pipeline
              .internal_static_google_cloud_aiplatform_v1beta1_PipelineJob_RuntimeConfig_InputArtifact_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.InputArtifact.class,
                  com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.InputArtifact
                      .Builder.class);
        }

        // Construct using
        // com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.InputArtifact.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          kindCase_ = 0;
          kind_ = null;
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.aiplatform.v1beta1.Pipeline
              .internal_static_google_cloud_aiplatform_v1beta1_PipelineJob_RuntimeConfig_InputArtifact_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.InputArtifact
            getDefaultInstanceForType() {
          return com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.InputArtifact
              .getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.InputArtifact build() {
          com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.InputArtifact result =
              buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.InputArtifact
            buildPartial() {
          com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.InputArtifact result =
              new com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.InputArtifact(this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          buildPartialOneofs(result);
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.InputArtifact result) {
          int from_bitField0_ = bitField0_;
        }

        private void buildPartialOneofs(
            com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.InputArtifact result) {
          result.kindCase_ = kindCase_;
          result.kind_ = this.kind_;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.InputArtifact) {
            return mergeFrom(
                (com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.InputArtifact)
                    other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.InputArtifact other) {
          if (other
              == com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.InputArtifact
                  .getDefaultInstance()) return this;
          switch (other.getKindCase()) {
            case ARTIFACT_ID:
              {
                kindCase_ = 1;
                kind_ = other.kind_;
                onChanged();
                break;
              }
            case KIND_NOT_SET:
              {
                break;
              }
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    java.lang.String s = input.readStringRequireUtf8();
                    kindCase_ = 1;
                    kind_ = s;
                    break;
                  } // case 10
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int kindCase_ = 0;
        private java.lang.Object kind_;

        public KindCase getKindCase() {
          return KindCase.forNumber(kindCase_);
        }

        public Builder clearKind() {
          kindCase_ = 0;
          kind_ = null;
          onChanged();
          return this;
        }

        private int bitField0_;

        /**
         *
         *
         * <pre>
         * Artifact resource id from MLMD. Which is the last portion of an
         * artifact resource name:
         * `projects/{project}/locations/{location}/metadataStores/default/artifacts/{artifact_id}`.
         * The artifact must stay within the same project, location and default
         * metadatastore as the pipeline.
         * </pre>
         *
         * <code>string artifact_id = 1;</code>
         *
         * @return Whether the artifactId field is set.
         */
        @java.lang.Override
        public boolean hasArtifactId() {
          return kindCase_ == 1;
        }

        /**
         *
         *
         * <pre>
         * Artifact resource id from MLMD. Which is the last portion of an
         * artifact resource name:
         * `projects/{project}/locations/{location}/metadataStores/default/artifacts/{artifact_id}`.
         * The artifact must stay within the same project, location and default
         * metadatastore as the pipeline.
         * </pre>
         *
         * <code>string artifact_id = 1;</code>
         *
         * @return The artifactId.
         */
        @java.lang.Override
        public java.lang.String getArtifactId() {
          java.lang.Object ref = "";
          if (kindCase_ == 1) {
            ref = kind_;
          }
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            if (kindCase_ == 1) {
              kind_ = s;
            }
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }

        /**
         *
         *
         * <pre>
         * Artifact resource id from MLMD. Which is the last portion of an
         * artifact resource name:
         * `projects/{project}/locations/{location}/metadataStores/default/artifacts/{artifact_id}`.
         * The artifact must stay within the same project, location and default
         * metadatastore as the pipeline.
         * </pre>
         *
         * <code>string artifact_id = 1;</code>
         *
         * @return The bytes for artifactId.
         */
        @java.lang.Override
        public com.google.protobuf.ByteString getArtifactIdBytes() {
          java.lang.Object ref = "";
          if (kindCase_ == 1) {
            ref = kind_;
          }
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            if (kindCase_ == 1) {
              kind_ = b;
            }
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }

        /**
         *
         *
         * <pre>
         * Artifact resource id from MLMD. Which is the last portion of an
         * artifact resource name:
         * `projects/{project}/locations/{location}/metadataStores/default/artifacts/{artifact_id}`.
         * The artifact must stay within the same project, location and default
         * metadatastore as the pipeline.
         * </pre>
         *
         * <code>string artifact_id = 1;</code>
         *
         * @param value The artifactId to set.
         * @return This builder for chaining.
         */
        public Builder setArtifactId(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          kindCase_ = 1;
          kind_ = value;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Artifact resource id from MLMD. Which is the last portion of an
         * artifact resource name:
         * `projects/{project}/locations/{location}/metadataStores/default/artifacts/{artifact_id}`.
         * The artifact must stay within the same project, location and default
         * metadatastore as the pipeline.
         * </pre>
         *
         * <code>string artifact_id = 1;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearArtifactId() {
          if (kindCase_ == 1) {
            kindCase_ = 0;
            kind_ = null;
            onChanged();
          }
          return this;
        }

        /**
         *
         *
         * <pre>
         * Artifact resource id from MLMD. Which is the last portion of an
         * artifact resource name:
         * `projects/{project}/locations/{location}/metadataStores/default/artifacts/{artifact_id}`.
         * The artifact must stay within the same project, location and default
         * metadatastore as the pipeline.
         * </pre>
         *
         * <code>string artifact_id = 1;</code>
         *
         * @param value The bytes for artifactId to set.
         * @return This builder for chaining.
         */
        public Builder setArtifactIdBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          kindCase_ = 1;
          kind_ = value;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.InputArtifact)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.InputArtifact)
      private static final com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig
              .InputArtifact
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.InputArtifact();
      }

      public static com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.InputArtifact
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<InputArtifact> PARSER =
          new com.google.protobuf.AbstractParser<InputArtifact>() {
            @java.lang.Override
            public InputArtifact parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<InputArtifact> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<InputArtifact> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.InputArtifact
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public interface PersistentResourceRuntimeDetailOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.PersistentResourceRuntimeDetail)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Persistent resource name.
       * Format:
       * `projects/{project}/locations/{location}/persistentResources/{persistent_resource}`
       * </pre>
       *
       * <code>string persistent_resource_name = 1;</code>
       *
       * @return The persistentResourceName.
       */
      java.lang.String getPersistentResourceName();

      /**
       *
       *
       * <pre>
       * Persistent resource name.
       * Format:
       * `projects/{project}/locations/{location}/persistentResources/{persistent_resource}`
       * </pre>
       *
       * <code>string persistent_resource_name = 1;</code>
       *
       * @return The bytes for persistentResourceName.
       */
      com.google.protobuf.ByteString getPersistentResourceNameBytes();

      /**
       *
       *
       * <pre>
       * The max time a pipeline task waits for the required CPU, memory, or
       * accelerator resource to become available from the specified persistent
       * resource. Default wait time is 0.
       * </pre>
       *
       * <code>int64 task_resource_unavailable_wait_time_ms = 2;</code>
       *
       * @return The taskResourceUnavailableWaitTimeMs.
       */
      long getTaskResourceUnavailableWaitTimeMs();

      /**
       *
       *
       * <pre>
       * Specifies the behavior to take if the timeout is reached.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.PersistentResourceRuntimeDetail.TaskResourceUnavailableTimeoutBehavior task_resource_unavailable_timeout_behavior = 3;
       * </code>
       *
       * @return The enum numeric value on the wire for taskResourceUnavailableTimeoutBehavior.
       */
      int getTaskResourceUnavailableTimeoutBehaviorValue();

      /**
       *
       *
       * <pre>
       * Specifies the behavior to take if the timeout is reached.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.PersistentResourceRuntimeDetail.TaskResourceUnavailableTimeoutBehavior task_resource_unavailable_timeout_behavior = 3;
       * </code>
       *
       * @return The taskResourceUnavailableTimeoutBehavior.
       */
      com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.PersistentResourceRuntimeDetail
              .TaskResourceUnavailableTimeoutBehavior
          getTaskResourceUnavailableTimeoutBehavior();
    }

    /**
     *
     *
     * <pre>
     * Persistent resource based runtime detail. For more information, refer to
     * https://cloud.google.com/vertex-ai/docs/training/persistent-resource-overview
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.PersistentResourceRuntimeDetail}
     */
    public static final class PersistentResourceRuntimeDetail
        extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.PersistentResourceRuntimeDetail)
        PersistentResourceRuntimeDetailOrBuilder {
      private static final long serialVersionUID = 0L;

      // Use PersistentResourceRuntimeDetail.newBuilder() to construct.
      private PersistentResourceRuntimeDetail(
          com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private PersistentResourceRuntimeDetail() {
        persistentResourceName_ = "";
        taskResourceUnavailableTimeoutBehavior_ = 0;
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new PersistentResourceRuntimeDetail();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1beta1.Pipeline
            .internal_static_google_cloud_aiplatform_v1beta1_PipelineJob_RuntimeConfig_PersistentResourceRuntimeDetail_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1beta1.Pipeline
            .internal_static_google_cloud_aiplatform_v1beta1_PipelineJob_RuntimeConfig_PersistentResourceRuntimeDetail_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig
                    .PersistentResourceRuntimeDetail.class,
                com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig
                    .PersistentResourceRuntimeDetail.Builder.class);
      }

      /**
       *
       *
       * <pre>
       * An enum that specifies the behavior to take if the timeout is reached.
       * </pre>
       *
       * Protobuf enum {@code
       * google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.PersistentResourceRuntimeDetail.TaskResourceUnavailableTimeoutBehavior}
       */
      public enum TaskResourceUnavailableTimeoutBehavior
          implements com.google.protobuf.ProtocolMessageEnum {
        /**
         *
         *
         * <pre>
         * Unspecified. Behavior is same as `FAIL`.
         * </pre>
         *
         * <code>TASK_RESOURCE_UNAVAILABLE_TIMEOUT_BEHAVIOR_UNSPECIFIED = 0;</code>
         */
        TASK_RESOURCE_UNAVAILABLE_TIMEOUT_BEHAVIOR_UNSPECIFIED(0),
        /**
         *
         *
         * <pre>
         * Fail the task if the timeout is reached.
         * </pre>
         *
         * <code>FAIL = 1;</code>
         */
        FAIL(1),
        /**
         *
         *
         * <pre>
         * Fall back to on-demand execution if the timeout is reached.
         * </pre>
         *
         * <code>FALL_BACK_TO_ON_DEMAND = 2;</code>
         */
        FALL_BACK_TO_ON_DEMAND(2),
        UNRECOGNIZED(-1),
        ;

        /**
         *
         *
         * <pre>
         * Unspecified. Behavior is same as `FAIL`.
         * </pre>
         *
         * <code>TASK_RESOURCE_UNAVAILABLE_TIMEOUT_BEHAVIOR_UNSPECIFIED = 0;</code>
         */
        public static final int TASK_RESOURCE_UNAVAILABLE_TIMEOUT_BEHAVIOR_UNSPECIFIED_VALUE = 0;

        /**
         *
         *
         * <pre>
         * Fail the task if the timeout is reached.
         * </pre>
         *
         * <code>FAIL = 1;</code>
         */
        public static final int FAIL_VALUE = 1;

        /**
         *
         *
         * <pre>
         * Fall back to on-demand execution if the timeout is reached.
         * </pre>
         *
         * <code>FALL_BACK_TO_ON_DEMAND = 2;</code>
         */
        public static final int FALL_BACK_TO_ON_DEMAND_VALUE = 2;

        public final int getNumber() {
          if (this == UNRECOGNIZED) {
            throw new java.lang.IllegalArgumentException(
                "Can't get the number of an unknown enum value.");
          }
          return value;
        }

        /**
         * @param value The numeric wire value of the corresponding enum entry.
         * @return The enum associated with the given numeric wire value.
         * @deprecated Use {@link #forNumber(int)} instead.
         */
        @java.lang.Deprecated
        public static TaskResourceUnavailableTimeoutBehavior valueOf(int value) {
          return forNumber(value);
        }

        /**
         * @param value The numeric wire value of the corresponding enum entry.
         * @return The enum associated with the given numeric wire value.
         */
        public static TaskResourceUnavailableTimeoutBehavior forNumber(int value) {
          switch (value) {
            case 0:
              return TASK_RESOURCE_UNAVAILABLE_TIMEOUT_BEHAVIOR_UNSPECIFIED;
            case 1:
              return FAIL;
            case 2:
              return FALL_BACK_TO_ON_DEMAND;
            default:
              return null;
          }
        }

        public static com.google.protobuf.Internal.EnumLiteMap<
                TaskResourceUnavailableTimeoutBehavior>
            internalGetValueMap() {
          return internalValueMap;
        }

        private static final com.google.protobuf.Internal.EnumLiteMap<
                TaskResourceUnavailableTimeoutBehavior>
            internalValueMap =
                new com.google.protobuf.Internal.EnumLiteMap<
                    TaskResourceUnavailableTimeoutBehavior>() {
                  public TaskResourceUnavailableTimeoutBehavior findValueByNumber(int number) {
                    return TaskResourceUnavailableTimeoutBehavior.forNumber(number);
                  }
                };

        public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
          if (this == UNRECOGNIZED) {
            throw new java.lang.IllegalStateException(
                "Can't get the descriptor of an unrecognized enum value.");
          }
          return getDescriptor().getValues().get(ordinal());
        }

        public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
          return getDescriptor();
        }

        public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
          return com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig
              .PersistentResourceRuntimeDetail.getDescriptor()
              .getEnumTypes()
              .get(0);
        }

        private static final TaskResourceUnavailableTimeoutBehavior[] VALUES = values();

        public static TaskResourceUnavailableTimeoutBehavior valueOf(
            com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
          if (desc.getType() != getDescriptor()) {
            throw new java.lang.IllegalArgumentException(
                "EnumValueDescriptor is not for this type.");
          }
          if (desc.getIndex() == -1) {
            return UNRECOGNIZED;
          }
          return VALUES[desc.getIndex()];
        }

        private final int value;

        private TaskResourceUnavailableTimeoutBehavior(int value) {
          this.value = value;
        }

        // @@protoc_insertion_point(enum_scope:google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.PersistentResourceRuntimeDetail.TaskResourceUnavailableTimeoutBehavior)
      }

      public static final int PERSISTENT_RESOURCE_NAME_FIELD_NUMBER = 1;

      @SuppressWarnings("serial")
      private volatile java.lang.Object persistentResourceName_ = "";

      /**
       *
       *
       * <pre>
       * Persistent resource name.
       * Format:
       * `projects/{project}/locations/{location}/persistentResources/{persistent_resource}`
       * </pre>
       *
       * <code>string persistent_resource_name = 1;</code>
       *
       * @return The persistentResourceName.
       */
      @java.lang.Override
      public java.lang.String getPersistentResourceName() {
        java.lang.Object ref = persistentResourceName_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          persistentResourceName_ = s;
          return s;
        }
      }

      /**
       *
       *
       * <pre>
       * Persistent resource name.
       * Format:
       * `projects/{project}/locations/{location}/persistentResources/{persistent_resource}`
       * </pre>
       *
       * <code>string persistent_resource_name = 1;</code>
       *
       * @return The bytes for persistentResourceName.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getPersistentResourceNameBytes() {
        java.lang.Object ref = persistentResourceName_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          persistentResourceName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int TASK_RESOURCE_UNAVAILABLE_WAIT_TIME_MS_FIELD_NUMBER = 2;
      private long taskResourceUnavailableWaitTimeMs_ = 0L;

      /**
       *
       *
       * <pre>
       * The max time a pipeline task waits for the required CPU, memory, or
       * accelerator resource to become available from the specified persistent
       * resource. Default wait time is 0.
       * </pre>
       *
       * <code>int64 task_resource_unavailable_wait_time_ms = 2;</code>
       *
       * @return The taskResourceUnavailableWaitTimeMs.
       */
      @java.lang.Override
      public long getTaskResourceUnavailableWaitTimeMs() {
        return taskResourceUnavailableWaitTimeMs_;
      }

      public static final int TASK_RESOURCE_UNAVAILABLE_TIMEOUT_BEHAVIOR_FIELD_NUMBER = 3;
      private int taskResourceUnavailableTimeoutBehavior_ = 0;

      /**
       *
       *
       * <pre>
       * Specifies the behavior to take if the timeout is reached.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.PersistentResourceRuntimeDetail.TaskResourceUnavailableTimeoutBehavior task_resource_unavailable_timeout_behavior = 3;
       * </code>
       *
       * @return The enum numeric value on the wire for taskResourceUnavailableTimeoutBehavior.
       */
      @java.lang.Override
      public int getTaskResourceUnavailableTimeoutBehaviorValue() {
        return taskResourceUnavailableTimeoutBehavior_;
      }

      /**
       *
       *
       * <pre>
       * Specifies the behavior to take if the timeout is reached.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.PersistentResourceRuntimeDetail.TaskResourceUnavailableTimeoutBehavior task_resource_unavailable_timeout_behavior = 3;
       * </code>
       *
       * @return The taskResourceUnavailableTimeoutBehavior.
       */
      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig
              .PersistentResourceRuntimeDetail.TaskResourceUnavailableTimeoutBehavior
          getTaskResourceUnavailableTimeoutBehavior() {
        com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig
                .PersistentResourceRuntimeDetail.TaskResourceUnavailableTimeoutBehavior
            result =
                com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig
                    .PersistentResourceRuntimeDetail.TaskResourceUnavailableTimeoutBehavior
                    .forNumber(taskResourceUnavailableTimeoutBehavior_);
        return result == null
            ? com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig
                .PersistentResourceRuntimeDetail.TaskResourceUnavailableTimeoutBehavior.UNRECOGNIZED
            : result;
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(persistentResourceName_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 1, persistentResourceName_);
        }
        if (taskResourceUnavailableWaitTimeMs_ != 0L) {
          output.writeInt64(2, taskResourceUnavailableWaitTimeMs_);
        }
        if (taskResourceUnavailableTimeoutBehavior_
            != com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig
                .PersistentResourceRuntimeDetail.TaskResourceUnavailableTimeoutBehavior
                .TASK_RESOURCE_UNAVAILABLE_TIMEOUT_BEHAVIOR_UNSPECIFIED
                .getNumber()) {
          output.writeEnum(3, taskResourceUnavailableTimeoutBehavior_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(persistentResourceName_)) {
          size +=
              com.google.protobuf.GeneratedMessageV3.computeStringSize(1, persistentResourceName_);
        }
        if (taskResourceUnavailableWaitTimeMs_ != 0L) {
          size +=
              com.google.protobuf.CodedOutputStream.computeInt64Size(
                  2, taskResourceUnavailableWaitTimeMs_);
        }
        if (taskResourceUnavailableTimeoutBehavior_
            != com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig
                .PersistentResourceRuntimeDetail.TaskResourceUnavailableTimeoutBehavior
                .TASK_RESOURCE_UNAVAILABLE_TIMEOUT_BEHAVIOR_UNSPECIFIED
                .getNumber()) {
          size +=
              com.google.protobuf.CodedOutputStream.computeEnumSize(
                  3, taskResourceUnavailableTimeoutBehavior_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof
            com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig
                .PersistentResourceRuntimeDetail)) {
          return super.equals(obj);
        }
        com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig
                .PersistentResourceRuntimeDetail
            other =
                (com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig
                        .PersistentResourceRuntimeDetail)
                    obj;

        if (!getPersistentResourceName().equals(other.getPersistentResourceName())) return false;
        if (getTaskResourceUnavailableWaitTimeMs() != other.getTaskResourceUnavailableWaitTimeMs())
          return false;
        if (taskResourceUnavailableTimeoutBehavior_
            != other.taskResourceUnavailableTimeoutBehavior_) return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + PERSISTENT_RESOURCE_NAME_FIELD_NUMBER;
        hash = (53 * hash) + getPersistentResourceName().hashCode();
        hash = (37 * hash) + TASK_RESOURCE_UNAVAILABLE_WAIT_TIME_MS_FIELD_NUMBER;
        hash =
            (53 * hash)
                + com.google.protobuf.Internal.hashLong(getTaskResourceUnavailableWaitTimeMs());
        hash = (37 * hash) + TASK_RESOURCE_UNAVAILABLE_TIMEOUT_BEHAVIOR_FIELD_NUMBER;
        hash = (53 * hash) + taskResourceUnavailableTimeoutBehavior_;
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig
              .PersistentResourceRuntimeDetail
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig
              .PersistentResourceRuntimeDetail
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig
              .PersistentResourceRuntimeDetail
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig
              .PersistentResourceRuntimeDetail
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig
              .PersistentResourceRuntimeDetail
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig
              .PersistentResourceRuntimeDetail
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig
              .PersistentResourceRuntimeDetail
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig
              .PersistentResourceRuntimeDetail
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig
              .PersistentResourceRuntimeDetail
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig
              .PersistentResourceRuntimeDetail
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig
              .PersistentResourceRuntimeDetail
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig
              .PersistentResourceRuntimeDetail
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig
                  .PersistentResourceRuntimeDetail
              prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }

      /**
       *
       *
       * <pre>
       * Persistent resource based runtime detail. For more information, refer to
       * https://cloud.google.com/vertex-ai/docs/training/persistent-resource-overview
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.PersistentResourceRuntimeDetail}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.PersistentResourceRuntimeDetail)
          com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig
              .PersistentResourceRuntimeDetailOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.aiplatform.v1beta1.Pipeline
              .internal_static_google_cloud_aiplatform_v1beta1_PipelineJob_RuntimeConfig_PersistentResourceRuntimeDetail_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.aiplatform.v1beta1.Pipeline
              .internal_static_google_cloud_aiplatform_v1beta1_PipelineJob_RuntimeConfig_PersistentResourceRuntimeDetail_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig
                      .PersistentResourceRuntimeDetail.class,
                  com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig
                      .PersistentResourceRuntimeDetail.Builder.class);
        }

        // Construct using
        // com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.PersistentResourceRuntimeDetail.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          persistentResourceName_ = "";
          taskResourceUnavailableWaitTimeMs_ = 0L;
          taskResourceUnavailableTimeoutBehavior_ = 0;
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.aiplatform.v1beta1.Pipeline
              .internal_static_google_cloud_aiplatform_v1beta1_PipelineJob_RuntimeConfig_PersistentResourceRuntimeDetail_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig
                .PersistentResourceRuntimeDetail
            getDefaultInstanceForType() {
          return com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig
              .PersistentResourceRuntimeDetail.getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig
                .PersistentResourceRuntimeDetail
            build() {
          com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig
                  .PersistentResourceRuntimeDetail
              result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig
                .PersistentResourceRuntimeDetail
            buildPartial() {
          com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig
                  .PersistentResourceRuntimeDetail
              result =
                  new com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig
                      .PersistentResourceRuntimeDetail(this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig
                    .PersistentResourceRuntimeDetail
                result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.persistentResourceName_ = persistentResourceName_;
          }
          if (((from_bitField0_ & 0x00000002) != 0)) {
            result.taskResourceUnavailableWaitTimeMs_ = taskResourceUnavailableWaitTimeMs_;
          }
          if (((from_bitField0_ & 0x00000004) != 0)) {
            result.taskResourceUnavailableTimeoutBehavior_ =
                taskResourceUnavailableTimeoutBehavior_;
          }
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig
                  .PersistentResourceRuntimeDetail) {
            return mergeFrom(
                (com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig
                        .PersistentResourceRuntimeDetail)
                    other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig
                    .PersistentResourceRuntimeDetail
                other) {
          if (other
              == com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig
                  .PersistentResourceRuntimeDetail.getDefaultInstance()) return this;
          if (!other.getPersistentResourceName().isEmpty()) {
            persistentResourceName_ = other.persistentResourceName_;
            bitField0_ |= 0x00000001;
            onChanged();
          }
          if (other.getTaskResourceUnavailableWaitTimeMs() != 0L) {
            setTaskResourceUnavailableWaitTimeMs(other.getTaskResourceUnavailableWaitTimeMs());
          }
          if (other.taskResourceUnavailableTimeoutBehavior_ != 0) {
            setTaskResourceUnavailableTimeoutBehaviorValue(
                other.getTaskResourceUnavailableTimeoutBehaviorValue());
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    persistentResourceName_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 10
                case 16:
                  {
                    taskResourceUnavailableWaitTimeMs_ = input.readInt64();
                    bitField0_ |= 0x00000002;
                    break;
                  } // case 16
                case 24:
                  {
                    taskResourceUnavailableTimeoutBehavior_ = input.readEnum();
                    bitField0_ |= 0x00000004;
                    break;
                  } // case 24
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private java.lang.Object persistentResourceName_ = "";

        /**
         *
         *
         * <pre>
         * Persistent resource name.
         * Format:
         * `projects/{project}/locations/{location}/persistentResources/{persistent_resource}`
         * </pre>
         *
         * <code>string persistent_resource_name = 1;</code>
         *
         * @return The persistentResourceName.
         */
        public java.lang.String getPersistentResourceName() {
          java.lang.Object ref = persistentResourceName_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            persistentResourceName_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }

        /**
         *
         *
         * <pre>
         * Persistent resource name.
         * Format:
         * `projects/{project}/locations/{location}/persistentResources/{persistent_resource}`
         * </pre>
         *
         * <code>string persistent_resource_name = 1;</code>
         *
         * @return The bytes for persistentResourceName.
         */
        public com.google.protobuf.ByteString getPersistentResourceNameBytes() {
          java.lang.Object ref = persistentResourceName_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            persistentResourceName_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }

        /**
         *
         *
         * <pre>
         * Persistent resource name.
         * Format:
         * `projects/{project}/locations/{location}/persistentResources/{persistent_resource}`
         * </pre>
         *
         * <code>string persistent_resource_name = 1;</code>
         *
         * @param value The persistentResourceName to set.
         * @return This builder for chaining.
         */
        public Builder setPersistentResourceName(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          persistentResourceName_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Persistent resource name.
         * Format:
         * `projects/{project}/locations/{location}/persistentResources/{persistent_resource}`
         * </pre>
         *
         * <code>string persistent_resource_name = 1;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearPersistentResourceName() {
          persistentResourceName_ = getDefaultInstance().getPersistentResourceName();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Persistent resource name.
         * Format:
         * `projects/{project}/locations/{location}/persistentResources/{persistent_resource}`
         * </pre>
         *
         * <code>string persistent_resource_name = 1;</code>
         *
         * @param value The bytes for persistentResourceName to set.
         * @return This builder for chaining.
         */
        public Builder setPersistentResourceNameBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          persistentResourceName_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        private long taskResourceUnavailableWaitTimeMs_;

        /**
         *
         *
         * <pre>
         * The max time a pipeline task waits for the required CPU, memory, or
         * accelerator resource to become available from the specified persistent
         * resource. Default wait time is 0.
         * </pre>
         *
         * <code>int64 task_resource_unavailable_wait_time_ms = 2;</code>
         *
         * @return The taskResourceUnavailableWaitTimeMs.
         */
        @java.lang.Override
        public long getTaskResourceUnavailableWaitTimeMs() {
          return taskResourceUnavailableWaitTimeMs_;
        }

        /**
         *
         *
         * <pre>
         * The max time a pipeline task waits for the required CPU, memory, or
         * accelerator resource to become available from the specified persistent
         * resource. Default wait time is 0.
         * </pre>
         *
         * <code>int64 task_resource_unavailable_wait_time_ms = 2;</code>
         *
         * @param value The taskResourceUnavailableWaitTimeMs to set.
         * @return This builder for chaining.
         */
        public Builder setTaskResourceUnavailableWaitTimeMs(long value) {

          taskResourceUnavailableWaitTimeMs_ = value;
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * The max time a pipeline task waits for the required CPU, memory, or
         * accelerator resource to become available from the specified persistent
         * resource. Default wait time is 0.
         * </pre>
         *
         * <code>int64 task_resource_unavailable_wait_time_ms = 2;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearTaskResourceUnavailableWaitTimeMs() {
          bitField0_ = (bitField0_ & ~0x00000002);
          taskResourceUnavailableWaitTimeMs_ = 0L;
          onChanged();
          return this;
        }

        private int taskResourceUnavailableTimeoutBehavior_ = 0;

        /**
         *
         *
         * <pre>
         * Specifies the behavior to take if the timeout is reached.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.PersistentResourceRuntimeDetail.TaskResourceUnavailableTimeoutBehavior task_resource_unavailable_timeout_behavior = 3;
         * </code>
         *
         * @return The enum numeric value on the wire for taskResourceUnavailableTimeoutBehavior.
         */
        @java.lang.Override
        public int getTaskResourceUnavailableTimeoutBehaviorValue() {
          return taskResourceUnavailableTimeoutBehavior_;
        }

        /**
         *
         *
         * <pre>
         * Specifies the behavior to take if the timeout is reached.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.PersistentResourceRuntimeDetail.TaskResourceUnavailableTimeoutBehavior task_resource_unavailable_timeout_behavior = 3;
         * </code>
         *
         * @param value The enum numeric value on the wire for
         *     taskResourceUnavailableTimeoutBehavior to set.
         * @return This builder for chaining.
         */
        public Builder setTaskResourceUnavailableTimeoutBehaviorValue(int value) {
          taskResourceUnavailableTimeoutBehavior_ = value;
          bitField0_ |= 0x00000004;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Specifies the behavior to take if the timeout is reached.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.PersistentResourceRuntimeDetail.TaskResourceUnavailableTimeoutBehavior task_resource_unavailable_timeout_behavior = 3;
         * </code>
         *
         * @return The taskResourceUnavailableTimeoutBehavior.
         */
        @java.lang.Override
        public com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig
                .PersistentResourceRuntimeDetail.TaskResourceUnavailableTimeoutBehavior
            getTaskResourceUnavailableTimeoutBehavior() {
          com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig
                  .PersistentResourceRuntimeDetail.TaskResourceUnavailableTimeoutBehavior
              result =
                  com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig
                      .PersistentResourceRuntimeDetail.TaskResourceUnavailableTimeoutBehavior
                      .forNumber(taskResourceUnavailableTimeoutBehavior_);
          return result == null
              ? com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig
                  .PersistentResourceRuntimeDetail.TaskResourceUnavailableTimeoutBehavior
                  .UNRECOGNIZED
              : result;
        }

        /**
         *
         *
         * <pre>
         * Specifies the behavior to take if the timeout is reached.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.PersistentResourceRuntimeDetail.TaskResourceUnavailableTimeoutBehavior task_resource_unavailable_timeout_behavior = 3;
         * </code>
         *
         * @param value The taskResourceUnavailableTimeoutBehavior to set.
         * @return This builder for chaining.
         */
        public Builder setTaskResourceUnavailableTimeoutBehavior(
            com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig
                    .PersistentResourceRuntimeDetail.TaskResourceUnavailableTimeoutBehavior
                value) {
          if (value == null) {
            throw new NullPointerException();
          }
          bitField0_ |= 0x00000004;
          taskResourceUnavailableTimeoutBehavior_ = value.getNumber();
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Specifies the behavior to take if the timeout is reached.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.PersistentResourceRuntimeDetail.TaskResourceUnavailableTimeoutBehavior task_resource_unavailable_timeout_behavior = 3;
         * </code>
         *
         * @return This builder for chaining.
         */
        public Builder clearTaskResourceUnavailableTimeoutBehavior() {
          bitField0_ = (bitField0_ & ~0x00000004);
          taskResourceUnavailableTimeoutBehavior_ = 0;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.PersistentResourceRuntimeDetail)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.PersistentResourceRuntimeDetail)
      private static final com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig
              .PersistentResourceRuntimeDetail
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig
                .PersistentResourceRuntimeDetail();
      }

      public static com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig
              .PersistentResourceRuntimeDetail
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<PersistentResourceRuntimeDetail> PARSER =
          new com.google.protobuf.AbstractParser<PersistentResourceRuntimeDetail>() {
            @java.lang.Override
            public PersistentResourceRuntimeDetail parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<PersistentResourceRuntimeDetail> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<PersistentResourceRuntimeDetail> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig
              .PersistentResourceRuntimeDetail
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public interface DefaultRuntimeOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.DefaultRuntime)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Persistent resource based runtime detail.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.PersistentResourceRuntimeDetail persistent_resource_runtime_detail = 1;
       * </code>
       *
       * @return Whether the persistentResourceRuntimeDetail field is set.
       */
      boolean hasPersistentResourceRuntimeDetail();

      /**
       *
       *
       * <pre>
       * Persistent resource based runtime detail.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.PersistentResourceRuntimeDetail persistent_resource_runtime_detail = 1;
       * </code>
       *
       * @return The persistentResourceRuntimeDetail.
       */
      com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.PersistentResourceRuntimeDetail
          getPersistentResourceRuntimeDetail();

      /**
       *
       *
       * <pre>
       * Persistent resource based runtime detail.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.PersistentResourceRuntimeDetail persistent_resource_runtime_detail = 1;
       * </code>
       */
      com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig
              .PersistentResourceRuntimeDetailOrBuilder
          getPersistentResourceRuntimeDetailOrBuilder();

      com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.DefaultRuntime.RuntimeDetailCase
          getRuntimeDetailCase();
    }

    /**
     *
     *
     * <pre>
     * The default runtime for the PipelineJob.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.DefaultRuntime}
     */
    public static final class DefaultRuntime extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.DefaultRuntime)
        DefaultRuntimeOrBuilder {
      private static final long serialVersionUID = 0L;

      // Use DefaultRuntime.newBuilder() to construct.
      private DefaultRuntime(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private DefaultRuntime() {}

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new DefaultRuntime();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1beta1.Pipeline
            .internal_static_google_cloud_aiplatform_v1beta1_PipelineJob_RuntimeConfig_DefaultRuntime_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1beta1.Pipeline
            .internal_static_google_cloud_aiplatform_v1beta1_PipelineJob_RuntimeConfig_DefaultRuntime_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.DefaultRuntime.class,
                com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.DefaultRuntime.Builder
                    .class);
      }

      private int runtimeDetailCase_ = 0;

      @SuppressWarnings("serial")
      private java.lang.Object runtimeDetail_;

      public enum RuntimeDetailCase
          implements
              com.google.protobuf.Internal.EnumLite,
              com.google.protobuf.AbstractMessage.InternalOneOfEnum {
        PERSISTENT_RESOURCE_RUNTIME_DETAIL(1),
        RUNTIMEDETAIL_NOT_SET(0);
        private final int value;

        private RuntimeDetailCase(int value) {
          this.value = value;
        }

        /**
         * @param value The number of the enum to look for.
         * @return The enum associated with the given number.
         * @deprecated Use {@link #forNumber(int)} instead.
         */
        @java.lang.Deprecated
        public static RuntimeDetailCase valueOf(int value) {
          return forNumber(value);
        }

        public static RuntimeDetailCase forNumber(int value) {
          switch (value) {
            case 1:
              return PERSISTENT_RESOURCE_RUNTIME_DETAIL;
            case 0:
              return RUNTIMEDETAIL_NOT_SET;
            default:
              return null;
          }
        }

        public int getNumber() {
          return this.value;
        }
      };

      public RuntimeDetailCase getRuntimeDetailCase() {
        return RuntimeDetailCase.forNumber(runtimeDetailCase_);
      }

      public static final int PERSISTENT_RESOURCE_RUNTIME_DETAIL_FIELD_NUMBER = 1;

      /**
       *
       *
       * <pre>
       * Persistent resource based runtime detail.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.PersistentResourceRuntimeDetail persistent_resource_runtime_detail = 1;
       * </code>
       *
       * @return Whether the persistentResourceRuntimeDetail field is set.
       */
      @java.lang.Override
      public boolean hasPersistentResourceRuntimeDetail() {
        return runtimeDetailCase_ == 1;
      }

      /**
       *
       *
       * <pre>
       * Persistent resource based runtime detail.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.PersistentResourceRuntimeDetail persistent_resource_runtime_detail = 1;
       * </code>
       *
       * @return The persistentResourceRuntimeDetail.
       */
      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig
              .PersistentResourceRuntimeDetail
          getPersistentResourceRuntimeDetail() {
        if (runtimeDetailCase_ == 1) {
          return (com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig
                  .PersistentResourceRuntimeDetail)
              runtimeDetail_;
        }
        return com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig
            .PersistentResourceRuntimeDetail.getDefaultInstance();
      }

      /**
       *
       *
       * <pre>
       * Persistent resource based runtime detail.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.PersistentResourceRuntimeDetail persistent_resource_runtime_detail = 1;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig
              .PersistentResourceRuntimeDetailOrBuilder
          getPersistentResourceRuntimeDetailOrBuilder() {
        if (runtimeDetailCase_ == 1) {
          return (com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig
                  .PersistentResourceRuntimeDetail)
              runtimeDetail_;
        }
        return com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig
            .PersistentResourceRuntimeDetail.getDefaultInstance();
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (runtimeDetailCase_ == 1) {
          output.writeMessage(
              1,
              (com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig
                      .PersistentResourceRuntimeDetail)
                  runtimeDetail_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (runtimeDetailCase_ == 1) {
          size +=
              com.google.protobuf.CodedOutputStream.computeMessageSize(
                  1,
                  (com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig
                          .PersistentResourceRuntimeDetail)
                      runtimeDetail_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof
            com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.DefaultRuntime)) {
          return super.equals(obj);
        }
        com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.DefaultRuntime other =
            (com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.DefaultRuntime) obj;

        if (!getRuntimeDetailCase().equals(other.getRuntimeDetailCase())) return false;
        switch (runtimeDetailCase_) {
          case 1:
            if (!getPersistentResourceRuntimeDetail()
                .equals(other.getPersistentResourceRuntimeDetail())) return false;
            break;
          case 0:
          default:
        }
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        switch (runtimeDetailCase_) {
          case 1:
            hash = (37 * hash) + PERSISTENT_RESOURCE_RUNTIME_DETAIL_FIELD_NUMBER;
            hash = (53 * hash) + getPersistentResourceRuntimeDetail().hashCode();
            break;
          case 0:
          default:
        }
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.DefaultRuntime
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.DefaultRuntime
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.DefaultRuntime
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.DefaultRuntime
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.DefaultRuntime
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.DefaultRuntime
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.DefaultRuntime
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.DefaultRuntime
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.DefaultRuntime
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.DefaultRuntime
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.DefaultRuntime
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.DefaultRuntime
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.DefaultRuntime prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }

      /**
       *
       *
       * <pre>
       * The default runtime for the PipelineJob.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.DefaultRuntime}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.DefaultRuntime)
          com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.DefaultRuntimeOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.aiplatform.v1beta1.Pipeline
              .internal_static_google_cloud_aiplatform_v1beta1_PipelineJob_RuntimeConfig_DefaultRuntime_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.aiplatform.v1beta1.Pipeline
              .internal_static_google_cloud_aiplatform_v1beta1_PipelineJob_RuntimeConfig_DefaultRuntime_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.DefaultRuntime
                      .class,
                  com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.DefaultRuntime
                      .Builder.class);
        }

        // Construct using
        // com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.DefaultRuntime.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          if (persistentResourceRuntimeDetailBuilder_ != null) {
            persistentResourceRuntimeDetailBuilder_.clear();
          }
          runtimeDetailCase_ = 0;
          runtimeDetail_ = null;
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.aiplatform.v1beta1.Pipeline
              .internal_static_google_cloud_aiplatform_v1beta1_PipelineJob_RuntimeConfig_DefaultRuntime_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.DefaultRuntime
            getDefaultInstanceForType() {
          return com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.DefaultRuntime
              .getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.DefaultRuntime
            build() {
          com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.DefaultRuntime result =
              buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.DefaultRuntime
            buildPartial() {
          com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.DefaultRuntime result =
              new com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.DefaultRuntime(
                  this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          buildPartialOneofs(result);
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.DefaultRuntime result) {
          int from_bitField0_ = bitField0_;
        }

        private void buildPartialOneofs(
            com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.DefaultRuntime result) {
          result.runtimeDetailCase_ = runtimeDetailCase_;
          result.runtimeDetail_ = this.runtimeDetail_;
          if (runtimeDetailCase_ == 1 && persistentResourceRuntimeDetailBuilder_ != null) {
            result.runtimeDetail_ = persistentResourceRuntimeDetailBuilder_.build();
          }
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.DefaultRuntime) {
            return mergeFrom(
                (com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.DefaultRuntime)
                    other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.DefaultRuntime other) {
          if (other
              == com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.DefaultRuntime
                  .getDefaultInstance()) return this;
          switch (other.getRuntimeDetailCase()) {
            case PERSISTENT_RESOURCE_RUNTIME_DETAIL:
              {
                mergePersistentResourceRuntimeDetail(other.getPersistentResourceRuntimeDetail());
                break;
              }
            case RUNTIMEDETAIL_NOT_SET:
              {
                break;
              }
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    input.readMessage(
                        getPersistentResourceRuntimeDetailFieldBuilder().getBuilder(),
                        extensionRegistry);
                    runtimeDetailCase_ = 1;
                    break;
                  } // case 10
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int runtimeDetailCase_ = 0;
        private java.lang.Object runtimeDetail_;

        public RuntimeDetailCase getRuntimeDetailCase() {
          return RuntimeDetailCase.forNumber(runtimeDetailCase_);
        }

        public Builder clearRuntimeDetail() {
          runtimeDetailCase_ = 0;
          runtimeDetail_ = null;
          onChanged();
          return this;
        }

        private int bitField0_;

        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig
                    .PersistentResourceRuntimeDetail,
                com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig
                    .PersistentResourceRuntimeDetail.Builder,
                com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig
                    .PersistentResourceRuntimeDetailOrBuilder>
            persistentResourceRuntimeDetailBuilder_;

        /**
         *
         *
         * <pre>
         * Persistent resource based runtime detail.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.PersistentResourceRuntimeDetail persistent_resource_runtime_detail = 1;
         * </code>
         *
         * @return Whether the persistentResourceRuntimeDetail field is set.
         */
        @java.lang.Override
        public boolean hasPersistentResourceRuntimeDetail() {
          return runtimeDetailCase_ == 1;
        }

        /**
         *
         *
         * <pre>
         * Persistent resource based runtime detail.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.PersistentResourceRuntimeDetail persistent_resource_runtime_detail = 1;
         * </code>
         *
         * @return The persistentResourceRuntimeDetail.
         */
        @java.lang.Override
        public com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig
                .PersistentResourceRuntimeDetail
            getPersistentResourceRuntimeDetail() {
          if (persistentResourceRuntimeDetailBuilder_ == null) {
            if (runtimeDetailCase_ == 1) {
              return (com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig
                      .PersistentResourceRuntimeDetail)
                  runtimeDetail_;
            }
            return com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig
                .PersistentResourceRuntimeDetail.getDefaultInstance();
          } else {
            if (runtimeDetailCase_ == 1) {
              return persistentResourceRuntimeDetailBuilder_.getMessage();
            }
            return com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig
                .PersistentResourceRuntimeDetail.getDefaultInstance();
          }
        }

        /**
         *
         *
         * <pre>
         * Persistent resource based runtime detail.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.PersistentResourceRuntimeDetail persistent_resource_runtime_detail = 1;
         * </code>
         */
        public Builder setPersistentResourceRuntimeDetail(
            com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig
                    .PersistentResourceRuntimeDetail
                value) {
          if (persistentResourceRuntimeDetailBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            runtimeDetail_ = value;
            onChanged();
          } else {
            persistentResourceRuntimeDetailBuilder_.setMessage(value);
          }
          runtimeDetailCase_ = 1;
          return this;
        }

        /**
         *
         *
         * <pre>
         * Persistent resource based runtime detail.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.PersistentResourceRuntimeDetail persistent_resource_runtime_detail = 1;
         * </code>
         */
        public Builder setPersistentResourceRuntimeDetail(
            com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig
                    .PersistentResourceRuntimeDetail.Builder
                builderForValue) {
          if (persistentResourceRuntimeDetailBuilder_ == null) {
            runtimeDetail_ = builderForValue.build();
            onChanged();
          } else {
            persistentResourceRuntimeDetailBuilder_.setMessage(builderForValue.build());
          }
          runtimeDetailCase_ = 1;
          return this;
        }

        /**
         *
         *
         * <pre>
         * Persistent resource based runtime detail.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.PersistentResourceRuntimeDetail persistent_resource_runtime_detail = 1;
         * </code>
         */
        public Builder mergePersistentResourceRuntimeDetail(
            com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig
                    .PersistentResourceRuntimeDetail
                value) {
          if (persistentResourceRuntimeDetailBuilder_ == null) {
            if (runtimeDetailCase_ == 1
                && runtimeDetail_
                    != com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig
                        .PersistentResourceRuntimeDetail.getDefaultInstance()) {
              runtimeDetail_ =
                  com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig
                      .PersistentResourceRuntimeDetail.newBuilder(
                          (com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig
                                  .PersistentResourceRuntimeDetail)
                              runtimeDetail_)
                      .mergeFrom(value)
                      .buildPartial();
            } else {
              runtimeDetail_ = value;
            }
            onChanged();
          } else {
            if (runtimeDetailCase_ == 1) {
              persistentResourceRuntimeDetailBuilder_.mergeFrom(value);
            } else {
              persistentResourceRuntimeDetailBuilder_.setMessage(value);
            }
          }
          runtimeDetailCase_ = 1;
          return this;
        }

        /**
         *
         *
         * <pre>
         * Persistent resource based runtime detail.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.PersistentResourceRuntimeDetail persistent_resource_runtime_detail = 1;
         * </code>
         */
        public Builder clearPersistentResourceRuntimeDetail() {
          if (persistentResourceRuntimeDetailBuilder_ == null) {
            if (runtimeDetailCase_ == 1) {
              runtimeDetailCase_ = 0;
              runtimeDetail_ = null;
              onChanged();
            }
          } else {
            if (runtimeDetailCase_ == 1) {
              runtimeDetailCase_ = 0;
              runtimeDetail_ = null;
            }
            persistentResourceRuntimeDetailBuilder_.clear();
          }
          return this;
        }

        /**
         *
         *
         * <pre>
         * Persistent resource based runtime detail.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.PersistentResourceRuntimeDetail persistent_resource_runtime_detail = 1;
         * </code>
         */
        public com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig
                .PersistentResourceRuntimeDetail.Builder
            getPersistentResourceRuntimeDetailBuilder() {
          return getPersistentResourceRuntimeDetailFieldBuilder().getBuilder();
        }

        /**
         *
         *
         * <pre>
         * Persistent resource based runtime detail.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.PersistentResourceRuntimeDetail persistent_resource_runtime_detail = 1;
         * </code>
         */
        @java.lang.Override
        public com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig
                .PersistentResourceRuntimeDetailOrBuilder
            getPersistentResourceRuntimeDetailOrBuilder() {
          if ((runtimeDetailCase_ == 1) && (persistentResourceRuntimeDetailBuilder_ != null)) {
            return persistentResourceRuntimeDetailBuilder_.getMessageOrBuilder();
          } else {
            if (runtimeDetailCase_ == 1) {
              return (com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig
                      .PersistentResourceRuntimeDetail)
                  runtimeDetail_;
            }
            return com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig
                .PersistentResourceRuntimeDetail.getDefaultInstance();
          }
        }

        /**
         *
         *
         * <pre>
         * Persistent resource based runtime detail.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.PersistentResourceRuntimeDetail persistent_resource_runtime_detail = 1;
         * </code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig
                    .PersistentResourceRuntimeDetail,
                com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig
                    .PersistentResourceRuntimeDetail.Builder,
                com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig
                    .PersistentResourceRuntimeDetailOrBuilder>
            getPersistentResourceRuntimeDetailFieldBuilder() {
          if (persistentResourceRuntimeDetailBuilder_ == null) {
            if (!(runtimeDetailCase_ == 1)) {
              runtimeDetail_ =
                  com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig
                      .PersistentResourceRuntimeDetail.getDefaultInstance();
            }
            persistentResourceRuntimeDetailBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig
                        .PersistentResourceRuntimeDetail,
                    com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig
                        .PersistentResourceRuntimeDetail.Builder,
                    com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig
                        .PersistentResourceRuntimeDetailOrBuilder>(
                    (com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig
                            .PersistentResourceRuntimeDetail)
                        runtimeDetail_,
                    getParentForChildren(),
                    isClean());
            runtimeDetail_ = null;
          }
          runtimeDetailCase_ = 1;
          onChanged();
          return persistentResourceRuntimeDetailBuilder_;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.DefaultRuntime)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.DefaultRuntime)
      private static final com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig
              .DefaultRuntime
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.DefaultRuntime();
      }

      public static com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.DefaultRuntime
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<DefaultRuntime> PARSER =
          new com.google.protobuf.AbstractParser<DefaultRuntime>() {
            @java.lang.Override
            public DefaultRuntime parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<DefaultRuntime> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<DefaultRuntime> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.DefaultRuntime
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    private int bitField0_;
    public static final int PARAMETERS_FIELD_NUMBER = 1;

    private static final class ParametersDefaultEntryHolder {
      static final com.google.protobuf.MapEntry<
              java.lang.String, com.google.cloud.aiplatform.v1beta1.Value>
          defaultEntry =
              com.google.protobuf.MapEntry
                  .<java.lang.String, com.google.cloud.aiplatform.v1beta1.Value>newDefaultInstance(
                      com.google.cloud.aiplatform.v1beta1.Pipeline
                          .internal_static_google_cloud_aiplatform_v1beta1_PipelineJob_RuntimeConfig_ParametersEntry_descriptor,
                      com.google.protobuf.WireFormat.FieldType.STRING,
                      "",
                      com.google.protobuf.WireFormat.FieldType.MESSAGE,
                      com.google.cloud.aiplatform.v1beta1.Value.getDefaultInstance());
    }

    @SuppressWarnings("serial")
    private com.google.protobuf.MapField<
            java.lang.String, com.google.cloud.aiplatform.v1beta1.Value>
        parameters_;

    private com.google.protobuf.MapField<
            java.lang.String, com.google.cloud.aiplatform.v1beta1.Value>
        internalGetParameters() {
      if (parameters_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            ParametersDefaultEntryHolder.defaultEntry);
      }
      return parameters_;
    }

    @java.lang.Deprecated
    public int getParametersCount() {
      return internalGetParameters().getMap().size();
    }

    /**
     *
     *
     * <pre>
     * Deprecated. Use
     * [RuntimeConfig.parameter_values][google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.parameter_values]
     * instead. The runtime parameters of the PipelineJob. The parameters will
     * be passed into
     * [PipelineJob.pipeline_spec][google.cloud.aiplatform.v1beta1.PipelineJob.pipeline_spec]
     * to replace the placeholders at runtime. This field is used by pipelines
     * built using `PipelineJob.pipeline_spec.schema_version` 2.0.0 or lower,
     * such as pipelines built using Kubeflow Pipelines SDK 1.8 or lower.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.aiplatform.v1beta1.Value&gt; parameters = 1 [deprecated = true];
     * </code>
     */
    @java.lang.Override
    @java.lang.Deprecated
    public boolean containsParameters(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetParameters().getMap().containsKey(key);
    }

    /** Use {@link #getParametersMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, com.google.cloud.aiplatform.v1beta1.Value>
        getParameters() {
      return getParametersMap();
    }

    /**
     *
     *
     * <pre>
     * Deprecated. Use
     * [RuntimeConfig.parameter_values][google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.parameter_values]
     * instead. The runtime parameters of the PipelineJob. The parameters will
     * be passed into
     * [PipelineJob.pipeline_spec][google.cloud.aiplatform.v1beta1.PipelineJob.pipeline_spec]
     * to replace the placeholders at runtime. This field is used by pipelines
     * built using `PipelineJob.pipeline_spec.schema_version` 2.0.0 or lower,
     * such as pipelines built using Kubeflow Pipelines SDK 1.8 or lower.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.aiplatform.v1beta1.Value&gt; parameters = 1 [deprecated = true];
     * </code>
     */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, com.google.cloud.aiplatform.v1beta1.Value>
        getParametersMap() {
      return internalGetParameters().getMap();
    }

    /**
     *
     *
     * <pre>
     * Deprecated. Use
     * [RuntimeConfig.parameter_values][google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.parameter_values]
     * instead. The runtime parameters of the PipelineJob. The parameters will
     * be passed into
     * [PipelineJob.pipeline_spec][google.cloud.aiplatform.v1beta1.PipelineJob.pipeline_spec]
     * to replace the placeholders at runtime. This field is used by pipelines
     * built using `PipelineJob.pipeline_spec.schema_version` 2.0.0 or lower,
     * such as pipelines built using Kubeflow Pipelines SDK 1.8 or lower.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.aiplatform.v1beta1.Value&gt; parameters = 1 [deprecated = true];
     * </code>
     */
    @java.lang.Override
    @java.lang.Deprecated
    public /* nullable */ com.google.cloud.aiplatform.v1beta1.Value getParametersOrDefault(
        java.lang.String key,
        /* nullable */
        com.google.cloud.aiplatform.v1beta1.Value defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, com.google.cloud.aiplatform.v1beta1.Value> map =
          internalGetParameters().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }

    /**
     *
     *
     * <pre>
     * Deprecated. Use
     * [RuntimeConfig.parameter_values][google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.parameter_values]
     * instead. The runtime parameters of the PipelineJob. The parameters will
     * be passed into
     * [PipelineJob.pipeline_spec][google.cloud.aiplatform.v1beta1.PipelineJob.pipeline_spec]
     * to replace the placeholders at runtime. This field is used by pipelines
     * built using `PipelineJob.pipeline_spec.schema_version` 2.0.0 or lower,
     * such as pipelines built using Kubeflow Pipelines SDK 1.8 or lower.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.aiplatform.v1beta1.Value&gt; parameters = 1 [deprecated = true];
     * </code>
     */
    @java.lang.Override
    @java.lang.Deprecated
    public com.google.cloud.aiplatform.v1beta1.Value getParametersOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, com.google.cloud.aiplatform.v1beta1.Value> map =
          internalGetParameters().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public static final int GCS_OUTPUT_DIRECTORY_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object gcsOutputDirectory_ = "";

    /**
     *
     *
     * <pre>
     * Required. A path in a Cloud Storage bucket, which will be treated as the
     * root output directory of the pipeline. It is used by the system to
     * generate the paths of output artifacts. The artifact paths are generated
     * with a sub-path pattern `{job_id}/{task_id}/{output_key}` under the
     * specified output directory. The service account specified in this
     * pipeline must have the `storage.objects.get` and `storage.objects.create`
     * permissions for this bucket.
     * </pre>
     *
     * <code>string gcs_output_directory = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The gcsOutputDirectory.
     */
    @java.lang.Override
    public java.lang.String getGcsOutputDirectory() {
      java.lang.Object ref = gcsOutputDirectory_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        gcsOutputDirectory_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. A path in a Cloud Storage bucket, which will be treated as the
     * root output directory of the pipeline. It is used by the system to
     * generate the paths of output artifacts. The artifact paths are generated
     * with a sub-path pattern `{job_id}/{task_id}/{output_key}` under the
     * specified output directory. The service account specified in this
     * pipeline must have the `storage.objects.get` and `storage.objects.create`
     * permissions for this bucket.
     * </pre>
     *
     * <code>string gcs_output_directory = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for gcsOutputDirectory.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getGcsOutputDirectoryBytes() {
      java.lang.Object ref = gcsOutputDirectory_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        gcsOutputDirectory_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int PARAMETER_VALUES_FIELD_NUMBER = 3;

    private static final class ParameterValuesDefaultEntryHolder {
      static final com.google.protobuf.MapEntry<java.lang.String, com.google.protobuf.Value>
          defaultEntry =
              com.google.protobuf.MapEntry
                  .<java.lang.String, com.google.protobuf.Value>newDefaultInstance(
                      com.google.cloud.aiplatform.v1beta1.Pipeline
                          .internal_static_google_cloud_aiplatform_v1beta1_PipelineJob_RuntimeConfig_ParameterValuesEntry_descriptor,
                      com.google.protobuf.WireFormat.FieldType.STRING,
                      "",
                      com.google.protobuf.WireFormat.FieldType.MESSAGE,
                      com.google.protobuf.Value.getDefaultInstance());
    }

    @SuppressWarnings("serial")
    private com.google.protobuf.MapField<java.lang.String, com.google.protobuf.Value>
        parameterValues_;

    private com.google.protobuf.MapField<java.lang.String, com.google.protobuf.Value>
        internalGetParameterValues() {
      if (parameterValues_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            ParameterValuesDefaultEntryHolder.defaultEntry);
      }
      return parameterValues_;
    }

    public int getParameterValuesCount() {
      return internalGetParameterValues().getMap().size();
    }

    /**
     *
     *
     * <pre>
     * The runtime parameters of the PipelineJob. The parameters will be
     * passed into
     * [PipelineJob.pipeline_spec][google.cloud.aiplatform.v1beta1.PipelineJob.pipeline_spec]
     * to replace the placeholders at runtime. This field is used by pipelines
     * built using `PipelineJob.pipeline_spec.schema_version` 2.1.0, such as
     * pipelines built using Kubeflow Pipelines SDK 1.9 or higher and the v2
     * DSL.
     * </pre>
     *
     * <code>map&lt;string, .google.protobuf.Value&gt; parameter_values = 3;</code>
     */
    @java.lang.Override
    public boolean containsParameterValues(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetParameterValues().getMap().containsKey(key);
    }

    /** Use {@link #getParameterValuesMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, com.google.protobuf.Value> getParameterValues() {
      return getParameterValuesMap();
    }

    /**
     *
     *
     * <pre>
     * The runtime parameters of the PipelineJob. The parameters will be
     * passed into
     * [PipelineJob.pipeline_spec][google.cloud.aiplatform.v1beta1.PipelineJob.pipeline_spec]
     * to replace the placeholders at runtime. This field is used by pipelines
     * built using `PipelineJob.pipeline_spec.schema_version` 2.1.0, such as
     * pipelines built using Kubeflow Pipelines SDK 1.9 or higher and the v2
     * DSL.
     * </pre>
     *
     * <code>map&lt;string, .google.protobuf.Value&gt; parameter_values = 3;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, com.google.protobuf.Value> getParameterValuesMap() {
      return internalGetParameterValues().getMap();
    }

    /**
     *
     *
     * <pre>
     * The runtime parameters of the PipelineJob. The parameters will be
     * passed into
     * [PipelineJob.pipeline_spec][google.cloud.aiplatform.v1beta1.PipelineJob.pipeline_spec]
     * to replace the placeholders at runtime. This field is used by pipelines
     * built using `PipelineJob.pipeline_spec.schema_version` 2.1.0, such as
     * pipelines built using Kubeflow Pipelines SDK 1.9 or higher and the v2
     * DSL.
     * </pre>
     *
     * <code>map&lt;string, .google.protobuf.Value&gt; parameter_values = 3;</code>
     */
    @java.lang.Override
    public /* nullable */ com.google.protobuf.Value getParameterValuesOrDefault(
        java.lang.String key,
        /* nullable */
        com.google.protobuf.Value defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, com.google.protobuf.Value> map =
          internalGetParameterValues().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }

    /**
     *
     *
     * <pre>
     * The runtime parameters of the PipelineJob. The parameters will be
     * passed into
     * [PipelineJob.pipeline_spec][google.cloud.aiplatform.v1beta1.PipelineJob.pipeline_spec]
     * to replace the placeholders at runtime. This field is used by pipelines
     * built using `PipelineJob.pipeline_spec.schema_version` 2.1.0, such as
     * pipelines built using Kubeflow Pipelines SDK 1.9 or higher and the v2
     * DSL.
     * </pre>
     *
     * <code>map&lt;string, .google.protobuf.Value&gt; parameter_values = 3;</code>
     */
    @java.lang.Override
    public com.google.protobuf.Value getParameterValuesOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, com.google.protobuf.Value> map =
          internalGetParameterValues().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public static final int FAILURE_POLICY_FIELD_NUMBER = 4;
    private int failurePolicy_ = 0;

    /**
     *
     *
     * <pre>
     * Represents the failure policy of a pipeline. Currently, the default of a
     * pipeline is that the pipeline will continue to run until no more tasks
     * can be executed, also known as PIPELINE_FAILURE_POLICY_FAIL_SLOW.
     * However, if a pipeline is set to PIPELINE_FAILURE_POLICY_FAIL_FAST, it
     * will stop scheduling any new tasks when a task has failed. Any scheduled
     * tasks will continue to completion.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.PipelineFailurePolicy failure_policy = 4;</code>
     *
     * @return The enum numeric value on the wire for failurePolicy.
     */
    @java.lang.Override
    public int getFailurePolicyValue() {
      return failurePolicy_;
    }

    /**
     *
     *
     * <pre>
     * Represents the failure policy of a pipeline. Currently, the default of a
     * pipeline is that the pipeline will continue to run until no more tasks
     * can be executed, also known as PIPELINE_FAILURE_POLICY_FAIL_SLOW.
     * However, if a pipeline is set to PIPELINE_FAILURE_POLICY_FAIL_FAST, it
     * will stop scheduling any new tasks when a task has failed. Any scheduled
     * tasks will continue to completion.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.PipelineFailurePolicy failure_policy = 4;</code>
     *
     * @return The failurePolicy.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.PipelineFailurePolicy getFailurePolicy() {
      com.google.cloud.aiplatform.v1beta1.PipelineFailurePolicy result =
          com.google.cloud.aiplatform.v1beta1.PipelineFailurePolicy.forNumber(failurePolicy_);
      return result == null
          ? com.google.cloud.aiplatform.v1beta1.PipelineFailurePolicy.UNRECOGNIZED
          : result;
    }

    public static final int INPUT_ARTIFACTS_FIELD_NUMBER = 5;

    private static final class InputArtifactsDefaultEntryHolder {
      static final com.google.protobuf.MapEntry<
              java.lang.String,
              com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.InputArtifact>
          defaultEntry =
              com.google.protobuf.MapEntry
                  .<java.lang.String,
                      com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.InputArtifact>
                      newDefaultInstance(
                          com.google.cloud.aiplatform.v1beta1.Pipeline
                              .internal_static_google_cloud_aiplatform_v1beta1_PipelineJob_RuntimeConfig_InputArtifactsEntry_descriptor,
                          com.google.protobuf.WireFormat.FieldType.STRING,
                          "",
                          com.google.protobuf.WireFormat.FieldType.MESSAGE,
                          com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig
                              .InputArtifact.getDefaultInstance());
    }

    @SuppressWarnings("serial")
    private com.google.protobuf.MapField<
            java.lang.String,
            com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.InputArtifact>
        inputArtifacts_;

    private com.google.protobuf.MapField<
            java.lang.String,
            com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.InputArtifact>
        internalGetInputArtifacts() {
      if (inputArtifacts_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            InputArtifactsDefaultEntryHolder.defaultEntry);
      }
      return inputArtifacts_;
    }

    public int getInputArtifactsCount() {
      return internalGetInputArtifacts().getMap().size();
    }

    /**
     *
     *
     * <pre>
     * The runtime artifacts of the PipelineJob. The key will be the input
     * artifact name and the value would be one of the InputArtifact.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.InputArtifact&gt; input_artifacts = 5;
     * </code>
     */
    @java.lang.Override
    public boolean containsInputArtifacts(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetInputArtifacts().getMap().containsKey(key);
    }

    /** Use {@link #getInputArtifactsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<
            java.lang.String,
            com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.InputArtifact>
        getInputArtifacts() {
      return getInputArtifactsMap();
    }

    /**
     *
     *
     * <pre>
     * The runtime artifacts of the PipelineJob. The key will be the input
     * artifact name and the value would be one of the InputArtifact.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.InputArtifact&gt; input_artifacts = 5;
     * </code>
     */
    @java.lang.Override
    public java.util.Map<
            java.lang.String,
            com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.InputArtifact>
        getInputArtifactsMap() {
      return internalGetInputArtifacts().getMap();
    }

    /**
     *
     *
     * <pre>
     * The runtime artifacts of the PipelineJob. The key will be the input
     * artifact name and the value would be one of the InputArtifact.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.InputArtifact&gt; input_artifacts = 5;
     * </code>
     */
    @java.lang.Override
    public /* nullable */ com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig
            .InputArtifact
        getInputArtifactsOrDefault(
            java.lang.String key,
            /* nullable */
            com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.InputArtifact
                defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<
              java.lang.String,
              com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.InputArtifact>
          map = internalGetInputArtifacts().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }

    /**
     *
     *
     * <pre>
     * The runtime artifacts of the PipelineJob. The key will be the input
     * artifact name and the value would be one of the InputArtifact.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.InputArtifact&gt; input_artifacts = 5;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.InputArtifact
        getInputArtifactsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<
              java.lang.String,
              com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.InputArtifact>
          map = internalGetInputArtifacts().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public static final int DEFAULT_RUNTIME_FIELD_NUMBER = 6;
    private com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.DefaultRuntime
        defaultRuntime_;

    /**
     *
     *
     * <pre>
     * Optional. The default runtime for the PipelineJob. If not provided,
     * Vertex Custom Job(on demand) is used as the runtime. For Vertex Custom
     * Job, please refer to
     * https://cloud.google.com/vertex-ai/docs/training/overview.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.DefaultRuntime default_runtime = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the defaultRuntime field is set.
     */
    @java.lang.Override
    public boolean hasDefaultRuntime() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. The default runtime for the PipelineJob. If not provided,
     * Vertex Custom Job(on demand) is used as the runtime. For Vertex Custom
     * Job, please refer to
     * https://cloud.google.com/vertex-ai/docs/training/overview.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.DefaultRuntime default_runtime = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The defaultRuntime.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.DefaultRuntime
        getDefaultRuntime() {
      return defaultRuntime_ == null
          ? com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.DefaultRuntime
              .getDefaultInstance()
          : defaultRuntime_;
    }

    /**
     *
     *
     * <pre>
     * Optional. The default runtime for the PipelineJob. If not provided,
     * Vertex Custom Job(on demand) is used as the runtime. For Vertex Custom
     * Job, please refer to
     * https://cloud.google.com/vertex-ai/docs/training/overview.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.DefaultRuntime default_runtime = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.DefaultRuntimeOrBuilder
        getDefaultRuntimeOrBuilder() {
      return defaultRuntime_ == null
          ? com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.DefaultRuntime
              .getDefaultInstance()
          : defaultRuntime_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
          output, internalGetParameters(), ParametersDefaultEntryHolder.defaultEntry, 1);
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(gcsOutputDirectory_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, gcsOutputDirectory_);
      }
      com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
          output, internalGetParameterValues(), ParameterValuesDefaultEntryHolder.defaultEntry, 3);
      if (failurePolicy_
          != com.google.cloud.aiplatform.v1beta1.PipelineFailurePolicy
              .PIPELINE_FAILURE_POLICY_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(4, failurePolicy_);
      }
      com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
          output, internalGetInputArtifacts(), InputArtifactsDefaultEntryHolder.defaultEntry, 5);
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(6, getDefaultRuntime());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      for (java.util.Map.Entry<java.lang.String, com.google.cloud.aiplatform.v1beta1.Value> entry :
          internalGetParameters().getMap().entrySet()) {
        com.google.protobuf.MapEntry<java.lang.String, com.google.cloud.aiplatform.v1beta1.Value>
            parameters__ =
                ParametersDefaultEntryHolder.defaultEntry
                    .newBuilderForType()
                    .setKey(entry.getKey())
                    .setValue(entry.getValue())
                    .build();
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, parameters__);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(gcsOutputDirectory_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, gcsOutputDirectory_);
      }
      for (java.util.Map.Entry<java.lang.String, com.google.protobuf.Value> entry :
          internalGetParameterValues().getMap().entrySet()) {
        com.google.protobuf.MapEntry<java.lang.String, com.google.protobuf.Value>
            parameterValues__ =
                ParameterValuesDefaultEntryHolder.defaultEntry
                    .newBuilderForType()
                    .setKey(entry.getKey())
                    .setValue(entry.getValue())
                    .build();
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, parameterValues__);
      }
      if (failurePolicy_
          != com.google.cloud.aiplatform.v1beta1.PipelineFailurePolicy
              .PIPELINE_FAILURE_POLICY_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(4, failurePolicy_);
      }
      for (java.util.Map.Entry<
              java.lang.String,
              com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.InputArtifact>
          entry : internalGetInputArtifacts().getMap().entrySet()) {
        com.google.protobuf.MapEntry<
                java.lang.String,
                com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.InputArtifact>
            inputArtifacts__ =
                InputArtifactsDefaultEntryHolder.defaultEntry
                    .newBuilderForType()
                    .setKey(entry.getKey())
                    .setValue(entry.getValue())
                    .build();
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, inputArtifacts__);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getDefaultRuntime());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig)) {
        return super.equals(obj);
      }
      com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig other =
          (com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig) obj;

      if (!internalGetParameters().equals(other.internalGetParameters())) return false;
      if (!getGcsOutputDirectory().equals(other.getGcsOutputDirectory())) return false;
      if (!internalGetParameterValues().equals(other.internalGetParameterValues())) return false;
      if (failurePolicy_ != other.failurePolicy_) return false;
      if (!internalGetInputArtifacts().equals(other.internalGetInputArtifacts())) return false;
      if (hasDefaultRuntime() != other.hasDefaultRuntime()) return false;
      if (hasDefaultRuntime()) {
        if (!getDefaultRuntime().equals(other.getDefaultRuntime())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (!internalGetParameters().getMap().isEmpty()) {
        hash = (37 * hash) + PARAMETERS_FIELD_NUMBER;
        hash = (53 * hash) + internalGetParameters().hashCode();
      }
      hash = (37 * hash) + GCS_OUTPUT_DIRECTORY_FIELD_NUMBER;
      hash = (53 * hash) + getGcsOutputDirectory().hashCode();
      if (!internalGetParameterValues().getMap().isEmpty()) {
        hash = (37 * hash) + PARAMETER_VALUES_FIELD_NUMBER;
        hash = (53 * hash) + internalGetParameterValues().hashCode();
      }
      hash = (37 * hash) + FAILURE_POLICY_FIELD_NUMBER;
      hash = (53 * hash) + failurePolicy_;
      if (!internalGetInputArtifacts().getMap().isEmpty()) {
        hash = (37 * hash) + INPUT_ARTIFACTS_FIELD_NUMBER;
        hash = (53 * hash) + internalGetInputArtifacts().hashCode();
      }
      if (hasDefaultRuntime()) {
        hash = (37 * hash) + DEFAULT_RUNTIME_FIELD_NUMBER;
        hash = (53 * hash) + getDefaultRuntime().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * The runtime config of a PipelineJob.
     * </pre>
     *
     * Protobuf type {@code google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig)
        com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfigOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1beta1.Pipeline
            .internal_static_google_cloud_aiplatform_v1beta1_PipelineJob_RuntimeConfig_descriptor;
      }

      @SuppressWarnings({"rawtypes"})
      protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
          int number) {
        switch (number) {
          case 1:
            return internalGetParameters();
          case 3:
            return internalGetParameterValues();
          case 5:
            return internalGetInputArtifacts();
          default:
            throw new RuntimeException("Invalid map field number: " + number);
        }
      }

      @SuppressWarnings({"rawtypes"})
      protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
          int number) {
        switch (number) {
          case 1:
            return internalGetMutableParameters();
          case 3:
            return internalGetMutableParameterValues();
          case 5:
            return internalGetMutableInputArtifacts();
          default:
            throw new RuntimeException("Invalid map field number: " + number);
        }
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1beta1.Pipeline
            .internal_static_google_cloud_aiplatform_v1beta1_PipelineJob_RuntimeConfig_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.class,
                com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.Builder.class);
      }

      // Construct using com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getDefaultRuntimeFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        internalGetMutableParameters().clear();
        gcsOutputDirectory_ = "";
        internalGetMutableParameterValues().clear();
        failurePolicy_ = 0;
        internalGetMutableInputArtifacts().clear();
        defaultRuntime_ = null;
        if (defaultRuntimeBuilder_ != null) {
          defaultRuntimeBuilder_.dispose();
          defaultRuntimeBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.aiplatform.v1beta1.Pipeline
            .internal_static_google_cloud_aiplatform_v1beta1_PipelineJob_RuntimeConfig_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig
          getDefaultInstanceForType() {
        return com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig build() {
        com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig buildPartial() {
        com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig result =
            new com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.parameters_ =
              internalGetParameters().build(ParametersDefaultEntryHolder.defaultEntry);
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.gcsOutputDirectory_ = gcsOutputDirectory_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.parameterValues_ =
              internalGetParameterValues().build(ParameterValuesDefaultEntryHolder.defaultEntry);
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.failurePolicy_ = failurePolicy_;
        }
        if (((from_bitField0_ & 0x00000010) != 0)) {
          result.inputArtifacts_ =
              internalGetInputArtifacts().build(InputArtifactsDefaultEntryHolder.defaultEntry);
        }
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000020) != 0)) {
          result.defaultRuntime_ =
              defaultRuntimeBuilder_ == null ? defaultRuntime_ : defaultRuntimeBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig) {
          return mergeFrom((com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig other) {
        if (other
            == com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.getDefaultInstance())
          return this;
        internalGetMutableParameters().mergeFrom(other.internalGetParameters());
        bitField0_ |= 0x00000001;
        if (!other.getGcsOutputDirectory().isEmpty()) {
          gcsOutputDirectory_ = other.gcsOutputDirectory_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        internalGetMutableParameterValues().mergeFrom(other.internalGetParameterValues());
        bitField0_ |= 0x00000004;
        if (other.failurePolicy_ != 0) {
          setFailurePolicyValue(other.getFailurePolicyValue());
        }
        internalGetMutableInputArtifacts().mergeFrom(other.internalGetInputArtifacts());
        bitField0_ |= 0x00000010;
        if (other.hasDefaultRuntime()) {
          mergeDefaultRuntime(other.getDefaultRuntime());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  com.google.protobuf.MapEntry<
                          java.lang.String, com.google.cloud.aiplatform.v1beta1.Value>
                      parameters__ =
                          input.readMessage(
                              ParametersDefaultEntryHolder.defaultEntry.getParserForType(),
                              extensionRegistry);
                  internalGetMutableParameters()
                      .ensureBuilderMap()
                      .put(parameters__.getKey(), parameters__.getValue());
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  gcsOutputDirectory_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              case 26:
                {
                  com.google.protobuf.MapEntry<java.lang.String, com.google.protobuf.Value>
                      parameterValues__ =
                          input.readMessage(
                              ParameterValuesDefaultEntryHolder.defaultEntry.getParserForType(),
                              extensionRegistry);
                  internalGetMutableParameterValues()
                      .ensureBuilderMap()
                      .put(parameterValues__.getKey(), parameterValues__.getValue());
                  bitField0_ |= 0x00000004;
                  break;
                } // case 26
              case 32:
                {
                  failurePolicy_ = input.readEnum();
                  bitField0_ |= 0x00000008;
                  break;
                } // case 32
              case 42:
                {
                  com.google.protobuf.MapEntry<
                          java.lang.String,
                          com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig
                              .InputArtifact>
                      inputArtifacts__ =
                          input.readMessage(
                              InputArtifactsDefaultEntryHolder.defaultEntry.getParserForType(),
                              extensionRegistry);
                  internalGetMutableInputArtifacts()
                      .ensureBuilderMap()
                      .put(inputArtifacts__.getKey(), inputArtifacts__.getValue());
                  bitField0_ |= 0x00000010;
                  break;
                } // case 42
              case 50:
                {
                  input.readMessage(
                      getDefaultRuntimeFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000020;
                  break;
                } // case 50
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private static final class ParametersConverter
          implements com.google.protobuf.MapFieldBuilder.Converter<
              java.lang.String,
              com.google.cloud.aiplatform.v1beta1.ValueOrBuilder,
              com.google.cloud.aiplatform.v1beta1.Value> {
        @java.lang.Override
        public com.google.cloud.aiplatform.v1beta1.Value build(
            com.google.cloud.aiplatform.v1beta1.ValueOrBuilder val) {
          if (val instanceof com.google.cloud.aiplatform.v1beta1.Value) {
            return (com.google.cloud.aiplatform.v1beta1.Value) val;
          }
          return ((com.google.cloud.aiplatform.v1beta1.Value.Builder) val).build();
        }

        @java.lang.Override
        public com.google.protobuf.MapEntry<
                java.lang.String, com.google.cloud.aiplatform.v1beta1.Value>
            defaultEntry() {
          return ParametersDefaultEntryHolder.defaultEntry;
        }
      }
      ;

      private static final ParametersConverter parametersConverter = new ParametersConverter();

      private com.google.protobuf.MapFieldBuilder<
              java.lang.String,
              com.google.cloud.aiplatform.v1beta1.ValueOrBuilder,
              com.google.cloud.aiplatform.v1beta1.Value,
              com.google.cloud.aiplatform.v1beta1.Value.Builder>
          parameters_;

      @java.lang.Deprecated
      private com.google.protobuf.MapFieldBuilder<
              java.lang.String,
              com.google.cloud.aiplatform.v1beta1.ValueOrBuilder,
              com.google.cloud.aiplatform.v1beta1.Value,
              com.google.cloud.aiplatform.v1beta1.Value.Builder>
          internalGetParameters() {
        if (parameters_ == null) {
          return new com.google.protobuf.MapFieldBuilder<>(parametersConverter);
        }
        return parameters_;
      }

      @java.lang.Deprecated
      private com.google.protobuf.MapFieldBuilder<
              java.lang.String,
              com.google.cloud.aiplatform.v1beta1.ValueOrBuilder,
              com.google.cloud.aiplatform.v1beta1.Value,
              com.google.cloud.aiplatform.v1beta1.Value.Builder>
          internalGetMutableParameters() {
        if (parameters_ == null) {
          parameters_ = new com.google.protobuf.MapFieldBuilder<>(parametersConverter);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return parameters_;
      }

      @java.lang.Deprecated
      public int getParametersCount() {
        return internalGetParameters().ensureBuilderMap().size();
      }

      /**
       *
       *
       * <pre>
       * Deprecated. Use
       * [RuntimeConfig.parameter_values][google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.parameter_values]
       * instead. The runtime parameters of the PipelineJob. The parameters will
       * be passed into
       * [PipelineJob.pipeline_spec][google.cloud.aiplatform.v1beta1.PipelineJob.pipeline_spec]
       * to replace the placeholders at runtime. This field is used by pipelines
       * built using `PipelineJob.pipeline_spec.schema_version` 2.0.0 or lower,
       * such as pipelines built using Kubeflow Pipelines SDK 1.8 or lower.
       * </pre>
       *
       * <code>
       * map&lt;string, .google.cloud.aiplatform.v1beta1.Value&gt; parameters = 1 [deprecated = true];
       * </code>
       */
      @java.lang.Override
      @java.lang.Deprecated
      public boolean containsParameters(java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        return internalGetParameters().ensureBuilderMap().containsKey(key);
      }

      /** Use {@link #getParametersMap()} instead. */
      @java.lang.Override
      @java.lang.Deprecated
      public java.util.Map<java.lang.String, com.google.cloud.aiplatform.v1beta1.Value>
          getParameters() {
        return getParametersMap();
      }

      /**
       *
       *
       * <pre>
       * Deprecated. Use
       * [RuntimeConfig.parameter_values][google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.parameter_values]
       * instead. The runtime parameters of the PipelineJob. The parameters will
       * be passed into
       * [PipelineJob.pipeline_spec][google.cloud.aiplatform.v1beta1.PipelineJob.pipeline_spec]
       * to replace the placeholders at runtime. This field is used by pipelines
       * built using `PipelineJob.pipeline_spec.schema_version` 2.0.0 or lower,
       * such as pipelines built using Kubeflow Pipelines SDK 1.8 or lower.
       * </pre>
       *
       * <code>
       * map&lt;string, .google.cloud.aiplatform.v1beta1.Value&gt; parameters = 1 [deprecated = true];
       * </code>
       */
      @java.lang.Override
      @java.lang.Deprecated
      public java.util.Map<java.lang.String, com.google.cloud.aiplatform.v1beta1.Value>
          getParametersMap() {
        return internalGetParameters().getImmutableMap();
      }

      /**
       *
       *
       * <pre>
       * Deprecated. Use
       * [RuntimeConfig.parameter_values][google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.parameter_values]
       * instead. The runtime parameters of the PipelineJob. The parameters will
       * be passed into
       * [PipelineJob.pipeline_spec][google.cloud.aiplatform.v1beta1.PipelineJob.pipeline_spec]
       * to replace the placeholders at runtime. This field is used by pipelines
       * built using `PipelineJob.pipeline_spec.schema_version` 2.0.0 or lower,
       * such as pipelines built using Kubeflow Pipelines SDK 1.8 or lower.
       * </pre>
       *
       * <code>
       * map&lt;string, .google.cloud.aiplatform.v1beta1.Value&gt; parameters = 1 [deprecated = true];
       * </code>
       */
      @java.lang.Override
      @java.lang.Deprecated
      public /* nullable */ com.google.cloud.aiplatform.v1beta1.Value getParametersOrDefault(
          java.lang.String key,
          /* nullable */
          com.google.cloud.aiplatform.v1beta1.Value defaultValue) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        java.util.Map<java.lang.String, com.google.cloud.aiplatform.v1beta1.ValueOrBuilder> map =
            internalGetMutableParameters().ensureBuilderMap();
        return map.containsKey(key) ? parametersConverter.build(map.get(key)) : defaultValue;
      }

      /**
       *
       *
       * <pre>
       * Deprecated. Use
       * [RuntimeConfig.parameter_values][google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.parameter_values]
       * instead. The runtime parameters of the PipelineJob. The parameters will
       * be passed into
       * [PipelineJob.pipeline_spec][google.cloud.aiplatform.v1beta1.PipelineJob.pipeline_spec]
       * to replace the placeholders at runtime. This field is used by pipelines
       * built using `PipelineJob.pipeline_spec.schema_version` 2.0.0 or lower,
       * such as pipelines built using Kubeflow Pipelines SDK 1.8 or lower.
       * </pre>
       *
       * <code>
       * map&lt;string, .google.cloud.aiplatform.v1beta1.Value&gt; parameters = 1 [deprecated = true];
       * </code>
       */
      @java.lang.Override
      @java.lang.Deprecated
      public com.google.cloud.aiplatform.v1beta1.Value getParametersOrThrow(java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        java.util.Map<java.lang.String, com.google.cloud.aiplatform.v1beta1.ValueOrBuilder> map =
            internalGetMutableParameters().ensureBuilderMap();
        if (!map.containsKey(key)) {
          throw new java.lang.IllegalArgumentException();
        }
        return parametersConverter.build(map.get(key));
      }

      @java.lang.Deprecated
      public Builder clearParameters() {
        bitField0_ = (bitField0_ & ~0x00000001);
        internalGetMutableParameters().clear();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Deprecated. Use
       * [RuntimeConfig.parameter_values][google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.parameter_values]
       * instead. The runtime parameters of the PipelineJob. The parameters will
       * be passed into
       * [PipelineJob.pipeline_spec][google.cloud.aiplatform.v1beta1.PipelineJob.pipeline_spec]
       * to replace the placeholders at runtime. This field is used by pipelines
       * built using `PipelineJob.pipeline_spec.schema_version` 2.0.0 or lower,
       * such as pipelines built using Kubeflow Pipelines SDK 1.8 or lower.
       * </pre>
       *
       * <code>
       * map&lt;string, .google.cloud.aiplatform.v1beta1.Value&gt; parameters = 1 [deprecated = true];
       * </code>
       */
      @java.lang.Deprecated
      public Builder removeParameters(java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        internalGetMutableParameters().ensureBuilderMap().remove(key);
        return this;
      }

      /** Use alternate mutation accessors instead. */
      @java.lang.Deprecated
      public java.util.Map<java.lang.String, com.google.cloud.aiplatform.v1beta1.Value>
          getMutableParameters() {
        bitField0_ |= 0x00000001;
        return internalGetMutableParameters().ensureMessageMap();
      }

      /**
       *
       *
       * <pre>
       * Deprecated. Use
       * [RuntimeConfig.parameter_values][google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.parameter_values]
       * instead. The runtime parameters of the PipelineJob. The parameters will
       * be passed into
       * [PipelineJob.pipeline_spec][google.cloud.aiplatform.v1beta1.PipelineJob.pipeline_spec]
       * to replace the placeholders at runtime. This field is used by pipelines
       * built using `PipelineJob.pipeline_spec.schema_version` 2.0.0 or lower,
       * such as pipelines built using Kubeflow Pipelines SDK 1.8 or lower.
       * </pre>
       *
       * <code>
       * map&lt;string, .google.cloud.aiplatform.v1beta1.Value&gt; parameters = 1 [deprecated = true];
       * </code>
       */
      @java.lang.Deprecated
      public Builder putParameters(
          java.lang.String key, com.google.cloud.aiplatform.v1beta1.Value value) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        if (value == null) {
          throw new NullPointerException("map value");
        }
        internalGetMutableParameters().ensureBuilderMap().put(key, value);
        bitField0_ |= 0x00000001;
        return this;
      }

      /**
       *
       *
       * <pre>
       * Deprecated. Use
       * [RuntimeConfig.parameter_values][google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.parameter_values]
       * instead. The runtime parameters of the PipelineJob. The parameters will
       * be passed into
       * [PipelineJob.pipeline_spec][google.cloud.aiplatform.v1beta1.PipelineJob.pipeline_spec]
       * to replace the placeholders at runtime. This field is used by pipelines
       * built using `PipelineJob.pipeline_spec.schema_version` 2.0.0 or lower,
       * such as pipelines built using Kubeflow Pipelines SDK 1.8 or lower.
       * </pre>
       *
       * <code>
       * map&lt;string, .google.cloud.aiplatform.v1beta1.Value&gt; parameters = 1 [deprecated = true];
       * </code>
       */
      @java.lang.Deprecated
      public Builder putAllParameters(
          java.util.Map<java.lang.String, com.google.cloud.aiplatform.v1beta1.Value> values) {
        for (java.util.Map.Entry<java.lang.String, com.google.cloud.aiplatform.v1beta1.Value> e :
            values.entrySet()) {
          if (e.getKey() == null || e.getValue() == null) {
            throw new NullPointerException();
          }
        }
        internalGetMutableParameters().ensureBuilderMap().putAll(values);
        bitField0_ |= 0x00000001;
        return this;
      }

      /**
       *
       *
       * <pre>
       * Deprecated. Use
       * [RuntimeConfig.parameter_values][google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.parameter_values]
       * instead. The runtime parameters of the PipelineJob. The parameters will
       * be passed into
       * [PipelineJob.pipeline_spec][google.cloud.aiplatform.v1beta1.PipelineJob.pipeline_spec]
       * to replace the placeholders at runtime. This field is used by pipelines
       * built using `PipelineJob.pipeline_spec.schema_version` 2.0.0 or lower,
       * such as pipelines built using Kubeflow Pipelines SDK 1.8 or lower.
       * </pre>
       *
       * <code>
       * map&lt;string, .google.cloud.aiplatform.v1beta1.Value&gt; parameters = 1 [deprecated = true];
       * </code>
       */
      @java.lang.Deprecated
      public com.google.cloud.aiplatform.v1beta1.Value.Builder putParametersBuilderIfAbsent(
          java.lang.String key) {
        java.util.Map<java.lang.String, com.google.cloud.aiplatform.v1beta1.ValueOrBuilder>
            builderMap = internalGetMutableParameters().ensureBuilderMap();
        com.google.cloud.aiplatform.v1beta1.ValueOrBuilder entry = builderMap.get(key);
        if (entry == null) {
          entry = com.google.cloud.aiplatform.v1beta1.Value.newBuilder();
          builderMap.put(key, entry);
        }
        if (entry instanceof com.google.cloud.aiplatform.v1beta1.Value) {
          entry = ((com.google.cloud.aiplatform.v1beta1.Value) entry).toBuilder();
          builderMap.put(key, entry);
        }
        return (com.google.cloud.aiplatform.v1beta1.Value.Builder) entry;
      }

      private java.lang.Object gcsOutputDirectory_ = "";

      /**
       *
       *
       * <pre>
       * Required. A path in a Cloud Storage bucket, which will be treated as the
       * root output directory of the pipeline. It is used by the system to
       * generate the paths of output artifacts. The artifact paths are generated
       * with a sub-path pattern `{job_id}/{task_id}/{output_key}` under the
       * specified output directory. The service account specified in this
       * pipeline must have the `storage.objects.get` and `storage.objects.create`
       * permissions for this bucket.
       * </pre>
       *
       * <code>string gcs_output_directory = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The gcsOutputDirectory.
       */
      public java.lang.String getGcsOutputDirectory() {
        java.lang.Object ref = gcsOutputDirectory_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          gcsOutputDirectory_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Required. A path in a Cloud Storage bucket, which will be treated as the
       * root output directory of the pipeline. It is used by the system to
       * generate the paths of output artifacts. The artifact paths are generated
       * with a sub-path pattern `{job_id}/{task_id}/{output_key}` under the
       * specified output directory. The service account specified in this
       * pipeline must have the `storage.objects.get` and `storage.objects.create`
       * permissions for this bucket.
       * </pre>
       *
       * <code>string gcs_output_directory = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for gcsOutputDirectory.
       */
      public com.google.protobuf.ByteString getGcsOutputDirectoryBytes() {
        java.lang.Object ref = gcsOutputDirectory_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          gcsOutputDirectory_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Required. A path in a Cloud Storage bucket, which will be treated as the
       * root output directory of the pipeline. It is used by the system to
       * generate the paths of output artifacts. The artifact paths are generated
       * with a sub-path pattern `{job_id}/{task_id}/{output_key}` under the
       * specified output directory. The service account specified in this
       * pipeline must have the `storage.objects.get` and `storage.objects.create`
       * permissions for this bucket.
       * </pre>
       *
       * <code>string gcs_output_directory = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The gcsOutputDirectory to set.
       * @return This builder for chaining.
       */
      public Builder setGcsOutputDirectory(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        gcsOutputDirectory_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required. A path in a Cloud Storage bucket, which will be treated as the
       * root output directory of the pipeline. It is used by the system to
       * generate the paths of output artifacts. The artifact paths are generated
       * with a sub-path pattern `{job_id}/{task_id}/{output_key}` under the
       * specified output directory. The service account specified in this
       * pipeline must have the `storage.objects.get` and `storage.objects.create`
       * permissions for this bucket.
       * </pre>
       *
       * <code>string gcs_output_directory = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearGcsOutputDirectory() {
        gcsOutputDirectory_ = getDefaultInstance().getGcsOutputDirectory();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required. A path in a Cloud Storage bucket, which will be treated as the
       * root output directory of the pipeline. It is used by the system to
       * generate the paths of output artifacts. The artifact paths are generated
       * with a sub-path pattern `{job_id}/{task_id}/{output_key}` under the
       * specified output directory. The service account specified in this
       * pipeline must have the `storage.objects.get` and `storage.objects.create`
       * permissions for this bucket.
       * </pre>
       *
       * <code>string gcs_output_directory = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bytes for gcsOutputDirectory to set.
       * @return This builder for chaining.
       */
      public Builder setGcsOutputDirectoryBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        gcsOutputDirectory_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      private static final class ParameterValuesConverter
          implements com.google.protobuf.MapFieldBuilder.Converter<
              java.lang.String, com.google.protobuf.ValueOrBuilder, com.google.protobuf.Value> {
        @java.lang.Override
        public com.google.protobuf.Value build(com.google.protobuf.ValueOrBuilder val) {
          if (val instanceof com.google.protobuf.Value) {
            return (com.google.protobuf.Value) val;
          }
          return ((com.google.protobuf.Value.Builder) val).build();
        }

        @java.lang.Override
        public com.google.protobuf.MapEntry<java.lang.String, com.google.protobuf.Value>
            defaultEntry() {
          return ParameterValuesDefaultEntryHolder.defaultEntry;
        }
      }
      ;

      private static final ParameterValuesConverter parameterValuesConverter =
          new ParameterValuesConverter();

      private com.google.protobuf.MapFieldBuilder<
              java.lang.String,
              com.google.protobuf.ValueOrBuilder,
              com.google.protobuf.Value,
              com.google.protobuf.Value.Builder>
          parameterValues_;

      private com.google.protobuf.MapFieldBuilder<
              java.lang.String,
              com.google.protobuf.ValueOrBuilder,
              com.google.protobuf.Value,
              com.google.protobuf.Value.Builder>
          internalGetParameterValues() {
        if (parameterValues_ == null) {
          return new com.google.protobuf.MapFieldBuilder<>(parameterValuesConverter);
        }
        return parameterValues_;
      }

      private com.google.protobuf.MapFieldBuilder<
              java.lang.String,
              com.google.protobuf.ValueOrBuilder,
              com.google.protobuf.Value,
              com.google.protobuf.Value.Builder>
          internalGetMutableParameterValues() {
        if (parameterValues_ == null) {
          parameterValues_ = new com.google.protobuf.MapFieldBuilder<>(parameterValuesConverter);
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return parameterValues_;
      }

      public int getParameterValuesCount() {
        return internalGetParameterValues().ensureBuilderMap().size();
      }

      /**
       *
       *
       * <pre>
       * The runtime parameters of the PipelineJob. The parameters will be
       * passed into
       * [PipelineJob.pipeline_spec][google.cloud.aiplatform.v1beta1.PipelineJob.pipeline_spec]
       * to replace the placeholders at runtime. This field is used by pipelines
       * built using `PipelineJob.pipeline_spec.schema_version` 2.1.0, such as
       * pipelines built using Kubeflow Pipelines SDK 1.9 or higher and the v2
       * DSL.
       * </pre>
       *
       * <code>map&lt;string, .google.protobuf.Value&gt; parameter_values = 3;</code>
       */
      @java.lang.Override
      public boolean containsParameterValues(java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        return internalGetParameterValues().ensureBuilderMap().containsKey(key);
      }

      /** Use {@link #getParameterValuesMap()} instead. */
      @java.lang.Override
      @java.lang.Deprecated
      public java.util.Map<java.lang.String, com.google.protobuf.Value> getParameterValues() {
        return getParameterValuesMap();
      }

      /**
       *
       *
       * <pre>
       * The runtime parameters of the PipelineJob. The parameters will be
       * passed into
       * [PipelineJob.pipeline_spec][google.cloud.aiplatform.v1beta1.PipelineJob.pipeline_spec]
       * to replace the placeholders at runtime. This field is used by pipelines
       * built using `PipelineJob.pipeline_spec.schema_version` 2.1.0, such as
       * pipelines built using Kubeflow Pipelines SDK 1.9 or higher and the v2
       * DSL.
       * </pre>
       *
       * <code>map&lt;string, .google.protobuf.Value&gt; parameter_values = 3;</code>
       */
      @java.lang.Override
      public java.util.Map<java.lang.String, com.google.protobuf.Value> getParameterValuesMap() {
        return internalGetParameterValues().getImmutableMap();
      }

      /**
       *
       *
       * <pre>
       * The runtime parameters of the PipelineJob. The parameters will be
       * passed into
       * [PipelineJob.pipeline_spec][google.cloud.aiplatform.v1beta1.PipelineJob.pipeline_spec]
       * to replace the placeholders at runtime. This field is used by pipelines
       * built using `PipelineJob.pipeline_spec.schema_version` 2.1.0, such as
       * pipelines built using Kubeflow Pipelines SDK 1.9 or higher and the v2
       * DSL.
       * </pre>
       *
       * <code>map&lt;string, .google.protobuf.Value&gt; parameter_values = 3;</code>
       */
      @java.lang.Override
      public /* nullable */ com.google.protobuf.Value getParameterValuesOrDefault(
          java.lang.String key,
          /* nullable */
          com.google.protobuf.Value defaultValue) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        java.util.Map<java.lang.String, com.google.protobuf.ValueOrBuilder> map =
            internalGetMutableParameterValues().ensureBuilderMap();
        return map.containsKey(key) ? parameterValuesConverter.build(map.get(key)) : defaultValue;
      }

      /**
       *
       *
       * <pre>
       * The runtime parameters of the PipelineJob. The parameters will be
       * passed into
       * [PipelineJob.pipeline_spec][google.cloud.aiplatform.v1beta1.PipelineJob.pipeline_spec]
       * to replace the placeholders at runtime. This field is used by pipelines
       * built using `PipelineJob.pipeline_spec.schema_version` 2.1.0, such as
       * pipelines built using Kubeflow Pipelines SDK 1.9 or higher and the v2
       * DSL.
       * </pre>
       *
       * <code>map&lt;string, .google.protobuf.Value&gt; parameter_values = 3;</code>
       */
      @java.lang.Override
      public com.google.protobuf.Value getParameterValuesOrThrow(java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        java.util.Map<java.lang.String, com.google.protobuf.ValueOrBuilder> map =
            internalGetMutableParameterValues().ensureBuilderMap();
        if (!map.containsKey(key)) {
          throw new java.lang.IllegalArgumentException();
        }
        return parameterValuesConverter.build(map.get(key));
      }

      public Builder clearParameterValues() {
        bitField0_ = (bitField0_ & ~0x00000004);
        internalGetMutableParameterValues().clear();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The runtime parameters of the PipelineJob. The parameters will be
       * passed into
       * [PipelineJob.pipeline_spec][google.cloud.aiplatform.v1beta1.PipelineJob.pipeline_spec]
       * to replace the placeholders at runtime. This field is used by pipelines
       * built using `PipelineJob.pipeline_spec.schema_version` 2.1.0, such as
       * pipelines built using Kubeflow Pipelines SDK 1.9 or higher and the v2
       * DSL.
       * </pre>
       *
       * <code>map&lt;string, .google.protobuf.Value&gt; parameter_values = 3;</code>
       */
      public Builder removeParameterValues(java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        internalGetMutableParameterValues().ensureBuilderMap().remove(key);
        return this;
      }

      /** Use alternate mutation accessors instead. */
      @java.lang.Deprecated
      public java.util.Map<java.lang.String, com.google.protobuf.Value>
          getMutableParameterValues() {
        bitField0_ |= 0x00000004;
        return internalGetMutableParameterValues().ensureMessageMap();
      }

      /**
       *
       *
       * <pre>
       * The runtime parameters of the PipelineJob. The parameters will be
       * passed into
       * [PipelineJob.pipeline_spec][google.cloud.aiplatform.v1beta1.PipelineJob.pipeline_spec]
       * to replace the placeholders at runtime. This field is used by pipelines
       * built using `PipelineJob.pipeline_spec.schema_version` 2.1.0, such as
       * pipelines built using Kubeflow Pipelines SDK 1.9 or higher and the v2
       * DSL.
       * </pre>
       *
       * <code>map&lt;string, .google.protobuf.Value&gt; parameter_values = 3;</code>
       */
      public Builder putParameterValues(java.lang.String key, com.google.protobuf.Value value) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        if (value == null) {
          throw new NullPointerException("map value");
        }
        internalGetMutableParameterValues().ensureBuilderMap().put(key, value);
        bitField0_ |= 0x00000004;
        return this;
      }

      /**
       *
       *
       * <pre>
       * The runtime parameters of the PipelineJob. The parameters will be
       * passed into
       * [PipelineJob.pipeline_spec][google.cloud.aiplatform.v1beta1.PipelineJob.pipeline_spec]
       * to replace the placeholders at runtime. This field is used by pipelines
       * built using `PipelineJob.pipeline_spec.schema_version` 2.1.0, such as
       * pipelines built using Kubeflow Pipelines SDK 1.9 or higher and the v2
       * DSL.
       * </pre>
       *
       * <code>map&lt;string, .google.protobuf.Value&gt; parameter_values = 3;</code>
       */
      public Builder putAllParameterValues(
          java.util.Map<java.lang.String, com.google.protobuf.Value> values) {
        for (java.util.Map.Entry<java.lang.String, com.google.protobuf.Value> e :
            values.entrySet()) {
          if (e.getKey() == null || e.getValue() == null) {
            throw new NullPointerException();
          }
        }
        internalGetMutableParameterValues().ensureBuilderMap().putAll(values);
        bitField0_ |= 0x00000004;
        return this;
      }

      /**
       *
       *
       * <pre>
       * The runtime parameters of the PipelineJob. The parameters will be
       * passed into
       * [PipelineJob.pipeline_spec][google.cloud.aiplatform.v1beta1.PipelineJob.pipeline_spec]
       * to replace the placeholders at runtime. This field is used by pipelines
       * built using `PipelineJob.pipeline_spec.schema_version` 2.1.0, such as
       * pipelines built using Kubeflow Pipelines SDK 1.9 or higher and the v2
       * DSL.
       * </pre>
       *
       * <code>map&lt;string, .google.protobuf.Value&gt; parameter_values = 3;</code>
       */
      public com.google.protobuf.Value.Builder putParameterValuesBuilderIfAbsent(
          java.lang.String key) {
        java.util.Map<java.lang.String, com.google.protobuf.ValueOrBuilder> builderMap =
            internalGetMutableParameterValues().ensureBuilderMap();
        com.google.protobuf.ValueOrBuilder entry = builderMap.get(key);
        if (entry == null) {
          entry = com.google.protobuf.Value.newBuilder();
          builderMap.put(key, entry);
        }
        if (entry instanceof com.google.protobuf.Value) {
          entry = ((com.google.protobuf.Value) entry).toBuilder();
          builderMap.put(key, entry);
        }
        return (com.google.protobuf.Value.Builder) entry;
      }

      private int failurePolicy_ = 0;

      /**
       *
       *
       * <pre>
       * Represents the failure policy of a pipeline. Currently, the default of a
       * pipeline is that the pipeline will continue to run until no more tasks
       * can be executed, also known as PIPELINE_FAILURE_POLICY_FAIL_SLOW.
       * However, if a pipeline is set to PIPELINE_FAILURE_POLICY_FAIL_FAST, it
       * will stop scheduling any new tasks when a task has failed. Any scheduled
       * tasks will continue to completion.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.PipelineFailurePolicy failure_policy = 4;</code>
       *
       * @return The enum numeric value on the wire for failurePolicy.
       */
      @java.lang.Override
      public int getFailurePolicyValue() {
        return failurePolicy_;
      }

      /**
       *
       *
       * <pre>
       * Represents the failure policy of a pipeline. Currently, the default of a
       * pipeline is that the pipeline will continue to run until no more tasks
       * can be executed, also known as PIPELINE_FAILURE_POLICY_FAIL_SLOW.
       * However, if a pipeline is set to PIPELINE_FAILURE_POLICY_FAIL_FAST, it
       * will stop scheduling any new tasks when a task has failed. Any scheduled
       * tasks will continue to completion.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.PipelineFailurePolicy failure_policy = 4;</code>
       *
       * @param value The enum numeric value on the wire for failurePolicy to set.
       * @return This builder for chaining.
       */
      public Builder setFailurePolicyValue(int value) {
        failurePolicy_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Represents the failure policy of a pipeline. Currently, the default of a
       * pipeline is that the pipeline will continue to run until no more tasks
       * can be executed, also known as PIPELINE_FAILURE_POLICY_FAIL_SLOW.
       * However, if a pipeline is set to PIPELINE_FAILURE_POLICY_FAIL_FAST, it
       * will stop scheduling any new tasks when a task has failed. Any scheduled
       * tasks will continue to completion.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.PipelineFailurePolicy failure_policy = 4;</code>
       *
       * @return The failurePolicy.
       */
      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.PipelineFailurePolicy getFailurePolicy() {
        com.google.cloud.aiplatform.v1beta1.PipelineFailurePolicy result =
            com.google.cloud.aiplatform.v1beta1.PipelineFailurePolicy.forNumber(failurePolicy_);
        return result == null
            ? com.google.cloud.aiplatform.v1beta1.PipelineFailurePolicy.UNRECOGNIZED
            : result;
      }

      /**
       *
       *
       * <pre>
       * Represents the failure policy of a pipeline. Currently, the default of a
       * pipeline is that the pipeline will continue to run until no more tasks
       * can be executed, also known as PIPELINE_FAILURE_POLICY_FAIL_SLOW.
       * However, if a pipeline is set to PIPELINE_FAILURE_POLICY_FAIL_FAST, it
       * will stop scheduling any new tasks when a task has failed. Any scheduled
       * tasks will continue to completion.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.PipelineFailurePolicy failure_policy = 4;</code>
       *
       * @param value The failurePolicy to set.
       * @return This builder for chaining.
       */
      public Builder setFailurePolicy(
          com.google.cloud.aiplatform.v1beta1.PipelineFailurePolicy value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000008;
        failurePolicy_ = value.getNumber();
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Represents the failure policy of a pipeline. Currently, the default of a
       * pipeline is that the pipeline will continue to run until no more tasks
       * can be executed, also known as PIPELINE_FAILURE_POLICY_FAIL_SLOW.
       * However, if a pipeline is set to PIPELINE_FAILURE_POLICY_FAIL_FAST, it
       * will stop scheduling any new tasks when a task has failed. Any scheduled
       * tasks will continue to completion.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.PipelineFailurePolicy failure_policy = 4;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearFailurePolicy() {
        bitField0_ = (bitField0_ & ~0x00000008);
        failurePolicy_ = 0;
        onChanged();
        return this;
      }

      private static final class InputArtifactsConverter
          implements com.google.protobuf.MapFieldBuilder.Converter<
              java.lang.String,
              com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.InputArtifactOrBuilder,
              com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.InputArtifact> {
        @java.lang.Override
        public com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.InputArtifact build(
            com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.InputArtifactOrBuilder
                val) {
          if (val
              instanceof
              com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.InputArtifact) {
            return (com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.InputArtifact)
                val;
          }
          return ((com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.InputArtifact
                      .Builder)
                  val)
              .build();
        }

        @java.lang.Override
        public com.google.protobuf.MapEntry<
                java.lang.String,
                com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.InputArtifact>
            defaultEntry() {
          return InputArtifactsDefaultEntryHolder.defaultEntry;
        }
      }
      ;

      private static final InputArtifactsConverter inputArtifactsConverter =
          new InputArtifactsConverter();

      private com.google.protobuf.MapFieldBuilder<
              java.lang.String,
              com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.InputArtifactOrBuilder,
              com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.InputArtifact,
              com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.InputArtifact.Builder>
          inputArtifacts_;

      private com.google.protobuf.MapFieldBuilder<
              java.lang.String,
              com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.InputArtifactOrBuilder,
              com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.InputArtifact,
              com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.InputArtifact.Builder>
          internalGetInputArtifacts() {
        if (inputArtifacts_ == null) {
          return new com.google.protobuf.MapFieldBuilder<>(inputArtifactsConverter);
        }
        return inputArtifacts_;
      }

      private com.google.protobuf.MapFieldBuilder<
              java.lang.String,
              com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.InputArtifactOrBuilder,
              com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.InputArtifact,
              com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.InputArtifact.Builder>
          internalGetMutableInputArtifacts() {
        if (inputArtifacts_ == null) {
          inputArtifacts_ = new com.google.protobuf.MapFieldBuilder<>(inputArtifactsConverter);
        }
        bitField0_ |= 0x00000010;
        onChanged();
        return inputArtifacts_;
      }

      public int getInputArtifactsCount() {
        return internalGetInputArtifacts().ensureBuilderMap().size();
      }

      /**
       *
       *
       * <pre>
       * The runtime artifacts of the PipelineJob. The key will be the input
       * artifact name and the value would be one of the InputArtifact.
       * </pre>
       *
       * <code>
       * map&lt;string, .google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.InputArtifact&gt; input_artifacts = 5;
       * </code>
       */
      @java.lang.Override
      public boolean containsInputArtifacts(java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        return internalGetInputArtifacts().ensureBuilderMap().containsKey(key);
      }

      /** Use {@link #getInputArtifactsMap()} instead. */
      @java.lang.Override
      @java.lang.Deprecated
      public java.util.Map<
              java.lang.String,
              com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.InputArtifact>
          getInputArtifacts() {
        return getInputArtifactsMap();
      }

      /**
       *
       *
       * <pre>
       * The runtime artifacts of the PipelineJob. The key will be the input
       * artifact name and the value would be one of the InputArtifact.
       * </pre>
       *
       * <code>
       * map&lt;string, .google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.InputArtifact&gt; input_artifacts = 5;
       * </code>
       */
      @java.lang.Override
      public java.util.Map<
              java.lang.String,
              com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.InputArtifact>
          getInputArtifactsMap() {
        return internalGetInputArtifacts().getImmutableMap();
      }

      /**
       *
       *
       * <pre>
       * The runtime artifacts of the PipelineJob. The key will be the input
       * artifact name and the value would be one of the InputArtifact.
       * </pre>
       *
       * <code>
       * map&lt;string, .google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.InputArtifact&gt; input_artifacts = 5;
       * </code>
       */
      @java.lang.Override
      public /* nullable */ com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig
              .InputArtifact
          getInputArtifactsOrDefault(
              java.lang.String key,
              /* nullable */
              com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.InputArtifact
                  defaultValue) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        java.util.Map<
                java.lang.String,
                com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig
                    .InputArtifactOrBuilder>
            map = internalGetMutableInputArtifacts().ensureBuilderMap();
        return map.containsKey(key) ? inputArtifactsConverter.build(map.get(key)) : defaultValue;
      }

      /**
       *
       *
       * <pre>
       * The runtime artifacts of the PipelineJob. The key will be the input
       * artifact name and the value would be one of the InputArtifact.
       * </pre>
       *
       * <code>
       * map&lt;string, .google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.InputArtifact&gt; input_artifacts = 5;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.InputArtifact
          getInputArtifactsOrThrow(java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        java.util.Map<
                java.lang.String,
                com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig
                    .InputArtifactOrBuilder>
            map = internalGetMutableInputArtifacts().ensureBuilderMap();
        if (!map.containsKey(key)) {
          throw new java.lang.IllegalArgumentException();
        }
        return inputArtifactsConverter.build(map.get(key));
      }

      public Builder clearInputArtifacts() {
        bitField0_ = (bitField0_ & ~0x00000010);
        internalGetMutableInputArtifacts().clear();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The runtime artifacts of the PipelineJob. The key will be the input
       * artifact name and the value would be one of the InputArtifact.
       * </pre>
       *
       * <code>
       * map&lt;string, .google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.InputArtifact&gt; input_artifacts = 5;
       * </code>
       */
      public Builder removeInputArtifacts(java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        internalGetMutableInputArtifacts().ensureBuilderMap().remove(key);
        return this;
      }

      /** Use alternate mutation accessors instead. */
      @java.lang.Deprecated
      public java.util.Map<
              java.lang.String,
              com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.InputArtifact>
          getMutableInputArtifacts() {
        bitField0_ |= 0x00000010;
        return internalGetMutableInputArtifacts().ensureMessageMap();
      }

      /**
       *
       *
       * <pre>
       * The runtime artifacts of the PipelineJob. The key will be the input
       * artifact name and the value would be one of the InputArtifact.
       * </pre>
       *
       * <code>
       * map&lt;string, .google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.InputArtifact&gt; input_artifacts = 5;
       * </code>
       */
      public Builder putInputArtifacts(
          java.lang.String key,
          com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.InputArtifact value) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        if (value == null) {
          throw new NullPointerException("map value");
        }
        internalGetMutableInputArtifacts().ensureBuilderMap().put(key, value);
        bitField0_ |= 0x00000010;
        return this;
      }

      /**
       *
       *
       * <pre>
       * The runtime artifacts of the PipelineJob. The key will be the input
       * artifact name and the value would be one of the InputArtifact.
       * </pre>
       *
       * <code>
       * map&lt;string, .google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.InputArtifact&gt; input_artifacts = 5;
       * </code>
       */
      public Builder putAllInputArtifacts(
          java.util.Map<
                  java.lang.String,
                  com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.InputArtifact>
              values) {
        for (java.util.Map.Entry<
                java.lang.String,
                com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.InputArtifact>
            e : values.entrySet()) {
          if (e.getKey() == null || e.getValue() == null) {
            throw new NullPointerException();
          }
        }
        internalGetMutableInputArtifacts().ensureBuilderMap().putAll(values);
        bitField0_ |= 0x00000010;
        return this;
      }

      /**
       *
       *
       * <pre>
       * The runtime artifacts of the PipelineJob. The key will be the input
       * artifact name and the value would be one of the InputArtifact.
       * </pre>
       *
       * <code>
       * map&lt;string, .google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.InputArtifact&gt; input_artifacts = 5;
       * </code>
       */
      public com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.InputArtifact.Builder
          putInputArtifactsBuilderIfAbsent(java.lang.String key) {
        java.util.Map<
                java.lang.String,
                com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig
                    .InputArtifactOrBuilder>
            builderMap = internalGetMutableInputArtifacts().ensureBuilderMap();
        com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.InputArtifactOrBuilder entry =
            builderMap.get(key);
        if (entry == null) {
          entry =
              com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.InputArtifact
                  .newBuilder();
          builderMap.put(key, entry);
        }
        if (entry
            instanceof
            com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.InputArtifact) {
          entry =
              ((com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.InputArtifact) entry)
                  .toBuilder();
          builderMap.put(key, entry);
        }
        return (com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.InputArtifact.Builder)
            entry;
      }

      private com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.DefaultRuntime
          defaultRuntime_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.DefaultRuntime,
              com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.DefaultRuntime.Builder,
              com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.DefaultRuntimeOrBuilder>
          defaultRuntimeBuilder_;

      /**
       *
       *
       * <pre>
       * Optional. The default runtime for the PipelineJob. If not provided,
       * Vertex Custom Job(on demand) is used as the runtime. For Vertex Custom
       * Job, please refer to
       * https://cloud.google.com/vertex-ai/docs/training/overview.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.DefaultRuntime default_runtime = 6 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return Whether the defaultRuntime field is set.
       */
      public boolean hasDefaultRuntime() {
        return ((bitField0_ & 0x00000020) != 0);
      }

      /**
       *
       *
       * <pre>
       * Optional. The default runtime for the PipelineJob. If not provided,
       * Vertex Custom Job(on demand) is used as the runtime. For Vertex Custom
       * Job, please refer to
       * https://cloud.google.com/vertex-ai/docs/training/overview.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.DefaultRuntime default_runtime = 6 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The defaultRuntime.
       */
      public com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.DefaultRuntime
          getDefaultRuntime() {
        if (defaultRuntimeBuilder_ == null) {
          return defaultRuntime_ == null
              ? com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.DefaultRuntime
                  .getDefaultInstance()
              : defaultRuntime_;
        } else {
          return defaultRuntimeBuilder_.getMessage();
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. The default runtime for the PipelineJob. If not provided,
       * Vertex Custom Job(on demand) is used as the runtime. For Vertex Custom
       * Job, please refer to
       * https://cloud.google.com/vertex-ai/docs/training/overview.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.DefaultRuntime default_runtime = 6 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setDefaultRuntime(
          com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.DefaultRuntime value) {
        if (defaultRuntimeBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          defaultRuntime_ = value;
        } else {
          defaultRuntimeBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000020;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. The default runtime for the PipelineJob. If not provided,
       * Vertex Custom Job(on demand) is used as the runtime. For Vertex Custom
       * Job, please refer to
       * https://cloud.google.com/vertex-ai/docs/training/overview.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.DefaultRuntime default_runtime = 6 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setDefaultRuntime(
          com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.DefaultRuntime.Builder
              builderForValue) {
        if (defaultRuntimeBuilder_ == null) {
          defaultRuntime_ = builderForValue.build();
        } else {
          defaultRuntimeBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000020;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. The default runtime for the PipelineJob. If not provided,
       * Vertex Custom Job(on demand) is used as the runtime. For Vertex Custom
       * Job, please refer to
       * https://cloud.google.com/vertex-ai/docs/training/overview.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.DefaultRuntime default_runtime = 6 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder mergeDefaultRuntime(
          com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.DefaultRuntime value) {
        if (defaultRuntimeBuilder_ == null) {
          if (((bitField0_ & 0x00000020) != 0)
              && defaultRuntime_ != null
              && defaultRuntime_
                  != com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.DefaultRuntime
                      .getDefaultInstance()) {
            getDefaultRuntimeBuilder().mergeFrom(value);
          } else {
            defaultRuntime_ = value;
          }
        } else {
          defaultRuntimeBuilder_.mergeFrom(value);
        }
        if (defaultRuntime_ != null) {
          bitField0_ |= 0x00000020;
          onChanged();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. The default runtime for the PipelineJob. If not provided,
       * Vertex Custom Job(on demand) is used as the runtime. For Vertex Custom
       * Job, please refer to
       * https://cloud.google.com/vertex-ai/docs/training/overview.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.DefaultRuntime default_runtime = 6 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder clearDefaultRuntime() {
        bitField0_ = (bitField0_ & ~0x00000020);
        defaultRuntime_ = null;
        if (defaultRuntimeBuilder_ != null) {
          defaultRuntimeBuilder_.dispose();
          defaultRuntimeBuilder_ = null;
        }
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. The default runtime for the PipelineJob. If not provided,
       * Vertex Custom Job(on demand) is used as the runtime. For Vertex Custom
       * Job, please refer to
       * https://cloud.google.com/vertex-ai/docs/training/overview.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.DefaultRuntime default_runtime = 6 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.DefaultRuntime.Builder
          getDefaultRuntimeBuilder() {
        bitField0_ |= 0x00000020;
        onChanged();
        return getDefaultRuntimeFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * Optional. The default runtime for the PipelineJob. If not provided,
       * Vertex Custom Job(on demand) is used as the runtime. For Vertex Custom
       * Job, please refer to
       * https://cloud.google.com/vertex-ai/docs/training/overview.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.DefaultRuntime default_runtime = 6 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.DefaultRuntimeOrBuilder
          getDefaultRuntimeOrBuilder() {
        if (defaultRuntimeBuilder_ != null) {
          return defaultRuntimeBuilder_.getMessageOrBuilder();
        } else {
          return defaultRuntime_ == null
              ? com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.DefaultRuntime
                  .getDefaultInstance()
              : defaultRuntime_;
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. The default runtime for the PipelineJob. If not provided,
       * Vertex Custom Job(on demand) is used as the runtime. For Vertex Custom
       * Job, please refer to
       * https://cloud.google.com/vertex-ai/docs/training/overview.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.DefaultRuntime default_runtime = 6 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.DefaultRuntime,
              com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.DefaultRuntime.Builder,
              com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.DefaultRuntimeOrBuilder>
          getDefaultRuntimeFieldBuilder() {
        if (defaultRuntimeBuilder_ == null) {
          defaultRuntimeBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.DefaultRuntime,
                  com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.DefaultRuntime
                      .Builder,
                  com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig
                      .DefaultRuntimeOrBuilder>(
                  getDefaultRuntime(), getParentForChildren(), isClean());
          defaultRuntime_ = null;
        }
        return defaultRuntimeBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig)
    private static final com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig();
    }

    public static com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<RuntimeConfig> PARSER =
        new com.google.protobuf.AbstractParser<RuntimeConfig>() {
          @java.lang.Override
          public RuntimeConfig parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<RuntimeConfig> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<RuntimeConfig> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";

  /**
   *
   *
   * <pre>
   * Output only. The resource name of the PipelineJob.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Output only. The resource name of the PipelineJob.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DISPLAY_NAME_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object displayName_ = "";

  /**
   *
   *
   * <pre>
   * The display name of the Pipeline.
   * The name can be up to 128 characters long and can consist of any UTF-8
   * characters.
   * </pre>
   *
   * <code>string display_name = 2;</code>
   *
   * @return The displayName.
   */
  @java.lang.Override
  public java.lang.String getDisplayName() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      displayName_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * The display name of the Pipeline.
   * The name can be up to 128 characters long and can consist of any UTF-8
   * characters.
   * </pre>
   *
   * <code>string display_name = 2;</code>
   *
   * @return The bytes for displayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDisplayNameBytes() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      displayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 3;
  private com.google.protobuf.Timestamp createTime_;

  /**
   *
   *
   * <pre>
   * Output only. Pipeline creation time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * Output only. Pipeline creation time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  /**
   *
   *
   * <pre>
   * Output only. Pipeline creation time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int START_TIME_FIELD_NUMBER = 4;
  private com.google.protobuf.Timestamp startTime_;

  /**
   *
   *
   * <pre>
   * Output only. Pipeline start time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp start_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the startTime field is set.
   */
  @java.lang.Override
  public boolean hasStartTime() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * Output only. Pipeline start time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp start_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The startTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getStartTime() {
    return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
  }

  /**
   *
   *
   * <pre>
   * Output only. Pipeline start time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp start_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getStartTimeOrBuilder() {
    return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
  }

  public static final int END_TIME_FIELD_NUMBER = 5;
  private com.google.protobuf.Timestamp endTime_;

  /**
   *
   *
   * <pre>
   * Output only. Pipeline end time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp end_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the endTime field is set.
   */
  @java.lang.Override
  public boolean hasEndTime() {
    return ((bitField0_ & 0x00000004) != 0);
  }

  /**
   *
   *
   * <pre>
   * Output only. Pipeline end time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp end_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The endTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getEndTime() {
    return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
  }

  /**
   *
   *
   * <pre>
   * Output only. Pipeline end time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp end_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getEndTimeOrBuilder() {
    return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
  }

  public static final int UPDATE_TIME_FIELD_NUMBER = 6;
  private com.google.protobuf.Timestamp updateTime_;

  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this PipelineJob was most recently updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the updateTime field is set.
   */
  @java.lang.Override
  public boolean hasUpdateTime() {
    return ((bitField0_ & 0x00000008) != 0);
  }

  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this PipelineJob was most recently updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The updateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getUpdateTime() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }

  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this PipelineJob was most recently updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }

  public static final int PIPELINE_SPEC_FIELD_NUMBER = 7;
  private com.google.protobuf.Struct pipelineSpec_;

  /**
   *
   *
   * <pre>
   * The spec of the pipeline.
   * </pre>
   *
   * <code>.google.protobuf.Struct pipeline_spec = 7;</code>
   *
   * @return Whether the pipelineSpec field is set.
   */
  @java.lang.Override
  public boolean hasPipelineSpec() {
    return ((bitField0_ & 0x00000010) != 0);
  }

  /**
   *
   *
   * <pre>
   * The spec of the pipeline.
   * </pre>
   *
   * <code>.google.protobuf.Struct pipeline_spec = 7;</code>
   *
   * @return The pipelineSpec.
   */
  @java.lang.Override
  public com.google.protobuf.Struct getPipelineSpec() {
    return pipelineSpec_ == null ? com.google.protobuf.Struct.getDefaultInstance() : pipelineSpec_;
  }

  /**
   *
   *
   * <pre>
   * The spec of the pipeline.
   * </pre>
   *
   * <code>.google.protobuf.Struct pipeline_spec = 7;</code>
   */
  @java.lang.Override
  public com.google.protobuf.StructOrBuilder getPipelineSpecOrBuilder() {
    return pipelineSpec_ == null ? com.google.protobuf.Struct.getDefaultInstance() : pipelineSpec_;
  }

  public static final int STATE_FIELD_NUMBER = 8;
  private int state_ = 0;

  /**
   *
   *
   * <pre>
   * Output only. The detailed state of the job.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.PipelineState state = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for state.
   */
  @java.lang.Override
  public int getStateValue() {
    return state_;
  }

  /**
   *
   *
   * <pre>
   * Output only. The detailed state of the job.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.PipelineState state = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The state.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.PipelineState getState() {
    com.google.cloud.aiplatform.v1beta1.PipelineState result =
        com.google.cloud.aiplatform.v1beta1.PipelineState.forNumber(state_);
    return result == null ? com.google.cloud.aiplatform.v1beta1.PipelineState.UNRECOGNIZED : result;
  }

  public static final int JOB_DETAIL_FIELD_NUMBER = 9;
  private com.google.cloud.aiplatform.v1beta1.PipelineJobDetail jobDetail_;

  /**
   *
   *
   * <pre>
   * Output only. The details of pipeline run. Not available in the list view.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.PipelineJobDetail job_detail = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the jobDetail field is set.
   */
  @java.lang.Override
  public boolean hasJobDetail() {
    return ((bitField0_ & 0x00000020) != 0);
  }

  /**
   *
   *
   * <pre>
   * Output only. The details of pipeline run. Not available in the list view.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.PipelineJobDetail job_detail = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The jobDetail.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.PipelineJobDetail getJobDetail() {
    return jobDetail_ == null
        ? com.google.cloud.aiplatform.v1beta1.PipelineJobDetail.getDefaultInstance()
        : jobDetail_;
  }

  /**
   *
   *
   * <pre>
   * Output only. The details of pipeline run. Not available in the list view.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.PipelineJobDetail job_detail = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.PipelineJobDetailOrBuilder getJobDetailOrBuilder() {
    return jobDetail_ == null
        ? com.google.cloud.aiplatform.v1beta1.PipelineJobDetail.getDefaultInstance()
        : jobDetail_;
  }

  public static final int ERROR_FIELD_NUMBER = 10;
  private com.google.rpc.Status error_;

  /**
   *
   *
   * <pre>
   * Output only. The error that occurred during pipeline execution.
   * Only populated when the pipeline's state is FAILED or CANCELLED.
   * </pre>
   *
   * <code>.google.rpc.Status error = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return Whether the error field is set.
   */
  @java.lang.Override
  public boolean hasError() {
    return ((bitField0_ & 0x00000040) != 0);
  }

  /**
   *
   *
   * <pre>
   * Output only. The error that occurred during pipeline execution.
   * Only populated when the pipeline's state is FAILED or CANCELLED.
   * </pre>
   *
   * <code>.google.rpc.Status error = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The error.
   */
  @java.lang.Override
  public com.google.rpc.Status getError() {
    return error_ == null ? com.google.rpc.Status.getDefaultInstance() : error_;
  }

  /**
   *
   *
   * <pre>
   * Output only. The error that occurred during pipeline execution.
   * Only populated when the pipeline's state is FAILED or CANCELLED.
   * </pre>
   *
   * <code>.google.rpc.Status error = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   */
  @java.lang.Override
  public com.google.rpc.StatusOrBuilder getErrorOrBuilder() {
    return error_ == null ? com.google.rpc.Status.getDefaultInstance() : error_;
  }

  public static final int LABELS_FIELD_NUMBER = 11;

  private static final class LabelsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.aiplatform.v1beta1.Pipeline
                .internal_static_google_cloud_aiplatform_v1beta1_PipelineJob_LabelsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
    if (labels_ == null) {
      return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
    }
    return labels_;
  }

  public int getLabelsCount() {
    return internalGetLabels().getMap().size();
  }

  /**
   *
   *
   * <pre>
   * The labels with user-defined metadata to organize PipelineJob.
   *
   * Label keys and values can be no longer than 64 characters
   * (Unicode codepoints), can only contain lowercase letters, numeric
   * characters, underscores and dashes. International characters are allowed.
   *
   * See https://goo.gl/xmQnxf for more information and examples of labels.
   *
   * Note there is some reserved label key for Vertex AI Pipelines.
   * - `vertex-ai-pipelines-run-billing-id`, user set value will get overrided.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 11;</code>
   */
  @java.lang.Override
  public boolean containsLabels(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetLabels().getMap().containsKey(key);
  }

  /** Use {@link #getLabelsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getLabels() {
    return getLabelsMap();
  }

  /**
   *
   *
   * <pre>
   * The labels with user-defined metadata to organize PipelineJob.
   *
   * Label keys and values can be no longer than 64 characters
   * (Unicode codepoints), can only contain lowercase letters, numeric
   * characters, underscores and dashes. International characters are allowed.
   *
   * See https://goo.gl/xmQnxf for more information and examples of labels.
   *
   * Note there is some reserved label key for Vertex AI Pipelines.
   * - `vertex-ai-pipelines-run-billing-id`, user set value will get overrided.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 11;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
    return internalGetLabels().getMap();
  }

  /**
   *
   *
   * <pre>
   * The labels with user-defined metadata to organize PipelineJob.
   *
   * Label keys and values can be no longer than 64 characters
   * (Unicode codepoints), can only contain lowercase letters, numeric
   * characters, underscores and dashes. International characters are allowed.
   *
   * See https://goo.gl/xmQnxf for more information and examples of labels.
   *
   * Note there is some reserved label key for Vertex AI Pipelines.
   * - `vertex-ai-pipelines-run-billing-id`, user set value will get overrided.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 11;</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getLabelsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }

  /**
   *
   *
   * <pre>
   * The labels with user-defined metadata to organize PipelineJob.
   *
   * Label keys and values can be no longer than 64 characters
   * (Unicode codepoints), can only contain lowercase letters, numeric
   * characters, underscores and dashes. International characters are allowed.
   *
   * See https://goo.gl/xmQnxf for more information and examples of labels.
   *
   * Note there is some reserved label key for Vertex AI Pipelines.
   * - `vertex-ai-pipelines-run-billing-id`, user set value will get overrided.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 11;</code>
   */
  @java.lang.Override
  public java.lang.String getLabelsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int RUNTIME_CONFIG_FIELD_NUMBER = 12;
  private com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig runtimeConfig_;

  /**
   *
   *
   * <pre>
   * Runtime config of the pipeline.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig runtime_config = 12;</code>
   *
   * @return Whether the runtimeConfig field is set.
   */
  @java.lang.Override
  public boolean hasRuntimeConfig() {
    return ((bitField0_ & 0x00000080) != 0);
  }

  /**
   *
   *
   * <pre>
   * Runtime config of the pipeline.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig runtime_config = 12;</code>
   *
   * @return The runtimeConfig.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig getRuntimeConfig() {
    return runtimeConfig_ == null
        ? com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.getDefaultInstance()
        : runtimeConfig_;
  }

  /**
   *
   *
   * <pre>
   * Runtime config of the pipeline.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig runtime_config = 12;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfigOrBuilder
      getRuntimeConfigOrBuilder() {
    return runtimeConfig_ == null
        ? com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.getDefaultInstance()
        : runtimeConfig_;
  }

  public static final int ENCRYPTION_SPEC_FIELD_NUMBER = 16;
  private com.google.cloud.aiplatform.v1beta1.EncryptionSpec encryptionSpec_;

  /**
   *
   *
   * <pre>
   * Customer-managed encryption key spec for a pipelineJob. If set, this
   * PipelineJob and all of its sub-resources will be secured by this key.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.EncryptionSpec encryption_spec = 16;</code>
   *
   * @return Whether the encryptionSpec field is set.
   */
  @java.lang.Override
  public boolean hasEncryptionSpec() {
    return ((bitField0_ & 0x00000100) != 0);
  }

  /**
   *
   *
   * <pre>
   * Customer-managed encryption key spec for a pipelineJob. If set, this
   * PipelineJob and all of its sub-resources will be secured by this key.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.EncryptionSpec encryption_spec = 16;</code>
   *
   * @return The encryptionSpec.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.EncryptionSpec getEncryptionSpec() {
    return encryptionSpec_ == null
        ? com.google.cloud.aiplatform.v1beta1.EncryptionSpec.getDefaultInstance()
        : encryptionSpec_;
  }

  /**
   *
   *
   * <pre>
   * Customer-managed encryption key spec for a pipelineJob. If set, this
   * PipelineJob and all of its sub-resources will be secured by this key.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.EncryptionSpec encryption_spec = 16;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.EncryptionSpecOrBuilder getEncryptionSpecOrBuilder() {
    return encryptionSpec_ == null
        ? com.google.cloud.aiplatform.v1beta1.EncryptionSpec.getDefaultInstance()
        : encryptionSpec_;
  }

  public static final int SERVICE_ACCOUNT_FIELD_NUMBER = 17;

  @SuppressWarnings("serial")
  private volatile java.lang.Object serviceAccount_ = "";

  /**
   *
   *
   * <pre>
   * The service account that the pipeline workload runs as.
   * If not specified, the Compute Engine default service account in the project
   * will be used.
   * See
   * https://cloud.google.com/compute/docs/access/service-accounts#default_service_account
   *
   * Users starting the pipeline must have the `iam.serviceAccounts.actAs`
   * permission on this service account.
   * </pre>
   *
   * <code>string service_account = 17;</code>
   *
   * @return The serviceAccount.
   */
  @java.lang.Override
  public java.lang.String getServiceAccount() {
    java.lang.Object ref = serviceAccount_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      serviceAccount_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * The service account that the pipeline workload runs as.
   * If not specified, the Compute Engine default service account in the project
   * will be used.
   * See
   * https://cloud.google.com/compute/docs/access/service-accounts#default_service_account
   *
   * Users starting the pipeline must have the `iam.serviceAccounts.actAs`
   * permission on this service account.
   * </pre>
   *
   * <code>string service_account = 17;</code>
   *
   * @return The bytes for serviceAccount.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getServiceAccountBytes() {
    java.lang.Object ref = serviceAccount_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      serviceAccount_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int NETWORK_FIELD_NUMBER = 18;

  @SuppressWarnings("serial")
  private volatile java.lang.Object network_ = "";

  /**
   *
   *
   * <pre>
   * The full name of the Compute Engine
   * [network](/compute/docs/networks-and-firewalls#networks) to which the
   * Pipeline Job's workload should be peered. For example,
   * `projects/12345/global/networks/myVPC`.
   * [Format](/compute/docs/reference/rest/v1/networks/insert)
   * is of the form `projects/{project}/global/networks/{network}`.
   * Where {project} is a project number, as in `12345`, and {network} is a
   * network name.
   *
   * Private services access must already be configured for the network.
   * Pipeline job will apply the network configuration to the Google Cloud
   * resources being launched, if applied, such as Vertex AI
   * Training or Dataflow job. If left unspecified, the workload is not peered
   * with any network.
   * </pre>
   *
   * <code>string network = 18 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The network.
   */
  @java.lang.Override
  public java.lang.String getNetwork() {
    java.lang.Object ref = network_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      network_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * The full name of the Compute Engine
   * [network](/compute/docs/networks-and-firewalls#networks) to which the
   * Pipeline Job's workload should be peered. For example,
   * `projects/12345/global/networks/myVPC`.
   * [Format](/compute/docs/reference/rest/v1/networks/insert)
   * is of the form `projects/{project}/global/networks/{network}`.
   * Where {project} is a project number, as in `12345`, and {network} is a
   * network name.
   *
   * Private services access must already be configured for the network.
   * Pipeline job will apply the network configuration to the Google Cloud
   * resources being launched, if applied, such as Vertex AI
   * Training or Dataflow job. If left unspecified, the workload is not peered
   * with any network.
   * </pre>
   *
   * <code>string network = 18 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The bytes for network.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNetworkBytes() {
    java.lang.Object ref = network_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      network_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int RESERVED_IP_RANGES_FIELD_NUMBER = 25;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList reservedIpRanges_ =
      com.google.protobuf.LazyStringArrayList.emptyList();

  /**
   *
   *
   * <pre>
   * A list of names for the reserved ip ranges under the VPC network
   * that can be used for this Pipeline Job's workload.
   *
   * If set, we will deploy the Pipeline Job's workload within the provided ip
   * ranges. Otherwise, the job will be deployed to any ip ranges under the
   * provided VPC network.
   *
   * Example: ['vertex-ai-ip-range'].
   * </pre>
   *
   * <code>repeated string reserved_ip_ranges = 25;</code>
   *
   * @return A list containing the reservedIpRanges.
   */
  public com.google.protobuf.ProtocolStringList getReservedIpRangesList() {
    return reservedIpRanges_;
  }

  /**
   *
   *
   * <pre>
   * A list of names for the reserved ip ranges under the VPC network
   * that can be used for this Pipeline Job's workload.
   *
   * If set, we will deploy the Pipeline Job's workload within the provided ip
   * ranges. Otherwise, the job will be deployed to any ip ranges under the
   * provided VPC network.
   *
   * Example: ['vertex-ai-ip-range'].
   * </pre>
   *
   * <code>repeated string reserved_ip_ranges = 25;</code>
   *
   * @return The count of reservedIpRanges.
   */
  public int getReservedIpRangesCount() {
    return reservedIpRanges_.size();
  }

  /**
   *
   *
   * <pre>
   * A list of names for the reserved ip ranges under the VPC network
   * that can be used for this Pipeline Job's workload.
   *
   * If set, we will deploy the Pipeline Job's workload within the provided ip
   * ranges. Otherwise, the job will be deployed to any ip ranges under the
   * provided VPC network.
   *
   * Example: ['vertex-ai-ip-range'].
   * </pre>
   *
   * <code>repeated string reserved_ip_ranges = 25;</code>
   *
   * @param index The index of the element to return.
   * @return The reservedIpRanges at the given index.
   */
  public java.lang.String getReservedIpRanges(int index) {
    return reservedIpRanges_.get(index);
  }

  /**
   *
   *
   * <pre>
   * A list of names for the reserved ip ranges under the VPC network
   * that can be used for this Pipeline Job's workload.
   *
   * If set, we will deploy the Pipeline Job's workload within the provided ip
   * ranges. Otherwise, the job will be deployed to any ip ranges under the
   * provided VPC network.
   *
   * Example: ['vertex-ai-ip-range'].
   * </pre>
   *
   * <code>repeated string reserved_ip_ranges = 25;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the reservedIpRanges at the given index.
   */
  public com.google.protobuf.ByteString getReservedIpRangesBytes(int index) {
    return reservedIpRanges_.getByteString(index);
  }

  public static final int PSC_INTERFACE_CONFIG_FIELD_NUMBER = 31;
  private com.google.cloud.aiplatform.v1beta1.PscInterfaceConfig pscInterfaceConfig_;

  /**
   *
   *
   * <pre>
   * Optional. Configuration for PSC-I for PipelineJob.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.PscInterfaceConfig psc_interface_config = 31 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the pscInterfaceConfig field is set.
   */
  @java.lang.Override
  public boolean hasPscInterfaceConfig() {
    return ((bitField0_ & 0x00000200) != 0);
  }

  /**
   *
   *
   * <pre>
   * Optional. Configuration for PSC-I for PipelineJob.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.PscInterfaceConfig psc_interface_config = 31 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The pscInterfaceConfig.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.PscInterfaceConfig getPscInterfaceConfig() {
    return pscInterfaceConfig_ == null
        ? com.google.cloud.aiplatform.v1beta1.PscInterfaceConfig.getDefaultInstance()
        : pscInterfaceConfig_;
  }

  /**
   *
   *
   * <pre>
   * Optional. Configuration for PSC-I for PipelineJob.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.PscInterfaceConfig psc_interface_config = 31 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.PscInterfaceConfigOrBuilder
      getPscInterfaceConfigOrBuilder() {
    return pscInterfaceConfig_ == null
        ? com.google.cloud.aiplatform.v1beta1.PscInterfaceConfig.getDefaultInstance()
        : pscInterfaceConfig_;
  }

  public static final int TEMPLATE_URI_FIELD_NUMBER = 19;

  @SuppressWarnings("serial")
  private volatile java.lang.Object templateUri_ = "";

  /**
   *
   *
   * <pre>
   * A template uri from where the
   * [PipelineJob.pipeline_spec][google.cloud.aiplatform.v1beta1.PipelineJob.pipeline_spec],
   * if empty, will be downloaded. Currently, only uri from Vertex Template
   * Registry &amp; Gallery is supported. Reference to
   * https://cloud.google.com/vertex-ai/docs/pipelines/create-pipeline-template.
   * </pre>
   *
   * <code>string template_uri = 19;</code>
   *
   * @return The templateUri.
   */
  @java.lang.Override
  public java.lang.String getTemplateUri() {
    java.lang.Object ref = templateUri_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      templateUri_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * A template uri from where the
   * [PipelineJob.pipeline_spec][google.cloud.aiplatform.v1beta1.PipelineJob.pipeline_spec],
   * if empty, will be downloaded. Currently, only uri from Vertex Template
   * Registry &amp; Gallery is supported. Reference to
   * https://cloud.google.com/vertex-ai/docs/pipelines/create-pipeline-template.
   * </pre>
   *
   * <code>string template_uri = 19;</code>
   *
   * @return The bytes for templateUri.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getTemplateUriBytes() {
    java.lang.Object ref = templateUri_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      templateUri_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TEMPLATE_METADATA_FIELD_NUMBER = 20;
  private com.google.cloud.aiplatform.v1beta1.PipelineTemplateMetadata templateMetadata_;

  /**
   *
   *
   * <pre>
   * Output only. Pipeline template metadata. Will fill up fields if
   * [PipelineJob.template_uri][google.cloud.aiplatform.v1beta1.PipelineJob.template_uri]
   * is from supported template registry.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.PipelineTemplateMetadata template_metadata = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the templateMetadata field is set.
   */
  @java.lang.Override
  public boolean hasTemplateMetadata() {
    return ((bitField0_ & 0x00000400) != 0);
  }

  /**
   *
   *
   * <pre>
   * Output only. Pipeline template metadata. Will fill up fields if
   * [PipelineJob.template_uri][google.cloud.aiplatform.v1beta1.PipelineJob.template_uri]
   * is from supported template registry.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.PipelineTemplateMetadata template_metadata = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The templateMetadata.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.PipelineTemplateMetadata getTemplateMetadata() {
    return templateMetadata_ == null
        ? com.google.cloud.aiplatform.v1beta1.PipelineTemplateMetadata.getDefaultInstance()
        : templateMetadata_;
  }

  /**
   *
   *
   * <pre>
   * Output only. Pipeline template metadata. Will fill up fields if
   * [PipelineJob.template_uri][google.cloud.aiplatform.v1beta1.PipelineJob.template_uri]
   * is from supported template registry.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.PipelineTemplateMetadata template_metadata = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.PipelineTemplateMetadataOrBuilder
      getTemplateMetadataOrBuilder() {
    return templateMetadata_ == null
        ? com.google.cloud.aiplatform.v1beta1.PipelineTemplateMetadata.getDefaultInstance()
        : templateMetadata_;
  }

  public static final int SCHEDULE_NAME_FIELD_NUMBER = 22;

  @SuppressWarnings("serial")
  private volatile java.lang.Object scheduleName_ = "";

  /**
   *
   *
   * <pre>
   * Output only. The schedule resource name.
   * Only returned if the Pipeline is created by Schedule API.
   * </pre>
   *
   * <code>string schedule_name = 22 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The scheduleName.
   */
  @java.lang.Override
  public java.lang.String getScheduleName() {
    java.lang.Object ref = scheduleName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      scheduleName_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Output only. The schedule resource name.
   * Only returned if the Pipeline is created by Schedule API.
   * </pre>
   *
   * <code>string schedule_name = 22 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for scheduleName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getScheduleNameBytes() {
    java.lang.Object ref = scheduleName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      scheduleName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PREFLIGHT_VALIDATIONS_FIELD_NUMBER = 26;
  private boolean preflightValidations_ = false;

  /**
   *
   *
   * <pre>
   * Optional. Whether to do component level validations before job creation.
   * </pre>
   *
   * <code>bool preflight_validations = 26 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The preflightValidations.
   */
  @java.lang.Override
  public boolean getPreflightValidations() {
    return preflightValidations_;
  }

  public static final int SATISFIES_PZS_FIELD_NUMBER = 27;
  private boolean satisfiesPzs_ = false;

  /**
   *
   *
   * <pre>
   * Output only. Reserved for future use.
   * </pre>
   *
   * <code>bool satisfies_pzs = 27 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The satisfiesPzs.
   */
  @java.lang.Override
  public boolean getSatisfiesPzs() {
    return satisfiesPzs_;
  }

  public static final int SATISFIES_PZI_FIELD_NUMBER = 28;
  private boolean satisfiesPzi_ = false;

  /**
   *
   *
   * <pre>
   * Output only. Reserved for future use.
   * </pre>
   *
   * <code>bool satisfies_pzi = 28 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The satisfiesPzi.
   */
  @java.lang.Override
  public boolean getSatisfiesPzi() {
    return satisfiesPzi_;
  }

  public static final int ORIGINAL_PIPELINE_JOB_ID_FIELD_NUMBER = 29;
  private long originalPipelineJobId_ = 0L;

  /**
   *
   *
   * <pre>
   * Optional. The original pipeline job id if this pipeline job is a rerun of a
   * previous pipeline job.
   * </pre>
   *
   * <code>int64 original_pipeline_job_id = 29 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The originalPipelineJobId.
   */
  @java.lang.Override
  public long getOriginalPipelineJobId() {
    return originalPipelineJobId_;
  }

  public static final int PIPELINE_TASK_RERUN_CONFIGS_FIELD_NUMBER = 30;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig>
      pipelineTaskRerunConfigs_;

  /**
   *
   *
   * <pre>
   * Optional. The rerun configs for each task in the pipeline job.
   * By default, the rerun will:
   * 1. Use the same input artifacts as the original run.
   * 2. Use the same input parameters as the original run.
   * 3. Skip all the tasks that are already succeeded in the original run.
   * 4. Rerun all the tasks that are not succeeded in the original run.
   * By providing this field, users can override the default behavior and
   * specify the rerun config for each task.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig pipeline_task_rerun_configs = 30 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig>
      getPipelineTaskRerunConfigsList() {
    return pipelineTaskRerunConfigs_;
  }

  /**
   *
   *
   * <pre>
   * Optional. The rerun configs for each task in the pipeline job.
   * By default, the rerun will:
   * 1. Use the same input artifacts as the original run.
   * 2. Use the same input parameters as the original run.
   * 3. Skip all the tasks that are already succeeded in the original run.
   * 4. Rerun all the tasks that are not succeeded in the original run.
   * By providing this field, users can override the default behavior and
   * specify the rerun config for each task.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig pipeline_task_rerun_configs = 30 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfigOrBuilder>
      getPipelineTaskRerunConfigsOrBuilderList() {
    return pipelineTaskRerunConfigs_;
  }

  /**
   *
   *
   * <pre>
   * Optional. The rerun configs for each task in the pipeline job.
   * By default, the rerun will:
   * 1. Use the same input artifacts as the original run.
   * 2. Use the same input parameters as the original run.
   * 3. Skip all the tasks that are already succeeded in the original run.
   * 4. Rerun all the tasks that are not succeeded in the original run.
   * By providing this field, users can override the default behavior and
   * specify the rerun config for each task.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig pipeline_task_rerun_configs = 30 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public int getPipelineTaskRerunConfigsCount() {
    return pipelineTaskRerunConfigs_.size();
  }

  /**
   *
   *
   * <pre>
   * Optional. The rerun configs for each task in the pipeline job.
   * By default, the rerun will:
   * 1. Use the same input artifacts as the original run.
   * 2. Use the same input parameters as the original run.
   * 3. Skip all the tasks that are already succeeded in the original run.
   * 4. Rerun all the tasks that are not succeeded in the original run.
   * By providing this field, users can override the default behavior and
   * specify the rerun config for each task.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig pipeline_task_rerun_configs = 30 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig getPipelineTaskRerunConfigs(
      int index) {
    return pipelineTaskRerunConfigs_.get(index);
  }

  /**
   *
   *
   * <pre>
   * Optional. The rerun configs for each task in the pipeline job.
   * By default, the rerun will:
   * 1. Use the same input artifacts as the original run.
   * 2. Use the same input parameters as the original run.
   * 3. Skip all the tasks that are already succeeded in the original run.
   * 4. Rerun all the tasks that are not succeeded in the original run.
   * By providing this field, users can override the default behavior and
   * specify the rerun config for each task.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig pipeline_task_rerun_configs = 30 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfigOrBuilder
      getPipelineTaskRerunConfigsOrBuilder(int index) {
    return pipelineTaskRerunConfigs_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, displayName_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(3, getCreateTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(4, getStartTime());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(5, getEndTime());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeMessage(6, getUpdateTime());
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      output.writeMessage(7, getPipelineSpec());
    }
    if (state_
        != com.google.cloud.aiplatform.v1beta1.PipelineState.PIPELINE_STATE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(8, state_);
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      output.writeMessage(9, getJobDetail());
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      output.writeMessage(10, getError());
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetLabels(), LabelsDefaultEntryHolder.defaultEntry, 11);
    if (((bitField0_ & 0x00000080) != 0)) {
      output.writeMessage(12, getRuntimeConfig());
    }
    if (((bitField0_ & 0x00000100) != 0)) {
      output.writeMessage(16, getEncryptionSpec());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(serviceAccount_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 17, serviceAccount_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(network_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 18, network_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(templateUri_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 19, templateUri_);
    }
    if (((bitField0_ & 0x00000400) != 0)) {
      output.writeMessage(20, getTemplateMetadata());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(scheduleName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 22, scheduleName_);
    }
    for (int i = 0; i < reservedIpRanges_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 25, reservedIpRanges_.getRaw(i));
    }
    if (preflightValidations_ != false) {
      output.writeBool(26, preflightValidations_);
    }
    if (satisfiesPzs_ != false) {
      output.writeBool(27, satisfiesPzs_);
    }
    if (satisfiesPzi_ != false) {
      output.writeBool(28, satisfiesPzi_);
    }
    if (originalPipelineJobId_ != 0L) {
      output.writeInt64(29, originalPipelineJobId_);
    }
    for (int i = 0; i < pipelineTaskRerunConfigs_.size(); i++) {
      output.writeMessage(30, pipelineTaskRerunConfigs_.get(i));
    }
    if (((bitField0_ & 0x00000200) != 0)) {
      output.writeMessage(31, getPscInterfaceConfig());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, displayName_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getCreateTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getStartTime());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getEndTime());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getUpdateTime());
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getPipelineSpec());
    }
    if (state_
        != com.google.cloud.aiplatform.v1beta1.PipelineState.PIPELINE_STATE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(8, state_);
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(9, getJobDetail());
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(10, getError());
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetLabels().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
          LabelsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(11, labels__);
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(12, getRuntimeConfig());
    }
    if (((bitField0_ & 0x00000100) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(16, getEncryptionSpec());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(serviceAccount_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(17, serviceAccount_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(network_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(18, network_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(templateUri_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(19, templateUri_);
    }
    if (((bitField0_ & 0x00000400) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(20, getTemplateMetadata());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(scheduleName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(22, scheduleName_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < reservedIpRanges_.size(); i++) {
        dataSize += computeStringSizeNoTag(reservedIpRanges_.getRaw(i));
      }
      size += dataSize;
      size += 2 * getReservedIpRangesList().size();
    }
    if (preflightValidations_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(26, preflightValidations_);
    }
    if (satisfiesPzs_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(27, satisfiesPzs_);
    }
    if (satisfiesPzi_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(28, satisfiesPzi_);
    }
    if (originalPipelineJobId_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(29, originalPipelineJobId_);
    }
    for (int i = 0; i < pipelineTaskRerunConfigs_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              30, pipelineTaskRerunConfigs_.get(i));
    }
    if (((bitField0_ & 0x00000200) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(31, getPscInterfaceConfig());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.PipelineJob)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1beta1.PipelineJob other =
        (com.google.cloud.aiplatform.v1beta1.PipelineJob) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getDisplayName().equals(other.getDisplayName())) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasStartTime() != other.hasStartTime()) return false;
    if (hasStartTime()) {
      if (!getStartTime().equals(other.getStartTime())) return false;
    }
    if (hasEndTime() != other.hasEndTime()) return false;
    if (hasEndTime()) {
      if (!getEndTime().equals(other.getEndTime())) return false;
    }
    if (hasUpdateTime() != other.hasUpdateTime()) return false;
    if (hasUpdateTime()) {
      if (!getUpdateTime().equals(other.getUpdateTime())) return false;
    }
    if (hasPipelineSpec() != other.hasPipelineSpec()) return false;
    if (hasPipelineSpec()) {
      if (!getPipelineSpec().equals(other.getPipelineSpec())) return false;
    }
    if (state_ != other.state_) return false;
    if (hasJobDetail() != other.hasJobDetail()) return false;
    if (hasJobDetail()) {
      if (!getJobDetail().equals(other.getJobDetail())) return false;
    }
    if (hasError() != other.hasError()) return false;
    if (hasError()) {
      if (!getError().equals(other.getError())) return false;
    }
    if (!internalGetLabels().equals(other.internalGetLabels())) return false;
    if (hasRuntimeConfig() != other.hasRuntimeConfig()) return false;
    if (hasRuntimeConfig()) {
      if (!getRuntimeConfig().equals(other.getRuntimeConfig())) return false;
    }
    if (hasEncryptionSpec() != other.hasEncryptionSpec()) return false;
    if (hasEncryptionSpec()) {
      if (!getEncryptionSpec().equals(other.getEncryptionSpec())) return false;
    }
    if (!getServiceAccount().equals(other.getServiceAccount())) return false;
    if (!getNetwork().equals(other.getNetwork())) return false;
    if (!getReservedIpRangesList().equals(other.getReservedIpRangesList())) return false;
    if (hasPscInterfaceConfig() != other.hasPscInterfaceConfig()) return false;
    if (hasPscInterfaceConfig()) {
      if (!getPscInterfaceConfig().equals(other.getPscInterfaceConfig())) return false;
    }
    if (!getTemplateUri().equals(other.getTemplateUri())) return false;
    if (hasTemplateMetadata() != other.hasTemplateMetadata()) return false;
    if (hasTemplateMetadata()) {
      if (!getTemplateMetadata().equals(other.getTemplateMetadata())) return false;
    }
    if (!getScheduleName().equals(other.getScheduleName())) return false;
    if (getPreflightValidations() != other.getPreflightValidations()) return false;
    if (getSatisfiesPzs() != other.getSatisfiesPzs()) return false;
    if (getSatisfiesPzi() != other.getSatisfiesPzi()) return false;
    if (getOriginalPipelineJobId() != other.getOriginalPipelineJobId()) return false;
    if (!getPipelineTaskRerunConfigsList().equals(other.getPipelineTaskRerunConfigsList()))
      return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDisplayName().hashCode();
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasStartTime()) {
      hash = (37 * hash) + START_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getStartTime().hashCode();
    }
    if (hasEndTime()) {
      hash = (37 * hash) + END_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getEndTime().hashCode();
    }
    if (hasUpdateTime()) {
      hash = (37 * hash) + UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateTime().hashCode();
    }
    if (hasPipelineSpec()) {
      hash = (37 * hash) + PIPELINE_SPEC_FIELD_NUMBER;
      hash = (53 * hash) + getPipelineSpec().hashCode();
    }
    hash = (37 * hash) + STATE_FIELD_NUMBER;
    hash = (53 * hash) + state_;
    if (hasJobDetail()) {
      hash = (37 * hash) + JOB_DETAIL_FIELD_NUMBER;
      hash = (53 * hash) + getJobDetail().hashCode();
    }
    if (hasError()) {
      hash = (37 * hash) + ERROR_FIELD_NUMBER;
      hash = (53 * hash) + getError().hashCode();
    }
    if (!internalGetLabels().getMap().isEmpty()) {
      hash = (37 * hash) + LABELS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetLabels().hashCode();
    }
    if (hasRuntimeConfig()) {
      hash = (37 * hash) + RUNTIME_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getRuntimeConfig().hashCode();
    }
    if (hasEncryptionSpec()) {
      hash = (37 * hash) + ENCRYPTION_SPEC_FIELD_NUMBER;
      hash = (53 * hash) + getEncryptionSpec().hashCode();
    }
    hash = (37 * hash) + SERVICE_ACCOUNT_FIELD_NUMBER;
    hash = (53 * hash) + getServiceAccount().hashCode();
    hash = (37 * hash) + NETWORK_FIELD_NUMBER;
    hash = (53 * hash) + getNetwork().hashCode();
    if (getReservedIpRangesCount() > 0) {
      hash = (37 * hash) + RESERVED_IP_RANGES_FIELD_NUMBER;
      hash = (53 * hash) + getReservedIpRangesList().hashCode();
    }
    if (hasPscInterfaceConfig()) {
      hash = (37 * hash) + PSC_INTERFACE_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getPscInterfaceConfig().hashCode();
    }
    hash = (37 * hash) + TEMPLATE_URI_FIELD_NUMBER;
    hash = (53 * hash) + getTemplateUri().hashCode();
    if (hasTemplateMetadata()) {
      hash = (37 * hash) + TEMPLATE_METADATA_FIELD_NUMBER;
      hash = (53 * hash) + getTemplateMetadata().hashCode();
    }
    hash = (37 * hash) + SCHEDULE_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getScheduleName().hashCode();
    hash = (37 * hash) + PREFLIGHT_VALIDATIONS_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getPreflightValidations());
    hash = (37 * hash) + SATISFIES_PZS_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getSatisfiesPzs());
    hash = (37 * hash) + SATISFIES_PZI_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getSatisfiesPzi());
    hash = (37 * hash) + ORIGINAL_PIPELINE_JOB_ID_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getOriginalPipelineJobId());
    if (getPipelineTaskRerunConfigsCount() > 0) {
      hash = (37 * hash) + PIPELINE_TASK_RERUN_CONFIGS_FIELD_NUMBER;
      hash = (53 * hash) + getPipelineTaskRerunConfigsList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1beta1.PipelineJob parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.PipelineJob parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.PipelineJob parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.PipelineJob parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.PipelineJob parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.PipelineJob parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.PipelineJob parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.PipelineJob parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.PipelineJob parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.PipelineJob parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.PipelineJob parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.PipelineJob parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.aiplatform.v1beta1.PipelineJob prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * An instance of a machine learning PipelineJob.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.PipelineJob}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.PipelineJob)
      com.google.cloud.aiplatform.v1beta1.PipelineJobOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.Pipeline
          .internal_static_google_cloud_aiplatform_v1beta1_PipelineJob_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 11:
          return internalGetLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
        int number) {
      switch (number) {
        case 11:
          return internalGetMutableLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.Pipeline
          .internal_static_google_cloud_aiplatform_v1beta1_PipelineJob_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.PipelineJob.class,
              com.google.cloud.aiplatform.v1beta1.PipelineJob.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1beta1.PipelineJob.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getCreateTimeFieldBuilder();
        getStartTimeFieldBuilder();
        getEndTimeFieldBuilder();
        getUpdateTimeFieldBuilder();
        getPipelineSpecFieldBuilder();
        getJobDetailFieldBuilder();
        getErrorFieldBuilder();
        getRuntimeConfigFieldBuilder();
        getEncryptionSpecFieldBuilder();
        getPscInterfaceConfigFieldBuilder();
        getTemplateMetadataFieldBuilder();
        getPipelineTaskRerunConfigsFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      displayName_ = "";
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      startTime_ = null;
      if (startTimeBuilder_ != null) {
        startTimeBuilder_.dispose();
        startTimeBuilder_ = null;
      }
      endTime_ = null;
      if (endTimeBuilder_ != null) {
        endTimeBuilder_.dispose();
        endTimeBuilder_ = null;
      }
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      pipelineSpec_ = null;
      if (pipelineSpecBuilder_ != null) {
        pipelineSpecBuilder_.dispose();
        pipelineSpecBuilder_ = null;
      }
      state_ = 0;
      jobDetail_ = null;
      if (jobDetailBuilder_ != null) {
        jobDetailBuilder_.dispose();
        jobDetailBuilder_ = null;
      }
      error_ = null;
      if (errorBuilder_ != null) {
        errorBuilder_.dispose();
        errorBuilder_ = null;
      }
      internalGetMutableLabels().clear();
      runtimeConfig_ = null;
      if (runtimeConfigBuilder_ != null) {
        runtimeConfigBuilder_.dispose();
        runtimeConfigBuilder_ = null;
      }
      encryptionSpec_ = null;
      if (encryptionSpecBuilder_ != null) {
        encryptionSpecBuilder_.dispose();
        encryptionSpecBuilder_ = null;
      }
      serviceAccount_ = "";
      network_ = "";
      reservedIpRanges_ = com.google.protobuf.LazyStringArrayList.emptyList();
      pscInterfaceConfig_ = null;
      if (pscInterfaceConfigBuilder_ != null) {
        pscInterfaceConfigBuilder_.dispose();
        pscInterfaceConfigBuilder_ = null;
      }
      templateUri_ = "";
      templateMetadata_ = null;
      if (templateMetadataBuilder_ != null) {
        templateMetadataBuilder_.dispose();
        templateMetadataBuilder_ = null;
      }
      scheduleName_ = "";
      preflightValidations_ = false;
      satisfiesPzs_ = false;
      satisfiesPzi_ = false;
      originalPipelineJobId_ = 0L;
      if (pipelineTaskRerunConfigsBuilder_ == null) {
        pipelineTaskRerunConfigs_ = java.util.Collections.emptyList();
      } else {
        pipelineTaskRerunConfigs_ = null;
        pipelineTaskRerunConfigsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x01000000);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1beta1.Pipeline
          .internal_static_google_cloud_aiplatform_v1beta1_PipelineJob_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.PipelineJob getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1beta1.PipelineJob.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.PipelineJob build() {
      com.google.cloud.aiplatform.v1beta1.PipelineJob result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.PipelineJob buildPartial() {
      com.google.cloud.aiplatform.v1beta1.PipelineJob result =
          new com.google.cloud.aiplatform.v1beta1.PipelineJob(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.aiplatform.v1beta1.PipelineJob result) {
      if (pipelineTaskRerunConfigsBuilder_ == null) {
        if (((bitField0_ & 0x01000000) != 0)) {
          pipelineTaskRerunConfigs_ =
              java.util.Collections.unmodifiableList(pipelineTaskRerunConfigs_);
          bitField0_ = (bitField0_ & ~0x01000000);
        }
        result.pipelineTaskRerunConfigs_ = pipelineTaskRerunConfigs_;
      } else {
        result.pipelineTaskRerunConfigs_ = pipelineTaskRerunConfigsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.aiplatform.v1beta1.PipelineJob result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.displayName_ = displayName_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.startTime_ = startTimeBuilder_ == null ? startTime_ : startTimeBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.endTime_ = endTimeBuilder_ == null ? endTime_ : endTimeBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.updateTime_ = updateTimeBuilder_ == null ? updateTime_ : updateTimeBuilder_.build();
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.pipelineSpec_ =
            pipelineSpecBuilder_ == null ? pipelineSpec_ : pipelineSpecBuilder_.build();
        to_bitField0_ |= 0x00000010;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.state_ = state_;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.jobDetail_ = jobDetailBuilder_ == null ? jobDetail_ : jobDetailBuilder_.build();
        to_bitField0_ |= 0x00000020;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.error_ = errorBuilder_ == null ? error_ : errorBuilder_.build();
        to_bitField0_ |= 0x00000040;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.labels_ = internalGetLabels();
        result.labels_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.runtimeConfig_ =
            runtimeConfigBuilder_ == null ? runtimeConfig_ : runtimeConfigBuilder_.build();
        to_bitField0_ |= 0x00000080;
      }
      if (((from_bitField0_ & 0x00001000) != 0)) {
        result.encryptionSpec_ =
            encryptionSpecBuilder_ == null ? encryptionSpec_ : encryptionSpecBuilder_.build();
        to_bitField0_ |= 0x00000100;
      }
      if (((from_bitField0_ & 0x00002000) != 0)) {
        result.serviceAccount_ = serviceAccount_;
      }
      if (((from_bitField0_ & 0x00004000) != 0)) {
        result.network_ = network_;
      }
      if (((from_bitField0_ & 0x00008000) != 0)) {
        reservedIpRanges_.makeImmutable();
        result.reservedIpRanges_ = reservedIpRanges_;
      }
      if (((from_bitField0_ & 0x00010000) != 0)) {
        result.pscInterfaceConfig_ =
            pscInterfaceConfigBuilder_ == null
                ? pscInterfaceConfig_
                : pscInterfaceConfigBuilder_.build();
        to_bitField0_ |= 0x00000200;
      }
      if (((from_bitField0_ & 0x00020000) != 0)) {
        result.templateUri_ = templateUri_;
      }
      if (((from_bitField0_ & 0x00040000) != 0)) {
        result.templateMetadata_ =
            templateMetadataBuilder_ == null ? templateMetadata_ : templateMetadataBuilder_.build();
        to_bitField0_ |= 0x00000400;
      }
      if (((from_bitField0_ & 0x00080000) != 0)) {
        result.scheduleName_ = scheduleName_;
      }
      if (((from_bitField0_ & 0x00100000) != 0)) {
        result.preflightValidations_ = preflightValidations_;
      }
      if (((from_bitField0_ & 0x00200000) != 0)) {
        result.satisfiesPzs_ = satisfiesPzs_;
      }
      if (((from_bitField0_ & 0x00400000) != 0)) {
        result.satisfiesPzi_ = satisfiesPzi_;
      }
      if (((from_bitField0_ & 0x00800000) != 0)) {
        result.originalPipelineJobId_ = originalPipelineJobId_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1beta1.PipelineJob) {
        return mergeFrom((com.google.cloud.aiplatform.v1beta1.PipelineJob) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1beta1.PipelineJob other) {
      if (other == com.google.cloud.aiplatform.v1beta1.PipelineJob.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getDisplayName().isEmpty()) {
        displayName_ = other.displayName_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasStartTime()) {
        mergeStartTime(other.getStartTime());
      }
      if (other.hasEndTime()) {
        mergeEndTime(other.getEndTime());
      }
      if (other.hasUpdateTime()) {
        mergeUpdateTime(other.getUpdateTime());
      }
      if (other.hasPipelineSpec()) {
        mergePipelineSpec(other.getPipelineSpec());
      }
      if (other.state_ != 0) {
        setStateValue(other.getStateValue());
      }
      if (other.hasJobDetail()) {
        mergeJobDetail(other.getJobDetail());
      }
      if (other.hasError()) {
        mergeError(other.getError());
      }
      internalGetMutableLabels().mergeFrom(other.internalGetLabels());
      bitField0_ |= 0x00000400;
      if (other.hasRuntimeConfig()) {
        mergeRuntimeConfig(other.getRuntimeConfig());
      }
      if (other.hasEncryptionSpec()) {
        mergeEncryptionSpec(other.getEncryptionSpec());
      }
      if (!other.getServiceAccount().isEmpty()) {
        serviceAccount_ = other.serviceAccount_;
        bitField0_ |= 0x00002000;
        onChanged();
      }
      if (!other.getNetwork().isEmpty()) {
        network_ = other.network_;
        bitField0_ |= 0x00004000;
        onChanged();
      }
      if (!other.reservedIpRanges_.isEmpty()) {
        if (reservedIpRanges_.isEmpty()) {
          reservedIpRanges_ = other.reservedIpRanges_;
          bitField0_ |= 0x00008000;
        } else {
          ensureReservedIpRangesIsMutable();
          reservedIpRanges_.addAll(other.reservedIpRanges_);
        }
        onChanged();
      }
      if (other.hasPscInterfaceConfig()) {
        mergePscInterfaceConfig(other.getPscInterfaceConfig());
      }
      if (!other.getTemplateUri().isEmpty()) {
        templateUri_ = other.templateUri_;
        bitField0_ |= 0x00020000;
        onChanged();
      }
      if (other.hasTemplateMetadata()) {
        mergeTemplateMetadata(other.getTemplateMetadata());
      }
      if (!other.getScheduleName().isEmpty()) {
        scheduleName_ = other.scheduleName_;
        bitField0_ |= 0x00080000;
        onChanged();
      }
      if (other.getPreflightValidations() != false) {
        setPreflightValidations(other.getPreflightValidations());
      }
      if (other.getSatisfiesPzs() != false) {
        setSatisfiesPzs(other.getSatisfiesPzs());
      }
      if (other.getSatisfiesPzi() != false) {
        setSatisfiesPzi(other.getSatisfiesPzi());
      }
      if (other.getOriginalPipelineJobId() != 0L) {
        setOriginalPipelineJobId(other.getOriginalPipelineJobId());
      }
      if (pipelineTaskRerunConfigsBuilder_ == null) {
        if (!other.pipelineTaskRerunConfigs_.isEmpty()) {
          if (pipelineTaskRerunConfigs_.isEmpty()) {
            pipelineTaskRerunConfigs_ = other.pipelineTaskRerunConfigs_;
            bitField0_ = (bitField0_ & ~0x01000000);
          } else {
            ensurePipelineTaskRerunConfigsIsMutable();
            pipelineTaskRerunConfigs_.addAll(other.pipelineTaskRerunConfigs_);
          }
          onChanged();
        }
      } else {
        if (!other.pipelineTaskRerunConfigs_.isEmpty()) {
          if (pipelineTaskRerunConfigsBuilder_.isEmpty()) {
            pipelineTaskRerunConfigsBuilder_.dispose();
            pipelineTaskRerunConfigsBuilder_ = null;
            pipelineTaskRerunConfigs_ = other.pipelineTaskRerunConfigs_;
            bitField0_ = (bitField0_ & ~0x01000000);
            pipelineTaskRerunConfigsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getPipelineTaskRerunConfigsFieldBuilder()
                    : null;
          } else {
            pipelineTaskRerunConfigsBuilder_.addAllMessages(other.pipelineTaskRerunConfigs_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                displayName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getStartTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(getEndTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 50:
              {
                input.readMessage(getUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000020;
                break;
              } // case 50
            case 58:
              {
                input.readMessage(getPipelineSpecFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000040;
                break;
              } // case 58
            case 64:
              {
                state_ = input.readEnum();
                bitField0_ |= 0x00000080;
                break;
              } // case 64
            case 74:
              {
                input.readMessage(getJobDetailFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000100;
                break;
              } // case 74
            case 82:
              {
                input.readMessage(getErrorFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000200;
                break;
              } // case 82
            case 90:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
                    input.readMessage(
                        LabelsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableLabels()
                    .getMutableMap()
                    .put(labels__.getKey(), labels__.getValue());
                bitField0_ |= 0x00000400;
                break;
              } // case 90
            case 98:
              {
                input.readMessage(getRuntimeConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000800;
                break;
              } // case 98
            case 130:
              {
                input.readMessage(getEncryptionSpecFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00001000;
                break;
              } // case 130
            case 138:
              {
                serviceAccount_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00002000;
                break;
              } // case 138
            case 146:
              {
                network_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00004000;
                break;
              } // case 146
            case 154:
              {
                templateUri_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00020000;
                break;
              } // case 154
            case 162:
              {
                input.readMessage(
                    getTemplateMetadataFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00040000;
                break;
              } // case 162
            case 178:
              {
                scheduleName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00080000;
                break;
              } // case 178
            case 202:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureReservedIpRangesIsMutable();
                reservedIpRanges_.add(s);
                break;
              } // case 202
            case 208:
              {
                preflightValidations_ = input.readBool();
                bitField0_ |= 0x00100000;
                break;
              } // case 208
            case 216:
              {
                satisfiesPzs_ = input.readBool();
                bitField0_ |= 0x00200000;
                break;
              } // case 216
            case 224:
              {
                satisfiesPzi_ = input.readBool();
                bitField0_ |= 0x00400000;
                break;
              } // case 224
            case 232:
              {
                originalPipelineJobId_ = input.readInt64();
                bitField0_ |= 0x00800000;
                break;
              } // case 232
            case 242:
              {
                com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig m =
                    input.readMessage(
                        com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.parser(),
                        extensionRegistry);
                if (pipelineTaskRerunConfigsBuilder_ == null) {
                  ensurePipelineTaskRerunConfigsIsMutable();
                  pipelineTaskRerunConfigs_.add(m);
                } else {
                  pipelineTaskRerunConfigsBuilder_.addMessage(m);
                }
                break;
              } // case 242
            case 250:
              {
                input.readMessage(
                    getPscInterfaceConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00010000;
                break;
              } // case 250
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";

    /**
     *
     *
     * <pre>
     * Output only. The resource name of the PipelineJob.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The resource name of the PipelineJob.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The resource name of the PipelineJob.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The resource name of the PipelineJob.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The resource name of the PipelineJob.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object displayName_ = "";

    /**
     *
     *
     * <pre>
     * The display name of the Pipeline.
     * The name can be up to 128 characters long and can consist of any UTF-8
     * characters.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @return The displayName.
     */
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The display name of the Pipeline.
     * The name can be up to 128 characters long and can consist of any UTF-8
     * characters.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @return The bytes for displayName.
     */
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The display name of the Pipeline.
     * The name can be up to 128 characters long and can consist of any UTF-8
     * characters.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @param value The displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      displayName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The display name of the Pipeline.
     * The name can be up to 128 characters long and can consist of any UTF-8
     * characters.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisplayName() {
      displayName_ = getDefaultInstance().getDisplayName();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The display name of the Pipeline.
     * The name can be up to 128 characters long and can consist of any UTF-8
     * characters.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @param value The bytes for displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      displayName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. Pipeline creation time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000004) != 0);
    }

    /**
     *
     *
     * <pre>
     * Output only. Pipeline creation time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Pipeline creation time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Pipeline creation time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Pipeline creation time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      if (createTime_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Pipeline creation time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000004);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Pipeline creation time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Output only. Pipeline creation time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Pipeline creation time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.Timestamp startTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        startTimeBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. Pipeline start time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the startTime field is set.
     */
    public boolean hasStartTime() {
      return ((bitField0_ & 0x00000008) != 0);
    }

    /**
     *
     *
     * <pre>
     * Output only. Pipeline start time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The startTime.
     */
    public com.google.protobuf.Timestamp getStartTime() {
      if (startTimeBuilder_ == null) {
        return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
      } else {
        return startTimeBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Pipeline start time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setStartTime(com.google.protobuf.Timestamp value) {
      if (startTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        startTime_ = value;
      } else {
        startTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Pipeline start time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setStartTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (startTimeBuilder_ == null) {
        startTime_ = builderForValue.build();
      } else {
        startTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Pipeline start time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeStartTime(com.google.protobuf.Timestamp value) {
      if (startTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && startTime_ != null
            && startTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getStartTimeBuilder().mergeFrom(value);
        } else {
          startTime_ = value;
        }
      } else {
        startTimeBuilder_.mergeFrom(value);
      }
      if (startTime_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Pipeline start time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearStartTime() {
      bitField0_ = (bitField0_ & ~0x00000008);
      startTime_ = null;
      if (startTimeBuilder_ != null) {
        startTimeBuilder_.dispose();
        startTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Pipeline start time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getStartTimeBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getStartTimeFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Output only. Pipeline start time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getStartTimeOrBuilder() {
      if (startTimeBuilder_ != null) {
        return startTimeBuilder_.getMessageOrBuilder();
      } else {
        return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Pipeline start time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getStartTimeFieldBuilder() {
      if (startTimeBuilder_ == null) {
        startTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getStartTime(), getParentForChildren(), isClean());
        startTime_ = null;
      }
      return startTimeBuilder_;
    }

    private com.google.protobuf.Timestamp endTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        endTimeBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. Pipeline end time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the endTime field is set.
     */
    public boolean hasEndTime() {
      return ((bitField0_ & 0x00000010) != 0);
    }

    /**
     *
     *
     * <pre>
     * Output only. Pipeline end time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The endTime.
     */
    public com.google.protobuf.Timestamp getEndTime() {
      if (endTimeBuilder_ == null) {
        return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
      } else {
        return endTimeBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Pipeline end time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setEndTime(com.google.protobuf.Timestamp value) {
      if (endTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        endTime_ = value;
      } else {
        endTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Pipeline end time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setEndTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (endTimeBuilder_ == null) {
        endTime_ = builderForValue.build();
      } else {
        endTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Pipeline end time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeEndTime(com.google.protobuf.Timestamp value) {
      if (endTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && endTime_ != null
            && endTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getEndTimeBuilder().mergeFrom(value);
        } else {
          endTime_ = value;
        }
      } else {
        endTimeBuilder_.mergeFrom(value);
      }
      if (endTime_ != null) {
        bitField0_ |= 0x00000010;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Pipeline end time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearEndTime() {
      bitField0_ = (bitField0_ & ~0x00000010);
      endTime_ = null;
      if (endTimeBuilder_ != null) {
        endTimeBuilder_.dispose();
        endTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Pipeline end time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getEndTimeBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getEndTimeFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Output only. Pipeline end time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getEndTimeOrBuilder() {
      if (endTimeBuilder_ != null) {
        return endTimeBuilder_.getMessageOrBuilder();
      } else {
        return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Pipeline end time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getEndTimeFieldBuilder() {
      if (endTimeBuilder_ == null) {
        endTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getEndTime(), getParentForChildren(), isClean());
        endTime_ = null;
      }
      return endTimeBuilder_;
    }

    private com.google.protobuf.Timestamp updateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        updateTimeBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this PipelineJob was most recently updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the updateTime field is set.
     */
    public boolean hasUpdateTime() {
      return ((bitField0_ & 0x00000020) != 0);
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this PipelineJob was most recently updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The updateTime.
     */
    public com.google.protobuf.Timestamp getUpdateTime() {
      if (updateTimeBuilder_ == null) {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      } else {
        return updateTimeBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this PipelineJob was most recently updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateTime_ = value;
      } else {
        updateTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this PipelineJob was most recently updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (updateTimeBuilder_ == null) {
        updateTime_ = builderForValue.build();
      } else {
        updateTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this PipelineJob was most recently updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)
            && updateTime_ != null
            && updateTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getUpdateTimeBuilder().mergeFrom(value);
        } else {
          updateTime_ = value;
        }
      } else {
        updateTimeBuilder_.mergeFrom(value);
      }
      if (updateTime_ != null) {
        bitField0_ |= 0x00000020;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this PipelineJob was most recently updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearUpdateTime() {
      bitField0_ = (bitField0_ & ~0x00000020);
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this PipelineJob was most recently updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getUpdateTimeBuilder() {
      bitField0_ |= 0x00000020;
      onChanged();
      return getUpdateTimeFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this PipelineJob was most recently updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
      if (updateTimeBuilder_ != null) {
        return updateTimeBuilder_.getMessageOrBuilder();
      } else {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this PipelineJob was most recently updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getUpdateTimeFieldBuilder() {
      if (updateTimeBuilder_ == null) {
        updateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getUpdateTime(), getParentForChildren(), isClean());
        updateTime_ = null;
      }
      return updateTimeBuilder_;
    }

    private com.google.protobuf.Struct pipelineSpec_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Struct,
            com.google.protobuf.Struct.Builder,
            com.google.protobuf.StructOrBuilder>
        pipelineSpecBuilder_;

    /**
     *
     *
     * <pre>
     * The spec of the pipeline.
     * </pre>
     *
     * <code>.google.protobuf.Struct pipeline_spec = 7;</code>
     *
     * @return Whether the pipelineSpec field is set.
     */
    public boolean hasPipelineSpec() {
      return ((bitField0_ & 0x00000040) != 0);
    }

    /**
     *
     *
     * <pre>
     * The spec of the pipeline.
     * </pre>
     *
     * <code>.google.protobuf.Struct pipeline_spec = 7;</code>
     *
     * @return The pipelineSpec.
     */
    public com.google.protobuf.Struct getPipelineSpec() {
      if (pipelineSpecBuilder_ == null) {
        return pipelineSpec_ == null
            ? com.google.protobuf.Struct.getDefaultInstance()
            : pipelineSpec_;
      } else {
        return pipelineSpecBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * The spec of the pipeline.
     * </pre>
     *
     * <code>.google.protobuf.Struct pipeline_spec = 7;</code>
     */
    public Builder setPipelineSpec(com.google.protobuf.Struct value) {
      if (pipelineSpecBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        pipelineSpec_ = value;
      } else {
        pipelineSpecBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The spec of the pipeline.
     * </pre>
     *
     * <code>.google.protobuf.Struct pipeline_spec = 7;</code>
     */
    public Builder setPipelineSpec(com.google.protobuf.Struct.Builder builderForValue) {
      if (pipelineSpecBuilder_ == null) {
        pipelineSpec_ = builderForValue.build();
      } else {
        pipelineSpecBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The spec of the pipeline.
     * </pre>
     *
     * <code>.google.protobuf.Struct pipeline_spec = 7;</code>
     */
    public Builder mergePipelineSpec(com.google.protobuf.Struct value) {
      if (pipelineSpecBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)
            && pipelineSpec_ != null
            && pipelineSpec_ != com.google.protobuf.Struct.getDefaultInstance()) {
          getPipelineSpecBuilder().mergeFrom(value);
        } else {
          pipelineSpec_ = value;
        }
      } else {
        pipelineSpecBuilder_.mergeFrom(value);
      }
      if (pipelineSpec_ != null) {
        bitField0_ |= 0x00000040;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The spec of the pipeline.
     * </pre>
     *
     * <code>.google.protobuf.Struct pipeline_spec = 7;</code>
     */
    public Builder clearPipelineSpec() {
      bitField0_ = (bitField0_ & ~0x00000040);
      pipelineSpec_ = null;
      if (pipelineSpecBuilder_ != null) {
        pipelineSpecBuilder_.dispose();
        pipelineSpecBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The spec of the pipeline.
     * </pre>
     *
     * <code>.google.protobuf.Struct pipeline_spec = 7;</code>
     */
    public com.google.protobuf.Struct.Builder getPipelineSpecBuilder() {
      bitField0_ |= 0x00000040;
      onChanged();
      return getPipelineSpecFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * The spec of the pipeline.
     * </pre>
     *
     * <code>.google.protobuf.Struct pipeline_spec = 7;</code>
     */
    public com.google.protobuf.StructOrBuilder getPipelineSpecOrBuilder() {
      if (pipelineSpecBuilder_ != null) {
        return pipelineSpecBuilder_.getMessageOrBuilder();
      } else {
        return pipelineSpec_ == null
            ? com.google.protobuf.Struct.getDefaultInstance()
            : pipelineSpec_;
      }
    }

    /**
     *
     *
     * <pre>
     * The spec of the pipeline.
     * </pre>
     *
     * <code>.google.protobuf.Struct pipeline_spec = 7;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Struct,
            com.google.protobuf.Struct.Builder,
            com.google.protobuf.StructOrBuilder>
        getPipelineSpecFieldBuilder() {
      if (pipelineSpecBuilder_ == null) {
        pipelineSpecBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Struct,
                com.google.protobuf.Struct.Builder,
                com.google.protobuf.StructOrBuilder>(
                getPipelineSpec(), getParentForChildren(), isClean());
        pipelineSpec_ = null;
      }
      return pipelineSpecBuilder_;
    }

    private int state_ = 0;

    /**
     *
     *
     * <pre>
     * Output only. The detailed state of the job.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PipelineState state = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for state.
     */
    @java.lang.Override
    public int getStateValue() {
      return state_;
    }

    /**
     *
     *
     * <pre>
     * Output only. The detailed state of the job.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PipelineState state = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for state to set.
     * @return This builder for chaining.
     */
    public Builder setStateValue(int value) {
      state_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The detailed state of the job.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PipelineState state = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The state.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.PipelineState getState() {
      com.google.cloud.aiplatform.v1beta1.PipelineState result =
          com.google.cloud.aiplatform.v1beta1.PipelineState.forNumber(state_);
      return result == null
          ? com.google.cloud.aiplatform.v1beta1.PipelineState.UNRECOGNIZED
          : result;
    }

    /**
     *
     *
     * <pre>
     * Output only. The detailed state of the job.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PipelineState state = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The state to set.
     * @return This builder for chaining.
     */
    public Builder setState(com.google.cloud.aiplatform.v1beta1.PipelineState value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000080;
      state_ = value.getNumber();
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The detailed state of the job.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PipelineState state = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearState() {
      bitField0_ = (bitField0_ & ~0x00000080);
      state_ = 0;
      onChanged();
      return this;
    }

    private com.google.cloud.aiplatform.v1beta1.PipelineJobDetail jobDetail_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.PipelineJobDetail,
            com.google.cloud.aiplatform.v1beta1.PipelineJobDetail.Builder,
            com.google.cloud.aiplatform.v1beta1.PipelineJobDetailOrBuilder>
        jobDetailBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. The details of pipeline run. Not available in the list view.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PipelineJobDetail job_detail = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the jobDetail field is set.
     */
    public boolean hasJobDetail() {
      return ((bitField0_ & 0x00000100) != 0);
    }

    /**
     *
     *
     * <pre>
     * Output only. The details of pipeline run. Not available in the list view.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PipelineJobDetail job_detail = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The jobDetail.
     */
    public com.google.cloud.aiplatform.v1beta1.PipelineJobDetail getJobDetail() {
      if (jobDetailBuilder_ == null) {
        return jobDetail_ == null
            ? com.google.cloud.aiplatform.v1beta1.PipelineJobDetail.getDefaultInstance()
            : jobDetail_;
      } else {
        return jobDetailBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The details of pipeline run. Not available in the list view.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PipelineJobDetail job_detail = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setJobDetail(com.google.cloud.aiplatform.v1beta1.PipelineJobDetail value) {
      if (jobDetailBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        jobDetail_ = value;
      } else {
        jobDetailBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The details of pipeline run. Not available in the list view.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PipelineJobDetail job_detail = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setJobDetail(
        com.google.cloud.aiplatform.v1beta1.PipelineJobDetail.Builder builderForValue) {
      if (jobDetailBuilder_ == null) {
        jobDetail_ = builderForValue.build();
      } else {
        jobDetailBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The details of pipeline run. Not available in the list view.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PipelineJobDetail job_detail = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeJobDetail(com.google.cloud.aiplatform.v1beta1.PipelineJobDetail value) {
      if (jobDetailBuilder_ == null) {
        if (((bitField0_ & 0x00000100) != 0)
            && jobDetail_ != null
            && jobDetail_
                != com.google.cloud.aiplatform.v1beta1.PipelineJobDetail.getDefaultInstance()) {
          getJobDetailBuilder().mergeFrom(value);
        } else {
          jobDetail_ = value;
        }
      } else {
        jobDetailBuilder_.mergeFrom(value);
      }
      if (jobDetail_ != null) {
        bitField0_ |= 0x00000100;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The details of pipeline run. Not available in the list view.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PipelineJobDetail job_detail = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearJobDetail() {
      bitField0_ = (bitField0_ & ~0x00000100);
      jobDetail_ = null;
      if (jobDetailBuilder_ != null) {
        jobDetailBuilder_.dispose();
        jobDetailBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The details of pipeline run. Not available in the list view.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PipelineJobDetail job_detail = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.PipelineJobDetail.Builder getJobDetailBuilder() {
      bitField0_ |= 0x00000100;
      onChanged();
      return getJobDetailFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Output only. The details of pipeline run. Not available in the list view.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PipelineJobDetail job_detail = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.PipelineJobDetailOrBuilder getJobDetailOrBuilder() {
      if (jobDetailBuilder_ != null) {
        return jobDetailBuilder_.getMessageOrBuilder();
      } else {
        return jobDetail_ == null
            ? com.google.cloud.aiplatform.v1beta1.PipelineJobDetail.getDefaultInstance()
            : jobDetail_;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The details of pipeline run. Not available in the list view.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PipelineJobDetail job_detail = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.PipelineJobDetail,
            com.google.cloud.aiplatform.v1beta1.PipelineJobDetail.Builder,
            com.google.cloud.aiplatform.v1beta1.PipelineJobDetailOrBuilder>
        getJobDetailFieldBuilder() {
      if (jobDetailBuilder_ == null) {
        jobDetailBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.PipelineJobDetail,
                com.google.cloud.aiplatform.v1beta1.PipelineJobDetail.Builder,
                com.google.cloud.aiplatform.v1beta1.PipelineJobDetailOrBuilder>(
                getJobDetail(), getParentForChildren(), isClean());
        jobDetail_ = null;
      }
      return jobDetailBuilder_;
    }

    private com.google.rpc.Status error_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.rpc.Status, com.google.rpc.Status.Builder, com.google.rpc.StatusOrBuilder>
        errorBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. The error that occurred during pipeline execution.
     * Only populated when the pipeline's state is FAILED or CANCELLED.
     * </pre>
     *
     * <code>.google.rpc.Status error = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return Whether the error field is set.
     */
    public boolean hasError() {
      return ((bitField0_ & 0x00000200) != 0);
    }

    /**
     *
     *
     * <pre>
     * Output only. The error that occurred during pipeline execution.
     * Only populated when the pipeline's state is FAILED or CANCELLED.
     * </pre>
     *
     * <code>.google.rpc.Status error = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The error.
     */
    public com.google.rpc.Status getError() {
      if (errorBuilder_ == null) {
        return error_ == null ? com.google.rpc.Status.getDefaultInstance() : error_;
      } else {
        return errorBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The error that occurred during pipeline execution.
     * Only populated when the pipeline's state is FAILED or CANCELLED.
     * </pre>
     *
     * <code>.google.rpc.Status error = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder setError(com.google.rpc.Status value) {
      if (errorBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        error_ = value;
      } else {
        errorBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The error that occurred during pipeline execution.
     * Only populated when the pipeline's state is FAILED or CANCELLED.
     * </pre>
     *
     * <code>.google.rpc.Status error = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder setError(com.google.rpc.Status.Builder builderForValue) {
      if (errorBuilder_ == null) {
        error_ = builderForValue.build();
      } else {
        errorBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The error that occurred during pipeline execution.
     * Only populated when the pipeline's state is FAILED or CANCELLED.
     * </pre>
     *
     * <code>.google.rpc.Status error = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder mergeError(com.google.rpc.Status value) {
      if (errorBuilder_ == null) {
        if (((bitField0_ & 0x00000200) != 0)
            && error_ != null
            && error_ != com.google.rpc.Status.getDefaultInstance()) {
          getErrorBuilder().mergeFrom(value);
        } else {
          error_ = value;
        }
      } else {
        errorBuilder_.mergeFrom(value);
      }
      if (error_ != null) {
        bitField0_ |= 0x00000200;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The error that occurred during pipeline execution.
     * Only populated when the pipeline's state is FAILED or CANCELLED.
     * </pre>
     *
     * <code>.google.rpc.Status error = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder clearError() {
      bitField0_ = (bitField0_ & ~0x00000200);
      error_ = null;
      if (errorBuilder_ != null) {
        errorBuilder_.dispose();
        errorBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The error that occurred during pipeline execution.
     * Only populated when the pipeline's state is FAILED or CANCELLED.
     * </pre>
     *
     * <code>.google.rpc.Status error = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public com.google.rpc.Status.Builder getErrorBuilder() {
      bitField0_ |= 0x00000200;
      onChanged();
      return getErrorFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Output only. The error that occurred during pipeline execution.
     * Only populated when the pipeline's state is FAILED or CANCELLED.
     * </pre>
     *
     * <code>.google.rpc.Status error = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public com.google.rpc.StatusOrBuilder getErrorOrBuilder() {
      if (errorBuilder_ != null) {
        return errorBuilder_.getMessageOrBuilder();
      } else {
        return error_ == null ? com.google.rpc.Status.getDefaultInstance() : error_;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The error that occurred during pipeline execution.
     * Only populated when the pipeline's state is FAILED or CANCELLED.
     * </pre>
     *
     * <code>.google.rpc.Status error = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.rpc.Status, com.google.rpc.Status.Builder, com.google.rpc.StatusOrBuilder>
        getErrorFieldBuilder() {
      if (errorBuilder_ == null) {
        errorBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.rpc.Status,
                com.google.rpc.Status.Builder,
                com.google.rpc.StatusOrBuilder>(getError(), getParentForChildren(), isClean());
        error_ = null;
      }
      return errorBuilder_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
      if (labels_ == null) {
        return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      return labels_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableLabels() {
      if (labels_ == null) {
        labels_ = com.google.protobuf.MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      if (!labels_.isMutable()) {
        labels_ = labels_.copy();
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return labels_;
    }

    public int getLabelsCount() {
      return internalGetLabels().getMap().size();
    }

    /**
     *
     *
     * <pre>
     * The labels with user-defined metadata to organize PipelineJob.
     *
     * Label keys and values can be no longer than 64 characters
     * (Unicode codepoints), can only contain lowercase letters, numeric
     * characters, underscores and dashes. International characters are allowed.
     *
     * See https://goo.gl/xmQnxf for more information and examples of labels.
     *
     * Note there is some reserved label key for Vertex AI Pipelines.
     * - `vertex-ai-pipelines-run-billing-id`, user set value will get overrided.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 11;</code>
     */
    @java.lang.Override
    public boolean containsLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetLabels().getMap().containsKey(key);
    }

    /** Use {@link #getLabelsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getLabels() {
      return getLabelsMap();
    }

    /**
     *
     *
     * <pre>
     * The labels with user-defined metadata to organize PipelineJob.
     *
     * Label keys and values can be no longer than 64 characters
     * (Unicode codepoints), can only contain lowercase letters, numeric
     * characters, underscores and dashes. International characters are allowed.
     *
     * See https://goo.gl/xmQnxf for more information and examples of labels.
     *
     * Note there is some reserved label key for Vertex AI Pipelines.
     * - `vertex-ai-pipelines-run-billing-id`, user set value will get overrided.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 11;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
      return internalGetLabels().getMap();
    }

    /**
     *
     *
     * <pre>
     * The labels with user-defined metadata to organize PipelineJob.
     *
     * Label keys and values can be no longer than 64 characters
     * (Unicode codepoints), can only contain lowercase letters, numeric
     * characters, underscores and dashes. International characters are allowed.
     *
     * See https://goo.gl/xmQnxf for more information and examples of labels.
     *
     * Note there is some reserved label key for Vertex AI Pipelines.
     * - `vertex-ai-pipelines-run-billing-id`, user set value will get overrided.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 11;</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getLabelsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }

    /**
     *
     *
     * <pre>
     * The labels with user-defined metadata to organize PipelineJob.
     *
     * Label keys and values can be no longer than 64 characters
     * (Unicode codepoints), can only contain lowercase letters, numeric
     * characters, underscores and dashes. International characters are allowed.
     *
     * See https://goo.gl/xmQnxf for more information and examples of labels.
     *
     * Note there is some reserved label key for Vertex AI Pipelines.
     * - `vertex-ai-pipelines-run-billing-id`, user set value will get overrided.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 11;</code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearLabels() {
      bitField0_ = (bitField0_ & ~0x00000400);
      internalGetMutableLabels().getMutableMap().clear();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The labels with user-defined metadata to organize PipelineJob.
     *
     * Label keys and values can be no longer than 64 characters
     * (Unicode codepoints), can only contain lowercase letters, numeric
     * characters, underscores and dashes. International characters are allowed.
     *
     * See https://goo.gl/xmQnxf for more information and examples of labels.
     *
     * Note there is some reserved label key for Vertex AI Pipelines.
     * - `vertex-ai-pipelines-run-billing-id`, user set value will get overrided.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 11;</code>
     */
    public Builder removeLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableLabels().getMutableMap().remove(key);
      return this;
    }

    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableLabels() {
      bitField0_ |= 0x00000400;
      return internalGetMutableLabels().getMutableMap();
    }

    /**
     *
     *
     * <pre>
     * The labels with user-defined metadata to organize PipelineJob.
     *
     * Label keys and values can be no longer than 64 characters
     * (Unicode codepoints), can only contain lowercase letters, numeric
     * characters, underscores and dashes. International characters are allowed.
     *
     * See https://goo.gl/xmQnxf for more information and examples of labels.
     *
     * Note there is some reserved label key for Vertex AI Pipelines.
     * - `vertex-ai-pipelines-run-billing-id`, user set value will get overrided.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 11;</code>
     */
    public Builder putLabels(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableLabels().getMutableMap().put(key, value);
      bitField0_ |= 0x00000400;
      return this;
    }

    /**
     *
     *
     * <pre>
     * The labels with user-defined metadata to organize PipelineJob.
     *
     * Label keys and values can be no longer than 64 characters
     * (Unicode codepoints), can only contain lowercase letters, numeric
     * characters, underscores and dashes. International characters are allowed.
     *
     * See https://goo.gl/xmQnxf for more information and examples of labels.
     *
     * Note there is some reserved label key for Vertex AI Pipelines.
     * - `vertex-ai-pipelines-run-billing-id`, user set value will get overrided.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 11;</code>
     */
    public Builder putAllLabels(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableLabels().getMutableMap().putAll(values);
      bitField0_ |= 0x00000400;
      return this;
    }

    private com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig runtimeConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig,
            com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.Builder,
            com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfigOrBuilder>
        runtimeConfigBuilder_;

    /**
     *
     *
     * <pre>
     * Runtime config of the pipeline.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig runtime_config = 12;</code>
     *
     * @return Whether the runtimeConfig field is set.
     */
    public boolean hasRuntimeConfig() {
      return ((bitField0_ & 0x00000800) != 0);
    }

    /**
     *
     *
     * <pre>
     * Runtime config of the pipeline.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig runtime_config = 12;</code>
     *
     * @return The runtimeConfig.
     */
    public com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig getRuntimeConfig() {
      if (runtimeConfigBuilder_ == null) {
        return runtimeConfig_ == null
            ? com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.getDefaultInstance()
            : runtimeConfig_;
      } else {
        return runtimeConfigBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Runtime config of the pipeline.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig runtime_config = 12;</code>
     */
    public Builder setRuntimeConfig(
        com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig value) {
      if (runtimeConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        runtimeConfig_ = value;
      } else {
        runtimeConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Runtime config of the pipeline.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig runtime_config = 12;</code>
     */
    public Builder setRuntimeConfig(
        com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.Builder builderForValue) {
      if (runtimeConfigBuilder_ == null) {
        runtimeConfig_ = builderForValue.build();
      } else {
        runtimeConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Runtime config of the pipeline.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig runtime_config = 12;</code>
     */
    public Builder mergeRuntimeConfig(
        com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig value) {
      if (runtimeConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000800) != 0)
            && runtimeConfig_ != null
            && runtimeConfig_
                != com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig
                    .getDefaultInstance()) {
          getRuntimeConfigBuilder().mergeFrom(value);
        } else {
          runtimeConfig_ = value;
        }
      } else {
        runtimeConfigBuilder_.mergeFrom(value);
      }
      if (runtimeConfig_ != null) {
        bitField0_ |= 0x00000800;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Runtime config of the pipeline.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig runtime_config = 12;</code>
     */
    public Builder clearRuntimeConfig() {
      bitField0_ = (bitField0_ & ~0x00000800);
      runtimeConfig_ = null;
      if (runtimeConfigBuilder_ != null) {
        runtimeConfigBuilder_.dispose();
        runtimeConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Runtime config of the pipeline.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig runtime_config = 12;</code>
     */
    public com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.Builder
        getRuntimeConfigBuilder() {
      bitField0_ |= 0x00000800;
      onChanged();
      return getRuntimeConfigFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Runtime config of the pipeline.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig runtime_config = 12;</code>
     */
    public com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfigOrBuilder
        getRuntimeConfigOrBuilder() {
      if (runtimeConfigBuilder_ != null) {
        return runtimeConfigBuilder_.getMessageOrBuilder();
      } else {
        return runtimeConfig_ == null
            ? com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.getDefaultInstance()
            : runtimeConfig_;
      }
    }

    /**
     *
     *
     * <pre>
     * Runtime config of the pipeline.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig runtime_config = 12;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig,
            com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.Builder,
            com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfigOrBuilder>
        getRuntimeConfigFieldBuilder() {
      if (runtimeConfigBuilder_ == null) {
        runtimeConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig,
                com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.Builder,
                com.google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfigOrBuilder>(
                getRuntimeConfig(), getParentForChildren(), isClean());
        runtimeConfig_ = null;
      }
      return runtimeConfigBuilder_;
    }

    private com.google.cloud.aiplatform.v1beta1.EncryptionSpec encryptionSpec_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.EncryptionSpec,
            com.google.cloud.aiplatform.v1beta1.EncryptionSpec.Builder,
            com.google.cloud.aiplatform.v1beta1.EncryptionSpecOrBuilder>
        encryptionSpecBuilder_;

    /**
     *
     *
     * <pre>
     * Customer-managed encryption key spec for a pipelineJob. If set, this
     * PipelineJob and all of its sub-resources will be secured by this key.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.EncryptionSpec encryption_spec = 16;</code>
     *
     * @return Whether the encryptionSpec field is set.
     */
    public boolean hasEncryptionSpec() {
      return ((bitField0_ & 0x00001000) != 0);
    }

    /**
     *
     *
     * <pre>
     * Customer-managed encryption key spec for a pipelineJob. If set, this
     * PipelineJob and all of its sub-resources will be secured by this key.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.EncryptionSpec encryption_spec = 16;</code>
     *
     * @return The encryptionSpec.
     */
    public com.google.cloud.aiplatform.v1beta1.EncryptionSpec getEncryptionSpec() {
      if (encryptionSpecBuilder_ == null) {
        return encryptionSpec_ == null
            ? com.google.cloud.aiplatform.v1beta1.EncryptionSpec.getDefaultInstance()
            : encryptionSpec_;
      } else {
        return encryptionSpecBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Customer-managed encryption key spec for a pipelineJob. If set, this
     * PipelineJob and all of its sub-resources will be secured by this key.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.EncryptionSpec encryption_spec = 16;</code>
     */
    public Builder setEncryptionSpec(com.google.cloud.aiplatform.v1beta1.EncryptionSpec value) {
      if (encryptionSpecBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        encryptionSpec_ = value;
      } else {
        encryptionSpecBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Customer-managed encryption key spec for a pipelineJob. If set, this
     * PipelineJob and all of its sub-resources will be secured by this key.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.EncryptionSpec encryption_spec = 16;</code>
     */
    public Builder setEncryptionSpec(
        com.google.cloud.aiplatform.v1beta1.EncryptionSpec.Builder builderForValue) {
      if (encryptionSpecBuilder_ == null) {
        encryptionSpec_ = builderForValue.build();
      } else {
        encryptionSpecBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Customer-managed encryption key spec for a pipelineJob. If set, this
     * PipelineJob and all of its sub-resources will be secured by this key.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.EncryptionSpec encryption_spec = 16;</code>
     */
    public Builder mergeEncryptionSpec(com.google.cloud.aiplatform.v1beta1.EncryptionSpec value) {
      if (encryptionSpecBuilder_ == null) {
        if (((bitField0_ & 0x00001000) != 0)
            && encryptionSpec_ != null
            && encryptionSpec_
                != com.google.cloud.aiplatform.v1beta1.EncryptionSpec.getDefaultInstance()) {
          getEncryptionSpecBuilder().mergeFrom(value);
        } else {
          encryptionSpec_ = value;
        }
      } else {
        encryptionSpecBuilder_.mergeFrom(value);
      }
      if (encryptionSpec_ != null) {
        bitField0_ |= 0x00001000;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Customer-managed encryption key spec for a pipelineJob. If set, this
     * PipelineJob and all of its sub-resources will be secured by this key.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.EncryptionSpec encryption_spec = 16;</code>
     */
    public Builder clearEncryptionSpec() {
      bitField0_ = (bitField0_ & ~0x00001000);
      encryptionSpec_ = null;
      if (encryptionSpecBuilder_ != null) {
        encryptionSpecBuilder_.dispose();
        encryptionSpecBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Customer-managed encryption key spec for a pipelineJob. If set, this
     * PipelineJob and all of its sub-resources will be secured by this key.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.EncryptionSpec encryption_spec = 16;</code>
     */
    public com.google.cloud.aiplatform.v1beta1.EncryptionSpec.Builder getEncryptionSpecBuilder() {
      bitField0_ |= 0x00001000;
      onChanged();
      return getEncryptionSpecFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Customer-managed encryption key spec for a pipelineJob. If set, this
     * PipelineJob and all of its sub-resources will be secured by this key.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.EncryptionSpec encryption_spec = 16;</code>
     */
    public com.google.cloud.aiplatform.v1beta1.EncryptionSpecOrBuilder
        getEncryptionSpecOrBuilder() {
      if (encryptionSpecBuilder_ != null) {
        return encryptionSpecBuilder_.getMessageOrBuilder();
      } else {
        return encryptionSpec_ == null
            ? com.google.cloud.aiplatform.v1beta1.EncryptionSpec.getDefaultInstance()
            : encryptionSpec_;
      }
    }

    /**
     *
     *
     * <pre>
     * Customer-managed encryption key spec for a pipelineJob. If set, this
     * PipelineJob and all of its sub-resources will be secured by this key.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.EncryptionSpec encryption_spec = 16;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.EncryptionSpec,
            com.google.cloud.aiplatform.v1beta1.EncryptionSpec.Builder,
            com.google.cloud.aiplatform.v1beta1.EncryptionSpecOrBuilder>
        getEncryptionSpecFieldBuilder() {
      if (encryptionSpecBuilder_ == null) {
        encryptionSpecBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.EncryptionSpec,
                com.google.cloud.aiplatform.v1beta1.EncryptionSpec.Builder,
                com.google.cloud.aiplatform.v1beta1.EncryptionSpecOrBuilder>(
                getEncryptionSpec(), getParentForChildren(), isClean());
        encryptionSpec_ = null;
      }
      return encryptionSpecBuilder_;
    }

    private java.lang.Object serviceAccount_ = "";

    /**
     *
     *
     * <pre>
     * The service account that the pipeline workload runs as.
     * If not specified, the Compute Engine default service account in the project
     * will be used.
     * See
     * https://cloud.google.com/compute/docs/access/service-accounts#default_service_account
     *
     * Users starting the pipeline must have the `iam.serviceAccounts.actAs`
     * permission on this service account.
     * </pre>
     *
     * <code>string service_account = 17;</code>
     *
     * @return The serviceAccount.
     */
    public java.lang.String getServiceAccount() {
      java.lang.Object ref = serviceAccount_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        serviceAccount_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The service account that the pipeline workload runs as.
     * If not specified, the Compute Engine default service account in the project
     * will be used.
     * See
     * https://cloud.google.com/compute/docs/access/service-accounts#default_service_account
     *
     * Users starting the pipeline must have the `iam.serviceAccounts.actAs`
     * permission on this service account.
     * </pre>
     *
     * <code>string service_account = 17;</code>
     *
     * @return The bytes for serviceAccount.
     */
    public com.google.protobuf.ByteString getServiceAccountBytes() {
      java.lang.Object ref = serviceAccount_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        serviceAccount_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The service account that the pipeline workload runs as.
     * If not specified, the Compute Engine default service account in the project
     * will be used.
     * See
     * https://cloud.google.com/compute/docs/access/service-accounts#default_service_account
     *
     * Users starting the pipeline must have the `iam.serviceAccounts.actAs`
     * permission on this service account.
     * </pre>
     *
     * <code>string service_account = 17;</code>
     *
     * @param value The serviceAccount to set.
     * @return This builder for chaining.
     */
    public Builder setServiceAccount(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      serviceAccount_ = value;
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The service account that the pipeline workload runs as.
     * If not specified, the Compute Engine default service account in the project
     * will be used.
     * See
     * https://cloud.google.com/compute/docs/access/service-accounts#default_service_account
     *
     * Users starting the pipeline must have the `iam.serviceAccounts.actAs`
     * permission on this service account.
     * </pre>
     *
     * <code>string service_account = 17;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearServiceAccount() {
      serviceAccount_ = getDefaultInstance().getServiceAccount();
      bitField0_ = (bitField0_ & ~0x00002000);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The service account that the pipeline workload runs as.
     * If not specified, the Compute Engine default service account in the project
     * will be used.
     * See
     * https://cloud.google.com/compute/docs/access/service-accounts#default_service_account
     *
     * Users starting the pipeline must have the `iam.serviceAccounts.actAs`
     * permission on this service account.
     * </pre>
     *
     * <code>string service_account = 17;</code>
     *
     * @param value The bytes for serviceAccount to set.
     * @return This builder for chaining.
     */
    public Builder setServiceAccountBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      serviceAccount_ = value;
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }

    private java.lang.Object network_ = "";

    /**
     *
     *
     * <pre>
     * The full name of the Compute Engine
     * [network](/compute/docs/networks-and-firewalls#networks) to which the
     * Pipeline Job's workload should be peered. For example,
     * `projects/12345/global/networks/myVPC`.
     * [Format](/compute/docs/reference/rest/v1/networks/insert)
     * is of the form `projects/{project}/global/networks/{network}`.
     * Where {project} is a project number, as in `12345`, and {network} is a
     * network name.
     *
     * Private services access must already be configured for the network.
     * Pipeline job will apply the network configuration to the Google Cloud
     * resources being launched, if applied, such as Vertex AI
     * Training or Dataflow job. If left unspecified, the workload is not peered
     * with any network.
     * </pre>
     *
     * <code>string network = 18 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The network.
     */
    public java.lang.String getNetwork() {
      java.lang.Object ref = network_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        network_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The full name of the Compute Engine
     * [network](/compute/docs/networks-and-firewalls#networks) to which the
     * Pipeline Job's workload should be peered. For example,
     * `projects/12345/global/networks/myVPC`.
     * [Format](/compute/docs/reference/rest/v1/networks/insert)
     * is of the form `projects/{project}/global/networks/{network}`.
     * Where {project} is a project number, as in `12345`, and {network} is a
     * network name.
     *
     * Private services access must already be configured for the network.
     * Pipeline job will apply the network configuration to the Google Cloud
     * resources being launched, if applied, such as Vertex AI
     * Training or Dataflow job. If left unspecified, the workload is not peered
     * with any network.
     * </pre>
     *
     * <code>string network = 18 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The bytes for network.
     */
    public com.google.protobuf.ByteString getNetworkBytes() {
      java.lang.Object ref = network_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        network_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The full name of the Compute Engine
     * [network](/compute/docs/networks-and-firewalls#networks) to which the
     * Pipeline Job's workload should be peered. For example,
     * `projects/12345/global/networks/myVPC`.
     * [Format](/compute/docs/reference/rest/v1/networks/insert)
     * is of the form `projects/{project}/global/networks/{network}`.
     * Where {project} is a project number, as in `12345`, and {network} is a
     * network name.
     *
     * Private services access must already be configured for the network.
     * Pipeline job will apply the network configuration to the Google Cloud
     * resources being launched, if applied, such as Vertex AI
     * Training or Dataflow job. If left unspecified, the workload is not peered
     * with any network.
     * </pre>
     *
     * <code>string network = 18 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The network to set.
     * @return This builder for chaining.
     */
    public Builder setNetwork(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      network_ = value;
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The full name of the Compute Engine
     * [network](/compute/docs/networks-and-firewalls#networks) to which the
     * Pipeline Job's workload should be peered. For example,
     * `projects/12345/global/networks/myVPC`.
     * [Format](/compute/docs/reference/rest/v1/networks/insert)
     * is of the form `projects/{project}/global/networks/{network}`.
     * Where {project} is a project number, as in `12345`, and {network} is a
     * network name.
     *
     * Private services access must already be configured for the network.
     * Pipeline job will apply the network configuration to the Google Cloud
     * resources being launched, if applied, such as Vertex AI
     * Training or Dataflow job. If left unspecified, the workload is not peered
     * with any network.
     * </pre>
     *
     * <code>string network = 18 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNetwork() {
      network_ = getDefaultInstance().getNetwork();
      bitField0_ = (bitField0_ & ~0x00004000);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The full name of the Compute Engine
     * [network](/compute/docs/networks-and-firewalls#networks) to which the
     * Pipeline Job's workload should be peered. For example,
     * `projects/12345/global/networks/myVPC`.
     * [Format](/compute/docs/reference/rest/v1/networks/insert)
     * is of the form `projects/{project}/global/networks/{network}`.
     * Where {project} is a project number, as in `12345`, and {network} is a
     * network name.
     *
     * Private services access must already be configured for the network.
     * Pipeline job will apply the network configuration to the Google Cloud
     * resources being launched, if applied, such as Vertex AI
     * Training or Dataflow job. If left unspecified, the workload is not peered
     * with any network.
     * </pre>
     *
     * <code>string network = 18 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The bytes for network to set.
     * @return This builder for chaining.
     */
    public Builder setNetworkBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      network_ = value;
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList reservedIpRanges_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureReservedIpRangesIsMutable() {
      if (!reservedIpRanges_.isModifiable()) {
        reservedIpRanges_ = new com.google.protobuf.LazyStringArrayList(reservedIpRanges_);
      }
      bitField0_ |= 0x00008000;
    }

    /**
     *
     *
     * <pre>
     * A list of names for the reserved ip ranges under the VPC network
     * that can be used for this Pipeline Job's workload.
     *
     * If set, we will deploy the Pipeline Job's workload within the provided ip
     * ranges. Otherwise, the job will be deployed to any ip ranges under the
     * provided VPC network.
     *
     * Example: ['vertex-ai-ip-range'].
     * </pre>
     *
     * <code>repeated string reserved_ip_ranges = 25;</code>
     *
     * @return A list containing the reservedIpRanges.
     */
    public com.google.protobuf.ProtocolStringList getReservedIpRangesList() {
      reservedIpRanges_.makeImmutable();
      return reservedIpRanges_;
    }

    /**
     *
     *
     * <pre>
     * A list of names for the reserved ip ranges under the VPC network
     * that can be used for this Pipeline Job's workload.
     *
     * If set, we will deploy the Pipeline Job's workload within the provided ip
     * ranges. Otherwise, the job will be deployed to any ip ranges under the
     * provided VPC network.
     *
     * Example: ['vertex-ai-ip-range'].
     * </pre>
     *
     * <code>repeated string reserved_ip_ranges = 25;</code>
     *
     * @return The count of reservedIpRanges.
     */
    public int getReservedIpRangesCount() {
      return reservedIpRanges_.size();
    }

    /**
     *
     *
     * <pre>
     * A list of names for the reserved ip ranges under the VPC network
     * that can be used for this Pipeline Job's workload.
     *
     * If set, we will deploy the Pipeline Job's workload within the provided ip
     * ranges. Otherwise, the job will be deployed to any ip ranges under the
     * provided VPC network.
     *
     * Example: ['vertex-ai-ip-range'].
     * </pre>
     *
     * <code>repeated string reserved_ip_ranges = 25;</code>
     *
     * @param index The index of the element to return.
     * @return The reservedIpRanges at the given index.
     */
    public java.lang.String getReservedIpRanges(int index) {
      return reservedIpRanges_.get(index);
    }

    /**
     *
     *
     * <pre>
     * A list of names for the reserved ip ranges under the VPC network
     * that can be used for this Pipeline Job's workload.
     *
     * If set, we will deploy the Pipeline Job's workload within the provided ip
     * ranges. Otherwise, the job will be deployed to any ip ranges under the
     * provided VPC network.
     *
     * Example: ['vertex-ai-ip-range'].
     * </pre>
     *
     * <code>repeated string reserved_ip_ranges = 25;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the reservedIpRanges at the given index.
     */
    public com.google.protobuf.ByteString getReservedIpRangesBytes(int index) {
      return reservedIpRanges_.getByteString(index);
    }

    /**
     *
     *
     * <pre>
     * A list of names for the reserved ip ranges under the VPC network
     * that can be used for this Pipeline Job's workload.
     *
     * If set, we will deploy the Pipeline Job's workload within the provided ip
     * ranges. Otherwise, the job will be deployed to any ip ranges under the
     * provided VPC network.
     *
     * Example: ['vertex-ai-ip-range'].
     * </pre>
     *
     * <code>repeated string reserved_ip_ranges = 25;</code>
     *
     * @param index The index to set the value at.
     * @param value The reservedIpRanges to set.
     * @return This builder for chaining.
     */
    public Builder setReservedIpRanges(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureReservedIpRangesIsMutable();
      reservedIpRanges_.set(index, value);
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of names for the reserved ip ranges under the VPC network
     * that can be used for this Pipeline Job's workload.
     *
     * If set, we will deploy the Pipeline Job's workload within the provided ip
     * ranges. Otherwise, the job will be deployed to any ip ranges under the
     * provided VPC network.
     *
     * Example: ['vertex-ai-ip-range'].
     * </pre>
     *
     * <code>repeated string reserved_ip_ranges = 25;</code>
     *
     * @param value The reservedIpRanges to add.
     * @return This builder for chaining.
     */
    public Builder addReservedIpRanges(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureReservedIpRangesIsMutable();
      reservedIpRanges_.add(value);
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of names for the reserved ip ranges under the VPC network
     * that can be used for this Pipeline Job's workload.
     *
     * If set, we will deploy the Pipeline Job's workload within the provided ip
     * ranges. Otherwise, the job will be deployed to any ip ranges under the
     * provided VPC network.
     *
     * Example: ['vertex-ai-ip-range'].
     * </pre>
     *
     * <code>repeated string reserved_ip_ranges = 25;</code>
     *
     * @param values The reservedIpRanges to add.
     * @return This builder for chaining.
     */
    public Builder addAllReservedIpRanges(java.lang.Iterable<java.lang.String> values) {
      ensureReservedIpRangesIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, reservedIpRanges_);
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of names for the reserved ip ranges under the VPC network
     * that can be used for this Pipeline Job's workload.
     *
     * If set, we will deploy the Pipeline Job's workload within the provided ip
     * ranges. Otherwise, the job will be deployed to any ip ranges under the
     * provided VPC network.
     *
     * Example: ['vertex-ai-ip-range'].
     * </pre>
     *
     * <code>repeated string reserved_ip_ranges = 25;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearReservedIpRanges() {
      reservedIpRanges_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00008000);
      ;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of names for the reserved ip ranges under the VPC network
     * that can be used for this Pipeline Job's workload.
     *
     * If set, we will deploy the Pipeline Job's workload within the provided ip
     * ranges. Otherwise, the job will be deployed to any ip ranges under the
     * provided VPC network.
     *
     * Example: ['vertex-ai-ip-range'].
     * </pre>
     *
     * <code>repeated string reserved_ip_ranges = 25;</code>
     *
     * @param value The bytes of the reservedIpRanges to add.
     * @return This builder for chaining.
     */
    public Builder addReservedIpRangesBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureReservedIpRangesIsMutable();
      reservedIpRanges_.add(value);
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }

    private com.google.cloud.aiplatform.v1beta1.PscInterfaceConfig pscInterfaceConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.PscInterfaceConfig,
            com.google.cloud.aiplatform.v1beta1.PscInterfaceConfig.Builder,
            com.google.cloud.aiplatform.v1beta1.PscInterfaceConfigOrBuilder>
        pscInterfaceConfigBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. Configuration for PSC-I for PipelineJob.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PscInterfaceConfig psc_interface_config = 31 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the pscInterfaceConfig field is set.
     */
    public boolean hasPscInterfaceConfig() {
      return ((bitField0_ & 0x00010000) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. Configuration for PSC-I for PipelineJob.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PscInterfaceConfig psc_interface_config = 31 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The pscInterfaceConfig.
     */
    public com.google.cloud.aiplatform.v1beta1.PscInterfaceConfig getPscInterfaceConfig() {
      if (pscInterfaceConfigBuilder_ == null) {
        return pscInterfaceConfig_ == null
            ? com.google.cloud.aiplatform.v1beta1.PscInterfaceConfig.getDefaultInstance()
            : pscInterfaceConfig_;
      } else {
        return pscInterfaceConfigBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Configuration for PSC-I for PipelineJob.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PscInterfaceConfig psc_interface_config = 31 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setPscInterfaceConfig(
        com.google.cloud.aiplatform.v1beta1.PscInterfaceConfig value) {
      if (pscInterfaceConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        pscInterfaceConfig_ = value;
      } else {
        pscInterfaceConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00010000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Configuration for PSC-I for PipelineJob.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PscInterfaceConfig psc_interface_config = 31 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setPscInterfaceConfig(
        com.google.cloud.aiplatform.v1beta1.PscInterfaceConfig.Builder builderForValue) {
      if (pscInterfaceConfigBuilder_ == null) {
        pscInterfaceConfig_ = builderForValue.build();
      } else {
        pscInterfaceConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00010000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Configuration for PSC-I for PipelineJob.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PscInterfaceConfig psc_interface_config = 31 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergePscInterfaceConfig(
        com.google.cloud.aiplatform.v1beta1.PscInterfaceConfig value) {
      if (pscInterfaceConfigBuilder_ == null) {
        if (((bitField0_ & 0x00010000) != 0)
            && pscInterfaceConfig_ != null
            && pscInterfaceConfig_
                != com.google.cloud.aiplatform.v1beta1.PscInterfaceConfig.getDefaultInstance()) {
          getPscInterfaceConfigBuilder().mergeFrom(value);
        } else {
          pscInterfaceConfig_ = value;
        }
      } else {
        pscInterfaceConfigBuilder_.mergeFrom(value);
      }
      if (pscInterfaceConfig_ != null) {
        bitField0_ |= 0x00010000;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Configuration for PSC-I for PipelineJob.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PscInterfaceConfig psc_interface_config = 31 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearPscInterfaceConfig() {
      bitField0_ = (bitField0_ & ~0x00010000);
      pscInterfaceConfig_ = null;
      if (pscInterfaceConfigBuilder_ != null) {
        pscInterfaceConfigBuilder_.dispose();
        pscInterfaceConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Configuration for PSC-I for PipelineJob.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PscInterfaceConfig psc_interface_config = 31 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.PscInterfaceConfig.Builder
        getPscInterfaceConfigBuilder() {
      bitField0_ |= 0x00010000;
      onChanged();
      return getPscInterfaceConfigFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Optional. Configuration for PSC-I for PipelineJob.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PscInterfaceConfig psc_interface_config = 31 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.PscInterfaceConfigOrBuilder
        getPscInterfaceConfigOrBuilder() {
      if (pscInterfaceConfigBuilder_ != null) {
        return pscInterfaceConfigBuilder_.getMessageOrBuilder();
      } else {
        return pscInterfaceConfig_ == null
            ? com.google.cloud.aiplatform.v1beta1.PscInterfaceConfig.getDefaultInstance()
            : pscInterfaceConfig_;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Configuration for PSC-I for PipelineJob.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PscInterfaceConfig psc_interface_config = 31 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.PscInterfaceConfig,
            com.google.cloud.aiplatform.v1beta1.PscInterfaceConfig.Builder,
            com.google.cloud.aiplatform.v1beta1.PscInterfaceConfigOrBuilder>
        getPscInterfaceConfigFieldBuilder() {
      if (pscInterfaceConfigBuilder_ == null) {
        pscInterfaceConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.PscInterfaceConfig,
                com.google.cloud.aiplatform.v1beta1.PscInterfaceConfig.Builder,
                com.google.cloud.aiplatform.v1beta1.PscInterfaceConfigOrBuilder>(
                getPscInterfaceConfig(), getParentForChildren(), isClean());
        pscInterfaceConfig_ = null;
      }
      return pscInterfaceConfigBuilder_;
    }

    private java.lang.Object templateUri_ = "";

    /**
     *
     *
     * <pre>
     * A template uri from where the
     * [PipelineJob.pipeline_spec][google.cloud.aiplatform.v1beta1.PipelineJob.pipeline_spec],
     * if empty, will be downloaded. Currently, only uri from Vertex Template
     * Registry &amp; Gallery is supported. Reference to
     * https://cloud.google.com/vertex-ai/docs/pipelines/create-pipeline-template.
     * </pre>
     *
     * <code>string template_uri = 19;</code>
     *
     * @return The templateUri.
     */
    public java.lang.String getTemplateUri() {
      java.lang.Object ref = templateUri_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        templateUri_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * A template uri from where the
     * [PipelineJob.pipeline_spec][google.cloud.aiplatform.v1beta1.PipelineJob.pipeline_spec],
     * if empty, will be downloaded. Currently, only uri from Vertex Template
     * Registry &amp; Gallery is supported. Reference to
     * https://cloud.google.com/vertex-ai/docs/pipelines/create-pipeline-template.
     * </pre>
     *
     * <code>string template_uri = 19;</code>
     *
     * @return The bytes for templateUri.
     */
    public com.google.protobuf.ByteString getTemplateUriBytes() {
      java.lang.Object ref = templateUri_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        templateUri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * A template uri from where the
     * [PipelineJob.pipeline_spec][google.cloud.aiplatform.v1beta1.PipelineJob.pipeline_spec],
     * if empty, will be downloaded. Currently, only uri from Vertex Template
     * Registry &amp; Gallery is supported. Reference to
     * https://cloud.google.com/vertex-ai/docs/pipelines/create-pipeline-template.
     * </pre>
     *
     * <code>string template_uri = 19;</code>
     *
     * @param value The templateUri to set.
     * @return This builder for chaining.
     */
    public Builder setTemplateUri(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      templateUri_ = value;
      bitField0_ |= 0x00020000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * A template uri from where the
     * [PipelineJob.pipeline_spec][google.cloud.aiplatform.v1beta1.PipelineJob.pipeline_spec],
     * if empty, will be downloaded. Currently, only uri from Vertex Template
     * Registry &amp; Gallery is supported. Reference to
     * https://cloud.google.com/vertex-ai/docs/pipelines/create-pipeline-template.
     * </pre>
     *
     * <code>string template_uri = 19;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTemplateUri() {
      templateUri_ = getDefaultInstance().getTemplateUri();
      bitField0_ = (bitField0_ & ~0x00020000);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * A template uri from where the
     * [PipelineJob.pipeline_spec][google.cloud.aiplatform.v1beta1.PipelineJob.pipeline_spec],
     * if empty, will be downloaded. Currently, only uri from Vertex Template
     * Registry &amp; Gallery is supported. Reference to
     * https://cloud.google.com/vertex-ai/docs/pipelines/create-pipeline-template.
     * </pre>
     *
     * <code>string template_uri = 19;</code>
     *
     * @param value The bytes for templateUri to set.
     * @return This builder for chaining.
     */
    public Builder setTemplateUriBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      templateUri_ = value;
      bitField0_ |= 0x00020000;
      onChanged();
      return this;
    }

    private com.google.cloud.aiplatform.v1beta1.PipelineTemplateMetadata templateMetadata_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.PipelineTemplateMetadata,
            com.google.cloud.aiplatform.v1beta1.PipelineTemplateMetadata.Builder,
            com.google.cloud.aiplatform.v1beta1.PipelineTemplateMetadataOrBuilder>
        templateMetadataBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. Pipeline template metadata. Will fill up fields if
     * [PipelineJob.template_uri][google.cloud.aiplatform.v1beta1.PipelineJob.template_uri]
     * is from supported template registry.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PipelineTemplateMetadata template_metadata = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the templateMetadata field is set.
     */
    public boolean hasTemplateMetadata() {
      return ((bitField0_ & 0x00040000) != 0);
    }

    /**
     *
     *
     * <pre>
     * Output only. Pipeline template metadata. Will fill up fields if
     * [PipelineJob.template_uri][google.cloud.aiplatform.v1beta1.PipelineJob.template_uri]
     * is from supported template registry.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PipelineTemplateMetadata template_metadata = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The templateMetadata.
     */
    public com.google.cloud.aiplatform.v1beta1.PipelineTemplateMetadata getTemplateMetadata() {
      if (templateMetadataBuilder_ == null) {
        return templateMetadata_ == null
            ? com.google.cloud.aiplatform.v1beta1.PipelineTemplateMetadata.getDefaultInstance()
            : templateMetadata_;
      } else {
        return templateMetadataBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Pipeline template metadata. Will fill up fields if
     * [PipelineJob.template_uri][google.cloud.aiplatform.v1beta1.PipelineJob.template_uri]
     * is from supported template registry.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PipelineTemplateMetadata template_metadata = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setTemplateMetadata(
        com.google.cloud.aiplatform.v1beta1.PipelineTemplateMetadata value) {
      if (templateMetadataBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        templateMetadata_ = value;
      } else {
        templateMetadataBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00040000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Pipeline template metadata. Will fill up fields if
     * [PipelineJob.template_uri][google.cloud.aiplatform.v1beta1.PipelineJob.template_uri]
     * is from supported template registry.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PipelineTemplateMetadata template_metadata = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setTemplateMetadata(
        com.google.cloud.aiplatform.v1beta1.PipelineTemplateMetadata.Builder builderForValue) {
      if (templateMetadataBuilder_ == null) {
        templateMetadata_ = builderForValue.build();
      } else {
        templateMetadataBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00040000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Pipeline template metadata. Will fill up fields if
     * [PipelineJob.template_uri][google.cloud.aiplatform.v1beta1.PipelineJob.template_uri]
     * is from supported template registry.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PipelineTemplateMetadata template_metadata = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeTemplateMetadata(
        com.google.cloud.aiplatform.v1beta1.PipelineTemplateMetadata value) {
      if (templateMetadataBuilder_ == null) {
        if (((bitField0_ & 0x00040000) != 0)
            && templateMetadata_ != null
            && templateMetadata_
                != com.google.cloud.aiplatform.v1beta1.PipelineTemplateMetadata
                    .getDefaultInstance()) {
          getTemplateMetadataBuilder().mergeFrom(value);
        } else {
          templateMetadata_ = value;
        }
      } else {
        templateMetadataBuilder_.mergeFrom(value);
      }
      if (templateMetadata_ != null) {
        bitField0_ |= 0x00040000;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Pipeline template metadata. Will fill up fields if
     * [PipelineJob.template_uri][google.cloud.aiplatform.v1beta1.PipelineJob.template_uri]
     * is from supported template registry.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PipelineTemplateMetadata template_metadata = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearTemplateMetadata() {
      bitField0_ = (bitField0_ & ~0x00040000);
      templateMetadata_ = null;
      if (templateMetadataBuilder_ != null) {
        templateMetadataBuilder_.dispose();
        templateMetadataBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Pipeline template metadata. Will fill up fields if
     * [PipelineJob.template_uri][google.cloud.aiplatform.v1beta1.PipelineJob.template_uri]
     * is from supported template registry.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PipelineTemplateMetadata template_metadata = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.PipelineTemplateMetadata.Builder
        getTemplateMetadataBuilder() {
      bitField0_ |= 0x00040000;
      onChanged();
      return getTemplateMetadataFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Output only. Pipeline template metadata. Will fill up fields if
     * [PipelineJob.template_uri][google.cloud.aiplatform.v1beta1.PipelineJob.template_uri]
     * is from supported template registry.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PipelineTemplateMetadata template_metadata = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.PipelineTemplateMetadataOrBuilder
        getTemplateMetadataOrBuilder() {
      if (templateMetadataBuilder_ != null) {
        return templateMetadataBuilder_.getMessageOrBuilder();
      } else {
        return templateMetadata_ == null
            ? com.google.cloud.aiplatform.v1beta1.PipelineTemplateMetadata.getDefaultInstance()
            : templateMetadata_;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Pipeline template metadata. Will fill up fields if
     * [PipelineJob.template_uri][google.cloud.aiplatform.v1beta1.PipelineJob.template_uri]
     * is from supported template registry.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PipelineTemplateMetadata template_metadata = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.PipelineTemplateMetadata,
            com.google.cloud.aiplatform.v1beta1.PipelineTemplateMetadata.Builder,
            com.google.cloud.aiplatform.v1beta1.PipelineTemplateMetadataOrBuilder>
        getTemplateMetadataFieldBuilder() {
      if (templateMetadataBuilder_ == null) {
        templateMetadataBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.PipelineTemplateMetadata,
                com.google.cloud.aiplatform.v1beta1.PipelineTemplateMetadata.Builder,
                com.google.cloud.aiplatform.v1beta1.PipelineTemplateMetadataOrBuilder>(
                getTemplateMetadata(), getParentForChildren(), isClean());
        templateMetadata_ = null;
      }
      return templateMetadataBuilder_;
    }

    private java.lang.Object scheduleName_ = "";

    /**
     *
     *
     * <pre>
     * Output only. The schedule resource name.
     * Only returned if the Pipeline is created by Schedule API.
     * </pre>
     *
     * <code>string schedule_name = 22 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The scheduleName.
     */
    public java.lang.String getScheduleName() {
      java.lang.Object ref = scheduleName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        scheduleName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The schedule resource name.
     * Only returned if the Pipeline is created by Schedule API.
     * </pre>
     *
     * <code>string schedule_name = 22 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for scheduleName.
     */
    public com.google.protobuf.ByteString getScheduleNameBytes() {
      java.lang.Object ref = scheduleName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        scheduleName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The schedule resource name.
     * Only returned if the Pipeline is created by Schedule API.
     * </pre>
     *
     * <code>string schedule_name = 22 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The scheduleName to set.
     * @return This builder for chaining.
     */
    public Builder setScheduleName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      scheduleName_ = value;
      bitField0_ |= 0x00080000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The schedule resource name.
     * Only returned if the Pipeline is created by Schedule API.
     * </pre>
     *
     * <code>string schedule_name = 22 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearScheduleName() {
      scheduleName_ = getDefaultInstance().getScheduleName();
      bitField0_ = (bitField0_ & ~0x00080000);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The schedule resource name.
     * Only returned if the Pipeline is created by Schedule API.
     * </pre>
     *
     * <code>string schedule_name = 22 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for scheduleName to set.
     * @return This builder for chaining.
     */
    public Builder setScheduleNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      scheduleName_ = value;
      bitField0_ |= 0x00080000;
      onChanged();
      return this;
    }

    private boolean preflightValidations_;

    /**
     *
     *
     * <pre>
     * Optional. Whether to do component level validations before job creation.
     * </pre>
     *
     * <code>bool preflight_validations = 26 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The preflightValidations.
     */
    @java.lang.Override
    public boolean getPreflightValidations() {
      return preflightValidations_;
    }

    /**
     *
     *
     * <pre>
     * Optional. Whether to do component level validations before job creation.
     * </pre>
     *
     * <code>bool preflight_validations = 26 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The preflightValidations to set.
     * @return This builder for chaining.
     */
    public Builder setPreflightValidations(boolean value) {

      preflightValidations_ = value;
      bitField0_ |= 0x00100000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Whether to do component level validations before job creation.
     * </pre>
     *
     * <code>bool preflight_validations = 26 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPreflightValidations() {
      bitField0_ = (bitField0_ & ~0x00100000);
      preflightValidations_ = false;
      onChanged();
      return this;
    }

    private boolean satisfiesPzs_;

    /**
     *
     *
     * <pre>
     * Output only. Reserved for future use.
     * </pre>
     *
     * <code>bool satisfies_pzs = 27 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The satisfiesPzs.
     */
    @java.lang.Override
    public boolean getSatisfiesPzs() {
      return satisfiesPzs_;
    }

    /**
     *
     *
     * <pre>
     * Output only. Reserved for future use.
     * </pre>
     *
     * <code>bool satisfies_pzs = 27 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The satisfiesPzs to set.
     * @return This builder for chaining.
     */
    public Builder setSatisfiesPzs(boolean value) {

      satisfiesPzs_ = value;
      bitField0_ |= 0x00200000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Reserved for future use.
     * </pre>
     *
     * <code>bool satisfies_pzs = 27 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSatisfiesPzs() {
      bitField0_ = (bitField0_ & ~0x00200000);
      satisfiesPzs_ = false;
      onChanged();
      return this;
    }

    private boolean satisfiesPzi_;

    /**
     *
     *
     * <pre>
     * Output only. Reserved for future use.
     * </pre>
     *
     * <code>bool satisfies_pzi = 28 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The satisfiesPzi.
     */
    @java.lang.Override
    public boolean getSatisfiesPzi() {
      return satisfiesPzi_;
    }

    /**
     *
     *
     * <pre>
     * Output only. Reserved for future use.
     * </pre>
     *
     * <code>bool satisfies_pzi = 28 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The satisfiesPzi to set.
     * @return This builder for chaining.
     */
    public Builder setSatisfiesPzi(boolean value) {

      satisfiesPzi_ = value;
      bitField0_ |= 0x00400000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Reserved for future use.
     * </pre>
     *
     * <code>bool satisfies_pzi = 28 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSatisfiesPzi() {
      bitField0_ = (bitField0_ & ~0x00400000);
      satisfiesPzi_ = false;
      onChanged();
      return this;
    }

    private long originalPipelineJobId_;

    /**
     *
     *
     * <pre>
     * Optional. The original pipeline job id if this pipeline job is a rerun of a
     * previous pipeline job.
     * </pre>
     *
     * <code>int64 original_pipeline_job_id = 29 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The originalPipelineJobId.
     */
    @java.lang.Override
    public long getOriginalPipelineJobId() {
      return originalPipelineJobId_;
    }

    /**
     *
     *
     * <pre>
     * Optional. The original pipeline job id if this pipeline job is a rerun of a
     * previous pipeline job.
     * </pre>
     *
     * <code>int64 original_pipeline_job_id = 29 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The originalPipelineJobId to set.
     * @return This builder for chaining.
     */
    public Builder setOriginalPipelineJobId(long value) {

      originalPipelineJobId_ = value;
      bitField0_ |= 0x00800000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The original pipeline job id if this pipeline job is a rerun of a
     * previous pipeline job.
     * </pre>
     *
     * <code>int64 original_pipeline_job_id = 29 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearOriginalPipelineJobId() {
      bitField0_ = (bitField0_ & ~0x00800000);
      originalPipelineJobId_ = 0L;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig>
        pipelineTaskRerunConfigs_ = java.util.Collections.emptyList();

    private void ensurePipelineTaskRerunConfigsIsMutable() {
      if (!((bitField0_ & 0x01000000) != 0)) {
        pipelineTaskRerunConfigs_ =
            new java.util.ArrayList<com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig>(
                pipelineTaskRerunConfigs_);
        bitField0_ |= 0x01000000;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig,
            com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.Builder,
            com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfigOrBuilder>
        pipelineTaskRerunConfigsBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. The rerun configs for each task in the pipeline job.
     * By default, the rerun will:
     * 1. Use the same input artifacts as the original run.
     * 2. Use the same input parameters as the original run.
     * 3. Skip all the tasks that are already succeeded in the original run.
     * 4. Rerun all the tasks that are not succeeded in the original run.
     * By providing this field, users can override the default behavior and
     * specify the rerun config for each task.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig pipeline_task_rerun_configs = 30 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig>
        getPipelineTaskRerunConfigsList() {
      if (pipelineTaskRerunConfigsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(pipelineTaskRerunConfigs_);
      } else {
        return pipelineTaskRerunConfigsBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The rerun configs for each task in the pipeline job.
     * By default, the rerun will:
     * 1. Use the same input artifacts as the original run.
     * 2. Use the same input parameters as the original run.
     * 3. Skip all the tasks that are already succeeded in the original run.
     * 4. Rerun all the tasks that are not succeeded in the original run.
     * By providing this field, users can override the default behavior and
     * specify the rerun config for each task.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig pipeline_task_rerun_configs = 30 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public int getPipelineTaskRerunConfigsCount() {
      if (pipelineTaskRerunConfigsBuilder_ == null) {
        return pipelineTaskRerunConfigs_.size();
      } else {
        return pipelineTaskRerunConfigsBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The rerun configs for each task in the pipeline job.
     * By default, the rerun will:
     * 1. Use the same input artifacts as the original run.
     * 2. Use the same input parameters as the original run.
     * 3. Skip all the tasks that are already succeeded in the original run.
     * 4. Rerun all the tasks that are not succeeded in the original run.
     * By providing this field, users can override the default behavior and
     * specify the rerun config for each task.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig pipeline_task_rerun_configs = 30 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig getPipelineTaskRerunConfigs(
        int index) {
      if (pipelineTaskRerunConfigsBuilder_ == null) {
        return pipelineTaskRerunConfigs_.get(index);
      } else {
        return pipelineTaskRerunConfigsBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The rerun configs for each task in the pipeline job.
     * By default, the rerun will:
     * 1. Use the same input artifacts as the original run.
     * 2. Use the same input parameters as the original run.
     * 3. Skip all the tasks that are already succeeded in the original run.
     * 4. Rerun all the tasks that are not succeeded in the original run.
     * By providing this field, users can override the default behavior and
     * specify the rerun config for each task.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig pipeline_task_rerun_configs = 30 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setPipelineTaskRerunConfigs(
        int index, com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig value) {
      if (pipelineTaskRerunConfigsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePipelineTaskRerunConfigsIsMutable();
        pipelineTaskRerunConfigs_.set(index, value);
        onChanged();
      } else {
        pipelineTaskRerunConfigsBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The rerun configs for each task in the pipeline job.
     * By default, the rerun will:
     * 1. Use the same input artifacts as the original run.
     * 2. Use the same input parameters as the original run.
     * 3. Skip all the tasks that are already succeeded in the original run.
     * 4. Rerun all the tasks that are not succeeded in the original run.
     * By providing this field, users can override the default behavior and
     * specify the rerun config for each task.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig pipeline_task_rerun_configs = 30 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setPipelineTaskRerunConfigs(
        int index,
        com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.Builder builderForValue) {
      if (pipelineTaskRerunConfigsBuilder_ == null) {
        ensurePipelineTaskRerunConfigsIsMutable();
        pipelineTaskRerunConfigs_.set(index, builderForValue.build());
        onChanged();
      } else {
        pipelineTaskRerunConfigsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The rerun configs for each task in the pipeline job.
     * By default, the rerun will:
     * 1. Use the same input artifacts as the original run.
     * 2. Use the same input parameters as the original run.
     * 3. Skip all the tasks that are already succeeded in the original run.
     * 4. Rerun all the tasks that are not succeeded in the original run.
     * By providing this field, users can override the default behavior and
     * specify the rerun config for each task.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig pipeline_task_rerun_configs = 30 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addPipelineTaskRerunConfigs(
        com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig value) {
      if (pipelineTaskRerunConfigsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePipelineTaskRerunConfigsIsMutable();
        pipelineTaskRerunConfigs_.add(value);
        onChanged();
      } else {
        pipelineTaskRerunConfigsBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The rerun configs for each task in the pipeline job.
     * By default, the rerun will:
     * 1. Use the same input artifacts as the original run.
     * 2. Use the same input parameters as the original run.
     * 3. Skip all the tasks that are already succeeded in the original run.
     * 4. Rerun all the tasks that are not succeeded in the original run.
     * By providing this field, users can override the default behavior and
     * specify the rerun config for each task.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig pipeline_task_rerun_configs = 30 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addPipelineTaskRerunConfigs(
        int index, com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig value) {
      if (pipelineTaskRerunConfigsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePipelineTaskRerunConfigsIsMutable();
        pipelineTaskRerunConfigs_.add(index, value);
        onChanged();
      } else {
        pipelineTaskRerunConfigsBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The rerun configs for each task in the pipeline job.
     * By default, the rerun will:
     * 1. Use the same input artifacts as the original run.
     * 2. Use the same input parameters as the original run.
     * 3. Skip all the tasks that are already succeeded in the original run.
     * 4. Rerun all the tasks that are not succeeded in the original run.
     * By providing this field, users can override the default behavior and
     * specify the rerun config for each task.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig pipeline_task_rerun_configs = 30 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addPipelineTaskRerunConfigs(
        com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.Builder builderForValue) {
      if (pipelineTaskRerunConfigsBuilder_ == null) {
        ensurePipelineTaskRerunConfigsIsMutable();
        pipelineTaskRerunConfigs_.add(builderForValue.build());
        onChanged();
      } else {
        pipelineTaskRerunConfigsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The rerun configs for each task in the pipeline job.
     * By default, the rerun will:
     * 1. Use the same input artifacts as the original run.
     * 2. Use the same input parameters as the original run.
     * 3. Skip all the tasks that are already succeeded in the original run.
     * 4. Rerun all the tasks that are not succeeded in the original run.
     * By providing this field, users can override the default behavior and
     * specify the rerun config for each task.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig pipeline_task_rerun_configs = 30 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addPipelineTaskRerunConfigs(
        int index,
        com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.Builder builderForValue) {
      if (pipelineTaskRerunConfigsBuilder_ == null) {
        ensurePipelineTaskRerunConfigsIsMutable();
        pipelineTaskRerunConfigs_.add(index, builderForValue.build());
        onChanged();
      } else {
        pipelineTaskRerunConfigsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The rerun configs for each task in the pipeline job.
     * By default, the rerun will:
     * 1. Use the same input artifacts as the original run.
     * 2. Use the same input parameters as the original run.
     * 3. Skip all the tasks that are already succeeded in the original run.
     * 4. Rerun all the tasks that are not succeeded in the original run.
     * By providing this field, users can override the default behavior and
     * specify the rerun config for each task.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig pipeline_task_rerun_configs = 30 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addAllPipelineTaskRerunConfigs(
        java.lang.Iterable<? extends com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig>
            values) {
      if (pipelineTaskRerunConfigsBuilder_ == null) {
        ensurePipelineTaskRerunConfigsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, pipelineTaskRerunConfigs_);
        onChanged();
      } else {
        pipelineTaskRerunConfigsBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The rerun configs for each task in the pipeline job.
     * By default, the rerun will:
     * 1. Use the same input artifacts as the original run.
     * 2. Use the same input parameters as the original run.
     * 3. Skip all the tasks that are already succeeded in the original run.
     * 4. Rerun all the tasks that are not succeeded in the original run.
     * By providing this field, users can override the default behavior and
     * specify the rerun config for each task.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig pipeline_task_rerun_configs = 30 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearPipelineTaskRerunConfigs() {
      if (pipelineTaskRerunConfigsBuilder_ == null) {
        pipelineTaskRerunConfigs_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x01000000);
        onChanged();
      } else {
        pipelineTaskRerunConfigsBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The rerun configs for each task in the pipeline job.
     * By default, the rerun will:
     * 1. Use the same input artifacts as the original run.
     * 2. Use the same input parameters as the original run.
     * 3. Skip all the tasks that are already succeeded in the original run.
     * 4. Rerun all the tasks that are not succeeded in the original run.
     * By providing this field, users can override the default behavior and
     * specify the rerun config for each task.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig pipeline_task_rerun_configs = 30 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder removePipelineTaskRerunConfigs(int index) {
      if (pipelineTaskRerunConfigsBuilder_ == null) {
        ensurePipelineTaskRerunConfigsIsMutable();
        pipelineTaskRerunConfigs_.remove(index);
        onChanged();
      } else {
        pipelineTaskRerunConfigsBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The rerun configs for each task in the pipeline job.
     * By default, the rerun will:
     * 1. Use the same input artifacts as the original run.
     * 2. Use the same input parameters as the original run.
     * 3. Skip all the tasks that are already succeeded in the original run.
     * 4. Rerun all the tasks that are not succeeded in the original run.
     * By providing this field, users can override the default behavior and
     * specify the rerun config for each task.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig pipeline_task_rerun_configs = 30 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.Builder
        getPipelineTaskRerunConfigsBuilder(int index) {
      return getPipelineTaskRerunConfigsFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * Optional. The rerun configs for each task in the pipeline job.
     * By default, the rerun will:
     * 1. Use the same input artifacts as the original run.
     * 2. Use the same input parameters as the original run.
     * 3. Skip all the tasks that are already succeeded in the original run.
     * 4. Rerun all the tasks that are not succeeded in the original run.
     * By providing this field, users can override the default behavior and
     * specify the rerun config for each task.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig pipeline_task_rerun_configs = 30 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfigOrBuilder
        getPipelineTaskRerunConfigsOrBuilder(int index) {
      if (pipelineTaskRerunConfigsBuilder_ == null) {
        return pipelineTaskRerunConfigs_.get(index);
      } else {
        return pipelineTaskRerunConfigsBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The rerun configs for each task in the pipeline job.
     * By default, the rerun will:
     * 1. Use the same input artifacts as the original run.
     * 2. Use the same input parameters as the original run.
     * 3. Skip all the tasks that are already succeeded in the original run.
     * 4. Rerun all the tasks that are not succeeded in the original run.
     * By providing this field, users can override the default behavior and
     * specify the rerun config for each task.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig pipeline_task_rerun_configs = 30 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<
            ? extends com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfigOrBuilder>
        getPipelineTaskRerunConfigsOrBuilderList() {
      if (pipelineTaskRerunConfigsBuilder_ != null) {
        return pipelineTaskRerunConfigsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(pipelineTaskRerunConfigs_);
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The rerun configs for each task in the pipeline job.
     * By default, the rerun will:
     * 1. Use the same input artifacts as the original run.
     * 2. Use the same input parameters as the original run.
     * 3. Skip all the tasks that are already succeeded in the original run.
     * 4. Rerun all the tasks that are not succeeded in the original run.
     * By providing this field, users can override the default behavior and
     * specify the rerun config for each task.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig pipeline_task_rerun_configs = 30 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.Builder
        addPipelineTaskRerunConfigsBuilder() {
      return getPipelineTaskRerunConfigsFieldBuilder()
          .addBuilder(
              com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Optional. The rerun configs for each task in the pipeline job.
     * By default, the rerun will:
     * 1. Use the same input artifacts as the original run.
     * 2. Use the same input parameters as the original run.
     * 3. Skip all the tasks that are already succeeded in the original run.
     * 4. Rerun all the tasks that are not succeeded in the original run.
     * By providing this field, users can override the default behavior and
     * specify the rerun config for each task.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig pipeline_task_rerun_configs = 30 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.Builder
        addPipelineTaskRerunConfigsBuilder(int index) {
      return getPipelineTaskRerunConfigsFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Optional. The rerun configs for each task in the pipeline job.
     * By default, the rerun will:
     * 1. Use the same input artifacts as the original run.
     * 2. Use the same input parameters as the original run.
     * 3. Skip all the tasks that are already succeeded in the original run.
     * 4. Rerun all the tasks that are not succeeded in the original run.
     * By providing this field, users can override the default behavior and
     * specify the rerun config for each task.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig pipeline_task_rerun_configs = 30 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.Builder>
        getPipelineTaskRerunConfigsBuilderList() {
      return getPipelineTaskRerunConfigsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig,
            com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.Builder,
            com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfigOrBuilder>
        getPipelineTaskRerunConfigsFieldBuilder() {
      if (pipelineTaskRerunConfigsBuilder_ == null) {
        pipelineTaskRerunConfigsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig,
                com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.Builder,
                com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfigOrBuilder>(
                pipelineTaskRerunConfigs_,
                ((bitField0_ & 0x01000000) != 0),
                getParentForChildren(),
                isClean());
        pipelineTaskRerunConfigs_ = null;
      }
      return pipelineTaskRerunConfigsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.PipelineJob)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.PipelineJob)
  private static final com.google.cloud.aiplatform.v1beta1.PipelineJob DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.PipelineJob();
  }

  public static com.google.cloud.aiplatform.v1beta1.PipelineJob getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<PipelineJob> PARSER =
      new com.google.protobuf.AbstractParser<PipelineJob>() {
        @java.lang.Override
        public PipelineJob parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<PipelineJob> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<PipelineJob> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.PipelineJob getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
