/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1beta1/model_monitoring_service.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.aiplatform.v1beta1;

/**
 *
 *
 * <pre>
 * Request message for
 * [ModelMonitoringService.SearchModelMonitoringAlerts][google.cloud.aiplatform.v1beta1.ModelMonitoringService.SearchModelMonitoringAlerts].
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1beta1.SearchModelMonitoringAlertsRequest}
 */
public final class SearchModelMonitoringAlertsRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.SearchModelMonitoringAlertsRequest)
    SearchModelMonitoringAlertsRequestOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use SearchModelMonitoringAlertsRequest.newBuilder() to construct.
  private SearchModelMonitoringAlertsRequest(
      com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private SearchModelMonitoringAlertsRequest() {
    modelMonitor_ = "";
    modelMonitoringJob_ = "";
    statsName_ = "";
    objectiveType_ = "";
    pageToken_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new SearchModelMonitoringAlertsRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1beta1.ModelMonitoringServiceProto
        .internal_static_google_cloud_aiplatform_v1beta1_SearchModelMonitoringAlertsRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1beta1.ModelMonitoringServiceProto
        .internal_static_google_cloud_aiplatform_v1beta1_SearchModelMonitoringAlertsRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1beta1.SearchModelMonitoringAlertsRequest.class,
            com.google.cloud.aiplatform.v1beta1.SearchModelMonitoringAlertsRequest.Builder.class);
  }

  private int bitField0_;
  public static final int MODEL_MONITOR_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object modelMonitor_ = "";

  /**
   *
   *
   * <pre>
   * Required. ModelMonitor resource name.
   * Format:
   * `projects/{project}/locations/{location}/modelMonitors/{model_monitor}`
   * </pre>
   *
   * <code>
   * string model_monitor = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The modelMonitor.
   */
  @java.lang.Override
  public java.lang.String getModelMonitor() {
    java.lang.Object ref = modelMonitor_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      modelMonitor_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Required. ModelMonitor resource name.
   * Format:
   * `projects/{project}/locations/{location}/modelMonitors/{model_monitor}`
   * </pre>
   *
   * <code>
   * string model_monitor = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for modelMonitor.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getModelMonitorBytes() {
    java.lang.Object ref = modelMonitor_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      modelMonitor_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int MODEL_MONITORING_JOB_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object modelMonitoringJob_ = "";

  /**
   *
   *
   * <pre>
   * If non-empty, returns the alerts of this model monitoring job.
   * </pre>
   *
   * <code>string model_monitoring_job = 2;</code>
   *
   * @return The modelMonitoringJob.
   */
  @java.lang.Override
  public java.lang.String getModelMonitoringJob() {
    java.lang.Object ref = modelMonitoringJob_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      modelMonitoringJob_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * If non-empty, returns the alerts of this model monitoring job.
   * </pre>
   *
   * <code>string model_monitoring_job = 2;</code>
   *
   * @return The bytes for modelMonitoringJob.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getModelMonitoringJobBytes() {
    java.lang.Object ref = modelMonitoringJob_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      modelMonitoringJob_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ALERT_TIME_INTERVAL_FIELD_NUMBER = 3;
  private com.google.type.Interval alertTimeInterval_;

  /**
   *
   *
   * <pre>
   * If non-empty, returns the alerts in this time interval.
   * </pre>
   *
   * <code>.google.type.Interval alert_time_interval = 3;</code>
   *
   * @return Whether the alertTimeInterval field is set.
   */
  @java.lang.Override
  public boolean hasAlertTimeInterval() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * If non-empty, returns the alerts in this time interval.
   * </pre>
   *
   * <code>.google.type.Interval alert_time_interval = 3;</code>
   *
   * @return The alertTimeInterval.
   */
  @java.lang.Override
  public com.google.type.Interval getAlertTimeInterval() {
    return alertTimeInterval_ == null
        ? com.google.type.Interval.getDefaultInstance()
        : alertTimeInterval_;
  }

  /**
   *
   *
   * <pre>
   * If non-empty, returns the alerts in this time interval.
   * </pre>
   *
   * <code>.google.type.Interval alert_time_interval = 3;</code>
   */
  @java.lang.Override
  public com.google.type.IntervalOrBuilder getAlertTimeIntervalOrBuilder() {
    return alertTimeInterval_ == null
        ? com.google.type.Interval.getDefaultInstance()
        : alertTimeInterval_;
  }

  public static final int STATS_NAME_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object statsName_ = "";

  /**
   *
   *
   * <pre>
   * If non-empty, returns the alerts of this stats_name.
   * </pre>
   *
   * <code>string stats_name = 4;</code>
   *
   * @return The statsName.
   */
  @java.lang.Override
  public java.lang.String getStatsName() {
    java.lang.Object ref = statsName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      statsName_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * If non-empty, returns the alerts of this stats_name.
   * </pre>
   *
   * <code>string stats_name = 4;</code>
   *
   * @return The bytes for statsName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getStatsNameBytes() {
    java.lang.Object ref = statsName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      statsName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int OBJECTIVE_TYPE_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private volatile java.lang.Object objectiveType_ = "";

  /**
   *
   *
   * <pre>
   * If non-empty, returns the alerts of this objective type.
   * Supported monitoring objectives:
   * `raw-feature-drift`
   * `prediction-output-drift`
   * `feature-attribution`
   * </pre>
   *
   * <code>string objective_type = 5;</code>
   *
   * @return The objectiveType.
   */
  @java.lang.Override
  public java.lang.String getObjectiveType() {
    java.lang.Object ref = objectiveType_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      objectiveType_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * If non-empty, returns the alerts of this objective type.
   * Supported monitoring objectives:
   * `raw-feature-drift`
   * `prediction-output-drift`
   * `feature-attribution`
   * </pre>
   *
   * <code>string objective_type = 5;</code>
   *
   * @return The bytes for objectiveType.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getObjectiveTypeBytes() {
    java.lang.Object ref = objectiveType_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      objectiveType_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PAGE_SIZE_FIELD_NUMBER = 6;
  private int pageSize_ = 0;

  /**
   *
   *
   * <pre>
   * The standard list page size.
   * </pre>
   *
   * <code>int32 page_size = 6;</code>
   *
   * @return The pageSize.
   */
  @java.lang.Override
  public int getPageSize() {
    return pageSize_;
  }

  public static final int PAGE_TOKEN_FIELD_NUMBER = 7;

  @SuppressWarnings("serial")
  private volatile java.lang.Object pageToken_ = "";

  /**
   *
   *
   * <pre>
   * A page token received from a previous
   * [ModelMonitoringService.SearchModelMonitoringAlerts][google.cloud.aiplatform.v1beta1.ModelMonitoringService.SearchModelMonitoringAlerts]
   * call.
   * </pre>
   *
   * <code>string page_token = 7;</code>
   *
   * @return The pageToken.
   */
  @java.lang.Override
  public java.lang.String getPageToken() {
    java.lang.Object ref = pageToken_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      pageToken_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * A page token received from a previous
   * [ModelMonitoringService.SearchModelMonitoringAlerts][google.cloud.aiplatform.v1beta1.ModelMonitoringService.SearchModelMonitoringAlerts]
   * call.
   * </pre>
   *
   * <code>string page_token = 7;</code>
   *
   * @return The bytes for pageToken.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPageTokenBytes() {
    java.lang.Object ref = pageToken_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      pageToken_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(modelMonitor_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, modelMonitor_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(modelMonitoringJob_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, modelMonitoringJob_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(3, getAlertTimeInterval());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(statsName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, statsName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(objectiveType_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, objectiveType_);
    }
    if (pageSize_ != 0) {
      output.writeInt32(6, pageSize_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(pageToken_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 7, pageToken_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(modelMonitor_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, modelMonitor_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(modelMonitoringJob_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, modelMonitoringJob_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getAlertTimeInterval());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(statsName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, statsName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(objectiveType_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, objectiveType_);
    }
    if (pageSize_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(6, pageSize_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(pageToken_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(7, pageToken_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.SearchModelMonitoringAlertsRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1beta1.SearchModelMonitoringAlertsRequest other =
        (com.google.cloud.aiplatform.v1beta1.SearchModelMonitoringAlertsRequest) obj;

    if (!getModelMonitor().equals(other.getModelMonitor())) return false;
    if (!getModelMonitoringJob().equals(other.getModelMonitoringJob())) return false;
    if (hasAlertTimeInterval() != other.hasAlertTimeInterval()) return false;
    if (hasAlertTimeInterval()) {
      if (!getAlertTimeInterval().equals(other.getAlertTimeInterval())) return false;
    }
    if (!getStatsName().equals(other.getStatsName())) return false;
    if (!getObjectiveType().equals(other.getObjectiveType())) return false;
    if (getPageSize() != other.getPageSize()) return false;
    if (!getPageToken().equals(other.getPageToken())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + MODEL_MONITOR_FIELD_NUMBER;
    hash = (53 * hash) + getModelMonitor().hashCode();
    hash = (37 * hash) + MODEL_MONITORING_JOB_FIELD_NUMBER;
    hash = (53 * hash) + getModelMonitoringJob().hashCode();
    if (hasAlertTimeInterval()) {
      hash = (37 * hash) + ALERT_TIME_INTERVAL_FIELD_NUMBER;
      hash = (53 * hash) + getAlertTimeInterval().hashCode();
    }
    hash = (37 * hash) + STATS_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getStatsName().hashCode();
    hash = (37 * hash) + OBJECTIVE_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + getObjectiveType().hashCode();
    hash = (37 * hash) + PAGE_SIZE_FIELD_NUMBER;
    hash = (53 * hash) + getPageSize();
    hash = (37 * hash) + PAGE_TOKEN_FIELD_NUMBER;
    hash = (53 * hash) + getPageToken().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1beta1.SearchModelMonitoringAlertsRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.SearchModelMonitoringAlertsRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.SearchModelMonitoringAlertsRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.SearchModelMonitoringAlertsRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.SearchModelMonitoringAlertsRequest parseFrom(
      byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.SearchModelMonitoringAlertsRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.SearchModelMonitoringAlertsRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.SearchModelMonitoringAlertsRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.SearchModelMonitoringAlertsRequest
      parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.SearchModelMonitoringAlertsRequest
      parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.SearchModelMonitoringAlertsRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.SearchModelMonitoringAlertsRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.aiplatform.v1beta1.SearchModelMonitoringAlertsRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Request message for
   * [ModelMonitoringService.SearchModelMonitoringAlerts][google.cloud.aiplatform.v1beta1.ModelMonitoringService.SearchModelMonitoringAlerts].
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.SearchModelMonitoringAlertsRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.SearchModelMonitoringAlertsRequest)
      com.google.cloud.aiplatform.v1beta1.SearchModelMonitoringAlertsRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.ModelMonitoringServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_SearchModelMonitoringAlertsRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.ModelMonitoringServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_SearchModelMonitoringAlertsRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.SearchModelMonitoringAlertsRequest.class,
              com.google.cloud.aiplatform.v1beta1.SearchModelMonitoringAlertsRequest.Builder.class);
    }

    // Construct using
    // com.google.cloud.aiplatform.v1beta1.SearchModelMonitoringAlertsRequest.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getAlertTimeIntervalFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      modelMonitor_ = "";
      modelMonitoringJob_ = "";
      alertTimeInterval_ = null;
      if (alertTimeIntervalBuilder_ != null) {
        alertTimeIntervalBuilder_.dispose();
        alertTimeIntervalBuilder_ = null;
      }
      statsName_ = "";
      objectiveType_ = "";
      pageSize_ = 0;
      pageToken_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1beta1.ModelMonitoringServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_SearchModelMonitoringAlertsRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.SearchModelMonitoringAlertsRequest
        getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1beta1.SearchModelMonitoringAlertsRequest
          .getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.SearchModelMonitoringAlertsRequest build() {
      com.google.cloud.aiplatform.v1beta1.SearchModelMonitoringAlertsRequest result =
          buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.SearchModelMonitoringAlertsRequest buildPartial() {
      com.google.cloud.aiplatform.v1beta1.SearchModelMonitoringAlertsRequest result =
          new com.google.cloud.aiplatform.v1beta1.SearchModelMonitoringAlertsRequest(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(
        com.google.cloud.aiplatform.v1beta1.SearchModelMonitoringAlertsRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.modelMonitor_ = modelMonitor_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.modelMonitoringJob_ = modelMonitoringJob_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.alertTimeInterval_ =
            alertTimeIntervalBuilder_ == null
                ? alertTimeInterval_
                : alertTimeIntervalBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.statsName_ = statsName_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.objectiveType_ = objectiveType_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.pageSize_ = pageSize_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.pageToken_ = pageToken_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1beta1.SearchModelMonitoringAlertsRequest) {
        return mergeFrom(
            (com.google.cloud.aiplatform.v1beta1.SearchModelMonitoringAlertsRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(
        com.google.cloud.aiplatform.v1beta1.SearchModelMonitoringAlertsRequest other) {
      if (other
          == com.google.cloud.aiplatform.v1beta1.SearchModelMonitoringAlertsRequest
              .getDefaultInstance()) return this;
      if (!other.getModelMonitor().isEmpty()) {
        modelMonitor_ = other.modelMonitor_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getModelMonitoringJob().isEmpty()) {
        modelMonitoringJob_ = other.modelMonitoringJob_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.hasAlertTimeInterval()) {
        mergeAlertTimeInterval(other.getAlertTimeInterval());
      }
      if (!other.getStatsName().isEmpty()) {
        statsName_ = other.statsName_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (!other.getObjectiveType().isEmpty()) {
        objectiveType_ = other.objectiveType_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (other.getPageSize() != 0) {
        setPageSize(other.getPageSize());
      }
      if (!other.getPageToken().isEmpty()) {
        pageToken_ = other.pageToken_;
        bitField0_ |= 0x00000040;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                modelMonitor_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                modelMonitoringJob_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(
                    getAlertTimeIntervalFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                statsName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                objectiveType_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 48:
              {
                pageSize_ = input.readInt32();
                bitField0_ |= 0x00000020;
                break;
              } // case 48
            case 58:
              {
                pageToken_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000040;
                break;
              } // case 58
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object modelMonitor_ = "";

    /**
     *
     *
     * <pre>
     * Required. ModelMonitor resource name.
     * Format:
     * `projects/{project}/locations/{location}/modelMonitors/{model_monitor}`
     * </pre>
     *
     * <code>
     * string model_monitor = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The modelMonitor.
     */
    public java.lang.String getModelMonitor() {
      java.lang.Object ref = modelMonitor_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        modelMonitor_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. ModelMonitor resource name.
     * Format:
     * `projects/{project}/locations/{location}/modelMonitors/{model_monitor}`
     * </pre>
     *
     * <code>
     * string model_monitor = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for modelMonitor.
     */
    public com.google.protobuf.ByteString getModelMonitorBytes() {
      java.lang.Object ref = modelMonitor_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        modelMonitor_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. ModelMonitor resource name.
     * Format:
     * `projects/{project}/locations/{location}/modelMonitors/{model_monitor}`
     * </pre>
     *
     * <code>
     * string model_monitor = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The modelMonitor to set.
     * @return This builder for chaining.
     */
    public Builder setModelMonitor(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      modelMonitor_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. ModelMonitor resource name.
     * Format:
     * `projects/{project}/locations/{location}/modelMonitors/{model_monitor}`
     * </pre>
     *
     * <code>
     * string model_monitor = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearModelMonitor() {
      modelMonitor_ = getDefaultInstance().getModelMonitor();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. ModelMonitor resource name.
     * Format:
     * `projects/{project}/locations/{location}/modelMonitors/{model_monitor}`
     * </pre>
     *
     * <code>
     * string model_monitor = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for modelMonitor to set.
     * @return This builder for chaining.
     */
    public Builder setModelMonitorBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      modelMonitor_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object modelMonitoringJob_ = "";

    /**
     *
     *
     * <pre>
     * If non-empty, returns the alerts of this model monitoring job.
     * </pre>
     *
     * <code>string model_monitoring_job = 2;</code>
     *
     * @return The modelMonitoringJob.
     */
    public java.lang.String getModelMonitoringJob() {
      java.lang.Object ref = modelMonitoringJob_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        modelMonitoringJob_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * If non-empty, returns the alerts of this model monitoring job.
     * </pre>
     *
     * <code>string model_monitoring_job = 2;</code>
     *
     * @return The bytes for modelMonitoringJob.
     */
    public com.google.protobuf.ByteString getModelMonitoringJobBytes() {
      java.lang.Object ref = modelMonitoringJob_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        modelMonitoringJob_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * If non-empty, returns the alerts of this model monitoring job.
     * </pre>
     *
     * <code>string model_monitoring_job = 2;</code>
     *
     * @param value The modelMonitoringJob to set.
     * @return This builder for chaining.
     */
    public Builder setModelMonitoringJob(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      modelMonitoringJob_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * If non-empty, returns the alerts of this model monitoring job.
     * </pre>
     *
     * <code>string model_monitoring_job = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearModelMonitoringJob() {
      modelMonitoringJob_ = getDefaultInstance().getModelMonitoringJob();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * If non-empty, returns the alerts of this model monitoring job.
     * </pre>
     *
     * <code>string model_monitoring_job = 2;</code>
     *
     * @param value The bytes for modelMonitoringJob to set.
     * @return This builder for chaining.
     */
    public Builder setModelMonitoringJobBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      modelMonitoringJob_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private com.google.type.Interval alertTimeInterval_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.type.Interval,
            com.google.type.Interval.Builder,
            com.google.type.IntervalOrBuilder>
        alertTimeIntervalBuilder_;

    /**
     *
     *
     * <pre>
     * If non-empty, returns the alerts in this time interval.
     * </pre>
     *
     * <code>.google.type.Interval alert_time_interval = 3;</code>
     *
     * @return Whether the alertTimeInterval field is set.
     */
    public boolean hasAlertTimeInterval() {
      return ((bitField0_ & 0x00000004) != 0);
    }

    /**
     *
     *
     * <pre>
     * If non-empty, returns the alerts in this time interval.
     * </pre>
     *
     * <code>.google.type.Interval alert_time_interval = 3;</code>
     *
     * @return The alertTimeInterval.
     */
    public com.google.type.Interval getAlertTimeInterval() {
      if (alertTimeIntervalBuilder_ == null) {
        return alertTimeInterval_ == null
            ? com.google.type.Interval.getDefaultInstance()
            : alertTimeInterval_;
      } else {
        return alertTimeIntervalBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * If non-empty, returns the alerts in this time interval.
     * </pre>
     *
     * <code>.google.type.Interval alert_time_interval = 3;</code>
     */
    public Builder setAlertTimeInterval(com.google.type.Interval value) {
      if (alertTimeIntervalBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        alertTimeInterval_ = value;
      } else {
        alertTimeIntervalBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * If non-empty, returns the alerts in this time interval.
     * </pre>
     *
     * <code>.google.type.Interval alert_time_interval = 3;</code>
     */
    public Builder setAlertTimeInterval(com.google.type.Interval.Builder builderForValue) {
      if (alertTimeIntervalBuilder_ == null) {
        alertTimeInterval_ = builderForValue.build();
      } else {
        alertTimeIntervalBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * If non-empty, returns the alerts in this time interval.
     * </pre>
     *
     * <code>.google.type.Interval alert_time_interval = 3;</code>
     */
    public Builder mergeAlertTimeInterval(com.google.type.Interval value) {
      if (alertTimeIntervalBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && alertTimeInterval_ != null
            && alertTimeInterval_ != com.google.type.Interval.getDefaultInstance()) {
          getAlertTimeIntervalBuilder().mergeFrom(value);
        } else {
          alertTimeInterval_ = value;
        }
      } else {
        alertTimeIntervalBuilder_.mergeFrom(value);
      }
      if (alertTimeInterval_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * If non-empty, returns the alerts in this time interval.
     * </pre>
     *
     * <code>.google.type.Interval alert_time_interval = 3;</code>
     */
    public Builder clearAlertTimeInterval() {
      bitField0_ = (bitField0_ & ~0x00000004);
      alertTimeInterval_ = null;
      if (alertTimeIntervalBuilder_ != null) {
        alertTimeIntervalBuilder_.dispose();
        alertTimeIntervalBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * If non-empty, returns the alerts in this time interval.
     * </pre>
     *
     * <code>.google.type.Interval alert_time_interval = 3;</code>
     */
    public com.google.type.Interval.Builder getAlertTimeIntervalBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getAlertTimeIntervalFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * If non-empty, returns the alerts in this time interval.
     * </pre>
     *
     * <code>.google.type.Interval alert_time_interval = 3;</code>
     */
    public com.google.type.IntervalOrBuilder getAlertTimeIntervalOrBuilder() {
      if (alertTimeIntervalBuilder_ != null) {
        return alertTimeIntervalBuilder_.getMessageOrBuilder();
      } else {
        return alertTimeInterval_ == null
            ? com.google.type.Interval.getDefaultInstance()
            : alertTimeInterval_;
      }
    }

    /**
     *
     *
     * <pre>
     * If non-empty, returns the alerts in this time interval.
     * </pre>
     *
     * <code>.google.type.Interval alert_time_interval = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.type.Interval,
            com.google.type.Interval.Builder,
            com.google.type.IntervalOrBuilder>
        getAlertTimeIntervalFieldBuilder() {
      if (alertTimeIntervalBuilder_ == null) {
        alertTimeIntervalBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.type.Interval,
                com.google.type.Interval.Builder,
                com.google.type.IntervalOrBuilder>(
                getAlertTimeInterval(), getParentForChildren(), isClean());
        alertTimeInterval_ = null;
      }
      return alertTimeIntervalBuilder_;
    }

    private java.lang.Object statsName_ = "";

    /**
     *
     *
     * <pre>
     * If non-empty, returns the alerts of this stats_name.
     * </pre>
     *
     * <code>string stats_name = 4;</code>
     *
     * @return The statsName.
     */
    public java.lang.String getStatsName() {
      java.lang.Object ref = statsName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        statsName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * If non-empty, returns the alerts of this stats_name.
     * </pre>
     *
     * <code>string stats_name = 4;</code>
     *
     * @return The bytes for statsName.
     */
    public com.google.protobuf.ByteString getStatsNameBytes() {
      java.lang.Object ref = statsName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        statsName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * If non-empty, returns the alerts of this stats_name.
     * </pre>
     *
     * <code>string stats_name = 4;</code>
     *
     * @param value The statsName to set.
     * @return This builder for chaining.
     */
    public Builder setStatsName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      statsName_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * If non-empty, returns the alerts of this stats_name.
     * </pre>
     *
     * <code>string stats_name = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearStatsName() {
      statsName_ = getDefaultInstance().getStatsName();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * If non-empty, returns the alerts of this stats_name.
     * </pre>
     *
     * <code>string stats_name = 4;</code>
     *
     * @param value The bytes for statsName to set.
     * @return This builder for chaining.
     */
    public Builder setStatsNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      statsName_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private java.lang.Object objectiveType_ = "";

    /**
     *
     *
     * <pre>
     * If non-empty, returns the alerts of this objective type.
     * Supported monitoring objectives:
     * `raw-feature-drift`
     * `prediction-output-drift`
     * `feature-attribution`
     * </pre>
     *
     * <code>string objective_type = 5;</code>
     *
     * @return The objectiveType.
     */
    public java.lang.String getObjectiveType() {
      java.lang.Object ref = objectiveType_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        objectiveType_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * If non-empty, returns the alerts of this objective type.
     * Supported monitoring objectives:
     * `raw-feature-drift`
     * `prediction-output-drift`
     * `feature-attribution`
     * </pre>
     *
     * <code>string objective_type = 5;</code>
     *
     * @return The bytes for objectiveType.
     */
    public com.google.protobuf.ByteString getObjectiveTypeBytes() {
      java.lang.Object ref = objectiveType_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        objectiveType_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * If non-empty, returns the alerts of this objective type.
     * Supported monitoring objectives:
     * `raw-feature-drift`
     * `prediction-output-drift`
     * `feature-attribution`
     * </pre>
     *
     * <code>string objective_type = 5;</code>
     *
     * @param value The objectiveType to set.
     * @return This builder for chaining.
     */
    public Builder setObjectiveType(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      objectiveType_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * If non-empty, returns the alerts of this objective type.
     * Supported monitoring objectives:
     * `raw-feature-drift`
     * `prediction-output-drift`
     * `feature-attribution`
     * </pre>
     *
     * <code>string objective_type = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearObjectiveType() {
      objectiveType_ = getDefaultInstance().getObjectiveType();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * If non-empty, returns the alerts of this objective type.
     * Supported monitoring objectives:
     * `raw-feature-drift`
     * `prediction-output-drift`
     * `feature-attribution`
     * </pre>
     *
     * <code>string objective_type = 5;</code>
     *
     * @param value The bytes for objectiveType to set.
     * @return This builder for chaining.
     */
    public Builder setObjectiveTypeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      objectiveType_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private int pageSize_;

    /**
     *
     *
     * <pre>
     * The standard list page size.
     * </pre>
     *
     * <code>int32 page_size = 6;</code>
     *
     * @return The pageSize.
     */
    @java.lang.Override
    public int getPageSize() {
      return pageSize_;
    }

    /**
     *
     *
     * <pre>
     * The standard list page size.
     * </pre>
     *
     * <code>int32 page_size = 6;</code>
     *
     * @param value The pageSize to set.
     * @return This builder for chaining.
     */
    public Builder setPageSize(int value) {

      pageSize_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The standard list page size.
     * </pre>
     *
     * <code>int32 page_size = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPageSize() {
      bitField0_ = (bitField0_ & ~0x00000020);
      pageSize_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object pageToken_ = "";

    /**
     *
     *
     * <pre>
     * A page token received from a previous
     * [ModelMonitoringService.SearchModelMonitoringAlerts][google.cloud.aiplatform.v1beta1.ModelMonitoringService.SearchModelMonitoringAlerts]
     * call.
     * </pre>
     *
     * <code>string page_token = 7;</code>
     *
     * @return The pageToken.
     */
    public java.lang.String getPageToken() {
      java.lang.Object ref = pageToken_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        pageToken_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * A page token received from a previous
     * [ModelMonitoringService.SearchModelMonitoringAlerts][google.cloud.aiplatform.v1beta1.ModelMonitoringService.SearchModelMonitoringAlerts]
     * call.
     * </pre>
     *
     * <code>string page_token = 7;</code>
     *
     * @return The bytes for pageToken.
     */
    public com.google.protobuf.ByteString getPageTokenBytes() {
      java.lang.Object ref = pageToken_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        pageToken_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * A page token received from a previous
     * [ModelMonitoringService.SearchModelMonitoringAlerts][google.cloud.aiplatform.v1beta1.ModelMonitoringService.SearchModelMonitoringAlerts]
     * call.
     * </pre>
     *
     * <code>string page_token = 7;</code>
     *
     * @param value The pageToken to set.
     * @return This builder for chaining.
     */
    public Builder setPageToken(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      pageToken_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * A page token received from a previous
     * [ModelMonitoringService.SearchModelMonitoringAlerts][google.cloud.aiplatform.v1beta1.ModelMonitoringService.SearchModelMonitoringAlerts]
     * call.
     * </pre>
     *
     * <code>string page_token = 7;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPageToken() {
      pageToken_ = getDefaultInstance().getPageToken();
      bitField0_ = (bitField0_ & ~0x00000040);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * A page token received from a previous
     * [ModelMonitoringService.SearchModelMonitoringAlerts][google.cloud.aiplatform.v1beta1.ModelMonitoringService.SearchModelMonitoringAlerts]
     * call.
     * </pre>
     *
     * <code>string page_token = 7;</code>
     *
     * @param value The bytes for pageToken to set.
     * @return This builder for chaining.
     */
    public Builder setPageTokenBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      pageToken_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.SearchModelMonitoringAlertsRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.SearchModelMonitoringAlertsRequest)
  private static final com.google.cloud.aiplatform.v1beta1.SearchModelMonitoringAlertsRequest
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.SearchModelMonitoringAlertsRequest();
  }

  public static com.google.cloud.aiplatform.v1beta1.SearchModelMonitoringAlertsRequest
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<SearchModelMonitoringAlertsRequest> PARSER =
      new com.google.protobuf.AbstractParser<SearchModelMonitoringAlertsRequest>() {
        @java.lang.Override
        public SearchModelMonitoringAlertsRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<SearchModelMonitoringAlertsRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<SearchModelMonitoringAlertsRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.SearchModelMonitoringAlertsRequest
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
