/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1beta1/tensorboard_service.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.aiplatform.v1beta1;

/**
 *
 *
 * <pre>
 * Request message for
 * [TensorboardService.WriteTensorboardRunData][google.cloud.aiplatform.v1beta1.TensorboardService.WriteTensorboardRunData].
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1beta1.WriteTensorboardRunDataRequest}
 */
public final class WriteTensorboardRunDataRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.WriteTensorboardRunDataRequest)
    WriteTensorboardRunDataRequestOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use WriteTensorboardRunDataRequest.newBuilder() to construct.
  private WriteTensorboardRunDataRequest(
      com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private WriteTensorboardRunDataRequest() {
    tensorboardRun_ = "";
    timeSeriesData_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new WriteTensorboardRunDataRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1beta1.TensorboardServiceProto
        .internal_static_google_cloud_aiplatform_v1beta1_WriteTensorboardRunDataRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1beta1.TensorboardServiceProto
        .internal_static_google_cloud_aiplatform_v1beta1_WriteTensorboardRunDataRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1beta1.WriteTensorboardRunDataRequest.class,
            com.google.cloud.aiplatform.v1beta1.WriteTensorboardRunDataRequest.Builder.class);
  }

  public static final int TENSORBOARD_RUN_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object tensorboardRun_ = "";

  /**
   *
   *
   * <pre>
   * Required. The resource name of the TensorboardRun to write data to.
   * Format:
   * `projects/{project}/locations/{location}/tensorboards/{tensorboard}/experiments/{experiment}/runs/{run}`
   * </pre>
   *
   * <code>
   * string tensorboard_run = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The tensorboardRun.
   */
  @java.lang.Override
  public java.lang.String getTensorboardRun() {
    java.lang.Object ref = tensorboardRun_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      tensorboardRun_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Required. The resource name of the TensorboardRun to write data to.
   * Format:
   * `projects/{project}/locations/{location}/tensorboards/{tensorboard}/experiments/{experiment}/runs/{run}`
   * </pre>
   *
   * <code>
   * string tensorboard_run = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for tensorboardRun.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getTensorboardRunBytes() {
    java.lang.Object ref = tensorboardRun_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      tensorboardRun_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TIME_SERIES_DATA_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.aiplatform.v1beta1.TimeSeriesData> timeSeriesData_;

  /**
   *
   *
   * <pre>
   * Required. The TensorboardTimeSeries data to write.
   * Values with in a time series are indexed by their step value.
   * Repeated writes to the same step will overwrite the existing value for that
   * step.
   * The upper limit of data points per write request is 5000.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.TimeSeriesData time_series_data = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.aiplatform.v1beta1.TimeSeriesData>
      getTimeSeriesDataList() {
    return timeSeriesData_;
  }

  /**
   *
   *
   * <pre>
   * Required. The TensorboardTimeSeries data to write.
   * Values with in a time series are indexed by their step value.
   * Repeated writes to the same step will overwrite the existing value for that
   * step.
   * The upper limit of data points per write request is 5000.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.TimeSeriesData time_series_data = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.aiplatform.v1beta1.TimeSeriesDataOrBuilder>
      getTimeSeriesDataOrBuilderList() {
    return timeSeriesData_;
  }

  /**
   *
   *
   * <pre>
   * Required. The TensorboardTimeSeries data to write.
   * Values with in a time series are indexed by their step value.
   * Repeated writes to the same step will overwrite the existing value for that
   * step.
   * The upper limit of data points per write request is 5000.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.TimeSeriesData time_series_data = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public int getTimeSeriesDataCount() {
    return timeSeriesData_.size();
  }

  /**
   *
   *
   * <pre>
   * Required. The TensorboardTimeSeries data to write.
   * Values with in a time series are indexed by their step value.
   * Repeated writes to the same step will overwrite the existing value for that
   * step.
   * The upper limit of data points per write request is 5000.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.TimeSeriesData time_series_data = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.TimeSeriesData getTimeSeriesData(int index) {
    return timeSeriesData_.get(index);
  }

  /**
   *
   *
   * <pre>
   * Required. The TensorboardTimeSeries data to write.
   * Values with in a time series are indexed by their step value.
   * Repeated writes to the same step will overwrite the existing value for that
   * step.
   * The upper limit of data points per write request is 5000.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.TimeSeriesData time_series_data = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.TimeSeriesDataOrBuilder getTimeSeriesDataOrBuilder(
      int index) {
    return timeSeriesData_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(tensorboardRun_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, tensorboardRun_);
    }
    for (int i = 0; i < timeSeriesData_.size(); i++) {
      output.writeMessage(2, timeSeriesData_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(tensorboardRun_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, tensorboardRun_);
    }
    for (int i = 0; i < timeSeriesData_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, timeSeriesData_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.WriteTensorboardRunDataRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1beta1.WriteTensorboardRunDataRequest other =
        (com.google.cloud.aiplatform.v1beta1.WriteTensorboardRunDataRequest) obj;

    if (!getTensorboardRun().equals(other.getTensorboardRun())) return false;
    if (!getTimeSeriesDataList().equals(other.getTimeSeriesDataList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + TENSORBOARD_RUN_FIELD_NUMBER;
    hash = (53 * hash) + getTensorboardRun().hashCode();
    if (getTimeSeriesDataCount() > 0) {
      hash = (37 * hash) + TIME_SERIES_DATA_FIELD_NUMBER;
      hash = (53 * hash) + getTimeSeriesDataList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1beta1.WriteTensorboardRunDataRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.WriteTensorboardRunDataRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.WriteTensorboardRunDataRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.WriteTensorboardRunDataRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.WriteTensorboardRunDataRequest parseFrom(
      byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.WriteTensorboardRunDataRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.WriteTensorboardRunDataRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.WriteTensorboardRunDataRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.WriteTensorboardRunDataRequest
      parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.WriteTensorboardRunDataRequest
      parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.WriteTensorboardRunDataRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.WriteTensorboardRunDataRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.aiplatform.v1beta1.WriteTensorboardRunDataRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Request message for
   * [TensorboardService.WriteTensorboardRunData][google.cloud.aiplatform.v1beta1.TensorboardService.WriteTensorboardRunData].
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.WriteTensorboardRunDataRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.WriteTensorboardRunDataRequest)
      com.google.cloud.aiplatform.v1beta1.WriteTensorboardRunDataRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.TensorboardServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_WriteTensorboardRunDataRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.TensorboardServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_WriteTensorboardRunDataRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.WriteTensorboardRunDataRequest.class,
              com.google.cloud.aiplatform.v1beta1.WriteTensorboardRunDataRequest.Builder.class);
    }

    // Construct using
    // com.google.cloud.aiplatform.v1beta1.WriteTensorboardRunDataRequest.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      tensorboardRun_ = "";
      if (timeSeriesDataBuilder_ == null) {
        timeSeriesData_ = java.util.Collections.emptyList();
      } else {
        timeSeriesData_ = null;
        timeSeriesDataBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000002);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1beta1.TensorboardServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_WriteTensorboardRunDataRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.WriteTensorboardRunDataRequest
        getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1beta1.WriteTensorboardRunDataRequest
          .getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.WriteTensorboardRunDataRequest build() {
      com.google.cloud.aiplatform.v1beta1.WriteTensorboardRunDataRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.WriteTensorboardRunDataRequest buildPartial() {
      com.google.cloud.aiplatform.v1beta1.WriteTensorboardRunDataRequest result =
          new com.google.cloud.aiplatform.v1beta1.WriteTensorboardRunDataRequest(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.aiplatform.v1beta1.WriteTensorboardRunDataRequest result) {
      if (timeSeriesDataBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          timeSeriesData_ = java.util.Collections.unmodifiableList(timeSeriesData_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.timeSeriesData_ = timeSeriesData_;
      } else {
        result.timeSeriesData_ = timeSeriesDataBuilder_.build();
      }
    }

    private void buildPartial0(
        com.google.cloud.aiplatform.v1beta1.WriteTensorboardRunDataRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.tensorboardRun_ = tensorboardRun_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1beta1.WriteTensorboardRunDataRequest) {
        return mergeFrom(
            (com.google.cloud.aiplatform.v1beta1.WriteTensorboardRunDataRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(
        com.google.cloud.aiplatform.v1beta1.WriteTensorboardRunDataRequest other) {
      if (other
          == com.google.cloud.aiplatform.v1beta1.WriteTensorboardRunDataRequest
              .getDefaultInstance()) return this;
      if (!other.getTensorboardRun().isEmpty()) {
        tensorboardRun_ = other.tensorboardRun_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (timeSeriesDataBuilder_ == null) {
        if (!other.timeSeriesData_.isEmpty()) {
          if (timeSeriesData_.isEmpty()) {
            timeSeriesData_ = other.timeSeriesData_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureTimeSeriesDataIsMutable();
            timeSeriesData_.addAll(other.timeSeriesData_);
          }
          onChanged();
        }
      } else {
        if (!other.timeSeriesData_.isEmpty()) {
          if (timeSeriesDataBuilder_.isEmpty()) {
            timeSeriesDataBuilder_.dispose();
            timeSeriesDataBuilder_ = null;
            timeSeriesData_ = other.timeSeriesData_;
            bitField0_ = (bitField0_ & ~0x00000002);
            timeSeriesDataBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getTimeSeriesDataFieldBuilder()
                    : null;
          } else {
            timeSeriesDataBuilder_.addAllMessages(other.timeSeriesData_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                tensorboardRun_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                com.google.cloud.aiplatform.v1beta1.TimeSeriesData m =
                    input.readMessage(
                        com.google.cloud.aiplatform.v1beta1.TimeSeriesData.parser(),
                        extensionRegistry);
                if (timeSeriesDataBuilder_ == null) {
                  ensureTimeSeriesDataIsMutable();
                  timeSeriesData_.add(m);
                } else {
                  timeSeriesDataBuilder_.addMessage(m);
                }
                break;
              } // case 18
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object tensorboardRun_ = "";

    /**
     *
     *
     * <pre>
     * Required. The resource name of the TensorboardRun to write data to.
     * Format:
     * `projects/{project}/locations/{location}/tensorboards/{tensorboard}/experiments/{experiment}/runs/{run}`
     * </pre>
     *
     * <code>
     * string tensorboard_run = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The tensorboardRun.
     */
    public java.lang.String getTensorboardRun() {
      java.lang.Object ref = tensorboardRun_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        tensorboardRun_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The resource name of the TensorboardRun to write data to.
     * Format:
     * `projects/{project}/locations/{location}/tensorboards/{tensorboard}/experiments/{experiment}/runs/{run}`
     * </pre>
     *
     * <code>
     * string tensorboard_run = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for tensorboardRun.
     */
    public com.google.protobuf.ByteString getTensorboardRunBytes() {
      java.lang.Object ref = tensorboardRun_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        tensorboardRun_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The resource name of the TensorboardRun to write data to.
     * Format:
     * `projects/{project}/locations/{location}/tensorboards/{tensorboard}/experiments/{experiment}/runs/{run}`
     * </pre>
     *
     * <code>
     * string tensorboard_run = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The tensorboardRun to set.
     * @return This builder for chaining.
     */
    public Builder setTensorboardRun(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      tensorboardRun_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The resource name of the TensorboardRun to write data to.
     * Format:
     * `projects/{project}/locations/{location}/tensorboards/{tensorboard}/experiments/{experiment}/runs/{run}`
     * </pre>
     *
     * <code>
     * string tensorboard_run = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTensorboardRun() {
      tensorboardRun_ = getDefaultInstance().getTensorboardRun();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The resource name of the TensorboardRun to write data to.
     * Format:
     * `projects/{project}/locations/{location}/tensorboards/{tensorboard}/experiments/{experiment}/runs/{run}`
     * </pre>
     *
     * <code>
     * string tensorboard_run = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for tensorboardRun to set.
     * @return This builder for chaining.
     */
    public Builder setTensorboardRunBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      tensorboardRun_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.aiplatform.v1beta1.TimeSeriesData> timeSeriesData_ =
        java.util.Collections.emptyList();

    private void ensureTimeSeriesDataIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        timeSeriesData_ =
            new java.util.ArrayList<com.google.cloud.aiplatform.v1beta1.TimeSeriesData>(
                timeSeriesData_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.TimeSeriesData,
            com.google.cloud.aiplatform.v1beta1.TimeSeriesData.Builder,
            com.google.cloud.aiplatform.v1beta1.TimeSeriesDataOrBuilder>
        timeSeriesDataBuilder_;

    /**
     *
     *
     * <pre>
     * Required. The TensorboardTimeSeries data to write.
     * Values with in a time series are indexed by their step value.
     * Repeated writes to the same step will overwrite the existing value for that
     * step.
     * The upper limit of data points per write request is 5000.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.TimeSeriesData time_series_data = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<com.google.cloud.aiplatform.v1beta1.TimeSeriesData>
        getTimeSeriesDataList() {
      if (timeSeriesDataBuilder_ == null) {
        return java.util.Collections.unmodifiableList(timeSeriesData_);
      } else {
        return timeSeriesDataBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The TensorboardTimeSeries data to write.
     * Values with in a time series are indexed by their step value.
     * Repeated writes to the same step will overwrite the existing value for that
     * step.
     * The upper limit of data points per write request is 5000.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.TimeSeriesData time_series_data = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public int getTimeSeriesDataCount() {
      if (timeSeriesDataBuilder_ == null) {
        return timeSeriesData_.size();
      } else {
        return timeSeriesDataBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The TensorboardTimeSeries data to write.
     * Values with in a time series are indexed by their step value.
     * Repeated writes to the same step will overwrite the existing value for that
     * step.
     * The upper limit of data points per write request is 5000.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.TimeSeriesData time_series_data = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.TimeSeriesData getTimeSeriesData(int index) {
      if (timeSeriesDataBuilder_ == null) {
        return timeSeriesData_.get(index);
      } else {
        return timeSeriesDataBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The TensorboardTimeSeries data to write.
     * Values with in a time series are indexed by their step value.
     * Repeated writes to the same step will overwrite the existing value for that
     * step.
     * The upper limit of data points per write request is 5000.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.TimeSeriesData time_series_data = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setTimeSeriesData(
        int index, com.google.cloud.aiplatform.v1beta1.TimeSeriesData value) {
      if (timeSeriesDataBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTimeSeriesDataIsMutable();
        timeSeriesData_.set(index, value);
        onChanged();
      } else {
        timeSeriesDataBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The TensorboardTimeSeries data to write.
     * Values with in a time series are indexed by their step value.
     * Repeated writes to the same step will overwrite the existing value for that
     * step.
     * The upper limit of data points per write request is 5000.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.TimeSeriesData time_series_data = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setTimeSeriesData(
        int index, com.google.cloud.aiplatform.v1beta1.TimeSeriesData.Builder builderForValue) {
      if (timeSeriesDataBuilder_ == null) {
        ensureTimeSeriesDataIsMutable();
        timeSeriesData_.set(index, builderForValue.build());
        onChanged();
      } else {
        timeSeriesDataBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The TensorboardTimeSeries data to write.
     * Values with in a time series are indexed by their step value.
     * Repeated writes to the same step will overwrite the existing value for that
     * step.
     * The upper limit of data points per write request is 5000.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.TimeSeriesData time_series_data = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addTimeSeriesData(com.google.cloud.aiplatform.v1beta1.TimeSeriesData value) {
      if (timeSeriesDataBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTimeSeriesDataIsMutable();
        timeSeriesData_.add(value);
        onChanged();
      } else {
        timeSeriesDataBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The TensorboardTimeSeries data to write.
     * Values with in a time series are indexed by their step value.
     * Repeated writes to the same step will overwrite the existing value for that
     * step.
     * The upper limit of data points per write request is 5000.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.TimeSeriesData time_series_data = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addTimeSeriesData(
        int index, com.google.cloud.aiplatform.v1beta1.TimeSeriesData value) {
      if (timeSeriesDataBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTimeSeriesDataIsMutable();
        timeSeriesData_.add(index, value);
        onChanged();
      } else {
        timeSeriesDataBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The TensorboardTimeSeries data to write.
     * Values with in a time series are indexed by their step value.
     * Repeated writes to the same step will overwrite the existing value for that
     * step.
     * The upper limit of data points per write request is 5000.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.TimeSeriesData time_series_data = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addTimeSeriesData(
        com.google.cloud.aiplatform.v1beta1.TimeSeriesData.Builder builderForValue) {
      if (timeSeriesDataBuilder_ == null) {
        ensureTimeSeriesDataIsMutable();
        timeSeriesData_.add(builderForValue.build());
        onChanged();
      } else {
        timeSeriesDataBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The TensorboardTimeSeries data to write.
     * Values with in a time series are indexed by their step value.
     * Repeated writes to the same step will overwrite the existing value for that
     * step.
     * The upper limit of data points per write request is 5000.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.TimeSeriesData time_series_data = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addTimeSeriesData(
        int index, com.google.cloud.aiplatform.v1beta1.TimeSeriesData.Builder builderForValue) {
      if (timeSeriesDataBuilder_ == null) {
        ensureTimeSeriesDataIsMutable();
        timeSeriesData_.add(index, builderForValue.build());
        onChanged();
      } else {
        timeSeriesDataBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The TensorboardTimeSeries data to write.
     * Values with in a time series are indexed by their step value.
     * Repeated writes to the same step will overwrite the existing value for that
     * step.
     * The upper limit of data points per write request is 5000.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.TimeSeriesData time_series_data = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addAllTimeSeriesData(
        java.lang.Iterable<? extends com.google.cloud.aiplatform.v1beta1.TimeSeriesData> values) {
      if (timeSeriesDataBuilder_ == null) {
        ensureTimeSeriesDataIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, timeSeriesData_);
        onChanged();
      } else {
        timeSeriesDataBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The TensorboardTimeSeries data to write.
     * Values with in a time series are indexed by their step value.
     * Repeated writes to the same step will overwrite the existing value for that
     * step.
     * The upper limit of data points per write request is 5000.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.TimeSeriesData time_series_data = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearTimeSeriesData() {
      if (timeSeriesDataBuilder_ == null) {
        timeSeriesData_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        timeSeriesDataBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The TensorboardTimeSeries data to write.
     * Values with in a time series are indexed by their step value.
     * Repeated writes to the same step will overwrite the existing value for that
     * step.
     * The upper limit of data points per write request is 5000.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.TimeSeriesData time_series_data = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder removeTimeSeriesData(int index) {
      if (timeSeriesDataBuilder_ == null) {
        ensureTimeSeriesDataIsMutable();
        timeSeriesData_.remove(index);
        onChanged();
      } else {
        timeSeriesDataBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The TensorboardTimeSeries data to write.
     * Values with in a time series are indexed by their step value.
     * Repeated writes to the same step will overwrite the existing value for that
     * step.
     * The upper limit of data points per write request is 5000.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.TimeSeriesData time_series_data = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.TimeSeriesData.Builder getTimeSeriesDataBuilder(
        int index) {
      return getTimeSeriesDataFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * Required. The TensorboardTimeSeries data to write.
     * Values with in a time series are indexed by their step value.
     * Repeated writes to the same step will overwrite the existing value for that
     * step.
     * The upper limit of data points per write request is 5000.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.TimeSeriesData time_series_data = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.TimeSeriesDataOrBuilder getTimeSeriesDataOrBuilder(
        int index) {
      if (timeSeriesDataBuilder_ == null) {
        return timeSeriesData_.get(index);
      } else {
        return timeSeriesDataBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The TensorboardTimeSeries data to write.
     * Values with in a time series are indexed by their step value.
     * Repeated writes to the same step will overwrite the existing value for that
     * step.
     * The upper limit of data points per write request is 5000.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.TimeSeriesData time_series_data = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<? extends com.google.cloud.aiplatform.v1beta1.TimeSeriesDataOrBuilder>
        getTimeSeriesDataOrBuilderList() {
      if (timeSeriesDataBuilder_ != null) {
        return timeSeriesDataBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(timeSeriesData_);
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The TensorboardTimeSeries data to write.
     * Values with in a time series are indexed by their step value.
     * Repeated writes to the same step will overwrite the existing value for that
     * step.
     * The upper limit of data points per write request is 5000.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.TimeSeriesData time_series_data = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.TimeSeriesData.Builder addTimeSeriesDataBuilder() {
      return getTimeSeriesDataFieldBuilder()
          .addBuilder(com.google.cloud.aiplatform.v1beta1.TimeSeriesData.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Required. The TensorboardTimeSeries data to write.
     * Values with in a time series are indexed by their step value.
     * Repeated writes to the same step will overwrite the existing value for that
     * step.
     * The upper limit of data points per write request is 5000.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.TimeSeriesData time_series_data = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.TimeSeriesData.Builder addTimeSeriesDataBuilder(
        int index) {
      return getTimeSeriesDataFieldBuilder()
          .addBuilder(
              index, com.google.cloud.aiplatform.v1beta1.TimeSeriesData.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Required. The TensorboardTimeSeries data to write.
     * Values with in a time series are indexed by their step value.
     * Repeated writes to the same step will overwrite the existing value for that
     * step.
     * The upper limit of data points per write request is 5000.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.TimeSeriesData time_series_data = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<com.google.cloud.aiplatform.v1beta1.TimeSeriesData.Builder>
        getTimeSeriesDataBuilderList() {
      return getTimeSeriesDataFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.TimeSeriesData,
            com.google.cloud.aiplatform.v1beta1.TimeSeriesData.Builder,
            com.google.cloud.aiplatform.v1beta1.TimeSeriesDataOrBuilder>
        getTimeSeriesDataFieldBuilder() {
      if (timeSeriesDataBuilder_ == null) {
        timeSeriesDataBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.TimeSeriesData,
                com.google.cloud.aiplatform.v1beta1.TimeSeriesData.Builder,
                com.google.cloud.aiplatform.v1beta1.TimeSeriesDataOrBuilder>(
                timeSeriesData_,
                ((bitField0_ & 0x00000002) != 0),
                getParentForChildren(),
                isClean());
        timeSeriesData_ = null;
      }
      return timeSeriesDataBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.WriteTensorboardRunDataRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.WriteTensorboardRunDataRequest)
  private static final com.google.cloud.aiplatform.v1beta1.WriteTensorboardRunDataRequest
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.WriteTensorboardRunDataRequest();
  }

  public static com.google.cloud.aiplatform.v1beta1.WriteTensorboardRunDataRequest
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<WriteTensorboardRunDataRequest> PARSER =
      new com.google.protobuf.AbstractParser<WriteTensorboardRunDataRequest>() {
        @java.lang.Override
        public WriteTensorboardRunDataRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<WriteTensorboardRunDataRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<WriteTensorboardRunDataRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.WriteTensorboardRunDataRequest
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
