/*
 * Decompiled with CFR 0.152.
 */
package com.google.logging.v2;

import com.google.api.core.BetaApi;
import com.google.api.pathtemplate.PathTemplate;
import com.google.api.pathtemplate.ValidationException;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class SettingsName
implements ResourceName {
    private static final PathTemplate PROJECT = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/settings");
    private static final PathTemplate ORGANIZATION = PathTemplate.createWithoutUrlEncoding((String)"organizations/{organization}/settings");
    private static final PathTemplate FOLDER = PathTemplate.createWithoutUrlEncoding((String)"folders/{folder}/settings");
    private static final PathTemplate BILLING_ACCOUNT = PathTemplate.createWithoutUrlEncoding((String)"billingAccounts/{billing_account}/settings");
    private volatile Map<String, String> fieldValuesMap;
    private PathTemplate pathTemplate;
    private String fixedValue;
    private final String project;
    private final String organization;
    private final String folder;
    private final String billingAccount;

    @Deprecated
    protected SettingsName() {
        this.project = null;
        this.organization = null;
        this.folder = null;
        this.billingAccount = null;
    }

    private SettingsName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.organization = null;
        this.folder = null;
        this.billingAccount = null;
        this.pathTemplate = PROJECT;
    }

    private SettingsName(OrganizationBuilder builder) {
        this.organization = (String)Preconditions.checkNotNull((Object)builder.getOrganization());
        this.project = null;
        this.folder = null;
        this.billingAccount = null;
        this.pathTemplate = ORGANIZATION;
    }

    private SettingsName(FolderBuilder builder) {
        this.folder = (String)Preconditions.checkNotNull((Object)builder.getFolder());
        this.project = null;
        this.organization = null;
        this.billingAccount = null;
        this.pathTemplate = FOLDER;
    }

    private SettingsName(BillingAccountBuilder builder) {
        this.billingAccount = (String)Preconditions.checkNotNull((Object)builder.getBillingAccount());
        this.project = null;
        this.organization = null;
        this.folder = null;
        this.pathTemplate = BILLING_ACCOUNT;
    }

    public String getProject() {
        return this.project;
    }

    public String getOrganization() {
        return this.organization;
    }

    public String getFolder() {
        return this.folder;
    }

    public String getBillingAccount() {
        return this.billingAccount;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static Builder newProjectBuilder() {
        return new Builder();
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static OrganizationBuilder newOrganizationBuilder() {
        return new OrganizationBuilder();
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static FolderBuilder newFolderBuilder() {
        return new FolderBuilder();
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static BillingAccountBuilder newBillingAccountBuilder() {
        return new BillingAccountBuilder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static SettingsName of(String project) {
        return SettingsName.newBuilder().setProject(project).build();
    }

    @BetaApi(value="The static create methods are not stable yet and may be changed in the future.")
    public static SettingsName ofProjectName(String project) {
        return SettingsName.newBuilder().setProject(project).build();
    }

    @BetaApi(value="The static create methods are not stable yet and may be changed in the future.")
    public static SettingsName ofOrganizationName(String organization) {
        return SettingsName.newOrganizationBuilder().setOrganization(organization).build();
    }

    @BetaApi(value="The static create methods are not stable yet and may be changed in the future.")
    public static SettingsName ofFolderName(String folder) {
        return SettingsName.newFolderBuilder().setFolder(folder).build();
    }

    @BetaApi(value="The static create methods are not stable yet and may be changed in the future.")
    public static SettingsName ofBillingAccountName(String billingAccount) {
        return SettingsName.newBillingAccountBuilder().setBillingAccount(billingAccount).build();
    }

    public static String format(String project) {
        return SettingsName.newBuilder().setProject(project).build().toString();
    }

    @BetaApi(value="The static format methods are not stable yet and may be changed in the future.")
    public static String formatProjectName(String project) {
        return SettingsName.newBuilder().setProject(project).build().toString();
    }

    @BetaApi(value="The static format methods are not stable yet and may be changed in the future.")
    public static String formatOrganizationName(String organization) {
        return SettingsName.newOrganizationBuilder().setOrganization(organization).build().toString();
    }

    @BetaApi(value="The static format methods are not stable yet and may be changed in the future.")
    public static String formatFolderName(String folder) {
        return SettingsName.newFolderBuilder().setFolder(folder).build().toString();
    }

    @BetaApi(value="The static format methods are not stable yet and may be changed in the future.")
    public static String formatBillingAccountName(String billingAccount) {
        return SettingsName.newBillingAccountBuilder().setBillingAccount(billingAccount).build().toString();
    }

    public static SettingsName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        if (PROJECT.matches(formattedString)) {
            Map matchMap = PROJECT.match(formattedString);
            return SettingsName.ofProjectName((String)matchMap.get("project"));
        }
        if (ORGANIZATION.matches(formattedString)) {
            Map matchMap = ORGANIZATION.match(formattedString);
            return SettingsName.ofOrganizationName((String)matchMap.get("organization"));
        }
        if (FOLDER.matches(formattedString)) {
            Map matchMap = FOLDER.match(formattedString);
            return SettingsName.ofFolderName((String)matchMap.get("folder"));
        }
        if (BILLING_ACCOUNT.matches(formattedString)) {
            Map matchMap = BILLING_ACCOUNT.match(formattedString);
            return SettingsName.ofBillingAccountName((String)matchMap.get("billing_account"));
        }
        throw new ValidationException("SettingsName.parse: formattedString not in valid format", new Object[0]);
    }

    public static List<SettingsName> parseList(List<String> formattedStrings) {
        ArrayList<SettingsName> list = new ArrayList<SettingsName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(SettingsName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<SettingsName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (SettingsName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT.matches(formattedString) || ORGANIZATION.matches(formattedString) || FOLDER.matches(formattedString) || BILLING_ACCOUNT.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            SettingsName settingsName = this;
            synchronized (settingsName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.organization != null) {
                        fieldMapBuilder.put((Object)"organization", (Object)this.organization);
                    }
                    if (this.folder != null) {
                        fieldMapBuilder.put((Object)"folder", (Object)this.folder);
                    }
                    if (this.billingAccount != null) {
                        fieldMapBuilder.put((Object)"billing_account", (Object)this.billingAccount);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return this.fixedValue != null ? this.fixedValue : this.pathTemplate.instantiate(this.getFieldValuesMap());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            SettingsName that = (SettingsName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.organization, that.organization) && Objects.equals(this.folder, that.folder) && Objects.equals(this.billingAccount, that.billingAccount);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.fixedValue);
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.organization);
        h *= 1000003;
        h ^= Objects.hashCode(this.folder);
        h *= 1000003;
        return h ^= Objects.hashCode(this.billingAccount);
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static class BillingAccountBuilder {
        private String billingAccount;

        protected BillingAccountBuilder() {
        }

        public String getBillingAccount() {
            return this.billingAccount;
        }

        public BillingAccountBuilder setBillingAccount(String billingAccount) {
            this.billingAccount = billingAccount;
            return this;
        }

        public SettingsName build() {
            return new SettingsName(this);
        }
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static class FolderBuilder {
        private String folder;

        protected FolderBuilder() {
        }

        public String getFolder() {
            return this.folder;
        }

        public FolderBuilder setFolder(String folder) {
            this.folder = folder;
            return this;
        }

        public SettingsName build() {
            return new SettingsName(this);
        }
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static class OrganizationBuilder {
        private String organization;

        protected OrganizationBuilder() {
        }

        public String getOrganization() {
            return this.organization;
        }

        public OrganizationBuilder setOrganization(String organization) {
            this.organization = organization;
            return this;
        }

        public SettingsName build() {
            return new SettingsName(this);
        }
    }

    public static class Builder {
        private String project;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        private Builder(SettingsName settingsName) {
            Preconditions.checkArgument((boolean)Objects.equals(settingsName.pathTemplate, PROJECT), (Object)"toBuilder is only supported when SettingsName has the pattern of projects/{project}/settings");
            this.project = settingsName.project;
        }

        public SettingsName build() {
            return new SettingsName(this);
        }
    }
}

