/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/speech/v2/cloud_speech.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.speech.v2;

/**
 *
 *
 * <pre>
 * A speech recognition result corresponding to a portion of the audio.
 * </pre>
 *
 * Protobuf type {@code google.cloud.speech.v2.SpeechRecognitionResult}
 */
public final class SpeechRecognitionResult extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.speech.v2.SpeechRecognitionResult)
    SpeechRecognitionResultOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use SpeechRecognitionResult.newBuilder() to construct.
  private SpeechRecognitionResult(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private SpeechRecognitionResult() {
    alternatives_ = java.util.Collections.emptyList();
    languageCode_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new SpeechRecognitionResult();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.speech.v2.CloudSpeechProto
        .internal_static_google_cloud_speech_v2_SpeechRecognitionResult_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.speech.v2.CloudSpeechProto
        .internal_static_google_cloud_speech_v2_SpeechRecognitionResult_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.speech.v2.SpeechRecognitionResult.class,
            com.google.cloud.speech.v2.SpeechRecognitionResult.Builder.class);
  }

  private int bitField0_;
  public static final int ALTERNATIVES_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.speech.v2.SpeechRecognitionAlternative> alternatives_;
  /**
   *
   *
   * <pre>
   * May contain one or more recognition hypotheses. These alternatives are
   * ordered in terms of accuracy, with the top (first) alternative being the
   * most probable, as ranked by the recognizer.
   * </pre>
   *
   * <code>repeated .google.cloud.speech.v2.SpeechRecognitionAlternative alternatives = 1;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.speech.v2.SpeechRecognitionAlternative>
      getAlternativesList() {
    return alternatives_;
  }
  /**
   *
   *
   * <pre>
   * May contain one or more recognition hypotheses. These alternatives are
   * ordered in terms of accuracy, with the top (first) alternative being the
   * most probable, as ranked by the recognizer.
   * </pre>
   *
   * <code>repeated .google.cloud.speech.v2.SpeechRecognitionAlternative alternatives = 1;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.speech.v2.SpeechRecognitionAlternativeOrBuilder>
      getAlternativesOrBuilderList() {
    return alternatives_;
  }
  /**
   *
   *
   * <pre>
   * May contain one or more recognition hypotheses. These alternatives are
   * ordered in terms of accuracy, with the top (first) alternative being the
   * most probable, as ranked by the recognizer.
   * </pre>
   *
   * <code>repeated .google.cloud.speech.v2.SpeechRecognitionAlternative alternatives = 1;</code>
   */
  @java.lang.Override
  public int getAlternativesCount() {
    return alternatives_.size();
  }
  /**
   *
   *
   * <pre>
   * May contain one or more recognition hypotheses. These alternatives are
   * ordered in terms of accuracy, with the top (first) alternative being the
   * most probable, as ranked by the recognizer.
   * </pre>
   *
   * <code>repeated .google.cloud.speech.v2.SpeechRecognitionAlternative alternatives = 1;</code>
   */
  @java.lang.Override
  public com.google.cloud.speech.v2.SpeechRecognitionAlternative getAlternatives(int index) {
    return alternatives_.get(index);
  }
  /**
   *
   *
   * <pre>
   * May contain one or more recognition hypotheses. These alternatives are
   * ordered in terms of accuracy, with the top (first) alternative being the
   * most probable, as ranked by the recognizer.
   * </pre>
   *
   * <code>repeated .google.cloud.speech.v2.SpeechRecognitionAlternative alternatives = 1;</code>
   */
  @java.lang.Override
  public com.google.cloud.speech.v2.SpeechRecognitionAlternativeOrBuilder getAlternativesOrBuilder(
      int index) {
    return alternatives_.get(index);
  }

  public static final int CHANNEL_TAG_FIELD_NUMBER = 2;
  private int channelTag_ = 0;
  /**
   *
   *
   * <pre>
   * For multi-channel audio, this is the channel number corresponding to the
   * recognized result for the audio from that channel.
   * For `audio_channel_count` = `N`, its output values can range from `1` to
   * `N`.
   * </pre>
   *
   * <code>int32 channel_tag = 2;</code>
   *
   * @return The channelTag.
   */
  @java.lang.Override
  public int getChannelTag() {
    return channelTag_;
  }

  public static final int RESULT_END_OFFSET_FIELD_NUMBER = 4;
  private com.google.protobuf.Duration resultEndOffset_;
  /**
   *
   *
   * <pre>
   * Time offset of the end of this result relative to the beginning of the
   * audio.
   * </pre>
   *
   * <code>.google.protobuf.Duration result_end_offset = 4;</code>
   *
   * @return Whether the resultEndOffset field is set.
   */
  @java.lang.Override
  public boolean hasResultEndOffset() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Time offset of the end of this result relative to the beginning of the
   * audio.
   * </pre>
   *
   * <code>.google.protobuf.Duration result_end_offset = 4;</code>
   *
   * @return The resultEndOffset.
   */
  @java.lang.Override
  public com.google.protobuf.Duration getResultEndOffset() {
    return resultEndOffset_ == null
        ? com.google.protobuf.Duration.getDefaultInstance()
        : resultEndOffset_;
  }
  /**
   *
   *
   * <pre>
   * Time offset of the end of this result relative to the beginning of the
   * audio.
   * </pre>
   *
   * <code>.google.protobuf.Duration result_end_offset = 4;</code>
   */
  @java.lang.Override
  public com.google.protobuf.DurationOrBuilder getResultEndOffsetOrBuilder() {
    return resultEndOffset_ == null
        ? com.google.protobuf.Duration.getDefaultInstance()
        : resultEndOffset_;
  }

  public static final int LANGUAGE_CODE_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private volatile java.lang.Object languageCode_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The [BCP-47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt)
   * language tag of the language in this result. This language code was
   * detected to have the most likelihood of being spoken in the audio.
   * </pre>
   *
   * <code>string language_code = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The languageCode.
   */
  @java.lang.Override
  public java.lang.String getLanguageCode() {
    java.lang.Object ref = languageCode_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      languageCode_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The [BCP-47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt)
   * language tag of the language in this result. This language code was
   * detected to have the most likelihood of being spoken in the audio.
   * </pre>
   *
   * <code>string language_code = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for languageCode.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getLanguageCodeBytes() {
    java.lang.Object ref = languageCode_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      languageCode_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < alternatives_.size(); i++) {
      output.writeMessage(1, alternatives_.get(i));
    }
    if (channelTag_ != 0) {
      output.writeInt32(2, channelTag_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(4, getResultEndOffset());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(languageCode_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, languageCode_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < alternatives_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, alternatives_.get(i));
    }
    if (channelTag_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(2, channelTag_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getResultEndOffset());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(languageCode_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, languageCode_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.speech.v2.SpeechRecognitionResult)) {
      return super.equals(obj);
    }
    com.google.cloud.speech.v2.SpeechRecognitionResult other =
        (com.google.cloud.speech.v2.SpeechRecognitionResult) obj;

    if (!getAlternativesList().equals(other.getAlternativesList())) return false;
    if (getChannelTag() != other.getChannelTag()) return false;
    if (hasResultEndOffset() != other.hasResultEndOffset()) return false;
    if (hasResultEndOffset()) {
      if (!getResultEndOffset().equals(other.getResultEndOffset())) return false;
    }
    if (!getLanguageCode().equals(other.getLanguageCode())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getAlternativesCount() > 0) {
      hash = (37 * hash) + ALTERNATIVES_FIELD_NUMBER;
      hash = (53 * hash) + getAlternativesList().hashCode();
    }
    hash = (37 * hash) + CHANNEL_TAG_FIELD_NUMBER;
    hash = (53 * hash) + getChannelTag();
    if (hasResultEndOffset()) {
      hash = (37 * hash) + RESULT_END_OFFSET_FIELD_NUMBER;
      hash = (53 * hash) + getResultEndOffset().hashCode();
    }
    hash = (37 * hash) + LANGUAGE_CODE_FIELD_NUMBER;
    hash = (53 * hash) + getLanguageCode().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.speech.v2.SpeechRecognitionResult parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.speech.v2.SpeechRecognitionResult parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.speech.v2.SpeechRecognitionResult parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.speech.v2.SpeechRecognitionResult parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.speech.v2.SpeechRecognitionResult parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.speech.v2.SpeechRecognitionResult parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.speech.v2.SpeechRecognitionResult parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.speech.v2.SpeechRecognitionResult parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.speech.v2.SpeechRecognitionResult parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.speech.v2.SpeechRecognitionResult parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.speech.v2.SpeechRecognitionResult parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.speech.v2.SpeechRecognitionResult parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.speech.v2.SpeechRecognitionResult prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A speech recognition result corresponding to a portion of the audio.
   * </pre>
   *
   * Protobuf type {@code google.cloud.speech.v2.SpeechRecognitionResult}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.speech.v2.SpeechRecognitionResult)
      com.google.cloud.speech.v2.SpeechRecognitionResultOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.speech.v2.CloudSpeechProto
          .internal_static_google_cloud_speech_v2_SpeechRecognitionResult_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.speech.v2.CloudSpeechProto
          .internal_static_google_cloud_speech_v2_SpeechRecognitionResult_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.speech.v2.SpeechRecognitionResult.class,
              com.google.cloud.speech.v2.SpeechRecognitionResult.Builder.class);
    }

    // Construct using com.google.cloud.speech.v2.SpeechRecognitionResult.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getAlternativesFieldBuilder();
        getResultEndOffsetFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (alternativesBuilder_ == null) {
        alternatives_ = java.util.Collections.emptyList();
      } else {
        alternatives_ = null;
        alternativesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      channelTag_ = 0;
      resultEndOffset_ = null;
      if (resultEndOffsetBuilder_ != null) {
        resultEndOffsetBuilder_.dispose();
        resultEndOffsetBuilder_ = null;
      }
      languageCode_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.speech.v2.CloudSpeechProto
          .internal_static_google_cloud_speech_v2_SpeechRecognitionResult_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.speech.v2.SpeechRecognitionResult getDefaultInstanceForType() {
      return com.google.cloud.speech.v2.SpeechRecognitionResult.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.speech.v2.SpeechRecognitionResult build() {
      com.google.cloud.speech.v2.SpeechRecognitionResult result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.speech.v2.SpeechRecognitionResult buildPartial() {
      com.google.cloud.speech.v2.SpeechRecognitionResult result =
          new com.google.cloud.speech.v2.SpeechRecognitionResult(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.speech.v2.SpeechRecognitionResult result) {
      if (alternativesBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          alternatives_ = java.util.Collections.unmodifiableList(alternatives_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.alternatives_ = alternatives_;
      } else {
        result.alternatives_ = alternativesBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.speech.v2.SpeechRecognitionResult result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.channelTag_ = channelTag_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.resultEndOffset_ =
            resultEndOffsetBuilder_ == null ? resultEndOffset_ : resultEndOffsetBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.languageCode_ = languageCode_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.speech.v2.SpeechRecognitionResult) {
        return mergeFrom((com.google.cloud.speech.v2.SpeechRecognitionResult) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.speech.v2.SpeechRecognitionResult other) {
      if (other == com.google.cloud.speech.v2.SpeechRecognitionResult.getDefaultInstance())
        return this;
      if (alternativesBuilder_ == null) {
        if (!other.alternatives_.isEmpty()) {
          if (alternatives_.isEmpty()) {
            alternatives_ = other.alternatives_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureAlternativesIsMutable();
            alternatives_.addAll(other.alternatives_);
          }
          onChanged();
        }
      } else {
        if (!other.alternatives_.isEmpty()) {
          if (alternativesBuilder_.isEmpty()) {
            alternativesBuilder_.dispose();
            alternativesBuilder_ = null;
            alternatives_ = other.alternatives_;
            bitField0_ = (bitField0_ & ~0x00000001);
            alternativesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getAlternativesFieldBuilder()
                    : null;
          } else {
            alternativesBuilder_.addAllMessages(other.alternatives_);
          }
        }
      }
      if (other.getChannelTag() != 0) {
        setChannelTag(other.getChannelTag());
      }
      if (other.hasResultEndOffset()) {
        mergeResultEndOffset(other.getResultEndOffset());
      }
      if (!other.getLanguageCode().isEmpty()) {
        languageCode_ = other.languageCode_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                com.google.cloud.speech.v2.SpeechRecognitionAlternative m =
                    input.readMessage(
                        com.google.cloud.speech.v2.SpeechRecognitionAlternative.parser(),
                        extensionRegistry);
                if (alternativesBuilder_ == null) {
                  ensureAlternativesIsMutable();
                  alternatives_.add(m);
                } else {
                  alternativesBuilder_.addMessage(m);
                }
                break;
              } // case 10
            case 16:
              {
                channelTag_ = input.readInt32();
                bitField0_ |= 0x00000002;
                break;
              } // case 16
            case 34:
              {
                input.readMessage(getResultEndOffsetFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 34
            case 42:
              {
                languageCode_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 42
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.util.List<com.google.cloud.speech.v2.SpeechRecognitionAlternative> alternatives_ =
        java.util.Collections.emptyList();

    private void ensureAlternativesIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        alternatives_ =
            new java.util.ArrayList<com.google.cloud.speech.v2.SpeechRecognitionAlternative>(
                alternatives_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.speech.v2.SpeechRecognitionAlternative,
            com.google.cloud.speech.v2.SpeechRecognitionAlternative.Builder,
            com.google.cloud.speech.v2.SpeechRecognitionAlternativeOrBuilder>
        alternativesBuilder_;

    /**
     *
     *
     * <pre>
     * May contain one or more recognition hypotheses. These alternatives are
     * ordered in terms of accuracy, with the top (first) alternative being the
     * most probable, as ranked by the recognizer.
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v2.SpeechRecognitionAlternative alternatives = 1;</code>
     */
    public java.util.List<com.google.cloud.speech.v2.SpeechRecognitionAlternative>
        getAlternativesList() {
      if (alternativesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(alternatives_);
      } else {
        return alternativesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * May contain one or more recognition hypotheses. These alternatives are
     * ordered in terms of accuracy, with the top (first) alternative being the
     * most probable, as ranked by the recognizer.
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v2.SpeechRecognitionAlternative alternatives = 1;</code>
     */
    public int getAlternativesCount() {
      if (alternativesBuilder_ == null) {
        return alternatives_.size();
      } else {
        return alternativesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * May contain one or more recognition hypotheses. These alternatives are
     * ordered in terms of accuracy, with the top (first) alternative being the
     * most probable, as ranked by the recognizer.
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v2.SpeechRecognitionAlternative alternatives = 1;</code>
     */
    public com.google.cloud.speech.v2.SpeechRecognitionAlternative getAlternatives(int index) {
      if (alternativesBuilder_ == null) {
        return alternatives_.get(index);
      } else {
        return alternativesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * May contain one or more recognition hypotheses. These alternatives are
     * ordered in terms of accuracy, with the top (first) alternative being the
     * most probable, as ranked by the recognizer.
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v2.SpeechRecognitionAlternative alternatives = 1;</code>
     */
    public Builder setAlternatives(
        int index, com.google.cloud.speech.v2.SpeechRecognitionAlternative value) {
      if (alternativesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAlternativesIsMutable();
        alternatives_.set(index, value);
        onChanged();
      } else {
        alternativesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * May contain one or more recognition hypotheses. These alternatives are
     * ordered in terms of accuracy, with the top (first) alternative being the
     * most probable, as ranked by the recognizer.
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v2.SpeechRecognitionAlternative alternatives = 1;</code>
     */
    public Builder setAlternatives(
        int index,
        com.google.cloud.speech.v2.SpeechRecognitionAlternative.Builder builderForValue) {
      if (alternativesBuilder_ == null) {
        ensureAlternativesIsMutable();
        alternatives_.set(index, builderForValue.build());
        onChanged();
      } else {
        alternativesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * May contain one or more recognition hypotheses. These alternatives are
     * ordered in terms of accuracy, with the top (first) alternative being the
     * most probable, as ranked by the recognizer.
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v2.SpeechRecognitionAlternative alternatives = 1;</code>
     */
    public Builder addAlternatives(com.google.cloud.speech.v2.SpeechRecognitionAlternative value) {
      if (alternativesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAlternativesIsMutable();
        alternatives_.add(value);
        onChanged();
      } else {
        alternativesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * May contain one or more recognition hypotheses. These alternatives are
     * ordered in terms of accuracy, with the top (first) alternative being the
     * most probable, as ranked by the recognizer.
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v2.SpeechRecognitionAlternative alternatives = 1;</code>
     */
    public Builder addAlternatives(
        int index, com.google.cloud.speech.v2.SpeechRecognitionAlternative value) {
      if (alternativesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAlternativesIsMutable();
        alternatives_.add(index, value);
        onChanged();
      } else {
        alternativesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * May contain one or more recognition hypotheses. These alternatives are
     * ordered in terms of accuracy, with the top (first) alternative being the
     * most probable, as ranked by the recognizer.
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v2.SpeechRecognitionAlternative alternatives = 1;</code>
     */
    public Builder addAlternatives(
        com.google.cloud.speech.v2.SpeechRecognitionAlternative.Builder builderForValue) {
      if (alternativesBuilder_ == null) {
        ensureAlternativesIsMutable();
        alternatives_.add(builderForValue.build());
        onChanged();
      } else {
        alternativesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * May contain one or more recognition hypotheses. These alternatives are
     * ordered in terms of accuracy, with the top (first) alternative being the
     * most probable, as ranked by the recognizer.
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v2.SpeechRecognitionAlternative alternatives = 1;</code>
     */
    public Builder addAlternatives(
        int index,
        com.google.cloud.speech.v2.SpeechRecognitionAlternative.Builder builderForValue) {
      if (alternativesBuilder_ == null) {
        ensureAlternativesIsMutable();
        alternatives_.add(index, builderForValue.build());
        onChanged();
      } else {
        alternativesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * May contain one or more recognition hypotheses. These alternatives are
     * ordered in terms of accuracy, with the top (first) alternative being the
     * most probable, as ranked by the recognizer.
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v2.SpeechRecognitionAlternative alternatives = 1;</code>
     */
    public Builder addAllAlternatives(
        java.lang.Iterable<? extends com.google.cloud.speech.v2.SpeechRecognitionAlternative>
            values) {
      if (alternativesBuilder_ == null) {
        ensureAlternativesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, alternatives_);
        onChanged();
      } else {
        alternativesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * May contain one or more recognition hypotheses. These alternatives are
     * ordered in terms of accuracy, with the top (first) alternative being the
     * most probable, as ranked by the recognizer.
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v2.SpeechRecognitionAlternative alternatives = 1;</code>
     */
    public Builder clearAlternatives() {
      if (alternativesBuilder_ == null) {
        alternatives_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        alternativesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * May contain one or more recognition hypotheses. These alternatives are
     * ordered in terms of accuracy, with the top (first) alternative being the
     * most probable, as ranked by the recognizer.
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v2.SpeechRecognitionAlternative alternatives = 1;</code>
     */
    public Builder removeAlternatives(int index) {
      if (alternativesBuilder_ == null) {
        ensureAlternativesIsMutable();
        alternatives_.remove(index);
        onChanged();
      } else {
        alternativesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * May contain one or more recognition hypotheses. These alternatives are
     * ordered in terms of accuracy, with the top (first) alternative being the
     * most probable, as ranked by the recognizer.
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v2.SpeechRecognitionAlternative alternatives = 1;</code>
     */
    public com.google.cloud.speech.v2.SpeechRecognitionAlternative.Builder getAlternativesBuilder(
        int index) {
      return getAlternativesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * May contain one or more recognition hypotheses. These alternatives are
     * ordered in terms of accuracy, with the top (first) alternative being the
     * most probable, as ranked by the recognizer.
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v2.SpeechRecognitionAlternative alternatives = 1;</code>
     */
    public com.google.cloud.speech.v2.SpeechRecognitionAlternativeOrBuilder
        getAlternativesOrBuilder(int index) {
      if (alternativesBuilder_ == null) {
        return alternatives_.get(index);
      } else {
        return alternativesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * May contain one or more recognition hypotheses. These alternatives are
     * ordered in terms of accuracy, with the top (first) alternative being the
     * most probable, as ranked by the recognizer.
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v2.SpeechRecognitionAlternative alternatives = 1;</code>
     */
    public java.util.List<
            ? extends com.google.cloud.speech.v2.SpeechRecognitionAlternativeOrBuilder>
        getAlternativesOrBuilderList() {
      if (alternativesBuilder_ != null) {
        return alternativesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(alternatives_);
      }
    }
    /**
     *
     *
     * <pre>
     * May contain one or more recognition hypotheses. These alternatives are
     * ordered in terms of accuracy, with the top (first) alternative being the
     * most probable, as ranked by the recognizer.
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v2.SpeechRecognitionAlternative alternatives = 1;</code>
     */
    public com.google.cloud.speech.v2.SpeechRecognitionAlternative.Builder
        addAlternativesBuilder() {
      return getAlternativesFieldBuilder()
          .addBuilder(com.google.cloud.speech.v2.SpeechRecognitionAlternative.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * May contain one or more recognition hypotheses. These alternatives are
     * ordered in terms of accuracy, with the top (first) alternative being the
     * most probable, as ranked by the recognizer.
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v2.SpeechRecognitionAlternative alternatives = 1;</code>
     */
    public com.google.cloud.speech.v2.SpeechRecognitionAlternative.Builder addAlternativesBuilder(
        int index) {
      return getAlternativesFieldBuilder()
          .addBuilder(
              index, com.google.cloud.speech.v2.SpeechRecognitionAlternative.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * May contain one or more recognition hypotheses. These alternatives are
     * ordered in terms of accuracy, with the top (first) alternative being the
     * most probable, as ranked by the recognizer.
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v2.SpeechRecognitionAlternative alternatives = 1;</code>
     */
    public java.util.List<com.google.cloud.speech.v2.SpeechRecognitionAlternative.Builder>
        getAlternativesBuilderList() {
      return getAlternativesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.speech.v2.SpeechRecognitionAlternative,
            com.google.cloud.speech.v2.SpeechRecognitionAlternative.Builder,
            com.google.cloud.speech.v2.SpeechRecognitionAlternativeOrBuilder>
        getAlternativesFieldBuilder() {
      if (alternativesBuilder_ == null) {
        alternativesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.speech.v2.SpeechRecognitionAlternative,
                com.google.cloud.speech.v2.SpeechRecognitionAlternative.Builder,
                com.google.cloud.speech.v2.SpeechRecognitionAlternativeOrBuilder>(
                alternatives_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
        alternatives_ = null;
      }
      return alternativesBuilder_;
    }

    private int channelTag_;
    /**
     *
     *
     * <pre>
     * For multi-channel audio, this is the channel number corresponding to the
     * recognized result for the audio from that channel.
     * For `audio_channel_count` = `N`, its output values can range from `1` to
     * `N`.
     * </pre>
     *
     * <code>int32 channel_tag = 2;</code>
     *
     * @return The channelTag.
     */
    @java.lang.Override
    public int getChannelTag() {
      return channelTag_;
    }
    /**
     *
     *
     * <pre>
     * For multi-channel audio, this is the channel number corresponding to the
     * recognized result for the audio from that channel.
     * For `audio_channel_count` = `N`, its output values can range from `1` to
     * `N`.
     * </pre>
     *
     * <code>int32 channel_tag = 2;</code>
     *
     * @param value The channelTag to set.
     * @return This builder for chaining.
     */
    public Builder setChannelTag(int value) {

      channelTag_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * For multi-channel audio, this is the channel number corresponding to the
     * recognized result for the audio from that channel.
     * For `audio_channel_count` = `N`, its output values can range from `1` to
     * `N`.
     * </pre>
     *
     * <code>int32 channel_tag = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearChannelTag() {
      bitField0_ = (bitField0_ & ~0x00000002);
      channelTag_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.Duration resultEndOffset_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        resultEndOffsetBuilder_;
    /**
     *
     *
     * <pre>
     * Time offset of the end of this result relative to the beginning of the
     * audio.
     * </pre>
     *
     * <code>.google.protobuf.Duration result_end_offset = 4;</code>
     *
     * @return Whether the resultEndOffset field is set.
     */
    public boolean hasResultEndOffset() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Time offset of the end of this result relative to the beginning of the
     * audio.
     * </pre>
     *
     * <code>.google.protobuf.Duration result_end_offset = 4;</code>
     *
     * @return The resultEndOffset.
     */
    public com.google.protobuf.Duration getResultEndOffset() {
      if (resultEndOffsetBuilder_ == null) {
        return resultEndOffset_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : resultEndOffset_;
      } else {
        return resultEndOffsetBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Time offset of the end of this result relative to the beginning of the
     * audio.
     * </pre>
     *
     * <code>.google.protobuf.Duration result_end_offset = 4;</code>
     */
    public Builder setResultEndOffset(com.google.protobuf.Duration value) {
      if (resultEndOffsetBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        resultEndOffset_ = value;
      } else {
        resultEndOffsetBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Time offset of the end of this result relative to the beginning of the
     * audio.
     * </pre>
     *
     * <code>.google.protobuf.Duration result_end_offset = 4;</code>
     */
    public Builder setResultEndOffset(com.google.protobuf.Duration.Builder builderForValue) {
      if (resultEndOffsetBuilder_ == null) {
        resultEndOffset_ = builderForValue.build();
      } else {
        resultEndOffsetBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Time offset of the end of this result relative to the beginning of the
     * audio.
     * </pre>
     *
     * <code>.google.protobuf.Duration result_end_offset = 4;</code>
     */
    public Builder mergeResultEndOffset(com.google.protobuf.Duration value) {
      if (resultEndOffsetBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && resultEndOffset_ != null
            && resultEndOffset_ != com.google.protobuf.Duration.getDefaultInstance()) {
          getResultEndOffsetBuilder().mergeFrom(value);
        } else {
          resultEndOffset_ = value;
        }
      } else {
        resultEndOffsetBuilder_.mergeFrom(value);
      }
      if (resultEndOffset_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Time offset of the end of this result relative to the beginning of the
     * audio.
     * </pre>
     *
     * <code>.google.protobuf.Duration result_end_offset = 4;</code>
     */
    public Builder clearResultEndOffset() {
      bitField0_ = (bitField0_ & ~0x00000004);
      resultEndOffset_ = null;
      if (resultEndOffsetBuilder_ != null) {
        resultEndOffsetBuilder_.dispose();
        resultEndOffsetBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Time offset of the end of this result relative to the beginning of the
     * audio.
     * </pre>
     *
     * <code>.google.protobuf.Duration result_end_offset = 4;</code>
     */
    public com.google.protobuf.Duration.Builder getResultEndOffsetBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getResultEndOffsetFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Time offset of the end of this result relative to the beginning of the
     * audio.
     * </pre>
     *
     * <code>.google.protobuf.Duration result_end_offset = 4;</code>
     */
    public com.google.protobuf.DurationOrBuilder getResultEndOffsetOrBuilder() {
      if (resultEndOffsetBuilder_ != null) {
        return resultEndOffsetBuilder_.getMessageOrBuilder();
      } else {
        return resultEndOffset_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : resultEndOffset_;
      }
    }
    /**
     *
     *
     * <pre>
     * Time offset of the end of this result relative to the beginning of the
     * audio.
     * </pre>
     *
     * <code>.google.protobuf.Duration result_end_offset = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        getResultEndOffsetFieldBuilder() {
      if (resultEndOffsetBuilder_ == null) {
        resultEndOffsetBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>(
                getResultEndOffset(), getParentForChildren(), isClean());
        resultEndOffset_ = null;
      }
      return resultEndOffsetBuilder_;
    }

    private java.lang.Object languageCode_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The [BCP-47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt)
     * language tag of the language in this result. This language code was
     * detected to have the most likelihood of being spoken in the audio.
     * </pre>
     *
     * <code>string language_code = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The languageCode.
     */
    public java.lang.String getLanguageCode() {
      java.lang.Object ref = languageCode_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        languageCode_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The [BCP-47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt)
     * language tag of the language in this result. This language code was
     * detected to have the most likelihood of being spoken in the audio.
     * </pre>
     *
     * <code>string language_code = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for languageCode.
     */
    public com.google.protobuf.ByteString getLanguageCodeBytes() {
      java.lang.Object ref = languageCode_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        languageCode_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The [BCP-47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt)
     * language tag of the language in this result. This language code was
     * detected to have the most likelihood of being spoken in the audio.
     * </pre>
     *
     * <code>string language_code = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The languageCode to set.
     * @return This builder for chaining.
     */
    public Builder setLanguageCode(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      languageCode_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The [BCP-47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt)
     * language tag of the language in this result. This language code was
     * detected to have the most likelihood of being spoken in the audio.
     * </pre>
     *
     * <code>string language_code = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLanguageCode() {
      languageCode_ = getDefaultInstance().getLanguageCode();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The [BCP-47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt)
     * language tag of the language in this result. This language code was
     * detected to have the most likelihood of being spoken in the audio.
     * </pre>
     *
     * <code>string language_code = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for languageCode to set.
     * @return This builder for chaining.
     */
    public Builder setLanguageCodeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      languageCode_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.speech.v2.SpeechRecognitionResult)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.speech.v2.SpeechRecognitionResult)
  private static final com.google.cloud.speech.v2.SpeechRecognitionResult DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.speech.v2.SpeechRecognitionResult();
  }

  public static com.google.cloud.speech.v2.SpeechRecognitionResult getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<SpeechRecognitionResult> PARSER =
      new com.google.protobuf.AbstractParser<SpeechRecognitionResult>() {
        @java.lang.Override
        public SpeechRecognitionResult parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<SpeechRecognitionResult> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<SpeechRecognitionResult> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.speech.v2.SpeechRecognitionResult getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
