/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.debugging.sourcemap.FilePosition;
import com.google.javascript.jscomp.CodeConsumer;
import com.google.javascript.jscomp.CodeGenerator;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.SourceMap;
import com.google.javascript.jscomp.TypedCodeGenerator;
import com.google.javascript.rhino.Node;
import java.nio.charset.Charset;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;

class CodePrinter {
    static final int DEFAULT_LINE_LENGTH_THRESHOLD = 500;

    CodePrinter() {
    }

    private static String toSource(Node root, Format outputFormat, boolean lineBreak, int lineLengthThreshold, SourceMap sourceMap, SourceMap.DetailLevel sourceMapDetailLevel, Charset outputCharset, boolean tagAsStrict) {
        CodeGenerator cg;
        Preconditions.checkState((sourceMapDetailLevel != null ? 1 : 0) != 0);
        boolean createSourceMap = sourceMap != null;
        MappedCodePrinter mcp = outputFormat == Format.COMPACT ? new CompactCodePrinter(lineBreak, lineLengthThreshold, createSourceMap, sourceMapDetailLevel) : new PrettyCodePrinter(lineLengthThreshold, createSourceMap, sourceMapDetailLevel);
        CodeGenerator codeGenerator = cg = outputFormat == Format.TYPED ? new TypedCodeGenerator(mcp, outputCharset) : new CodeGenerator(mcp, outputCharset);
        if (tagAsStrict) {
            cg.tagAsStrict();
        }
        cg.add(root);
        mcp.endFile();
        String code = mcp.getCode();
        if (createSourceMap) {
            mcp.generateSourceMap(sourceMap);
        }
        return code;
    }

    static enum Format {
        COMPACT,
        PRETTY,
        TYPED;

    }

    static class Builder {
        private final Node root;
        private boolean prettyPrint = false;
        private boolean lineBreak = false;
        private boolean outputTypes = false;
        private int lineLengthThreshold = 500;
        private SourceMap sourceMap = null;
        private SourceMap.DetailLevel sourceMapDetailLevel = SourceMap.DetailLevel.ALL;
        private Charset outputCharset = null;
        private boolean tagAsStrict;

        Builder(Node node) {
            this.root = node;
        }

        Builder setPrettyPrint(boolean prettyPrint) {
            this.prettyPrint = prettyPrint;
            return this;
        }

        Builder setLineBreak(boolean lineBreak) {
            this.lineBreak = lineBreak;
            return this;
        }

        Builder setOutputTypes(boolean outputTypes) {
            this.outputTypes = outputTypes;
            return this;
        }

        Builder setLineLengthThreshold(int threshold) {
            this.lineLengthThreshold = threshold;
            return this;
        }

        Builder setSourceMap(SourceMap sourceMap) {
            this.sourceMap = sourceMap;
            return this;
        }

        Builder setSourceMapDetailLevel(SourceMap.DetailLevel level) {
            Preconditions.checkState((level != null ? 1 : 0) != 0);
            this.sourceMapDetailLevel = level;
            return this;
        }

        Builder setOutputCharset(Charset outCharset) {
            this.outputCharset = outCharset;
            return this;
        }

        Builder setTagAsStrict(boolean tagAsStrict) {
            this.tagAsStrict = tagAsStrict;
            return this;
        }

        String build() {
            if (this.root == null) {
                throw new IllegalStateException("Cannot build without root node being specified");
            }
            Format outputFormat = this.outputTypes ? Format.TYPED : (this.prettyPrint ? Format.PRETTY : Format.COMPACT);
            return CodePrinter.toSource(this.root, outputFormat, this.lineBreak, this.lineLengthThreshold, this.sourceMap, this.sourceMapDetailLevel, this.outputCharset, this.tagAsStrict);
        }
    }

    static class CompactCodePrinter
    extends MappedCodePrinter {
        private final boolean lineBreak;
        private int lineStartPosition = 0;
        private int preferredBreakPosition = 0;

        private CompactCodePrinter(boolean lineBreak, int lineLengthThreshold, boolean createSrcMap, SourceMap.DetailLevel sourceMapDetailLevel) {
            super(lineLengthThreshold, createSrcMap, sourceMapDetailLevel);
            this.lineBreak = lineBreak;
        }

        @Override
        void append(String str) {
            this.code.append(str);
            this.lineLength += str.length();
        }

        @Override
        void startNewLine() {
            if (this.lineLength > 0) {
                this.code.append('\n');
                this.lineLength = 0;
                ++this.lineIndex;
                this.lineStartPosition = this.code.length();
            }
        }

        @Override
        void maybeLineBreak() {
            char ch;
            int len;
            if (this.lineBreak && this.sawFunction) {
                this.startNewLine();
                this.sawFunction = false;
            }
            if (this.preferredBreakPosition == (len = this.code.length()) - 1 && (ch = this.code.charAt(len - 1)) == ';') {
                this.preferredBreakPosition = len;
            }
            this.maybeCutLine();
        }

        @Override
        void maybeCutLine() {
            if (this.lineLength > this.lineLengthThreshold) {
                if (this.preferredBreakPosition > this.lineStartPosition && this.preferredBreakPosition < this.lineStartPosition + this.lineLength) {
                    int position = this.preferredBreakPosition;
                    this.code.insert(position, '\n');
                    this.reportLineCut(this.lineIndex, position - this.lineStartPosition);
                    ++this.lineIndex;
                    this.lineLength -= position - this.lineStartPosition;
                    this.lineStartPosition = position + 1;
                } else {
                    this.startNewLine();
                }
            }
        }

        @Override
        void notePreferredLineBreak() {
            this.preferredBreakPosition = this.code.length();
        }
    }

    static class PrettyCodePrinter
    extends MappedCodePrinter {
        static final String INDENT = "  ";
        private int indent = 0;

        private PrettyCodePrinter(int lineLengthThreshold, boolean createSourceMap, SourceMap.DetailLevel sourceMapDetailLevel) {
            super(lineLengthThreshold, createSourceMap, sourceMapDetailLevel);
        }

        @Override
        void append(String str) {
            if (this.lineLength == 0) {
                for (int i = 0; i < this.indent; ++i) {
                    this.code.append(INDENT);
                    this.lineLength += INDENT.length();
                }
            }
            this.code.append(str);
            this.lineLength += str.length();
        }

        @Override
        void startNewLine() {
            if (this.lineLength > 0) {
                this.code.append('\n');
                ++this.lineIndex;
                this.lineLength = 0;
            }
        }

        @Override
        void maybeLineBreak() {
            this.maybeCutLine();
        }

        @Override
        void maybeCutLine() {
            if (this.lineLength > this.lineLengthThreshold) {
                this.startNewLine();
            }
        }

        @Override
        void endLine() {
            this.startNewLine();
        }

        @Override
        void appendBlockStart() {
            this.append(" {");
            ++this.indent;
        }

        @Override
        void appendBlockEnd() {
            this.endLine();
            --this.indent;
            this.append("}");
        }

        @Override
        void listSeparator() {
            this.add(", ");
            this.maybeLineBreak();
        }

        @Override
        void endFunction(boolean statementContext) {
            super.endFunction(statementContext);
            if (statementContext) {
                this.startNewLine();
            }
        }

        @Override
        void beginCaseBody() {
            super.beginCaseBody();
            ++this.indent;
            this.endLine();
        }

        @Override
        void endCaseBody() {
            super.endCaseBody();
            --this.indent;
            this.endStatement();
        }

        @Override
        void appendOp(String op, boolean binOp) {
            if (binOp) {
                if (this.getLastChar() != ' ') {
                    this.append(" ");
                }
                this.append(op);
                this.append(" ");
            } else {
                this.append(op);
            }
        }

        @Override
        boolean shouldPreserveExtraBlocks() {
            return true;
        }

        private Node getTryForCatch(Node n) {
            return n.getParent().getParent();
        }

        @Override
        boolean breakAfterBlockFor(Node n, boolean isStatementContext) {
            Preconditions.checkState((boolean)n.isBlock());
            Node parent = n.getParent();
            if (parent != null) {
                int type = parent.getType();
                switch (type) {
                    case 114: {
                        return false;
                    }
                    case 105: {
                        return false;
                    }
                    case 77: {
                        return n != parent.getFirstChild();
                    }
                    case 120: {
                        return !NodeUtil.hasFinally(this.getTryForCatch(parent));
                    }
                    case 108: {
                        return n == parent.getLastChild();
                    }
                }
            }
            return true;
        }

        @Override
        void endFile() {
            this.maybeEndStatement();
        }
    }

    private static abstract class MappedCodePrinter
    extends CodeConsumer {
        private final Deque<Mapping> mappings;
        private final List<Mapping> allMappings;
        private final boolean createSrcMap;
        private final SourceMap.DetailLevel sourceMapDetailLevel;
        protected final StringBuilder code = new StringBuilder(1024);
        protected final int lineLengthThreshold;
        protected int lineLength = 0;
        protected int lineIndex = 0;

        MappedCodePrinter(int lineLengthThreshold, boolean createSrcMap, SourceMap.DetailLevel sourceMapDetailLevel) {
            Preconditions.checkState((sourceMapDetailLevel != null ? 1 : 0) != 0);
            this.lineLengthThreshold = lineLengthThreshold <= 0 ? Integer.MAX_VALUE : lineLengthThreshold;
            this.createSrcMap = createSrcMap;
            this.sourceMapDetailLevel = sourceMapDetailLevel;
            this.mappings = createSrcMap ? new ArrayDeque() : null;
            this.allMappings = createSrcMap ? new ArrayList() : null;
        }

        @Override
        void startSourceMapping(Node node) {
            Preconditions.checkState((this.sourceMapDetailLevel != null ? 1 : 0) != 0);
            Preconditions.checkState((node != null ? 1 : 0) != 0);
            if (this.createSrcMap && node.getSourceFileName() != null && node.getLineno() > 0 && this.sourceMapDetailLevel.apply(node)) {
                int line = this.getCurrentLineIndex();
                int index = this.getCurrentCharIndex();
                Preconditions.checkState((line >= 0 ? 1 : 0) != 0);
                Mapping mapping = new Mapping();
                mapping.node = node;
                mapping.start = new FilePosition(line, index);
                this.mappings.push(mapping);
                this.allMappings.add(mapping);
            }
        }

        @Override
        void endSourceMapping(Node node) {
            if (this.createSrcMap && !this.mappings.isEmpty() && this.mappings.peek().node == node) {
                Mapping mapping = this.mappings.pop();
                int line = this.getCurrentLineIndex();
                int index = this.getCurrentCharIndex();
                Preconditions.checkState((line >= 0 ? 1 : 0) != 0);
                mapping.end = new FilePosition(line, index);
            }
        }

        void generateSourceMap(SourceMap map) {
            if (this.createSrcMap) {
                for (Mapping mapping : this.allMappings) {
                    map.addMapping(mapping.node, mapping.start, mapping.end);
                }
            }
        }

        void reportLineCut(int lineIndex, int charIndex) {
            if (this.createSrcMap) {
                for (Mapping mapping : this.allMappings) {
                    mapping.start = this.convertPosition(mapping.start, lineIndex, charIndex);
                    if (mapping.end == null) continue;
                    mapping.end = this.convertPosition(mapping.end, lineIndex, charIndex);
                }
            }
        }

        private FilePosition convertPosition(FilePosition position, int lineIndex, int characterPosition) {
            int originalLine = position.getLine();
            int originalChar = position.getColumn();
            if (originalLine == lineIndex && originalChar >= characterPosition) {
                return new FilePosition(originalLine + 1, originalChar - characterPosition);
            }
            return position;
        }

        public String getCode() {
            return this.code.toString();
        }

        @Override
        char getLastChar() {
            return this.code.length() > 0 ? this.code.charAt(this.code.length() - 1) : (char)'\u0000';
        }

        protected final int getCurrentCharIndex() {
            return this.lineLength;
        }

        protected final int getCurrentLineIndex() {
            return this.lineIndex;
        }

        private static class Mapping {
            Node node;
            FilePosition start;
            FilePosition end;

            private Mapping() {
            }
        }
    }
}

