/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.collect.ImmutableSet;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;
import java.util.Set;
import java.util.logging.Logger;

class ExpandJqueryAliases
extends NodeTraversal.AbstractPostOrderCallback
implements CompilerPass {
    private final AbstractCompiler compiler;
    private static final Logger logger = Logger.getLogger(ExpandJqueryAliases.class.getName());
    private static final Set<String> JqueryExtendNames = ImmutableSet.of((Object)"jQuery.extend", (Object)"jQuery.fn.extend", (Object)"jQuery.prototype.extend");

    ExpandJqueryAliases(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    public static boolean isJqueryExtendReference(Node n, String qname) {
        if (JqueryExtendNames.contains(qname)) {
            Node firstArgument = n.getNext();
            if (firstArgument == null) {
                return false;
            }
            Node secondArgument = firstArgument.getNext();
            if (firstArgument.isObjectLit() && secondArgument == null || firstArgument.isName() && secondArgument != null && secondArgument.isObjectLit() && secondArgument.getNext() == null) {
                return true;
            }
        }
        return false;
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        String qName;
        Node callTarget;
        if (this.compiler.getCodingConvention().isPrototypeAlias(n)) {
            this.replaceJqueryPrototypeAlias(n);
        } else if (n.isCall() && ExpandJqueryAliases.isJqueryExtendReference(callTarget = n.getFirstChild(), qName = callTarget.getQualifiedName())) {
            this.replaceJqueryExtendCall(n);
        }
    }

    @Override
    public void process(Node externs, Node root) {
        logger.fine("Expanding Jquery Aliases");
        NodeTraversal.traverse(this.compiler, root, this);
    }

    private void replaceJqueryPrototypeAlias(Node n) {
        Node fn = n.getLastChild();
        if (fn != null) {
            n.replaceChild(fn, IR.string("prototype"));
            this.compiler.reportCodeChange();
        }
    }

    private void replaceJqueryExtendCall(Node n) {
        Node callTarget = n.getFirstChild();
        Node objectToExtend = callTarget.getNext();
        Node extendArg = objectToExtend.getNext();
        if (extendArg == null) {
            extendArg = objectToExtend;
            objectToExtend = callTarget.getFirstChild();
        }
        if (!extendArg.hasChildren()) {
            return;
        }
        Node fncBlock = IR.block().srcref(n);
        while (extendArg.hasChildren()) {
            Node currentProp = extendArg.removeFirstChild();
            Node propValue = currentProp.removeFirstChild();
            Node newProp = currentProp.isQuotedString() ? IR.getelem(objectToExtend.cloneTree(), currentProp).srcref(currentProp) : IR.getprop(objectToExtend.cloneTree(), currentProp).srcref(currentProp);
            Node assignNode = IR.assign(newProp, propValue).srcref(currentProp);
            fncBlock.addChildToBack(IR.exprResult(assignNode).srcref(currentProp));
        }
        Node targetVal = "jQuery.prototype".equals(objectToExtend.getQualifiedName()) ? objectToExtend.getFirstChild().cloneTree() : objectToExtend.cloneTree();
        fncBlock.addChildToBack(IR.returnNode(targetVal).srcref(targetVal));
        Node fnc = IR.function(IR.name("").srcref(n), IR.paramList().srcref(n), fncBlock);
        n.replaceChild(callTarget, fnc);
        n.putBooleanProp(50, true);
        while (fnc.getNext() != null) {
            n.removeChildAfter(fnc);
        }
        this.compiler.reportCodeChange();
    }
}

