/*
 * Decompiled with CFR 0.152.
 */
package com.google.visualization.datasource.datatable.value;

import com.google.visualization.datasource.datatable.value.NullValueException;
import com.google.visualization.datasource.datatable.value.Value;
import com.google.visualization.datasource.datatable.value.ValueType;
import com.ibm.icu.util.Calendar;
import com.ibm.icu.util.GregorianCalendar;
import com.ibm.icu.util.TimeZone;

public class DateValue
extends Value {
    private static final DateValue NULL_VALUE = new DateValue();
    private int year;
    private int month;
    private int dayOfMonth;
    private Integer hashCode = null;

    public static DateValue getNullValue() {
        return NULL_VALUE;
    }

    private DateValue() {
        this.hashCode = 0;
    }

    public DateValue(int n, int n2, int n3) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(n, n2, n3);
        if (gregorianCalendar.get(1) != n || gregorianCalendar.get(2) != n2 || gregorianCalendar.get(5) != n3) {
            throw new IllegalArgumentException("Invalid java date (yyyy-MM-dd): " + n + '-' + n2 + '-' + n3);
        }
        this.year = n;
        this.month = n2;
        this.dayOfMonth = n3;
    }

    public DateValue(GregorianCalendar gregorianCalendar) {
        if (!gregorianCalendar.getTimeZone().equals((Object)TimeZone.getTimeZone((String)"GMT"))) {
            throw new IllegalArgumentException("Can't create DateValue from GregorianCalendar that is not GMT.");
        }
        this.year = gregorianCalendar.get(1);
        this.month = gregorianCalendar.get(2);
        this.dayOfMonth = gregorianCalendar.get(5);
    }

    @Override
    public ValueType getType() {
        return ValueType.DATE;
    }

    public String toString() {
        if (this == NULL_VALUE) {
            return "null";
        }
        return String.format("%1$d-%2$02d-%3$02d", this.year, this.month + 1, this.dayOfMonth);
    }

    @Override
    public boolean isNull() {
        return this == NULL_VALUE;
    }

    @Override
    public int compareTo(Value value) {
        if (this == value) {
            return 0;
        }
        DateValue dateValue = (DateValue)value;
        if (this.isNull()) {
            return -1;
        }
        if (dateValue.isNull()) {
            return 1;
        }
        if (this.year > dateValue.year) {
            return 1;
        }
        if (this.year < dateValue.year) {
            return -1;
        }
        if (this.month > dateValue.month) {
            return 1;
        }
        if (this.month < dateValue.month) {
            return -1;
        }
        if (this.dayOfMonth > dateValue.dayOfMonth) {
            return 1;
        }
        if (this.dayOfMonth < dateValue.dayOfMonth) {
            return -1;
        }
        return 0;
    }

    @Override
    public int hashCode() {
        if (null != this.hashCode) {
            return this.hashCode;
        }
        int n = 1279;
        n = n * 17 + this.year;
        n = n * 17 + this.month;
        n = n * 17 + this.dayOfMonth;
        this.hashCode = n;
        return this.hashCode;
    }

    public Calendar getObjectToFormat() {
        if (this.isNull()) {
            return null;
        }
        GregorianCalendar gregorianCalendar = new GregorianCalendar(this.year, this.month, this.dayOfMonth);
        gregorianCalendar.setTimeZone(TimeZone.getTimeZone((String)"GMT"));
        return gregorianCalendar;
    }

    public int getYear() {
        if (this.isNull()) {
            throw new NullValueException("This object is null");
        }
        return this.year;
    }

    public int getMonth() {
        if (this.isNull()) {
            throw new NullValueException("This object is null");
        }
        return this.month;
    }

    public int getDayOfMonth() {
        if (this.isNull()) {
            throw new NullValueException("This object is null");
        }
        return this.dayOfMonth;
    }

    @Override
    protected String innerToQueryString() {
        return "DATE '" + this.year + "-" + (this.month + 1) + "-" + this.dayOfMonth + "'";
    }
}

