/*
 * Decompiled with CFR 0.152.
 */
package com.google.visualization.datasource.datatable.value;

import com.google.common.collect.Maps;
import com.google.visualization.datasource.base.TypeMismatchException;
import com.google.visualization.datasource.datatable.value.BooleanValue;
import com.google.visualization.datasource.datatable.value.DateTimeValue;
import com.google.visualization.datasource.datatable.value.DateValue;
import com.google.visualization.datasource.datatable.value.NumberValue;
import com.google.visualization.datasource.datatable.value.TextValue;
import com.google.visualization.datasource.datatable.value.TimeOfDayValue;
import com.google.visualization.datasource.datatable.value.Value;
import com.ibm.icu.util.GregorianCalendar;
import java.util.Map;

public enum ValueType {
    BOOLEAN("BOOLEAN"),
    NUMBER("NUMBER"),
    TEXT("STRING"),
    DATE("DATE"),
    TIMEOFDAY("TIMEOFDAY"),
    DATETIME("DATETIME");

    private String typeCode;
    private static Map<String, ValueType> typeCodeToValueType;

    private ValueType(String string2) {
        this.typeCode = string2;
    }

    String getTypeCode() {
        return this.typeCode;
    }

    public String getTypeCodeLowerCase() {
        return this.typeCode.toLowerCase();
    }

    static ValueType getByTypeCode(String string) {
        return typeCodeToValueType.get(string);
    }

    public Value createValue(Object object) throws TypeMismatchException {
        Value value = null;
        if (object == null) {
            value = Value.getNullValueFromValueType(this);
        } else if (this == TEXT && (object instanceof String || object == null)) {
            value = new TextValue((String)object);
        } else if (this == NUMBER && object instanceof Number) {
            value = new NumberValue(((Number)object).doubleValue());
        } else if (this == BOOLEAN && object instanceof Boolean) {
            value = (Boolean)object != false ? BooleanValue.TRUE : BooleanValue.FALSE;
        } else if (this == DATE && object instanceof GregorianCalendar) {
            value = new DateValue((GregorianCalendar)object);
        } else if (this == DATETIME && object instanceof GregorianCalendar) {
            value = new DateTimeValue((GregorianCalendar)object);
        } else if (this == TIMEOFDAY && object instanceof GregorianCalendar) {
            value = new TimeOfDayValue((GregorianCalendar)object);
        }
        if (value == null) {
            throw new TypeMismatchException("Value type mismatch.");
        }
        return value;
    }

    static {
        typeCodeToValueType = Maps.newHashMap();
        for (ValueType valueType : ValueType.values()) {
            typeCodeToValueType.put(valueType.typeCode, valueType);
        }
    }
}

