/*
 * Decompiled with CFR 0.152.
 */
package com.google.visualization.datasource.query;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.visualization.datasource.base.InvalidQueryException;
import com.google.visualization.datasource.base.MessagesEnum;
import com.google.visualization.datasource.query.AbstractColumn;
import com.google.visualization.datasource.query.AggregationColumn;
import com.google.visualization.datasource.query.QueryFilter;
import com.google.visualization.datasource.query.QueryFormat;
import com.google.visualization.datasource.query.QueryGroup;
import com.google.visualization.datasource.query.QueryLabels;
import com.google.visualization.datasource.query.QueryOptions;
import com.google.visualization.datasource.query.QueryPivot;
import com.google.visualization.datasource.query.QuerySelection;
import com.google.visualization.datasource.query.QuerySort;
import com.google.visualization.datasource.query.ScalarFunctionColumn;
import com.google.visualization.datasource.query.SimpleColumn;
import com.ibm.icu.util.ULocale;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.text.StrBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Query {
    private static final Log log = LogFactory.getLog((String)Query.class.getName());
    private QuerySort sort = null;
    protected QuerySelection selection = null;
    private QueryFilter filter = null;
    private QueryGroup group = null;
    private QueryPivot pivot = null;
    private int rowSkipping = 0;
    private int rowLimit = -1;
    private int rowOffset = 0;
    private QueryOptions options = null;
    private QueryLabels labels = null;
    private QueryFormat userFormatOptions = null;
    private ULocale localeForUserMessages = null;

    private static <T> void checkForDuplicates(List<T> list, String string, ULocale uLocale) throws InvalidQueryException {
        for (int i = 0; i < list.size(); ++i) {
            T t = list.get(i);
            for (int j = i + 1; j < list.size(); ++j) {
                if (!t.equals(list.get(j))) continue;
                String[] stringArray = new String[]{t.toString(), string};
                String string2 = MessagesEnum.COLUMN_ONLY_ONCE.getMessageWithArgs(uLocale, stringArray);
                log.error((Object)string2);
                throw new InvalidQueryException(string2);
            }
        }
    }

    public void setSort(QuerySort querySort) {
        this.sort = querySort;
    }

    public QuerySort getSort() {
        return this.sort;
    }

    public boolean hasSort() {
        return this.sort != null && !this.sort.isEmpty();
    }

    public void setSelection(QuerySelection querySelection) {
        this.selection = querySelection;
    }

    public QuerySelection getSelection() {
        return this.selection;
    }

    public boolean hasSelection() {
        return this.selection != null && !this.selection.isEmpty();
    }

    public void setFilter(QueryFilter queryFilter) {
        this.filter = queryFilter;
    }

    public QueryFilter getFilter() {
        return this.filter;
    }

    public boolean hasFilter() {
        return this.filter != null;
    }

    public void setGroup(QueryGroup queryGroup) {
        this.group = queryGroup;
    }

    public void setPivot(QueryPivot queryPivot) {
        this.pivot = queryPivot;
    }

    public QueryGroup getGroup() {
        return this.group;
    }

    public boolean hasGroup() {
        return this.group != null && !this.group.getColumnIds().isEmpty();
    }

    public QueryPivot getPivot() {
        return this.pivot;
    }

    public boolean hasPivot() {
        return this.pivot != null && !this.pivot.getColumnIds().isEmpty();
    }

    public int getRowSkipping() {
        return this.rowSkipping;
    }

    public void setRowSkipping(int n) throws InvalidQueryException {
        if (n < 0) {
            String string = MessagesEnum.INVALID_SKIPPING.getMessageWithArgs(this.localeForUserMessages, Integer.toString(n));
            log.error((Object)string);
            throw new InvalidQueryException(string);
        }
        this.rowSkipping = n;
    }

    public void copyRowSkipping(Query query) {
        this.rowSkipping = query.getRowSkipping();
    }

    public boolean hasRowSkipping() {
        return this.rowSkipping > 0;
    }

    public int getRowLimit() {
        return this.rowLimit;
    }

    public void setRowLimit(int n) throws InvalidQueryException {
        if (n < -1) {
            String string = "Invalid value for row limit: " + n;
            log.error((Object)string);
            throw new InvalidQueryException(string);
        }
        this.rowLimit = n;
    }

    public void copyRowLimit(Query query) {
        this.rowLimit = query.getRowLimit();
    }

    public boolean hasRowLimit() {
        return this.rowLimit > -1;
    }

    public int getRowOffset() {
        return this.rowOffset;
    }

    public void setRowOffset(int n) throws InvalidQueryException {
        if (n < 0) {
            String string = MessagesEnum.INVALID_OFFSET.getMessageWithArgs(this.localeForUserMessages, Integer.toString(n));
            log.error((Object)string);
            throw new InvalidQueryException(string);
        }
        this.rowOffset = n;
    }

    public void copyRowOffset(Query query) {
        this.rowOffset = query.getRowOffset();
    }

    public boolean hasRowOffset() {
        return this.rowOffset > 0;
    }

    public QueryFormat getUserFormatOptions() {
        return this.userFormatOptions;
    }

    public void setUserFormatOptions(QueryFormat queryFormat) {
        this.userFormatOptions = queryFormat;
    }

    public boolean hasUserFormatOptions() {
        return this.userFormatOptions != null && !this.userFormatOptions.getColumns().isEmpty();
    }

    public QueryLabels getLabels() {
        return this.labels;
    }

    public void setLabels(QueryLabels queryLabels) {
        this.labels = queryLabels;
    }

    public boolean hasLabels() {
        return this.labels != null && !this.labels.getColumns().isEmpty();
    }

    public QueryOptions getOptions() {
        return this.options;
    }

    public void setOptions(QueryOptions queryOptions) {
        this.options = queryOptions;
    }

    public boolean hasOptions() {
        return this.options != null && !this.options.isDefault();
    }

    public boolean isEmpty() {
        return !this.hasSort() && !this.hasSelection() && !this.hasFilter() && !this.hasGroup() && !this.hasPivot() && !this.hasRowSkipping() && !this.hasRowLimit() && !this.hasRowOffset() && !this.hasUserFormatOptions() && !this.hasLabels() && !this.hasOptions();
    }

    public void setLocaleForUserMessages(ULocale uLocale) {
        this.localeForUserMessages = uLocale;
    }

    public void copyFrom(Query query) {
        this.setSort(query.getSort());
        this.setSelection(query.getSelection());
        this.setFilter(query.getFilter());
        this.setGroup(query.getGroup());
        this.setPivot(query.getPivot());
        this.copyRowSkipping(query);
        this.copyRowLimit(query);
        this.copyRowOffset(query);
        this.setUserFormatOptions(query.getUserFormatOptions());
        this.setLabels(query.getLabels());
        this.setOptions(query.getOptions());
    }

    public void validate() throws InvalidQueryException {
        HashSet hashSet;
        Object object5;
        Object object2;
        Object object4;
        ArrayList arrayList = this.hasGroup() ? this.group.getColumnIds() : Lists.newArrayList();
        ArrayList arrayList2 = this.hasGroup() ? this.group.getColumns() : Lists.newArrayList();
        ArrayList arrayList3 = this.hasPivot() ? this.pivot.getColumnIds() : Lists.newArrayList();
        ArrayList arrayList4 = this.hasSelection() ? this.selection.getColumns() : Lists.newArrayList();
        ArrayList arrayList5 = this.hasSelection() ? this.selection.getAggregationColumns() : Lists.newArrayList();
        ArrayList arrayList6 = this.hasSelection() ? this.selection.getSimpleColumns() : Lists.newArrayList();
        ArrayList arrayList7 = this.hasSelection() ? this.selection.getScalarFunctionColumns() : Lists.newArrayList();
        arrayList7.addAll(arrayList7);
        ArrayList arrayList8 = this.hasSort() ? this.sort.getColumns() : Lists.newArrayList();
        ArrayList arrayList9 = this.hasSort() ? this.sort.getAggregationColumns() : Lists.newArrayList();
        Query.checkForDuplicates(arrayList4, "SELECT", this.localeForUserMessages);
        Query.checkForDuplicates(arrayList8, "ORDER BY", this.localeForUserMessages);
        Query.checkForDuplicates(arrayList, "GROUP BY", this.localeForUserMessages);
        Query.checkForDuplicates(arrayList3, "PIVOT", this.localeForUserMessages);
        if (this.hasGroup()) {
            object4 = this.group.getColumns().iterator();
            while (object4.hasNext()) {
                AbstractColumn object32 = object4.next();
                if (object32.getAllAggregationColumns().isEmpty()) continue;
                String string = MessagesEnum.CANNOT_BE_IN_GROUP_BY.getMessageWithArgs(this.localeForUserMessages, object32.toQueryString());
                log.error((Object)string);
                throw new InvalidQueryException(string);
            }
        }
        if (this.hasPivot()) {
            object4 = this.pivot.getColumns().iterator();
            while (object4.hasNext()) {
                AbstractColumn abstractColumn = (AbstractColumn)object4.next();
                if (abstractColumn.getAllAggregationColumns().isEmpty()) continue;
                String string = MessagesEnum.CANNOT_BE_IN_PIVOT.getMessageWithArgs(this.localeForUserMessages, abstractColumn.toQueryString());
                log.error((Object)string);
                throw new InvalidQueryException(string);
            }
        }
        if (this.hasFilter() && !(object4 = this.filter.getAggregationColumns()).isEmpty()) {
            String string = MessagesEnum.CANNOT_BE_IN_WHERE.getMessageWithArgs(this.localeForUserMessages, ((AggregationColumn)object4.get(0)).toQueryString());
            log.error((Object)string);
            throw new InvalidQueryException(string);
        }
        for (SimpleColumn simpleColumn : arrayList6) {
            object2 = simpleColumn.getColumnId();
            for (Object object3 : arrayList5) {
                if (!((String)object2).equals(((AggregationColumn)object3).getAggregatedColumn().getId())) continue;
                String string = MessagesEnum.SELECT_WITH_AND_WITHOUT_AGG.getMessageWithArgs(this.localeForUserMessages, new String[]{object2});
                log.error((Object)string);
                throw new InvalidQueryException(string);
            }
        }
        if (!arrayList5.isEmpty()) {
            for (AbstractColumn abstractColumn : arrayList4) {
                this.checkSelectedColumnWithGrouping(arrayList2, abstractColumn);
            }
        }
        if (this.hasSelection() && this.hasGroup()) {
            for (AggregationColumn aggregationColumn : arrayList5) {
                object2 = aggregationColumn.getAggregatedColumn().getId();
                if (!arrayList.contains(object2)) continue;
                object5 = MessagesEnum.COL_AGG_NOT_IN_SELECT.getMessageWithArgs(this.localeForUserMessages, new String[]{object2});
                log.error(object5);
                throw new InvalidQueryException((String)object5);
            }
        }
        if (this.hasGroup() && arrayList5.isEmpty()) {
            object4 = MessagesEnum.CANNOT_GROUP_WITNOUT_AGG.getMessage(this.localeForUserMessages);
            log.error(object4);
            throw new InvalidQueryException((String)object4);
        }
        if (this.hasPivot() && arrayList5.isEmpty()) {
            object4 = MessagesEnum.CANNOT_PIVOT_WITNOUT_AGG.getMessage(this.localeForUserMessages);
            log.error(object4);
            throw new InvalidQueryException((String)object4);
        }
        if (this.hasSort() && !arrayList5.isEmpty()) {
            for (AbstractColumn abstractColumn : this.sort.getColumns()) {
                object2 = MessagesEnum.COL_IN_ORDER_MUST_BE_IN_SELECT.getMessageWithArgs(this.localeForUserMessages, abstractColumn.toQueryString());
                this.checkColumnInList(this.selection.getColumns(), abstractColumn, (String)object2);
            }
        }
        if (this.hasPivot()) {
            for (AggregationColumn aggregationColumn : arrayList5) {
                object2 = aggregationColumn.getAggregatedColumn().getId();
                if (!arrayList3.contains(object2)) continue;
                object5 = MessagesEnum.AGG_IN_SELECT_NO_PIVOT.getMessageWithArgs(this.localeForUserMessages, new String[]{object2});
                log.error(object5);
                throw new InvalidQueryException((String)object5);
            }
        }
        if (this.hasGroup() && this.hasPivot()) {
            for (String string : arrayList) {
                if (!arrayList3.contains(string)) continue;
                object2 = MessagesEnum.NO_COL_IN_GROUP_AND_PIVOT.getMessageWithArgs(this.localeForUserMessages, string);
                log.error(object2);
                throw new InvalidQueryException((String)object2);
            }
        }
        if (this.hasPivot() && !arrayList9.isEmpty()) {
            object4 = (AggregationColumn)arrayList9.get(0);
            String string = MessagesEnum.NO_AGG_IN_ORDER_WHEN_PIVOT.getMessageWithArgs(this.localeForUserMessages, ((AggregationColumn)object4).getAggregatedColumn().getId());
            log.error((Object)string);
            throw new InvalidQueryException(string);
        }
        for (AggregationColumn aggregationColumn : arrayList9) {
            object2 = MessagesEnum.AGG_IN_ORDER_NOT_IN_SELECT.getMessageWithArgs(this.localeForUserMessages, aggregationColumn.toQueryString());
            this.checkColumnInList(arrayList5, aggregationColumn, (String)object2);
        }
        object4 = this.hasLabels() ? this.labels.getColumns() : Sets.newHashSet();
        Set<Object> set = hashSet = this.hasUserFormatOptions() ? this.userFormatOptions.getColumns() : Sets.newHashSet();
        if (this.hasSelection()) {
            Object object3;
            object2 = object4.iterator();
            while (object2.hasNext()) {
                object5 = (AbstractColumn)object2.next();
                if (arrayList4.contains(object5)) continue;
                object3 = MessagesEnum.LABEL_COL_NOT_IN_SELECT.getMessageWithArgs(this.localeForUserMessages, ((AbstractColumn)object5).toQueryString());
                log.error(object3);
                throw new InvalidQueryException((String)object3);
            }
            for (Object object5 : hashSet) {
                if (arrayList4.contains(object5)) continue;
                object3 = MessagesEnum.FORMAT_COL_NOT_IN_SELECT.getMessageWithArgs(this.localeForUserMessages, ((AbstractColumn)object5).toQueryString());
                log.error(object3);
                throw new InvalidQueryException((String)object3);
            }
        }
    }

    public Set<String> getAllColumnIds() {
        HashSet hashSet = Sets.newHashSet();
        if (this.hasSelection()) {
            for (AbstractColumn abstractColumn : this.selection.getColumns()) {
                hashSet.addAll(abstractColumn.getAllSimpleColumnIds());
            }
        }
        if (this.hasSort()) {
            for (AbstractColumn abstractColumn : this.sort.getColumns()) {
                hashSet.addAll(abstractColumn.getAllSimpleColumnIds());
            }
        }
        if (this.hasGroup()) {
            hashSet.addAll(this.getGroup().getSimpleColumnIds());
        }
        if (this.hasPivot()) {
            hashSet.addAll(this.getPivot().getSimpleColumnIds());
        }
        if (this.hasFilter()) {
            hashSet.addAll(this.getFilter().getAllColumnIds());
        }
        if (this.hasLabels()) {
            for (AbstractColumn abstractColumn : this.labels.getColumns()) {
                hashSet.addAll(abstractColumn.getAllSimpleColumnIds());
            }
        }
        if (this.hasUserFormatOptions()) {
            for (AbstractColumn abstractColumn : this.userFormatOptions.getColumns()) {
                hashSet.addAll(abstractColumn.getAllSimpleColumnIds());
            }
        }
        return hashSet;
    }

    public Set<AggregationColumn> getAllAggregations() {
        HashSet hashSet = Sets.newHashSet();
        if (this.hasSelection()) {
            hashSet.addAll(this.selection.getAggregationColumns());
        }
        if (this.hasSort()) {
            for (AbstractColumn abstractColumn : this.sort.getColumns()) {
                if (!(abstractColumn instanceof AggregationColumn)) continue;
                hashSet.add((AggregationColumn)abstractColumn);
            }
        }
        if (this.hasLabels()) {
            for (AbstractColumn abstractColumn : this.labels.getColumns()) {
                if (!(abstractColumn instanceof AggregationColumn)) continue;
                hashSet.add((AggregationColumn)abstractColumn);
            }
        }
        if (this.hasUserFormatOptions()) {
            for (AbstractColumn abstractColumn : this.userFormatOptions.getColumns()) {
                if (!(abstractColumn instanceof AggregationColumn)) continue;
                hashSet.add((AggregationColumn)abstractColumn);
            }
        }
        return hashSet;
    }

    public Set<ScalarFunctionColumn> getAllScalarFunctionsColumns() {
        HashSet hashSet = Sets.newHashSet();
        if (this.hasSelection()) {
            hashSet.addAll(this.selection.getScalarFunctionColumns());
        }
        if (this.hasFilter()) {
            hashSet.addAll(this.filter.getScalarFunctionColumns());
        }
        if (this.hasGroup()) {
            hashSet.addAll(this.group.getScalarFunctionColumns());
        }
        if (this.hasPivot()) {
            hashSet.addAll(this.pivot.getScalarFunctionColumns());
        }
        if (this.hasSort()) {
            hashSet.addAll(this.sort.getScalarFunctionColumns());
        }
        if (this.hasLabels()) {
            hashSet.addAll(this.labels.getScalarFunctionColumns());
        }
        if (this.hasUserFormatOptions()) {
            hashSet.addAll(this.userFormatOptions.getScalarFunctionColumns());
        }
        return hashSet;
    }

    private void checkColumnInList(List<? extends AbstractColumn> list, AbstractColumn abstractColumn, String string) throws InvalidQueryException {
        if (list.contains(abstractColumn)) {
            return;
        }
        if (abstractColumn instanceof ScalarFunctionColumn) {
            List<AbstractColumn> list2 = ((ScalarFunctionColumn)abstractColumn).getColumns();
            for (AbstractColumn abstractColumn2 : list2) {
                this.checkColumnInList(list, abstractColumn2, string);
            }
        } else {
            log.error((Object)string);
            throw new InvalidQueryException(string);
        }
    }

    private void checkSelectedColumnWithGrouping(List<AbstractColumn> list, AbstractColumn abstractColumn) throws InvalidQueryException {
        if (abstractColumn instanceof SimpleColumn) {
            if (!list.contains(abstractColumn)) {
                String string = MessagesEnum.ADD_COL_TO_GROUP_BY_OR_AGG.getMessageWithArgs(this.localeForUserMessages, abstractColumn.getId());
                log.error((Object)string);
                throw new InvalidQueryException(string);
            }
        } else if (abstractColumn instanceof ScalarFunctionColumn && !list.contains(abstractColumn)) {
            List<AbstractColumn> list2 = ((ScalarFunctionColumn)abstractColumn).getColumns();
            for (AbstractColumn abstractColumn2 : list2) {
                this.checkSelectedColumnWithGrouping(list, abstractColumn2);
            }
        }
    }

    public int hashCode() {
        int n = 1;
        n = 37 * n + (this.filter == null ? 0 : this.filter.hashCode());
        n = 37 * n + (this.group == null ? 0 : this.group.hashCode());
        n = 37 * n + (this.labels == null ? 0 : this.labels.hashCode());
        n = 37 * n + (this.options == null ? 0 : this.options.hashCode());
        n = 37 * n + (this.pivot == null ? 0 : this.pivot.hashCode());
        n = 37 * n + this.rowSkipping;
        n = 37 * n + this.rowLimit;
        n = 37 * n + this.rowOffset;
        n = 37 * n + (this.selection == null ? 0 : this.selection.hashCode());
        n = 37 * n + (this.sort == null ? 0 : this.sort.hashCode());
        n = 37 * n + (this.userFormatOptions == null ? 0 : this.userFormatOptions.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Query query = (Query)object;
        if (this.filter == null ? query.filter != null : !this.filter.equals(query.filter)) {
            return false;
        }
        if (this.group == null ? query.group != null : !this.group.equals(query.group)) {
            return false;
        }
        if (this.labels == null ? query.labels != null : !this.labels.equals(query.labels)) {
            return false;
        }
        if (this.options == null ? query.options != null : !this.options.equals(query.options)) {
            return false;
        }
        if (this.pivot == null ? query.pivot != null : !this.pivot.equals(query.pivot)) {
            return false;
        }
        if (this.rowSkipping != query.rowSkipping) {
            return false;
        }
        if (this.rowLimit != query.rowLimit) {
            return false;
        }
        if (this.rowOffset != query.rowOffset) {
            return false;
        }
        if (this.selection == null ? query.selection != null : !this.selection.equals(query.selection)) {
            return false;
        }
        if (this.sort == null ? query.sort != null : !this.sort.equals(query.sort)) {
            return false;
        }
        return !(this.userFormatOptions == null ? query.userFormatOptions != null : !this.userFormatOptions.equals(query.userFormatOptions));
    }

    static String columnListToQueryString(List<AbstractColumn> list) {
        StrBuilder strBuilder = new StrBuilder();
        ArrayList arrayList = Lists.newArrayList();
        for (AbstractColumn abstractColumn : list) {
            arrayList.add(abstractColumn.toQueryString());
        }
        strBuilder.appendWithSeparators((Collection)arrayList, ", ");
        return strBuilder.toString();
    }

    static String stringToQueryStringLiteral(String string) {
        if (string.contains("\"")) {
            if (string.contains("'")) {
                throw new RuntimeException("Cannot represent string that contains both double-quotes (\")  and single quotes (').");
            }
            return "'" + string + "'";
        }
        return "\"" + string + "\"";
    }

    public String toQueryString() {
        ArrayList arrayList = Lists.newArrayList();
        if (this.hasSelection()) {
            arrayList.add("SELECT " + this.selection.toQueryString());
        }
        if (this.hasFilter()) {
            arrayList.add("WHERE " + this.filter.toQueryString());
        }
        if (this.hasGroup()) {
            arrayList.add("GROUP BY " + this.group.toQueryString());
        }
        if (this.hasPivot()) {
            arrayList.add("PIVOT " + this.pivot.toQueryString());
        }
        if (this.hasSort()) {
            arrayList.add("ORDER BY " + this.sort.toQueryString());
        }
        if (this.hasRowSkipping()) {
            arrayList.add("SKIPPING " + this.rowSkipping);
        }
        if (this.hasRowLimit()) {
            arrayList.add("LIMIT " + this.rowLimit);
        }
        if (this.hasRowOffset()) {
            arrayList.add("OFFSET " + this.rowOffset);
        }
        if (this.hasLabels()) {
            arrayList.add("LABEL " + this.labels.toQueryString());
        }
        if (this.hasUserFormatOptions()) {
            arrayList.add("FORMAT " + this.userFormatOptions.toQueryString());
        }
        if (this.hasOptions()) {
            arrayList.add("OPTIONS " + this.options.toQueryString());
        }
        StrBuilder strBuilder = new StrBuilder();
        strBuilder.appendWithSeparators((Collection)arrayList, " ");
        return strBuilder.toString();
    }
}

