/*
 * Decompiled with CFR 0.152.
 */
package com.google.visualization.datasource.query.engine;

import com.google.common.collect.Ordering;
import com.google.visualization.datasource.datatable.value.Value;
import com.google.visualization.datasource.query.AggregationColumn;
import com.google.visualization.datasource.query.engine.ColumnTitle;
import com.google.visualization.datasource.query.engine.RowTitle;
import java.util.Comparator;
import java.util.List;

class GroupingComparators {
    public static final Comparator<List<Value>> VALUE_LIST_COMPARATOR = new Comparator<List<Value>>(){

        @Override
        public int compare(List<Value> list, List<Value> list2) {
            int n;
            int n2;
            for (n2 = 0; n2 < Math.min(list.size(), list2.size()); ++n2) {
                n = list.get(n2).compareTo(list2.get(n2));
                if (n == 0) continue;
                return n;
            }
            n = n2 < list.size() ? 1 : (n2 < list2.size() ? -1 : 0);
            return n;
        }
    };
    public static final Comparator<RowTitle> ROW_TITLE_COMPARATOR = new Comparator<RowTitle>(){

        @Override
        public int compare(RowTitle rowTitle, RowTitle rowTitle2) {
            return VALUE_LIST_COMPARATOR.compare(rowTitle.values, rowTitle2.values);
        }
    };

    public static Comparator<ColumnTitle> getColumnTitleDynamicComparator(List<AggregationColumn> list) {
        return new ColumnTitleDynamicComparator(list);
    }

    private GroupingComparators() {
    }

    private static class ColumnTitleDynamicComparator
    implements Comparator<ColumnTitle> {
        private Comparator<AggregationColumn> aggregationsComparator;

        public ColumnTitleDynamicComparator(List<AggregationColumn> list) {
            this.aggregationsComparator = Ordering.explicit(list);
        }

        @Override
        public int compare(ColumnTitle columnTitle, ColumnTitle columnTitle2) {
            int n = VALUE_LIST_COMPARATOR.compare(columnTitle.getValues(), columnTitle2.getValues());
            if (n != 0) {
                return n;
            }
            return this.aggregationsComparator.compare(columnTitle.aggregation, columnTitle2.aggregation);
        }
    }
}

