/*
 * Decompiled with CFR 0.152.
 */
package com.google.visualization.datasource.query.engine;

import com.google.visualization.datasource.datatable.TableRow;
import com.google.visualization.datasource.datatable.value.Value;
import com.google.visualization.datasource.query.AbstractColumn;
import com.google.visualization.datasource.query.ColumnLookup;
import com.google.visualization.datasource.query.ColumnSort;
import com.google.visualization.datasource.query.QuerySort;
import com.google.visualization.datasource.query.SortOrder;
import com.ibm.icu.util.ULocale;
import java.util.Comparator;
import java.util.List;

class TableRowComparator
implements Comparator<TableRow> {
    private AbstractColumn[] sortColumns;
    private SortOrder[] sortColumnOrder;
    private Comparator<Value> valueComparator;
    private ColumnLookup columnLookup;

    public TableRowComparator(QuerySort querySort, ULocale uLocale, ColumnLookup columnLookup) {
        this.valueComparator = Value.getLocalizedComparator(uLocale);
        this.columnLookup = columnLookup;
        List<ColumnSort> list = querySort.getSortColumns();
        this.sortColumns = new AbstractColumn[list.size()];
        this.sortColumnOrder = new SortOrder[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            ColumnSort columnSort = list.get(i);
            this.sortColumns[i] = columnSort.getColumn();
            this.sortColumnOrder[i] = columnSort.getOrder();
        }
    }

    @Override
    public int compare(TableRow tableRow, TableRow tableRow2) {
        for (int i = 0; i < this.sortColumns.length; ++i) {
            AbstractColumn abstractColumn = this.sortColumns[i];
            int n = this.valueComparator.compare(abstractColumn.getValue(this.columnLookup, tableRow), abstractColumn.getValue(this.columnLookup, tableRow2));
            if (n == 0) continue;
            return this.sortColumnOrder[i] == SortOrder.ASCENDING ? n : -n;
        }
        return 0;
    }
}

