/*
 * Decompiled with CFR 0.152.
 */
package com.google.visualization.datasource.query.engine;

import com.google.visualization.datasource.datatable.value.NumberValue;
import com.google.visualization.datasource.datatable.value.Value;
import com.google.visualization.datasource.datatable.value.ValueType;
import com.google.visualization.datasource.query.AggregationType;

class ValueAggregator {
    private ValueType valueType;
    private Value max;
    private Value min;
    private double sum = 0.0;
    private int count = 0;

    public ValueAggregator(ValueType valueType) {
        this.valueType = valueType;
        this.min = this.max = Value.getNullValueFromValueType(valueType);
    }

    public void aggregate(Value value) {
        if (!value.isNull()) {
            ++this.count;
            if (this.valueType == ValueType.NUMBER) {
                this.sum += ((NumberValue)value).getValue();
            }
            if (this.count == 1) {
                this.max = this.min = value;
            } else {
                this.max = this.max.compareTo(value) >= 0 ? this.max : value;
                this.min = this.min.compareTo(value) <= 0 ? this.min : value;
            }
        } else if (this.count == 0) {
            this.min = this.max = value;
        }
    }

    private double getSum() {
        if (this.valueType != ValueType.NUMBER) {
            throw new UnsupportedOperationException();
        }
        return this.sum;
    }

    private Double getAverage() {
        if (this.valueType != ValueType.NUMBER) {
            throw new UnsupportedOperationException();
        }
        return this.count > 0 ? Double.valueOf(this.sum / (double)this.count) : null;
    }

    public Value getValue(AggregationType aggregationType) {
        Value value;
        switch (aggregationType) {
            case AVG: {
                value = this.count != 0 ? new NumberValue(this.getAverage()) : NumberValue.getNullValue();
                break;
            }
            case COUNT: {
                value = new NumberValue(this.count);
                break;
            }
            case MAX: {
                value = this.max;
                if (this.count != 0) break;
                value = Value.getNullValueFromValueType(value.getType());
                break;
            }
            case MIN: {
                value = this.min;
                if (this.count != 0) break;
                value = Value.getNullValueFromValueType(value.getType());
                break;
            }
            case SUM: {
                value = this.count != 0 ? new NumberValue(this.getSum()) : NumberValue.getNullValue();
                break;
            }
            default: {
                throw new RuntimeException("Invalid AggregationType");
            }
        }
        return value;
    }
}

