/*
 * Decompiled with CFR 0.152.
 */
package com.google.visualization.datasource.query.scalarfunction;

import com.google.visualization.datasource.base.InvalidQueryException;
import com.google.visualization.datasource.datatable.value.DateTimeValue;
import com.google.visualization.datasource.datatable.value.DateValue;
import com.google.visualization.datasource.datatable.value.NumberValue;
import com.google.visualization.datasource.datatable.value.Value;
import com.google.visualization.datasource.datatable.value.ValueType;
import com.google.visualization.datasource.query.scalarfunction.ScalarFunction;
import com.ibm.icu.util.Calendar;
import com.ibm.icu.util.GregorianCalendar;
import com.ibm.icu.util.TimeZone;
import java.util.Date;
import java.util.List;

public class DateDiff
implements ScalarFunction {
    private static final String FUNCTION_NAME = "dateDiff";
    private static final DateDiff INSTANCE = new DateDiff();

    private DateDiff() {
    }

    public static DateDiff getInstance() {
        return INSTANCE;
    }

    @Override
    public String getFunctionName() {
        return FUNCTION_NAME;
    }

    @Override
    public Value evaluate(List<Value> list) {
        Value value = list.get(0);
        Value value2 = list.get(1);
        if (value.isNull() || value2.isNull()) {
            return NumberValue.getNullValue();
        }
        Date date = this.getDateFromValue(value);
        Date date2 = this.getDateFromValue(value2);
        GregorianCalendar gregorianCalendar = new GregorianCalendar(TimeZone.getTimeZone((String)"GMT"));
        gregorianCalendar.setTime(date2);
        return new NumberValue(gregorianCalendar.fieldDifference(date, 5));
    }

    private Date getDateFromValue(Value value) {
        Calendar calendar = value.getType() == ValueType.DATE ? ((DateValue)value).getObjectToFormat() : ((DateTimeValue)value).getObjectToFormat();
        return calendar.getTime();
    }

    @Override
    public ValueType getReturnType(List<ValueType> list) {
        return ValueType.NUMBER;
    }

    @Override
    public void validateParameters(List<ValueType> list) throws InvalidQueryException {
        if (list.size() != 2) {
            throw new InvalidQueryException("Number of parameters for the dateDiff function is wrong: " + list.size());
        }
        if (!this.isDateOrDateTimeValue(list.get(0)) || !this.isDateOrDateTimeValue(list.get(1))) {
            throw new InvalidQueryException("Can't perform the function 'dateDiff' on values that are not a Date or a DateTime values");
        }
    }

    private boolean isDateOrDateTimeValue(ValueType valueType) {
        return valueType == ValueType.DATE || valueType == ValueType.DATETIME;
    }

    @Override
    public String toQueryString(List<String> list) {
        return "dateDiff(" + list.get(0) + ", " + list.get(1) + ")";
    }
}

