/*
 * Decompiled with CFR 0.152.
 */
package com.google.visualization.datasource.query.scalarfunction;

import com.google.visualization.datasource.base.InvalidQueryException;
import com.google.visualization.datasource.datatable.value.DateTimeValue;
import com.google.visualization.datasource.datatable.value.DateValue;
import com.google.visualization.datasource.datatable.value.NumberValue;
import com.google.visualization.datasource.datatable.value.Value;
import com.google.visualization.datasource.datatable.value.ValueType;
import com.google.visualization.datasource.query.scalarfunction.ScalarFunction;
import com.ibm.icu.util.GregorianCalendar;
import com.ibm.icu.util.TimeZone;
import java.util.Date;
import java.util.List;

public class ToDate
implements ScalarFunction {
    private static final String FUNCTION_NAME = "toDate";
    private static final ToDate INSTANCE = new ToDate();

    private ToDate() {
    }

    public static ToDate getInstance() {
        return INSTANCE;
    }

    @Override
    public String getFunctionName() {
        return FUNCTION_NAME;
    }

    @Override
    public Value evaluate(List<Value> list) {
        DateValue dateValue;
        Value value = list.get(0);
        GregorianCalendar gregorianCalendar = new GregorianCalendar(TimeZone.getTimeZone((String)"GMT"));
        if (value.isNull()) {
            return DateValue.getNullValue();
        }
        switch (value.getType()) {
            case DATE: {
                dateValue = (DateValue)value;
                break;
            }
            case DATETIME: {
                dateValue = new DateValue((GregorianCalendar)((DateTimeValue)value).getObjectToFormat());
                break;
            }
            case NUMBER: {
                Date date = new Date((long)((NumberValue)value).getValue());
                gregorianCalendar.setTime(date);
                dateValue = new DateValue(gregorianCalendar);
                break;
            }
            default: {
                throw new RuntimeException("Value type was not found: " + (Object)((Object)value.getType()));
            }
        }
        return dateValue;
    }

    @Override
    public ValueType getReturnType(List<ValueType> list) {
        return ValueType.DATE;
    }

    @Override
    public void validateParameters(List<ValueType> list) throws InvalidQueryException {
        if (list.size() != 1) {
            throw new InvalidQueryException("Number of parameters for the date function is wrong: " + list.size());
        }
        if (list.get(0) != ValueType.DATETIME && list.get(0) != ValueType.DATE && list.get(0) != ValueType.NUMBER) {
            throw new InvalidQueryException("Can't perform the function 'date' on values that are not date, dateTime or number values");
        }
    }

    @Override
    public String toQueryString(List<String> list) {
        return "toDate(" + list.get(0) + ")";
    }
}

