/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.genericdao.dao;

import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DAOUtil {
    public static <T> List<Class<?>> getTypeArguments(Class<T> baseClass, Class<? extends T> childClass) {
        HashMap resolvedTypes = new HashMap();
        Type type = childClass;
        while (!DAOUtil.getClass(type).equals(baseClass)) {
            if (type instanceof Class) {
                type = type.getGenericSuperclass();
                continue;
            }
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Class rawType = (Class)parameterizedType.getRawType();
            Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
            TypeVariable<Class<T>>[] typeParameters = rawType.getTypeParameters();
            for (int i = 0; i < actualTypeArguments.length; ++i) {
                resolvedTypes.put(typeParameters[i], actualTypeArguments[i]);
            }
            if (rawType.equals(baseClass)) continue;
            type = rawType.getGenericSuperclass();
        }
        Type[] actualTypeArguments = type instanceof Class ? type.getTypeParameters() : ((ParameterizedType)type).getActualTypeArguments();
        ArrayList typeArgumentsAsClasses = new ArrayList();
        for (Type baseType : actualTypeArguments) {
            while (resolvedTypes.containsKey(baseType)) {
                baseType = (Type)resolvedTypes.get(baseType);
            }
            typeArgumentsAsClasses.add(DAOUtil.getClass(baseType));
        }
        return typeArgumentsAsClasses;
    }

    private static Class<?> getClass(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return DAOUtil.getClass(((ParameterizedType)type).getRawType());
        }
        if (type instanceof GenericArrayType) {
            Type componentType = ((GenericArrayType)type).getGenericComponentType();
            Class<?> componentClass = DAOUtil.getClass(componentType);
            if (componentClass != null) {
                return Array.newInstance(componentClass, 0).getClass();
            }
            return null;
        }
        return null;
    }

    public static Object callMethod(Object object, String methodName, Object ... args) throws NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Class[] paramTypes = new Class[args.length];
        for (int i = 0; i < args.length; ++i) {
            if (args[i] == null) {
                throw new NullPointerException("No arguments may be null when using callMethod(Object, String, Object...) because every argument is needed in order to determine the parameter types. Use callMethod(Object, String, Class<?>[], Object...) instead and specify parameter types.");
            }
            paramTypes[i] = args[i].getClass();
        }
        return DAOUtil.callMethod(object, methodName, paramTypes, args);
    }

    public static Object callMethod(Object object, String methodName, Class<?>[] paramTypes, Object ... args) throws NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Method method = DAOUtil.getMethod(object.getClass(), methodName, paramTypes);
        if (method == null) {
            throw new NoSuchMethodException("Method: " + methodName + " not found on Class: " + object.getClass());
        }
        if (method.isVarArgs()) {
            int i;
            Object[] allargs = new Object[method.getParameterTypes().length];
            Object[] vargs = (Object[])Array.newInstance(method.getParameterTypes()[method.getParameterTypes().length - 1].getComponentType(), args.length - method.getParameterTypes().length + 1);
            for (i = 0; i < method.getParameterTypes().length - 1; ++i) {
                allargs[i] = args[i];
            }
            for (i = 0; i < args.length - method.getParameterTypes().length + 1; ++i) {
                vargs[i] = args[method.getParameterTypes().length - 1 + i];
            }
            allargs[method.getParameterTypes().length - 1] = vargs;
            return method.invoke(object, allargs);
        }
        return method.invoke(object, args);
    }

    public static Method getMethod(Class<?> klass, String methodName, Class<?> ... paramTypes) {
        ArrayList<Method> candidates = new ArrayList<Method>();
        block0: for (Method method : klass.getMethods()) {
            int i;
            Class<?>[] methodParamTypes;
            if (!method.getName().equals(methodName) || paramTypes.length != (methodParamTypes = method.getParameterTypes()).length && (!method.isVarArgs() || paramTypes.length < methodParamTypes.length - 1)) continue;
            if (method.isVarArgs()) {
                for (i = 0; i < methodParamTypes.length - 1; ++i) {
                    if (paramTypes[i] != null && !methodParamTypes[i].isAssignableFrom(paramTypes[i])) continue block0;
                }
                if (!(methodParamTypes.length == paramTypes.length + 1 || methodParamTypes.length == paramTypes.length && methodParamTypes[paramTypes.length - 1].isAssignableFrom(paramTypes[paramTypes.length - 1]))) {
                    Class<?> varClass = methodParamTypes[methodParamTypes.length - 1].getComponentType();
                    for (int i2 = methodParamTypes.length - 1; i2 < paramTypes.length; ++i2) {
                        if (paramTypes[i2] != null && !varClass.isAssignableFrom(paramTypes[i2])) continue block0;
                    }
                }
            } else {
                for (i = 0; i < methodParamTypes.length; ++i) {
                    if (paramTypes[i] != null && !methodParamTypes[i].isAssignableFrom(paramTypes[i])) continue block0;
                }
            }
            candidates.add(method);
        }
        if (candidates.size() == 0) {
            return null;
        }
        if (candidates.size() == 1) {
            return (Method)candidates.get(0);
        }
        Iterator itr = candidates.iterator();
        while (itr.hasNext()) {
            Method m = (Method)itr.next();
            if (!m.isVarArgs() || m.getParameterTypes().length == paramTypes.length && m.getParameterTypes()[paramTypes.length - 1].isAssignableFrom(paramTypes[paramTypes.length - 1])) continue;
            itr.remove();
        }
        if (candidates.size() == 0) {
            return null;
        }
        Method a = (Method)candidates.get(0);
        boolean ambiguous = false;
        for (int j = 1; j < candidates.size(); ++j) {
            Method b = (Method)candidates.get(j);
            Class<?>[] aTypes = a.getParameterTypes();
            Class<?>[] bTypes = b.getParameterTypes();
            int aScore = 0;
            int bScore = 0;
            for (int i = 0; i < aTypes.length; ++i) {
                int distB;
                if (aTypes[i] == null) continue;
                int distA = DAOUtil.getDist(aTypes[i], paramTypes[i]);
                if (distA > (distB = DAOUtil.getDist(bTypes[i], paramTypes[i]))) {
                    ++bScore;
                    continue;
                }
                if (distA < distB) {
                    ++aScore;
                    continue;
                }
                if (distA != 1000 || aTypes[i].equals(bTypes[i])) continue;
                if (aTypes[i].isAssignableFrom(bTypes[i])) {
                    ++bScore;
                    continue;
                }
                if (!bTypes[i].isAssignableFrom(aTypes[i])) continue;
                ++aScore;
            }
            if (aScore == bScore) {
                ambiguous = true;
                continue;
            }
            if (bScore <= aScore) continue;
            a = b;
            ambiguous = false;
        }
        if (ambiguous) {
            return null;
        }
        return a;
    }

    private static int getDist(Class<?> superClass, Class<?> klass) {
        if (klass.isArray()) {
            if (superClass.isArray()) {
                superClass = superClass.getComponentType();
                klass = klass.getComponentType();
            } else {
                return 3000;
            }
        }
        if (superClass.equals(klass)) {
            return 0;
        }
        if (superClass.equals(Object.class)) {
            return 2000;
        }
        if (superClass.isInterface()) {
            return 1000;
        }
        int dist = 0;
        do {
            ++dist;
        } while (!superClass.equals(klass = klass.getSuperclass()));
        return dist;
    }
}

