/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.genericdao.search;

import com.googlecode.genericdao.search.ExampleOptions;
import com.googlecode.genericdao.search.Field;
import com.googlecode.genericdao.search.Filter;
import com.googlecode.genericdao.search.ISearch;
import com.googlecode.genericdao.search.InternalUtil;
import com.googlecode.genericdao.search.Metadata;
import com.googlecode.genericdao.search.MetadataUtil;
import com.googlecode.genericdao.search.SearchUtil;
import com.googlecode.genericdao.search.Sort;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseSearchProcessor {
    private static Logger logger = LoggerFactory.getLogger(BaseSearchProcessor.class);
    protected static int QLTYPE_HQL = 0;
    protected static int QLTYPE_EQL = 1;
    protected int qlType;
    protected MetadataUtil metadataUtil;
    protected String rootAlias = "_it";
    protected static final String ROOT_PATH = "";
    protected Pattern INJECTION_CHECK = Pattern.compile("^[\\w\\.]*$");
    private static final ExampleOptions defaultExampleOptions = new ExampleOptions();

    protected BaseSearchProcessor(int qlType, MetadataUtil metadataUtil) {
        if (metadataUtil == null) {
            throw new IllegalArgumentException("A SearchProcessor cannot be initialized with a null MetadataUtil.");
        }
        this.qlType = qlType;
        this.metadataUtil = metadataUtil;
    }

    public MetadataUtil getMetadataUtil() {
        return this.metadataUtil;
    }

    public void setRootAlias(String alias) {
        this.rootAlias = alias;
    }

    public String generateQL(Class<?> entityClass, ISearch search, List<Object> paramList) {
        if (entityClass == null) {
            throw new NullPointerException("The entity class for a search cannot be null");
        }
        SearchContext ctx = new SearchContext(entityClass, this.rootAlias, paramList);
        List<Field> fields = this.checkAndCleanFields(search.getFields());
        String select = this.generateSelectClause(ctx, fields, search.isDistinct());
        String where = this.generateWhereClause(ctx, this.checkAndCleanFilters(search.getFilters()), search.isDisjunction());
        String orderBy = this.generateOrderByClause(ctx, this.checkAndCleanSorts(search.getSorts()));
        this.applyFetches(ctx, this.checkAndCleanFetches(search.getFetches()), fields);
        String from = this.generateFromClause(ctx, true);
        StringBuilder sb = new StringBuilder();
        sb.append(select);
        sb.append(from);
        sb.append(where);
        sb.append(orderBy);
        String query = sb.toString();
        if (logger.isDebugEnabled()) {
            logger.debug("generateQL:\n  " + query);
        }
        return query;
    }

    public String generateRowCountQL(Class<?> entityClass, ISearch search, List<Object> paramList) {
        if (entityClass == null) {
            throw new NullPointerException("The entity class for a search cannot be null");
        }
        SearchContext ctx = new SearchContext(entityClass, this.rootAlias, paramList);
        String where = this.generateWhereClause(ctx, this.checkAndCleanFilters(search.getFilters()), search.isDisjunction());
        String from = this.generateFromClause(ctx, false);
        boolean useOperator = false;
        boolean notUseOperator = false;
        List<Field> fields = search.getFields();
        if (fields != null) {
            block3: for (Field field : fields) {
                switch (field.getOperator()) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        useOperator = true;
                        continue block3;
                    }
                }
                notUseOperator = true;
            }
        }
        if (useOperator && notUseOperator) {
            throw new Error("A search can not have a mix of fields with operators and fields without operators.");
        }
        if (useOperator) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        if (!search.isDistinct()) {
            sb.append("select count(").append(this.rootAlias).append(")");
        } else if (fields.size() == 0) {
            sb.append("select count(distinct ");
            sb.append(this.rootAlias).append(")");
        } else if (fields.size() == 1) {
            sb.append("select count(distinct ");
            String prop = fields.get(0).getProperty();
            if (prop == null || ROOT_PATH.equals(prop)) {
                sb.append(ctx.getRootAlias());
            } else {
                sb.append(this.getPathRef(ctx, prop));
            }
            sb.append(")");
        } else {
            throw new IllegalArgumentException("Unfortunately, Hibernate Generic DAO does not currently support the count operation on a search that has distinct set with multiple fields.");
        }
        sb.append(from);
        sb.append(where);
        String query = sb.toString();
        if (logger.isDebugEnabled()) {
            logger.debug("generateRowCountQL:\n  " + query);
        }
        return query;
    }

    protected String generateSelectClause(SearchContext ctx, List<Field> fields, boolean distinct) {
        StringBuilder sb = null;
        boolean useOperator = false;
        boolean notUseOperator = false;
        boolean first = true;
        if (fields != null) {
            for (Field field : fields) {
                if (first) {
                    sb = new StringBuilder("select ");
                    if (distinct) {
                        sb.append("distinct ");
                    }
                    first = false;
                } else {
                    sb.append(", ");
                }
                if (field.getOperator() == 999) {
                    if (field.getProperty() == null) {
                        sb.append("null");
                        continue;
                    }
                    this.appendCustomExpression(sb, ctx, field.getProperty());
                    continue;
                }
                String prop = field.getProperty() == null || ROOT_PATH.equals(field.getProperty()) ? ctx.getRootAlias() : this.getPathRef(ctx, field.getProperty());
                switch (field.getOperator()) {
                    case 6: {
                        sb.append("avg(");
                        useOperator = true;
                        break;
                    }
                    case 1: {
                        sb.append("count(");
                        useOperator = true;
                        break;
                    }
                    case 2: {
                        sb.append("count(distinct ");
                        useOperator = true;
                        break;
                    }
                    case 3: {
                        sb.append("max(");
                        useOperator = true;
                        break;
                    }
                    case 4: {
                        sb.append("min(");
                        useOperator = true;
                        break;
                    }
                    case 5: {
                        sb.append("sum(");
                        useOperator = true;
                        break;
                    }
                    default: {
                        notUseOperator = true;
                    }
                }
                sb.append(prop);
                if (!useOperator) continue;
                sb.append(")");
            }
        }
        if (first) {
            if (distinct) {
                return "select distinct " + ctx.getRootAlias();
            }
            return "select " + ctx.getRootAlias();
        }
        if (useOperator && notUseOperator) {
            throw new Error("A search can not have a mix of fields with operators and fields without operators.");
        }
        return sb.toString();
    }

    protected void applyFetches(SearchContext ctx, List<String> fetches, List<Field> fields) {
        if (fetches != null) {
            boolean hasFetches = false;
            boolean hasFields = false;
            for (String fetch : fetches) {
                this.getAlias(ctx, fetch, true);
                hasFetches = true;
            }
            if (hasFetches && fields != null) {
                ArrayList<String> fieldProps = new ArrayList<String>();
                for (Field field : fields) {
                    if (field.getOperator() == 0) {
                        fieldProps.add(field.getProperty() + ".");
                    }
                    hasFields = true;
                }
                if (hasFields) {
                    for (AliasNode node : ctx.aliases.values()) {
                        if (!node.fetch) continue;
                        boolean hasAncestor = false;
                        for (String field : fieldProps) {
                            if (!node.getFullPath().startsWith(field)) continue;
                            hasAncestor = true;
                            break;
                        }
                        if (hasAncestor) continue;
                        node.fetch = false;
                    }
                }
            }
        }
    }

    protected String generateFromClause(SearchContext ctx, boolean doEagerFetching) {
        StringBuilder sb = new StringBuilder(" from ");
        sb.append(this.getMetadataUtil().get(ctx.rootClass).getEntityName());
        sb.append(" ");
        sb.append(ctx.getRootAlias());
        sb.append(this.generateJoins(ctx, doEagerFetching));
        return sb.toString();
    }

    protected String generateJoins(SearchContext ctx, boolean doEagerFetching) {
        StringBuilder sb = new StringBuilder();
        LinkedList<AliasNode> queue = new LinkedList<AliasNode>();
        queue.offer(ctx.aliases.get(ROOT_PATH));
        while (!queue.isEmpty()) {
            AliasNode node = (AliasNode)queue.poll();
            if (node.parent != null) {
                sb.append(" left join ");
                if (doEagerFetching && node.fetch) {
                    sb.append("fetch ");
                }
                sb.append(node.parent.alias);
                sb.append(".");
                sb.append(node.property);
                sb.append(" as ");
                sb.append(node.alias);
            }
            for (AliasNode child : node.children) {
                queue.offer(child);
            }
        }
        return sb.toString();
    }

    protected String generateOrderByClause(SearchContext ctx, List<Sort> sorts) {
        if (sorts == null) {
            return ROOT_PATH;
        }
        StringBuilder sb = null;
        boolean first = true;
        for (Sort sort : sorts) {
            if (first) {
                sb = new StringBuilder(" order by ");
                first = false;
            } else {
                sb.append(", ");
            }
            if (sort.isCustomExpression()) {
                this.appendCustomExpression(sb, ctx, sort.getProperty());
            } else if (sort.isIgnoreCase() && this.metadataUtil.get(ctx.rootClass, sort.getProperty()).isString()) {
                sb.append("lower(");
                sb.append(this.getPathRef(ctx, sort.getProperty()));
                sb.append(")");
            } else {
                sb.append(this.getPathRef(ctx, sort.getProperty()));
            }
            sb.append(sort.isDesc() ? " desc" : " asc");
        }
        if (first) {
            return ROOT_PATH;
        }
        return sb.toString();
    }

    protected String generateWhereClause(SearchContext ctx, List<Filter> filters, boolean isDisjunction) {
        String content = null;
        if (filters == null || filters.size() == 0) {
            return ROOT_PATH;
        }
        if (filters.size() == 1) {
            content = this.filterToQL(ctx, filters.get(0));
        } else {
            Filter junction = new Filter(null, filters, isDisjunction ? 101 : 100);
            content = this.filterToQL(ctx, junction);
        }
        return content == null ? ROOT_PATH : " where " + content;
    }

    protected String filterToQL(SearchContext ctx, Filter filter) {
        String property = filter.getProperty();
        Object value = filter.getValue();
        int operator = filter.getOperator();
        if (operator == 8 || operator == 9) {
            if (value instanceof Collection && ((Collection)value).size() == 0) {
                return operator == 8 ? "1 = 2" : "1 = 1";
            }
            if (value instanceof Object[] && ((Object[])value).length == 0) {
                return operator == 8 ? "1 = 2" : "1 = 1";
            }
        }
        if (filter.isTakesListOfValues()) {
            value = this.prepareValue(ctx.rootClass, property, value, true);
        } else if (filter.isTakesSingleValue()) {
            value = this.prepareValue(ctx.rootClass, property, value, false);
        }
        switch (operator) {
            case 10: {
                return this.getPathRef(ctx, property) + " is null";
            }
            case 11: {
                return this.getPathRef(ctx, property) + " is not null";
            }
            case 8: {
                return this.getPathRef(ctx, property) + " in (" + this.param(ctx, value) + ")";
            }
            case 9: {
                return this.getPathRef(ctx, property) + " not in (" + this.param(ctx, value) + ")";
            }
            case 0: {
                return this.getPathRef(ctx, property) + " = " + this.param(ctx, value);
            }
            case 1: {
                return this.getPathRef(ctx, property) + " != " + this.param(ctx, value);
            }
            case 3: {
                return this.getPathRef(ctx, property) + " > " + this.param(ctx, value);
            }
            case 2: {
                return this.getPathRef(ctx, property) + " < " + this.param(ctx, value);
            }
            case 5: {
                return this.getPathRef(ctx, property) + " >= " + this.param(ctx, value);
            }
            case 4: {
                return this.getPathRef(ctx, property) + " <= " + this.param(ctx, value);
            }
            case 6: {
                return this.getPathRef(ctx, property) + " like " + this.param(ctx, value.toString());
            }
            case 7: {
                return "lower(" + this.getPathRef(ctx, property) + ") like lower(" + this.param(ctx, value.toString()) + ")";
            }
            case 100: 
            case 101: {
                if (!(value instanceof List)) {
                    return null;
                }
                String op = filter.getOperator() == 100 ? " and " : " or ";
                StringBuilder sb = new StringBuilder("(");
                boolean first = true;
                for (Object o : (List)value) {
                    String filterStr;
                    if (!(o instanceof Filter) || (filterStr = this.filterToQL(ctx, (Filter)o)) == null) continue;
                    if (first) {
                        first = false;
                    } else {
                        sb.append(op);
                    }
                    sb.append(filterStr);
                }
                if (first) {
                    return null;
                }
                sb.append(")");
                return sb.toString();
            }
            case 102: {
                if (!(value instanceof Filter)) {
                    return null;
                }
                String filterStr = this.filterToQL(ctx, (Filter)value);
                if (filterStr == null) {
                    return null;
                }
                return "not " + filterStr;
            }
            case 12: {
                Metadata metadata = this.metadataUtil.get(ctx.rootClass, property);
                if (metadata.isCollection()) {
                    return "not exists elements(" + this.getPathRef(ctx, property) + ")";
                }
                if (metadata.isString()) {
                    String pathRef = this.getPathRef(ctx, property);
                    return "(" + pathRef + " is null or " + pathRef + " = '')";
                }
                return this.getPathRef(ctx, property) + " is null";
            }
            case 13: {
                Metadata metadata = this.metadataUtil.get(ctx.rootClass, property);
                if (metadata.isCollection()) {
                    return "exists elements(" + this.getPathRef(ctx, property) + ")";
                }
                if (metadata.isString()) {
                    String pathRef = this.getPathRef(ctx, property);
                    return "(" + pathRef + " is not null and " + pathRef + " != '')";
                }
                return this.getPathRef(ctx, property) + " is not null";
            }
            case 200: {
                if (!(value instanceof Filter)) {
                    return null;
                }
                if (value instanceof Filter) {
                    String simple = this.generateSimpleAllOrSome(ctx, property, (Filter)value, "some");
                    if (simple != null) {
                        return simple;
                    }
                    return "exists " + this.generateSubquery(ctx, property, (Filter)value);
                }
            }
            case 201: {
                if (!(value instanceof Filter)) {
                    return null;
                }
                if (value instanceof Filter) {
                    String simple = this.generateSimpleAllOrSome(ctx, property, (Filter)value, "all");
                    if (simple != null) {
                        return simple;
                    }
                    return "not exists " + this.generateSubquery(ctx, property, this.negate((Filter)value));
                }
            }
            case 202: {
                if (!(value instanceof Filter)) {
                    return null;
                }
                if (value instanceof Filter) {
                    String simple = this.generateSimpleAllOrSome(ctx, property, (Filter)value, "all");
                    if (simple != null) {
                        return "not ( " + simple + " )";
                    }
                    return "not exists " + this.generateSubquery(ctx, property, (Filter)value);
                }
            }
            case 999: {
                List<Object> values = filter.getValuesAsList();
                if (values == null) {
                    values = Collections.singletonList(null);
                }
                StringBuilder sbCustom = new StringBuilder();
                this.appendCustomExpression(sbCustom, ctx, filter.getProperty(), values);
                return sbCustom.toString();
            }
        }
        throw new IllegalArgumentException("Filter comparison ( " + operator + " ) is invalid.");
    }

    protected String generateSubquery(SearchContext ctx, String property, Filter filter) {
        SearchContext ctx2 = new SearchContext();
        ctx2.rootClass = this.metadataUtil.get(ctx.rootClass, property).getJavaClass();
        ctx2.setRootAlias(this.rootAlias + ctx.nextSubqueryNum++);
        ctx2.paramList = ctx.paramList;
        ctx2.nextAliasNum = ctx.nextAliasNum;
        ctx2.nextSubqueryNum = ctx.nextSubqueryNum;
        ArrayList<Filter> filters = new ArrayList<Filter>(1);
        filters.add(filter);
        String where = this.generateWhereClause(ctx2, filters, false);
        String joins = this.generateJoins(ctx2, false);
        ctx.nextAliasNum = ctx2.nextAliasNum;
        ctx.nextSubqueryNum = ctx2.nextSubqueryNum;
        StringBuilder sb = new StringBuilder();
        sb.append("(from ");
        sb.append(this.getPathRef(ctx, property));
        sb.append(" ");
        sb.append(ctx2.getRootAlias());
        sb.append(joins);
        sb.append(where);
        sb.append(")");
        return sb.toString();
    }

    protected String generateSimpleAllOrSome(SearchContext ctx, String property, Filter filter, String operation) {
        String op;
        if (filter.getProperty() != null && !filter.getProperty().equals(ROOT_PATH)) {
            return null;
        }
        switch (filter.getOperator()) {
            case 0: {
                op = " = ";
                break;
            }
            case 1: {
                op = " != ";
                break;
            }
            case 2: {
                op = " > ";
                break;
            }
            case 4: {
                op = " >= ";
                break;
            }
            case 3: {
                op = " < ";
                break;
            }
            case 5: {
                op = " <= ";
                break;
            }
            default: {
                return null;
            }
        }
        Object value = InternalUtil.convertIfNeeded(filter.getValue(), this.metadataUtil.get(ctx.rootClass, property).getJavaClass());
        return this.param(ctx, value) + op + operation + " elements(" + this.getPathRef(ctx, property) + ")";
    }

    protected Object prepareValue(Class<?> rootClass, String property, Object value, boolean isCollection) {
        if (value == null) {
            return null;
        }
        Class expectedClass = property != null && ("class".equals(property) || property.endsWith(".class")) ? Class.class : (property != null && ("size".equals(property) || property.endsWith(".size")) ? Integer.class : this.metadataUtil.get(rootClass, property).getJavaClass());
        if (isCollection) {
            Object[] val2;
            if (value instanceof Collection) {
                val2 = new Object[((Collection)value).size()];
                int i = 0;
                for (Object item : (Collection)value) {
                    val2[i++] = InternalUtil.convertIfNeeded(item, expectedClass);
                }
            } else {
                val2 = new Object[((Object[])value).length];
                int i = 0;
                for (Object item : (Object[])value) {
                    val2[i++] = InternalUtil.convertIfNeeded(item, expectedClass);
                }
            }
            return val2;
        }
        return InternalUtil.convertIfNeeded(value, expectedClass);
    }

    protected Filter negate(Filter filter) {
        return Filter.not(this.addExplicitNullChecks(filter));
    }

    protected Filter addExplicitNullChecks(Filter filter) {
        return SearchUtil.walkFilter(filter, new SearchUtil.FilterVisitor(){

            public Filter visitAfter(Filter filter) {
                if (filter.isTakesSingleValue() || filter.isTakesListOfValues()) {
                    return Filter.and(filter, Filter.isNotNull(filter.getProperty()));
                }
                return filter;
            }
        }, false);
    }

    protected void appendCustomExpression(StringBuilder sb, SearchContext ctx, String expression) {
        Matcher matcher = Pattern.compile("\\{[\\w\\.]*\\}").matcher(expression);
        int lastEnd = 0;
        while (matcher.find()) {
            sb.append(expression.substring(lastEnd, matcher.start()));
            sb.append(this.getPathRef(ctx, expression.substring(matcher.start() + 1, matcher.end() - 1)));
            lastEnd = matcher.end();
        }
        sb.append(expression.substring(lastEnd));
    }

    protected void appendCustomExpression(StringBuilder sb, SearchContext ctx, String expression, List<?> values) {
        Matcher matcher = Pattern.compile("(\\{[\\w\\.]*\\})|(\\?\\d+\\b)").matcher(expression);
        int lastEnd = 0;
        while (matcher.find()) {
            sb.append(expression.substring(lastEnd, matcher.start()));
            if (expression.charAt(matcher.start()) == '{') {
                sb.append(this.getPathRef(ctx, expression.substring(matcher.start() + 1, matcher.end() - 1)));
            } else {
                int valueIndex = Integer.valueOf(expression.substring(matcher.start() + 1, matcher.end()));
                if (valueIndex == 0) {
                    throw new IllegalArgumentException("This custom filter expression (" + expression + ") contains a value placeholder for zero (?0), but placeholders should be numbered starting at ?1.");
                }
                if (values == null || values.isEmpty()) {
                    throw new IllegalArgumentException("This custom filter expression (" + expression + ") calls for a value placeholder number " + valueIndex + ", but no values were specified.");
                }
                if (valueIndex > values.size()) {
                    throw new IllegalArgumentException("This custom filter expression (" + expression + ") calls for a value placeholder number " + valueIndex + ", but only " + values.size() + " values were specified.");
                }
                sb.append(this.param(ctx, values.get(valueIndex - 1)));
            }
            lastEnd = matcher.end();
        }
        sb.append(expression.substring(lastEnd));
    }

    protected String param(SearchContext ctx, Object value) {
        if (value instanceof Class) {
            return ((Class)value).getName();
        }
        if (value instanceof Collection) {
            StringBuilder sb = new StringBuilder();
            boolean first = true;
            for (Object o : (Collection)value) {
                if (first) {
                    first = false;
                } else {
                    sb.append(",");
                }
                ctx.paramList.add(o);
                sb.append(":p");
                sb.append(Integer.toString(ctx.paramList.size()));
            }
            return sb.toString();
        }
        if (value instanceof Object[]) {
            StringBuilder sb = new StringBuilder();
            boolean first = true;
            for (Object o : (Object[])value) {
                if (first) {
                    first = false;
                } else {
                    sb.append(",");
                }
                ctx.paramList.add(o);
                sb.append(":p");
                sb.append(Integer.toString(ctx.paramList.size()));
            }
            return sb.toString();
        }
        ctx.paramList.add(value);
        return ":p" + Integer.toString(ctx.paramList.size());
    }

    protected String getPathRef(SearchContext ctx, String path) {
        if (path == null || ROOT_PATH.equals(path)) {
            return ctx.getRootAlias();
        }
        String[] parts = this.splitPath(ctx, path);
        return this.getAlias((SearchContext)ctx, (String)parts[0], (boolean)false).alias + "." + parts[1];
    }

    protected String[] splitPath(SearchContext ctx, String path) {
        if (path == null || ROOT_PATH.equals(path)) {
            return null;
        }
        int pos = path.lastIndexOf(46);
        if (pos == -1) {
            return new String[]{ROOT_PATH, path};
        }
        String lastSegment = path.substring(pos + 1);
        String currentPath = path;
        boolean first = true;
        while (true) {
            if (this.metadataUtil.isId(ctx.rootClass, currentPath)) {
                if (pos == -1) {
                    return new String[]{ROOT_PATH, path};
                }
                pos = currentPath.lastIndexOf(46, pos - 1);
            } else if (!first && this.metadataUtil.get(ctx.rootClass, currentPath).isEntity()) {
                return new String[]{currentPath, path.substring(currentPath.length() + 1)};
            }
            first = false;
            if (pos != -1 && lastSegment.equals("size") && this.metadataUtil.get(ctx.rootClass, currentPath.substring(0, pos)).isCollection()) {
                first = true;
            }
            if (pos == -1) {
                return new String[]{ROOT_PATH, path};
            }
            if ((pos = (currentPath = currentPath.substring(0, pos)).lastIndexOf(46)) == -1) {
                lastSegment = currentPath;
                continue;
            }
            lastSegment = currentPath.substring(pos + 1);
        }
    }

    protected AliasNode getAlias(SearchContext ctx, String path, boolean setFetch) {
        if (path == null || path.equals(ROOT_PATH)) {
            return ctx.aliases.get(ROOT_PATH);
        }
        if (ctx.aliases.containsKey(path)) {
            AliasNode node = ctx.aliases.get(path);
            if (setFetch) {
                while (node.parent != null) {
                    node.fetch = true;
                    node = node.parent;
                }
            }
            return node;
        }
        String[] parts = this.splitPath(ctx, path);
        int pos = parts[1].lastIndexOf(46);
        String alias = "a" + ctx.nextAliasNum++ + "_" + (pos == -1 ? parts[1] : parts[1].substring(pos + 1));
        AliasNode node = new AliasNode(parts[1], alias);
        this.getAlias(ctx, parts[0], setFetch).addChild(node);
        node.fetch = setFetch;
        ctx.aliases.put(path, node);
        return node;
    }

    protected List<Field> checkAndCleanFields(List<Field> fields) {
        if (fields == null) {
            return null;
        }
        for (Field field : fields) {
            if (field == null) {
                throw new IllegalArgumentException("The search contains a null field.");
            }
            if (field.getProperty() == null || field.getOperator() == 999) continue;
            this.securityCheckProperty(field.getProperty());
        }
        return fields;
    }

    protected List<String> checkAndCleanFetches(List<String> fetches) {
        return SearchUtil.walkList(fetches, new SearchUtil.ItemVisitor<String>(){

            @Override
            public String visit(String fetch) {
                BaseSearchProcessor.this.securityCheckProperty(fetch);
                return fetch;
            }
        }, true);
    }

    protected List<Sort> checkAndCleanSorts(List<Sort> sorts) {
        return SearchUtil.walkList(sorts, new SearchUtil.ItemVisitor<Sort>(){

            @Override
            public Sort visit(Sort sort) {
                if (!sort.isCustomExpression()) {
                    BaseSearchProcessor.this.securityCheckProperty(sort.getProperty());
                }
                return sort;
            }
        }, true);
    }

    protected List<Filter> checkAndCleanFilters(List<Filter> filters) {
        return SearchUtil.walkFilters(filters, new SearchUtil.FilterVisitor(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public Filter visitBefore(Filter filter) {
                if (filter == null) {
                    return null;
                }
                if (filter.getValue() == null && !filter.isTakesNoValue()) {
                    return null;
                }
                if (filter.getValue() == null) return filter;
                if (filter.isTakesListOfSubFilters()) {
                    if (!(filter.getValue() instanceof List)) throw new IllegalArgumentException("The search has a filter (" + filter + ") for which the value should be a List of Filters but is not a list. The actual type is " + filter.getValue().getClass());
                    for (Object o : (List)filter.getValue()) {
                        if (o instanceof Filter) continue;
                        throw new IllegalArgumentException("The search has a filter (" + filter + ") for which the value should be a List of Filters but there is an element in the list that is of type: " + o.getClass());
                    }
                    return filter;
                } else {
                    if (!filter.isTakesSingleSubFilter() || filter.getValue() instanceof Filter) return filter;
                    throw new IllegalArgumentException("The search has a filter (" + filter + ") for which the value should be of type Filter but is of type: " + filter.getValue().getClass());
                }
            }

            public Filter visitAfter(Filter filter) {
                if (filter == null) {
                    return null;
                }
                if (filter.getOperator() == 999) {
                    if (filter.getProperty() == null || filter.getProperty().isEmpty()) {
                        throw new IllegalArgumentException("This search has a custom filter with no expression specified.");
                    }
                } else if (!filter.isTakesNoProperty()) {
                    BaseSearchProcessor.this.securityCheckProperty(filter.getProperty());
                }
                if (filter.isTakesSingleSubFilter()) {
                    if (filter.getValue() == null) {
                        return null;
                    }
                } else if (filter.isTakesListOfSubFilters()) {
                    if (filter.getValue() == null) {
                        return null;
                    }
                    List list = (List)filter.getValue();
                    if (list.size() == 0) {
                        return null;
                    }
                    if (list.size() == 1) {
                        return (Filter)list.get(0);
                    }
                }
                return filter;
            }
        }, true);
    }

    protected void securityCheckProperty(String property) {
        if (property == null) {
            return;
        }
        if (!this.INJECTION_CHECK.matcher(property).matches()) {
            throw new IllegalArgumentException("A property used in a Search may only contain word characters (alphabetic, numeric and underscore \"_\") and dot \".\" seperators. This constraint was violated: " + property);
        }
    }

    public Filter getFilterFromExample(Object example) {
        return this.getFilterFromExample(example, null);
    }

    public Filter getFilterFromExample(Object example, ExampleOptions options) {
        if (example == null) {
            return null;
        }
        if (options == null) {
            options = defaultExampleOptions;
        }
        ArrayList<Filter> filters = new ArrayList<Filter>();
        LinkedList<String> path = new LinkedList<String>();
        Metadata metadata = this.metadataUtil.get(example.getClass());
        this.getFilterFromExampleRecursive(example, metadata, options, path, filters);
        if (filters.size() == 0) {
            return null;
        }
        if (filters.size() == 1) {
            return (Filter)filters.get(0);
        }
        return new Filter("AND", filters, 100);
    }

    private void getFilterFromExampleRecursive(Object example, Metadata metadata, ExampleOptions options, LinkedList<String> path, List<Filter> filters) {
        Serializable id;
        if (metadata.isEntity() && !metadata.getIdType().isEmeddable() && (id = metadata.getIdValue(example)) != null) {
            filters.add(Filter.equal(this.listToPath(path, "id"), id));
            return;
        }
        for (String property : metadata.getProperties()) {
            Metadata pMetadata;
            if (options.getExcludeProps() != null && options.getExcludeProps().size() != 0 && options.getExcludeProps().contains(this.listToPath(path, property)) || (pMetadata = metadata.getPropertyType(property)).isCollection()) continue;
            Object value = metadata.getPropertyValue(example, property);
            if (value == null) {
                if (options.isExcludeNulls()) continue;
                filters.add(Filter.isNull(this.listToPath(path, property)));
                continue;
            }
            if (options.isExcludeZeros() && value instanceof Number && ((Number)value).longValue() == 0L) continue;
            if (pMetadata.isEntity() || pMetadata.isEmeddable()) {
                path.add(property);
                this.getFilterFromExampleRecursive(value, pMetadata, options, path, filters);
                path.removeLast();
                continue;
            }
            if (pMetadata.isString() && (options.getLikeMode() != 0 || options.isIgnoreCase())) {
                String val = value.toString();
                switch (options.getLikeMode()) {
                    case 1: {
                        val = val + "%";
                        break;
                    }
                    case 2: {
                        val = "%" + val;
                        break;
                    }
                    case 3: {
                        val = "%" + val + "%";
                    }
                }
                filters.add(new Filter(this.listToPath(path, property), val, options.isIgnoreCase() ? 7 : 6));
                continue;
            }
            filters.add(Filter.equal(this.listToPath(path, property), value));
        }
    }

    private String listToPath(List<String> list, String lastProperty) {
        StringBuilder sb = new StringBuilder();
        for (String prop : list) {
            sb.append(prop).append(".");
        }
        sb.append(lastProperty);
        return sb.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static final class SearchContext {
        Class<?> rootClass;
        Map<String, AliasNode> aliases = new HashMap<String, AliasNode>();
        List<Object> paramList;
        int nextAliasNum = 1;
        int nextSubqueryNum = 1;

        public SearchContext() {
        }

        public SearchContext(Class<?> rootClass, String rootAlias, List<Object> paramList) {
            this.rootClass = rootClass;
            this.setRootAlias(rootAlias);
            this.paramList = paramList;
        }

        public void setRootAlias(String rootAlias) {
            this.aliases.put(BaseSearchProcessor.ROOT_PATH, new AliasNode(BaseSearchProcessor.ROOT_PATH, rootAlias));
        }

        public String getRootAlias() {
            return this.aliases.get((Object)BaseSearchProcessor.ROOT_PATH).alias;
        }
    }

    protected static final class AliasNode {
        String property;
        String alias;
        boolean fetch;
        AliasNode parent;
        List<AliasNode> children = new ArrayList<AliasNode>();

        AliasNode(String property, String alias) {
            this.property = property;
            this.alias = alias;
        }

        void addChild(AliasNode node) {
            this.children.add(node);
            node.parent = this;
        }

        public String getFullPath() {
            if (this.parent == null) {
                return BaseSearchProcessor.ROOT_PATH;
            }
            if (this.parent.parent == null) {
                return this.property;
            }
            return this.parent.getFullPath() + "." + this.property;
        }
    }
}

