/*
 * Copyright 2008 Google Inc.
 * 
 * Copyright (c) 2009 GWT Mosaic Georgios J. Georgopoulos.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package org.gwt.mosaic.ui.client;

import org.gwt.mosaic.ui.client.layout.HasLayoutManager;
import org.gwt.mosaic.ui.client.util.WidgetHelper;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.DisclosurePanelImages;
import com.google.gwt.user.client.ui.Image;

/**
 * 
 *  @author georgopoulos.georgios(at)gmail.com
 *
 */
public class DisclosureLayoutPanel extends CaptionLayoutPanel {

  /**
   * The default style name.
   */
  private static final String DEFAULT_STYLENAME = "mosaic-DisclosureLayoutPanel";
  
  private static final String STYLENAME_SUFFIX_OPEN = "open";
  private static final String STYLENAME_SUFFIX_CLOSED = "closed";

  private static DisclosurePanelImages createDefaultImages() {
    // if (LocaleInfo.getCurrentLocale().isRTL()) {
    // return GWT.create(DisclosurePanelImagesRTL.class);
    // }
    return GWT.create(DisclosurePanelImages.class);
  }

  private Image image = new Image();

  /**
   * Create an empty {@code DisclosurePanel} that is is initially closed.
   */
  public DisclosureLayoutPanel() {
    this(null);
  }

  /**
   * Creates a DisclosurePanel with the specified header text, an initial
   * open/close state and a bundle of images to be used in the default header
   * widget.
   * 
   * @param images a bundle that provides disclosure panel specific images
   * @param headerText the text to be displayed in the header
   * @param isOpen the initial open/close state of the content panel
   */
  public DisclosureLayoutPanel(final DisclosurePanelImages images,
      final String headerText, final boolean isOpen) {
    super("<a href=\"javascript:void(0);\">"+headerText+"</a>", true);
    setCollapsed(!isOpen);
    getHeader().add(image);

    if (isOpen) {
      images.disclosurePanelOpen().applyTo(image);
    } else {
      images.disclosurePanelClosed().applyTo(image);
    }

    getHeader().addClickHandler(new ClickHandler() {
      public void onClick(ClickEvent event) {
        setCollapsed(!isCollapsed(), images);
      }
    });

    setStyleName(DEFAULT_STYLENAME);
  }

  private void setCollapsed(boolean collapsed, DisclosurePanelImages images) {
    setCollapsed(!isCollapsed());
    if (isCollapsed()) {
      images.disclosurePanelClosed().applyTo(image);
    } else {
      images.disclosurePanelOpen().applyTo(image);
    }
    HasLayoutManager lm = WidgetHelper.getParent(DisclosureLayoutPanel.this);
    if (lm != null) {
      lm.layout();
    } else {
      layout();
    }
  }

  /**
   * Creates a DisclosurePanel that will be initially closed using the specified
   * text in the header.
   * 
   * @param headerText the text to be displayed in the header
   */
  public DisclosureLayoutPanel(String headerText) {
    this(createDefaultImages(), headerText, false);
  }

  /**
   * Creates a DisclosurePanel with the specified header text and an initial
   * open/close state.
   * 
   * @param headerText the text to be displayed in the header
   * @param isOpen the initial open/close state of the content panel
   */
  public DisclosureLayoutPanel(String headerText, boolean isOpen) {
    this(createDefaultImages(), headerText, isOpen);
  }
  
  @Override
  public void setCollapsed(boolean collapsed) {
    super.setCollapsed(collapsed);
    if (collapsed) {
      removeStyleDependentName(STYLENAME_SUFFIX_CLOSED);
      addStyleDependentName(STYLENAME_SUFFIX_OPEN);
    } else {
      removeStyleDependentName(STYLENAME_SUFFIX_OPEN);
      addStyleDependentName(STYLENAME_SUFFIX_CLOSED);
    }
  }
}
