/*
 * Decompiled with CFR 0.152.
 */
package graphql.kickstart.servlet;

import graphql.ExecutionResult;
import graphql.ExecutionResultImpl;
import graphql.GraphQLError;
import graphql.kickstart.execution.FutureExecutionResult;
import graphql.kickstart.execution.GraphQLErrorQueryResult;
import graphql.kickstart.execution.GraphQLInvoker;
import graphql.kickstart.execution.GraphQLQueryResult;
import graphql.kickstart.execution.error.GenericGraphQLError;
import graphql.kickstart.execution.input.GraphQLBatchedInvocationInput;
import graphql.kickstart.execution.input.GraphQLInvocationInput;
import graphql.kickstart.execution.input.GraphQLSingleInvocationInput;
import graphql.kickstart.servlet.AsyncTimeoutListener;
import graphql.kickstart.servlet.GraphQLConfiguration;
import graphql.kickstart.servlet.HttpRequestInvoker;
import graphql.kickstart.servlet.ListenerHandler;
import graphql.kickstart.servlet.QueryResponseWriter;
import graphql.kickstart.servlet.QueryResponseWriterFactory;
import graphql.kickstart.servlet.input.BatchInputPreProcessResult;
import graphql.kickstart.servlet.input.BatchInputPreProcessor;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.AsyncContext;
import javax.servlet.AsyncListener;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpRequestInvokerImpl
implements HttpRequestInvoker {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HttpRequestInvokerImpl.class);
    private final GraphQLConfiguration configuration;
    private final GraphQLInvoker graphQLInvoker;
    private final QueryResponseWriterFactory queryResponseWriterFactory;

    @Override
    public void execute(GraphQLInvocationInput invocationInput, HttpServletRequest request, HttpServletResponse response) {
        ListenerHandler listenerHandler = ListenerHandler.start(request, response, this.configuration.getListeners());
        if (request.isAsyncSupported()) {
            this.invokeAndHandleAsync(invocationInput, request, response, listenerHandler);
        } else {
            this.handle(this.invoke(invocationInput, request, response), request, response, listenerHandler).join();
        }
    }

    private void invokeAndHandleAsync(GraphQLInvocationInput invocationInput, HttpServletRequest request, HttpServletResponse response, ListenerHandler listenerHandler) {
        AsyncContext asyncContext = request.isAsyncStarted() ? request.getAsyncContext() : request.startAsync((ServletRequest)request, (ServletResponse)response);
        asyncContext.setTimeout(this.configuration.getAsyncTimeout());
        AtomicReference futureHolder = new AtomicReference();
        AsyncTimeoutListener timeoutListener = event -> {
            log.warn("GraphQL execution canceled because timeout of " + this.configuration.getAsyncTimeout() + " millis was reached. The following query was being executed when this happened:\n{}", (Object)String.join((CharSequence)"\n", invocationInput.getQueries()));
            FutureExecutionResult futureResult = (FutureExecutionResult)futureHolder.get();
            if (futureResult != null) {
                futureResult.cancel();
            } else {
                this.writeErrorResponse(invocationInput, request, response, listenerHandler, new CancellationException());
            }
        };
        asyncContext.addListener((AsyncListener)timeoutListener);
        asyncContext.start(() -> {
            FutureExecutionResult futureResult = this.invoke(invocationInput, request, response);
            futureHolder.set(futureResult);
            this.handle(futureResult, request, response, listenerHandler).thenAccept(it -> asyncContext.complete());
        });
    }

    private CompletableFuture<Void> handle(FutureExecutionResult futureResult, HttpServletRequest request, HttpServletResponse response, ListenerHandler listenerHandler) {
        return ((CompletableFuture)((CompletableFuture)((CompletableFuture)futureResult.thenApplyQueryResult().thenAccept(it -> this.writeResultResponse(futureResult.getInvocationInput(), (GraphQLQueryResult)it, request, response))).thenAccept(it -> listenerHandler.onSuccess())).exceptionally(t -> this.writeErrorResponse(futureResult.getInvocationInput(), request, response, listenerHandler, (Throwable)t))).thenAccept(it -> listenerHandler.onFinally());
    }

    private void writeResultResponse(GraphQLInvocationInput invocationInput, GraphQLQueryResult queryResult, HttpServletRequest request, HttpServletResponse response) {
        QueryResponseWriter queryResponseWriter = this.createWriter(invocationInput, queryResult);
        try {
            queryResponseWriter.write(request, response);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private Void writeErrorResponse(GraphQLInvocationInput invocationInput, HttpServletRequest request, HttpServletResponse response, ListenerHandler listenerHandler, Throwable t) {
        Throwable cause = this.getCause(t);
        if (!response.isCommitted()) {
            this.writeResultResponse(invocationInput, (GraphQLQueryResult)GraphQLQueryResult.create((ExecutionResult)this.toErrorResult(cause)), request, response);
            listenerHandler.onError(cause);
        } else {
            log.warn("Cannot write GraphQL response, because the HTTP response is already committed. It most likely timed out.");
        }
        return null;
    }

    private Throwable getCause(Throwable t) {
        return t instanceof CompletionException && t.getCause() != null ? t.getCause() : t;
    }

    private ExecutionResult toErrorResult(Throwable t) {
        String message;
        String string = message = t instanceof CancellationException ? "Execution canceled because timeout of " + this.configuration.getAsyncTimeout() + " millis was reached" : t.getMessage();
        if (message == null) {
            message = "Unexpected error occurred";
        }
        return new ExecutionResultImpl((GraphQLError)new GenericGraphQLError(message));
    }

    protected QueryResponseWriter createWriter(GraphQLInvocationInput invocationInput, GraphQLQueryResult queryResult) {
        return this.queryResponseWriterFactory.createWriter(invocationInput, queryResult, this.configuration);
    }

    private FutureExecutionResult invoke(GraphQLInvocationInput invocationInput, HttpServletRequest request, HttpServletResponse response) {
        if (invocationInput instanceof GraphQLSingleInvocationInput) {
            return this.graphQLInvoker.execute(invocationInput);
        }
        return this.invokeBatched((GraphQLBatchedInvocationInput)invocationInput, request, response);
    }

    private FutureExecutionResult invokeBatched(GraphQLBatchedInvocationInput batchedInvocationInput, HttpServletRequest request, HttpServletResponse response) {
        BatchInputPreProcessor preprocessor = this.configuration.getBatchInputPreProcessor();
        BatchInputPreProcessResult result = preprocessor.preProcessBatch(batchedInvocationInput, request, response);
        if (result.isExecutable()) {
            return this.graphQLInvoker.execute((GraphQLInvocationInput)result.getBatchedInvocationInput());
        }
        return FutureExecutionResult.error((GraphQLErrorQueryResult)GraphQLQueryResult.createError((int)result.getStatusCode(), (String)result.getStatusMessage()));
    }

    @Generated
    public HttpRequestInvokerImpl(GraphQLConfiguration configuration, GraphQLInvoker graphQLInvoker, QueryResponseWriterFactory queryResponseWriterFactory) {
        this.configuration = configuration;
        this.graphQLInvoker = graphQLInvoker;
        this.queryResponseWriterFactory = queryResponseWriterFactory;
    }
}

