/*
 * Decompiled with CFR 0.152.
 */
package graphql.kickstart.servlet.context;

import graphql.kickstart.execution.context.DefaultGraphQLContext;
import graphql.kickstart.servlet.context.GraphQLServletContext;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.Part;
import org.dataloader.DataLoaderRegistry;

public class DefaultGraphQLServletContext
extends DefaultGraphQLContext
implements GraphQLServletContext {
    protected DefaultGraphQLServletContext(DataLoaderRegistry dataLoaderRegistry, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        super(dataLoaderRegistry);
        this.put(HttpServletRequest.class, httpServletRequest);
        this.put(HttpServletResponse.class, httpServletResponse);
    }

    public static Builder createServletContext(DataLoaderRegistry registry) {
        return new Builder(registry);
    }

    public static Builder createServletContext() {
        return new Builder(new DataLoaderRegistry());
    }

    @Override
    @Deprecated
    public HttpServletRequest getHttpServletRequest() {
        return (HttpServletRequest)this.getMapOfContext().get(HttpServletRequest.class);
    }

    @Override
    @Deprecated
    public HttpServletResponse getHttpServletResponse() {
        return (HttpServletResponse)this.getMapOfContext().get(HttpServletResponse.class);
    }

    @Override
    @Deprecated
    public List<Part> getFileParts() {
        return this.getHttpServletRequest().getParts().stream().filter(part -> part.getContentType() != null).collect(Collectors.toList());
    }

    @Override
    @Deprecated
    public Map<String, List<Part>> getParts() {
        return this.getHttpServletRequest().getParts().stream().collect(Collectors.groupingBy(Part::getName));
    }

    public static class Builder {
        private HttpServletRequest httpServletRequest;
        private HttpServletResponse httpServletResponse;
        private DataLoaderRegistry dataLoaderRegistry;

        private Builder(DataLoaderRegistry dataLoaderRegistry) {
            this.dataLoaderRegistry = dataLoaderRegistry;
        }

        public DefaultGraphQLServletContext build() {
            return new DefaultGraphQLServletContext(this.dataLoaderRegistry, this.httpServletRequest, this.httpServletResponse);
        }

        public Builder with(HttpServletRequest httpServletRequest) {
            this.httpServletRequest = httpServletRequest;
            return this;
        }

        public Builder with(DataLoaderRegistry dataLoaderRegistry) {
            this.dataLoaderRegistry = dataLoaderRegistry;
            return this;
        }

        public Builder with(HttpServletResponse httpServletResponse) {
            this.httpServletResponse = httpServletResponse;
            return this;
        }
    }
}

