/*
 * Decompiled with CFR 0.152.
 */
package org.dataloader.impl;

import java.util.function.Supplier;
import org.dataloader.annotations.Internal;
import org.dataloader.impl.DataLoaderAssertionException;

@Internal
public class Assertions {
    public static void assertState(boolean state, Supplier<String> message) {
        if (!state) {
            throw new DataLoaderAssertionException(message.get());
        }
    }

    public static <T> T nonNull(T t) {
        return Assertions.nonNull(t, () -> "nonNull object required");
    }

    public static <T> T nonNull(T t, Supplier<String> message) {
        if (t == null) {
            throw new NullPointerException(message.get());
        }
        return t;
    }
}

