/*
 * Decompiled with CFR 0.152.
 */
package com.gwtplatform.dispatch.rpc.server.guice;

import com.google.inject.AbstractModule;
import com.google.inject.Module;
import com.google.inject.internal.UniqueAnnotations;
import com.gwtplatform.dispatch.rpc.server.actionhandler.ActionHandler;
import com.gwtplatform.dispatch.rpc.server.actionhandlervalidator.ActionHandlerValidatorClass;
import com.gwtplatform.dispatch.rpc.server.actionhandlervalidator.ActionHandlerValidatorMap;
import com.gwtplatform.dispatch.rpc.server.actionhandlervalidator.ActionHandlerValidatorMapImpl;
import com.gwtplatform.dispatch.rpc.server.actionvalidator.ActionValidator;
import com.gwtplatform.dispatch.rpc.server.guice.DispatchModule;
import com.gwtplatform.dispatch.rpc.server.guice.actionvalidator.DefaultActionValidator;
import com.gwtplatform.dispatch.rpc.shared.Action;
import com.gwtplatform.dispatch.rpc.shared.Result;

public abstract class HandlerModule
extends AbstractModule {
    private final DispatchModule dispatchModule;

    public HandlerModule() {
        this.dispatchModule = new DispatchModule();
    }

    public HandlerModule(DispatchModule dispatchModule) {
        this.dispatchModule = dispatchModule;
    }

    protected <A extends Action<R>, R extends Result> void bindHandler(Class<A> actionClass, Class<? extends ActionHandler<A, R>> handlerClass) {
        this.bind(ActionHandlerValidatorMap.class).annotatedWith(UniqueAnnotations.create()).toInstance((Object)new ActionHandlerValidatorMapImpl(actionClass, new ActionHandlerValidatorClass(handlerClass, DefaultActionValidator.class)));
    }

    protected <A extends Action<R>, R extends Result> void bindHandler(Class<A> actionClass, Class<? extends ActionHandler<A, R>> handlerClass, Class<? extends ActionValidator> actionValidator) {
        this.bind(ActionHandlerValidatorMap.class).annotatedWith(UniqueAnnotations.create()).toInstance((Object)new ActionHandlerValidatorMapImpl(actionClass, new ActionHandlerValidatorClass(handlerClass, actionValidator)));
    }

    protected final void configure() {
        this.install((Module)this.dispatchModule);
        this.configureHandlers();
    }

    protected abstract void configureHandlers();
}

