/*
 * Decompiled with CFR 0.152.
 */
package com.gwtplatform.dispatch.rpc.server.guice.actionhandlervalidator;

import com.google.inject.Injector;
import com.gwtplatform.dispatch.rpc.server.actionhandler.ActionHandler;
import com.gwtplatform.dispatch.rpc.server.actionhandlervalidator.ActionHandlerValidatorClass;
import com.gwtplatform.dispatch.rpc.server.actionhandlervalidator.ActionHandlerValidatorInstance;
import com.gwtplatform.dispatch.rpc.server.actionhandlervalidator.LazyActionHandlerValidatorRegistry;
import com.gwtplatform.dispatch.rpc.server.actionvalidator.ActionValidator;
import com.gwtplatform.dispatch.rpc.shared.Action;
import com.gwtplatform.dispatch.rpc.shared.Result;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class LazyActionHandlerValidatorRegistryImpl
implements LazyActionHandlerValidatorRegistry {
    private final ConcurrentHashMap<Class<? extends Action<?>>, ActionHandlerValidatorClass<? extends Action<?>, ? extends Result>> actionHandlerValidatorClasses;
    private final ConcurrentHashMap<Class<? extends Action<?>>, ActionHandlerValidatorInstance> actionHandlerValidatorInstances;
    private final Injector injector;
    private final ConcurrentHashMap<Class<? extends ActionValidator>, ActionValidator> validators;

    @Inject
    LazyActionHandlerValidatorRegistryImpl(Injector injector) {
        this.injector = injector;
        this.actionHandlerValidatorClasses = new ConcurrentHashMap();
        this.actionHandlerValidatorInstances = new ConcurrentHashMap();
        this.validators = new ConcurrentHashMap();
    }

    public <A extends Action<R>, R extends Result> void addActionHandlerValidatorClass(Class<A> actionClass, ActionHandlerValidatorClass<A, R> actionHandlerValidatorClass) {
        this.actionHandlerValidatorClasses.putIfAbsent(actionClass, actionHandlerValidatorClass);
    }

    public void clearActionHandlerValidators() {
        this.actionHandlerValidatorInstances.clear();
        this.validators.clear();
    }

    public <A extends Action<R>, R extends Result> ActionHandlerValidatorInstance findActionHandlerValidator(A action) {
        ActionHandlerValidatorClass<? extends Action<?>, ? extends Result> actionHandlerValidatorClass;
        ActionHandlerValidatorInstance actionHandlerValidatorInstance = this.actionHandlerValidatorInstances.get(action.getClass());
        if (actionHandlerValidatorInstance == null && (actionHandlerValidatorClass = this.actionHandlerValidatorClasses.get(action.getClass())) != null && (actionHandlerValidatorInstance = this.createInstance(actionHandlerValidatorClass)) != null) {
            this.actionHandlerValidatorInstances.putIfAbsent(action.getClass(), actionHandlerValidatorInstance);
        }
        return actionHandlerValidatorInstance;
    }

    public ActionValidator findActionValidator(Class<? extends ActionValidator> actionValidatorClass) {
        return this.validators.get(actionValidatorClass);
    }

    public <A extends Action<R>, R extends Result> void removeActionHandlerValidatorClass(Class<A> actionClass, ActionHandlerValidatorClass<A, R> actionHandlerValidatorClass) {
        ActionHandlerValidatorClass<? extends Action<?>, ? extends Result> oldActionHandlerValidatorClass = this.actionHandlerValidatorClasses.get(actionClass);
        if (oldActionHandlerValidatorClass == actionHandlerValidatorClass) {
            this.actionHandlerValidatorClasses.remove(actionClass);
            ActionHandlerValidatorInstance instance = this.actionHandlerValidatorInstances.remove(actionClass);
            if (!this.containValidator(instance.getActionValidator())) {
                this.validators.remove(instance.getActionValidator().getClass());
            }
        }
    }

    private boolean containValidator(ActionValidator actionValidator) {
        for (ActionHandlerValidatorInstance validator : this.actionHandlerValidatorInstances.values()) {
            if (!validator.getActionValidator().getClass().equals(actionValidator.getClass())) continue;
            return true;
        }
        return false;
    }

    private ActionHandlerValidatorInstance createInstance(ActionHandlerValidatorClass<? extends Action<?>, ? extends Result> actionHandlerValidatorClass) {
        ActionHandlerValidatorInstance actionHandlerValidatorInstance;
        ActionValidator actionValidator = this.findActionValidator(actionHandlerValidatorClass.getActionValidatorClass());
        if (actionValidator == null) {
            actionValidator = (ActionValidator)this.injector.getInstance(actionHandlerValidatorClass.getActionValidatorClass());
            actionHandlerValidatorInstance = new ActionHandlerValidatorInstance(actionValidator, (ActionHandler)this.injector.getInstance(actionHandlerValidatorClass.getActionHandlerClass()));
            this.validators.putIfAbsent(actionValidator.getClass(), actionValidator);
        } else {
            actionHandlerValidatorInstance = new ActionHandlerValidatorInstance(actionValidator, (ActionHandler)this.injector.getInstance(actionHandlerValidatorClass.getActionHandlerClass()));
        }
        if (actionHandlerValidatorInstance.getActionHandler() == null || actionHandlerValidatorInstance.getActionValidator() == null) {
            return null;
        }
        return actionHandlerValidatorInstance;
    }
}

