/*
 * Decompiled with CFR 0.152.
 */
package com.gwtplatform.dispatch.rpc.server.spring;

import com.gwtplatform.dispatch.rpc.server.Dispatch;
import com.gwtplatform.dispatch.rpc.server.actionhandlervalidator.ActionHandlerValidatorRegistry;
import com.gwtplatform.dispatch.rpc.server.actionhandlervalidator.LazyActionHandlerValidatorRegistry;
import com.gwtplatform.dispatch.rpc.server.spring.DispatchImpl;
import com.gwtplatform.dispatch.rpc.server.spring.HandlerModule;
import com.gwtplatform.dispatch.rpc.server.spring.actionhandlervalidator.ActionHandlerValidatorLinker;
import com.gwtplatform.dispatch.rpc.server.spring.actionhandlervalidator.LazyActionHandlerValidatorRegistryImpl;
import com.gwtplatform.dispatch.rpc.server.spring.utils.SpringUtils;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.support.PropertySourcesPlaceholderConfigurer;

public class DispatchModule {
    private final Class<? extends Dispatch> dispatchClass;
    private final Class<? extends ActionHandlerValidatorRegistry> lazyActionHandlerValidatorRegistryClass;
    @Autowired
    private ApplicationContext context;
    @Autowired
    private List<HandlerModule> handlerModules;

    public DispatchModule() {
        this(DispatchImpl.class, LazyActionHandlerValidatorRegistryImpl.class);
    }

    public DispatchModule(Class<? extends Dispatch> dispatchClass) {
        this(dispatchClass, LazyActionHandlerValidatorRegistryImpl.class);
    }

    public DispatchModule(Class<? extends Dispatch> dispatchClass, Class<? extends ActionHandlerValidatorRegistry> lazyActionHandlerValidatorRegistryClass) {
        this.dispatchClass = dispatchClass;
        this.lazyActionHandlerValidatorRegistryClass = lazyActionHandlerValidatorRegistryClass;
    }

    @Autowired
    public void setHandlerModules(List<HandlerModule> handlerModules) {
        this.handlerModules = handlerModules;
    }

    @Bean
    public ActionHandlerValidatorRegistry getActionHandlerValidatorRegistry() {
        for (HandlerModule handlerModule : this.handlerModules) {
            handlerModule.configureHandlers();
        }
        ActionHandlerValidatorRegistry instance = SpringUtils.getOrCreate(this.context, this.lazyActionHandlerValidatorRegistryClass);
        if (LazyActionHandlerValidatorRegistry.class.isAssignableFrom(this.lazyActionHandlerValidatorRegistryClass)) {
            ActionHandlerValidatorLinker.linkValidators(this.context, instance);
        }
        return instance;
    }

    @Bean
    public static PropertySourcesPlaceholderConfigurer propertySourcesPlaceholderConfigurer() {
        return new PropertySourcesPlaceholderConfigurer();
    }

    @Bean
    public Dispatch getDispatch() {
        return SpringUtils.getOrCreate(this.context, this.dispatchClass);
    }
}

