/*
 * Decompiled with CFR 0.152.
 */
package com.gwtplatform.dispatch.rpc.server.spring;

import com.gwtplatform.dispatch.rpc.server.actionhandler.ActionHandler;
import com.gwtplatform.dispatch.rpc.server.actionhandlervalidator.ActionHandlerValidatorClass;
import com.gwtplatform.dispatch.rpc.server.actionhandlervalidator.ActionHandlerValidatorMapImpl;
import com.gwtplatform.dispatch.rpc.server.actionvalidator.ActionValidator;
import com.gwtplatform.dispatch.rpc.server.spring.DispatchModule;
import com.gwtplatform.dispatch.rpc.server.spring.actionvalidator.DefaultActionValidator;
import com.gwtplatform.dispatch.rpc.server.spring.utils.SpringUtils;
import com.gwtplatform.dispatch.rpc.shared.Action;
import com.gwtplatform.dispatch.rpc.shared.Result;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Import;

@Import(value={DispatchModule.class})
public abstract class HandlerModule {
    @Autowired
    protected ApplicationContext applicationContext;

    protected <A extends Action<R>, R extends Result> void bindHandler(Class<A> actionClass, Class<? extends ActionHandler<A, R>> handlerClass) {
        SpringUtils.registerBean(this.applicationContext, new ActionHandlerValidatorMapImpl(actionClass, new ActionHandlerValidatorClass(handlerClass, DefaultActionValidator.class)));
    }

    protected <A extends Action<R>, R extends Result> void bindHandler(Class<A> actionClass, Class<? extends ActionHandler<A, R>> handlerClass, Class<? extends ActionValidator> actionValidator) {
        SpringUtils.registerBean(this.applicationContext, new ActionHandlerValidatorMapImpl(actionClass, new ActionHandlerValidatorClass(handlerClass, actionValidator)));
    }

    protected abstract void configureHandlers();
}

